/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.jni.JNIEngine;
import geotrans.jni.JNIStrtoval;

class jOptions {
    public static final int DMS = 0;
    public static final int DM = 1;
    public static final int DEG = 2;
    public static final char SPACE = ' ';
    public static final char SLASH = '/';
    public static final char COLON = ':';
    public static final int SIGN = 0;
    public static final int HEMI = 1;
    public static final int _180_180 = 0;
    public static final int _0_360 = 1;
    public static final int MET100000 = 0;
    public static final int MET10000 = 1;
    public static final int MET1000 = 2;
    public static final int MET100 = 3;
    public static final int MET10 = 4;
    public static final int MET1 = 5;
    public static final int MET_1 = 6;
    public static final int MET_01 = 7;
    public static final int MET_001 = 8;
    private int units = 0;
    private char separator = (char)32;
    private int signHemi = 1;
    private int range = 0;
    private int precision = 5;
    private boolean leadingZeros = false;
    private String unitsString = "DMS";
    private int separatorIndex = 0;
    private String signHemiString = "N/S,E/W";
    private String rangeString = "(-180,180)";
    private String precisionString = "1m";
    private JNIEngine jniEngine = new JNIEngine();
    private JNIStrtoval jniStrtoval = new JNIStrtoval();

    public jOptions() {
    }

    public jOptions(jOptions joptions) {
        this.setOptions(joptions);
    }

    public int getUnits() {
        return this.units;
    }

    public String getUnitsString() {
        return this.unitsString;
    }

    public void setUnits(int unit) {
        this.units = unit;
        switch (this.units) {
            case 0: {
                this.unitsString = "DMS";
                break;
            }
            case 1: {
                this.unitsString = "DM";
                break;
            }
            case 2: {
                this.unitsString = "D";
            }
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public int getSeparatorIndex() {
        return this.separatorIndex;
    }

    public void setSeparator(char separ) {
        this.separator = separ;
        this.jniStrtoval.JNISetSeparator(separ);
        switch (this.separator) {
            case ' ': {
                this.separatorIndex = 0;
                break;
            }
            case '/': {
                this.separatorIndex = 1;
                break;
            }
            case ':': {
                this.separatorIndex = 2;
            }
        }
    }

    public void setSeparator(int separ) {
        this.separatorIndex = separ;
        switch (this.separatorIndex) {
            case 0: {
                this.separator = (char)32;
                break;
            }
            case 1: {
                this.separator = (char)47;
                break;
            }
            case 2: {
                this.separator = (char)58;
            }
        }
        this.jniStrtoval.JNISetSeparator(this.separator);
    }

    public int getSignHemi() {
        return this.signHemi;
    }

    public String getSignHemiString() {
        return this.signHemiString;
    }

    public void setSignHemi(int signhemi) {
        this.signHemi = signhemi;
        switch (this.signHemi) {
            case 0: {
                this.signHemiString = "+/-";
                break;
            }
            case 1: {
                this.signHemiString = "N/S,E/W";
            }
        }
    }

    public int getRange() {
        return this.range;
    }

    public String getRangeString() {
        return this.rangeString;
    }

    public void setRange(int lonRange) {
        this.range = lonRange;
        this.jniStrtoval.JNISetLongRange(lonRange);
        switch (this.range) {
            case 0: {
                this.rangeString = "(-180,180)";
                break;
            }
            case 1: {
                this.rangeString = "(0,360)";
            }
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getPrecisionString() {
        return this.precisionString;
    }

    public void setPrecision(int prec) {
        this.precision = prec;
        this.jniEngine.JNISetPrecision(prec);
        this.jniStrtoval.JNISetLatLongPrecision(prec);
        switch (this.precision) {
            case 0: {
                this.precisionString = "100,000m";
                break;
            }
            case 1: {
                this.precisionString = "10,000m";
                break;
            }
            case 2: {
                this.precisionString = "1,000m";
                break;
            }
            case 3: {
                this.precisionString = "100m";
                break;
            }
            case 4: {
                this.precisionString = "10m";
                break;
            }
            case 5: {
                this.precisionString = "1m";
                break;
            }
            case 6: {
                this.precisionString = "0.1m";
                break;
            }
            case 7: {
                this.precisionString = "0.01m";
                break;
            }
            case 8: {
                this.precisionString = "0.001m";
            }
        }
    }

    public boolean getLeadingZeros() {
        return this.leadingZeros;
    }

    public void setLeadingZeros(boolean lz) {
        this.leadingZeros = lz;
        this.jniStrtoval.JNIShowLeadingZeros(lz);
    }

    public boolean getUseNSEW() {
        return this.signHemi == 1;
    }

    public boolean getUseMinutes() {
        return this.units != 2;
    }

    public boolean getUseSeconds() {
        return this.units == 0;
    }

    public void reset(jOptions joptions) {
        this.setOptions(joptions);
        this.jniEngine.JNISetPrecision(joptions.precision);
        this.jniStrtoval.JNISetLatLongPrecision(joptions.precision);
        this.jniStrtoval.JNISetSeparator(joptions.separator);
        this.jniStrtoval.JNISetLongRange(joptions.range);
        this.jniStrtoval.JNIShowLeadingZeros(joptions.leadingZeros);
    }

    private void setOptions(jOptions joptions) {
        this.units = joptions.units;
        this.signHemi = joptions.signHemi;
        this.precision = joptions.precision;
        this.separator = joptions.separator;
        this.range = joptions.range;
        this.leadingZeros = joptions.leadingZeros;
        this.jniEngine = joptions.jniEngine;
    }
}

