/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.jni.GeotransError;
import geotrans.jni.JNIFiomeths;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Center;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressDlg
extends JDialog {
    JNIFiomeths jniFiomeths;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JLabel elapsedTimeLabel;
    private JLabel numErrorsLabel;
    private JLabel numProcessedLabel;
    private JLabel numWarningsLabel;
    private JButton okButton;
    private JPanel resultsPanel;
    private JButton startButton;
    private JLabel statusLabel;

    public ProgressDlg(JDialog parent, boolean modal, JNIFiomeths jni_Fiomeths) {
        super((Dialog)parent, modal);
        this.jniFiomeths = jni_Fiomeths;
        this.initComponents();
        this.numProcessedLabel.setVisible(false);
        this.numWarningsLabel.setVisible(false);
        this.numErrorsLabel.setVisible(false);
        this.elapsedTimeLabel.setVisible(false);
        this.pack();
        new Center(parent, this);
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.startButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.statusLabel = new JLabel();
        this.resultsPanel = new JPanel();
        this.numProcessedLabel = new JLabel();
        this.numWarningsLabel = new JLabel();
        this.numErrorsLabel = new JLabel();
        this.elapsedTimeLabel = new JLabel();
        this.setTitle("GEOTRANS File Processing");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProgressDlg.this.closeDialog(evt);
            }
        });
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setPreferredSize(new Dimension(274, 26));
        this.buttonsPanel.setMinimumSize(new Dimension(274, 26));
        this.startButton.setPreferredSize(new Dimension(76, 21));
        this.startButton.setBorder(BorderFactory.createBevelBorder(0));
        this.startButton.setMnemonic(83);
        this.startButton.setMaximumSize(new Dimension(76, 21));
        this.startButton.setText("Start");
        this.startButton.setMinimumSize(new Dimension(76, 21));
        this.startButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ProgressDlg.this.startButtonMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ProgressDlg.this.startButtonMouseReleased(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 15);
        this.buttonsPanel.add((Component)this.startButton, gridBagConstraints);
        this.okButton.setPreferredSize(new Dimension(76, 21));
        this.okButton.setBorder(BorderFactory.createBevelBorder(0));
        this.okButton.setMnemonic(79);
        this.okButton.setMaximumSize(new Dimension(76, 21));
        this.okButton.setText("OK");
        this.okButton.setMinimumSize(new Dimension(76, 21));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressDlg.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 15);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setPreferredSize(new Dimension(76, 21));
        this.cancelButton.setBorder(BorderFactory.createBevelBorder(0));
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setMaximumSize(new Dimension(76, 21));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(76, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setText("Waiting");
        this.statusLabel.setMaximumSize(new Dimension(35, 26));
        this.statusLabel.setMinimumSize(new Dimension(35, 26));
        this.statusLabel.setPreferredSize(new Dimension(35, 26));
        this.getContentPane().add((Component)this.statusLabel, "North");
        this.resultsPanel.setLayout(new GridBagLayout());
        this.resultsPanel.setPreferredSize(new Dimension(274, 100));
        this.resultsPanel.setMinimumSize(new Dimension(274, 100));
        this.numProcessedLabel.setHorizontalAlignment(0);
        this.numProcessedLabel.setText("Num Processed:");
        this.numProcessedLabel.setMaximumSize(new Dimension(274, 16));
        this.numProcessedLabel.setMinimumSize(new Dimension(274, 16));
        this.numProcessedLabel.setPreferredSize(new Dimension(274, 16));
        this.resultsPanel.add((Component)this.numProcessedLabel, new GridBagConstraints());
        this.numWarningsLabel.setHorizontalAlignment(0);
        this.numWarningsLabel.setText("Num Warnings:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.resultsPanel.add((Component)this.numWarningsLabel, gridBagConstraints);
        this.numErrorsLabel.setHorizontalAlignment(0);
        this.numErrorsLabel.setText("Num Errors:");
        this.numErrorsLabel.setMaximumSize(new Dimension(73, 16));
        this.numErrorsLabel.setMinimumSize(new Dimension(73, 16));
        this.numErrorsLabel.setPreferredSize(new Dimension(73, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.resultsPanel.add((Component)this.numErrorsLabel, gridBagConstraints);
        this.elapsedTimeLabel.setHorizontalAlignment(0);
        this.elapsedTimeLabel.setText("Elapsed Time:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.resultsPanel.add((Component)this.elapsedTimeLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.resultsPanel, "Center");
    }

    private void startButtonMousePressed(MouseEvent evt) {
        this.statusLabel.setText("In Progress");
        this.setCursor(new Cursor(3));
        this.startButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
    }

    private void startButtonMouseReleased(MouseEvent evt) {
        long numProcessed = 0L;
        long numErrors = 0L;
        long numWarnings = 0L;
        try {
            this.jniFiomeths.JNIConvertFile();
            this.statusLabel.setText("Completed");
            this.setCursor(new Cursor(0));
            numProcessed = this.jniFiomeths.JNIGetNumProcessed();
            this.numProcessedLabel.setVisible(true);
            this.numProcessedLabel.setText("Number of coordinates processed = " + numProcessed);
            numWarnings = this.jniFiomeths.JNIGetNumWarnings();
            this.numWarningsLabel.setVisible(true);
            this.numWarningsLabel.setText("Number of warnings = " + numWarnings);
            numErrors = this.jniFiomeths.JNIGetNumErrors();
            this.numErrorsLabel.setVisible(true);
            this.numErrorsLabel.setText("Number of errors = " + numErrors);
            this.okButton.setEnabled(true);
        }
        catch (GeotransError e) {
            new JNIStrtoval().displayErrorMsg(this, e.getMessage());
            this.jniFiomeths.JNICloseInputFile();
            this.jniFiomeths.JNICloseOutputFile();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.jniFiomeths.JNICloseInputFile();
        this.jniFiomeths.JNICloseOutputFile();
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.jniFiomeths.JNICloseInputFile();
        this.jniFiomeths.JNICloseOutputFile();
        this.dispose();
    }

    public static void main(String[] args) {
        JNIFiomeths jni_Fiomeths = new JNIFiomeths();
        new ProgressDlg(new JDialog(), true, jni_Fiomeths).show();
    }
}

