/*
 *  encoding.c
 *  MacBlueTelnet
 *
 *  Created by Yung-Luen Lan on 9/11/07.
 *  Copyright 2007 yllan.org. All rights reserved.
 *
 */

#include "encoding.h"
#include <glib.h>
#include <string>
#include <cstring>
#include <cstdlib>
#include <wchar.h>

static unsigned short G2U[32768] = {
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8000 to 0x8007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8008 to 0x800F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8010 to 0x8017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8018 to 0x801F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8020 to 0x8027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8028 to 0x802F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8030 to 0x8037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8038 to 0x803F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8040 to 0x8047 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8048 to 0x804F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8050 to 0x8057 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8058 to 0x805F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8060 to 0x8067 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8068 to 0x806F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8070 to 0x8077 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8078 to 0x807F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8080 to 0x8087 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8088 to 0x808F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8090 to 0x8097 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8098 to 0x809F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80A0 to 0x80A7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80A8 to 0x80AF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80B0 to 0x80B7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80B8 to 0x80BF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80C0 to 0x80C7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80C8 to 0x80CF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80D0 to 0x80D7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80D8 to 0x80DF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80E0 to 0x80E7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80E8 to 0x80EF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80F0 to 0x80F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80F8 to 0x80FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8100 to 0x8107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8108 to 0x810F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8110 to 0x8117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8118 to 0x811F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8120 to 0x8127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8128 to 0x812F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8130 to 0x8137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8138 to 0x813F */ 
0x4E02, 0x4E04, 0x4E05, 0x4E06, 0x4E0F, 0x4E12, 0x4E17, 0x4E1F, 	/* 0x8140 to 0x8147 */ 
0x4E20, 0x4E21, 0x4E23, 0x4E26, 0x4E29, 0x4E2E, 0x4E2F, 0x4E31, 	/* 0x8148 to 0x814F */ 
0x4E33, 0x4E35, 0x4E37, 0x4E3C, 0x4E40, 0x4E41, 0x4E42, 0x4E44, 	/* 0x8150 to 0x8157 */ 
0x4E46, 0x4E4A, 0x4E51, 0x4E55, 0x4E57, 0x4E5A, 0x4E5B, 0x4E62, 	/* 0x8158 to 0x815F */ 
0x4E63, 0x4E64, 0x4E65, 0x4E67, 0x4E68, 0x4E6A, 0x4E6B, 0x4E6C, 	/* 0x8160 to 0x8167 */ 
0x4E6D, 0x4E6E, 0x4E6F, 0x4E72, 0x4E74, 0x4E75, 0x4E76, 0x4E77, 	/* 0x8168 to 0x816F */ 
0x4E78, 0x4E79, 0x4E7A, 0x4E7B, 0x4E7C, 0x4E7D, 0x4E7F, 0x4E80, 	/* 0x8170 to 0x8177 */ 
0x4E81, 0x4E82, 0x4E83, 0x4E84, 0x4E85, 0x4E87, 0x4E8A, 0x0000, 	/* 0x8178 to 0x817F */ 
0x4E90, 0x4E96, 0x4E97, 0x4E99, 0x4E9C, 0x4E9D, 0x4E9E, 0x4EA3, 	/* 0x8180 to 0x8187 */ 
0x4EAA, 0x4EAF, 0x4EB0, 0x4EB1, 0x4EB4, 0x4EB6, 0x4EB7, 0x4EB8, 	/* 0x8188 to 0x818F */ 
0x4EB9, 0x4EBC, 0x4EBD, 0x4EBE, 0x4EC8, 0x4ECC, 0x4ECF, 0x4ED0, 	/* 0x8190 to 0x8197 */ 
0x4ED2, 0x4EDA, 0x4EDB, 0x4EDC, 0x4EE0, 0x4EE2, 0x4EE6, 0x4EE7, 	/* 0x8198 to 0x819F */ 
0x4EE9, 0x4EED, 0x4EEE, 0x4EEF, 0x4EF1, 0x4EF4, 0x4EF8, 0x4EF9, 	/* 0x81A0 to 0x81A7 */ 
0x4EFA, 0x4EFC, 0x4EFE, 0x4F00, 0x4F02, 0x4F03, 0x4F04, 0x4F05, 	/* 0x81A8 to 0x81AF */ 
0x4F06, 0x4F07, 0x4F08, 0x4F0B, 0x4F0C, 0x4F12, 0x4F13, 0x4F14, 	/* 0x81B0 to 0x81B7 */ 
0x4F15, 0x4F16, 0x4F1C, 0x4F1D, 0x4F21, 0x4F23, 0x4F28, 0x4F29, 	/* 0x81B8 to 0x81BF */ 
0x4F2C, 0x4F2D, 0x4F2E, 0x4F31, 0x4F33, 0x4F35, 0x4F37, 0x4F39, 	/* 0x81C0 to 0x81C7 */ 
0x4F3B, 0x4F3E, 0x4F3F, 0x4F40, 0x4F41, 0x4F42, 0x4F44, 0x4F45, 	/* 0x81C8 to 0x81CF */ 
0x4F47, 0x4F48, 0x4F49, 0x4F4A, 0x4F4B, 0x4F4C, 0x4F52, 0x4F54, 	/* 0x81D0 to 0x81D7 */ 
0x4F56, 0x4F61, 0x4F62, 0x4F66, 0x4F68, 0x4F6A, 0x4F6B, 0x4F6D, 	/* 0x81D8 to 0x81DF */ 
0x4F6E, 0x4F71, 0x4F72, 0x4F75, 0x4F77, 0x4F78, 0x4F79, 0x4F7A, 	/* 0x81E0 to 0x81E7 */ 
0x4F7D, 0x4F80, 0x4F81, 0x4F82, 0x4F85, 0x4F86, 0x4F87, 0x4F8A, 	/* 0x81E8 to 0x81EF */ 
0x4F8C, 0x4F8E, 0x4F90, 0x4F92, 0x4F93, 0x4F95, 0x4F96, 0x4F98, 	/* 0x81F0 to 0x81F7 */ 
0x4F99, 0x4F9A, 0x4F9C, 0x4F9E, 0x4F9F, 0x4FA1, 0x4FA2, 0x0000, 	/* 0x81F8 to 0x81FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8200 to 0x8207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8208 to 0x820F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8210 to 0x8217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8218 to 0x821F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8220 to 0x8227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8228 to 0x822F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8230 to 0x8237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8238 to 0x823F */ 
0x4FA4, 0x4FAB, 0x4FAD, 0x4FB0, 0x4FB1, 0x4FB2, 0x4FB3, 0x4FB4, 	/* 0x8240 to 0x8247 */ 
0x4FB6, 0x4FB7, 0x4FB8, 0x4FB9, 0x4FBA, 0x4FBB, 0x4FBC, 0x4FBD, 	/* 0x8248 to 0x824F */ 
0x4FBE, 0x4FC0, 0x4FC1, 0x4FC2, 0x4FC6, 0x4FC7, 0x4FC8, 0x4FC9, 	/* 0x8250 to 0x8257 */ 
0x4FCB, 0x4FCC, 0x4FCD, 0x4FD2, 0x4FD3, 0x4FD4, 0x4FD5, 0x4FD6, 	/* 0x8258 to 0x825F */ 
0x4FD9, 0x4FDB, 0x4FE0, 0x4FE2, 0x4FE4, 0x4FE5, 0x4FE7, 0x4FEB, 	/* 0x8260 to 0x8267 */ 
0x4FEC, 0x4FF0, 0x4FF2, 0x4FF4, 0x4FF5, 0x4FF6, 0x4FF7, 0x4FF9, 	/* 0x8268 to 0x826F */ 
0x4FFB, 0x4FFC, 0x4FFD, 0x4FFF, 0x5000, 0x5001, 0x5002, 0x5003, 	/* 0x8270 to 0x8277 */ 
0x5004, 0x5005, 0x5006, 0x5007, 0x5008, 0x5009, 0x500A, 0x0000, 	/* 0x8278 to 0x827F */ 
0x500B, 0x500E, 0x5010, 0x5011, 0x5013, 0x5015, 0x5016, 0x5017, 	/* 0x8280 to 0x8287 */ 
0x501B, 0x501D, 0x501E, 0x5020, 0x5022, 0x5023, 0x5024, 0x5027, 	/* 0x8288 to 0x828F */ 
0x502B, 0x502F, 0x5030, 0x5031, 0x5032, 0x5033, 0x5034, 0x5035, 	/* 0x8290 to 0x8297 */ 
0x5036, 0x5037, 0x5038, 0x5039, 0x503B, 0x503D, 0x503F, 0x5040, 	/* 0x8298 to 0x829F */ 
0x5041, 0x5042, 0x5044, 0x5045, 0x5046, 0x5049, 0x504A, 0x504B, 	/* 0x82A0 to 0x82A7 */ 
0x504D, 0x5050, 0x5051, 0x5052, 0x5053, 0x5054, 0x5056, 0x5057, 	/* 0x82A8 to 0x82AF */ 
0x5058, 0x5059, 0x505B, 0x505D, 0x505E, 0x505F, 0x5060, 0x5061, 	/* 0x82B0 to 0x82B7 */ 
0x5062, 0x5063, 0x5064, 0x5066, 0x5067, 0x5068, 0x5069, 0x506A, 	/* 0x82B8 to 0x82BF */ 
0x506B, 0x506D, 0x506E, 0x506F, 0x5070, 0x5071, 0x5072, 0x5073, 	/* 0x82C0 to 0x82C7 */ 
0x5074, 0x5075, 0x5078, 0x5079, 0x507A, 0x507C, 0x507D, 0x5081, 	/* 0x82C8 to 0x82CF */ 
0x5082, 0x5083, 0x5084, 0x5086, 0x5087, 0x5089, 0x508A, 0x508B, 	/* 0x82D0 to 0x82D7 */ 
0x508C, 0x508E, 0x508F, 0x5090, 0x5091, 0x5092, 0x5093, 0x5094, 	/* 0x82D8 to 0x82DF */ 
0x5095, 0x5096, 0x5097, 0x5098, 0x5099, 0x509A, 0x509B, 0x509C, 	/* 0x82E0 to 0x82E7 */ 
0x509D, 0x509E, 0x509F, 0x50A0, 0x50A1, 0x50A2, 0x50A4, 0x50A6, 	/* 0x82E8 to 0x82EF */ 
0x50AA, 0x50AB, 0x50AD, 0x50AE, 0x50AF, 0x50B0, 0x50B1, 0x50B3, 	/* 0x82F0 to 0x82F7 */ 
0x50B4, 0x50B5, 0x50B6, 0x50B7, 0x50B8, 0x50B9, 0x50BC, 0x0000, 	/* 0x82F8 to 0x82FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8300 to 0x8307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8308 to 0x830F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8310 to 0x8317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8318 to 0x831F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8320 to 0x8327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8328 to 0x832F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8330 to 0x8337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8338 to 0x833F */ 
0x50BD, 0x50BE, 0x50BF, 0x50C0, 0x50C1, 0x50C2, 0x50C3, 0x50C4, 	/* 0x8340 to 0x8347 */ 
0x50C5, 0x50C6, 0x50C7, 0x50C8, 0x50C9, 0x50CA, 0x50CB, 0x50CC, 	/* 0x8348 to 0x834F */ 
0x50CD, 0x50CE, 0x50D0, 0x50D1, 0x50D2, 0x50D3, 0x50D4, 0x50D5, 	/* 0x8350 to 0x8357 */ 
0x50D7, 0x50D8, 0x50D9, 0x50DB, 0x50DC, 0x50DD, 0x50DE, 0x50DF, 	/* 0x8358 to 0x835F */ 
0x50E0, 0x50E1, 0x50E2, 0x50E3, 0x50E4, 0x50E5, 0x50E8, 0x50E9, 	/* 0x8360 to 0x8367 */ 
0x50EA, 0x50EB, 0x50EF, 0x50F0, 0x50F1, 0x50F2, 0x50F4, 0x50F6, 	/* 0x8368 to 0x836F */ 
0x50F7, 0x50F8, 0x50F9, 0x50FA, 0x50FC, 0x50FD, 0x50FE, 0x50FF, 	/* 0x8370 to 0x8377 */ 
0x5100, 0x5101, 0x5102, 0x5103, 0x5104, 0x5105, 0x5108, 0x0000, 	/* 0x8378 to 0x837F */ 
0x5109, 0x510A, 0x510C, 0x510D, 0x510E, 0x510F, 0x5110, 0x5111, 	/* 0x8380 to 0x8387 */ 
0x5113, 0x5114, 0x5115, 0x5116, 0x5117, 0x5118, 0x5119, 0x511A, 	/* 0x8388 to 0x838F */ 
0x511B, 0x511C, 0x511D, 0x511E, 0x511F, 0x5120, 0x5122, 0x5123, 	/* 0x8390 to 0x8397 */ 
0x5124, 0x5125, 0x5126, 0x5127, 0x5128, 0x5129, 0x512A, 0x512B, 	/* 0x8398 to 0x839F */ 
0x512C, 0x512D, 0x512E, 0x512F, 0x5130, 0x5131, 0x5132, 0x5133, 	/* 0x83A0 to 0x83A7 */ 
0x5134, 0x5135, 0x5136, 0x5137, 0x5138, 0x5139, 0x513A, 0x513B, 	/* 0x83A8 to 0x83AF */ 
0x513C, 0x513D, 0x513E, 0x5142, 0x5147, 0x514A, 0x514C, 0x514E, 	/* 0x83B0 to 0x83B7 */ 
0x514F, 0x5150, 0x5152, 0x5153, 0x5157, 0x5158, 0x5159, 0x515B, 	/* 0x83B8 to 0x83BF */ 
0x515D, 0x515E, 0x515F, 0x5160, 0x5161, 0x5163, 0x5164, 0x5166, 	/* 0x83C0 to 0x83C7 */ 
0x5167, 0x5169, 0x516A, 0x516F, 0x5172, 0x517A, 0x517E, 0x517F, 	/* 0x83C8 to 0x83CF */ 
0x5183, 0x5184, 0x5186, 0x5187, 0x518A, 0x518B, 0x518E, 0x518F, 	/* 0x83D0 to 0x83D7 */ 
0x5190, 0x5191, 0x5193, 0x5194, 0x5198, 0x519A, 0x519D, 0x519E, 	/* 0x83D8 to 0x83DF */ 
0x519F, 0x51A1, 0x51A3, 0x51A6, 0x51A7, 0x51A8, 0x51A9, 0x51AA, 	/* 0x83E0 to 0x83E7 */ 
0x51AD, 0x51AE, 0x51B4, 0x51B8, 0x51B9, 0x51BA, 0x51BE, 0x51BF, 	/* 0x83E8 to 0x83EF */ 
0x51C1, 0x51C2, 0x51C3, 0x51C5, 0x51C8, 0x51CA, 0x51CD, 0x51CE, 	/* 0x83F0 to 0x83F7 */ 
0x51D0, 0x51D2, 0x51D3, 0x51D4, 0x51D5, 0x51D6, 0x51D7, 0x0000, 	/* 0x83F8 to 0x83FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8400 to 0x8407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8408 to 0x840F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8410 to 0x8417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8418 to 0x841F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8420 to 0x8427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8428 to 0x842F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8430 to 0x8437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8438 to 0x843F */ 
0x51D8, 0x51D9, 0x51DA, 0x51DC, 0x51DE, 0x51DF, 0x51E2, 0x51E3, 	/* 0x8440 to 0x8447 */ 
0x51E5, 0x51E6, 0x51E7, 0x51E8, 0x51E9, 0x51EA, 0x51EC, 0x51EE, 	/* 0x8448 to 0x844F */ 
0x51F1, 0x51F2, 0x51F4, 0x51F7, 0x51FE, 0x5204, 0x5205, 0x5209, 	/* 0x8450 to 0x8457 */ 
0x520B, 0x520C, 0x520F, 0x5210, 0x5213, 0x5214, 0x5215, 0x521C, 	/* 0x8458 to 0x845F */ 
0x521E, 0x521F, 0x5221, 0x5222, 0x5223, 0x5225, 0x5226, 0x5227, 	/* 0x8460 to 0x8467 */ 
0x522A, 0x522C, 0x522F, 0x5231, 0x5232, 0x5234, 0x5235, 0x523C, 	/* 0x8468 to 0x846F */ 
0x523E, 0x5244, 0x5245, 0x5246, 0x5247, 0x5248, 0x5249, 0x524B, 	/* 0x8470 to 0x8477 */ 
0x524E, 0x524F, 0x5252, 0x5253, 0x5255, 0x5257, 0x5258, 0x0000, 	/* 0x8478 to 0x847F */ 
0x5259, 0x525A, 0x525B, 0x525D, 0x525F, 0x5260, 0x5262, 0x5263, 	/* 0x8480 to 0x8487 */ 
0x5264, 0x5266, 0x5268, 0x526B, 0x526C, 0x526D, 0x526E, 0x5270, 	/* 0x8488 to 0x848F */ 
0x5271, 0x5273, 0x5274, 0x5275, 0x5276, 0x5277, 0x5278, 0x5279, 	/* 0x8490 to 0x8497 */ 
0x527A, 0x527B, 0x527C, 0x527E, 0x5280, 0x5283, 0x5284, 0x5285, 	/* 0x8498 to 0x849F */ 
0x5286, 0x5287, 0x5289, 0x528A, 0x528B, 0x528C, 0x528D, 0x528E, 	/* 0x84A0 to 0x84A7 */ 
0x528F, 0x5291, 0x5292, 0x5294, 0x5295, 0x5296, 0x5297, 0x5298, 	/* 0x84A8 to 0x84AF */ 
0x5299, 0x529A, 0x529C, 0x52A4, 0x52A5, 0x52A6, 0x52A7, 0x52AE, 	/* 0x84B0 to 0x84B7 */ 
0x52AF, 0x52B0, 0x52B4, 0x52B5, 0x52B6, 0x52B7, 0x52B8, 0x52B9, 	/* 0x84B8 to 0x84BF */ 
0x52BA, 0x52BB, 0x52BC, 0x52BD, 0x52C0, 0x52C1, 0x52C2, 0x52C4, 	/* 0x84C0 to 0x84C7 */ 
0x52C5, 0x52C6, 0x52C8, 0x52CA, 0x52CC, 0x52CD, 0x52CE, 0x52CF, 	/* 0x84C8 to 0x84CF */ 
0x52D1, 0x52D3, 0x52D4, 0x52D5, 0x52D7, 0x52D9, 0x52DA, 0x52DB, 	/* 0x84D0 to 0x84D7 */ 
0x52DC, 0x52DD, 0x52DE, 0x52E0, 0x52E1, 0x52E2, 0x52E3, 0x52E5, 	/* 0x84D8 to 0x84DF */ 
0x52E6, 0x52E7, 0x52E8, 0x52E9, 0x52EA, 0x52EB, 0x52EC, 0x52ED, 	/* 0x84E0 to 0x84E7 */ 
0x52EE, 0x52EF, 0x52F1, 0x52F2, 0x52F3, 0x52F4, 0x52F5, 0x52F6, 	/* 0x84E8 to 0x84EF */ 
0x52F7, 0x52F8, 0x52FB, 0x52FC, 0x52FD, 0x5301, 0x5302, 0x5303, 	/* 0x84F0 to 0x84F7 */ 
0x5304, 0x5307, 0x5309, 0x530A, 0x530B, 0x530C, 0x530E, 0x0000, 	/* 0x84F8 to 0x84FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8500 to 0x8507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8508 to 0x850F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8510 to 0x8517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8518 to 0x851F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8520 to 0x8527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8528 to 0x852F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8530 to 0x8537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8538 to 0x853F */ 
0x5311, 0x5312, 0x5313, 0x5314, 0x5318, 0x531B, 0x531C, 0x531E, 	/* 0x8540 to 0x8547 */ 
0x531F, 0x5322, 0x5324, 0x5325, 0x5327, 0x5328, 0x5329, 0x532B, 	/* 0x8548 to 0x854F */ 
0x532C, 0x532D, 0x532F, 0x5330, 0x5331, 0x5332, 0x5333, 0x5334, 	/* 0x8550 to 0x8557 */ 
0x5335, 0x5336, 0x5337, 0x5338, 0x533C, 0x533D, 0x5340, 0x5342, 	/* 0x8558 to 0x855F */ 
0x5344, 0x5346, 0x534B, 0x534C, 0x534D, 0x5350, 0x5354, 0x5358, 	/* 0x8560 to 0x8567 */ 
0x5359, 0x535B, 0x535D, 0x5365, 0x5368, 0x536A, 0x536C, 0x536D, 	/* 0x8568 to 0x856F */ 
0x5372, 0x5376, 0x5379, 0x537B, 0x537C, 0x537D, 0x537E, 0x5380, 	/* 0x8570 to 0x8577 */ 
0x5381, 0x5383, 0x5387, 0x5388, 0x538A, 0x538E, 0x538F, 0x0000, 	/* 0x8578 to 0x857F */ 
0x5390, 0x5391, 0x5392, 0x5393, 0x5394, 0x5396, 0x5397, 0x5399, 	/* 0x8580 to 0x8587 */ 
0x539B, 0x539C, 0x539E, 0x53A0, 0x53A1, 0x53A4, 0x53A7, 0x53AA, 	/* 0x8588 to 0x858F */ 
0x53AB, 0x53AC, 0x53AD, 0x53AF, 0x53B0, 0x53B1, 0x53B2, 0x53B3, 	/* 0x8590 to 0x8597 */ 
0x53B4, 0x53B5, 0x53B7, 0x53B8, 0x53B9, 0x53BA, 0x53BC, 0x53BD, 	/* 0x8598 to 0x859F */ 
0x53BE, 0x53C0, 0x53C3, 0x53C4, 0x53C5, 0x53C6, 0x53C7, 0x53CE, 	/* 0x85A0 to 0x85A7 */ 
0x53CF, 0x53D0, 0x53D2, 0x53D3, 0x53D5, 0x53DA, 0x53DC, 0x53DD, 	/* 0x85A8 to 0x85AF */ 
0x53DE, 0x53E1, 0x53E2, 0x53E7, 0x53F4, 0x53FA, 0x53FE, 0x53FF, 	/* 0x85B0 to 0x85B7 */ 
0x5400, 0x5402, 0x5405, 0x5407, 0x540B, 0x5414, 0x5418, 0x5419, 	/* 0x85B8 to 0x85BF */ 
0x541A, 0x541C, 0x5422, 0x5424, 0x5425, 0x542A, 0x5430, 0x5433, 	/* 0x85C0 to 0x85C7 */ 
0x5436, 0x5437, 0x543A, 0x543D, 0x543F, 0x5441, 0x5442, 0x5444, 	/* 0x85C8 to 0x85CF */ 
0x5445, 0x5447, 0x5449, 0x544C, 0x544D, 0x544E, 0x544F, 0x5451, 	/* 0x85D0 to 0x85D7 */ 
0x545A, 0x545D, 0x545E, 0x545F, 0x5460, 0x5461, 0x5463, 0x5465, 	/* 0x85D8 to 0x85DF */ 
0x5467, 0x5469, 0x546A, 0x546B, 0x546C, 0x546D, 0x546E, 0x546F, 	/* 0x85E0 to 0x85E7 */ 
0x5470, 0x5474, 0x5479, 0x547A, 0x547E, 0x547F, 0x5481, 0x5483, 	/* 0x85E8 to 0x85EF */ 
0x5485, 0x5487, 0x5488, 0x5489, 0x548A, 0x548D, 0x5491, 0x5493, 	/* 0x85F0 to 0x85F7 */ 
0x5497, 0x5498, 0x549C, 0x549E, 0x549F, 0x54A0, 0x54A1, 0x0000, 	/* 0x85F8 to 0x85FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8600 to 0x8607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8608 to 0x860F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8610 to 0x8617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8618 to 0x861F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8620 to 0x8627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8628 to 0x862F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8630 to 0x8637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8638 to 0x863F */ 
0x54A2, 0x54A5, 0x54AE, 0x54B0, 0x54B2, 0x54B5, 0x54B6, 0x54B7, 	/* 0x8640 to 0x8647 */ 
0x54B9, 0x54BA, 0x54BC, 0x54BE, 0x54C3, 0x54C5, 0x54CA, 0x54CB, 	/* 0x8648 to 0x864F */ 
0x54D6, 0x54D8, 0x54DB, 0x54E0, 0x54E1, 0x54E2, 0x54E3, 0x54E4, 	/* 0x8650 to 0x8657 */ 
0x54EB, 0x54EC, 0x54EF, 0x54F0, 0x54F1, 0x54F4, 0x54F5, 0x54F6, 	/* 0x8658 to 0x865F */ 
0x54F7, 0x54F8, 0x54F9, 0x54FB, 0x54FE, 0x5500, 0x5502, 0x5503, 	/* 0x8660 to 0x8667 */ 
0x5504, 0x5505, 0x5508, 0x550A, 0x550B, 0x550C, 0x550D, 0x550E, 	/* 0x8668 to 0x866F */ 
0x5512, 0x5513, 0x5515, 0x5516, 0x5517, 0x5518, 0x5519, 0x551A, 	/* 0x8670 to 0x8677 */ 
0x551C, 0x551D, 0x551E, 0x551F, 0x5521, 0x5525, 0x5526, 0x0000, 	/* 0x8678 to 0x867F */ 
0x5528, 0x5529, 0x552B, 0x552D, 0x5532, 0x5534, 0x5535, 0x5536, 	/* 0x8680 to 0x8687 */ 
0x5538, 0x5539, 0x553A, 0x553B, 0x553D, 0x5540, 0x5542, 0x5545, 	/* 0x8688 to 0x868F */ 
0x5547, 0x5548, 0x554B, 0x554C, 0x554D, 0x554E, 0x554F, 0x5551, 	/* 0x8690 to 0x8697 */ 
0x5552, 0x5553, 0x5554, 0x5557, 0x5558, 0x5559, 0x555A, 0x555B, 	/* 0x8698 to 0x869F */ 
0x555D, 0x555E, 0x555F, 0x5560, 0x5562, 0x5563, 0x5568, 0x5569, 	/* 0x86A0 to 0x86A7 */ 
0x556B, 0x556F, 0x5570, 0x5571, 0x5572, 0x5573, 0x5574, 0x5579, 	/* 0x86A8 to 0x86AF */ 
0x557A, 0x557D, 0x557F, 0x5585, 0x5586, 0x558C, 0x558D, 0x558E, 	/* 0x86B0 to 0x86B7 */ 
0x5590, 0x5592, 0x5593, 0x5595, 0x5596, 0x5597, 0x559A, 0x559B, 	/* 0x86B8 to 0x86BF */ 
0x559E, 0x55A0, 0x55A1, 0x55A2, 0x55A3, 0x55A4, 0x55A5, 0x55A6, 	/* 0x86C0 to 0x86C7 */ 
0x55A8, 0x55A9, 0x55AA, 0x55AB, 0x55AC, 0x55AD, 0x55AE, 0x55AF, 	/* 0x86C8 to 0x86CF */ 
0x55B0, 0x55B2, 0x55B4, 0x55B6, 0x55B8, 0x55BA, 0x55BC, 0x55BF, 	/* 0x86D0 to 0x86D7 */ 
0x55C0, 0x55C1, 0x55C2, 0x55C3, 0x55C6, 0x55C7, 0x55C8, 0x55CA, 	/* 0x86D8 to 0x86DF */ 
0x55CB, 0x55CE, 0x55CF, 0x55D0, 0x55D5, 0x55D7, 0x55D8, 0x55D9, 	/* 0x86E0 to 0x86E7 */ 
0x55DA, 0x55DB, 0x55DE, 0x55E0, 0x55E2, 0x55E7, 0x55E9, 0x55ED, 	/* 0x86E8 to 0x86EF */ 
0x55EE, 0x55F0, 0x55F1, 0x55F4, 0x55F6, 0x55F8, 0x55F9, 0x55FA, 	/* 0x86F0 to 0x86F7 */ 
0x55FB, 0x55FC, 0x55FF, 0x5602, 0x5603, 0x5604, 0x5605, 0x0000, 	/* 0x86F8 to 0x86FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8700 to 0x8707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8708 to 0x870F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8710 to 0x8717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8718 to 0x871F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8720 to 0x8727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8728 to 0x872F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8730 to 0x8737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8738 to 0x873F */ 
0x5606, 0x5607, 0x560A, 0x560B, 0x560D, 0x5610, 0x5611, 0x5612, 	/* 0x8740 to 0x8747 */ 
0x5613, 0x5614, 0x5615, 0x5616, 0x5617, 0x5619, 0x561A, 0x561C, 	/* 0x8748 to 0x874F */ 
0x561D, 0x5620, 0x5621, 0x5622, 0x5625, 0x5626, 0x5628, 0x5629, 	/* 0x8750 to 0x8757 */ 
0x562A, 0x562B, 0x562E, 0x562F, 0x5630, 0x5633, 0x5635, 0x5637, 	/* 0x8758 to 0x875F */ 
0x5638, 0x563A, 0x563C, 0x563D, 0x563E, 0x5640, 0x5641, 0x5642, 	/* 0x8760 to 0x8767 */ 
0x5643, 0x5644, 0x5645, 0x5646, 0x5647, 0x5648, 0x5649, 0x564A, 	/* 0x8768 to 0x876F */ 
0x564B, 0x564F, 0x5650, 0x5651, 0x5652, 0x5653, 0x5655, 0x5656, 	/* 0x8770 to 0x8777 */ 
0x565A, 0x565B, 0x565D, 0x565E, 0x565F, 0x5660, 0x5661, 0x0000, 	/* 0x8778 to 0x877F */ 
0x5663, 0x5665, 0x5666, 0x5667, 0x566D, 0x566E, 0x566F, 0x5670, 	/* 0x8780 to 0x8787 */ 
0x5672, 0x5673, 0x5674, 0x5675, 0x5677, 0x5678, 0x5679, 0x567A, 	/* 0x8788 to 0x878F */ 
0x567D, 0x567E, 0x567F, 0x5680, 0x5681, 0x5682, 0x5683, 0x5684, 	/* 0x8790 to 0x8797 */ 
0x5687, 0x5688, 0x5689, 0x568A, 0x568B, 0x568C, 0x568D, 0x5690, 	/* 0x8798 to 0x879F */ 
0x5691, 0x5692, 0x5694, 0x5695, 0x5696, 0x5697, 0x5698, 0x5699, 	/* 0x87A0 to 0x87A7 */ 
0x569A, 0x569B, 0x569C, 0x569D, 0x569E, 0x569F, 0x56A0, 0x56A1, 	/* 0x87A8 to 0x87AF */ 
0x56A2, 0x56A4, 0x56A5, 0x56A6, 0x56A7, 0x56A8, 0x56A9, 0x56AA, 	/* 0x87B0 to 0x87B7 */ 
0x56AB, 0x56AC, 0x56AD, 0x56AE, 0x56B0, 0x56B1, 0x56B2, 0x56B3, 	/* 0x87B8 to 0x87BF */ 
0x56B4, 0x56B5, 0x56B6, 0x56B8, 0x56B9, 0x56BA, 0x56BB, 0x56BD, 	/* 0x87C0 to 0x87C7 */ 
0x56BE, 0x56BF, 0x56C0, 0x56C1, 0x56C2, 0x56C3, 0x56C4, 0x56C5, 	/* 0x87C8 to 0x87CF */ 
0x56C6, 0x56C7, 0x56C8, 0x56C9, 0x56CB, 0x56CC, 0x56CD, 0x56CE, 	/* 0x87D0 to 0x87D7 */ 
0x56CF, 0x56D0, 0x56D1, 0x56D2, 0x56D3, 0x56D5, 0x56D6, 0x56D8, 	/* 0x87D8 to 0x87DF */ 
0x56D9, 0x56DC, 0x56E3, 0x56E5, 0x56E6, 0x56E7, 0x56E8, 0x56E9, 	/* 0x87E0 to 0x87E7 */ 
0x56EA, 0x56EC, 0x56EE, 0x56EF, 0x56F2, 0x56F3, 0x56F6, 0x56F7, 	/* 0x87E8 to 0x87EF */ 
0x56F8, 0x56FB, 0x56FC, 0x5700, 0x5701, 0x5702, 0x5705, 0x5707, 	/* 0x87F0 to 0x87F7 */ 
0x570B, 0x570C, 0x570D, 0x570E, 0x570F, 0x5710, 0x5711, 0x0000, 	/* 0x87F8 to 0x87FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8800 to 0x8807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8808 to 0x880F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8810 to 0x8817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8818 to 0x881F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8820 to 0x8827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8828 to 0x882F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8830 to 0x8837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8838 to 0x883F */ 
0x5712, 0x5713, 0x5714, 0x5715, 0x5716, 0x5717, 0x5718, 0x5719, 	/* 0x8840 to 0x8847 */ 
0x571A, 0x571B, 0x571D, 0x571E, 0x5720, 0x5721, 0x5722, 0x5724, 	/* 0x8848 to 0x884F */ 
0x5725, 0x5726, 0x5727, 0x572B, 0x5731, 0x5732, 0x5734, 0x5735, 	/* 0x8850 to 0x8857 */ 
0x5736, 0x5737, 0x5738, 0x573C, 0x573D, 0x573F, 0x5741, 0x5743, 	/* 0x8858 to 0x885F */ 
0x5744, 0x5745, 0x5746, 0x5748, 0x5749, 0x574B, 0x5752, 0x5753, 	/* 0x8860 to 0x8867 */ 
0x5754, 0x5755, 0x5756, 0x5758, 0x5759, 0x5762, 0x5763, 0x5765, 	/* 0x8868 to 0x886F */ 
0x5767, 0x576C, 0x576E, 0x5770, 0x5771, 0x5772, 0x5774, 0x5775, 	/* 0x8870 to 0x8877 */ 
0x5778, 0x5779, 0x577A, 0x577D, 0x577E, 0x577F, 0x5780, 0x0000, 	/* 0x8878 to 0x887F */ 
0x5781, 0x5787, 0x5788, 0x5789, 0x578A, 0x578D, 0x578E, 0x578F, 	/* 0x8880 to 0x8887 */ 
0x5790, 0x5791, 0x5794, 0x5795, 0x5796, 0x5797, 0x5798, 0x5799, 	/* 0x8888 to 0x888F */ 
0x579A, 0x579C, 0x579D, 0x579E, 0x579F, 0x57A5, 0x57A8, 0x57AA, 	/* 0x8890 to 0x8897 */ 
0x57AC, 0x57AF, 0x57B0, 0x57B1, 0x57B3, 0x57B5, 0x57B6, 0x57B7, 	/* 0x8898 to 0x889F */ 
0x57B9, 0x57BA, 0x57BB, 0x57BC, 0x57BD, 0x57BE, 0x57BF, 0x57C0, 	/* 0x88A0 to 0x88A7 */ 
0x57C1, 0x57C4, 0x57C5, 0x57C6, 0x57C7, 0x57C8, 0x57C9, 0x57CA, 	/* 0x88A8 to 0x88AF */ 
0x57CC, 0x57CD, 0x57D0, 0x57D1, 0x57D3, 0x57D6, 0x57D7, 0x57DB, 	/* 0x88B0 to 0x88B7 */ 
0x57DC, 0x57DE, 0x57E1, 0x57E2, 0x57E3, 0x57E5, 0x57E6, 0x57E7, 	/* 0x88B8 to 0x88BF */ 
0x57E8, 0x57E9, 0x57EA, 0x57EB, 0x57EC, 0x57EE, 0x57F0, 0x57F1, 	/* 0x88C0 to 0x88C7 */ 
0x57F2, 0x57F3, 0x57F5, 0x57F6, 0x57F7, 0x57FB, 0x57FC, 0x57FE, 	/* 0x88C8 to 0x88CF */ 
0x57FF, 0x5801, 0x5803, 0x5804, 0x5805, 0x5808, 0x5809, 0x580A, 	/* 0x88D0 to 0x88D7 */ 
0x580C, 0x580E, 0x580F, 0x5810, 0x5812, 0x5813, 0x5814, 0x5816, 	/* 0x88D8 to 0x88DF */ 
0x5817, 0x5818, 0x581A, 0x581B, 0x581C, 0x581D, 0x581F, 0x5822, 	/* 0x88E0 to 0x88E7 */ 
0x5823, 0x5825, 0x5826, 0x5827, 0x5828, 0x5829, 0x582B, 0x582C, 	/* 0x88E8 to 0x88EF */ 
0x582D, 0x582E, 0x582F, 0x5831, 0x5832, 0x5833, 0x5834, 0x5836, 	/* 0x88F0 to 0x88F7 */ 
0x5837, 0x5838, 0x5839, 0x583A, 0x583B, 0x583C, 0x583D, 0x0000, 	/* 0x88F8 to 0x88FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8900 to 0x8907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8908 to 0x890F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8910 to 0x8917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8918 to 0x891F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8920 to 0x8927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8928 to 0x892F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8930 to 0x8937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8938 to 0x893F */ 
0x583E, 0x583F, 0x5840, 0x5841, 0x5842, 0x5843, 0x5845, 0x5846, 	/* 0x8940 to 0x8947 */ 
0x5847, 0x5848, 0x5849, 0x584A, 0x584B, 0x584E, 0x584F, 0x5850, 	/* 0x8948 to 0x894F */ 
0x5852, 0x5853, 0x5855, 0x5856, 0x5857, 0x5859, 0x585A, 0x585B, 	/* 0x8950 to 0x8957 */ 
0x585C, 0x585D, 0x585F, 0x5860, 0x5861, 0x5862, 0x5863, 0x5864, 	/* 0x8958 to 0x895F */ 
0x5866, 0x5867, 0x5868, 0x5869, 0x586A, 0x586D, 0x586E, 0x586F, 	/* 0x8960 to 0x8967 */ 
0x5870, 0x5871, 0x5872, 0x5873, 0x5874, 0x5875, 0x5876, 0x5877, 	/* 0x8968 to 0x896F */ 
0x5878, 0x5879, 0x587A, 0x587B, 0x587C, 0x587D, 0x587F, 0x5882, 	/* 0x8970 to 0x8977 */ 
0x5884, 0x5886, 0x5887, 0x5888, 0x588A, 0x588B, 0x588C, 0x0000, 	/* 0x8978 to 0x897F */ 
0x588D, 0x588E, 0x588F, 0x5890, 0x5891, 0x5894, 0x5895, 0x5896, 	/* 0x8980 to 0x8987 */ 
0x5897, 0x5898, 0x589B, 0x589C, 0x589D, 0x58A0, 0x58A1, 0x58A2, 	/* 0x8988 to 0x898F */ 
0x58A3, 0x58A4, 0x58A5, 0x58A6, 0x58A7, 0x58AA, 0x58AB, 0x58AC, 	/* 0x8990 to 0x8997 */ 
0x58AD, 0x58AE, 0x58AF, 0x58B0, 0x58B1, 0x58B2, 0x58B3, 0x58B4, 	/* 0x8998 to 0x899F */ 
0x58B5, 0x58B6, 0x58B7, 0x58B8, 0x58B9, 0x58BA, 0x58BB, 0x58BD, 	/* 0x89A0 to 0x89A7 */ 
0x58BE, 0x58BF, 0x58C0, 0x58C2, 0x58C3, 0x58C4, 0x58C6, 0x58C7, 	/* 0x89A8 to 0x89AF */ 
0x58C8, 0x58C9, 0x58CA, 0x58CB, 0x58CC, 0x58CD, 0x58CE, 0x58CF, 	/* 0x89B0 to 0x89B7 */ 
0x58D0, 0x58D2, 0x58D3, 0x58D4, 0x58D6, 0x58D7, 0x58D8, 0x58D9, 	/* 0x89B8 to 0x89BF */ 
0x58DA, 0x58DB, 0x58DC, 0x58DD, 0x58DE, 0x58DF, 0x58E0, 0x58E1, 	/* 0x89C0 to 0x89C7 */ 
0x58E2, 0x58E3, 0x58E5, 0x58E6, 0x58E7, 0x58E8, 0x58E9, 0x58EA, 	/* 0x89C8 to 0x89CF */ 
0x58ED, 0x58EF, 0x58F1, 0x58F2, 0x58F4, 0x58F5, 0x58F7, 0x58F8, 	/* 0x89D0 to 0x89D7 */ 
0x58FA, 0x58FB, 0x58FC, 0x58FD, 0x58FE, 0x58FF, 0x5900, 0x5901, 	/* 0x89D8 to 0x89DF */ 
0x5903, 0x5905, 0x5906, 0x5908, 0x5909, 0x590A, 0x590B, 0x590C, 	/* 0x89E0 to 0x89E7 */ 
0x590E, 0x5910, 0x5911, 0x5912, 0x5913, 0x5917, 0x5918, 0x591B, 	/* 0x89E8 to 0x89EF */ 
0x591D, 0x591E, 0x5920, 0x5921, 0x5922, 0x5923, 0x5926, 0x5928, 	/* 0x89F0 to 0x89F7 */ 
0x592C, 0x5930, 0x5932, 0x5933, 0x5935, 0x5936, 0x593B, 0x0000, 	/* 0x89F8 to 0x89FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A00 to 0x8A07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A08 to 0x8A0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A10 to 0x8A17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A18 to 0x8A1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A20 to 0x8A27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A28 to 0x8A2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A30 to 0x8A37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A38 to 0x8A3F */ 
0x593D, 0x593E, 0x593F, 0x5940, 0x5943, 0x5945, 0x5946, 0x594A, 	/* 0x8A40 to 0x8A47 */ 
0x594C, 0x594D, 0x5950, 0x5952, 0x5953, 0x5959, 0x595B, 0x595C, 	/* 0x8A48 to 0x8A4F */ 
0x595D, 0x595E, 0x595F, 0x5961, 0x5963, 0x5964, 0x5966, 0x5967, 	/* 0x8A50 to 0x8A57 */ 
0x5968, 0x5969, 0x596A, 0x596B, 0x596C, 0x596D, 0x596E, 0x596F, 	/* 0x8A58 to 0x8A5F */ 
0x5970, 0x5971, 0x5972, 0x5975, 0x5977, 0x597A, 0x597B, 0x597C, 	/* 0x8A60 to 0x8A67 */ 
0x597E, 0x597F, 0x5980, 0x5985, 0x5989, 0x598B, 0x598C, 0x598E, 	/* 0x8A68 to 0x8A6F */ 
0x598F, 0x5990, 0x5991, 0x5994, 0x5995, 0x5998, 0x599A, 0x599B, 	/* 0x8A70 to 0x8A77 */ 
0x599C, 0x599D, 0x599F, 0x59A0, 0x59A1, 0x59A2, 0x59A6, 0x0000, 	/* 0x8A78 to 0x8A7F */ 
0x59A7, 0x59AC, 0x59AD, 0x59B0, 0x59B1, 0x59B3, 0x59B4, 0x59B5, 	/* 0x8A80 to 0x8A87 */ 
0x59B6, 0x59B7, 0x59B8, 0x59BA, 0x59BC, 0x59BD, 0x59BF, 0x59C0, 	/* 0x8A88 to 0x8A8F */ 
0x59C1, 0x59C2, 0x59C3, 0x59C4, 0x59C5, 0x59C7, 0x59C8, 0x59C9, 	/* 0x8A90 to 0x8A97 */ 
0x59CC, 0x59CD, 0x59CE, 0x59CF, 0x59D5, 0x59D6, 0x59D9, 0x59DB, 	/* 0x8A98 to 0x8A9F */ 
0x59DE, 0x59DF, 0x59E0, 0x59E1, 0x59E2, 0x59E4, 0x59E6, 0x59E7, 	/* 0x8AA0 to 0x8AA7 */ 
0x59E9, 0x59EA, 0x59EB, 0x59ED, 0x59EE, 0x59EF, 0x59F0, 0x59F1, 	/* 0x8AA8 to 0x8AAF */ 
0x59F2, 0x59F3, 0x59F4, 0x59F5, 0x59F6, 0x59F7, 0x59F8, 0x59FA, 	/* 0x8AB0 to 0x8AB7 */ 
0x59FC, 0x59FD, 0x59FE, 0x5A00, 0x5A02, 0x5A0A, 0x5A0B, 0x5A0D, 	/* 0x8AB8 to 0x8ABF */ 
0x5A0E, 0x5A0F, 0x5A10, 0x5A12, 0x5A14, 0x5A15, 0x5A16, 0x5A17, 	/* 0x8AC0 to 0x8AC7 */ 
0x5A19, 0x5A1A, 0x5A1B, 0x5A1D, 0x5A1E, 0x5A21, 0x5A22, 0x5A24, 	/* 0x8AC8 to 0x8ACF */ 
0x5A26, 0x5A27, 0x5A28, 0x5A2A, 0x5A2B, 0x5A2C, 0x5A2D, 0x5A2E, 	/* 0x8AD0 to 0x8AD7 */ 
0x5A2F, 0x5A30, 0x5A33, 0x5A35, 0x5A37, 0x5A38, 0x5A39, 0x5A3A, 	/* 0x8AD8 to 0x8ADF */ 
0x5A3B, 0x5A3D, 0x5A3E, 0x5A3F, 0x5A41, 0x5A42, 0x5A43, 0x5A44, 	/* 0x8AE0 to 0x8AE7 */ 
0x5A45, 0x5A47, 0x5A48, 0x5A4B, 0x5A4C, 0x5A4D, 0x5A4E, 0x5A4F, 	/* 0x8AE8 to 0x8AEF */ 
0x5A50, 0x5A51, 0x5A52, 0x5A53, 0x5A54, 0x5A56, 0x5A57, 0x5A58, 	/* 0x8AF0 to 0x8AF7 */ 
0x5A59, 0x5A5B, 0x5A5C, 0x5A5D, 0x5A5E, 0x5A5F, 0x5A60, 0x0000, 	/* 0x8AF8 to 0x8AFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B00 to 0x8B07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B08 to 0x8B0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B10 to 0x8B17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B18 to 0x8B1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B20 to 0x8B27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B28 to 0x8B2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B30 to 0x8B37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B38 to 0x8B3F */ 
0x5A61, 0x5A63, 0x5A64, 0x5A65, 0x5A66, 0x5A68, 0x5A69, 0x5A6B, 	/* 0x8B40 to 0x8B47 */ 
0x5A6C, 0x5A6D, 0x5A6E, 0x5A6F, 0x5A70, 0x5A71, 0x5A72, 0x5A73, 	/* 0x8B48 to 0x8B4F */ 
0x5A78, 0x5A79, 0x5A7B, 0x5A7C, 0x5A7D, 0x5A7E, 0x5A80, 0x5A81, 	/* 0x8B50 to 0x8B57 */ 
0x5A82, 0x5A83, 0x5A84, 0x5A85, 0x5A86, 0x5A87, 0x5A88, 0x5A89, 	/* 0x8B58 to 0x8B5F */ 
0x5A8A, 0x5A8B, 0x5A8C, 0x5A8D, 0x5A8E, 0x5A8F, 0x5A90, 0x5A91, 	/* 0x8B60 to 0x8B67 */ 
0x5A93, 0x5A94, 0x5A95, 0x5A96, 0x5A97, 0x5A98, 0x5A99, 0x5A9C, 	/* 0x8B68 to 0x8B6F */ 
0x5A9D, 0x5A9E, 0x5A9F, 0x5AA0, 0x5AA1, 0x5AA2, 0x5AA3, 0x5AA4, 	/* 0x8B70 to 0x8B77 */ 
0x5AA5, 0x5AA6, 0x5AA7, 0x5AA8, 0x5AA9, 0x5AAB, 0x5AAC, 0x0000, 	/* 0x8B78 to 0x8B7F */ 
0x5AAD, 0x5AAE, 0x5AAF, 0x5AB0, 0x5AB1, 0x5AB4, 0x5AB6, 0x5AB7, 	/* 0x8B80 to 0x8B87 */ 
0x5AB9, 0x5ABA, 0x5ABB, 0x5ABC, 0x5ABD, 0x5ABF, 0x5AC0, 0x5AC3, 	/* 0x8B88 to 0x8B8F */ 
0x5AC4, 0x5AC5, 0x5AC6, 0x5AC7, 0x5AC8, 0x5ACA, 0x5ACB, 0x5ACD, 	/* 0x8B90 to 0x8B97 */ 
0x5ACE, 0x5ACF, 0x5AD0, 0x5AD1, 0x5AD3, 0x5AD5, 0x5AD7, 0x5AD9, 	/* 0x8B98 to 0x8B9F */ 
0x5ADA, 0x5ADB, 0x5ADD, 0x5ADE, 0x5ADF, 0x5AE2, 0x5AE4, 0x5AE5, 	/* 0x8BA0 to 0x8BA7 */ 
0x5AE7, 0x5AE8, 0x5AEA, 0x5AEC, 0x5AED, 0x5AEE, 0x5AEF, 0x5AF0, 	/* 0x8BA8 to 0x8BAF */ 
0x5AF2, 0x5AF3, 0x5AF4, 0x5AF5, 0x5AF6, 0x5AF7, 0x5AF8, 0x5AF9, 	/* 0x8BB0 to 0x8BB7 */ 
0x5AFA, 0x5AFB, 0x5AFC, 0x5AFD, 0x5AFE, 0x5AFF, 0x5B00, 0x5B01, 	/* 0x8BB8 to 0x8BBF */ 
0x5B02, 0x5B03, 0x5B04, 0x5B05, 0x5B06, 0x5B07, 0x5B08, 0x5B0A, 	/* 0x8BC0 to 0x8BC7 */ 
0x5B0B, 0x5B0C, 0x5B0D, 0x5B0E, 0x5B0F, 0x5B10, 0x5B11, 0x5B12, 	/* 0x8BC8 to 0x8BCF */ 
0x5B13, 0x5B14, 0x5B15, 0x5B18, 0x5B19, 0x5B1A, 0x5B1B, 0x5B1C, 	/* 0x8BD0 to 0x8BD7 */ 
0x5B1D, 0x5B1E, 0x5B1F, 0x5B20, 0x5B21, 0x5B22, 0x5B23, 0x5B24, 	/* 0x8BD8 to 0x8BDF */ 
0x5B25, 0x5B26, 0x5B27, 0x5B28, 0x5B29, 0x5B2A, 0x5B2B, 0x5B2C, 	/* 0x8BE0 to 0x8BE7 */ 
0x5B2D, 0x5B2E, 0x5B2F, 0x5B30, 0x5B31, 0x5B33, 0x5B35, 0x5B36, 	/* 0x8BE8 to 0x8BEF */ 
0x5B38, 0x5B39, 0x5B3A, 0x5B3B, 0x5B3C, 0x5B3D, 0x5B3E, 0x5B3F, 	/* 0x8BF0 to 0x8BF7 */ 
0x5B41, 0x5B42, 0x5B43, 0x5B44, 0x5B45, 0x5B46, 0x5B47, 0x0000, 	/* 0x8BF8 to 0x8BFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C00 to 0x8C07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C08 to 0x8C0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C10 to 0x8C17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C18 to 0x8C1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C20 to 0x8C27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C28 to 0x8C2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C30 to 0x8C37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C38 to 0x8C3F */ 
0x5B48, 0x5B49, 0x5B4A, 0x5B4B, 0x5B4C, 0x5B4D, 0x5B4E, 0x5B4F, 	/* 0x8C40 to 0x8C47 */ 
0x5B52, 0x5B56, 0x5B5E, 0x5B60, 0x5B61, 0x5B67, 0x5B68, 0x5B6B, 	/* 0x8C48 to 0x8C4F */ 
0x5B6D, 0x5B6E, 0x5B6F, 0x5B72, 0x5B74, 0x5B76, 0x5B77, 0x5B78, 	/* 0x8C50 to 0x8C57 */ 
0x5B79, 0x5B7B, 0x5B7C, 0x5B7E, 0x5B7F, 0x5B82, 0x5B86, 0x5B8A, 	/* 0x8C58 to 0x8C5F */ 
0x5B8D, 0x5B8E, 0x5B90, 0x5B91, 0x5B92, 0x5B94, 0x5B96, 0x5B9F, 	/* 0x8C60 to 0x8C67 */ 
0x5BA7, 0x5BA8, 0x5BA9, 0x5BAC, 0x5BAD, 0x5BAE, 0x5BAF, 0x5BB1, 	/* 0x8C68 to 0x8C6F */ 
0x5BB2, 0x5BB7, 0x5BBA, 0x5BBB, 0x5BBC, 0x5BC0, 0x5BC1, 0x5BC3, 	/* 0x8C70 to 0x8C77 */ 
0x5BC8, 0x5BC9, 0x5BCA, 0x5BCB, 0x5BCD, 0x5BCE, 0x5BCF, 0x0000, 	/* 0x8C78 to 0x8C7F */ 
0x5BD1, 0x5BD4, 0x5BD5, 0x5BD6, 0x5BD7, 0x5BD8, 0x5BD9, 0x5BDA, 	/* 0x8C80 to 0x8C87 */ 
0x5BDB, 0x5BDC, 0x5BE0, 0x5BE2, 0x5BE3, 0x5BE6, 0x5BE7, 0x5BE9, 	/* 0x8C88 to 0x8C8F */ 
0x5BEA, 0x5BEB, 0x5BEC, 0x5BED, 0x5BEF, 0x5BF1, 0x5BF2, 0x5BF3, 	/* 0x8C90 to 0x8C97 */ 
0x5BF4, 0x5BF5, 0x5BF6, 0x5BF7, 0x5BFD, 0x5BFE, 0x5C00, 0x5C02, 	/* 0x8C98 to 0x8C9F */ 
0x5C03, 0x5C05, 0x5C07, 0x5C08, 0x5C0B, 0x5C0C, 0x5C0D, 0x5C0E, 	/* 0x8CA0 to 0x8CA7 */ 
0x5C10, 0x5C12, 0x5C13, 0x5C17, 0x5C19, 0x5C1B, 0x5C1E, 0x5C1F, 	/* 0x8CA8 to 0x8CAF */ 
0x5C20, 0x5C21, 0x5C23, 0x5C26, 0x5C28, 0x5C29, 0x5C2A, 0x5C2B, 	/* 0x8CB0 to 0x8CB7 */ 
0x5C2D, 0x5C2E, 0x5C2F, 0x5C30, 0x5C32, 0x5C33, 0x5C35, 0x5C36, 	/* 0x8CB8 to 0x8CBF */ 
0x5C37, 0x5C43, 0x5C44, 0x5C46, 0x5C47, 0x5C4C, 0x5C4D, 0x5C52, 	/* 0x8CC0 to 0x8CC7 */ 
0x5C53, 0x5C54, 0x5C56, 0x5C57, 0x5C58, 0x5C5A, 0x5C5B, 0x5C5C, 	/* 0x8CC8 to 0x8CCF */ 
0x5C5D, 0x5C5F, 0x5C62, 0x5C64, 0x5C67, 0x5C68, 0x5C69, 0x5C6A, 	/* 0x8CD0 to 0x8CD7 */ 
0x5C6B, 0x5C6C, 0x5C6D, 0x5C70, 0x5C72, 0x5C73, 0x5C74, 0x5C75, 	/* 0x8CD8 to 0x8CDF */ 
0x5C76, 0x5C77, 0x5C78, 0x5C7B, 0x5C7C, 0x5C7D, 0x5C7E, 0x5C80, 	/* 0x8CE0 to 0x8CE7 */ 
0x5C83, 0x5C84, 0x5C85, 0x5C86, 0x5C87, 0x5C89, 0x5C8A, 0x5C8B, 	/* 0x8CE8 to 0x8CEF */ 
0x5C8E, 0x5C8F, 0x5C92, 0x5C93, 0x5C95, 0x5C9D, 0x5C9E, 0x5C9F, 	/* 0x8CF0 to 0x8CF7 */ 
0x5CA0, 0x5CA1, 0x5CA4, 0x5CA5, 0x5CA6, 0x5CA7, 0x5CA8, 0x0000, 	/* 0x8CF8 to 0x8CFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D00 to 0x8D07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D08 to 0x8D0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D10 to 0x8D17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D18 to 0x8D1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D20 to 0x8D27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D28 to 0x8D2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D30 to 0x8D37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D38 to 0x8D3F */ 
0x5CAA, 0x5CAE, 0x5CAF, 0x5CB0, 0x5CB2, 0x5CB4, 0x5CB6, 0x5CB9, 	/* 0x8D40 to 0x8D47 */ 
0x5CBA, 0x5CBB, 0x5CBC, 0x5CBE, 0x5CC0, 0x5CC2, 0x5CC3, 0x5CC5, 	/* 0x8D48 to 0x8D4F */ 
0x5CC6, 0x5CC7, 0x5CC8, 0x5CC9, 0x5CCA, 0x5CCC, 0x5CCD, 0x5CCE, 	/* 0x8D50 to 0x8D57 */ 
0x5CCF, 0x5CD0, 0x5CD1, 0x5CD3, 0x5CD4, 0x5CD5, 0x5CD6, 0x5CD7, 	/* 0x8D58 to 0x8D5F */ 
0x5CD8, 0x5CDA, 0x5CDB, 0x5CDC, 0x5CDD, 0x5CDE, 0x5CDF, 0x5CE0, 	/* 0x8D60 to 0x8D67 */ 
0x5CE2, 0x5CE3, 0x5CE7, 0x5CE9, 0x5CEB, 0x5CEC, 0x5CEE, 0x5CEF, 	/* 0x8D68 to 0x8D6F */ 
0x5CF1, 0x5CF2, 0x5CF3, 0x5CF4, 0x5CF5, 0x5CF6, 0x5CF7, 0x5CF8, 	/* 0x8D70 to 0x8D77 */ 
0x5CF9, 0x5CFA, 0x5CFC, 0x5CFD, 0x5CFE, 0x5CFF, 0x5D00, 0x0000, 	/* 0x8D78 to 0x8D7F */ 
0x5D01, 0x5D04, 0x5D05, 0x5D08, 0x5D09, 0x5D0A, 0x5D0B, 0x5D0C, 	/* 0x8D80 to 0x8D87 */ 
0x5D0D, 0x5D0F, 0x5D10, 0x5D11, 0x5D12, 0x5D13, 0x5D15, 0x5D17, 	/* 0x8D88 to 0x8D8F */ 
0x5D18, 0x5D19, 0x5D1A, 0x5D1C, 0x5D1D, 0x5D1F, 0x5D20, 0x5D21, 	/* 0x8D90 to 0x8D97 */ 
0x5D22, 0x5D23, 0x5D25, 0x5D28, 0x5D2A, 0x5D2B, 0x5D2C, 0x5D2F, 	/* 0x8D98 to 0x8D9F */ 
0x5D30, 0x5D31, 0x5D32, 0x5D33, 0x5D35, 0x5D36, 0x5D37, 0x5D38, 	/* 0x8DA0 to 0x8DA7 */ 
0x5D39, 0x5D3A, 0x5D3B, 0x5D3C, 0x5D3F, 0x5D40, 0x5D41, 0x5D42, 	/* 0x8DA8 to 0x8DAF */ 
0x5D43, 0x5D44, 0x5D45, 0x5D46, 0x5D48, 0x5D49, 0x5D4D, 0x5D4E, 	/* 0x8DB0 to 0x8DB7 */ 
0x5D4F, 0x5D50, 0x5D51, 0x5D52, 0x5D53, 0x5D54, 0x5D55, 0x5D56, 	/* 0x8DB8 to 0x8DBF */ 
0x5D57, 0x5D59, 0x5D5A, 0x5D5C, 0x5D5E, 0x5D5F, 0x5D60, 0x5D61, 	/* 0x8DC0 to 0x8DC7 */ 
0x5D62, 0x5D63, 0x5D64, 0x5D65, 0x5D66, 0x5D67, 0x5D68, 0x5D6A, 	/* 0x8DC8 to 0x8DCF */ 
0x5D6D, 0x5D6E, 0x5D70, 0x5D71, 0x5D72, 0x5D73, 0x5D75, 0x5D76, 	/* 0x8DD0 to 0x8DD7 */ 
0x5D77, 0x5D78, 0x5D79, 0x5D7A, 0x5D7B, 0x5D7C, 0x5D7D, 0x5D7E, 	/* 0x8DD8 to 0x8DDF */ 
0x5D7F, 0x5D80, 0x5D81, 0x5D83, 0x5D84, 0x5D85, 0x5D86, 0x5D87, 	/* 0x8DE0 to 0x8DE7 */ 
0x5D88, 0x5D89, 0x5D8A, 0x5D8B, 0x5D8C, 0x5D8D, 0x5D8E, 0x5D8F, 	/* 0x8DE8 to 0x8DEF */ 
0x5D90, 0x5D91, 0x5D92, 0x5D93, 0x5D94, 0x5D95, 0x5D96, 0x5D97, 	/* 0x8DF0 to 0x8DF7 */ 
0x5D98, 0x5D9A, 0x5D9B, 0x5D9C, 0x5D9E, 0x5D9F, 0x5DA0, 0x0000, 	/* 0x8DF8 to 0x8DFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E00 to 0x8E07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E08 to 0x8E0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E10 to 0x8E17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E18 to 0x8E1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E20 to 0x8E27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E28 to 0x8E2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E30 to 0x8E37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E38 to 0x8E3F */ 
0x5DA1, 0x5DA2, 0x5DA3, 0x5DA4, 0x5DA5, 0x5DA6, 0x5DA7, 0x5DA8, 	/* 0x8E40 to 0x8E47 */ 
0x5DA9, 0x5DAA, 0x5DAB, 0x5DAC, 0x5DAD, 0x5DAE, 0x5DAF, 0x5DB0, 	/* 0x8E48 to 0x8E4F */ 
0x5DB1, 0x5DB2, 0x5DB3, 0x5DB4, 0x5DB5, 0x5DB6, 0x5DB8, 0x5DB9, 	/* 0x8E50 to 0x8E57 */ 
0x5DBA, 0x5DBB, 0x5DBC, 0x5DBD, 0x5DBE, 0x5DBF, 0x5DC0, 0x5DC1, 	/* 0x8E58 to 0x8E5F */ 
0x5DC2, 0x5DC3, 0x5DC4, 0x5DC6, 0x5DC7, 0x5DC8, 0x5DC9, 0x5DCA, 	/* 0x8E60 to 0x8E67 */ 
0x5DCB, 0x5DCC, 0x5DCE, 0x5DCF, 0x5DD0, 0x5DD1, 0x5DD2, 0x5DD3, 	/* 0x8E68 to 0x8E6F */ 
0x5DD4, 0x5DD5, 0x5DD6, 0x5DD7, 0x5DD8, 0x5DD9, 0x5DDA, 0x5DDC, 	/* 0x8E70 to 0x8E77 */ 
0x5DDF, 0x5DE0, 0x5DE3, 0x5DE4, 0x5DEA, 0x5DEC, 0x5DED, 0x0000, 	/* 0x8E78 to 0x8E7F */ 
0x5DF0, 0x5DF5, 0x5DF6, 0x5DF8, 0x5DF9, 0x5DFA, 0x5DFB, 0x5DFC, 	/* 0x8E80 to 0x8E87 */ 
0x5DFF, 0x5E00, 0x5E04, 0x5E07, 0x5E09, 0x5E0A, 0x5E0B, 0x5E0D, 	/* 0x8E88 to 0x8E8F */ 
0x5E0E, 0x5E12, 0x5E13, 0x5E17, 0x5E1E, 0x5E1F, 0x5E20, 0x5E21, 	/* 0x8E90 to 0x8E97 */ 
0x5E22, 0x5E23, 0x5E24, 0x5E25, 0x5E28, 0x5E29, 0x5E2A, 0x5E2B, 	/* 0x8E98 to 0x8E9F */ 
0x5E2C, 0x5E2F, 0x5E30, 0x5E32, 0x5E33, 0x5E34, 0x5E35, 0x5E36, 	/* 0x8EA0 to 0x8EA7 */ 
0x5E39, 0x5E3A, 0x5E3E, 0x5E3F, 0x5E40, 0x5E41, 0x5E43, 0x5E46, 	/* 0x8EA8 to 0x8EAF */ 
0x5E47, 0x5E48, 0x5E49, 0x5E4A, 0x5E4B, 0x5E4D, 0x5E4E, 0x5E4F, 	/* 0x8EB0 to 0x8EB7 */ 
0x5E50, 0x5E51, 0x5E52, 0x5E53, 0x5E56, 0x5E57, 0x5E58, 0x5E59, 	/* 0x8EB8 to 0x8EBF */ 
0x5E5A, 0x5E5C, 0x5E5D, 0x5E5F, 0x5E60, 0x5E63, 0x5E64, 0x5E65, 	/* 0x8EC0 to 0x8EC7 */ 
0x5E66, 0x5E67, 0x5E68, 0x5E69, 0x5E6A, 0x5E6B, 0x5E6C, 0x5E6D, 	/* 0x8EC8 to 0x8ECF */ 
0x5E6E, 0x5E6F, 0x5E70, 0x5E71, 0x5E75, 0x5E77, 0x5E79, 0x5E7E, 	/* 0x8ED0 to 0x8ED7 */ 
0x5E81, 0x5E82, 0x5E83, 0x5E85, 0x5E88, 0x5E89, 0x5E8C, 0x5E8D, 	/* 0x8ED8 to 0x8EDF */ 
0x5E8E, 0x5E92, 0x5E98, 0x5E9B, 0x5E9D, 0x5EA1, 0x5EA2, 0x5EA3, 	/* 0x8EE0 to 0x8EE7 */ 
0x5EA4, 0x5EA8, 0x5EA9, 0x5EAA, 0x5EAB, 0x5EAC, 0x5EAE, 0x5EAF, 	/* 0x8EE8 to 0x8EEF */ 
0x5EB0, 0x5EB1, 0x5EB2, 0x5EB4, 0x5EBA, 0x5EBB, 0x5EBC, 0x5EBD, 	/* 0x8EF0 to 0x8EF7 */ 
0x5EBF, 0x5EC0, 0x5EC1, 0x5EC2, 0x5EC3, 0x5EC4, 0x5EC5, 0x0000, 	/* 0x8EF8 to 0x8EFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F00 to 0x8F07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F08 to 0x8F0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F10 to 0x8F17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F18 to 0x8F1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F20 to 0x8F27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F28 to 0x8F2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F30 to 0x8F37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F38 to 0x8F3F */ 
0x5EC6, 0x5EC7, 0x5EC8, 0x5ECB, 0x5ECC, 0x5ECD, 0x5ECE, 0x5ECF, 	/* 0x8F40 to 0x8F47 */ 
0x5ED0, 0x5ED4, 0x5ED5, 0x5ED7, 0x5ED8, 0x5ED9, 0x5EDA, 0x5EDC, 	/* 0x8F48 to 0x8F4F */ 
0x5EDD, 0x5EDE, 0x5EDF, 0x5EE0, 0x5EE1, 0x5EE2, 0x5EE3, 0x5EE4, 	/* 0x8F50 to 0x8F57 */ 
0x5EE5, 0x5EE6, 0x5EE7, 0x5EE9, 0x5EEB, 0x5EEC, 0x5EED, 0x5EEE, 	/* 0x8F58 to 0x8F5F */ 
0x5EEF, 0x5EF0, 0x5EF1, 0x5EF2, 0x5EF3, 0x5EF5, 0x5EF8, 0x5EF9, 	/* 0x8F60 to 0x8F67 */ 
0x5EFB, 0x5EFC, 0x5EFD, 0x5F05, 0x5F06, 0x5F07, 0x5F09, 0x5F0C, 	/* 0x8F68 to 0x8F6F */ 
0x5F0D, 0x5F0E, 0x5F10, 0x5F12, 0x5F14, 0x5F16, 0x5F19, 0x5F1A, 	/* 0x8F70 to 0x8F77 */ 
0x5F1C, 0x5F1D, 0x5F1E, 0x5F21, 0x5F22, 0x5F23, 0x5F24, 0x0000, 	/* 0x8F78 to 0x8F7F */ 
0x5F28, 0x5F2B, 0x5F2C, 0x5F2E, 0x5F30, 0x5F32, 0x5F33, 0x5F34, 	/* 0x8F80 to 0x8F87 */ 
0x5F35, 0x5F36, 0x5F37, 0x5F38, 0x5F3B, 0x5F3D, 0x5F3E, 0x5F3F, 	/* 0x8F88 to 0x8F8F */ 
0x5F41, 0x5F42, 0x5F43, 0x5F44, 0x5F45, 0x5F46, 0x5F47, 0x5F48, 	/* 0x8F90 to 0x8F97 */ 
0x5F49, 0x5F4A, 0x5F4B, 0x5F4C, 0x5F4D, 0x5F4E, 0x5F4F, 0x5F51, 	/* 0x8F98 to 0x8F9F */ 
0x5F54, 0x5F59, 0x5F5A, 0x5F5B, 0x5F5C, 0x5F5E, 0x5F5F, 0x5F60, 	/* 0x8FA0 to 0x8FA7 */ 
0x5F63, 0x5F65, 0x5F67, 0x5F68, 0x5F6B, 0x5F6E, 0x5F6F, 0x5F72, 	/* 0x8FA8 to 0x8FAF */ 
0x5F74, 0x5F75, 0x5F76, 0x5F78, 0x5F7A, 0x5F7D, 0x5F7E, 0x5F7F, 	/* 0x8FB0 to 0x8FB7 */ 
0x5F83, 0x5F86, 0x5F8D, 0x5F8E, 0x5F8F, 0x5F91, 0x5F93, 0x5F94, 	/* 0x8FB8 to 0x8FBF */ 
0x5F96, 0x5F9A, 0x5F9B, 0x5F9D, 0x5F9E, 0x5F9F, 0x5FA0, 0x5FA2, 	/* 0x8FC0 to 0x8FC7 */ 
0x5FA3, 0x5FA4, 0x5FA5, 0x5FA6, 0x5FA7, 0x5FA9, 0x5FAB, 0x5FAC, 	/* 0x8FC8 to 0x8FCF */ 
0x5FAF, 0x5FB0, 0x5FB1, 0x5FB2, 0x5FB3, 0x5FB4, 0x5FB6, 0x5FB8, 	/* 0x8FD0 to 0x8FD7 */ 
0x5FB9, 0x5FBA, 0x5FBB, 0x5FBE, 0x5FBF, 0x5FC0, 0x5FC1, 0x5FC2, 	/* 0x8FD8 to 0x8FDF */ 
0x5FC7, 0x5FC8, 0x5FCA, 0x5FCB, 0x5FCE, 0x5FD3, 0x5FD4, 0x5FD5, 	/* 0x8FE0 to 0x8FE7 */ 
0x5FDA, 0x5FDB, 0x5FDC, 0x5FDE, 0x5FDF, 0x5FE2, 0x5FE3, 0x5FE5, 	/* 0x8FE8 to 0x8FEF */ 
0x5FE6, 0x5FE8, 0x5FE9, 0x5FEC, 0x5FEF, 0x5FF0, 0x5FF2, 0x5FF3, 	/* 0x8FF0 to 0x8FF7 */ 
0x5FF4, 0x5FF6, 0x5FF7, 0x5FF9, 0x5FFA, 0x5FFC, 0x6007, 0x0000, 	/* 0x8FF8 to 0x8FFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9000 to 0x9007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9008 to 0x900F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9010 to 0x9017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9018 to 0x901F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9020 to 0x9027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9028 to 0x902F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9030 to 0x9037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9038 to 0x903F */ 
0x6008, 0x6009, 0x600B, 0x600C, 0x6010, 0x6011, 0x6013, 0x6017, 	/* 0x9040 to 0x9047 */ 
0x6018, 0x601A, 0x601E, 0x601F, 0x6022, 0x6023, 0x6024, 0x602C, 	/* 0x9048 to 0x904F */ 
0x602D, 0x602E, 0x6030, 0x6031, 0x6032, 0x6033, 0x6034, 0x6036, 	/* 0x9050 to 0x9057 */ 
0x6037, 0x6038, 0x6039, 0x603A, 0x603D, 0x603E, 0x6040, 0x6044, 	/* 0x9058 to 0x905F */ 
0x6045, 0x6046, 0x6047, 0x6048, 0x6049, 0x604A, 0x604C, 0x604E, 	/* 0x9060 to 0x9067 */ 
0x604F, 0x6051, 0x6053, 0x6054, 0x6056, 0x6057, 0x6058, 0x605B, 	/* 0x9068 to 0x906F */ 
0x605C, 0x605E, 0x605F, 0x6060, 0x6061, 0x6065, 0x6066, 0x606E, 	/* 0x9070 to 0x9077 */ 
0x6071, 0x6072, 0x6074, 0x6075, 0x6077, 0x607E, 0x6080, 0x0000, 	/* 0x9078 to 0x907F */ 
0x6081, 0x6082, 0x6085, 0x6086, 0x6087, 0x6088, 0x608A, 0x608B, 	/* 0x9080 to 0x9087 */ 
0x608E, 0x608F, 0x6090, 0x6091, 0x6093, 0x6095, 0x6097, 0x6098, 	/* 0x9088 to 0x908F */ 
0x6099, 0x609C, 0x609E, 0x60A1, 0x60A2, 0x60A4, 0x60A5, 0x60A7, 	/* 0x9090 to 0x9097 */ 
0x60A9, 0x60AA, 0x60AE, 0x60B0, 0x60B3, 0x60B5, 0x60B6, 0x60B7, 	/* 0x9098 to 0x909F */ 
0x60B9, 0x60BA, 0x60BD, 0x60BE, 0x60BF, 0x60C0, 0x60C1, 0x60C2, 	/* 0x90A0 to 0x90A7 */ 
0x60C3, 0x60C4, 0x60C7, 0x60C8, 0x60C9, 0x60CC, 0x60CD, 0x60CE, 	/* 0x90A8 to 0x90AF */ 
0x60CF, 0x60D0, 0x60D2, 0x60D3, 0x60D4, 0x60D6, 0x60D7, 0x60D9, 	/* 0x90B0 to 0x90B7 */ 
0x60DB, 0x60DE, 0x60E1, 0x60E2, 0x60E3, 0x60E4, 0x60E5, 0x60EA, 	/* 0x90B8 to 0x90BF */ 
0x60F1, 0x60F2, 0x60F5, 0x60F7, 0x60F8, 0x60FB, 0x60FC, 0x60FD, 	/* 0x90C0 to 0x90C7 */ 
0x60FE, 0x60FF, 0x6102, 0x6103, 0x6104, 0x6105, 0x6107, 0x610A, 	/* 0x90C8 to 0x90CF */ 
0x610B, 0x610C, 0x6110, 0x6111, 0x6112, 0x6113, 0x6114, 0x6116, 	/* 0x90D0 to 0x90D7 */ 
0x6117, 0x6118, 0x6119, 0x611B, 0x611C, 0x611D, 0x611E, 0x6121, 	/* 0x90D8 to 0x90DF */ 
0x6122, 0x6125, 0x6128, 0x6129, 0x612A, 0x612C, 0x612D, 0x612E, 	/* 0x90E0 to 0x90E7 */ 
0x612F, 0x6130, 0x6131, 0x6132, 0x6133, 0x6134, 0x6135, 0x6136, 	/* 0x90E8 to 0x90EF */ 
0x6137, 0x6138, 0x6139, 0x613A, 0x613B, 0x613C, 0x613D, 0x613E, 	/* 0x90F0 to 0x90F7 */ 
0x6140, 0x6141, 0x6142, 0x6143, 0x6144, 0x6145, 0x6146, 0x0000, 	/* 0x90F8 to 0x90FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9100 to 0x9107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9108 to 0x910F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9110 to 0x9117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9118 to 0x911F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9120 to 0x9127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9128 to 0x912F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9130 to 0x9137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9138 to 0x913F */ 
0x6147, 0x6149, 0x614B, 0x614D, 0x614F, 0x6150, 0x6152, 0x6153, 	/* 0x9140 to 0x9147 */ 
0x6154, 0x6156, 0x6157, 0x6158, 0x6159, 0x615A, 0x615B, 0x615C, 	/* 0x9148 to 0x914F */ 
0x615E, 0x615F, 0x6160, 0x6161, 0x6163, 0x6164, 0x6165, 0x6166, 	/* 0x9150 to 0x9157 */ 
0x6169, 0x616A, 0x616B, 0x616C, 0x616D, 0x616E, 0x616F, 0x6171, 	/* 0x9158 to 0x915F */ 
0x6172, 0x6173, 0x6174, 0x6176, 0x6178, 0x6179, 0x617A, 0x617B, 	/* 0x9160 to 0x9167 */ 
0x617C, 0x617D, 0x617E, 0x617F, 0x6180, 0x6181, 0x6182, 0x6183, 	/* 0x9168 to 0x916F */ 
0x6184, 0x6185, 0x6186, 0x6187, 0x6188, 0x6189, 0x618A, 0x618C, 	/* 0x9170 to 0x9177 */ 
0x618D, 0x618F, 0x6190, 0x6191, 0x6192, 0x6193, 0x6195, 0x0000, 	/* 0x9178 to 0x917F */ 
0x6196, 0x6197, 0x6198, 0x6199, 0x619A, 0x619B, 0x619C, 0x619E, 	/* 0x9180 to 0x9187 */ 
0x619F, 0x61A0, 0x61A1, 0x61A2, 0x61A3, 0x61A4, 0x61A5, 0x61A6, 	/* 0x9188 to 0x918F */ 
0x61AA, 0x61AB, 0x61AD, 0x61AE, 0x61AF, 0x61B0, 0x61B1, 0x61B2, 	/* 0x9190 to 0x9197 */ 
0x61B3, 0x61B4, 0x61B5, 0x61B6, 0x61B8, 0x61B9, 0x61BA, 0x61BB, 	/* 0x9198 to 0x919F */ 
0x61BC, 0x61BD, 0x61BF, 0x61C0, 0x61C1, 0x61C3, 0x61C4, 0x61C5, 	/* 0x91A0 to 0x91A7 */ 
0x61C6, 0x61C7, 0x61C9, 0x61CC, 0x61CD, 0x61CE, 0x61CF, 0x61D0, 	/* 0x91A8 to 0x91AF */ 
0x61D3, 0x61D5, 0x61D6, 0x61D7, 0x61D8, 0x61D9, 0x61DA, 0x61DB, 	/* 0x91B0 to 0x91B7 */ 
0x61DC, 0x61DD, 0x61DE, 0x61DF, 0x61E0, 0x61E1, 0x61E2, 0x61E3, 	/* 0x91B8 to 0x91BF */ 
0x61E4, 0x61E5, 0x61E7, 0x61E8, 0x61E9, 0x61EA, 0x61EB, 0x61EC, 	/* 0x91C0 to 0x91C7 */ 
0x61ED, 0x61EE, 0x61EF, 0x61F0, 0x61F1, 0x61F2, 0x61F3, 0x61F4, 	/* 0x91C8 to 0x91CF */ 
0x61F6, 0x61F7, 0x61F8, 0x61F9, 0x61FA, 0x61FB, 0x61FC, 0x61FD, 	/* 0x91D0 to 0x91D7 */ 
0x61FE, 0x6200, 0x6201, 0x6202, 0x6203, 0x6204, 0x6205, 0x6207, 	/* 0x91D8 to 0x91DF */ 
0x6209, 0x6213, 0x6214, 0x6219, 0x621C, 0x621D, 0x621E, 0x6220, 	/* 0x91E0 to 0x91E7 */ 
0x6223, 0x6226, 0x6227, 0x6228, 0x6229, 0x622B, 0x622D, 0x622F, 	/* 0x91E8 to 0x91EF */ 
0x6230, 0x6231, 0x6232, 0x6235, 0x6236, 0x6238, 0x6239, 0x623A, 	/* 0x91F0 to 0x91F7 */ 
0x623B, 0x623C, 0x6242, 0x6244, 0x6245, 0x6246, 0x624A, 0x0000, 	/* 0x91F8 to 0x91FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9200 to 0x9207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9208 to 0x920F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9210 to 0x9217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9218 to 0x921F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9220 to 0x9227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9228 to 0x922F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9230 to 0x9237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9238 to 0x923F */ 
0x624F, 0x6250, 0x6255, 0x6256, 0x6257, 0x6259, 0x625A, 0x625C, 	/* 0x9240 to 0x9247 */ 
0x625D, 0x625E, 0x625F, 0x6260, 0x6261, 0x6262, 0x6264, 0x6265, 	/* 0x9248 to 0x924F */ 
0x6268, 0x6271, 0x6272, 0x6274, 0x6275, 0x6277, 0x6278, 0x627A, 	/* 0x9250 to 0x9257 */ 
0x627B, 0x627D, 0x6281, 0x6282, 0x6283, 0x6285, 0x6286, 0x6287, 	/* 0x9258 to 0x925F */ 
0x6288, 0x628B, 0x628C, 0x628D, 0x628E, 0x628F, 0x6290, 0x6294, 	/* 0x9260 to 0x9267 */ 
0x6299, 0x629C, 0x629D, 0x629E, 0x62A3, 0x62A6, 0x62A7, 0x62A9, 	/* 0x9268 to 0x926F */ 
0x62AA, 0x62AD, 0x62AE, 0x62AF, 0x62B0, 0x62B2, 0x62B3, 0x62B4, 	/* 0x9270 to 0x9277 */ 
0x62B6, 0x62B7, 0x62B8, 0x62BA, 0x62BE, 0x62C0, 0x62C1, 0x0000, 	/* 0x9278 to 0x927F */ 
0x62C3, 0x62CB, 0x62CF, 0x62D1, 0x62D5, 0x62DD, 0x62DE, 0x62E0, 	/* 0x9280 to 0x9287 */ 
0x62E1, 0x62E4, 0x62EA, 0x62EB, 0x62F0, 0x62F2, 0x62F5, 0x62F8, 	/* 0x9288 to 0x928F */ 
0x62F9, 0x62FA, 0x62FB, 0x6300, 0x6303, 0x6304, 0x6305, 0x6306, 	/* 0x9290 to 0x9297 */ 
0x630A, 0x630B, 0x630C, 0x630D, 0x630F, 0x6310, 0x6312, 0x6313, 	/* 0x9298 to 0x929F */ 
0x6314, 0x6315, 0x6317, 0x6318, 0x6319, 0x631C, 0x6326, 0x6327, 	/* 0x92A0 to 0x92A7 */ 
0x6329, 0x632C, 0x632D, 0x632E, 0x6330, 0x6331, 0x6333, 0x6334, 	/* 0x92A8 to 0x92AF */ 
0x6335, 0x6336, 0x6337, 0x6338, 0x633B, 0x633C, 0x633E, 0x633F, 	/* 0x92B0 to 0x92B7 */ 
0x6340, 0x6341, 0x6344, 0x6347, 0x6348, 0x634A, 0x6351, 0x6352, 	/* 0x92B8 to 0x92BF */ 
0x6353, 0x6354, 0x6356, 0x6357, 0x6358, 0x6359, 0x635A, 0x635B, 	/* 0x92C0 to 0x92C7 */ 
0x635C, 0x635D, 0x6360, 0x6364, 0x6365, 0x6366, 0x6368, 0x636A, 	/* 0x92C8 to 0x92CF */ 
0x636B, 0x636C, 0x636F, 0x6370, 0x6372, 0x6373, 0x6374, 0x6375, 	/* 0x92D0 to 0x92D7 */ 
0x6378, 0x6379, 0x637C, 0x637D, 0x637E, 0x637F, 0x6381, 0x6383, 	/* 0x92D8 to 0x92DF */ 
0x6384, 0x6385, 0x6386, 0x638B, 0x638D, 0x6391, 0x6393, 0x6394, 	/* 0x92E0 to 0x92E7 */ 
0x6395, 0x6397, 0x6399, 0x639A, 0x639B, 0x639C, 0x639D, 0x639E, 	/* 0x92E8 to 0x92EF */ 
0x639F, 0x63A1, 0x63A4, 0x63A6, 0x63AB, 0x63AF, 0x63B1, 0x63B2, 	/* 0x92F0 to 0x92F7 */ 
0x63B5, 0x63B6, 0x63B9, 0x63BB, 0x63BD, 0x63BF, 0x63C0, 0x0000, 	/* 0x92F8 to 0x92FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9300 to 0x9307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9308 to 0x930F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9310 to 0x9317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9318 to 0x931F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9320 to 0x9327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9328 to 0x932F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9330 to 0x9337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9338 to 0x933F */ 
0x63C1, 0x63C2, 0x63C3, 0x63C5, 0x63C7, 0x63C8, 0x63CA, 0x63CB, 	/* 0x9340 to 0x9347 */ 
0x63CC, 0x63D1, 0x63D3, 0x63D4, 0x63D5, 0x63D7, 0x63D8, 0x63D9, 	/* 0x9348 to 0x934F */ 
0x63DA, 0x63DB, 0x63DC, 0x63DD, 0x63DF, 0x63E2, 0x63E4, 0x63E5, 	/* 0x9350 to 0x9357 */ 
0x63E6, 0x63E7, 0x63E8, 0x63EB, 0x63EC, 0x63EE, 0x63EF, 0x63F0, 	/* 0x9358 to 0x935F */ 
0x63F1, 0x63F3, 0x63F5, 0x63F7, 0x63F9, 0x63FA, 0x63FB, 0x63FC, 	/* 0x9360 to 0x9367 */ 
0x63FE, 0x6403, 0x6404, 0x6406, 0x6407, 0x6408, 0x6409, 0x640A, 	/* 0x9368 to 0x936F */ 
0x640D, 0x640E, 0x6411, 0x6412, 0x6415, 0x6416, 0x6417, 0x6418, 	/* 0x9370 to 0x9377 */ 
0x6419, 0x641A, 0x641D, 0x641F, 0x6422, 0x6423, 0x6424, 0x0000, 	/* 0x9378 to 0x937F */ 
0x6425, 0x6427, 0x6428, 0x6429, 0x642B, 0x642E, 0x642F, 0x6430, 	/* 0x9380 to 0x9387 */ 
0x6431, 0x6432, 0x6433, 0x6435, 0x6436, 0x6437, 0x6438, 0x6439, 	/* 0x9388 to 0x938F */ 
0x643B, 0x643C, 0x643E, 0x6440, 0x6442, 0x6443, 0x6449, 0x644B, 	/* 0x9390 to 0x9397 */ 
0x644C, 0x644D, 0x644E, 0x644F, 0x6450, 0x6451, 0x6453, 0x6455, 	/* 0x9398 to 0x939F */ 
0x6456, 0x6457, 0x6459, 0x645A, 0x645B, 0x645C, 0x645D, 0x645F, 	/* 0x93A0 to 0x93A7 */ 
0x6460, 0x6461, 0x6462, 0x6463, 0x6464, 0x6465, 0x6466, 0x6468, 	/* 0x93A8 to 0x93AF */ 
0x646A, 0x646B, 0x646C, 0x646E, 0x646F, 0x6470, 0x6471, 0x6472, 	/* 0x93B0 to 0x93B7 */ 
0x6473, 0x6474, 0x6475, 0x6476, 0x6477, 0x647B, 0x647C, 0x647D, 	/* 0x93B8 to 0x93BF */ 
0x647E, 0x647F, 0x6480, 0x6481, 0x6483, 0x6486, 0x6488, 0x6489, 	/* 0x93C0 to 0x93C7 */ 
0x648A, 0x648B, 0x648C, 0x648D, 0x648E, 0x648F, 0x6490, 0x6493, 	/* 0x93C8 to 0x93CF */ 
0x6494, 0x6497, 0x6498, 0x649A, 0x649B, 0x649C, 0x649D, 0x649F, 	/* 0x93D0 to 0x93D7 */ 
0x64A0, 0x64A1, 0x64A2, 0x64A3, 0x64A5, 0x64A6, 0x64A7, 0x64A8, 	/* 0x93D8 to 0x93DF */ 
0x64AA, 0x64AB, 0x64AF, 0x64B1, 0x64B2, 0x64B3, 0x64B4, 0x64B6, 	/* 0x93E0 to 0x93E7 */ 
0x64B9, 0x64BB, 0x64BD, 0x64BE, 0x64BF, 0x64C1, 0x64C3, 0x64C4, 	/* 0x93E8 to 0x93EF */ 
0x64C6, 0x64C7, 0x64C8, 0x64C9, 0x64CA, 0x64CB, 0x64CC, 0x64CF, 	/* 0x93F0 to 0x93F7 */ 
0x64D1, 0x64D3, 0x64D4, 0x64D5, 0x64D6, 0x64D9, 0x64DA, 0x0000, 	/* 0x93F8 to 0x93FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9400 to 0x9407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9408 to 0x940F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9410 to 0x9417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9418 to 0x941F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9420 to 0x9427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9428 to 0x942F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9430 to 0x9437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9438 to 0x943F */ 
0x64DB, 0x64DC, 0x64DD, 0x64DF, 0x64E0, 0x64E1, 0x64E3, 0x64E5, 	/* 0x9440 to 0x9447 */ 
0x64E7, 0x64E8, 0x64E9, 0x64EA, 0x64EB, 0x64EC, 0x64ED, 0x64EE, 	/* 0x9448 to 0x944F */ 
0x64EF, 0x64F0, 0x64F1, 0x64F2, 0x64F3, 0x64F4, 0x64F5, 0x64F6, 	/* 0x9450 to 0x9457 */ 
0x64F7, 0x64F8, 0x64F9, 0x64FA, 0x64FB, 0x64FC, 0x64FD, 0x64FE, 	/* 0x9458 to 0x945F */ 
0x64FF, 0x6501, 0x6502, 0x6503, 0x6504, 0x6505, 0x6506, 0x6507, 	/* 0x9460 to 0x9467 */ 
0x6508, 0x650A, 0x650B, 0x650C, 0x650D, 0x650E, 0x650F, 0x6510, 	/* 0x9468 to 0x946F */ 
0x6511, 0x6513, 0x6514, 0x6515, 0x6516, 0x6517, 0x6519, 0x651A, 	/* 0x9470 to 0x9477 */ 
0x651B, 0x651C, 0x651D, 0x651E, 0x651F, 0x6520, 0x6521, 0x0000, 	/* 0x9478 to 0x947F */ 
0x6522, 0x6523, 0x6524, 0x6526, 0x6527, 0x6528, 0x6529, 0x652A, 	/* 0x9480 to 0x9487 */ 
0x652C, 0x652D, 0x6530, 0x6531, 0x6532, 0x6533, 0x6537, 0x653A, 	/* 0x9488 to 0x948F */ 
0x653C, 0x653D, 0x6540, 0x6541, 0x6542, 0x6543, 0x6544, 0x6546, 	/* 0x9490 to 0x9497 */ 
0x6547, 0x654A, 0x654B, 0x654D, 0x654E, 0x6550, 0x6552, 0x6553, 	/* 0x9498 to 0x949F */ 
0x6554, 0x6557, 0x6558, 0x655A, 0x655C, 0x655F, 0x6560, 0x6561, 	/* 0x94A0 to 0x94A7 */ 
0x6564, 0x6565, 0x6567, 0x6568, 0x6569, 0x656A, 0x656D, 0x656E, 	/* 0x94A8 to 0x94AF */ 
0x656F, 0x6571, 0x6573, 0x6575, 0x6576, 0x6578, 0x6579, 0x657A, 	/* 0x94B0 to 0x94B7 */ 
0x657B, 0x657C, 0x657D, 0x657E, 0x657F, 0x6580, 0x6581, 0x6582, 	/* 0x94B8 to 0x94BF */ 
0x6583, 0x6584, 0x6585, 0x6586, 0x6588, 0x6589, 0x658A, 0x658D, 	/* 0x94C0 to 0x94C7 */ 
0x658E, 0x658F, 0x6592, 0x6594, 0x6595, 0x6596, 0x6598, 0x659A, 	/* 0x94C8 to 0x94CF */ 
0x659D, 0x659E, 0x65A0, 0x65A2, 0x65A3, 0x65A6, 0x65A8, 0x65AA, 	/* 0x94D0 to 0x94D7 */ 
0x65AC, 0x65AE, 0x65B1, 0x65B2, 0x65B3, 0x65B4, 0x65B5, 0x65B6, 	/* 0x94D8 to 0x94DF */ 
0x65B7, 0x65B8, 0x65BA, 0x65BB, 0x65BE, 0x65BF, 0x65C0, 0x65C2, 	/* 0x94E0 to 0x94E7 */ 
0x65C7, 0x65C8, 0x65C9, 0x65CA, 0x65CD, 0x65D0, 0x65D1, 0x65D3, 	/* 0x94E8 to 0x94EF */ 
0x65D4, 0x65D5, 0x65D8, 0x65D9, 0x65DA, 0x65DB, 0x65DC, 0x65DD, 	/* 0x94F0 to 0x94F7 */ 
0x65DE, 0x65DF, 0x65E1, 0x65E3, 0x65E4, 0x65EA, 0x65EB, 0x0000, 	/* 0x94F8 to 0x94FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9500 to 0x9507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9508 to 0x950F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9510 to 0x9517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9518 to 0x951F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9520 to 0x9527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9528 to 0x952F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9530 to 0x9537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9538 to 0x953F */ 
0x65F2, 0x65F3, 0x65F4, 0x65F5, 0x65F8, 0x65F9, 0x65FB, 0x65FC, 	/* 0x9540 to 0x9547 */ 
0x65FD, 0x65FE, 0x65FF, 0x6601, 0x6604, 0x6605, 0x6607, 0x6608, 	/* 0x9548 to 0x954F */ 
0x6609, 0x660B, 0x660D, 0x6610, 0x6611, 0x6612, 0x6616, 0x6617, 	/* 0x9550 to 0x9557 */ 
0x6618, 0x661A, 0x661B, 0x661C, 0x661E, 0x6621, 0x6622, 0x6623, 	/* 0x9558 to 0x955F */ 
0x6624, 0x6626, 0x6629, 0x662A, 0x662B, 0x662C, 0x662E, 0x6630, 	/* 0x9560 to 0x9567 */ 
0x6632, 0x6633, 0x6637, 0x6638, 0x6639, 0x663A, 0x663B, 0x663D, 	/* 0x9568 to 0x956F */ 
0x663F, 0x6640, 0x6642, 0x6644, 0x6645, 0x6646, 0x6647, 0x6648, 	/* 0x9570 to 0x9577 */ 
0x6649, 0x664A, 0x664D, 0x664E, 0x6650, 0x6651, 0x6658, 0x0000, 	/* 0x9578 to 0x957F */ 
0x6659, 0x665B, 0x665C, 0x665D, 0x665E, 0x6660, 0x6662, 0x6663, 	/* 0x9580 to 0x9587 */ 
0x6665, 0x6667, 0x6669, 0x666A, 0x666B, 0x666C, 0x666D, 0x6671, 	/* 0x9588 to 0x958F */ 
0x6672, 0x6673, 0x6675, 0x6678, 0x6679, 0x667B, 0x667C, 0x667D, 	/* 0x9590 to 0x9597 */ 
0x667F, 0x6680, 0x6681, 0x6683, 0x6685, 0x6686, 0x6688, 0x6689, 	/* 0x9598 to 0x959F */ 
0x668A, 0x668B, 0x668D, 0x668E, 0x668F, 0x6690, 0x6692, 0x6693, 	/* 0x95A0 to 0x95A7 */ 
0x6694, 0x6695, 0x6698, 0x6699, 0x669A, 0x669B, 0x669C, 0x669E, 	/* 0x95A8 to 0x95AF */ 
0x669F, 0x66A0, 0x66A1, 0x66A2, 0x66A3, 0x66A4, 0x66A5, 0x66A6, 	/* 0x95B0 to 0x95B7 */ 
0x66A9, 0x66AA, 0x66AB, 0x66AC, 0x66AD, 0x66AF, 0x66B0, 0x66B1, 	/* 0x95B8 to 0x95BF */ 
0x66B2, 0x66B3, 0x66B5, 0x66B6, 0x66B7, 0x66B8, 0x66BA, 0x66BB, 	/* 0x95C0 to 0x95C7 */ 
0x66BC, 0x66BD, 0x66BF, 0x66C0, 0x66C1, 0x66C2, 0x66C3, 0x66C4, 	/* 0x95C8 to 0x95CF */ 
0x66C5, 0x66C6, 0x66C7, 0x66C8, 0x66C9, 0x66CA, 0x66CB, 0x66CC, 	/* 0x95D0 to 0x95D7 */ 
0x66CD, 0x66CE, 0x66CF, 0x66D0, 0x66D1, 0x66D2, 0x66D3, 0x66D4, 	/* 0x95D8 to 0x95DF */ 
0x66D5, 0x66D6, 0x66D7, 0x66D8, 0x66DA, 0x66DE, 0x66DF, 0x66E0, 	/* 0x95E0 to 0x95E7 */ 
0x66E1, 0x66E2, 0x66E3, 0x66E4, 0x66E5, 0x66E7, 0x66E8, 0x66EA, 	/* 0x95E8 to 0x95EF */ 
0x66EB, 0x66EC, 0x66ED, 0x66EE, 0x66EF, 0x66F1, 0x66F5, 0x66F6, 	/* 0x95F0 to 0x95F7 */ 
0x66F8, 0x66FA, 0x66FB, 0x66FD, 0x6701, 0x6702, 0x6703, 0x0000, 	/* 0x95F8 to 0x95FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9600 to 0x9607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9608 to 0x960F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9610 to 0x9617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9618 to 0x961F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9620 to 0x9627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9628 to 0x962F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9630 to 0x9637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9638 to 0x963F */ 
0x6704, 0x6705, 0x6706, 0x6707, 0x670C, 0x670E, 0x670F, 0x6711, 	/* 0x9640 to 0x9647 */ 
0x6712, 0x6713, 0x6716, 0x6718, 0x6719, 0x671A, 0x671C, 0x671E, 	/* 0x9648 to 0x964F */ 
0x6720, 0x6721, 0x6722, 0x6723, 0x6724, 0x6725, 0x6727, 0x6729, 	/* 0x9650 to 0x9657 */ 
0x672E, 0x6730, 0x6732, 0x6733, 0x6736, 0x6737, 0x6738, 0x6739, 	/* 0x9658 to 0x965F */ 
0x673B, 0x673C, 0x673E, 0x673F, 0x6741, 0x6744, 0x6745, 0x6747, 	/* 0x9660 to 0x9667 */ 
0x674A, 0x674B, 0x674D, 0x6752, 0x6754, 0x6755, 0x6757, 0x6758, 	/* 0x9668 to 0x966F */ 
0x6759, 0x675A, 0x675B, 0x675D, 0x6762, 0x6763, 0x6764, 0x6766, 	/* 0x9670 to 0x9677 */ 
0x6767, 0x676B, 0x676C, 0x676E, 0x6771, 0x6774, 0x6776, 0x0000, 	/* 0x9678 to 0x967F */ 
0x6778, 0x6779, 0x677A, 0x677B, 0x677D, 0x6780, 0x6782, 0x6783, 	/* 0x9680 to 0x9687 */ 
0x6785, 0x6786, 0x6788, 0x678A, 0x678C, 0x678D, 0x678E, 0x678F, 	/* 0x9688 to 0x968F */ 
0x6791, 0x6792, 0x6793, 0x6794, 0x6796, 0x6799, 0x679B, 0x679F, 	/* 0x9690 to 0x9697 */ 
0x67A0, 0x67A1, 0x67A4, 0x67A6, 0x67A9, 0x67AC, 0x67AE, 0x67B1, 	/* 0x9698 to 0x969F */ 
0x67B2, 0x67B4, 0x67B9, 0x67BA, 0x67BB, 0x67BC, 0x67BD, 0x67BE, 	/* 0x96A0 to 0x96A7 */ 
0x67BF, 0x67C0, 0x67C2, 0x67C5, 0x67C6, 0x67C7, 0x67C8, 0x67C9, 	/* 0x96A8 to 0x96AF */ 
0x67CA, 0x67CB, 0x67CC, 0x67CD, 0x67CE, 0x67D5, 0x67D6, 0x67D7, 	/* 0x96B0 to 0x96B7 */ 
0x67DB, 0x67DF, 0x67E1, 0x67E3, 0x67E4, 0x67E6, 0x67E7, 0x67E8, 	/* 0x96B8 to 0x96BF */ 
0x67EA, 0x67EB, 0x67ED, 0x67EE, 0x67F2, 0x67F5, 0x67F6, 0x67F7, 	/* 0x96C0 to 0x96C7 */ 
0x67F8, 0x67F9, 0x67FA, 0x67FB, 0x67FC, 0x67FE, 0x6801, 0x6802, 	/* 0x96C8 to 0x96CF */ 
0x6803, 0x6804, 0x6806, 0x680D, 0x6810, 0x6812, 0x6814, 0x6815, 	/* 0x96D0 to 0x96D7 */ 
0x6818, 0x6819, 0x681A, 0x681B, 0x681C, 0x681E, 0x681F, 0x6820, 	/* 0x96D8 to 0x96DF */ 
0x6822, 0x6823, 0x6824, 0x6825, 0x6826, 0x6827, 0x6828, 0x682B, 	/* 0x96E0 to 0x96E7 */ 
0x682C, 0x682D, 0x682E, 0x682F, 0x6830, 0x6831, 0x6834, 0x6835, 	/* 0x96E8 to 0x96EF */ 
0x6836, 0x683A, 0x683B, 0x683F, 0x6847, 0x684B, 0x684D, 0x684F, 	/* 0x96F0 to 0x96F7 */ 
0x6852, 0x6856, 0x6857, 0x6858, 0x6859, 0x685A, 0x685B, 0x0000, 	/* 0x96F8 to 0x96FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9700 to 0x9707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9708 to 0x970F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9710 to 0x9717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9718 to 0x971F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9720 to 0x9727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9728 to 0x972F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9730 to 0x9737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9738 to 0x973F */ 
0x685C, 0x685D, 0x685E, 0x685F, 0x686A, 0x686C, 0x686D, 0x686E, 	/* 0x9740 to 0x9747 */ 
0x686F, 0x6870, 0x6871, 0x6872, 0x6873, 0x6875, 0x6878, 0x6879, 	/* 0x9748 to 0x974F */ 
0x687A, 0x687B, 0x687C, 0x687D, 0x687E, 0x687F, 0x6880, 0x6882, 	/* 0x9750 to 0x9757 */ 
0x6884, 0x6887, 0x6888, 0x6889, 0x688A, 0x688B, 0x688C, 0x688D, 	/* 0x9758 to 0x975F */ 
0x688E, 0x6890, 0x6891, 0x6892, 0x6894, 0x6895, 0x6896, 0x6898, 	/* 0x9760 to 0x9767 */ 
0x6899, 0x689A, 0x689B, 0x689C, 0x689D, 0x689E, 0x689F, 0x68A0, 	/* 0x9768 to 0x976F */ 
0x68A1, 0x68A3, 0x68A4, 0x68A5, 0x68A9, 0x68AA, 0x68AB, 0x68AC, 	/* 0x9770 to 0x9777 */ 
0x68AE, 0x68B1, 0x68B2, 0x68B4, 0x68B6, 0x68B7, 0x68B8, 0x0000, 	/* 0x9778 to 0x977F */ 
0x68B9, 0x68BA, 0x68BB, 0x68BC, 0x68BD, 0x68BE, 0x68BF, 0x68C1, 	/* 0x9780 to 0x9787 */ 
0x68C3, 0x68C4, 0x68C5, 0x68C6, 0x68C7, 0x68C8, 0x68CA, 0x68CC, 	/* 0x9788 to 0x978F */ 
0x68CE, 0x68CF, 0x68D0, 0x68D1, 0x68D3, 0x68D4, 0x68D6, 0x68D7, 	/* 0x9790 to 0x9797 */ 
0x68D9, 0x68DB, 0x68DC, 0x68DD, 0x68DE, 0x68DF, 0x68E1, 0x68E2, 	/* 0x9798 to 0x979F */ 
0x68E4, 0x68E5, 0x68E6, 0x68E7, 0x68E8, 0x68E9, 0x68EA, 0x68EB, 	/* 0x97A0 to 0x97A7 */ 
0x68EC, 0x68ED, 0x68EF, 0x68F2, 0x68F3, 0x68F4, 0x68F6, 0x68F7, 	/* 0x97A8 to 0x97AF */ 
0x68F8, 0x68FB, 0x68FD, 0x68FE, 0x68FF, 0x6900, 0x6902, 0x6903, 	/* 0x97B0 to 0x97B7 */ 
0x6904, 0x6906, 0x6907, 0x6908, 0x6909, 0x690A, 0x690C, 0x690F, 	/* 0x97B8 to 0x97BF */ 
0x6911, 0x6913, 0x6914, 0x6915, 0x6916, 0x6917, 0x6918, 0x6919, 	/* 0x97C0 to 0x97C7 */ 
0x691A, 0x691B, 0x691C, 0x691D, 0x691E, 0x6921, 0x6922, 0x6923, 	/* 0x97C8 to 0x97CF */ 
0x6925, 0x6926, 0x6927, 0x6928, 0x6929, 0x692A, 0x692B, 0x692C, 	/* 0x97D0 to 0x97D7 */ 
0x692E, 0x692F, 0x6931, 0x6932, 0x6933, 0x6935, 0x6936, 0x6937, 	/* 0x97D8 to 0x97DF */ 
0x6938, 0x693A, 0x693B, 0x693C, 0x693E, 0x6940, 0x6941, 0x6943, 	/* 0x97E0 to 0x97E7 */ 
0x6944, 0x6945, 0x6946, 0x6947, 0x6948, 0x6949, 0x694A, 0x694B, 	/* 0x97E8 to 0x97EF */ 
0x694C, 0x694D, 0x694E, 0x694F, 0x6950, 0x6951, 0x6952, 0x6953, 	/* 0x97F0 to 0x97F7 */ 
0x6955, 0x6956, 0x6958, 0x6959, 0x695B, 0x695C, 0x695F, 0x0000, 	/* 0x97F8 to 0x97FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9800 to 0x9807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9808 to 0x980F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9810 to 0x9817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9818 to 0x981F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9820 to 0x9827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9828 to 0x982F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9830 to 0x9837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9838 to 0x983F */ 
0x6961, 0x6962, 0x6964, 0x6965, 0x6967, 0x6968, 0x6969, 0x696A, 	/* 0x9840 to 0x9847 */ 
0x696C, 0x696D, 0x696F, 0x6970, 0x6972, 0x6973, 0x6974, 0x6975, 	/* 0x9848 to 0x984F */ 
0x6976, 0x697A, 0x697B, 0x697D, 0x697E, 0x697F, 0x6981, 0x6983, 	/* 0x9850 to 0x9857 */ 
0x6985, 0x698A, 0x698B, 0x698C, 0x698E, 0x698F, 0x6990, 0x6991, 	/* 0x9858 to 0x985F */ 
0x6992, 0x6993, 0x6996, 0x6997, 0x6999, 0x699A, 0x699D, 0x699E, 	/* 0x9860 to 0x9867 */ 
0x699F, 0x69A0, 0x69A1, 0x69A2, 0x69A3, 0x69A4, 0x69A5, 0x69A6, 	/* 0x9868 to 0x986F */ 
0x69A9, 0x69AA, 0x69AC, 0x69AE, 0x69AF, 0x69B0, 0x69B2, 0x69B3, 	/* 0x9870 to 0x9877 */ 
0x69B5, 0x69B6, 0x69B8, 0x69B9, 0x69BA, 0x69BC, 0x69BD, 0x0000, 	/* 0x9878 to 0x987F */ 
0x69BE, 0x69BF, 0x69C0, 0x69C2, 0x69C3, 0x69C4, 0x69C5, 0x69C6, 	/* 0x9880 to 0x9887 */ 
0x69C7, 0x69C8, 0x69C9, 0x69CB, 0x69CD, 0x69CF, 0x69D1, 0x69D2, 	/* 0x9888 to 0x988F */ 
0x69D3, 0x69D5, 0x69D6, 0x69D7, 0x69D8, 0x69D9, 0x69DA, 0x69DC, 	/* 0x9890 to 0x9897 */ 
0x69DD, 0x69DE, 0x69E1, 0x69E2, 0x69E3, 0x69E4, 0x69E5, 0x69E6, 	/* 0x9898 to 0x989F */ 
0x69E7, 0x69E8, 0x69E9, 0x69EA, 0x69EB, 0x69EC, 0x69EE, 0x69EF, 	/* 0x98A0 to 0x98A7 */ 
0x69F0, 0x69F1, 0x69F3, 0x69F4, 0x69F5, 0x69F6, 0x69F7, 0x69F8, 	/* 0x98A8 to 0x98AF */ 
0x69F9, 0x69FA, 0x69FB, 0x69FC, 0x69FE, 0x6A00, 0x6A01, 0x6A02, 	/* 0x98B0 to 0x98B7 */ 
0x6A03, 0x6A04, 0x6A05, 0x6A06, 0x6A07, 0x6A08, 0x6A09, 0x6A0B, 	/* 0x98B8 to 0x98BF */ 
0x6A0C, 0x6A0D, 0x6A0E, 0x6A0F, 0x6A10, 0x6A11, 0x6A12, 0x6A13, 	/* 0x98C0 to 0x98C7 */ 
0x6A14, 0x6A15, 0x6A16, 0x6A19, 0x6A1A, 0x6A1B, 0x6A1C, 0x6A1D, 	/* 0x98C8 to 0x98CF */ 
0x6A1E, 0x6A20, 0x6A22, 0x6A23, 0x6A24, 0x6A25, 0x6A26, 0x6A27, 	/* 0x98D0 to 0x98D7 */ 
0x6A29, 0x6A2B, 0x6A2C, 0x6A2D, 0x6A2E, 0x6A30, 0x6A32, 0x6A33, 	/* 0x98D8 to 0x98DF */ 
0x6A34, 0x6A36, 0x6A37, 0x6A38, 0x6A39, 0x6A3A, 0x6A3B, 0x6A3C, 	/* 0x98E0 to 0x98E7 */ 
0x6A3F, 0x6A40, 0x6A41, 0x6A42, 0x6A43, 0x6A45, 0x6A46, 0x6A48, 	/* 0x98E8 to 0x98EF */ 
0x6A49, 0x6A4A, 0x6A4B, 0x6A4C, 0x6A4D, 0x6A4E, 0x6A4F, 0x6A51, 	/* 0x98F0 to 0x98F7 */ 
0x6A52, 0x6A53, 0x6A54, 0x6A55, 0x6A56, 0x6A57, 0x6A5A, 0x0000, 	/* 0x98F8 to 0x98FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9900 to 0x9907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9908 to 0x990F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9910 to 0x9917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9918 to 0x991F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9920 to 0x9927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9928 to 0x992F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9930 to 0x9937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9938 to 0x993F */ 
0x6A5C, 0x6A5D, 0x6A5E, 0x6A5F, 0x6A60, 0x6A62, 0x6A63, 0x6A64, 	/* 0x9940 to 0x9947 */ 
0x6A66, 0x6A67, 0x6A68, 0x6A69, 0x6A6A, 0x6A6B, 0x6A6C, 0x6A6D, 	/* 0x9948 to 0x994F */ 
0x6A6E, 0x6A6F, 0x6A70, 0x6A72, 0x6A73, 0x6A74, 0x6A75, 0x6A76, 	/* 0x9950 to 0x9957 */ 
0x6A77, 0x6A78, 0x6A7A, 0x6A7B, 0x6A7D, 0x6A7E, 0x6A7F, 0x6A81, 	/* 0x9958 to 0x995F */ 
0x6A82, 0x6A83, 0x6A85, 0x6A86, 0x6A87, 0x6A88, 0x6A89, 0x6A8A, 	/* 0x9960 to 0x9967 */ 
0x6A8B, 0x6A8C, 0x6A8D, 0x6A8F, 0x6A92, 0x6A93, 0x6A94, 0x6A95, 	/* 0x9968 to 0x996F */ 
0x6A96, 0x6A98, 0x6A99, 0x6A9A, 0x6A9B, 0x6A9C, 0x6A9D, 0x6A9E, 	/* 0x9970 to 0x9977 */ 
0x6A9F, 0x6AA1, 0x6AA2, 0x6AA3, 0x6AA4, 0x6AA5, 0x6AA6, 0x0000, 	/* 0x9978 to 0x997F */ 
0x6AA7, 0x6AA8, 0x6AAA, 0x6AAD, 0x6AAE, 0x6AAF, 0x6AB0, 0x6AB1, 	/* 0x9980 to 0x9987 */ 
0x6AB2, 0x6AB3, 0x6AB4, 0x6AB5, 0x6AB6, 0x6AB7, 0x6AB8, 0x6AB9, 	/* 0x9988 to 0x998F */ 
0x6ABA, 0x6ABB, 0x6ABC, 0x6ABD, 0x6ABE, 0x6ABF, 0x6AC0, 0x6AC1, 	/* 0x9990 to 0x9997 */ 
0x6AC2, 0x6AC3, 0x6AC4, 0x6AC5, 0x6AC6, 0x6AC7, 0x6AC8, 0x6AC9, 	/* 0x9998 to 0x999F */ 
0x6ACA, 0x6ACB, 0x6ACC, 0x6ACD, 0x6ACE, 0x6ACF, 0x6AD0, 0x6AD1, 	/* 0x99A0 to 0x99A7 */ 
0x6AD2, 0x6AD3, 0x6AD4, 0x6AD5, 0x6AD6, 0x6AD7, 0x6AD8, 0x6AD9, 	/* 0x99A8 to 0x99AF */ 
0x6ADA, 0x6ADB, 0x6ADC, 0x6ADD, 0x6ADE, 0x6ADF, 0x6AE0, 0x6AE1, 	/* 0x99B0 to 0x99B7 */ 
0x6AE2, 0x6AE3, 0x6AE4, 0x6AE5, 0x6AE6, 0x6AE7, 0x6AE8, 0x6AE9, 	/* 0x99B8 to 0x99BF */ 
0x6AEA, 0x6AEB, 0x6AEC, 0x6AED, 0x6AEE, 0x6AEF, 0x6AF0, 0x6AF1, 	/* 0x99C0 to 0x99C7 */ 
0x6AF2, 0x6AF3, 0x6AF4, 0x6AF5, 0x6AF6, 0x6AF7, 0x6AF8, 0x6AF9, 	/* 0x99C8 to 0x99CF */ 
0x6AFA, 0x6AFB, 0x6AFC, 0x6AFD, 0x6AFE, 0x6AFF, 0x6B00, 0x6B01, 	/* 0x99D0 to 0x99D7 */ 
0x6B02, 0x6B03, 0x6B04, 0x6B05, 0x6B06, 0x6B07, 0x6B08, 0x6B09, 	/* 0x99D8 to 0x99DF */ 
0x6B0A, 0x6B0B, 0x6B0C, 0x6B0D, 0x6B0E, 0x6B0F, 0x6B10, 0x6B11, 	/* 0x99E0 to 0x99E7 */ 
0x6B12, 0x6B13, 0x6B14, 0x6B15, 0x6B16, 0x6B17, 0x6B18, 0x6B19, 	/* 0x99E8 to 0x99EF */ 
0x6B1A, 0x6B1B, 0x6B1C, 0x6B1D, 0x6B1E, 0x6B1F, 0x6B25, 0x6B26, 	/* 0x99F0 to 0x99F7 */ 
0x6B28, 0x6B29, 0x6B2A, 0x6B2B, 0x6B2C, 0x6B2D, 0x6B2E, 0x0000, 	/* 0x99F8 to 0x99FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A00 to 0x9A07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A08 to 0x9A0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A10 to 0x9A17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A18 to 0x9A1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A20 to 0x9A27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A28 to 0x9A2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A30 to 0x9A37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A38 to 0x9A3F */ 
0x6B2F, 0x6B30, 0x6B31, 0x6B33, 0x6B34, 0x6B35, 0x6B36, 0x6B38, 	/* 0x9A40 to 0x9A47 */ 
0x6B3B, 0x6B3C, 0x6B3D, 0x6B3F, 0x6B40, 0x6B41, 0x6B42, 0x6B44, 	/* 0x9A48 to 0x9A4F */ 
0x6B45, 0x6B48, 0x6B4A, 0x6B4B, 0x6B4D, 0x6B4E, 0x6B4F, 0x6B50, 	/* 0x9A50 to 0x9A57 */ 
0x6B51, 0x6B52, 0x6B53, 0x6B54, 0x6B55, 0x6B56, 0x6B57, 0x6B58, 	/* 0x9A58 to 0x9A5F */ 
0x6B5A, 0x6B5B, 0x6B5C, 0x6B5D, 0x6B5E, 0x6B5F, 0x6B60, 0x6B61, 	/* 0x9A60 to 0x9A67 */ 
0x6B68, 0x6B69, 0x6B6B, 0x6B6C, 0x6B6D, 0x6B6E, 0x6B6F, 0x6B70, 	/* 0x9A68 to 0x9A6F */ 
0x6B71, 0x6B72, 0x6B73, 0x6B74, 0x6B75, 0x6B76, 0x6B77, 0x6B78, 	/* 0x9A70 to 0x9A77 */ 
0x6B7A, 0x6B7D, 0x6B7E, 0x6B7F, 0x6B80, 0x6B85, 0x6B88, 0x0000, 	/* 0x9A78 to 0x9A7F */ 
0x6B8C, 0x6B8E, 0x6B8F, 0x6B90, 0x6B91, 0x6B94, 0x6B95, 0x6B97, 	/* 0x9A80 to 0x9A87 */ 
0x6B98, 0x6B99, 0x6B9C, 0x6B9D, 0x6B9E, 0x6B9F, 0x6BA0, 0x6BA2, 	/* 0x9A88 to 0x9A8F */ 
0x6BA3, 0x6BA4, 0x6BA5, 0x6BA6, 0x6BA7, 0x6BA8, 0x6BA9, 0x6BAB, 	/* 0x9A90 to 0x9A97 */ 
0x6BAC, 0x6BAD, 0x6BAE, 0x6BAF, 0x6BB0, 0x6BB1, 0x6BB2, 0x6BB6, 	/* 0x9A98 to 0x9A9F */ 
0x6BB8, 0x6BB9, 0x6BBA, 0x6BBB, 0x6BBC, 0x6BBD, 0x6BBE, 0x6BC0, 	/* 0x9AA0 to 0x9AA7 */ 
0x6BC3, 0x6BC4, 0x6BC6, 0x6BC7, 0x6BC8, 0x6BC9, 0x6BCA, 0x6BCC, 	/* 0x9AA8 to 0x9AAF */ 
0x6BCE, 0x6BD0, 0x6BD1, 0x6BD8, 0x6BDA, 0x6BDC, 0x6BDD, 0x6BDE, 	/* 0x9AB0 to 0x9AB7 */ 
0x6BDF, 0x6BE0, 0x6BE2, 0x6BE3, 0x6BE4, 0x6BE5, 0x6BE6, 0x6BE7, 	/* 0x9AB8 to 0x9ABF */ 
0x6BE8, 0x6BE9, 0x6BEC, 0x6BED, 0x6BEE, 0x6BF0, 0x6BF1, 0x6BF2, 	/* 0x9AC0 to 0x9AC7 */ 
0x6BF4, 0x6BF6, 0x6BF7, 0x6BF8, 0x6BFA, 0x6BFB, 0x6BFC, 0x6BFE, 	/* 0x9AC8 to 0x9ACF */ 
0x6BFF, 0x6C00, 0x6C01, 0x6C02, 0x6C03, 0x6C04, 0x6C08, 0x6C09, 	/* 0x9AD0 to 0x9AD7 */ 
0x6C0A, 0x6C0B, 0x6C0C, 0x6C0E, 0x6C12, 0x6C17, 0x6C1C, 0x6C1D, 	/* 0x9AD8 to 0x9ADF */ 
0x6C1E, 0x6C20, 0x6C23, 0x6C25, 0x6C2B, 0x6C2C, 0x6C2D, 0x6C31, 	/* 0x9AE0 to 0x9AE7 */ 
0x6C33, 0x6C36, 0x6C37, 0x6C39, 0x6C3A, 0x6C3B, 0x6C3C, 0x6C3E, 	/* 0x9AE8 to 0x9AEF */ 
0x6C3F, 0x6C43, 0x6C44, 0x6C45, 0x6C48, 0x6C4B, 0x6C4C, 0x6C4D, 	/* 0x9AF0 to 0x9AF7 */ 
0x6C4E, 0x6C4F, 0x6C51, 0x6C52, 0x6C53, 0x6C56, 0x6C58, 0x0000, 	/* 0x9AF8 to 0x9AFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B00 to 0x9B07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B08 to 0x9B0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B10 to 0x9B17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B18 to 0x9B1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B20 to 0x9B27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B28 to 0x9B2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B30 to 0x9B37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B38 to 0x9B3F */ 
0x6C59, 0x6C5A, 0x6C62, 0x6C63, 0x6C65, 0x6C66, 0x6C67, 0x6C6B, 	/* 0x9B40 to 0x9B47 */ 
0x6C6C, 0x6C6D, 0x6C6E, 0x6C6F, 0x6C71, 0x6C73, 0x6C75, 0x6C77, 	/* 0x9B48 to 0x9B4F */ 
0x6C78, 0x6C7A, 0x6C7B, 0x6C7C, 0x6C7F, 0x6C80, 0x6C84, 0x6C87, 	/* 0x9B50 to 0x9B57 */ 
0x6C8A, 0x6C8B, 0x6C8D, 0x6C8E, 0x6C91, 0x6C92, 0x6C95, 0x6C96, 	/* 0x9B58 to 0x9B5F */ 
0x6C97, 0x6C98, 0x6C9A, 0x6C9C, 0x6C9D, 0x6C9E, 0x6CA0, 0x6CA2, 	/* 0x9B60 to 0x9B67 */ 
0x6CA8, 0x6CAC, 0x6CAF, 0x6CB0, 0x6CB4, 0x6CB5, 0x6CB6, 0x6CB7, 	/* 0x9B68 to 0x9B6F */ 
0x6CBA, 0x6CC0, 0x6CC1, 0x6CC2, 0x6CC3, 0x6CC6, 0x6CC7, 0x6CC8, 	/* 0x9B70 to 0x9B77 */ 
0x6CCB, 0x6CCD, 0x6CCE, 0x6CCF, 0x6CD1, 0x6CD2, 0x6CD8, 0x0000, 	/* 0x9B78 to 0x9B7F */ 
0x6CD9, 0x6CDA, 0x6CDC, 0x6CDD, 0x6CDF, 0x6CE4, 0x6CE6, 0x6CE7, 	/* 0x9B80 to 0x9B87 */ 
0x6CE9, 0x6CEC, 0x6CED, 0x6CF2, 0x6CF4, 0x6CF9, 0x6CFF, 0x6D00, 	/* 0x9B88 to 0x9B8F */ 
0x6D02, 0x6D03, 0x6D05, 0x6D06, 0x6D08, 0x6D09, 0x6D0A, 0x6D0D, 	/* 0x9B90 to 0x9B97 */ 
0x6D0F, 0x6D10, 0x6D11, 0x6D13, 0x6D14, 0x6D15, 0x6D16, 0x6D18, 	/* 0x9B98 to 0x9B9F */ 
0x6D1C, 0x6D1D, 0x6D1F, 0x6D20, 0x6D21, 0x6D22, 0x6D23, 0x6D24, 	/* 0x9BA0 to 0x9BA7 */ 
0x6D26, 0x6D28, 0x6D29, 0x6D2C, 0x6D2D, 0x6D2F, 0x6D30, 0x6D34, 	/* 0x9BA8 to 0x9BAF */ 
0x6D36, 0x6D37, 0x6D38, 0x6D3A, 0x6D3F, 0x6D40, 0x6D42, 0x6D44, 	/* 0x9BB0 to 0x9BB7 */ 
0x6D49, 0x6D4C, 0x6D50, 0x6D55, 0x6D56, 0x6D57, 0x6D58, 0x6D5B, 	/* 0x9BB8 to 0x9BBF */ 
0x6D5D, 0x6D5F, 0x6D61, 0x6D62, 0x6D64, 0x6D65, 0x6D67, 0x6D68, 	/* 0x9BC0 to 0x9BC7 */ 
0x6D6B, 0x6D6C, 0x6D6D, 0x6D70, 0x6D71, 0x6D72, 0x6D73, 0x6D75, 	/* 0x9BC8 to 0x9BCF */ 
0x6D76, 0x6D79, 0x6D7A, 0x6D7B, 0x6D7D, 0x6D7E, 0x6D7F, 0x6D80, 	/* 0x9BD0 to 0x9BD7 */ 
0x6D81, 0x6D83, 0x6D84, 0x6D86, 0x6D87, 0x6D8A, 0x6D8B, 0x6D8D, 	/* 0x9BD8 to 0x9BDF */ 
0x6D8F, 0x6D90, 0x6D92, 0x6D96, 0x6D97, 0x6D98, 0x6D99, 0x6D9A, 	/* 0x9BE0 to 0x9BE7 */ 
0x6D9C, 0x6DA2, 0x6DA5, 0x6DAC, 0x6DAD, 0x6DB0, 0x6DB1, 0x6DB3, 	/* 0x9BE8 to 0x9BEF */ 
0x6DB4, 0x6DB6, 0x6DB7, 0x6DB9, 0x6DBA, 0x6DBB, 0x6DBC, 0x6DBD, 	/* 0x9BF0 to 0x9BF7 */ 
0x6DBE, 0x6DC1, 0x6DC2, 0x6DC3, 0x6DC8, 0x6DC9, 0x6DCA, 0x0000, 	/* 0x9BF8 to 0x9BFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C00 to 0x9C07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C08 to 0x9C0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C10 to 0x9C17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C18 to 0x9C1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C20 to 0x9C27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C28 to 0x9C2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C30 to 0x9C37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C38 to 0x9C3F */ 
0x6DCD, 0x6DCE, 0x6DCF, 0x6DD0, 0x6DD2, 0x6DD3, 0x6DD4, 0x6DD5, 	/* 0x9C40 to 0x9C47 */ 
0x6DD7, 0x6DDA, 0x6DDB, 0x6DDC, 0x6DDF, 0x6DE2, 0x6DE3, 0x6DE5, 	/* 0x9C48 to 0x9C4F */ 
0x6DE7, 0x6DE8, 0x6DE9, 0x6DEA, 0x6DED, 0x6DEF, 0x6DF0, 0x6DF2, 	/* 0x9C50 to 0x9C57 */ 
0x6DF4, 0x6DF5, 0x6DF6, 0x6DF8, 0x6DFA, 0x6DFD, 0x6DFE, 0x6DFF, 	/* 0x9C58 to 0x9C5F */ 
0x6E00, 0x6E01, 0x6E02, 0x6E03, 0x6E04, 0x6E06, 0x6E07, 0x6E08, 	/* 0x9C60 to 0x9C67 */ 
0x6E09, 0x6E0B, 0x6E0F, 0x6E12, 0x6E13, 0x6E15, 0x6E18, 0x6E19, 	/* 0x9C68 to 0x9C6F */ 
0x6E1B, 0x6E1C, 0x6E1E, 0x6E1F, 0x6E22, 0x6E26, 0x6E27, 0x6E28, 	/* 0x9C70 to 0x9C77 */ 
0x6E2A, 0x6E2C, 0x6E2E, 0x6E30, 0x6E31, 0x6E33, 0x6E35, 0x0000, 	/* 0x9C78 to 0x9C7F */ 
0x6E36, 0x6E37, 0x6E39, 0x6E3B, 0x6E3C, 0x6E3D, 0x6E3E, 0x6E3F, 	/* 0x9C80 to 0x9C87 */ 
0x6E40, 0x6E41, 0x6E42, 0x6E45, 0x6E46, 0x6E47, 0x6E48, 0x6E49, 	/* 0x9C88 to 0x9C8F */ 
0x6E4A, 0x6E4B, 0x6E4C, 0x6E4F, 0x6E50, 0x6E51, 0x6E52, 0x6E55, 	/* 0x9C90 to 0x9C97 */ 
0x6E57, 0x6E59, 0x6E5A, 0x6E5C, 0x6E5D, 0x6E5E, 0x6E60, 0x6E61, 	/* 0x9C98 to 0x9C9F */ 
0x6E62, 0x6E63, 0x6E64, 0x6E65, 0x6E66, 0x6E67, 0x6E68, 0x6E69, 	/* 0x9CA0 to 0x9CA7 */ 
0x6E6A, 0x6E6C, 0x6E6D, 0x6E6F, 0x6E70, 0x6E71, 0x6E72, 0x6E73, 	/* 0x9CA8 to 0x9CAF */ 
0x6E74, 0x6E75, 0x6E76, 0x6E77, 0x6E78, 0x6E79, 0x6E7A, 0x6E7B, 	/* 0x9CB0 to 0x9CB7 */ 
0x6E7C, 0x6E7D, 0x6E80, 0x6E81, 0x6E82, 0x6E84, 0x6E87, 0x6E88, 	/* 0x9CB8 to 0x9CBF */ 
0x6E8A, 0x6E8B, 0x6E8C, 0x6E8D, 0x6E8E, 0x6E91, 0x6E92, 0x6E93, 	/* 0x9CC0 to 0x9CC7 */ 
0x6E94, 0x6E95, 0x6E96, 0x6E97, 0x6E99, 0x6E9A, 0x6E9B, 0x6E9D, 	/* 0x9CC8 to 0x9CCF */ 
0x6E9E, 0x6EA0, 0x6EA1, 0x6EA3, 0x6EA4, 0x6EA6, 0x6EA8, 0x6EA9, 	/* 0x9CD0 to 0x9CD7 */ 
0x6EAB, 0x6EAC, 0x6EAD, 0x6EAE, 0x6EB0, 0x6EB3, 0x6EB5, 0x6EB8, 	/* 0x9CD8 to 0x9CDF */ 
0x6EB9, 0x6EBC, 0x6EBE, 0x6EBF, 0x6EC0, 0x6EC3, 0x6EC4, 0x6EC5, 	/* 0x9CE0 to 0x9CE7 */ 
0x6EC6, 0x6EC8, 0x6EC9, 0x6ECA, 0x6ECC, 0x6ECD, 0x6ECE, 0x6ED0, 	/* 0x9CE8 to 0x9CEF */ 
0x6ED2, 0x6ED6, 0x6ED8, 0x6ED9, 0x6EDB, 0x6EDC, 0x6EDD, 0x6EE3, 	/* 0x9CF0 to 0x9CF7 */ 
0x6EE7, 0x6EEA, 0x6EEB, 0x6EEC, 0x6EED, 0x6EEE, 0x6EEF, 0x0000, 	/* 0x9CF8 to 0x9CFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D00 to 0x9D07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D08 to 0x9D0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D10 to 0x9D17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D18 to 0x9D1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D20 to 0x9D27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D28 to 0x9D2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D30 to 0x9D37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D38 to 0x9D3F */ 
0x6EF0, 0x6EF1, 0x6EF2, 0x6EF3, 0x6EF5, 0x6EF6, 0x6EF7, 0x6EF8, 	/* 0x9D40 to 0x9D47 */ 
0x6EFA, 0x6EFB, 0x6EFC, 0x6EFD, 0x6EFE, 0x6EFF, 0x6F00, 0x6F01, 	/* 0x9D48 to 0x9D4F */ 
0x6F03, 0x6F04, 0x6F05, 0x6F07, 0x6F08, 0x6F0A, 0x6F0B, 0x6F0C, 	/* 0x9D50 to 0x9D57 */ 
0x6F0D, 0x6F0E, 0x6F10, 0x6F11, 0x6F12, 0x6F16, 0x6F17, 0x6F18, 	/* 0x9D58 to 0x9D5F */ 
0x6F19, 0x6F1A, 0x6F1B, 0x6F1C, 0x6F1D, 0x6F1E, 0x6F1F, 0x6F21, 	/* 0x9D60 to 0x9D67 */ 
0x6F22, 0x6F23, 0x6F25, 0x6F26, 0x6F27, 0x6F28, 0x6F2C, 0x6F2E, 	/* 0x9D68 to 0x9D6F */ 
0x6F30, 0x6F32, 0x6F34, 0x6F35, 0x6F37, 0x6F38, 0x6F39, 0x6F3A, 	/* 0x9D70 to 0x9D77 */ 
0x6F3B, 0x6F3C, 0x6F3D, 0x6F3F, 0x6F40, 0x6F41, 0x6F42, 0x0000, 	/* 0x9D78 to 0x9D7F */ 
0x6F43, 0x6F44, 0x6F45, 0x6F48, 0x6F49, 0x6F4A, 0x6F4C, 0x6F4E, 	/* 0x9D80 to 0x9D87 */ 
0x6F4F, 0x6F50, 0x6F51, 0x6F52, 0x6F53, 0x6F54, 0x6F55, 0x6F56, 	/* 0x9D88 to 0x9D8F */ 
0x6F57, 0x6F59, 0x6F5A, 0x6F5B, 0x6F5D, 0x6F5F, 0x6F60, 0x6F61, 	/* 0x9D90 to 0x9D97 */ 
0x6F63, 0x6F64, 0x6F65, 0x6F67, 0x6F68, 0x6F69, 0x6F6A, 0x6F6B, 	/* 0x9D98 to 0x9D9F */ 
0x6F6C, 0x6F6F, 0x6F70, 0x6F71, 0x6F73, 0x6F75, 0x6F76, 0x6F77, 	/* 0x9DA0 to 0x9DA7 */ 
0x6F79, 0x6F7B, 0x6F7D, 0x6F7E, 0x6F7F, 0x6F80, 0x6F81, 0x6F82, 	/* 0x9DA8 to 0x9DAF */ 
0x6F83, 0x6F85, 0x6F86, 0x6F87, 0x6F8A, 0x6F8B, 0x6F8F, 0x6F90, 	/* 0x9DB0 to 0x9DB7 */ 
0x6F91, 0x6F92, 0x6F93, 0x6F94, 0x6F95, 0x6F96, 0x6F97, 0x6F98, 	/* 0x9DB8 to 0x9DBF */ 
0x6F99, 0x6F9A, 0x6F9B, 0x6F9D, 0x6F9E, 0x6F9F, 0x6FA0, 0x6FA2, 	/* 0x9DC0 to 0x9DC7 */ 
0x6FA3, 0x6FA4, 0x6FA5, 0x6FA6, 0x6FA8, 0x6FA9, 0x6FAA, 0x6FAB, 	/* 0x9DC8 to 0x9DCF */ 
0x6FAC, 0x6FAD, 0x6FAE, 0x6FAF, 0x6FB0, 0x6FB1, 0x6FB2, 0x6FB4, 	/* 0x9DD0 to 0x9DD7 */ 
0x6FB5, 0x6FB7, 0x6FB8, 0x6FBA, 0x6FBB, 0x6FBC, 0x6FBD, 0x6FBE, 	/* 0x9DD8 to 0x9DDF */ 
0x6FBF, 0x6FC1, 0x6FC3, 0x6FC4, 0x6FC5, 0x6FC6, 0x6FC7, 0x6FC8, 	/* 0x9DE0 to 0x9DE7 */ 
0x6FCA, 0x6FCB, 0x6FCC, 0x6FCD, 0x6FCE, 0x6FCF, 0x6FD0, 0x6FD3, 	/* 0x9DE8 to 0x9DEF */ 
0x6FD4, 0x6FD5, 0x6FD6, 0x6FD7, 0x6FD8, 0x6FD9, 0x6FDA, 0x6FDB, 	/* 0x9DF0 to 0x9DF7 */ 
0x6FDC, 0x6FDD, 0x6FDF, 0x6FE2, 0x6FE3, 0x6FE4, 0x6FE5, 0x0000, 	/* 0x9DF8 to 0x9DFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E00 to 0x9E07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E08 to 0x9E0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E10 to 0x9E17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E18 to 0x9E1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E20 to 0x9E27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E28 to 0x9E2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E30 to 0x9E37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E38 to 0x9E3F */ 
0x6FE6, 0x6FE7, 0x6FE8, 0x6FE9, 0x6FEA, 0x6FEB, 0x6FEC, 0x6FED, 	/* 0x9E40 to 0x9E47 */ 
0x6FF0, 0x6FF1, 0x6FF2, 0x6FF3, 0x6FF4, 0x6FF5, 0x6FF6, 0x6FF7, 	/* 0x9E48 to 0x9E4F */ 
0x6FF8, 0x6FF9, 0x6FFA, 0x6FFB, 0x6FFC, 0x6FFD, 0x6FFE, 0x6FFF, 	/* 0x9E50 to 0x9E57 */ 
0x7000, 0x7001, 0x7002, 0x7003, 0x7004, 0x7005, 0x7006, 0x7007, 	/* 0x9E58 to 0x9E5F */ 
0x7008, 0x7009, 0x700A, 0x700B, 0x700C, 0x700D, 0x700E, 0x700F, 	/* 0x9E60 to 0x9E67 */ 
0x7010, 0x7012, 0x7013, 0x7014, 0x7015, 0x7016, 0x7017, 0x7018, 	/* 0x9E68 to 0x9E6F */ 
0x7019, 0x701C, 0x701D, 0x701E, 0x701F, 0x7020, 0x7021, 0x7022, 	/* 0x9E70 to 0x9E77 */ 
0x7024, 0x7025, 0x7026, 0x7027, 0x7028, 0x7029, 0x702A, 0x0000, 	/* 0x9E78 to 0x9E7F */ 
0x702B, 0x702C, 0x702D, 0x702E, 0x702F, 0x7030, 0x7031, 0x7032, 	/* 0x9E80 to 0x9E87 */ 
0x7033, 0x7034, 0x7036, 0x7037, 0x7038, 0x703A, 0x703B, 0x703C, 	/* 0x9E88 to 0x9E8F */ 
0x703D, 0x703E, 0x703F, 0x7040, 0x7041, 0x7042, 0x7043, 0x7044, 	/* 0x9E90 to 0x9E97 */ 
0x7045, 0x7046, 0x7047, 0x7048, 0x7049, 0x704A, 0x704B, 0x704D, 	/* 0x9E98 to 0x9E9F */ 
0x704E, 0x7050, 0x7051, 0x7052, 0x7053, 0x7054, 0x7055, 0x7056, 	/* 0x9EA0 to 0x9EA7 */ 
0x7057, 0x7058, 0x7059, 0x705A, 0x705B, 0x705C, 0x705D, 0x705F, 	/* 0x9EA8 to 0x9EAF */ 
0x7060, 0x7061, 0x7062, 0x7063, 0x7064, 0x7065, 0x7066, 0x7067, 	/* 0x9EB0 to 0x9EB7 */ 
0x7068, 0x7069, 0x706A, 0x706E, 0x7071, 0x7072, 0x7073, 0x7074, 	/* 0x9EB8 to 0x9EBF */ 
0x7077, 0x7079, 0x707A, 0x707B, 0x707D, 0x7081, 0x7082, 0x7083, 	/* 0x9EC0 to 0x9EC7 */ 
0x7084, 0x7086, 0x7087, 0x7088, 0x708B, 0x708C, 0x708D, 0x708F, 	/* 0x9EC8 to 0x9ECF */ 
0x7090, 0x7091, 0x7093, 0x7097, 0x7098, 0x709A, 0x709B, 0x709E, 	/* 0x9ED0 to 0x9ED7 */ 
0x709F, 0x70A0, 0x70A1, 0x70A2, 0x70A3, 0x70A4, 0x70A5, 0x70A6, 	/* 0x9ED8 to 0x9EDF */ 
0x70A7, 0x70A8, 0x70A9, 0x70AA, 0x70B0, 0x70B2, 0x70B4, 0x70B5, 	/* 0x9EE0 to 0x9EE7 */ 
0x70B6, 0x70BA, 0x70BE, 0x70BF, 0x70C4, 0x70C5, 0x70C6, 0x70C7, 	/* 0x9EE8 to 0x9EEF */ 
0x70C9, 0x70CB, 0x70CC, 0x70CD, 0x70CE, 0x70CF, 0x70D0, 0x70D1, 	/* 0x9EF0 to 0x9EF7 */ 
0x70D2, 0x70D3, 0x70D4, 0x70D5, 0x70D6, 0x70D7, 0x70DA, 0x0000, 	/* 0x9EF8 to 0x9EFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F00 to 0x9F07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F08 to 0x9F0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F10 to 0x9F17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F18 to 0x9F1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F20 to 0x9F27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F28 to 0x9F2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F30 to 0x9F37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F38 to 0x9F3F */ 
0x70DC, 0x70DD, 0x70DE, 0x70E0, 0x70E1, 0x70E2, 0x70E3, 0x70E5, 	/* 0x9F40 to 0x9F47 */ 
0x70EA, 0x70EE, 0x70F0, 0x70F1, 0x70F2, 0x70F3, 0x70F4, 0x70F5, 	/* 0x9F48 to 0x9F4F */ 
0x70F6, 0x70F8, 0x70FA, 0x70FB, 0x70FC, 0x70FE, 0x70FF, 0x7100, 	/* 0x9F50 to 0x9F57 */ 
0x7101, 0x7102, 0x7103, 0x7104, 0x7105, 0x7106, 0x7107, 0x7108, 	/* 0x9F58 to 0x9F5F */ 
0x710B, 0x710C, 0x710D, 0x710E, 0x710F, 0x7111, 0x7112, 0x7114, 	/* 0x9F60 to 0x9F67 */ 
0x7117, 0x711B, 0x711C, 0x711D, 0x711E, 0x711F, 0x7120, 0x7121, 	/* 0x9F68 to 0x9F6F */ 
0x7122, 0x7123, 0x7124, 0x7125, 0x7127, 0x7128, 0x7129, 0x712A, 	/* 0x9F70 to 0x9F77 */ 
0x712B, 0x712C, 0x712D, 0x712E, 0x7132, 0x7133, 0x7134, 0x0000, 	/* 0x9F78 to 0x9F7F */ 
0x7135, 0x7137, 0x7138, 0x7139, 0x713A, 0x713B, 0x713C, 0x713D, 	/* 0x9F80 to 0x9F87 */ 
0x713E, 0x713F, 0x7140, 0x7141, 0x7142, 0x7143, 0x7144, 0x7146, 	/* 0x9F88 to 0x9F8F */ 
0x7147, 0x7148, 0x7149, 0x714B, 0x714D, 0x714F, 0x7150, 0x7151, 	/* 0x9F90 to 0x9F97 */ 
0x7152, 0x7153, 0x7154, 0x7155, 0x7156, 0x7157, 0x7158, 0x7159, 	/* 0x9F98 to 0x9F9F */ 
0x715A, 0x715B, 0x715D, 0x715F, 0x7160, 0x7161, 0x7162, 0x7163, 	/* 0x9FA0 to 0x9FA7 */ 
0x7165, 0x7169, 0x716A, 0x716B, 0x716C, 0x716D, 0x716F, 0x7170, 	/* 0x9FA8 to 0x9FAF */ 
0x7171, 0x7174, 0x7175, 0x7176, 0x7177, 0x7179, 0x717B, 0x717C, 	/* 0x9FB0 to 0x9FB7 */ 
0x717E, 0x717F, 0x7180, 0x7181, 0x7182, 0x7183, 0x7185, 0x7186, 	/* 0x9FB8 to 0x9FBF */ 
0x7187, 0x7188, 0x7189, 0x718B, 0x718C, 0x718D, 0x718E, 0x7190, 	/* 0x9FC0 to 0x9FC7 */ 
0x7191, 0x7192, 0x7193, 0x7195, 0x7196, 0x7197, 0x719A, 0x719B, 	/* 0x9FC8 to 0x9FCF */ 
0x719C, 0x719D, 0x719E, 0x71A1, 0x71A2, 0x71A3, 0x71A4, 0x71A5, 	/* 0x9FD0 to 0x9FD7 */ 
0x71A6, 0x71A7, 0x71A9, 0x71AA, 0x71AB, 0x71AD, 0x71AE, 0x71AF, 	/* 0x9FD8 to 0x9FDF */ 
0x71B0, 0x71B1, 0x71B2, 0x71B4, 0x71B6, 0x71B7, 0x71B8, 0x71BA, 	/* 0x9FE0 to 0x9FE7 */ 
0x71BB, 0x71BC, 0x71BD, 0x71BE, 0x71BF, 0x71C0, 0x71C1, 0x71C2, 	/* 0x9FE8 to 0x9FEF */ 
0x71C4, 0x71C5, 0x71C6, 0x71C7, 0x71C8, 0x71C9, 0x71CA, 0x71CB, 	/* 0x9FF0 to 0x9FF7 */ 
0x71CC, 0x71CD, 0x71CF, 0x71D0, 0x71D1, 0x71D2, 0x71D3, 0x0000, 	/* 0x9FF8 to 0x9FFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA000 to 0xA007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA008 to 0xA00F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA010 to 0xA017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA018 to 0xA01F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA020 to 0xA027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA028 to 0xA02F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA030 to 0xA037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA038 to 0xA03F */ 
0x71D6, 0x71D7, 0x71D8, 0x71D9, 0x71DA, 0x71DB, 0x71DC, 0x71DD, 	/* 0xA040 to 0xA047 */ 
0x71DE, 0x71DF, 0x71E1, 0x71E2, 0x71E3, 0x71E4, 0x71E6, 0x71E8, 	/* 0xA048 to 0xA04F */ 
0x71E9, 0x71EA, 0x71EB, 0x71EC, 0x71ED, 0x71EF, 0x71F0, 0x71F1, 	/* 0xA050 to 0xA057 */ 
0x71F2, 0x71F3, 0x71F4, 0x71F5, 0x71F6, 0x71F7, 0x71F8, 0x71FA, 	/* 0xA058 to 0xA05F */ 
0x71FB, 0x71FC, 0x71FD, 0x71FE, 0x71FF, 0x7200, 0x7201, 0x7202, 	/* 0xA060 to 0xA067 */ 
0x7203, 0x7204, 0x7205, 0x7207, 0x7208, 0x7209, 0x720A, 0x720B, 	/* 0xA068 to 0xA06F */ 
0x720C, 0x720D, 0x720E, 0x720F, 0x7210, 0x7211, 0x7212, 0x7213, 	/* 0xA070 to 0xA077 */ 
0x7214, 0x7215, 0x7216, 0x7217, 0x7218, 0x7219, 0x721A, 0x0000, 	/* 0xA078 to 0xA07F */ 
0x721B, 0x721C, 0x721E, 0x721F, 0x7220, 0x7221, 0x7222, 0x7223, 	/* 0xA080 to 0xA087 */ 
0x7224, 0x7225, 0x7226, 0x7227, 0x7229, 0x722B, 0x722D, 0x722E, 	/* 0xA088 to 0xA08F */ 
0x722F, 0x7232, 0x7233, 0x7234, 0x723A, 0x723C, 0x723E, 0x7240, 	/* 0xA090 to 0xA097 */ 
0x7241, 0x7242, 0x7243, 0x7244, 0x7245, 0x7246, 0x7249, 0x724A, 	/* 0xA098 to 0xA09F */ 
0x724B, 0x724E, 0x724F, 0x7250, 0x7251, 0x7253, 0x7254, 0x7255, 	/* 0xA0A0 to 0xA0A7 */ 
0x7257, 0x7258, 0x725A, 0x725C, 0x725E, 0x7260, 0x7263, 0x7264, 	/* 0xA0A8 to 0xA0AF */ 
0x7265, 0x7268, 0x726A, 0x726B, 0x726C, 0x726D, 0x7270, 0x7271, 	/* 0xA0B0 to 0xA0B7 */ 
0x7273, 0x7274, 0x7276, 0x7277, 0x7278, 0x727B, 0x727C, 0x727D, 	/* 0xA0B8 to 0xA0BF */ 
0x7282, 0x7283, 0x7285, 0x7286, 0x7287, 0x7288, 0x7289, 0x728C, 	/* 0xA0C0 to 0xA0C7 */ 
0x728E, 0x7290, 0x7291, 0x7293, 0x7294, 0x7295, 0x7296, 0x7297, 	/* 0xA0C8 to 0xA0CF */ 
0x7298, 0x7299, 0x729A, 0x729B, 0x729C, 0x729D, 0x729E, 0x72A0, 	/* 0xA0D0 to 0xA0D7 */ 
0x72A1, 0x72A2, 0x72A3, 0x72A4, 0x72A5, 0x72A6, 0x72A7, 0x72A8, 	/* 0xA0D8 to 0xA0DF */ 
0x72A9, 0x72AA, 0x72AB, 0x72AE, 0x72B1, 0x72B2, 0x72B3, 0x72B5, 	/* 0xA0E0 to 0xA0E7 */ 
0x72BA, 0x72BB, 0x72BC, 0x72BD, 0x72BE, 0x72BF, 0x72C0, 0x72C5, 	/* 0xA0E8 to 0xA0EF */ 
0x72C6, 0x72C7, 0x72C9, 0x72CA, 0x72CB, 0x72CC, 0x72CF, 0x72D1, 	/* 0xA0F0 to 0xA0F7 */ 
0x72D3, 0x72D4, 0x72D5, 0x72D6, 0x72D8, 0x72DA, 0x72DB, 0x0000, 	/* 0xA0F8 to 0xA0FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA100 to 0xA107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA108 to 0xA10F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA110 to 0xA117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA118 to 0xA11F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA120 to 0xA127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA128 to 0xA12F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA130 to 0xA137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA138 to 0xA13F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA140 to 0xA147 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA148 to 0xA14F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA150 to 0xA157 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA158 to 0xA15F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA160 to 0xA167 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA168 to 0xA16F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA170 to 0xA177 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA178 to 0xA17F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA180 to 0xA187 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA188 to 0xA18F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA190 to 0xA197 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA198 to 0xA19F */ 
0x0000, 0x3000, 0x3001, 0x3002, 0x00B7, 0x02C9, 0x02C7, 0x00A8, 	/* 0xA1A0 to 0xA1A7 */ 
0x3003, 0x3005, 0x2014, 0xFF5E, 0x2016, 0x2026, 0x2018, 0x2019, 	/* 0xA1A8 to 0xA1AF */ 
0x201C, 0x201D, 0x3014, 0x3015, 0x3008, 0x3009, 0x300A, 0x300B, 	/* 0xA1B0 to 0xA1B7 */ 
0x300C, 0x300D, 0x300E, 0x300F, 0x3016, 0x3017, 0x3010, 0x3011, 	/* 0xA1B8 to 0xA1BF */ 
0x00B1, 0x00D7, 0x00F7, 0x2236, 0x2227, 0x2228, 0x2211, 0x220F, 	/* 0xA1C0 to 0xA1C7 */ 
0x222A, 0x2229, 0x2208, 0x2237, 0x221A, 0x22A5, 0x2225, 0x2220, 	/* 0xA1C8 to 0xA1CF */ 
0x2312, 0x2299, 0x222B, 0x222E, 0x2261, 0x224C, 0x2248, 0x223D, 	/* 0xA1D0 to 0xA1D7 */ 
0x221D, 0x2260, 0x226E, 0x226F, 0x2264, 0x2265, 0x221E, 0x2235, 	/* 0xA1D8 to 0xA1DF */ 
0x2234, 0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFF04, 	/* 0xA1E0 to 0xA1E7 */ 
0x00A4, 0xFFE0, 0xFFE1, 0x2030, 0x00A7, 0x2116, 0x2606, 0x2605, 	/* 0xA1E8 to 0xA1EF */ 
0x25CB, 0x25CF, 0x25CE, 0x25C7, 0x25C6, 0x25A1, 0x25A0, 0x25B3, 	/* 0xA1F0 to 0xA1F7 */ 
0x25B2, 0x203B, 0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0x0000, 	/* 0xA1F8 to 0xA1FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA200 to 0xA207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA208 to 0xA20F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA210 to 0xA217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA218 to 0xA21F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA220 to 0xA227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA228 to 0xA22F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA230 to 0xA237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA238 to 0xA23F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA240 to 0xA247 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA248 to 0xA24F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA250 to 0xA257 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA258 to 0xA25F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA260 to 0xA267 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA268 to 0xA26F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA270 to 0xA277 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA278 to 0xA27F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA280 to 0xA287 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA288 to 0xA28F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA290 to 0xA297 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA298 to 0xA29F */ 
0x0000, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176, 	/* 0xA2A0 to 0xA2A7 */ 
0x2177, 0x2178, 0x2179, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA2A8 to 0xA2AF */ 
0x0000, 0x2488, 0x2489, 0x248A, 0x248B, 0x248C, 0x248D, 0x248E, 	/* 0xA2B0 to 0xA2B7 */ 
0x248F, 0x2490, 0x2491, 0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 	/* 0xA2B8 to 0xA2BF */ 
0x2497, 0x2498, 0x2499, 0x249A, 0x249B, 0x2474, 0x2475, 0x2476, 	/* 0xA2C0 to 0xA2C7 */ 
0x2477, 0x2478, 0x2479, 0x247A, 0x247B, 0x247C, 0x247D, 0x247E, 	/* 0xA2C8 to 0xA2CF */ 
0x247F, 0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 	/* 0xA2D0 to 0xA2D7 */ 
0x2487, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 	/* 0xA2D8 to 0xA2DF */ 
0x2467, 0x2468, 0x2469, 0x0000, 0x0000, 0x3220, 0x3221, 0x3222, 	/* 0xA2E0 to 0xA2E7 */ 
0x3223, 0x3224, 0x3225, 0x3226, 0x3227, 0x3228, 0x3229, 0x0000, 	/* 0xA2E8 to 0xA2EF */ 
0x0000, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 	/* 0xA2F0 to 0xA2F7 */ 
0x2167, 0x2168, 0x2169, 0x216A, 0x216B, 0x0000, 0x0000, 0x0000, 	/* 0xA2F8 to 0xA2FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA300 to 0xA307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA308 to 0xA30F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA310 to 0xA317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA318 to 0xA31F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA320 to 0xA327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA328 to 0xA32F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA330 to 0xA337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA338 to 0xA33F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA340 to 0xA347 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA348 to 0xA34F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA350 to 0xA357 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA358 to 0xA35F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA360 to 0xA367 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA368 to 0xA36F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA370 to 0xA377 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA378 to 0xA37F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA380 to 0xA387 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA388 to 0xA38F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA390 to 0xA397 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA398 to 0xA39F */ 
0x0000, 0xFF01, 0xFF02, 0xFF03, 0xFFE5, 0xFF05, 0xFF06, 0xFF07, 	/* 0xA3A0 to 0xA3A7 */ 
0xFF08, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 	/* 0xA3A8 to 0xA3AF */ 
0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 	/* 0xA3B0 to 0xA3B7 */ 
0xFF18, 0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 	/* 0xA3B8 to 0xA3BF */ 
0xFF20, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 	/* 0xA3C0 to 0xA3C7 */ 
0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 	/* 0xA3C8 to 0xA3CF */ 
0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 	/* 0xA3D0 to 0xA3D7 */ 
0xFF38, 0xFF39, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3D, 0xFF3E, 0xFF3F, 	/* 0xA3D8 to 0xA3DF */ 
0xFF40, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 	/* 0xA3E0 to 0xA3E7 */ 
0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 	/* 0xA3E8 to 0xA3EF */ 
0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 	/* 0xA3F0 to 0xA3F7 */ 
0xFF58, 0xFF59, 0xFF5A, 0xFF5B, 0xFF5C, 0xFF5D, 0xFFE3, 0x0000, 	/* 0xA3F8 to 0xA3FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA400 to 0xA407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA408 to 0xA40F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA410 to 0xA417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA418 to 0xA41F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA420 to 0xA427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA428 to 0xA42F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA430 to 0xA437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA438 to 0xA43F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA440 to 0xA447 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA448 to 0xA44F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA450 to 0xA457 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA458 to 0xA45F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA460 to 0xA467 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA468 to 0xA46F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA470 to 0xA477 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA478 to 0xA47F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA480 to 0xA487 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA488 to 0xA48F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA490 to 0xA497 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA498 to 0xA49F */ 
0x0000, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 	/* 0xA4A0 to 0xA4A7 */ 
0x3048, 0x3049, 0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 	/* 0xA4A8 to 0xA4AF */ 
0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 	/* 0xA4B0 to 0xA4B7 */ 
0x3058, 0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 	/* 0xA4B8 to 0xA4BF */ 
0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 	/* 0xA4C0 to 0xA4C7 */ 
0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 	/* 0xA4C8 to 0xA4CF */ 
0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 	/* 0xA4D0 to 0xA4D7 */ 
0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 	/* 0xA4D8 to 0xA4DF */ 
0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 	/* 0xA4E0 to 0xA4E7 */ 
0x3088, 0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 	/* 0xA4E8 to 0xA4EF */ 
0x3090, 0x3091, 0x3092, 0x3093, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA4F0 to 0xA4F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA4F8 to 0xA4FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA500 to 0xA507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA508 to 0xA50F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA510 to 0xA517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA518 to 0xA51F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA520 to 0xA527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA528 to 0xA52F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA530 to 0xA537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA538 to 0xA53F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA540 to 0xA547 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA548 to 0xA54F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA550 to 0xA557 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA558 to 0xA55F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA560 to 0xA567 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA568 to 0xA56F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA570 to 0xA577 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA578 to 0xA57F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA580 to 0xA587 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA588 to 0xA58F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA590 to 0xA597 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA598 to 0xA59F */ 
0x0000, 0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 	/* 0xA5A0 to 0xA5A7 */ 
0x30A8, 0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 	/* 0xA5A8 to 0xA5AF */ 
0x30B0, 0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 	/* 0xA5B0 to 0xA5B7 */ 
0x30B8, 0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 	/* 0xA5B8 to 0xA5BF */ 
0x30C0, 0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 	/* 0xA5C0 to 0xA5C7 */ 
0x30C8, 0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 	/* 0xA5C8 to 0xA5CF */ 
0x30D0, 0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 	/* 0xA5D0 to 0xA5D7 */ 
0x30D8, 0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 	/* 0xA5D8 to 0xA5DF */ 
0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 	/* 0xA5E0 to 0xA5E7 */ 
0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 	/* 0xA5E8 to 0xA5EF */ 
0x30F0, 0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6, 0x0000, 	/* 0xA5F0 to 0xA5F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA5F8 to 0xA5FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA600 to 0xA607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA608 to 0xA60F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA610 to 0xA617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA618 to 0xA61F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA620 to 0xA627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA628 to 0xA62F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA630 to 0xA637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA638 to 0xA63F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA640 to 0xA647 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA648 to 0xA64F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA650 to 0xA657 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA658 to 0xA65F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA660 to 0xA667 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA668 to 0xA66F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA670 to 0xA677 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA678 to 0xA67F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA680 to 0xA687 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA688 to 0xA68F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA690 to 0xA697 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA698 to 0xA69F */ 
0x0000, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 	/* 0xA6A0 to 0xA6A7 */ 
0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 	/* 0xA6A8 to 0xA6AF */ 
0x03A0, 0x03A1, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 	/* 0xA6B0 to 0xA6B7 */ 
0x03A9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA6B8 to 0xA6BF */ 
0x0000, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 	/* 0xA6C0 to 0xA6C7 */ 
0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 	/* 0xA6C8 to 0xA6CF */ 
0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 	/* 0xA6D0 to 0xA6D7 */ 
0x03C9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA6D8 to 0xA6DF */ 
0xFE35, 0xFE36, 0xFE39, 0xFE3A, 0xFE3F, 0xFE40, 0xFE3D, 0xFE3E, 	/* 0xA6E0 to 0xA6E7 */ 
0xFE41, 0xFE42, 0xFE43, 0xFE44, 0x0000, 0x0000, 0xFE3B, 0xFE3C, 	/* 0xA6E8 to 0xA6EF */ 
0xFE37, 0xFE38, 0xFE31, 0x0000, 0xFE33, 0xFE34, 0x0000, 0x0000, 	/* 0xA6F0 to 0xA6F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA6F8 to 0xA6FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA700 to 0xA707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA708 to 0xA70F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA710 to 0xA717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA718 to 0xA71F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA720 to 0xA727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA728 to 0xA72F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA730 to 0xA737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA738 to 0xA73F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA740 to 0xA747 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA748 to 0xA74F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA750 to 0xA757 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA758 to 0xA75F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA760 to 0xA767 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA768 to 0xA76F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA770 to 0xA777 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA778 to 0xA77F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA780 to 0xA787 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA788 to 0xA78F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA790 to 0xA797 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA798 to 0xA79F */ 
0x0000, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 	/* 0xA7A0 to 0xA7A7 */ 
0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 	/* 0xA7A8 to 0xA7AF */ 
0x041E, 0x041F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 	/* 0xA7B0 to 0xA7B7 */ 
0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 	/* 0xA7B8 to 0xA7BF */ 
0x042E, 0x042F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA7C0 to 0xA7C7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA7C8 to 0xA7CF */ 
0x0000, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 	/* 0xA7D0 to 0xA7D7 */ 
0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 	/* 0xA7D8 to 0xA7DF */ 
0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 	/* 0xA7E0 to 0xA7E7 */ 
0x0446, 0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 	/* 0xA7E8 to 0xA7EF */ 
0x044E, 0x044F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA7F0 to 0xA7F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA7F8 to 0xA7FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA800 to 0xA807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA808 to 0xA80F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA810 to 0xA817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA818 to 0xA81F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA820 to 0xA827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA828 to 0xA82F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA830 to 0xA837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA838 to 0xA83F */ 
0x02CA, 0x02CB, 0x02D9, 0x2013, 0x2015, 0x2025, 0x2035, 0x2105, 	/* 0xA840 to 0xA847 */ 
0x2109, 0x2196, 0x2197, 0x2198, 0x2199, 0x2215, 0x221F, 0x2223, 	/* 0xA848 to 0xA84F */ 
0x2252, 0x2266, 0x2267, 0x22BF, 0x2550, 0x2551, 0x2552, 0x2553, 	/* 0xA850 to 0xA857 */ 
0x2554, 0x2555, 0x2556, 0x2557, 0x2558, 0x2559, 0x255A, 0x255B, 	/* 0xA858 to 0xA85F */ 
0x255C, 0x255D, 0x255E, 0x255F, 0x2560, 0x2561, 0x2562, 0x2563, 	/* 0xA860 to 0xA867 */ 
0x2564, 0x2565, 0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x256B, 	/* 0xA868 to 0xA86F */ 
0x256C, 0x256D, 0x256E, 0x256F, 0x2570, 0x2571, 0x2572, 0x2573, 	/* 0xA870 to 0xA877 */ 
0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2586, 0x2587, 0x0000, 	/* 0xA878 to 0xA87F */ 
0x2588, 0x2589, 0x258A, 0x258B, 0x258C, 0x258D, 0x258E, 0x258F, 	/* 0xA880 to 0xA887 */ 
0x2593, 0x2594, 0x2595, 0x25BC, 0x25BD, 0x25E2, 0x25E3, 0x25E4, 	/* 0xA888 to 0xA88F */ 
0x25E5, 0x2609, 0x2295, 0x3012, 0x301D, 0x301E, 0x0000, 0x0000, 	/* 0xA890 to 0xA897 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA898 to 0xA89F */ 
0x0000, 0x0101, 0x00E1, 0x01CE, 0x00E0, 0x0113, 0x00E9, 0x011B, 	/* 0xA8A0 to 0xA8A7 */ 
0x00E8, 0x012B, 0x00ED, 0x01D0, 0x00EC, 0x014D, 0x00F3, 0x01D2, 	/* 0xA8A8 to 0xA8AF */ 
0x00F2, 0x016B, 0x00FA, 0x01D4, 0x00F9, 0x01D6, 0x01D8, 0x01DA, 	/* 0xA8B0 to 0xA8B7 */ 
0x01DC, 0x00FC, 0x00EA, 0x0251, 0x0000, 0x0144, 0x0148, 0x0000, 	/* 0xA8B8 to 0xA8BF */ 
0x0261, 0x0000, 0x0000, 0x0000, 0x0000, 0x3105, 0x3106, 0x3107, 	/* 0xA8C0 to 0xA8C7 */ 
0x3108, 0x3109, 0x310A, 0x310B, 0x310C, 0x310D, 0x310E, 0x310F, 	/* 0xA8C8 to 0xA8CF */ 
0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116, 0x3117, 	/* 0xA8D0 to 0xA8D7 */ 
0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D, 0x311E, 0x311F, 	/* 0xA8D8 to 0xA8DF */ 
0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126, 0x3127, 	/* 0xA8E0 to 0xA8E7 */ 
0x3128, 0x3129, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA8E8 to 0xA8EF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA8F0 to 0xA8F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA8F8 to 0xA8FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA900 to 0xA907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA908 to 0xA90F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA910 to 0xA917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA918 to 0xA91F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA920 to 0xA927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA928 to 0xA92F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA930 to 0xA937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA938 to 0xA93F */ 
0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027, 0x3028, 	/* 0xA940 to 0xA947 */ 
0x3029, 0x32A3, 0x338E, 0x338F, 0x339C, 0x339D, 0x339E, 0x33A1, 	/* 0xA948 to 0xA94F */ 
0x33C4, 0x33CE, 0x33D1, 0x33D2, 0x33D5, 0xFE30, 0xFFE2, 0xFFE4, 	/* 0xA950 to 0xA957 */ 
0x0000, 0x2121, 0x3231, 0x0000, 0x2010, 0x0000, 0x0000, 0x0000, 	/* 0xA958 to 0xA95F */ 
0x30FC, 0x309B, 0x309C, 0x30FD, 0x30FE, 0x3006, 0x309D, 0x309E, 	/* 0xA960 to 0xA967 */ 
0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F, 0xFE50, 	/* 0xA968 to 0xA96F */ 
0xFE51, 0xFE52, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFE59, 0xFE5A, 	/* 0xA970 to 0xA977 */ 
0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F, 0xFE60, 0xFE61, 0x0000, 	/* 0xA978 to 0xA97F */ 
0xFE62, 0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE68, 0xFE69, 0xFE6A, 	/* 0xA980 to 0xA987 */ 
0xFE6B, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA988 to 0xA98F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3007, 0x0000, 	/* 0xA990 to 0xA997 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA998 to 0xA99F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x2500, 0x2501, 0x2502, 0x2503, 	/* 0xA9A0 to 0xA9A7 */ 
0x2504, 0x2505, 0x2506, 0x2507, 0x2508, 0x2509, 0x250A, 0x250B, 	/* 0xA9A8 to 0xA9AF */ 
0x250C, 0x250D, 0x250E, 0x250F, 0x2510, 0x2511, 0x2512, 0x2513, 	/* 0xA9B0 to 0xA9B7 */ 
0x2514, 0x2515, 0x2516, 0x2517, 0x2518, 0x2519, 0x251A, 0x251B, 	/* 0xA9B8 to 0xA9BF */ 
0x251C, 0x251D, 0x251E, 0x251F, 0x2520, 0x2521, 0x2522, 0x2523, 	/* 0xA9C0 to 0xA9C7 */ 
0x2524, 0x2525, 0x2526, 0x2527, 0x2528, 0x2529, 0x252A, 0x252B, 	/* 0xA9C8 to 0xA9CF */ 
0x252C, 0x252D, 0x252E, 0x252F, 0x2530, 0x2531, 0x2532, 0x2533, 	/* 0xA9D0 to 0xA9D7 */ 
0x2534, 0x2535, 0x2536, 0x2537, 0x2538, 0x2539, 0x253A, 0x253B, 	/* 0xA9D8 to 0xA9DF */ 
0x253C, 0x253D, 0x253E, 0x253F, 0x2540, 0x2541, 0x2542, 0x2543, 	/* 0xA9E0 to 0xA9E7 */ 
0x2544, 0x2545, 0x2546, 0x2547, 0x2548, 0x2549, 0x254A, 0x254B, 	/* 0xA9E8 to 0xA9EF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA9F0 to 0xA9F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA9F8 to 0xA9FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA00 to 0xAA07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA08 to 0xAA0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA10 to 0xAA17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA18 to 0xAA1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA20 to 0xAA27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA28 to 0xAA2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA30 to 0xAA37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA38 to 0xAA3F */ 
0x72DC, 0x72DD, 0x72DF, 0x72E2, 0x72E3, 0x72E4, 0x72E5, 0x72E6, 	/* 0xAA40 to 0xAA47 */ 
0x72E7, 0x72EA, 0x72EB, 0x72F5, 0x72F6, 0x72F9, 0x72FD, 0x72FE, 	/* 0xAA48 to 0xAA4F */ 
0x72FF, 0x7300, 0x7302, 0x7304, 0x7305, 0x7306, 0x7307, 0x7308, 	/* 0xAA50 to 0xAA57 */ 
0x7309, 0x730B, 0x730C, 0x730D, 0x730F, 0x7310, 0x7311, 0x7312, 	/* 0xAA58 to 0xAA5F */ 
0x7314, 0x7318, 0x7319, 0x731A, 0x731F, 0x7320, 0x7323, 0x7324, 	/* 0xAA60 to 0xAA67 */ 
0x7326, 0x7327, 0x7328, 0x732D, 0x732F, 0x7330, 0x7332, 0x7333, 	/* 0xAA68 to 0xAA6F */ 
0x7335, 0x7336, 0x733A, 0x733B, 0x733C, 0x733D, 0x7340, 0x7341, 	/* 0xAA70 to 0xAA77 */ 
0x7342, 0x7343, 0x7344, 0x7345, 0x7346, 0x7347, 0x7348, 0x0000, 	/* 0xAA78 to 0xAA7F */ 
0x7349, 0x734A, 0x734B, 0x734C, 0x734E, 0x734F, 0x7351, 0x7353, 	/* 0xAA80 to 0xAA87 */ 
0x7354, 0x7355, 0x7356, 0x7358, 0x7359, 0x735A, 0x735B, 0x735C, 	/* 0xAA88 to 0xAA8F */ 
0x735D, 0x735E, 0x735F, 0x7361, 0x7362, 0x7363, 0x7364, 0x7365, 	/* 0xAA90 to 0xAA97 */ 
0x7366, 0x7367, 0x7368, 0x7369, 0x736A, 0x736B, 0x736E, 0x7370, 	/* 0xAA98 to 0xAA9F */ 
0x7371, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAA0 to 0xAAA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAA8 to 0xAAAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAB0 to 0xAAB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAB8 to 0xAABF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAC0 to 0xAAC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAC8 to 0xAACF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAD0 to 0xAAD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAD8 to 0xAADF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAE0 to 0xAAE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAE8 to 0xAAEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAF0 to 0xAAF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAAF8 to 0xAAFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB00 to 0xAB07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB08 to 0xAB0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB10 to 0xAB17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB18 to 0xAB1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB20 to 0xAB27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB28 to 0xAB2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB30 to 0xAB37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB38 to 0xAB3F */ 
0x7372, 0x7373, 0x7374, 0x7375, 0x7376, 0x7377, 0x7378, 0x7379, 	/* 0xAB40 to 0xAB47 */ 
0x737A, 0x737B, 0x737C, 0x737D, 0x737F, 0x7380, 0x7381, 0x7382, 	/* 0xAB48 to 0xAB4F */ 
0x7383, 0x7385, 0x7386, 0x7388, 0x738A, 0x738C, 0x738D, 0x738F, 	/* 0xAB50 to 0xAB57 */ 
0x7390, 0x7392, 0x7393, 0x7394, 0x7395, 0x7397, 0x7398, 0x7399, 	/* 0xAB58 to 0xAB5F */ 
0x739A, 0x739C, 0x739D, 0x739E, 0x73A0, 0x73A1, 0x73A3, 0x73A4, 	/* 0xAB60 to 0xAB67 */ 
0x73A5, 0x73A6, 0x73A7, 0x73A8, 0x73AA, 0x73AC, 0x73AD, 0x73B1, 	/* 0xAB68 to 0xAB6F */ 
0x73B4, 0x73B5, 0x73B6, 0x73B8, 0x73B9, 0x73BC, 0x73BD, 0x73BE, 	/* 0xAB70 to 0xAB77 */ 
0x73BF, 0x73C1, 0x73C3, 0x73C4, 0x73C5, 0x73C6, 0x73C7, 0x0000, 	/* 0xAB78 to 0xAB7F */ 
0x73CB, 0x73CC, 0x73CE, 0x73D2, 0x73D3, 0x73D4, 0x73D5, 0x73D6, 	/* 0xAB80 to 0xAB87 */ 
0x73D7, 0x73D8, 0x73DA, 0x73DB, 0x73DC, 0x73DD, 0x73DF, 0x73E1, 	/* 0xAB88 to 0xAB8F */ 
0x73E2, 0x73E3, 0x73E4, 0x73E6, 0x73E8, 0x73EA, 0x73EB, 0x73EC, 	/* 0xAB90 to 0xAB97 */ 
0x73EE, 0x73EF, 0x73F0, 0x73F1, 0x73F3, 0x73F4, 0x73F5, 0x73F6, 	/* 0xAB98 to 0xAB9F */ 
0x73F7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABA0 to 0xABA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABA8 to 0xABAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABB0 to 0xABB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABB8 to 0xABBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABC0 to 0xABC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABC8 to 0xABCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABD0 to 0xABD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABD8 to 0xABDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABE0 to 0xABE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABE8 to 0xABEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABF0 to 0xABF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xABF8 to 0xABFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC00 to 0xAC07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC08 to 0xAC0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC10 to 0xAC17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC18 to 0xAC1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC20 to 0xAC27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC28 to 0xAC2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC30 to 0xAC37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC38 to 0xAC3F */ 
0x73F8, 0x73F9, 0x73FA, 0x73FB, 0x73FC, 0x73FD, 0x73FE, 0x73FF, 	/* 0xAC40 to 0xAC47 */ 
0x7400, 0x7401, 0x7402, 0x7404, 0x7407, 0x7408, 0x740B, 0x740C, 	/* 0xAC48 to 0xAC4F */ 
0x740D, 0x740E, 0x7411, 0x7412, 0x7413, 0x7414, 0x7415, 0x7416, 	/* 0xAC50 to 0xAC57 */ 
0x7417, 0x7418, 0x7419, 0x741C, 0x741D, 0x741E, 0x741F, 0x7420, 	/* 0xAC58 to 0xAC5F */ 
0x7421, 0x7423, 0x7424, 0x7427, 0x7429, 0x742B, 0x742D, 0x742F, 	/* 0xAC60 to 0xAC67 */ 
0x7431, 0x7432, 0x7437, 0x7438, 0x7439, 0x743A, 0x743B, 0x743D, 	/* 0xAC68 to 0xAC6F */ 
0x743E, 0x743F, 0x7440, 0x7442, 0x7443, 0x7444, 0x7445, 0x7446, 	/* 0xAC70 to 0xAC77 */ 
0x7447, 0x7448, 0x7449, 0x744A, 0x744B, 0x744C, 0x744D, 0x0000, 	/* 0xAC78 to 0xAC7F */ 
0x744E, 0x744F, 0x7450, 0x7451, 0x7452, 0x7453, 0x7454, 0x7456, 	/* 0xAC80 to 0xAC87 */ 
0x7458, 0x745D, 0x7460, 0x7461, 0x7462, 0x7463, 0x7464, 0x7465, 	/* 0xAC88 to 0xAC8F */ 
0x7466, 0x7467, 0x7468, 0x7469, 0x746A, 0x746B, 0x746C, 0x746E, 	/* 0xAC90 to 0xAC97 */ 
0x746F, 0x7471, 0x7472, 0x7473, 0x7474, 0x7475, 0x7478, 0x7479, 	/* 0xAC98 to 0xAC9F */ 
0x747A, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACA0 to 0xACA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACA8 to 0xACAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACB0 to 0xACB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACB8 to 0xACBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACC0 to 0xACC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACC8 to 0xACCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACD0 to 0xACD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACD8 to 0xACDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACE0 to 0xACE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACE8 to 0xACEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACF0 to 0xACF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xACF8 to 0xACFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD00 to 0xAD07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD08 to 0xAD0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD10 to 0xAD17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD18 to 0xAD1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD20 to 0xAD27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD28 to 0xAD2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD30 to 0xAD37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD38 to 0xAD3F */ 
0x747B, 0x747C, 0x747D, 0x747F, 0x7482, 0x7484, 0x7485, 0x7486, 	/* 0xAD40 to 0xAD47 */ 
0x7488, 0x7489, 0x748A, 0x748C, 0x748D, 0x748F, 0x7491, 0x7492, 	/* 0xAD48 to 0xAD4F */ 
0x7493, 0x7494, 0x7495, 0x7496, 0x7497, 0x7498, 0x7499, 0x749A, 	/* 0xAD50 to 0xAD57 */ 
0x749B, 0x749D, 0x749F, 0x74A0, 0x74A1, 0x74A2, 0x74A3, 0x74A4, 	/* 0xAD58 to 0xAD5F */ 
0x74A5, 0x74A6, 0x74AA, 0x74AB, 0x74AC, 0x74AD, 0x74AE, 0x74AF, 	/* 0xAD60 to 0xAD67 */ 
0x74B0, 0x74B1, 0x74B2, 0x74B3, 0x74B4, 0x74B5, 0x74B6, 0x74B7, 	/* 0xAD68 to 0xAD6F */ 
0x74B8, 0x74B9, 0x74BB, 0x74BC, 0x74BD, 0x74BE, 0x74BF, 0x74C0, 	/* 0xAD70 to 0xAD77 */ 
0x74C1, 0x74C2, 0x74C3, 0x74C4, 0x74C5, 0x74C6, 0x74C7, 0x0000, 	/* 0xAD78 to 0xAD7F */ 
0x74C8, 0x74C9, 0x74CA, 0x74CB, 0x74CC, 0x74CD, 0x74CE, 0x74CF, 	/* 0xAD80 to 0xAD87 */ 
0x74D0, 0x74D1, 0x74D3, 0x74D4, 0x74D5, 0x74D6, 0x74D7, 0x74D8, 	/* 0xAD88 to 0xAD8F */ 
0x74D9, 0x74DA, 0x74DB, 0x74DD, 0x74DF, 0x74E1, 0x74E5, 0x74E7, 	/* 0xAD90 to 0xAD97 */ 
0x74E8, 0x74E9, 0x74EA, 0x74EB, 0x74EC, 0x74ED, 0x74F0, 0x74F1, 	/* 0xAD98 to 0xAD9F */ 
0x74F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADA0 to 0xADA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADA8 to 0xADAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADB0 to 0xADB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADB8 to 0xADBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADC0 to 0xADC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADC8 to 0xADCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADD0 to 0xADD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADD8 to 0xADDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADE0 to 0xADE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADE8 to 0xADEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADF0 to 0xADF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xADF8 to 0xADFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE00 to 0xAE07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE08 to 0xAE0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE10 to 0xAE17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE18 to 0xAE1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE20 to 0xAE27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE28 to 0xAE2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE30 to 0xAE37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE38 to 0xAE3F */ 
0x74F3, 0x74F5, 0x74F8, 0x74F9, 0x74FA, 0x74FB, 0x74FC, 0x74FD, 	/* 0xAE40 to 0xAE47 */ 
0x74FE, 0x7500, 0x7501, 0x7502, 0x7503, 0x7505, 0x7506, 0x7507, 	/* 0xAE48 to 0xAE4F */ 
0x7508, 0x7509, 0x750A, 0x750B, 0x750C, 0x750E, 0x7510, 0x7512, 	/* 0xAE50 to 0xAE57 */ 
0x7514, 0x7515, 0x7516, 0x7517, 0x751B, 0x751D, 0x751E, 0x7520, 	/* 0xAE58 to 0xAE5F */ 
0x7521, 0x7522, 0x7523, 0x7524, 0x7526, 0x7527, 0x752A, 0x752E, 	/* 0xAE60 to 0xAE67 */ 
0x7534, 0x7536, 0x7539, 0x753C, 0x753D, 0x753F, 0x7541, 0x7542, 	/* 0xAE68 to 0xAE6F */ 
0x7543, 0x7544, 0x7546, 0x7547, 0x7549, 0x754A, 0x754D, 0x7550, 	/* 0xAE70 to 0xAE77 */ 
0x7551, 0x7552, 0x7553, 0x7555, 0x7556, 0x7557, 0x7558, 0x0000, 	/* 0xAE78 to 0xAE7F */ 
0x755D, 0x755E, 0x755F, 0x7560, 0x7561, 0x7562, 0x7563, 0x7564, 	/* 0xAE80 to 0xAE87 */ 
0x7567, 0x7568, 0x7569, 0x756B, 0x756C, 0x756D, 0x756E, 0x756F, 	/* 0xAE88 to 0xAE8F */ 
0x7570, 0x7571, 0x7573, 0x7575, 0x7576, 0x7577, 0x757A, 0x757B, 	/* 0xAE90 to 0xAE97 */ 
0x757C, 0x757D, 0x757E, 0x7580, 0x7581, 0x7582, 0x7584, 0x7585, 	/* 0xAE98 to 0xAE9F */ 
0x7587, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEA0 to 0xAEA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEA8 to 0xAEAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEB0 to 0xAEB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEB8 to 0xAEBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEC0 to 0xAEC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEC8 to 0xAECF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAED0 to 0xAED7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAED8 to 0xAEDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEE0 to 0xAEE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEE8 to 0xAEEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEF0 to 0xAEF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAEF8 to 0xAEFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF00 to 0xAF07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF08 to 0xAF0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF10 to 0xAF17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF18 to 0xAF1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF20 to 0xAF27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF28 to 0xAF2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF30 to 0xAF37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF38 to 0xAF3F */ 
0x7588, 0x7589, 0x758A, 0x758C, 0x758D, 0x758E, 0x7590, 0x7593, 	/* 0xAF40 to 0xAF47 */ 
0x7595, 0x7598, 0x759B, 0x759C, 0x759E, 0x75A2, 0x75A6, 0x75A7, 	/* 0xAF48 to 0xAF4F */ 
0x75A8, 0x75A9, 0x75AA, 0x75AD, 0x75B6, 0x75B7, 0x75BA, 0x75BB, 	/* 0xAF50 to 0xAF57 */ 
0x75BF, 0x75C0, 0x75C1, 0x75C6, 0x75CB, 0x75CC, 0x75CE, 0x75CF, 	/* 0xAF58 to 0xAF5F */ 
0x75D0, 0x75D1, 0x75D3, 0x75D7, 0x75D9, 0x75DA, 0x75DC, 0x75DD, 	/* 0xAF60 to 0xAF67 */ 
0x75DF, 0x75E0, 0x75E1, 0x75E5, 0x75E9, 0x75EC, 0x75ED, 0x75EE, 	/* 0xAF68 to 0xAF6F */ 
0x75EF, 0x75F2, 0x75F3, 0x75F5, 0x75F6, 0x75F7, 0x75F8, 0x75FA, 	/* 0xAF70 to 0xAF77 */ 
0x75FB, 0x75FD, 0x75FE, 0x7602, 0x7604, 0x7606, 0x7607, 0x0000, 	/* 0xAF78 to 0xAF7F */ 
0x7608, 0x7609, 0x760B, 0x760D, 0x760E, 0x760F, 0x7611, 0x7612, 	/* 0xAF80 to 0xAF87 */ 
0x7613, 0x7614, 0x7616, 0x761A, 0x761C, 0x761D, 0x761E, 0x7621, 	/* 0xAF88 to 0xAF8F */ 
0x7623, 0x7627, 0x7628, 0x762C, 0x762E, 0x762F, 0x7631, 0x7632, 	/* 0xAF90 to 0xAF97 */ 
0x7636, 0x7637, 0x7639, 0x763A, 0x763B, 0x763D, 0x7641, 0x7642, 	/* 0xAF98 to 0xAF9F */ 
0x7644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFA0 to 0xAFA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFA8 to 0xAFAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFB0 to 0xAFB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFB8 to 0xAFBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFC0 to 0xAFC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFC8 to 0xAFCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFD0 to 0xAFD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFD8 to 0xAFDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFE0 to 0xAFE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFE8 to 0xAFEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFF0 to 0xAFF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAFF8 to 0xAFFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB000 to 0xB007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB008 to 0xB00F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB010 to 0xB017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB018 to 0xB01F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB020 to 0xB027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB028 to 0xB02F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB030 to 0xB037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB038 to 0xB03F */ 
0x7645, 0x7646, 0x7647, 0x7648, 0x7649, 0x764A, 0x764B, 0x764E, 	/* 0xB040 to 0xB047 */ 
0x764F, 0x7650, 0x7651, 0x7652, 0x7653, 0x7655, 0x7657, 0x7658, 	/* 0xB048 to 0xB04F */ 
0x7659, 0x765A, 0x765B, 0x765D, 0x765F, 0x7660, 0x7661, 0x7662, 	/* 0xB050 to 0xB057 */ 
0x7664, 0x7665, 0x7666, 0x7667, 0x7668, 0x7669, 0x766A, 0x766C, 	/* 0xB058 to 0xB05F */ 
0x766D, 0x766E, 0x7670, 0x7671, 0x7672, 0x7673, 0x7674, 0x7675, 	/* 0xB060 to 0xB067 */ 
0x7676, 0x7677, 0x7679, 0x767A, 0x767C, 0x767F, 0x7680, 0x7681, 	/* 0xB068 to 0xB06F */ 
0x7683, 0x7685, 0x7689, 0x768A, 0x768C, 0x768D, 0x768F, 0x7690, 	/* 0xB070 to 0xB077 */ 
0x7692, 0x7694, 0x7695, 0x7697, 0x7698, 0x769A, 0x769B, 0x0000, 	/* 0xB078 to 0xB07F */ 
0x769C, 0x769D, 0x769E, 0x769F, 0x76A0, 0x76A1, 0x76A2, 0x76A3, 	/* 0xB080 to 0xB087 */ 
0x76A5, 0x76A6, 0x76A7, 0x76A8, 0x76A9, 0x76AA, 0x76AB, 0x76AC, 	/* 0xB088 to 0xB08F */ 
0x76AD, 0x76AF, 0x76B0, 0x76B3, 0x76B5, 0x76B6, 0x76B7, 0x76B8, 	/* 0xB090 to 0xB097 */ 
0x76B9, 0x76BA, 0x76BB, 0x76BC, 0x76BD, 0x76BE, 0x76C0, 0x76C1, 	/* 0xB098 to 0xB09F */ 
0x76C3, 0x554A, 0x963F, 0x57C3, 0x6328, 0x54CE, 0x5509, 0x54C0, 	/* 0xB0A0 to 0xB0A7 */ 
0x7691, 0x764C, 0x853C, 0x77EE, 0x827E, 0x788D, 0x7231, 0x9698, 	/* 0xB0A8 to 0xB0AF */ 
0x978D, 0x6C28, 0x5B89, 0x4FFA, 0x6309, 0x6697, 0x5CB8, 0x80FA, 	/* 0xB0B0 to 0xB0B7 */ 
0x6848, 0x80AE, 0x6602, 0x76CE, 0x51F9, 0x6556, 0x71AC, 0x7FF1, 	/* 0xB0B8 to 0xB0BF */ 
0x8884, 0x50B2, 0x5965, 0x61CA, 0x6FB3, 0x82AD, 0x634C, 0x6252, 	/* 0xB0C0 to 0xB0C7 */ 
0x53ED, 0x5427, 0x7B06, 0x516B, 0x75A4, 0x5DF4, 0x62D4, 0x8DCB, 	/* 0xB0C8 to 0xB0CF */ 
0x9776, 0x628A, 0x8019, 0x575D, 0x9738, 0x7F62, 0x7238, 0x767D, 	/* 0xB0D0 to 0xB0D7 */ 
0x67CF, 0x767E, 0x6446, 0x4F70, 0x8D25, 0x62DC, 0x7A17, 0x6591, 	/* 0xB0D8 to 0xB0DF */ 
0x73ED, 0x642C, 0x6273, 0x822C, 0x9881, 0x677F, 0x7248, 0x626E, 	/* 0xB0E0 to 0xB0E7 */ 
0x62CC, 0x4F34, 0x74E3, 0x534A, 0x529E, 0x7ECA, 0x90A6, 0x5E2E, 	/* 0xB0E8 to 0xB0EF */ 
0x6886, 0x699C, 0x8180, 0x7ED1, 0x68D2, 0x78C5, 0x868C, 0x9551, 	/* 0xB0F0 to 0xB0F7 */ 
0x508D, 0x8C24, 0x82DE, 0x80DE, 0x5305, 0x8912, 0x5265, 0x0000, 	/* 0xB0F8 to 0xB0FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB100 to 0xB107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB108 to 0xB10F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB110 to 0xB117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB118 to 0xB11F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB120 to 0xB127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB128 to 0xB12F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB130 to 0xB137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB138 to 0xB13F */ 
0x76C4, 0x76C7, 0x76C9, 0x76CB, 0x76CC, 0x76D3, 0x76D5, 0x76D9, 	/* 0xB140 to 0xB147 */ 
0x76DA, 0x76DC, 0x76DD, 0x76DE, 0x76E0, 0x76E1, 0x76E2, 0x76E3, 	/* 0xB148 to 0xB14F */ 
0x76E4, 0x76E6, 0x76E7, 0x76E8, 0x76E9, 0x76EA, 0x76EB, 0x76EC, 	/* 0xB150 to 0xB157 */ 
0x76ED, 0x76F0, 0x76F3, 0x76F5, 0x76F6, 0x76F7, 0x76FA, 0x76FB, 	/* 0xB158 to 0xB15F */ 
0x76FD, 0x76FF, 0x7700, 0x7702, 0x7703, 0x7705, 0x7706, 0x770A, 	/* 0xB160 to 0xB167 */ 
0x770C, 0x770E, 0x770F, 0x7710, 0x7711, 0x7712, 0x7713, 0x7714, 	/* 0xB168 to 0xB16F */ 
0x7715, 0x7716, 0x7717, 0x7718, 0x771B, 0x771C, 0x771D, 0x771E, 	/* 0xB170 to 0xB177 */ 
0x7721, 0x7723, 0x7724, 0x7725, 0x7727, 0x772A, 0x772B, 0x0000, 	/* 0xB178 to 0xB17F */ 
0x772C, 0x772E, 0x7730, 0x7731, 0x7732, 0x7733, 0x7734, 0x7739, 	/* 0xB180 to 0xB187 */ 
0x773B, 0x773D, 0x773E, 0x773F, 0x7742, 0x7744, 0x7745, 0x7746, 	/* 0xB188 to 0xB18F */ 
0x7748, 0x7749, 0x774A, 0x774B, 0x774C, 0x774D, 0x774E, 0x774F, 	/* 0xB190 to 0xB197 */ 
0x7752, 0x7753, 0x7754, 0x7755, 0x7756, 0x7757, 0x7758, 0x7759, 	/* 0xB198 to 0xB19F */ 
0x775C, 0x8584, 0x96F9, 0x4FDD, 0x5821, 0x9971, 0x5B9D, 0x62B1, 	/* 0xB1A0 to 0xB1A7 */ 
0x62A5, 0x66B4, 0x8C79, 0x9C8D, 0x7206, 0x676F, 0x7891, 0x60B2, 	/* 0xB1A8 to 0xB1AF */ 
0x5351, 0x5317, 0x8F88, 0x80CC, 0x8D1D, 0x94A1, 0x500D, 0x72C8, 	/* 0xB1B0 to 0xB1B7 */ 
0x5907, 0x60EB, 0x7119, 0x88AB, 0x5954, 0x82EF, 0x672C, 0x7B28, 	/* 0xB1B8 to 0xB1BF */ 
0x5D29, 0x7EF7, 0x752D, 0x6CF5, 0x8E66, 0x8FF8, 0x903C, 0x9F3B, 	/* 0xB1C0 to 0xB1C7 */ 
0x6BD4, 0x9119, 0x7B14, 0x5F7C, 0x78A7, 0x84D6, 0x853D, 0x6BD5, 	/* 0xB1C8 to 0xB1CF */ 
0x6BD9, 0x6BD6, 0x5E01, 0x5E87, 0x75F9, 0x95ED, 0x655D, 0x5F0A, 	/* 0xB1D0 to 0xB1D7 */ 
0x5FC5, 0x8F9F, 0x58C1, 0x81C2, 0x907F, 0x965B, 0x97AD, 0x8FB9, 	/* 0xB1D8 to 0xB1DF */ 
0x7F16, 0x8D2C, 0x6241, 0x4FBF, 0x53D8, 0x535E, 0x8FA8, 0x8FA9, 	/* 0xB1E0 to 0xB1E7 */ 
0x8FAB, 0x904D, 0x6807, 0x5F6A, 0x8198, 0x8868, 0x9CD6, 0x618B, 	/* 0xB1E8 to 0xB1EF */ 
0x522B, 0x762A, 0x5F6C, 0x658C, 0x6FD2, 0x6EE8, 0x5BBE, 0x6448, 	/* 0xB1F0 to 0xB1F7 */ 
0x5175, 0x51B0, 0x67C4, 0x4E19, 0x79C9, 0x997C, 0x70B3, 0x0000, 	/* 0xB1F8 to 0xB1FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB200 to 0xB207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB208 to 0xB20F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB210 to 0xB217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB218 to 0xB21F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB220 to 0xB227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB228 to 0xB22F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB230 to 0xB237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB238 to 0xB23F */ 
0x775D, 0x775E, 0x775F, 0x7760, 0x7764, 0x7767, 0x7769, 0x776A, 	/* 0xB240 to 0xB247 */ 
0x776D, 0x776E, 0x776F, 0x7770, 0x7771, 0x7772, 0x7773, 0x7774, 	/* 0xB248 to 0xB24F */ 
0x7775, 0x7776, 0x7777, 0x7778, 0x777A, 0x777B, 0x777C, 0x7781, 	/* 0xB250 to 0xB257 */ 
0x7782, 0x7783, 0x7786, 0x7787, 0x7788, 0x7789, 0x778A, 0x778B, 	/* 0xB258 to 0xB25F */ 
0x778F, 0x7790, 0x7793, 0x7794, 0x7795, 0x7796, 0x7797, 0x7798, 	/* 0xB260 to 0xB267 */ 
0x7799, 0x779A, 0x779B, 0x779C, 0x779D, 0x779E, 0x77A1, 0x77A3, 	/* 0xB268 to 0xB26F */ 
0x77A4, 0x77A6, 0x77A8, 0x77AB, 0x77AD, 0x77AE, 0x77AF, 0x77B1, 	/* 0xB270 to 0xB277 */ 
0x77B2, 0x77B4, 0x77B6, 0x77B7, 0x77B8, 0x77B9, 0x77BA, 0x0000, 	/* 0xB278 to 0xB27F */ 
0x77BC, 0x77BE, 0x77C0, 0x77C1, 0x77C2, 0x77C3, 0x77C4, 0x77C5, 	/* 0xB280 to 0xB287 */ 
0x77C6, 0x77C7, 0x77C8, 0x77C9, 0x77CA, 0x77CB, 0x77CC, 0x77CE, 	/* 0xB288 to 0xB28F */ 
0x77CF, 0x77D0, 0x77D1, 0x77D2, 0x77D3, 0x77D4, 0x77D5, 0x77D6, 	/* 0xB290 to 0xB297 */ 
0x77D8, 0x77D9, 0x77DA, 0x77DD, 0x77DE, 0x77DF, 0x77E0, 0x77E1, 	/* 0xB298 to 0xB29F */ 
0x77E4, 0x75C5, 0x5E76, 0x73BB, 0x83E0, 0x64AD, 0x62E8, 0x94B5, 	/* 0xB2A0 to 0xB2A7 */ 
0x6CE2, 0x535A, 0x52C3, 0x640F, 0x94C2, 0x7B94, 0x4F2F, 0x5E1B, 	/* 0xB2A8 to 0xB2AF */ 
0x8236, 0x8116, 0x818A, 0x6E24, 0x6CCA, 0x9A73, 0x6355, 0x535C, 	/* 0xB2B0 to 0xB2B7 */ 
0x54FA, 0x8865, 0x57E0, 0x4E0D, 0x5E03, 0x6B65, 0x7C3F, 0x90E8, 	/* 0xB2B8 to 0xB2BF */ 
0x6016, 0x64E6, 0x731C, 0x88C1, 0x6750, 0x624D, 0x8D22, 0x776C, 	/* 0xB2C0 to 0xB2C7 */ 
0x8E29, 0x91C7, 0x5F69, 0x83DC, 0x8521, 0x9910, 0x53C2, 0x8695, 	/* 0xB2C8 to 0xB2CF */ 
0x6B8B, 0x60ED, 0x60E8, 0x707F, 0x82CD, 0x8231, 0x4ED3, 0x6CA7, 	/* 0xB2D0 to 0xB2D7 */ 
0x85CF, 0x64CD, 0x7CD9, 0x69FD, 0x66F9, 0x8349, 0x5395, 0x7B56, 	/* 0xB2D8 to 0xB2DF */ 
0x4FA7, 0x518C, 0x6D4B, 0x5C42, 0x8E6D, 0x63D2, 0x53C9, 0x832C, 	/* 0xB2E0 to 0xB2E7 */ 
0x8336, 0x67E5, 0x78B4, 0x643D, 0x5BDF, 0x5C94, 0x5DEE, 0x8BE7, 	/* 0xB2E8 to 0xB2EF */ 
0x62C6, 0x67F4, 0x8C7A, 0x6400, 0x63BA, 0x8749, 0x998B, 0x8C17, 	/* 0xB2F0 to 0xB2F7 */ 
0x7F20, 0x94F2, 0x4EA7, 0x9610, 0x98A4, 0x660C, 0x7316, 0x0000, 	/* 0xB2F8 to 0xB2FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB300 to 0xB307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB308 to 0xB30F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB310 to 0xB317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB318 to 0xB31F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB320 to 0xB327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB328 to 0xB32F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB330 to 0xB337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB338 to 0xB33F */ 
0x77E6, 0x77E8, 0x77EA, 0x77EF, 0x77F0, 0x77F1, 0x77F2, 0x77F4, 	/* 0xB340 to 0xB347 */ 
0x77F5, 0x77F7, 0x77F9, 0x77FA, 0x77FB, 0x77FC, 0x7803, 0x7804, 	/* 0xB348 to 0xB34F */ 
0x7805, 0x7806, 0x7807, 0x7808, 0x780A, 0x780B, 0x780E, 0x780F, 	/* 0xB350 to 0xB357 */ 
0x7810, 0x7813, 0x7815, 0x7819, 0x781B, 0x781E, 0x7820, 0x7821, 	/* 0xB358 to 0xB35F */ 
0x7822, 0x7824, 0x7828, 0x782A, 0x782B, 0x782E, 0x782F, 0x7831, 	/* 0xB360 to 0xB367 */ 
0x7832, 0x7833, 0x7835, 0x7836, 0x783D, 0x783F, 0x7841, 0x7842, 	/* 0xB368 to 0xB36F */ 
0x7843, 0x7844, 0x7846, 0x7848, 0x7849, 0x784A, 0x784B, 0x784D, 	/* 0xB370 to 0xB377 */ 
0x784F, 0x7851, 0x7853, 0x7854, 0x7858, 0x7859, 0x785A, 0x0000, 	/* 0xB378 to 0xB37F */ 
0x785B, 0x785C, 0x785E, 0x785F, 0x7860, 0x7861, 0x7862, 0x7863, 	/* 0xB380 to 0xB387 */ 
0x7864, 0x7865, 0x7866, 0x7867, 0x7868, 0x7869, 0x786F, 0x7870, 	/* 0xB388 to 0xB38F */ 
0x7871, 0x7872, 0x7873, 0x7874, 0x7875, 0x7876, 0x7878, 0x7879, 	/* 0xB390 to 0xB397 */ 
0x787A, 0x787B, 0x787D, 0x787E, 0x787F, 0x7880, 0x7881, 0x7882, 	/* 0xB398 to 0xB39F */ 
0x7883, 0x573A, 0x5C1D, 0x5E38, 0x957F, 0x507F, 0x80A0, 0x5382, 	/* 0xB3A0 to 0xB3A7 */ 
0x655E, 0x7545, 0x5531, 0x5021, 0x8D85, 0x6284, 0x949E, 0x671D, 	/* 0xB3A8 to 0xB3AF */ 
0x5632, 0x6F6E, 0x5DE2, 0x5435, 0x7092, 0x8F66, 0x626F, 0x64A4, 	/* 0xB3B0 to 0xB3B7 */ 
0x63A3, 0x5F7B, 0x6F88, 0x90F4, 0x81E3, 0x8FB0, 0x5C18, 0x6668, 	/* 0xB3B8 to 0xB3BF */ 
0x5FF1, 0x6C89, 0x9648, 0x8D81, 0x886C, 0x6491, 0x79F0, 0x57CE, 	/* 0xB3C0 to 0xB3C7 */ 
0x6A59, 0x6210, 0x5448, 0x4E58, 0x7A0B, 0x60E9, 0x6F84, 0x8BDA, 	/* 0xB3C8 to 0xB3CF */ 
0x627F, 0x901E, 0x9A8B, 0x79E4, 0x5403, 0x75F4, 0x6301, 0x5319, 	/* 0xB3D0 to 0xB3D7 */ 
0x6C60, 0x8FDF, 0x5F1B, 0x9A70, 0x803B, 0x9F7F, 0x4F88, 0x5C3A, 	/* 0xB3D8 to 0xB3DF */ 
0x8D64, 0x7FC5, 0x65A5, 0x70BD, 0x5145, 0x51B2, 0x866B, 0x5D07, 	/* 0xB3E0 to 0xB3E7 */ 
0x5BA0, 0x62BD, 0x916C, 0x7574, 0x8E0C, 0x7A20, 0x6101, 0x7B79, 	/* 0xB3E8 to 0xB3EF */ 
0x4EC7, 0x7EF8, 0x7785, 0x4E11, 0x81ED, 0x521D, 0x51FA, 0x6A71, 	/* 0xB3F0 to 0xB3F7 */ 
0x53A8, 0x8E87, 0x9504, 0x96CF, 0x6EC1, 0x9664, 0x695A, 0x0000, 	/* 0xB3F8 to 0xB3FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB400 to 0xB407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB408 to 0xB40F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB410 to 0xB417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB418 to 0xB41F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB420 to 0xB427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB428 to 0xB42F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB430 to 0xB437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB438 to 0xB43F */ 
0x7884, 0x7885, 0x7886, 0x7888, 0x788A, 0x788B, 0x788F, 0x7890, 	/* 0xB440 to 0xB447 */ 
0x7892, 0x7894, 0x7895, 0x7896, 0x7899, 0x789D, 0x789E, 0x78A0, 	/* 0xB448 to 0xB44F */ 
0x78A2, 0x78A4, 0x78A6, 0x78A8, 0x78A9, 0x78AA, 0x78AB, 0x78AC, 	/* 0xB450 to 0xB457 */ 
0x78AD, 0x78AE, 0x78AF, 0x78B5, 0x78B6, 0x78B7, 0x78B8, 0x78BA, 	/* 0xB458 to 0xB45F */ 
0x78BB, 0x78BC, 0x78BD, 0x78BF, 0x78C0, 0x78C2, 0x78C3, 0x78C4, 	/* 0xB460 to 0xB467 */ 
0x78C6, 0x78C7, 0x78C8, 0x78CC, 0x78CD, 0x78CE, 0x78CF, 0x78D1, 	/* 0xB468 to 0xB46F */ 
0x78D2, 0x78D3, 0x78D6, 0x78D7, 0x78D8, 0x78DA, 0x78DB, 0x78DC, 	/* 0xB470 to 0xB477 */ 
0x78DD, 0x78DE, 0x78DF, 0x78E0, 0x78E1, 0x78E2, 0x78E3, 0x0000, 	/* 0xB478 to 0xB47F */ 
0x78E4, 0x78E5, 0x78E6, 0x78E7, 0x78E9, 0x78EA, 0x78EB, 0x78ED, 	/* 0xB480 to 0xB487 */ 
0x78EE, 0x78EF, 0x78F0, 0x78F1, 0x78F3, 0x78F5, 0x78F6, 0x78F8, 	/* 0xB488 to 0xB48F */ 
0x78F9, 0x78FB, 0x78FC, 0x78FD, 0x78FE, 0x78FF, 0x7900, 0x7902, 	/* 0xB490 to 0xB497 */ 
0x7903, 0x7904, 0x7906, 0x7907, 0x7908, 0x7909, 0x790A, 0x790B, 	/* 0xB498 to 0xB49F */ 
0x790C, 0x7840, 0x50A8, 0x77D7, 0x6410, 0x89E6, 0x5904, 0x63E3, 	/* 0xB4A0 to 0xB4A7 */ 
0x5DDD, 0x7A7F, 0x693D, 0x4F20, 0x8239, 0x5598, 0x4E32, 0x75AE, 	/* 0xB4A8 to 0xB4AF */ 
0x7A97, 0x5E62, 0x5E8A, 0x95EF, 0x521B, 0x5439, 0x708A, 0x6376, 	/* 0xB4B0 to 0xB4B7 */ 
0x9524, 0x5782, 0x6625, 0x693F, 0x9187, 0x5507, 0x6DF3, 0x7EAF, 	/* 0xB4B8 to 0xB4BF */ 
0x8822, 0x6233, 0x7EF0, 0x75B5, 0x8328, 0x78C1, 0x96CC, 0x8F9E, 	/* 0xB4C0 to 0xB4C7 */ 
0x6148, 0x74F7, 0x8BCD, 0x6B64, 0x523A, 0x8D50, 0x6B21, 0x806A, 	/* 0xB4C8 to 0xB4CF */ 
0x8471, 0x56F1, 0x5306, 0x4ECE, 0x4E1B, 0x51D1, 0x7C97, 0x918B, 	/* 0xB4D0 to 0xB4D7 */ 
0x7C07, 0x4FC3, 0x8E7F, 0x7BE1, 0x7A9C, 0x6467, 0x5D14, 0x50AC, 	/* 0xB4D8 to 0xB4DF */ 
0x8106, 0x7601, 0x7CB9, 0x6DEC, 0x7FE0, 0x6751, 0x5B58, 0x5BF8, 	/* 0xB4E0 to 0xB4E7 */ 
0x78CB, 0x64AE, 0x6413, 0x63AA, 0x632B, 0x9519, 0x642D, 0x8FBE, 	/* 0xB4E8 to 0xB4EF */ 
0x7B54, 0x7629, 0x6253, 0x5927, 0x5446, 0x6B79, 0x50A3, 0x6234, 	/* 0xB4F0 to 0xB4F7 */ 
0x5E26, 0x6B86, 0x4EE3, 0x8D37, 0x888B, 0x5F85, 0x902E, 0x0000, 	/* 0xB4F8 to 0xB4FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB500 to 0xB507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB508 to 0xB50F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB510 to 0xB517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB518 to 0xB51F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB520 to 0xB527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB528 to 0xB52F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB530 to 0xB537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB538 to 0xB53F */ 
0x790D, 0x790E, 0x790F, 0x7910, 0x7911, 0x7912, 0x7914, 0x7915, 	/* 0xB540 to 0xB547 */ 
0x7916, 0x7917, 0x7918, 0x7919, 0x791A, 0x791B, 0x791C, 0x791D, 	/* 0xB548 to 0xB54F */ 
0x791F, 0x7920, 0x7921, 0x7922, 0x7923, 0x7925, 0x7926, 0x7927, 	/* 0xB550 to 0xB557 */ 
0x7928, 0x7929, 0x792A, 0x792B, 0x792C, 0x792D, 0x792E, 0x792F, 	/* 0xB558 to 0xB55F */ 
0x7930, 0x7931, 0x7932, 0x7933, 0x7935, 0x7936, 0x7937, 0x7938, 	/* 0xB560 to 0xB567 */ 
0x7939, 0x793D, 0x793F, 0x7942, 0x7943, 0x7944, 0x7945, 0x7947, 	/* 0xB568 to 0xB56F */ 
0x794A, 0x794B, 0x794C, 0x794D, 0x794E, 0x794F, 0x7950, 0x7951, 	/* 0xB570 to 0xB577 */ 
0x7952, 0x7954, 0x7955, 0x7958, 0x7959, 0x7961, 0x7963, 0x0000, 	/* 0xB578 to 0xB57F */ 
0x7964, 0x7966, 0x7969, 0x796A, 0x796B, 0x796C, 0x796E, 0x7970, 	/* 0xB580 to 0xB587 */ 
0x7971, 0x7972, 0x7973, 0x7974, 0x7975, 0x7976, 0x7979, 0x797B, 	/* 0xB588 to 0xB58F */ 
0x797C, 0x797D, 0x797E, 0x797F, 0x7982, 0x7983, 0x7986, 0x7987, 	/* 0xB590 to 0xB597 */ 
0x7988, 0x7989, 0x798B, 0x798C, 0x798D, 0x798E, 0x7990, 0x7991, 	/* 0xB598 to 0xB59F */ 
0x7992, 0x6020, 0x803D, 0x62C5, 0x4E39, 0x5355, 0x90F8, 0x63B8, 	/* 0xB5A0 to 0xB5A7 */ 
0x80C6, 0x65E6, 0x6C2E, 0x4F46, 0x60EE, 0x6DE1, 0x8BDE, 0x5F39, 	/* 0xB5A8 to 0xB5AF */ 
0x86CB, 0x5F53, 0x6321, 0x515A, 0x8361, 0x6863, 0x5200, 0x6363, 	/* 0xB5B0 to 0xB5B7 */ 
0x8E48, 0x5012, 0x5C9B, 0x7977, 0x5BFC, 0x5230, 0x7A3B, 0x60BC, 	/* 0xB5B8 to 0xB5BF */ 
0x9053, 0x76D7, 0x5FB7, 0x5F97, 0x7684, 0x8E6C, 0x706F, 0x767B, 	/* 0xB5C0 to 0xB5C7 */ 
0x7B49, 0x77AA, 0x51F3, 0x9093, 0x5824, 0x4F4E, 0x6EF4, 0x8FEA, 	/* 0xB5C8 to 0xB5CF */ 
0x654C, 0x7B1B, 0x72C4, 0x6DA4, 0x7FDF, 0x5AE1, 0x62B5, 0x5E95, 	/* 0xB5D0 to 0xB5D7 */ 
0x5730, 0x8482, 0x7B2C, 0x5E1D, 0x5F1F, 0x9012, 0x7F14, 0x98A0, 	/* 0xB5D8 to 0xB5DF */ 
0x6382, 0x6EC7, 0x7898, 0x70B9, 0x5178, 0x975B, 0x57AB, 0x7535, 	/* 0xB5E0 to 0xB5E7 */ 
0x4F43, 0x7538, 0x5E97, 0x60E6, 0x5960, 0x6DC0, 0x6BBF, 0x7889, 	/* 0xB5E8 to 0xB5EF */ 
0x53FC, 0x96D5, 0x51CB, 0x5201, 0x6389, 0x540A, 0x9493, 0x8C03, 	/* 0xB5F0 to 0xB5F7 */ 
0x8DCC, 0x7239, 0x789F, 0x8776, 0x8FED, 0x8C0D, 0x53E0, 0x0000, 	/* 0xB5F8 to 0xB5FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB600 to 0xB607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB608 to 0xB60F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB610 to 0xB617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB618 to 0xB61F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB620 to 0xB627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB628 to 0xB62F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB630 to 0xB637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB638 to 0xB63F */ 
0x7993, 0x7994, 0x7995, 0x7996, 0x7997, 0x7998, 0x7999, 0x799B, 	/* 0xB640 to 0xB647 */ 
0x799C, 0x799D, 0x799E, 0x799F, 0x79A0, 0x79A1, 0x79A2, 0x79A3, 	/* 0xB648 to 0xB64F */ 
0x79A4, 0x79A5, 0x79A6, 0x79A8, 0x79A9, 0x79AA, 0x79AB, 0x79AC, 	/* 0xB650 to 0xB657 */ 
0x79AD, 0x79AE, 0x79AF, 0x79B0, 0x79B1, 0x79B2, 0x79B4, 0x79B5, 	/* 0xB658 to 0xB65F */ 
0x79B6, 0x79B7, 0x79B8, 0x79BC, 0x79BF, 0x79C2, 0x79C4, 0x79C5, 	/* 0xB660 to 0xB667 */ 
0x79C7, 0x79C8, 0x79CA, 0x79CC, 0x79CE, 0x79CF, 0x79D0, 0x79D3, 	/* 0xB668 to 0xB66F */ 
0x79D4, 0x79D6, 0x79D7, 0x79D9, 0x79DA, 0x79DB, 0x79DC, 0x79DD, 	/* 0xB670 to 0xB677 */ 
0x79DE, 0x79E0, 0x79E1, 0x79E2, 0x79E5, 0x79E8, 0x79EA, 0x0000, 	/* 0xB678 to 0xB67F */ 
0x79EC, 0x79EE, 0x79F1, 0x79F2, 0x79F3, 0x79F4, 0x79F5, 0x79F6, 	/* 0xB680 to 0xB687 */ 
0x79F7, 0x79F9, 0x79FA, 0x79FC, 0x79FE, 0x79FF, 0x7A01, 0x7A04, 	/* 0xB688 to 0xB68F */ 
0x7A05, 0x7A07, 0x7A08, 0x7A09, 0x7A0A, 0x7A0C, 0x7A0F, 0x7A10, 	/* 0xB690 to 0xB697 */ 
0x7A11, 0x7A12, 0x7A13, 0x7A15, 0x7A16, 0x7A18, 0x7A19, 0x7A1B, 	/* 0xB698 to 0xB69F */ 
0x7A1C, 0x4E01, 0x76EF, 0x53EE, 0x9489, 0x9876, 0x9F0E, 0x952D, 	/* 0xB6A0 to 0xB6A7 */ 
0x5B9A, 0x8BA2, 0x4E22, 0x4E1C, 0x51AC, 0x8463, 0x61C2, 0x52A8, 	/* 0xB6A8 to 0xB6AF */ 
0x680B, 0x4F97, 0x606B, 0x51BB, 0x6D1E, 0x515C, 0x6296, 0x6597, 	/* 0xB6B0 to 0xB6B7 */ 
0x9661, 0x8C46, 0x9017, 0x75D8, 0x90FD, 0x7763, 0x6BD2, 0x728A, 	/* 0xB6B8 to 0xB6BF */ 
0x72EC, 0x8BFB, 0x5835, 0x7779, 0x8D4C, 0x675C, 0x9540, 0x809A, 	/* 0xB6C0 to 0xB6C7 */ 
0x5EA6, 0x6E21, 0x5992, 0x7AEF, 0x77ED, 0x953B, 0x6BB5, 0x65AD, 	/* 0xB6C8 to 0xB6CF */ 
0x7F0E, 0x5806, 0x5151, 0x961F, 0x5BF9, 0x58A9, 0x5428, 0x8E72, 	/* 0xB6D0 to 0xB6D7 */ 
0x6566, 0x987F, 0x56E4, 0x949D, 0x76FE, 0x9041, 0x6387, 0x54C6, 	/* 0xB6D8 to 0xB6DF */ 
0x591A, 0x593A, 0x579B, 0x8EB2, 0x6735, 0x8DFA, 0x8235, 0x5241, 	/* 0xB6E0 to 0xB6E7 */ 
0x60F0, 0x5815, 0x86FE, 0x5CE8, 0x9E45, 0x4FC4, 0x989D, 0x8BB9, 	/* 0xB6E8 to 0xB6EF */ 
0x5A25, 0x6076, 0x5384, 0x627C, 0x904F, 0x9102, 0x997F, 0x6069, 	/* 0xB6F0 to 0xB6F7 */ 
0x800C, 0x513F, 0x8033, 0x5C14, 0x9975, 0x6D31, 0x4E8C, 0x0000, 	/* 0xB6F8 to 0xB6FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB700 to 0xB707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB708 to 0xB70F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB710 to 0xB717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB718 to 0xB71F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB720 to 0xB727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB728 to 0xB72F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB730 to 0xB737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB738 to 0xB73F */ 
0x7A1D, 0x7A1F, 0x7A21, 0x7A22, 0x7A24, 0x7A25, 0x7A26, 0x7A27, 	/* 0xB740 to 0xB747 */ 
0x7A28, 0x7A29, 0x7A2A, 0x7A2B, 0x7A2C, 0x7A2D, 0x7A2E, 0x7A2F, 	/* 0xB748 to 0xB74F */ 
0x7A30, 0x7A31, 0x7A32, 0x7A34, 0x7A35, 0x7A36, 0x7A38, 0x7A3A, 	/* 0xB750 to 0xB757 */ 
0x7A3E, 0x7A40, 0x7A41, 0x7A42, 0x7A43, 0x7A44, 0x7A45, 0x7A47, 	/* 0xB758 to 0xB75F */ 
0x7A48, 0x7A49, 0x7A4A, 0x7A4B, 0x7A4C, 0x7A4D, 0x7A4E, 0x7A4F, 	/* 0xB760 to 0xB767 */ 
0x7A50, 0x7A52, 0x7A53, 0x7A54, 0x7A55, 0x7A56, 0x7A58, 0x7A59, 	/* 0xB768 to 0xB76F */ 
0x7A5A, 0x7A5B, 0x7A5C, 0x7A5D, 0x7A5E, 0x7A5F, 0x7A60, 0x7A61, 	/* 0xB770 to 0xB777 */ 
0x7A62, 0x7A63, 0x7A64, 0x7A65, 0x7A66, 0x7A67, 0x7A68, 0x0000, 	/* 0xB778 to 0xB77F */ 
0x7A69, 0x7A6A, 0x7A6B, 0x7A6C, 0x7A6D, 0x7A6E, 0x7A6F, 0x7A71, 	/* 0xB780 to 0xB787 */ 
0x7A72, 0x7A73, 0x7A75, 0x7A7B, 0x7A7C, 0x7A7D, 0x7A7E, 0x7A82, 	/* 0xB788 to 0xB78F */ 
0x7A85, 0x7A87, 0x7A89, 0x7A8A, 0x7A8B, 0x7A8C, 0x7A8E, 0x7A8F, 	/* 0xB790 to 0xB797 */ 
0x7A90, 0x7A93, 0x7A94, 0x7A99, 0x7A9A, 0x7A9B, 0x7A9E, 0x7AA1, 	/* 0xB798 to 0xB79F */ 
0x7AA2, 0x8D30, 0x53D1, 0x7F5A, 0x7B4F, 0x4F10, 0x4E4F, 0x9600, 	/* 0xB7A0 to 0xB7A7 */ 
0x6CD5, 0x73D0, 0x85E9, 0x5E06, 0x756A, 0x7FFB, 0x6A0A, 0x77FE, 	/* 0xB7A8 to 0xB7AF */ 
0x9492, 0x7E41, 0x51E1, 0x70E6, 0x53CD, 0x8FD4, 0x8303, 0x8D29, 	/* 0xB7B0 to 0xB7B7 */ 
0x72AF, 0x996D, 0x6CDB, 0x574A, 0x82B3, 0x65B9, 0x80AA, 0x623F, 	/* 0xB7B8 to 0xB7BF */ 
0x9632, 0x59A8, 0x4EFF, 0x8BBF, 0x7EBA, 0x653E, 0x83F2, 0x975E, 	/* 0xB7C0 to 0xB7C7 */ 
0x5561, 0x98DE, 0x80A5, 0x532A, 0x8BFD, 0x5420, 0x80BA, 0x5E9F, 	/* 0xB7C8 to 0xB7CF */ 
0x6CB8, 0x8D39, 0x82AC, 0x915A, 0x5429, 0x6C1B, 0x5206, 0x7EB7, 	/* 0xB7D0 to 0xB7D7 */ 
0x575F, 0x711A, 0x6C7E, 0x7C89, 0x594B, 0x4EFD, 0x5FFF, 0x6124, 	/* 0xB7D8 to 0xB7DF */ 
0x7CAA, 0x4E30, 0x5C01, 0x67AB, 0x8702, 0x5CF0, 0x950B, 0x98CE, 	/* 0xB7E0 to 0xB7E7 */ 
0x75AF, 0x70FD, 0x9022, 0x51AF, 0x7F1D, 0x8BBD, 0x5949, 0x51E4, 	/* 0xB7E8 to 0xB7EF */ 
0x4F5B, 0x5426, 0x592B, 0x6577, 0x80A4, 0x5B75, 0x6276, 0x62C2, 	/* 0xB7F0 to 0xB7F7 */ 
0x8F90, 0x5E45, 0x6C1F, 0x7B26, 0x4F0F, 0x4FD8, 0x670D, 0x0000, 	/* 0xB7F8 to 0xB7FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB800 to 0xB807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB808 to 0xB80F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB810 to 0xB817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB818 to 0xB81F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB820 to 0xB827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB828 to 0xB82F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB830 to 0xB837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB838 to 0xB83F */ 
0x7AA3, 0x7AA4, 0x7AA7, 0x7AA9, 0x7AAA, 0x7AAB, 0x7AAE, 0x7AAF, 	/* 0xB840 to 0xB847 */ 
0x7AB0, 0x7AB1, 0x7AB2, 0x7AB4, 0x7AB5, 0x7AB6, 0x7AB7, 0x7AB8, 	/* 0xB848 to 0xB84F */ 
0x7AB9, 0x7ABA, 0x7ABB, 0x7ABC, 0x7ABD, 0x7ABE, 0x7AC0, 0x7AC1, 	/* 0xB850 to 0xB857 */ 
0x7AC2, 0x7AC3, 0x7AC4, 0x7AC5, 0x7AC6, 0x7AC7, 0x7AC8, 0x7AC9, 	/* 0xB858 to 0xB85F */ 
0x7ACA, 0x7ACC, 0x7ACD, 0x7ACE, 0x7ACF, 0x7AD0, 0x7AD1, 0x7AD2, 	/* 0xB860 to 0xB867 */ 
0x7AD3, 0x7AD4, 0x7AD5, 0x7AD7, 0x7AD8, 0x7ADA, 0x7ADB, 0x7ADC, 	/* 0xB868 to 0xB86F */ 
0x7ADD, 0x7AE1, 0x7AE2, 0x7AE4, 0x7AE7, 0x7AE8, 0x7AE9, 0x7AEA, 	/* 0xB870 to 0xB877 */ 
0x7AEB, 0x7AEC, 0x7AEE, 0x7AF0, 0x7AF1, 0x7AF2, 0x7AF3, 0x0000, 	/* 0xB878 to 0xB87F */ 
0x7AF4, 0x7AF5, 0x7AF6, 0x7AF7, 0x7AF8, 0x7AFB, 0x7AFC, 0x7AFE, 	/* 0xB880 to 0xB887 */ 
0x7B00, 0x7B01, 0x7B02, 0x7B05, 0x7B07, 0x7B09, 0x7B0C, 0x7B0D, 	/* 0xB888 to 0xB88F */ 
0x7B0E, 0x7B10, 0x7B12, 0x7B13, 0x7B16, 0x7B17, 0x7B18, 0x7B1A, 	/* 0xB890 to 0xB897 */ 
0x7B1C, 0x7B1D, 0x7B1F, 0x7B21, 0x7B22, 0x7B23, 0x7B27, 0x7B29, 	/* 0xB898 to 0xB89F */ 
0x7B2D, 0x6D6E, 0x6DAA, 0x798F, 0x88B1, 0x5F17, 0x752B, 0x629A, 	/* 0xB8A0 to 0xB8A7 */ 
0x8F85, 0x4FEF, 0x91DC, 0x65A7, 0x812F, 0x8151, 0x5E9C, 0x8150, 	/* 0xB8A8 to 0xB8AF */ 
0x8D74, 0x526F, 0x8986, 0x8D4B, 0x590D, 0x5085, 0x4ED8, 0x961C, 	/* 0xB8B0 to 0xB8B7 */ 
0x7236, 0x8179, 0x8D1F, 0x5BCC, 0x8BA3, 0x9644, 0x5987, 0x7F1A, 	/* 0xB8B8 to 0xB8BF */ 
0x5490, 0x5676, 0x560E, 0x8BE5, 0x6539, 0x6982, 0x9499, 0x76D6, 	/* 0xB8C0 to 0xB8C7 */ 
0x6E89, 0x5E72, 0x7518, 0x6746, 0x67D1, 0x7AFF, 0x809D, 0x8D76, 	/* 0xB8C8 to 0xB8CF */ 
0x611F, 0x79C6, 0x6562, 0x8D63, 0x5188, 0x521A, 0x94A2, 0x7F38, 	/* 0xB8D0 to 0xB8D7 */ 
0x809B, 0x7EB2, 0x5C97, 0x6E2F, 0x6760, 0x7BD9, 0x768B, 0x9AD8, 	/* 0xB8D8 to 0xB8DF */ 
0x818F, 0x7F94, 0x7CD5, 0x641E, 0x9550, 0x7A3F, 0x544A, 0x54E5, 	/* 0xB8E0 to 0xB8E7 */ 
0x6B4C, 0x6401, 0x6208, 0x9E3D, 0x80F3, 0x7599, 0x5272, 0x9769, 	/* 0xB8E8 to 0xB8EF */ 
0x845B, 0x683C, 0x86E4, 0x9601, 0x9694, 0x94EC, 0x4E2A, 0x5404, 	/* 0xB8F0 to 0xB8F7 */ 
0x7ED9, 0x6839, 0x8DDF, 0x8015, 0x66F4, 0x5E9A, 0x7FB9, 0x0000, 	/* 0xB8F8 to 0xB8FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB900 to 0xB907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB908 to 0xB90F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB910 to 0xB917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB918 to 0xB91F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB920 to 0xB927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB928 to 0xB92F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB930 to 0xB937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB938 to 0xB93F */ 
0x7B2F, 0x7B30, 0x7B32, 0x7B34, 0x7B35, 0x7B36, 0x7B37, 0x7B39, 	/* 0xB940 to 0xB947 */ 
0x7B3B, 0x7B3D, 0x7B3F, 0x7B40, 0x7B41, 0x7B42, 0x7B43, 0x7B44, 	/* 0xB948 to 0xB94F */ 
0x7B46, 0x7B48, 0x7B4A, 0x7B4D, 0x7B4E, 0x7B53, 0x7B55, 0x7B57, 	/* 0xB950 to 0xB957 */ 
0x7B59, 0x7B5C, 0x7B5E, 0x7B5F, 0x7B61, 0x7B63, 0x7B64, 0x7B65, 	/* 0xB958 to 0xB95F */ 
0x7B66, 0x7B67, 0x7B68, 0x7B69, 0x7B6A, 0x7B6B, 0x7B6C, 0x7B6D, 	/* 0xB960 to 0xB967 */ 
0x7B6F, 0x7B70, 0x7B73, 0x7B74, 0x7B76, 0x7B78, 0x7B7A, 0x7B7C, 	/* 0xB968 to 0xB96F */ 
0x7B7D, 0x7B7F, 0x7B81, 0x7B82, 0x7B83, 0x7B84, 0x7B86, 0x7B87, 	/* 0xB970 to 0xB977 */ 
0x7B88, 0x7B89, 0x7B8A, 0x7B8B, 0x7B8C, 0x7B8E, 0x7B8F, 0x0000, 	/* 0xB978 to 0xB97F */ 
0x7B91, 0x7B92, 0x7B93, 0x7B96, 0x7B98, 0x7B99, 0x7B9A, 0x7B9B, 	/* 0xB980 to 0xB987 */ 
0x7B9E, 0x7B9F, 0x7BA0, 0x7BA3, 0x7BA4, 0x7BA5, 0x7BAE, 0x7BAF, 	/* 0xB988 to 0xB98F */ 
0x7BB0, 0x7BB2, 0x7BB3, 0x7BB5, 0x7BB6, 0x7BB7, 0x7BB9, 0x7BBA, 	/* 0xB990 to 0xB997 */ 
0x7BBB, 0x7BBC, 0x7BBD, 0x7BBE, 0x7BBF, 0x7BC0, 0x7BC2, 0x7BC3, 	/* 0xB998 to 0xB99F */ 
0x7BC4, 0x57C2, 0x803F, 0x6897, 0x5DE5, 0x653B, 0x529F, 0x606D, 	/* 0xB9A0 to 0xB9A7 */ 
0x9F9A, 0x4F9B, 0x8EAC, 0x516C, 0x5BAB, 0x5F13, 0x5DE9, 0x6C5E, 	/* 0xB9A8 to 0xB9AF */ 
0x62F1, 0x8D21, 0x5171, 0x94A9, 0x52FE, 0x6C9F, 0x82DF, 0x72D7, 	/* 0xB9B0 to 0xB9B7 */ 
0x57A2, 0x6784, 0x8D2D, 0x591F, 0x8F9C, 0x83C7, 0x5495, 0x7B8D, 	/* 0xB9B8 to 0xB9BF */ 
0x4F30, 0x6CBD, 0x5B64, 0x59D1, 0x9F13, 0x53E4, 0x86CA, 0x9AA8, 	/* 0xB9C0 to 0xB9C7 */ 
0x8C37, 0x80A1, 0x6545, 0x987E, 0x56FA, 0x96C7, 0x522E, 0x74DC, 	/* 0xB9C8 to 0xB9CF */ 
0x5250, 0x5BE1, 0x6302, 0x8902, 0x4E56, 0x62D0, 0x602A, 0x68FA, 	/* 0xB9D0 to 0xB9D7 */ 
0x5173, 0x5B98, 0x51A0, 0x89C2, 0x7BA1, 0x9986, 0x7F50, 0x60EF, 	/* 0xB9D8 to 0xB9DF */ 
0x704C, 0x8D2F, 0x5149, 0x5E7F, 0x901B, 0x7470, 0x89C4, 0x572D, 	/* 0xB9E0 to 0xB9E7 */ 
0x7845, 0x5F52, 0x9F9F, 0x95FA, 0x8F68, 0x9B3C, 0x8BE1, 0x7678, 	/* 0xB9E8 to 0xB9EF */ 
0x6842, 0x67DC, 0x8DEA, 0x8D35, 0x523D, 0x8F8A, 0x6EDA, 0x68CD, 	/* 0xB9F0 to 0xB9F7 */ 
0x9505, 0x90ED, 0x56FD, 0x679C, 0x88F9, 0x8FC7, 0x54C8, 0x0000, 	/* 0xB9F8 to 0xB9FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA00 to 0xBA07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA08 to 0xBA0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA10 to 0xBA17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA18 to 0xBA1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA20 to 0xBA27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA28 to 0xBA2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA30 to 0xBA37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA38 to 0xBA3F */ 
0x7BC5, 0x7BC8, 0x7BC9, 0x7BCA, 0x7BCB, 0x7BCD, 0x7BCE, 0x7BCF, 	/* 0xBA40 to 0xBA47 */ 
0x7BD0, 0x7BD2, 0x7BD4, 0x7BD5, 0x7BD6, 0x7BD7, 0x7BD8, 0x7BDB, 	/* 0xBA48 to 0xBA4F */ 
0x7BDC, 0x7BDE, 0x7BDF, 0x7BE0, 0x7BE2, 0x7BE3, 0x7BE4, 0x7BE7, 	/* 0xBA50 to 0xBA57 */ 
0x7BE8, 0x7BE9, 0x7BEB, 0x7BEC, 0x7BED, 0x7BEF, 0x7BF0, 0x7BF2, 	/* 0xBA58 to 0xBA5F */ 
0x7BF3, 0x7BF4, 0x7BF5, 0x7BF6, 0x7BF8, 0x7BF9, 0x7BFA, 0x7BFB, 	/* 0xBA60 to 0xBA67 */ 
0x7BFD, 0x7BFF, 0x7C00, 0x7C01, 0x7C02, 0x7C03, 0x7C04, 0x7C05, 	/* 0xBA68 to 0xBA6F */ 
0x7C06, 0x7C08, 0x7C09, 0x7C0A, 0x7C0D, 0x7C0E, 0x7C10, 0x7C11, 	/* 0xBA70 to 0xBA77 */ 
0x7C12, 0x7C13, 0x7C14, 0x7C15, 0x7C17, 0x7C18, 0x7C19, 0x0000, 	/* 0xBA78 to 0xBA7F */ 
0x7C1A, 0x7C1B, 0x7C1C, 0x7C1D, 0x7C1E, 0x7C20, 0x7C21, 0x7C22, 	/* 0xBA80 to 0xBA87 */ 
0x7C23, 0x7C24, 0x7C25, 0x7C28, 0x7C29, 0x7C2B, 0x7C2C, 0x7C2D, 	/* 0xBA88 to 0xBA8F */ 
0x7C2E, 0x7C2F, 0x7C30, 0x7C31, 0x7C32, 0x7C33, 0x7C34, 0x7C35, 	/* 0xBA90 to 0xBA97 */ 
0x7C36, 0x7C37, 0x7C39, 0x7C3A, 0x7C3B, 0x7C3C, 0x7C3D, 0x7C3E, 	/* 0xBA98 to 0xBA9F */ 
0x7C42, 0x9AB8, 0x5B69, 0x6D77, 0x6C26, 0x4EA5, 0x5BB3, 0x9A87, 	/* 0xBAA0 to 0xBAA7 */ 
0x9163, 0x61A8, 0x90AF, 0x97E9, 0x542B, 0x6DB5, 0x5BD2, 0x51FD, 	/* 0xBAA8 to 0xBAAF */ 
0x558A, 0x7F55, 0x7FF0, 0x64BC, 0x634D, 0x65F1, 0x61BE, 0x608D, 	/* 0xBAB0 to 0xBAB7 */ 
0x710A, 0x6C57, 0x6C49, 0x592F, 0x676D, 0x822A, 0x58D5, 0x568E, 	/* 0xBAB8 to 0xBABF */ 
0x8C6A, 0x6BEB, 0x90DD, 0x597D, 0x8017, 0x53F7, 0x6D69, 0x5475, 	/* 0xBAC0 to 0xBAC7 */ 
0x559D, 0x8377, 0x83CF, 0x6838, 0x79BE, 0x548C, 0x4F55, 0x5408, 	/* 0xBAC8 to 0xBACF */ 
0x76D2, 0x8C89, 0x9602, 0x6CB3, 0x6DB8, 0x8D6B, 0x8910, 0x9E64, 	/* 0xBAD0 to 0xBAD7 */ 
0x8D3A, 0x563F, 0x9ED1, 0x75D5, 0x5F88, 0x72E0, 0x6068, 0x54FC, 	/* 0xBAD8 to 0xBADF */ 
0x4EA8, 0x6A2A, 0x8861, 0x6052, 0x8F70, 0x54C4, 0x70D8, 0x8679, 	/* 0xBAE0 to 0xBAE7 */ 
0x9E3F, 0x6D2A, 0x5B8F, 0x5F18, 0x7EA2, 0x5589, 0x4FAF, 0x7334, 	/* 0xBAE8 to 0xBAEF */ 
0x543C, 0x539A, 0x5019, 0x540E, 0x547C, 0x4E4E, 0x5FFD, 0x745A, 	/* 0xBAF0 to 0xBAF7 */ 
0x58F6, 0x846B, 0x80E1, 0x8774, 0x72D0, 0x7CCA, 0x6E56, 0x0000, 	/* 0xBAF8 to 0xBAFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB00 to 0xBB07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB08 to 0xBB0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB10 to 0xBB17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB18 to 0xBB1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB20 to 0xBB27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB28 to 0xBB2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB30 to 0xBB37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB38 to 0xBB3F */ 
0x7C43, 0x7C44, 0x7C45, 0x7C46, 0x7C47, 0x7C48, 0x7C49, 0x7C4A, 	/* 0xBB40 to 0xBB47 */ 
0x7C4B, 0x7C4C, 0x7C4E, 0x7C4F, 0x7C50, 0x7C51, 0x7C52, 0x7C53, 	/* 0xBB48 to 0xBB4F */ 
0x7C54, 0x7C55, 0x7C56, 0x7C57, 0x7C58, 0x7C59, 0x7C5A, 0x7C5B, 	/* 0xBB50 to 0xBB57 */ 
0x7C5C, 0x7C5D, 0x7C5E, 0x7C5F, 0x7C60, 0x7C61, 0x7C62, 0x7C63, 	/* 0xBB58 to 0xBB5F */ 
0x7C64, 0x7C65, 0x7C66, 0x7C67, 0x7C68, 0x7C69, 0x7C6A, 0x7C6B, 	/* 0xBB60 to 0xBB67 */ 
0x7C6C, 0x7C6D, 0x7C6E, 0x7C6F, 0x7C70, 0x7C71, 0x7C72, 0x7C75, 	/* 0xBB68 to 0xBB6F */ 
0x7C76, 0x7C77, 0x7C78, 0x7C79, 0x7C7A, 0x7C7E, 0x7C7F, 0x7C80, 	/* 0xBB70 to 0xBB77 */ 
0x7C81, 0x7C82, 0x7C83, 0x7C84, 0x7C85, 0x7C86, 0x7C87, 0x0000, 	/* 0xBB78 to 0xBB7F */ 
0x7C88, 0x7C8A, 0x7C8B, 0x7C8C, 0x7C8D, 0x7C8E, 0x7C8F, 0x7C90, 	/* 0xBB80 to 0xBB87 */ 
0x7C93, 0x7C94, 0x7C96, 0x7C99, 0x7C9A, 0x7C9B, 0x7CA0, 0x7CA1, 	/* 0xBB88 to 0xBB8F */ 
0x7CA3, 0x7CA6, 0x7CA7, 0x7CA8, 0x7CA9, 0x7CAB, 0x7CAC, 0x7CAD, 	/* 0xBB90 to 0xBB97 */ 
0x7CAF, 0x7CB0, 0x7CB4, 0x7CB5, 0x7CB6, 0x7CB7, 0x7CB8, 0x7CBA, 	/* 0xBB98 to 0xBB9F */ 
0x7CBB, 0x5F27, 0x864E, 0x552C, 0x62A4, 0x4E92, 0x6CAA, 0x6237, 	/* 0xBBA0 to 0xBBA7 */ 
0x82B1, 0x54D7, 0x534E, 0x733E, 0x6ED1, 0x753B, 0x5212, 0x5316, 	/* 0xBBA8 to 0xBBAF */ 
0x8BDD, 0x69D0, 0x5F8A, 0x6000, 0x6DEE, 0x574F, 0x6B22, 0x73AF, 	/* 0xBBB0 to 0xBBB7 */ 
0x6853, 0x8FD8, 0x7F13, 0x6362, 0x60A3, 0x5524, 0x75EA, 0x8C62, 	/* 0xBBB8 to 0xBBBF */ 
0x7115, 0x6DA3, 0x5BA6, 0x5E7B, 0x8352, 0x614C, 0x9EC4, 0x78FA, 	/* 0xBBC0 to 0xBBC7 */ 
0x8757, 0x7C27, 0x7687, 0x51F0, 0x60F6, 0x714C, 0x6643, 0x5E4C, 	/* 0xBBC8 to 0xBBCF */ 
0x604D, 0x8C0E, 0x7070, 0x6325, 0x8F89, 0x5FBD, 0x6062, 0x86D4, 	/* 0xBBD0 to 0xBBD7 */ 
0x56DE, 0x6BC1, 0x6094, 0x6167, 0x5349, 0x60E0, 0x6666, 0x8D3F, 	/* 0xBBD8 to 0xBBDF */ 
0x79FD, 0x4F1A, 0x70E9, 0x6C47, 0x8BB3, 0x8BF2, 0x7ED8, 0x8364, 	/* 0xBBE0 to 0xBBE7 */ 
0x660F, 0x5A5A, 0x9B42, 0x6D51, 0x6DF7, 0x8C41, 0x6D3B, 0x4F19, 	/* 0xBBE8 to 0xBBEF */ 
0x706B, 0x83B7, 0x6216, 0x60D1, 0x970D, 0x8D27, 0x7978, 0x51FB, 	/* 0xBBF0 to 0xBBF7 */ 
0x573E, 0x57FA, 0x673A, 0x7578, 0x7A3D, 0x79EF, 0x7B95, 0x0000, 	/* 0xBBF8 to 0xBBFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC00 to 0xBC07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC08 to 0xBC0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC10 to 0xBC17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC18 to 0xBC1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC20 to 0xBC27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC28 to 0xBC2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC30 to 0xBC37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC38 to 0xBC3F */ 
0x7CBF, 0x7CC0, 0x7CC2, 0x7CC3, 0x7CC4, 0x7CC6, 0x7CC9, 0x7CCB, 	/* 0xBC40 to 0xBC47 */ 
0x7CCE, 0x7CCF, 0x7CD0, 0x7CD1, 0x7CD2, 0x7CD3, 0x7CD4, 0x7CD8, 	/* 0xBC48 to 0xBC4F */ 
0x7CDA, 0x7CDB, 0x7CDD, 0x7CDE, 0x7CE1, 0x7CE2, 0x7CE3, 0x7CE4, 	/* 0xBC50 to 0xBC57 */ 
0x7CE5, 0x7CE6, 0x7CE7, 0x7CE9, 0x7CEA, 0x7CEB, 0x7CEC, 0x7CED, 	/* 0xBC58 to 0xBC5F */ 
0x7CEE, 0x7CF0, 0x7CF1, 0x7CF2, 0x7CF3, 0x7CF4, 0x7CF5, 0x7CF6, 	/* 0xBC60 to 0xBC67 */ 
0x7CF7, 0x7CF9, 0x7CFA, 0x7CFC, 0x7CFD, 0x7CFE, 0x7CFF, 0x7D00, 	/* 0xBC68 to 0xBC6F */ 
0x7D01, 0x7D02, 0x7D03, 0x7D04, 0x7D05, 0x7D06, 0x7D07, 0x7D08, 	/* 0xBC70 to 0xBC77 */ 
0x7D09, 0x7D0B, 0x7D0C, 0x7D0D, 0x7D0E, 0x7D0F, 0x7D10, 0x0000, 	/* 0xBC78 to 0xBC7F */ 
0x7D11, 0x7D12, 0x7D13, 0x7D14, 0x7D15, 0x7D16, 0x7D17, 0x7D18, 	/* 0xBC80 to 0xBC87 */ 
0x7D19, 0x7D1A, 0x7D1B, 0x7D1C, 0x7D1D, 0x7D1E, 0x7D1F, 0x7D21, 	/* 0xBC88 to 0xBC8F */ 
0x7D23, 0x7D24, 0x7D25, 0x7D26, 0x7D28, 0x7D29, 0x7D2A, 0x7D2C, 	/* 0xBC90 to 0xBC97 */ 
0x7D2D, 0x7D2E, 0x7D30, 0x7D31, 0x7D32, 0x7D33, 0x7D34, 0x7D35, 	/* 0xBC98 to 0xBC9F */ 
0x7D36, 0x808C, 0x9965, 0x8FF9, 0x6FC0, 0x8BA5, 0x9E21, 0x59EC, 	/* 0xBCA0 to 0xBCA7 */ 
0x7EE9, 0x7F09, 0x5409, 0x6781, 0x68D8, 0x8F91, 0x7C4D, 0x96C6, 	/* 0xBCA8 to 0xBCAF */ 
0x53CA, 0x6025, 0x75BE, 0x6C72, 0x5373, 0x5AC9, 0x7EA7, 0x6324, 	/* 0xBCB0 to 0xBCB7 */ 
0x51E0, 0x810A, 0x5DF1, 0x84DF, 0x6280, 0x5180, 0x5B63, 0x4F0E, 	/* 0xBCB8 to 0xBCBF */ 
0x796D, 0x5242, 0x60B8, 0x6D4E, 0x5BC4, 0x5BC2, 0x8BA1, 0x8BB0, 	/* 0xBCC0 to 0xBCC7 */ 
0x65E2, 0x5FCC, 0x9645, 0x5993, 0x7EE7, 0x7EAA, 0x5609, 0x67B7, 	/* 0xBCC8 to 0xBCCF */ 
0x5939, 0x4F73, 0x5BB6, 0x52A0, 0x835A, 0x988A, 0x8D3E, 0x7532, 	/* 0xBCD0 to 0xBCD7 */ 
0x94BE, 0x5047, 0x7A3C, 0x4EF7, 0x67B6, 0x9A7E, 0x5AC1, 0x6B7C, 	/* 0xBCD8 to 0xBCDF */ 
0x76D1, 0x575A, 0x5C16, 0x7B3A, 0x95F4, 0x714E, 0x517C, 0x80A9, 	/* 0xBCE0 to 0xBCE7 */ 
0x8270, 0x5978, 0x7F04, 0x8327, 0x68C0, 0x67EC, 0x78B1, 0x7877, 	/* 0xBCE8 to 0xBCEF */ 
0x62E3, 0x6361, 0x7B80, 0x4FED, 0x526A, 0x51CF, 0x8350, 0x69DB, 	/* 0xBCF0 to 0xBCF7 */ 
0x9274, 0x8DF5, 0x8D31, 0x89C1, 0x952E, 0x7BAD, 0x4EF6, 0x0000, 	/* 0xBCF8 to 0xBCFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD00 to 0xBD07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD08 to 0xBD0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD10 to 0xBD17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD18 to 0xBD1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD20 to 0xBD27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD28 to 0xBD2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD30 to 0xBD37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD38 to 0xBD3F */ 
0x7D37, 0x7D38, 0x7D39, 0x7D3A, 0x7D3B, 0x7D3C, 0x7D3D, 0x7D3E, 	/* 0xBD40 to 0xBD47 */ 
0x7D3F, 0x7D40, 0x7D41, 0x7D42, 0x7D43, 0x7D44, 0x7D45, 0x7D46, 	/* 0xBD48 to 0xBD4F */ 
0x7D47, 0x7D48, 0x7D49, 0x7D4A, 0x7D4B, 0x7D4C, 0x7D4D, 0x7D4E, 	/* 0xBD50 to 0xBD57 */ 
0x7D4F, 0x7D50, 0x7D51, 0x7D52, 0x7D53, 0x7D54, 0x7D55, 0x7D56, 	/* 0xBD58 to 0xBD5F */ 
0x7D57, 0x7D58, 0x7D59, 0x7D5A, 0x7D5B, 0x7D5C, 0x7D5D, 0x7D5E, 	/* 0xBD60 to 0xBD67 */ 
0x7D5F, 0x7D60, 0x7D61, 0x7D62, 0x7D63, 0x7D64, 0x7D65, 0x7D66, 	/* 0xBD68 to 0xBD6F */ 
0x7D67, 0x7D68, 0x7D69, 0x7D6A, 0x7D6B, 0x7D6C, 0x7D6D, 0x7D6F, 	/* 0xBD70 to 0xBD77 */ 
0x7D70, 0x7D71, 0x7D72, 0x7D73, 0x7D74, 0x7D75, 0x7D76, 0x0000, 	/* 0xBD78 to 0xBD7F */ 
0x7D78, 0x7D79, 0x7D7A, 0x7D7B, 0x7D7C, 0x7D7D, 0x7D7E, 0x7D7F, 	/* 0xBD80 to 0xBD87 */ 
0x7D80, 0x7D81, 0x7D82, 0x7D83, 0x7D84, 0x7D85, 0x7D86, 0x7D87, 	/* 0xBD88 to 0xBD8F */ 
0x7D88, 0x7D89, 0x7D8A, 0x7D8B, 0x7D8C, 0x7D8D, 0x7D8E, 0x7D8F, 	/* 0xBD90 to 0xBD97 */ 
0x7D90, 0x7D91, 0x7D92, 0x7D93, 0x7D94, 0x7D95, 0x7D96, 0x7D97, 	/* 0xBD98 to 0xBD9F */ 
0x7D98, 0x5065, 0x8230, 0x5251, 0x996F, 0x6E10, 0x6E85, 0x6DA7, 	/* 0xBDA0 to 0xBDA7 */ 
0x5EFA, 0x50F5, 0x59DC, 0x5C06, 0x6D46, 0x6C5F, 0x7586, 0x848B, 	/* 0xBDA8 to 0xBDAF */ 
0x6868, 0x5956, 0x8BB2, 0x5320, 0x9171, 0x964D, 0x8549, 0x6912, 	/* 0xBDB0 to 0xBDB7 */ 
0x7901, 0x7126, 0x80F6, 0x4EA4, 0x90CA, 0x6D47, 0x9A84, 0x5A07, 	/* 0xBDB8 to 0xBDBF */ 
0x56BC, 0x6405, 0x94F0, 0x77EB, 0x4FA5, 0x811A, 0x72E1, 0x89D2, 	/* 0xBDC0 to 0xBDC7 */ 
0x997A, 0x7F34, 0x7EDE, 0x527F, 0x6559, 0x9175, 0x8F7F, 0x8F83, 	/* 0xBDC8 to 0xBDCF */ 
0x53EB, 0x7A96, 0x63ED, 0x63A5, 0x7686, 0x79F8, 0x8857, 0x9636, 	/* 0xBDD0 to 0xBDD7 */ 
0x622A, 0x52AB, 0x8282, 0x6854, 0x6770, 0x6377, 0x776B, 0x7AED, 	/* 0xBDD8 to 0xBDDF */ 
0x6D01, 0x7ED3, 0x89E3, 0x59D0, 0x6212, 0x85C9, 0x82A5, 0x754C, 	/* 0xBDE0 to 0xBDE7 */ 
0x501F, 0x4ECB, 0x75A5, 0x8BEB, 0x5C4A, 0x5DFE, 0x7B4B, 0x65A4, 	/* 0xBDE8 to 0xBDEF */ 
0x91D1, 0x4ECA, 0x6D25, 0x895F, 0x7D27, 0x9526, 0x4EC5, 0x8C28, 	/* 0xBDF0 to 0xBDF7 */ 
0x8FDB, 0x9773, 0x664B, 0x7981, 0x8FD1, 0x70EC, 0x6D78, 0x0000, 	/* 0xBDF8 to 0xBDFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE00 to 0xBE07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE08 to 0xBE0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE10 to 0xBE17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE18 to 0xBE1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE20 to 0xBE27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE28 to 0xBE2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE30 to 0xBE37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE38 to 0xBE3F */ 
0x7D99, 0x7D9A, 0x7D9B, 0x7D9C, 0x7D9D, 0x7D9E, 0x7D9F, 0x7DA0, 	/* 0xBE40 to 0xBE47 */ 
0x7DA1, 0x7DA2, 0x7DA3, 0x7DA4, 0x7DA5, 0x7DA7, 0x7DA8, 0x7DA9, 	/* 0xBE48 to 0xBE4F */ 
0x7DAA, 0x7DAB, 0x7DAC, 0x7DAD, 0x7DAF, 0x7DB0, 0x7DB1, 0x7DB2, 	/* 0xBE50 to 0xBE57 */ 
0x7DB3, 0x7DB4, 0x7DB5, 0x7DB6, 0x7DB7, 0x7DB8, 0x7DB9, 0x7DBA, 	/* 0xBE58 to 0xBE5F */ 
0x7DBB, 0x7DBC, 0x7DBD, 0x7DBE, 0x7DBF, 0x7DC0, 0x7DC1, 0x7DC2, 	/* 0xBE60 to 0xBE67 */ 
0x7DC3, 0x7DC4, 0x7DC5, 0x7DC6, 0x7DC7, 0x7DC8, 0x7DC9, 0x7DCA, 	/* 0xBE68 to 0xBE6F */ 
0x7DCB, 0x7DCC, 0x7DCD, 0x7DCE, 0x7DCF, 0x7DD0, 0x7DD1, 0x7DD2, 	/* 0xBE70 to 0xBE77 */ 
0x7DD3, 0x7DD4, 0x7DD5, 0x7DD6, 0x7DD7, 0x7DD8, 0x7DD9, 0x0000, 	/* 0xBE78 to 0xBE7F */ 
0x7DDA, 0x7DDB, 0x7DDC, 0x7DDD, 0x7DDE, 0x7DDF, 0x7DE0, 0x7DE1, 	/* 0xBE80 to 0xBE87 */ 
0x7DE2, 0x7DE3, 0x7DE4, 0x7DE5, 0x7DE6, 0x7DE7, 0x7DE8, 0x7DE9, 	/* 0xBE88 to 0xBE8F */ 
0x7DEA, 0x7DEB, 0x7DEC, 0x7DED, 0x7DEE, 0x7DEF, 0x7DF0, 0x7DF1, 	/* 0xBE90 to 0xBE97 */ 
0x7DF2, 0x7DF3, 0x7DF4, 0x7DF5, 0x7DF6, 0x7DF7, 0x7DF8, 0x7DF9, 	/* 0xBE98 to 0xBE9F */ 
0x7DFA, 0x5C3D, 0x52B2, 0x8346, 0x5162, 0x830E, 0x775B, 0x6676, 	/* 0xBEA0 to 0xBEA7 */ 
0x9CB8, 0x4EAC, 0x60CA, 0x7CBE, 0x7CB3, 0x7ECF, 0x4E95, 0x8B66, 	/* 0xBEA8 to 0xBEAF */ 
0x666F, 0x9888, 0x9759, 0x5883, 0x656C, 0x955C, 0x5F84, 0x75C9, 	/* 0xBEB0 to 0xBEB7 */ 
0x9756, 0x7ADF, 0x7ADE, 0x51C0, 0x70AF, 0x7A98, 0x63EA, 0x7A76, 	/* 0xBEB8 to 0xBEBF */ 
0x7EA0, 0x7396, 0x97ED, 0x4E45, 0x7078, 0x4E5D, 0x9152, 0x53A9, 	/* 0xBEC0 to 0xBEC7 */ 
0x6551, 0x65E7, 0x81FC, 0x8205, 0x548E, 0x5C31, 0x759A, 0x97A0, 	/* 0xBEC8 to 0xBECF */ 
0x62D8, 0x72D9, 0x75BD, 0x5C45, 0x9A79, 0x83CA, 0x5C40, 0x5480, 	/* 0xBED0 to 0xBED7 */ 
0x77E9, 0x4E3E, 0x6CAE, 0x805A, 0x62D2, 0x636E, 0x5DE8, 0x5177, 	/* 0xBED8 to 0xBEDF */ 
0x8DDD, 0x8E1E, 0x952F, 0x4FF1, 0x53E5, 0x60E7, 0x70AC, 0x5267, 	/* 0xBEE0 to 0xBEE7 */ 
0x6350, 0x9E43, 0x5A1F, 0x5026, 0x7737, 0x5377, 0x7EE2, 0x6485, 	/* 0xBEE8 to 0xBEEF */ 
0x652B, 0x6289, 0x6398, 0x5014, 0x7235, 0x89C9, 0x51B3, 0x8BC0, 	/* 0xBEF0 to 0xBEF7 */ 
0x7EDD, 0x5747, 0x83CC, 0x94A7, 0x519B, 0x541B, 0x5CFB, 0x0000, 	/* 0xBEF8 to 0xBEFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF00 to 0xBF07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF08 to 0xBF0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF10 to 0xBF17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF18 to 0xBF1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF20 to 0xBF27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF28 to 0xBF2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF30 to 0xBF37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF38 to 0xBF3F */ 
0x7DFB, 0x7DFC, 0x7DFD, 0x7DFE, 0x7DFF, 0x7E00, 0x7E01, 0x7E02, 	/* 0xBF40 to 0xBF47 */ 
0x7E03, 0x7E04, 0x7E05, 0x7E06, 0x7E07, 0x7E08, 0x7E09, 0x7E0A, 	/* 0xBF48 to 0xBF4F */ 
0x7E0B, 0x7E0C, 0x7E0D, 0x7E0E, 0x7E0F, 0x7E10, 0x7E11, 0x7E12, 	/* 0xBF50 to 0xBF57 */ 
0x7E13, 0x7E14, 0x7E15, 0x7E16, 0x7E17, 0x7E18, 0x7E19, 0x7E1A, 	/* 0xBF58 to 0xBF5F */ 
0x7E1B, 0x7E1C, 0x7E1D, 0x7E1E, 0x7E1F, 0x7E20, 0x7E21, 0x7E22, 	/* 0xBF60 to 0xBF67 */ 
0x7E23, 0x7E24, 0x7E25, 0x7E26, 0x7E27, 0x7E28, 0x7E29, 0x7E2A, 	/* 0xBF68 to 0xBF6F */ 
0x7E2B, 0x7E2C, 0x7E2D, 0x7E2E, 0x7E2F, 0x7E30, 0x7E31, 0x7E32, 	/* 0xBF70 to 0xBF77 */ 
0x7E33, 0x7E34, 0x7E35, 0x7E36, 0x7E37, 0x7E38, 0x7E39, 0x0000, 	/* 0xBF78 to 0xBF7F */ 
0x7E3A, 0x7E3C, 0x7E3D, 0x7E3E, 0x7E3F, 0x7E40, 0x7E42, 0x7E43, 	/* 0xBF80 to 0xBF87 */ 
0x7E44, 0x7E45, 0x7E46, 0x7E48, 0x7E49, 0x7E4A, 0x7E4B, 0x7E4C, 	/* 0xBF88 to 0xBF8F */ 
0x7E4D, 0x7E4E, 0x7E4F, 0x7E50, 0x7E51, 0x7E52, 0x7E53, 0x7E54, 	/* 0xBF90 to 0xBF97 */ 
0x7E55, 0x7E56, 0x7E57, 0x7E58, 0x7E59, 0x7E5A, 0x7E5B, 0x7E5C, 	/* 0xBF98 to 0xBF9F */ 
0x7E5D, 0x4FCA, 0x7AE3, 0x6D5A, 0x90E1, 0x9A8F, 0x5580, 0x5496, 	/* 0xBFA0 to 0xBFA7 */ 
0x5361, 0x54AF, 0x5F00, 0x63E9, 0x6977, 0x51EF, 0x6168, 0x520A, 	/* 0xBFA8 to 0xBFAF */ 
0x582A, 0x52D8, 0x574E, 0x780D, 0x770B, 0x5EB7, 0x6177, 0x7CE0, 	/* 0xBFB0 to 0xBFB7 */ 
0x625B, 0x6297, 0x4EA2, 0x7095, 0x8003, 0x62F7, 0x70E4, 0x9760, 	/* 0xBFB8 to 0xBFBF */ 
0x5777, 0x82DB, 0x67EF, 0x68F5, 0x78D5, 0x9897, 0x79D1, 0x58F3, 	/* 0xBFC0 to 0xBFC7 */ 
0x54B3, 0x53EF, 0x6E34, 0x514B, 0x523B, 0x5BA2, 0x8BFE, 0x80AF, 	/* 0xBFC8 to 0xBFCF */ 
0x5543, 0x57A6, 0x6073, 0x5751, 0x542D, 0x7A7A, 0x6050, 0x5B54, 	/* 0xBFD0 to 0xBFD7 */ 
0x63A7, 0x62A0, 0x53E3, 0x6263, 0x5BC7, 0x67AF, 0x54ED, 0x7A9F, 	/* 0xBFD8 to 0xBFDF */ 
0x82E6, 0x9177, 0x5E93, 0x88E4, 0x5938, 0x57AE, 0x630E, 0x8DE8, 	/* 0xBFE0 to 0xBFE7 */ 
0x80EF, 0x5757, 0x7B77, 0x4FA9, 0x5FEB, 0x5BBD, 0x6B3E, 0x5321, 	/* 0xBFE8 to 0xBFEF */ 
0x7B50, 0x72C2, 0x6846, 0x77FF, 0x7736, 0x65F7, 0x51B5, 0x4E8F, 	/* 0xBFF0 to 0xBFF7 */ 
0x76D4, 0x5CBF, 0x7AA5, 0x8475, 0x594E, 0x9B41, 0x5080, 0x0000, 	/* 0xBFF8 to 0xBFFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC000 to 0xC007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC008 to 0xC00F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC010 to 0xC017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC018 to 0xC01F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC020 to 0xC027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC028 to 0xC02F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC030 to 0xC037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC038 to 0xC03F */ 
0x7E5E, 0x7E5F, 0x7E60, 0x7E61, 0x7E62, 0x7E63, 0x7E64, 0x7E65, 	/* 0xC040 to 0xC047 */ 
0x7E66, 0x7E67, 0x7E68, 0x7E69, 0x7E6A, 0x7E6B, 0x7E6C, 0x7E6D, 	/* 0xC048 to 0xC04F */ 
0x7E6E, 0x7E6F, 0x7E70, 0x7E71, 0x7E72, 0x7E73, 0x7E74, 0x7E75, 	/* 0xC050 to 0xC057 */ 
0x7E76, 0x7E77, 0x7E78, 0x7E79, 0x7E7A, 0x7E7B, 0x7E7C, 0x7E7D, 	/* 0xC058 to 0xC05F */ 
0x7E7E, 0x7E7F, 0x7E80, 0x7E81, 0x7E83, 0x7E84, 0x7E85, 0x7E86, 	/* 0xC060 to 0xC067 */ 
0x7E87, 0x7E88, 0x7E89, 0x7E8A, 0x7E8B, 0x7E8C, 0x7E8D, 0x7E8E, 	/* 0xC068 to 0xC06F */ 
0x7E8F, 0x7E90, 0x7E91, 0x7E92, 0x7E93, 0x7E94, 0x7E95, 0x7E96, 	/* 0xC070 to 0xC077 */ 
0x7E97, 0x7E98, 0x7E99, 0x7E9A, 0x7E9C, 0x7E9D, 0x7E9E, 0x0000, 	/* 0xC078 to 0xC07F */ 
0x7EAE, 0x7EB4, 0x7EBB, 0x7EBC, 0x7ED6, 0x7EE4, 0x7EEC, 0x7EF9, 	/* 0xC080 to 0xC087 */ 
0x7F0A, 0x7F10, 0x7F1E, 0x7F37, 0x7F39, 0x7F3B, 0x7F3C, 0x7F3D, 	/* 0xC088 to 0xC08F */ 
0x7F3E, 0x7F3F, 0x7F40, 0x7F41, 0x7F43, 0x7F46, 0x7F47, 0x7F48, 	/* 0xC090 to 0xC097 */ 
0x7F49, 0x7F4A, 0x7F4B, 0x7F4C, 0x7F4D, 0x7F4E, 0x7F4F, 0x7F52, 	/* 0xC098 to 0xC09F */ 
0x7F53, 0x9988, 0x6127, 0x6E83, 0x5764, 0x6606, 0x6346, 0x56F0, 	/* 0xC0A0 to 0xC0A7 */ 
0x62EC, 0x6269, 0x5ED3, 0x9614, 0x5783, 0x62C9, 0x5587, 0x8721, 	/* 0xC0A8 to 0xC0AF */ 
0x814A, 0x8FA3, 0x5566, 0x83B1, 0x6765, 0x8D56, 0x84DD, 0x5A6A, 	/* 0xC0B0 to 0xC0B7 */ 
0x680F, 0x62E6, 0x7BEE, 0x9611, 0x5170, 0x6F9C, 0x8C30, 0x63FD, 	/* 0xC0B8 to 0xC0BF */ 
0x89C8, 0x61D2, 0x7F06, 0x70C2, 0x6EE5, 0x7405, 0x6994, 0x72FC, 	/* 0xC0C0 to 0xC0C7 */ 
0x5ECA, 0x90CE, 0x6717, 0x6D6A, 0x635E, 0x52B3, 0x7262, 0x8001, 	/* 0xC0C8 to 0xC0CF */ 
0x4F6C, 0x59E5, 0x916A, 0x70D9, 0x6D9D, 0x52D2, 0x4E50, 0x96F7, 	/* 0xC0D0 to 0xC0D7 */ 
0x956D, 0x857E, 0x78CA, 0x7D2F, 0x5121, 0x5792, 0x64C2, 0x808B, 	/* 0xC0D8 to 0xC0DF */ 
0x7C7B, 0x6CEA, 0x68F1, 0x695E, 0x51B7, 0x5398, 0x68A8, 0x7281, 	/* 0xC0E0 to 0xC0E7 */ 
0x9ECE, 0x7BF1, 0x72F8, 0x79BB, 0x6F13, 0x7406, 0x674E, 0x91CC, 	/* 0xC0E8 to 0xC0EF */ 
0x9CA4, 0x793C, 0x8389, 0x8354, 0x540F, 0x6817, 0x4E3D, 0x5389, 	/* 0xC0F0 to 0xC0F7 */ 
0x52B1, 0x783E, 0x5386, 0x5229, 0x5088, 0x4F8B, 0x4FD0, 0x0000, 	/* 0xC0F8 to 0xC0FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC100 to 0xC107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC108 to 0xC10F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC110 to 0xC117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC118 to 0xC11F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC120 to 0xC127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC128 to 0xC12F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC130 to 0xC137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC138 to 0xC13F */ 
0x7F56, 0x7F59, 0x7F5B, 0x7F5C, 0x7F5D, 0x7F5E, 0x7F60, 0x7F63, 	/* 0xC140 to 0xC147 */ 
0x7F64, 0x7F65, 0x7F66, 0x7F67, 0x7F6B, 0x7F6C, 0x7F6D, 0x7F6F, 	/* 0xC148 to 0xC14F */ 
0x7F70, 0x7F73, 0x7F75, 0x7F76, 0x7F77, 0x7F78, 0x7F7A, 0x7F7B, 	/* 0xC150 to 0xC157 */ 
0x7F7C, 0x7F7D, 0x7F7F, 0x7F80, 0x7F82, 0x7F83, 0x7F84, 0x7F85, 	/* 0xC158 to 0xC15F */ 
0x7F86, 0x7F87, 0x7F88, 0x7F89, 0x7F8B, 0x7F8D, 0x7F8F, 0x7F90, 	/* 0xC160 to 0xC167 */ 
0x7F91, 0x7F92, 0x7F93, 0x7F95, 0x7F96, 0x7F97, 0x7F98, 0x7F99, 	/* 0xC168 to 0xC16F */ 
0x7F9B, 0x7F9C, 0x7FA0, 0x7FA2, 0x7FA3, 0x7FA5, 0x7FA6, 0x7FA8, 	/* 0xC170 to 0xC177 */ 
0x7FA9, 0x7FAA, 0x7FAB, 0x7FAC, 0x7FAD, 0x7FAE, 0x7FB1, 0x0000, 	/* 0xC178 to 0xC17F */ 
0x7FB3, 0x7FB4, 0x7FB5, 0x7FB6, 0x7FB7, 0x7FBA, 0x7FBB, 0x7FBE, 	/* 0xC180 to 0xC187 */ 
0x7FC0, 0x7FC2, 0x7FC3, 0x7FC4, 0x7FC6, 0x7FC7, 0x7FC8, 0x7FC9, 	/* 0xC188 to 0xC18F */ 
0x7FCB, 0x7FCD, 0x7FCF, 0x7FD0, 0x7FD1, 0x7FD2, 0x7FD3, 0x7FD6, 	/* 0xC190 to 0xC197 */ 
0x7FD7, 0x7FD9, 0x7FDA, 0x7FDB, 0x7FDC, 0x7FDD, 0x7FDE, 0x7FE2, 	/* 0xC198 to 0xC19F */ 
0x7FE3, 0x75E2, 0x7ACB, 0x7C92, 0x6CA5, 0x96B6, 0x529B, 0x7483, 	/* 0xC1A0 to 0xC1A7 */ 
0x54E9, 0x4FE9, 0x8054, 0x83B2, 0x8FDE, 0x9570, 0x5EC9, 0x601C, 	/* 0xC1A8 to 0xC1AF */ 
0x6D9F, 0x5E18, 0x655B, 0x8138, 0x94FE, 0x604B, 0x70BC, 0x7EC3, 	/* 0xC1B0 to 0xC1B7 */ 
0x7CAE, 0x51C9, 0x6881, 0x7CB1, 0x826F, 0x4E24, 0x8F86, 0x91CF, 	/* 0xC1B8 to 0xC1BF */ 
0x667E, 0x4EAE, 0x8C05, 0x64A9, 0x804A, 0x50DA, 0x7597, 0x71CE, 	/* 0xC1C0 to 0xC1C7 */ 
0x5BE5, 0x8FBD, 0x6F66, 0x4E86, 0x6482, 0x9563, 0x5ED6, 0x6599, 	/* 0xC1C8 to 0xC1CF */ 
0x5217, 0x88C2, 0x70C8, 0x52A3, 0x730E, 0x7433, 0x6797, 0x78F7, 	/* 0xC1D0 to 0xC1D7 */ 
0x9716, 0x4E34, 0x90BB, 0x9CDE, 0x6DCB, 0x51DB, 0x8D41, 0x541D, 	/* 0xC1D8 to 0xC1DF */ 
0x62CE, 0x73B2, 0x83F1, 0x96F6, 0x9F84, 0x94C3, 0x4F36, 0x7F9A, 	/* 0xC1E0 to 0xC1E7 */ 
0x51CC, 0x7075, 0x9675, 0x5CAD, 0x9886, 0x53E6, 0x4EE4, 0x6E9C, 	/* 0xC1E8 to 0xC1EF */ 
0x7409, 0x69B4, 0x786B, 0x998F, 0x7559, 0x5218, 0x7624, 0x6D41, 	/* 0xC1F0 to 0xC1F7 */ 
0x67F3, 0x516D, 0x9F99, 0x804B, 0x5499, 0x7B3C, 0x7ABF, 0x0000, 	/* 0xC1F8 to 0xC1FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC200 to 0xC207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC208 to 0xC20F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC210 to 0xC217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC218 to 0xC21F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC220 to 0xC227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC228 to 0xC22F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC230 to 0xC237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC238 to 0xC23F */ 
0x7FE4, 0x7FE7, 0x7FE8, 0x7FEA, 0x7FEB, 0x7FEC, 0x7FED, 0x7FEF, 	/* 0xC240 to 0xC247 */ 
0x7FF2, 0x7FF4, 0x7FF5, 0x7FF6, 0x7FF7, 0x7FF8, 0x7FF9, 0x7FFA, 	/* 0xC248 to 0xC24F */ 
0x7FFD, 0x7FFE, 0x7FFF, 0x8002, 0x8007, 0x8008, 0x8009, 0x800A, 	/* 0xC250 to 0xC257 */ 
0x800E, 0x800F, 0x8011, 0x8013, 0x801A, 0x801B, 0x801D, 0x801E, 	/* 0xC258 to 0xC25F */ 
0x801F, 0x8021, 0x8023, 0x8024, 0x802B, 0x802C, 0x802D, 0x802E, 	/* 0xC260 to 0xC267 */ 
0x802F, 0x8030, 0x8032, 0x8034, 0x8039, 0x803A, 0x803C, 0x803E, 	/* 0xC268 to 0xC26F */ 
0x8040, 0x8041, 0x8044, 0x8045, 0x8047, 0x8048, 0x8049, 0x804E, 	/* 0xC270 to 0xC277 */ 
0x804F, 0x8050, 0x8051, 0x8053, 0x8055, 0x8056, 0x8057, 0x0000, 	/* 0xC278 to 0xC27F */ 
0x8059, 0x805B, 0x805C, 0x805D, 0x805E, 0x805F, 0x8060, 0x8061, 	/* 0xC280 to 0xC287 */ 
0x8062, 0x8063, 0x8064, 0x8065, 0x8066, 0x8067, 0x8068, 0x806B, 	/* 0xC288 to 0xC28F */ 
0x806C, 0x806D, 0x806E, 0x806F, 0x8070, 0x8072, 0x8073, 0x8074, 	/* 0xC290 to 0xC297 */ 
0x8075, 0x8076, 0x8077, 0x8078, 0x8079, 0x807A, 0x807B, 0x807C, 	/* 0xC298 to 0xC29F */ 
0x807D, 0x9686, 0x5784, 0x62E2, 0x9647, 0x697C, 0x5A04, 0x6402, 	/* 0xC2A0 to 0xC2A7 */ 
0x7BD3, 0x6F0F, 0x964B, 0x82A6, 0x5362, 0x9885, 0x5E90, 0x7089, 	/* 0xC2A8 to 0xC2AF */ 
0x63B3, 0x5364, 0x864F, 0x9C81, 0x9E93, 0x788C, 0x9732, 0x8DEF, 	/* 0xC2B0 to 0xC2B7 */ 
0x8D42, 0x9E7F, 0x6F5E, 0x7984, 0x5F55, 0x9646, 0x622E, 0x9A74, 	/* 0xC2B8 to 0xC2BF */ 
0x5415, 0x94DD, 0x4FA3, 0x65C5, 0x5C65, 0x5C61, 0x7F15, 0x8651, 	/* 0xC2C0 to 0xC2C7 */ 
0x6C2F, 0x5F8B, 0x7387, 0x6EE4, 0x7EFF, 0x5CE6, 0x631B, 0x5B6A, 	/* 0xC2C8 to 0xC2CF */ 
0x6EE6, 0x5375, 0x4E71, 0x63A0, 0x7565, 0x62A1, 0x8F6E, 0x4F26, 	/* 0xC2D0 to 0xC2D7 */ 
0x4ED1, 0x6CA6, 0x7EB6, 0x8BBA, 0x841D, 0x87BA, 0x7F57, 0x903B, 	/* 0xC2D8 to 0xC2DF */ 
0x9523, 0x7BA9, 0x9AA1, 0x88F8, 0x843D, 0x6D1B, 0x9A86, 0x7EDC, 	/* 0xC2E0 to 0xC2E7 */ 
0x5988, 0x9EBB, 0x739B, 0x7801, 0x8682, 0x9A6C, 0x9A82, 0x561B, 	/* 0xC2E8 to 0xC2EF */ 
0x5417, 0x57CB, 0x4E70, 0x9EA6, 0x5356, 0x8FC8, 0x8109, 0x7792, 	/* 0xC2F0 to 0xC2F7 */ 
0x9992, 0x86EE, 0x6EE1, 0x8513, 0x66FC, 0x6162, 0x6F2B, 0x0000, 	/* 0xC2F8 to 0xC2FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC300 to 0xC307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC308 to 0xC30F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC310 to 0xC317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC318 to 0xC31F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC320 to 0xC327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC328 to 0xC32F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC330 to 0xC337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC338 to 0xC33F */ 
0x807E, 0x8081, 0x8082, 0x8085, 0x8088, 0x808A, 0x808D, 0x808E, 	/* 0xC340 to 0xC347 */ 
0x808F, 0x8090, 0x8091, 0x8092, 0x8094, 0x8095, 0x8097, 0x8099, 	/* 0xC348 to 0xC34F */ 
0x809E, 0x80A3, 0x80A6, 0x80A7, 0x80A8, 0x80AC, 0x80B0, 0x80B3, 	/* 0xC350 to 0xC357 */ 
0x80B5, 0x80B6, 0x80B8, 0x80B9, 0x80BB, 0x80C5, 0x80C7, 0x80C8, 	/* 0xC358 to 0xC35F */ 
0x80C9, 0x80CA, 0x80CB, 0x80CF, 0x80D0, 0x80D1, 0x80D2, 0x80D3, 	/* 0xC360 to 0xC367 */ 
0x80D4, 0x80D5, 0x80D8, 0x80DF, 0x80E0, 0x80E2, 0x80E3, 0x80E6, 	/* 0xC368 to 0xC36F */ 
0x80EE, 0x80F5, 0x80F7, 0x80F9, 0x80FB, 0x80FE, 0x80FF, 0x8100, 	/* 0xC370 to 0xC377 */ 
0x8101, 0x8103, 0x8104, 0x8105, 0x8107, 0x8108, 0x810B, 0x0000, 	/* 0xC378 to 0xC37F */ 
0x810C, 0x8115, 0x8117, 0x8119, 0x811B, 0x811C, 0x811D, 0x811F, 	/* 0xC380 to 0xC387 */ 
0x8120, 0x8121, 0x8122, 0x8123, 0x8124, 0x8125, 0x8126, 0x8127, 	/* 0xC388 to 0xC38F */ 
0x8128, 0x8129, 0x812A, 0x812B, 0x812D, 0x812E, 0x8130, 0x8133, 	/* 0xC390 to 0xC397 */ 
0x8134, 0x8135, 0x8137, 0x8139, 0x813A, 0x813B, 0x813C, 0x813D, 	/* 0xC398 to 0xC39F */ 
0x813F, 0x8C29, 0x8292, 0x832B, 0x76F2, 0x6C13, 0x5FD9, 0x83BD, 	/* 0xC3A0 to 0xC3A7 */ 
0x732B, 0x8305, 0x951A, 0x6BDB, 0x77DB, 0x94C6, 0x536F, 0x8302, 	/* 0xC3A8 to 0xC3AF */ 
0x5192, 0x5E3D, 0x8C8C, 0x8D38, 0x4E48, 0x73AB, 0x679A, 0x6885, 	/* 0xC3B0 to 0xC3B7 */ 
0x9176, 0x9709, 0x7164, 0x6CA1, 0x7709, 0x5A92, 0x9541, 0x6BCF, 	/* 0xC3B8 to 0xC3BF */ 
0x7F8E, 0x6627, 0x5BD0, 0x59B9, 0x5A9A, 0x95E8, 0x95F7, 0x4EEC, 	/* 0xC3C0 to 0xC3C7 */ 
0x840C, 0x8499, 0x6AAC, 0x76DF, 0x9530, 0x731B, 0x68A6, 0x5B5F, 	/* 0xC3C8 to 0xC3CF */ 
0x772F, 0x919A, 0x9761, 0x7CDC, 0x8FF7, 0x8C1C, 0x5F25, 0x7C73, 	/* 0xC3D0 to 0xC3D7 */ 
0x79D8, 0x89C5, 0x6CCC, 0x871C, 0x5BC6, 0x5E42, 0x68C9, 0x7720, 	/* 0xC3D8 to 0xC3DF */ 
0x7EF5, 0x5195, 0x514D, 0x52C9, 0x5A29, 0x7F05, 0x9762, 0x82D7, 	/* 0xC3E0 to 0xC3E7 */ 
0x63CF, 0x7784, 0x85D0, 0x79D2, 0x6E3A, 0x5E99, 0x5999, 0x8511, 	/* 0xC3E8 to 0xC3EF */ 
0x706D, 0x6C11, 0x62BF, 0x76BF, 0x654F, 0x60AF, 0x95FD, 0x660E, 	/* 0xC3F0 to 0xC3F7 */ 
0x879F, 0x9E23, 0x94ED, 0x540D, 0x547D, 0x8C2C, 0x6478, 0x0000, 	/* 0xC3F8 to 0xC3FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC400 to 0xC407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC408 to 0xC40F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC410 to 0xC417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC418 to 0xC41F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC420 to 0xC427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC428 to 0xC42F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC430 to 0xC437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC438 to 0xC43F */ 
0x8140, 0x8141, 0x8142, 0x8143, 0x8144, 0x8145, 0x8147, 0x8149, 	/* 0xC440 to 0xC447 */ 
0x814D, 0x814E, 0x814F, 0x8152, 0x8156, 0x8157, 0x8158, 0x815B, 	/* 0xC448 to 0xC44F */ 
0x815C, 0x815D, 0x815E, 0x815F, 0x8161, 0x8162, 0x8163, 0x8164, 	/* 0xC450 to 0xC457 */ 
0x8166, 0x8168, 0x816A, 0x816B, 0x816C, 0x816F, 0x8172, 0x8173, 	/* 0xC458 to 0xC45F */ 
0x8175, 0x8176, 0x8177, 0x8178, 0x8181, 0x8183, 0x8184, 0x8185, 	/* 0xC460 to 0xC467 */ 
0x8186, 0x8187, 0x8189, 0x818B, 0x818C, 0x818D, 0x818E, 0x8190, 	/* 0xC468 to 0xC46F */ 
0x8192, 0x8193, 0x8194, 0x8195, 0x8196, 0x8197, 0x8199, 0x819A, 	/* 0xC470 to 0xC477 */ 
0x819E, 0x819F, 0x81A0, 0x81A1, 0x81A2, 0x81A4, 0x81A5, 0x0000, 	/* 0xC478 to 0xC47F */ 
0x81A7, 0x81A9, 0x81AB, 0x81AC, 0x81AD, 0x81AE, 0x81AF, 0x81B0, 	/* 0xC480 to 0xC487 */ 
0x81B1, 0x81B2, 0x81B4, 0x81B5, 0x81B6, 0x81B7, 0x81B8, 0x81B9, 	/* 0xC488 to 0xC48F */ 
0x81BC, 0x81BD, 0x81BE, 0x81BF, 0x81C4, 0x81C5, 0x81C7, 0x81C8, 	/* 0xC490 to 0xC497 */ 
0x81C9, 0x81CB, 0x81CD, 0x81CE, 0x81CF, 0x81D0, 0x81D1, 0x81D2, 	/* 0xC498 to 0xC49F */ 
0x81D3, 0x6479, 0x8611, 0x6A21, 0x819C, 0x78E8, 0x6469, 0x9B54, 	/* 0xC4A0 to 0xC4A7 */ 
0x62B9, 0x672B, 0x83AB, 0x58A8, 0x9ED8, 0x6CAB, 0x6F20, 0x5BDE, 	/* 0xC4A8 to 0xC4AF */ 
0x964C, 0x8C0B, 0x725F, 0x67D0, 0x62C7, 0x7261, 0x4EA9, 0x59C6, 	/* 0xC4B0 to 0xC4B7 */ 
0x6BCD, 0x5893, 0x66AE, 0x5E55, 0x52DF, 0x6155, 0x6728, 0x76EE, 	/* 0xC4B8 to 0xC4BF */ 
0x7766, 0x7267, 0x7A46, 0x62FF, 0x54EA, 0x5450, 0x94A0, 0x90A3, 	/* 0xC4C0 to 0xC4C7 */ 
0x5A1C, 0x7EB3, 0x6C16, 0x4E43, 0x5976, 0x8010, 0x5948, 0x5357, 	/* 0xC4C8 to 0xC4CF */ 
0x7537, 0x96BE, 0x56CA, 0x6320, 0x8111, 0x607C, 0x95F9, 0x6DD6, 	/* 0xC4D0 to 0xC4D7 */ 
0x5462, 0x9981, 0x5185, 0x5AE9, 0x80FD, 0x59AE, 0x9713, 0x502A, 	/* 0xC4D8 to 0xC4DF */ 
0x6CE5, 0x5C3C, 0x62DF, 0x4F60, 0x533F, 0x817B, 0x9006, 0x6EBA, 	/* 0xC4E0 to 0xC4E7 */ 
0x852B, 0x62C8, 0x5E74, 0x78BE, 0x64B5, 0x637B, 0x5FF5, 0x5A18, 	/* 0xC4E8 to 0xC4EF */ 
0x917F, 0x9E1F, 0x5C3F, 0x634F, 0x8042, 0x5B7D, 0x556E, 0x954A, 	/* 0xC4F0 to 0xC4F7 */ 
0x954D, 0x6D85, 0x60A8, 0x67E0, 0x72DE, 0x51DD, 0x5B81, 0x0000, 	/* 0xC4F8 to 0xC4FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC500 to 0xC507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC508 to 0xC50F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC510 to 0xC517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC518 to 0xC51F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC520 to 0xC527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC528 to 0xC52F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC530 to 0xC537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC538 to 0xC53F */ 
0x81D4, 0x81D5, 0x81D6, 0x81D7, 0x81D8, 0x81D9, 0x81DA, 0x81DB, 	/* 0xC540 to 0xC547 */ 
0x81DC, 0x81DD, 0x81DE, 0x81DF, 0x81E0, 0x81E1, 0x81E2, 0x81E4, 	/* 0xC548 to 0xC54F */ 
0x81E5, 0x81E6, 0x81E8, 0x81E9, 0x81EB, 0x81EE, 0x81EF, 0x81F0, 	/* 0xC550 to 0xC557 */ 
0x81F1, 0x81F2, 0x81F5, 0x81F6, 0x81F7, 0x81F8, 0x81F9, 0x81FA, 	/* 0xC558 to 0xC55F */ 
0x81FD, 0x81FF, 0x8203, 0x8207, 0x8208, 0x8209, 0x820A, 0x820B, 	/* 0xC560 to 0xC567 */ 
0x820E, 0x820F, 0x8211, 0x8213, 0x8215, 0x8216, 0x8217, 0x8218, 	/* 0xC568 to 0xC56F */ 
0x8219, 0x821A, 0x821D, 0x8220, 0x8224, 0x8225, 0x8226, 0x8227, 	/* 0xC570 to 0xC577 */ 
0x8229, 0x822E, 0x8232, 0x823A, 0x823C, 0x823D, 0x823F, 0x0000, 	/* 0xC578 to 0xC57F */ 
0x8240, 0x8241, 0x8242, 0x8243, 0x8245, 0x8246, 0x8248, 0x824A, 	/* 0xC580 to 0xC587 */ 
0x824C, 0x824D, 0x824E, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 	/* 0xC588 to 0xC58F */ 
0x8255, 0x8256, 0x8257, 0x8259, 0x825B, 0x825C, 0x825D, 0x825E, 	/* 0xC590 to 0xC597 */ 
0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266, 0x8267, 	/* 0xC598 to 0xC59F */ 
0x8269, 0x62E7, 0x6CDE, 0x725B, 0x626D, 0x94AE, 0x7EBD, 0x8113, 	/* 0xC5A0 to 0xC5A7 */ 
0x6D53, 0x519C, 0x5F04, 0x5974, 0x52AA, 0x6012, 0x5973, 0x6696, 	/* 0xC5A8 to 0xC5AF */ 
0x8650, 0x759F, 0x632A, 0x61E6, 0x7CEF, 0x8BFA, 0x54E6, 0x6B27, 	/* 0xC5B0 to 0xC5B7 */ 
0x9E25, 0x6BB4, 0x85D5, 0x5455, 0x5076, 0x6CA4, 0x556A, 0x8DB4, 	/* 0xC5B8 to 0xC5BF */ 
0x722C, 0x5E15, 0x6015, 0x7436, 0x62CD, 0x6392, 0x724C, 0x5F98, 	/* 0xC5C0 to 0xC5C7 */ 
0x6E43, 0x6D3E, 0x6500, 0x6F58, 0x76D8, 0x78D0, 0x76FC, 0x7554, 	/* 0xC5C8 to 0xC5CF */ 
0x5224, 0x53DB, 0x4E53, 0x5E9E, 0x65C1, 0x802A, 0x80D6, 0x629B, 	/* 0xC5D0 to 0xC5D7 */ 
0x5486, 0x5228, 0x70AE, 0x888D, 0x8DD1, 0x6CE1, 0x5478, 0x80DA, 	/* 0xC5D8 to 0xC5DF */ 
0x57F9, 0x88F4, 0x8D54, 0x966A, 0x914D, 0x4F69, 0x6C9B, 0x55B7, 	/* 0xC5E0 to 0xC5E7 */ 
0x76C6, 0x7830, 0x62A8, 0x70F9, 0x6F8E, 0x5F6D, 0x84EC, 0x68DA, 	/* 0xC5E8 to 0xC5EF */ 
0x787C, 0x7BF7, 0x81A8, 0x670B, 0x9E4F, 0x6367, 0x78B0, 0x576F, 	/* 0xC5F0 to 0xC5F7 */ 
0x7812, 0x9739, 0x6279, 0x62AB, 0x5288, 0x7435, 0x6BD7, 0x0000, 	/* 0xC5F8 to 0xC5FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC600 to 0xC607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC608 to 0xC60F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC610 to 0xC617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC618 to 0xC61F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC620 to 0xC627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC628 to 0xC62F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC630 to 0xC637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC638 to 0xC63F */ 
0x826A, 0x826B, 0x826C, 0x826D, 0x8271, 0x8275, 0x8276, 0x8277, 	/* 0xC640 to 0xC647 */ 
0x8278, 0x827B, 0x827C, 0x8280, 0x8281, 0x8283, 0x8285, 0x8286, 	/* 0xC648 to 0xC64F */ 
0x8287, 0x8289, 0x828C, 0x8290, 0x8293, 0x8294, 0x8295, 0x8296, 	/* 0xC650 to 0xC657 */ 
0x829A, 0x829B, 0x829E, 0x82A0, 0x82A2, 0x82A3, 0x82A7, 0x82B2, 	/* 0xC658 to 0xC65F */ 
0x82B5, 0x82B6, 0x82BA, 0x82BB, 0x82BC, 0x82BF, 0x82C0, 0x82C2, 	/* 0xC660 to 0xC667 */ 
0x82C3, 0x82C5, 0x82C6, 0x82C9, 0x82D0, 0x82D6, 0x82D9, 0x82DA, 	/* 0xC668 to 0xC66F */ 
0x82DD, 0x82E2, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EC, 0x82ED, 	/* 0xC670 to 0xC677 */ 
0x82EE, 0x82F0, 0x82F2, 0x82F3, 0x82F5, 0x82F6, 0x82F8, 0x0000, 	/* 0xC678 to 0xC67F */ 
0x82FA, 0x82FC, 0x82FD, 0x82FE, 0x82FF, 0x8300, 0x830A, 0x830B, 	/* 0xC680 to 0xC687 */ 
0x830D, 0x8310, 0x8312, 0x8313, 0x8316, 0x8318, 0x8319, 0x831D, 	/* 0xC688 to 0xC68F */ 
0x831E, 0x831F, 0x8320, 0x8321, 0x8322, 0x8323, 0x8324, 0x8325, 	/* 0xC690 to 0xC697 */ 
0x8326, 0x8329, 0x832A, 0x832E, 0x8330, 0x8332, 0x8337, 0x833B, 	/* 0xC698 to 0xC69F */ 
0x833D, 0x5564, 0x813E, 0x75B2, 0x76AE, 0x5339, 0x75DE, 0x50FB, 	/* 0xC6A0 to 0xC6A7 */ 
0x5C41, 0x8B6C, 0x7BC7, 0x504F, 0x7247, 0x9A97, 0x98D8, 0x6F02, 	/* 0xC6A8 to 0xC6AF */ 
0x74E2, 0x7968, 0x6487, 0x77A5, 0x62FC, 0x9891, 0x8D2B, 0x54C1, 	/* 0xC6B0 to 0xC6B7 */ 
0x8058, 0x4E52, 0x576A, 0x82F9, 0x840D, 0x5E73, 0x51ED, 0x74F6, 	/* 0xC6B8 to 0xC6BF */ 
0x8BC4, 0x5C4F, 0x5761, 0x6CFC, 0x9887, 0x5A46, 0x7834, 0x9B44, 	/* 0xC6C0 to 0xC6C7 */ 
0x8FEB, 0x7C95, 0x5256, 0x6251, 0x94FA, 0x4EC6, 0x8386, 0x8461, 	/* 0xC6C8 to 0xC6CF */ 
0x83E9, 0x84B2, 0x57D4, 0x6734, 0x5703, 0x666E, 0x6D66, 0x8C31, 	/* 0xC6D0 to 0xC6D7 */ 
0x66DD, 0x7011, 0x671F, 0x6B3A, 0x6816, 0x621A, 0x59BB, 0x4E03, 	/* 0xC6D8 to 0xC6DF */ 
0x51C4, 0x6F06, 0x67D2, 0x6C8F, 0x5176, 0x68CB, 0x5947, 0x6B67, 	/* 0xC6E0 to 0xC6E7 */ 
0x7566, 0x5D0E, 0x8110, 0x9F50, 0x65D7, 0x7948, 0x7941, 0x9A91, 	/* 0xC6E8 to 0xC6EF */ 
0x8D77, 0x5C82, 0x4E5E, 0x4F01, 0x542F, 0x5951, 0x780C, 0x5668, 	/* 0xC6F0 to 0xC6F7 */ 
0x6C14, 0x8FC4, 0x5F03, 0x6C7D, 0x6CE3, 0x8BAB, 0x6390, 0x0000, 	/* 0xC6F8 to 0xC6FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC700 to 0xC707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC708 to 0xC70F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC710 to 0xC717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC718 to 0xC71F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC720 to 0xC727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC728 to 0xC72F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC730 to 0xC737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC738 to 0xC73F */ 
0x833E, 0x833F, 0x8341, 0x8342, 0x8344, 0x8345, 0x8348, 0x834A, 	/* 0xC740 to 0xC747 */ 
0x834B, 0x834C, 0x834D, 0x834E, 0x8353, 0x8355, 0x8356, 0x8357, 	/* 0xC748 to 0xC74F */ 
0x8358, 0x8359, 0x835D, 0x8362, 0x8370, 0x8371, 0x8372, 0x8373, 	/* 0xC750 to 0xC757 */ 
0x8374, 0x8375, 0x8376, 0x8379, 0x837A, 0x837E, 0x837F, 0x8380, 	/* 0xC758 to 0xC75F */ 
0x8381, 0x8382, 0x8383, 0x8384, 0x8387, 0x8388, 0x838A, 0x838B, 	/* 0xC760 to 0xC767 */ 
0x838C, 0x838D, 0x838F, 0x8390, 0x8391, 0x8394, 0x8395, 0x8396, 	/* 0xC768 to 0xC76F */ 
0x8397, 0x8399, 0x839A, 0x839D, 0x839F, 0x83A1, 0x83A2, 0x83A3, 	/* 0xC770 to 0xC777 */ 
0x83A4, 0x83A5, 0x83A6, 0x83A7, 0x83AC, 0x83AD, 0x83AE, 0x0000, 	/* 0xC778 to 0xC77F */ 
0x83AF, 0x83B5, 0x83BB, 0x83BE, 0x83BF, 0x83C2, 0x83C3, 0x83C4, 	/* 0xC780 to 0xC787 */ 
0x83C6, 0x83C8, 0x83C9, 0x83CB, 0x83CD, 0x83CE, 0x83D0, 0x83D1, 	/* 0xC788 to 0xC78F */ 
0x83D2, 0x83D3, 0x83D5, 0x83D7, 0x83D9, 0x83DA, 0x83DB, 0x83DE, 	/* 0xC790 to 0xC797 */ 
0x83E2, 0x83E3, 0x83E4, 0x83E6, 0x83E7, 0x83E8, 0x83EB, 0x83EC, 	/* 0xC798 to 0xC79F */ 
0x83ED, 0x6070, 0x6D3D, 0x7275, 0x6266, 0x948E, 0x94C5, 0x5343, 	/* 0xC7A0 to 0xC7A7 */ 
0x8FC1, 0x7B7E, 0x4EDF, 0x8C26, 0x4E7E, 0x9ED4, 0x94B1, 0x94B3, 	/* 0xC7A8 to 0xC7AF */ 
0x524D, 0x6F5C, 0x9063, 0x6D45, 0x8C34, 0x5811, 0x5D4C, 0x6B20, 	/* 0xC7B0 to 0xC7B7 */ 
0x6B49, 0x67AA, 0x545B, 0x8154, 0x7F8C, 0x5899, 0x8537, 0x5F3A, 	/* 0xC7B8 to 0xC7BF */ 
0x62A2, 0x6A47, 0x9539, 0x6572, 0x6084, 0x6865, 0x77A7, 0x4E54, 	/* 0xC7C0 to 0xC7C7 */ 
0x4FA8, 0x5DE7, 0x9798, 0x64AC, 0x7FD8, 0x5CED, 0x4FCF, 0x7A8D, 	/* 0xC7C8 to 0xC7CF */ 
0x5207, 0x8304, 0x4E14, 0x602F, 0x7A83, 0x94A6, 0x4FB5, 0x4EB2, 	/* 0xC7D0 to 0xC7D7 */ 
0x79E6, 0x7434, 0x52E4, 0x82B9, 0x64D2, 0x79BD, 0x5BDD, 0x6C81, 	/* 0xC7D8 to 0xC7DF */ 
0x9752, 0x8F7B, 0x6C22, 0x503E, 0x537F, 0x6E05, 0x64CE, 0x6674, 	/* 0xC7E0 to 0xC7E7 */ 
0x6C30, 0x60C5, 0x9877, 0x8BF7, 0x5E86, 0x743C, 0x7A77, 0x79CB, 	/* 0xC7E8 to 0xC7EF */ 
0x4E18, 0x90B1, 0x7403, 0x6C42, 0x56DA, 0x914B, 0x6CC5, 0x8D8B, 	/* 0xC7F0 to 0xC7F7 */ 
0x533A, 0x86C6, 0x66F2, 0x8EAF, 0x5C48, 0x9A71, 0x6E20, 0x0000, 	/* 0xC7F8 to 0xC7FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC800 to 0xC807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC808 to 0xC80F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC810 to 0xC817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC818 to 0xC81F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC820 to 0xC827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC828 to 0xC82F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC830 to 0xC837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC838 to 0xC83F */ 
0x83EE, 0x83EF, 0x83F3, 0x83F4, 0x83F5, 0x83F6, 0x83F7, 0x83FA, 	/* 0xC840 to 0xC847 */ 
0x83FB, 0x83FC, 0x83FE, 0x83FF, 0x8400, 0x8402, 0x8405, 0x8407, 	/* 0xC848 to 0xC84F */ 
0x8408, 0x8409, 0x840A, 0x8410, 0x8412, 0x8413, 0x8414, 0x8415, 	/* 0xC850 to 0xC857 */ 
0x8416, 0x8417, 0x8419, 0x841A, 0x841B, 0x841E, 0x841F, 0x8420, 	/* 0xC858 to 0xC85F */ 
0x8421, 0x8422, 0x8423, 0x8429, 0x842A, 0x842B, 0x842C, 0x842D, 	/* 0xC860 to 0xC867 */ 
0x842E, 0x842F, 0x8430, 0x8432, 0x8433, 0x8434, 0x8435, 0x8436, 	/* 0xC868 to 0xC86F */ 
0x8437, 0x8439, 0x843A, 0x843B, 0x843E, 0x843F, 0x8440, 0x8441, 	/* 0xC870 to 0xC877 */ 
0x8442, 0x8443, 0x8444, 0x8445, 0x8447, 0x8448, 0x8449, 0x0000, 	/* 0xC878 to 0xC87F */ 
0x844A, 0x844B, 0x844C, 0x844D, 0x844E, 0x844F, 0x8450, 0x8452, 	/* 0xC880 to 0xC887 */ 
0x8453, 0x8454, 0x8455, 0x8456, 0x8458, 0x845D, 0x845E, 0x845F, 	/* 0xC888 to 0xC88F */ 
0x8460, 0x8462, 0x8464, 0x8465, 0x8466, 0x8467, 0x8468, 0x846A, 	/* 0xC890 to 0xC897 */ 
0x846E, 0x846F, 0x8470, 0x8472, 0x8474, 0x8477, 0x8479, 0x847B, 	/* 0xC898 to 0xC89F */ 
0x847C, 0x53D6, 0x5A36, 0x9F8B, 0x8DA3, 0x53BB, 0x5708, 0x98A7, 	/* 0xC8A0 to 0xC8A7 */ 
0x6743, 0x919B, 0x6CC9, 0x5168, 0x75CA, 0x62F3, 0x72AC, 0x5238, 	/* 0xC8A8 to 0xC8AF */ 
0x529D, 0x7F3A, 0x7094, 0x7638, 0x5374, 0x9E4A, 0x69B7, 0x786E, 	/* 0xC8B0 to 0xC8B7 */ 
0x96C0, 0x88D9, 0x7FA4, 0x7136, 0x71C3, 0x5189, 0x67D3, 0x74E4, 	/* 0xC8B8 to 0xC8BF */ 
0x58E4, 0x6518, 0x56B7, 0x8BA9, 0x9976, 0x6270, 0x7ED5, 0x60F9, 	/* 0xC8C0 to 0xC8C7 */ 
0x70ED, 0x58EC, 0x4EC1, 0x4EBA, 0x5FCD, 0x97E7, 0x4EFB, 0x8BA4, 	/* 0xC8C8 to 0xC8CF */ 
0x5203, 0x598A, 0x7EAB, 0x6254, 0x4ECD, 0x65E5, 0x620E, 0x8338, 	/* 0xC8D0 to 0xC8D7 */ 
0x84C9, 0x8363, 0x878D, 0x7194, 0x6EB6, 0x5BB9, 0x7ED2, 0x5197, 	/* 0xC8D8 to 0xC8DF */ 
0x63C9, 0x67D4, 0x8089, 0x8339, 0x8815, 0x5112, 0x5B7A, 0x5982, 	/* 0xC8E0 to 0xC8E7 */ 
0x8FB1, 0x4E73, 0x6C5D, 0x5165, 0x8925, 0x8F6F, 0x962E, 0x854A, 	/* 0xC8E8 to 0xC8EF */ 
0x745E, 0x9510, 0x95F0, 0x6DA6, 0x82E5, 0x5F31, 0x6492, 0x6D12, 	/* 0xC8F0 to 0xC8F7 */ 
0x8428, 0x816E, 0x9CC3, 0x585E, 0x8D5B, 0x4E09, 0x53C1, 0x0000, 	/* 0xC8F8 to 0xC8FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC900 to 0xC907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC908 to 0xC90F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC910 to 0xC917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC918 to 0xC91F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC920 to 0xC927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC928 to 0xC92F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC930 to 0xC937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC938 to 0xC93F */ 
0x847D, 0x847E, 0x847F, 0x8480, 0x8481, 0x8483, 0x8484, 0x8485, 	/* 0xC940 to 0xC947 */ 
0x8486, 0x848A, 0x848D, 0x848F, 0x8490, 0x8491, 0x8492, 0x8493, 	/* 0xC948 to 0xC94F */ 
0x8494, 0x8495, 0x8496, 0x8498, 0x849A, 0x849B, 0x849D, 0x849E, 	/* 0xC950 to 0xC957 */ 
0x849F, 0x84A0, 0x84A2, 0x84A3, 0x84A4, 0x84A5, 0x84A6, 0x84A7, 	/* 0xC958 to 0xC95F */ 
0x84A8, 0x84A9, 0x84AA, 0x84AB, 0x84AC, 0x84AD, 0x84AE, 0x84B0, 	/* 0xC960 to 0xC967 */ 
0x84B1, 0x84B3, 0x84B5, 0x84B6, 0x84B7, 0x84BB, 0x84BC, 0x84BE, 	/* 0xC968 to 0xC96F */ 
0x84C0, 0x84C2, 0x84C3, 0x84C5, 0x84C6, 0x84C7, 0x84C8, 0x84CB, 	/* 0xC970 to 0xC977 */ 
0x84CC, 0x84CE, 0x84CF, 0x84D2, 0x84D4, 0x84D5, 0x84D7, 0x0000, 	/* 0xC978 to 0xC97F */ 
0x84D8, 0x84D9, 0x84DA, 0x84DB, 0x84DC, 0x84DE, 0x84E1, 0x84E2, 	/* 0xC980 to 0xC987 */ 
0x84E4, 0x84E7, 0x84E8, 0x84E9, 0x84EA, 0x84EB, 0x84ED, 0x84EE, 	/* 0xC988 to 0xC98F */ 
0x84EF, 0x84F1, 0x84F2, 0x84F3, 0x84F4, 0x84F5, 0x84F6, 0x84F7, 	/* 0xC990 to 0xC997 */ 
0x84F8, 0x84F9, 0x84FA, 0x84FB, 0x84FD, 0x84FE, 0x8500, 0x8501, 	/* 0xC998 to 0xC99F */ 
0x8502, 0x4F1E, 0x6563, 0x6851, 0x55D3, 0x4E27, 0x6414, 0x9A9A, 	/* 0xC9A0 to 0xC9A7 */ 
0x626B, 0x5AC2, 0x745F, 0x8272, 0x6DA9, 0x68EE, 0x50E7, 0x838E, 	/* 0xC9A8 to 0xC9AF */ 
0x7802, 0x6740, 0x5239, 0x6C99, 0x7EB1, 0x50BB, 0x5565, 0x715E, 	/* 0xC9B0 to 0xC9B7 */ 
0x7B5B, 0x6652, 0x73CA, 0x82EB, 0x6749, 0x5C71, 0x5220, 0x717D, 	/* 0xC9B8 to 0xC9BF */ 
0x886B, 0x95EA, 0x9655, 0x64C5, 0x8D61, 0x81B3, 0x5584, 0x6C55, 	/* 0xC9C0 to 0xC9C7 */ 
0x6247, 0x7F2E, 0x5892, 0x4F24, 0x5546, 0x8D4F, 0x664C, 0x4E0A, 	/* 0xC9C8 to 0xC9CF */ 
0x5C1A, 0x88F3, 0x68A2, 0x634E, 0x7A0D, 0x70E7, 0x828D, 0x52FA, 	/* 0xC9D0 to 0xC9D7 */ 
0x97F6, 0x5C11, 0x54E8, 0x90B5, 0x7ECD, 0x5962, 0x8D4A, 0x86C7, 	/* 0xC9D8 to 0xC9DF */ 
0x820C, 0x820D, 0x8D66, 0x6444, 0x5C04, 0x6151, 0x6D89, 0x793E, 	/* 0xC9E0 to 0xC9E7 */ 
0x8BBE, 0x7837, 0x7533, 0x547B, 0x4F38, 0x8EAB, 0x6DF1, 0x5A20, 	/* 0xC9E8 to 0xC9EF */ 
0x7EC5, 0x795E, 0x6C88, 0x5BA1, 0x5A76, 0x751A, 0x80BE, 0x614E, 	/* 0xC9F0 to 0xC9F7 */ 
0x6E17, 0x58F0, 0x751F, 0x7525, 0x7272, 0x5347, 0x7EF3, 0x0000, 	/* 0xC9F8 to 0xC9FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA00 to 0xCA07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA08 to 0xCA0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA10 to 0xCA17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA18 to 0xCA1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA20 to 0xCA27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA28 to 0xCA2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA30 to 0xCA37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA38 to 0xCA3F */ 
0x8503, 0x8504, 0x8505, 0x8506, 0x8507, 0x8508, 0x8509, 0x850A, 	/* 0xCA40 to 0xCA47 */ 
0x850B, 0x850D, 0x850E, 0x850F, 0x8510, 0x8512, 0x8514, 0x8515, 	/* 0xCA48 to 0xCA4F */ 
0x8516, 0x8518, 0x8519, 0x851B, 0x851C, 0x851D, 0x851E, 0x8520, 	/* 0xCA50 to 0xCA57 */ 
0x8522, 0x8523, 0x8524, 0x8525, 0x8526, 0x8527, 0x8528, 0x8529, 	/* 0xCA58 to 0xCA5F */ 
0x852A, 0x852D, 0x852E, 0x852F, 0x8530, 0x8531, 0x8532, 0x8533, 	/* 0xCA60 to 0xCA67 */ 
0x8534, 0x8535, 0x8536, 0x853E, 0x853F, 0x8540, 0x8541, 0x8542, 	/* 0xCA68 to 0xCA6F */ 
0x8544, 0x8545, 0x8546, 0x8547, 0x854B, 0x854C, 0x854D, 0x854E, 	/* 0xCA70 to 0xCA77 */ 
0x854F, 0x8550, 0x8551, 0x8552, 0x8553, 0x8554, 0x8555, 0x0000, 	/* 0xCA78 to 0xCA7F */ 
0x8557, 0x8558, 0x855A, 0x855B, 0x855C, 0x855D, 0x855F, 0x8560, 	/* 0xCA80 to 0xCA87 */ 
0x8561, 0x8562, 0x8563, 0x8565, 0x8566, 0x8567, 0x8569, 0x856A, 	/* 0xCA88 to 0xCA8F */ 
0x856B, 0x856C, 0x856D, 0x856E, 0x856F, 0x8570, 0x8571, 0x8573, 	/* 0xCA90 to 0xCA97 */ 
0x8575, 0x8576, 0x8577, 0x8578, 0x857C, 0x857D, 0x857F, 0x8580, 	/* 0xCA98 to 0xCA9F */ 
0x8581, 0x7701, 0x76DB, 0x5269, 0x80DC, 0x5723, 0x5E08, 0x5931, 	/* 0xCAA0 to 0xCAA7 */ 
0x72EE, 0x65BD, 0x6E7F, 0x8BD7, 0x5C38, 0x8671, 0x5341, 0x77F3, 	/* 0xCAA8 to 0xCAAF */ 
0x62FE, 0x65F6, 0x4EC0, 0x98DF, 0x8680, 0x5B9E, 0x8BC6, 0x53F2, 	/* 0xCAB0 to 0xCAB7 */ 
0x77E2, 0x4F7F, 0x5C4E, 0x9A76, 0x59CB, 0x5F0F, 0x793A, 0x58EB, 	/* 0xCAB8 to 0xCABF */ 
0x4E16, 0x67FF, 0x4E8B, 0x62ED, 0x8A93, 0x901D, 0x52BF, 0x662F, 	/* 0xCAC0 to 0xCAC7 */ 
0x55DC, 0x566C, 0x9002, 0x4ED5, 0x4F8D, 0x91CA, 0x9970, 0x6C0F, 	/* 0xCAC8 to 0xCACF */ 
0x5E02, 0x6043, 0x5BA4, 0x89C6, 0x8BD5, 0x6536, 0x624B, 0x9996, 	/* 0xCAD0 to 0xCAD7 */ 
0x5B88, 0x5BFF, 0x6388, 0x552E, 0x53D7, 0x7626, 0x517D, 0x852C, 	/* 0xCAD8 to 0xCADF */ 
0x67A2, 0x68B3, 0x6B8A, 0x6292, 0x8F93, 0x53D4, 0x8212, 0x6DD1, 	/* 0xCAE0 to 0xCAE7 */ 
0x758F, 0x4E66, 0x8D4E, 0x5B70, 0x719F, 0x85AF, 0x6691, 0x66D9, 	/* 0xCAE8 to 0xCAEF */ 
0x7F72, 0x8700, 0x9ECD, 0x9F20, 0x5C5E, 0x672F, 0x8FF0, 0x6811, 	/* 0xCAF0 to 0xCAF7 */ 
0x675F, 0x620D, 0x7AD6, 0x5885, 0x5EB6, 0x6570, 0x6F31, 0x0000, 	/* 0xCAF8 to 0xCAFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB00 to 0xCB07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB08 to 0xCB0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB10 to 0xCB17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB18 to 0xCB1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB20 to 0xCB27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB28 to 0xCB2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB30 to 0xCB37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB38 to 0xCB3F */ 
0x8582, 0x8583, 0x8586, 0x8588, 0x8589, 0x858A, 0x858B, 0x858C, 	/* 0xCB40 to 0xCB47 */ 
0x858D, 0x858E, 0x8590, 0x8591, 0x8592, 0x8593, 0x8594, 0x8595, 	/* 0xCB48 to 0xCB4F */ 
0x8596, 0x8597, 0x8598, 0x8599, 0x859A, 0x859D, 0x859E, 0x859F, 	/* 0xCB50 to 0xCB57 */ 
0x85A0, 0x85A1, 0x85A2, 0x85A3, 0x85A5, 0x85A6, 0x85A7, 0x85A9, 	/* 0xCB58 to 0xCB5F */ 
0x85AB, 0x85AC, 0x85AD, 0x85B1, 0x85B2, 0x85B3, 0x85B4, 0x85B5, 	/* 0xCB60 to 0xCB67 */ 
0x85B6, 0x85B8, 0x85BA, 0x85BB, 0x85BC, 0x85BD, 0x85BE, 0x85BF, 	/* 0xCB68 to 0xCB6F */ 
0x85C0, 0x85C2, 0x85C3, 0x85C4, 0x85C5, 0x85C6, 0x85C7, 0x85C8, 	/* 0xCB70 to 0xCB77 */ 
0x85CA, 0x85CB, 0x85CC, 0x85CD, 0x85CE, 0x85D1, 0x85D2, 0x0000, 	/* 0xCB78 to 0xCB7F */ 
0x85D4, 0x85D6, 0x85D7, 0x85D8, 0x85D9, 0x85DA, 0x85DB, 0x85DD, 	/* 0xCB80 to 0xCB87 */ 
0x85DE, 0x85DF, 0x85E0, 0x85E1, 0x85E2, 0x85E3, 0x85E5, 0x85E6, 	/* 0xCB88 to 0xCB8F */ 
0x85E7, 0x85E8, 0x85EA, 0x85EB, 0x85EC, 0x85ED, 0x85EE, 0x85EF, 	/* 0xCB90 to 0xCB97 */ 
0x85F0, 0x85F1, 0x85F2, 0x85F3, 0x85F4, 0x85F5, 0x85F6, 0x85F7, 	/* 0xCB98 to 0xCB9F */ 
0x85F8, 0x6055, 0x5237, 0x800D, 0x6454, 0x8870, 0x7529, 0x5E05, 	/* 0xCBA0 to 0xCBA7 */ 
0x6813, 0x62F4, 0x971C, 0x53CC, 0x723D, 0x8C01, 0x6C34, 0x7761, 	/* 0xCBA8 to 0xCBAF */ 
0x7A0E, 0x542E, 0x77AC, 0x987A, 0x821C, 0x8BF4, 0x7855, 0x6714, 	/* 0xCBB0 to 0xCBB7 */ 
0x70C1, 0x65AF, 0x6495, 0x5636, 0x601D, 0x79C1, 0x53F8, 0x4E1D, 	/* 0xCBB8 to 0xCBBF */ 
0x6B7B, 0x8086, 0x5BFA, 0x55E3, 0x56DB, 0x4F3A, 0x4F3C, 0x9972, 	/* 0xCBC0 to 0xCBC7 */ 
0x5DF3, 0x677E, 0x8038, 0x6002, 0x9882, 0x9001, 0x5B8B, 0x8BBC, 	/* 0xCBC8 to 0xCBCF */ 
0x8BF5, 0x641C, 0x8258, 0x64DE, 0x55FD, 0x82CF, 0x9165, 0x4FD7, 	/* 0xCBD0 to 0xCBD7 */ 
0x7D20, 0x901F, 0x7C9F, 0x50F3, 0x5851, 0x6EAF, 0x5BBF, 0x8BC9, 	/* 0xCBD8 to 0xCBDF */ 
0x8083, 0x9178, 0x849C, 0x7B97, 0x867D, 0x968B, 0x968F, 0x7EE5, 	/* 0xCBE0 to 0xCBE7 */ 
0x9AD3, 0x788E, 0x5C81, 0x7A57, 0x9042, 0x96A7, 0x795F, 0x5B59, 	/* 0xCBE8 to 0xCBEF */ 
0x635F, 0x7B0B, 0x84D1, 0x68AD, 0x5506, 0x7F29, 0x7410, 0x7D22, 	/* 0xCBF0 to 0xCBF7 */ 
0x9501, 0x6240, 0x584C, 0x4ED6, 0x5B83, 0x5979, 0x5854, 0x0000, 	/* 0xCBF8 to 0xCBFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC00 to 0xCC07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC08 to 0xCC0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC10 to 0xCC17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC18 to 0xCC1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC20 to 0xCC27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC28 to 0xCC2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC30 to 0xCC37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC38 to 0xCC3F */ 
0x85F9, 0x85FA, 0x85FC, 0x85FD, 0x85FE, 0x8600, 0x8601, 0x8602, 	/* 0xCC40 to 0xCC47 */ 
0x8603, 0x8604, 0x8606, 0x8607, 0x8608, 0x8609, 0x860A, 0x860B, 	/* 0xCC48 to 0xCC4F */ 
0x860C, 0x860D, 0x860E, 0x860F, 0x8610, 0x8612, 0x8613, 0x8614, 	/* 0xCC50 to 0xCC57 */ 
0x8615, 0x8617, 0x8618, 0x8619, 0x861A, 0x861B, 0x861C, 0x861D, 	/* 0xCC58 to 0xCC5F */ 
0x861E, 0x861F, 0x8620, 0x8621, 0x8622, 0x8623, 0x8624, 0x8625, 	/* 0xCC60 to 0xCC67 */ 
0x8626, 0x8628, 0x862A, 0x862B, 0x862C, 0x862D, 0x862E, 0x862F, 	/* 0xCC68 to 0xCC6F */ 
0x8630, 0x8631, 0x8632, 0x8633, 0x8634, 0x8635, 0x8636, 0x8637, 	/* 0xCC70 to 0xCC77 */ 
0x8639, 0x863A, 0x863B, 0x863D, 0x863E, 0x863F, 0x8640, 0x0000, 	/* 0xCC78 to 0xCC7F */ 
0x8641, 0x8642, 0x8643, 0x8644, 0x8645, 0x8646, 0x8647, 0x8648, 	/* 0xCC80 to 0xCC87 */ 
0x8649, 0x864A, 0x864B, 0x864C, 0x8652, 0x8653, 0x8655, 0x8656, 	/* 0xCC88 to 0xCC8F */ 
0x8657, 0x8658, 0x8659, 0x865B, 0x865C, 0x865D, 0x865F, 0x8660, 	/* 0xCC90 to 0xCC97 */ 
0x8661, 0x8663, 0x8664, 0x8665, 0x8666, 0x8667, 0x8668, 0x8669, 	/* 0xCC98 to 0xCC9F */ 
0x866A, 0x736D, 0x631E, 0x8E4B, 0x8E0F, 0x80CE, 0x82D4, 0x62AC, 	/* 0xCCA0 to 0xCCA7 */ 
0x53F0, 0x6CF0, 0x915E, 0x592A, 0x6001, 0x6C70, 0x574D, 0x644A, 	/* 0xCCA8 to 0xCCAF */ 
0x8D2A, 0x762B, 0x6EE9, 0x575B, 0x6A80, 0x75F0, 0x6F6D, 0x8C2D, 	/* 0xCCB0 to 0xCCB7 */ 
0x8C08, 0x5766, 0x6BEF, 0x8892, 0x78B3, 0x63A2, 0x53F9, 0x70AD, 	/* 0xCCB8 to 0xCCBF */ 
0x6C64, 0x5858, 0x642A, 0x5802, 0x68E0, 0x819B, 0x5510, 0x7CD6, 	/* 0xCCC0 to 0xCCC7 */ 
0x5018, 0x8EBA, 0x6DCC, 0x8D9F, 0x70EB, 0x638F, 0x6D9B, 0x6ED4, 	/* 0xCCC8 to 0xCCCF */ 
0x7EE6, 0x8404, 0x6843, 0x9003, 0x6DD8, 0x9676, 0x8BA8, 0x5957, 	/* 0xCCD0 to 0xCCD7 */ 
0x7279, 0x85E4, 0x817E, 0x75BC, 0x8A8A, 0x68AF, 0x5254, 0x8E22, 	/* 0xCCD8 to 0xCCDF */ 
0x9511, 0x63D0, 0x9898, 0x8E44, 0x557C, 0x4F53, 0x66FF, 0x568F, 	/* 0xCCE0 to 0xCCE7 */ 
0x60D5, 0x6D95, 0x5243, 0x5C49, 0x5929, 0x6DFB, 0x586B, 0x7530, 	/* 0xCCE8 to 0xCCEF */ 
0x751C, 0x606C, 0x8214, 0x8146, 0x6311, 0x6761, 0x8FE2, 0x773A, 	/* 0xCCF0 to 0xCCF7 */ 
0x8DF3, 0x8D34, 0x94C1, 0x5E16, 0x5385, 0x542C, 0x70C3, 0x0000, 	/* 0xCCF8 to 0xCCFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD00 to 0xCD07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD08 to 0xCD0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD10 to 0xCD17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD18 to 0xCD1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD20 to 0xCD27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD28 to 0xCD2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD30 to 0xCD37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD38 to 0xCD3F */ 
0x866D, 0x866F, 0x8670, 0x8672, 0x8673, 0x8674, 0x8675, 0x8676, 	/* 0xCD40 to 0xCD47 */ 
0x8677, 0x8678, 0x8683, 0x8684, 0x8685, 0x8686, 0x8687, 0x8688, 	/* 0xCD48 to 0xCD4F */ 
0x8689, 0x868E, 0x868F, 0x8690, 0x8691, 0x8692, 0x8694, 0x8696, 	/* 0xCD50 to 0xCD57 */ 
0x8697, 0x8698, 0x8699, 0x869A, 0x869B, 0x869E, 0x869F, 0x86A0, 	/* 0xCD58 to 0xCD5F */ 
0x86A1, 0x86A2, 0x86A5, 0x86A6, 0x86AB, 0x86AD, 0x86AE, 0x86B2, 	/* 0xCD60 to 0xCD67 */ 
0x86B3, 0x86B7, 0x86B8, 0x86B9, 0x86BB, 0x86BC, 0x86BD, 0x86BE, 	/* 0xCD68 to 0xCD6F */ 
0x86BF, 0x86C1, 0x86C2, 0x86C3, 0x86C5, 0x86C8, 0x86CC, 0x86CD, 	/* 0xCD70 to 0xCD77 */ 
0x86D2, 0x86D3, 0x86D5, 0x86D6, 0x86D7, 0x86DA, 0x86DC, 0x0000, 	/* 0xCD78 to 0xCD7F */ 
0x86DD, 0x86E0, 0x86E1, 0x86E2, 0x86E3, 0x86E5, 0x86E6, 0x86E7, 	/* 0xCD80 to 0xCD87 */ 
0x86E8, 0x86EA, 0x86EB, 0x86EC, 0x86EF, 0x86F5, 0x86F6, 0x86F7, 	/* 0xCD88 to 0xCD8F */ 
0x86FA, 0x86FB, 0x86FC, 0x86FD, 0x86FF, 0x8701, 0x8704, 0x8705, 	/* 0xCD90 to 0xCD97 */ 
0x8706, 0x870B, 0x870C, 0x870E, 0x870F, 0x8710, 0x8711, 0x8714, 	/* 0xCD98 to 0xCD9F */ 
0x8716, 0x6C40, 0x5EF7, 0x505C, 0x4EAD, 0x5EAD, 0x633A, 0x8247, 	/* 0xCDA0 to 0xCDA7 */ 
0x901A, 0x6850, 0x916E, 0x77B3, 0x540C, 0x94DC, 0x5F64, 0x7AE5, 	/* 0xCDA8 to 0xCDAF */ 
0x6876, 0x6345, 0x7B52, 0x7EDF, 0x75DB, 0x5077, 0x6295, 0x5934, 	/* 0xCDB0 to 0xCDB7 */ 
0x900F, 0x51F8, 0x79C3, 0x7A81, 0x56FE, 0x5F92, 0x9014, 0x6D82, 	/* 0xCDB8 to 0xCDBF */ 
0x5C60, 0x571F, 0x5410, 0x5154, 0x6E4D, 0x56E2, 0x63A8, 0x9893, 	/* 0xCDC0 to 0xCDC7 */ 
0x817F, 0x8715, 0x892A, 0x9000, 0x541E, 0x5C6F, 0x81C0, 0x62D6, 	/* 0xCDC8 to 0xCDCF */ 
0x6258, 0x8131, 0x9E35, 0x9640, 0x9A6E, 0x9A7C, 0x692D, 0x59A5, 	/* 0xCDD0 to 0xCDD7 */ 
0x62D3, 0x553E, 0x6316, 0x54C7, 0x86D9, 0x6D3C, 0x5A03, 0x74E6, 	/* 0xCDD8 to 0xCDDF */ 
0x889C, 0x6B6A, 0x5916, 0x8C4C, 0x5F2F, 0x6E7E, 0x73A9, 0x987D, 	/* 0xCDE0 to 0xCDE7 */ 
0x4E38, 0x70F7, 0x5B8C, 0x7897, 0x633D, 0x665A, 0x7696, 0x60CB, 	/* 0xCDE8 to 0xCDEF */ 
0x5B9B, 0x5A49, 0x4E07, 0x8155, 0x6C6A, 0x738B, 0x4EA1, 0x6789, 	/* 0xCDF0 to 0xCDF7 */ 
0x7F51, 0x5F80, 0x65FA, 0x671B, 0x5FD8, 0x5984, 0x5A01, 0x0000, 	/* 0xCDF8 to 0xCDFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE00 to 0xCE07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE08 to 0xCE0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE10 to 0xCE17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE18 to 0xCE1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE20 to 0xCE27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE28 to 0xCE2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE30 to 0xCE37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE38 to 0xCE3F */ 
0x8719, 0x871B, 0x871D, 0x871F, 0x8720, 0x8724, 0x8726, 0x8727, 	/* 0xCE40 to 0xCE47 */ 
0x8728, 0x872A, 0x872B, 0x872C, 0x872D, 0x872F, 0x8730, 0x8732, 	/* 0xCE48 to 0xCE4F */ 
0x8733, 0x8735, 0x8736, 0x8738, 0x8739, 0x873A, 0x873C, 0x873D, 	/* 0xCE50 to 0xCE57 */ 
0x8740, 0x8741, 0x8742, 0x8743, 0x8744, 0x8745, 0x8746, 0x874A, 	/* 0xCE58 to 0xCE5F */ 
0x874B, 0x874D, 0x874F, 0x8750, 0x8751, 0x8752, 0x8754, 0x8755, 	/* 0xCE60 to 0xCE67 */ 
0x8756, 0x8758, 0x875A, 0x875B, 0x875C, 0x875D, 0x875E, 0x875F, 	/* 0xCE68 to 0xCE6F */ 
0x8761, 0x8762, 0x8766, 0x8767, 0x8768, 0x8769, 0x876A, 0x876B, 	/* 0xCE70 to 0xCE77 */ 
0x876C, 0x876D, 0x876F, 0x8771, 0x8772, 0x8773, 0x8775, 0x0000, 	/* 0xCE78 to 0xCE7F */ 
0x8777, 0x8778, 0x8779, 0x877A, 0x877F, 0x8780, 0x8781, 0x8784, 	/* 0xCE80 to 0xCE87 */ 
0x8786, 0x8787, 0x8789, 0x878A, 0x878C, 0x878E, 0x878F, 0x8790, 	/* 0xCE88 to 0xCE8F */ 
0x8791, 0x8792, 0x8794, 0x8795, 0x8796, 0x8798, 0x8799, 0x879A, 	/* 0xCE90 to 0xCE97 */ 
0x879B, 0x879C, 0x879D, 0x879E, 0x87A0, 0x87A1, 0x87A2, 0x87A3, 	/* 0xCE98 to 0xCE9F */ 
0x87A4, 0x5DCD, 0x5FAE, 0x5371, 0x97E6, 0x8FDD, 0x6845, 0x56F4, 	/* 0xCEA0 to 0xCEA7 */ 
0x552F, 0x60DF, 0x4E3A, 0x6F4D, 0x7EF4, 0x82C7, 0x840E, 0x59D4, 	/* 0xCEA8 to 0xCEAF */ 
0x4F1F, 0x4F2A, 0x5C3E, 0x7EAC, 0x672A, 0x851A, 0x5473, 0x754F, 	/* 0xCEB0 to 0xCEB7 */ 
0x80C3, 0x5582, 0x9B4F, 0x4F4D, 0x6E2D, 0x8C13, 0x5C09, 0x6170, 	/* 0xCEB8 to 0xCEBF */ 
0x536B, 0x761F, 0x6E29, 0x868A, 0x6587, 0x95FB, 0x7EB9, 0x543B, 	/* 0xCEC0 to 0xCEC7 */ 
0x7A33, 0x7D0A, 0x95EE, 0x55E1, 0x7FC1, 0x74EE, 0x631D, 0x8717, 	/* 0xCEC8 to 0xCECF */ 
0x6DA1, 0x7A9D, 0x6211, 0x65A1, 0x5367, 0x63E1, 0x6C83, 0x5DEB, 	/* 0xCED0 to 0xCED7 */ 
0x545C, 0x94A8, 0x4E4C, 0x6C61, 0x8BEC, 0x5C4B, 0x65E0, 0x829C, 	/* 0xCED8 to 0xCEDF */ 
0x68A7, 0x543E, 0x5434, 0x6BCB, 0x6B66, 0x4E94, 0x6342, 0x5348, 	/* 0xCEE0 to 0xCEE7 */ 
0x821E, 0x4F0D, 0x4FAE, 0x575E, 0x620A, 0x96FE, 0x6664, 0x7269, 	/* 0xCEE8 to 0xCEEF */ 
0x52FF, 0x52A1, 0x609F, 0x8BEF, 0x6614, 0x7199, 0x6790, 0x897F, 	/* 0xCEF0 to 0xCEF7 */ 
0x7852, 0x77FD, 0x6670, 0x563B, 0x5438, 0x9521, 0x727A, 0x0000, 	/* 0xCEF8 to 0xCEFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF00 to 0xCF07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF08 to 0xCF0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF10 to 0xCF17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF18 to 0xCF1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF20 to 0xCF27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF28 to 0xCF2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF30 to 0xCF37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF38 to 0xCF3F */ 
0x87A5, 0x87A6, 0x87A7, 0x87A9, 0x87AA, 0x87AE, 0x87B0, 0x87B1, 	/* 0xCF40 to 0xCF47 */ 
0x87B2, 0x87B4, 0x87B6, 0x87B7, 0x87B8, 0x87B9, 0x87BB, 0x87BC, 	/* 0xCF48 to 0xCF4F */ 
0x87BE, 0x87BF, 0x87C1, 0x87C2, 0x87C3, 0x87C4, 0x87C5, 0x87C7, 	/* 0xCF50 to 0xCF57 */ 
0x87C8, 0x87C9, 0x87CC, 0x87CD, 0x87CE, 0x87CF, 0x87D0, 0x87D4, 	/* 0xCF58 to 0xCF5F */ 
0x87D5, 0x87D6, 0x87D7, 0x87D8, 0x87D9, 0x87DA, 0x87DC, 0x87DD, 	/* 0xCF60 to 0xCF67 */ 
0x87DE, 0x87DF, 0x87E1, 0x87E2, 0x87E3, 0x87E4, 0x87E6, 0x87E7, 	/* 0xCF68 to 0xCF6F */ 
0x87E8, 0x87E9, 0x87EB, 0x87EC, 0x87ED, 0x87EF, 0x87F0, 0x87F1, 	/* 0xCF70 to 0xCF77 */ 
0x87F2, 0x87F3, 0x87F4, 0x87F5, 0x87F6, 0x87F7, 0x87F8, 0x0000, 	/* 0xCF78 to 0xCF7F */ 
0x87FA, 0x87FB, 0x87FC, 0x87FD, 0x87FF, 0x8800, 0x8801, 0x8802, 	/* 0xCF80 to 0xCF87 */ 
0x8804, 0x8805, 0x8806, 0x8807, 0x8808, 0x8809, 0x880B, 0x880C, 	/* 0xCF88 to 0xCF8F */ 
0x880D, 0x880E, 0x880F, 0x8810, 0x8811, 0x8812, 0x8814, 0x8817, 	/* 0xCF90 to 0xCF97 */ 
0x8818, 0x8819, 0x881A, 0x881C, 0x881D, 0x881E, 0x881F, 0x8820, 	/* 0xCF98 to 0xCF9F */ 
0x8823, 0x7A00, 0x606F, 0x5E0C, 0x6089, 0x819D, 0x5915, 0x60DC, 	/* 0xCFA0 to 0xCFA7 */ 
0x7184, 0x70EF, 0x6EAA, 0x6C50, 0x7280, 0x6A84, 0x88AD, 0x5E2D, 	/* 0xCFA8 to 0xCFAF */ 
0x4E60, 0x5AB3, 0x559C, 0x94E3, 0x6D17, 0x7CFB, 0x9699, 0x620F, 	/* 0xCFB0 to 0xCFB7 */ 
0x7EC6, 0x778E, 0x867E, 0x5323, 0x971E, 0x8F96, 0x6687, 0x5CE1, 	/* 0xCFB8 to 0xCFBF */ 
0x4FA0, 0x72ED, 0x4E0B, 0x53A6, 0x590F, 0x5413, 0x6380, 0x9528, 	/* 0xCFC0 to 0xCFC7 */ 
0x5148, 0x4ED9, 0x9C9C, 0x7EA4, 0x54B8, 0x8D24, 0x8854, 0x8237, 	/* 0xCFC8 to 0xCFCF */ 
0x95F2, 0x6D8E, 0x5F26, 0x5ACC, 0x663E, 0x9669, 0x73B0, 0x732E, 	/* 0xCFD0 to 0xCFD7 */ 
0x53BF, 0x817A, 0x9985, 0x7FA1, 0x5BAA, 0x9677, 0x9650, 0x7EBF, 	/* 0xCFD8 to 0xCFDF */ 
0x76F8, 0x53A2, 0x9576, 0x9999, 0x7BB1, 0x8944, 0x6E58, 0x4E61, 	/* 0xCFE0 to 0xCFE7 */ 
0x7FD4, 0x7965, 0x8BE6, 0x60F3, 0x54CD, 0x4EAB, 0x9879, 0x5DF7, 	/* 0xCFE8 to 0xCFEF */ 
0x6A61, 0x50CF, 0x5411, 0x8C61, 0x8427, 0x785D, 0x9704, 0x524A, 	/* 0xCFF0 to 0xCFF7 */ 
0x54EE, 0x56A3, 0x9500, 0x6D88, 0x5BB5, 0x6DC6, 0x6653, 0x0000, 	/* 0xCFF8 to 0xCFFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD000 to 0xD007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD008 to 0xD00F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD010 to 0xD017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD018 to 0xD01F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD020 to 0xD027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD028 to 0xD02F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD030 to 0xD037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD038 to 0xD03F */ 
0x8824, 0x8825, 0x8826, 0x8827, 0x8828, 0x8829, 0x882A, 0x882B, 	/* 0xD040 to 0xD047 */ 
0x882C, 0x882D, 0x882E, 0x882F, 0x8830, 0x8831, 0x8833, 0x8834, 	/* 0xD048 to 0xD04F */ 
0x8835, 0x8836, 0x8837, 0x8838, 0x883A, 0x883B, 0x883D, 0x883E, 	/* 0xD050 to 0xD057 */ 
0x883F, 0x8841, 0x8842, 0x8843, 0x8846, 0x8847, 0x8848, 0x8849, 	/* 0xD058 to 0xD05F */ 
0x884A, 0x884B, 0x884E, 0x884F, 0x8850, 0x8851, 0x8852, 0x8853, 	/* 0xD060 to 0xD067 */ 
0x8855, 0x8856, 0x8858, 0x885A, 0x885B, 0x885C, 0x885D, 0x885E, 	/* 0xD068 to 0xD06F */ 
0x885F, 0x8860, 0x8866, 0x8867, 0x886A, 0x886D, 0x886F, 0x8871, 	/* 0xD070 to 0xD077 */ 
0x8873, 0x8874, 0x8875, 0x8876, 0x8878, 0x8879, 0x887A, 0x0000, 	/* 0xD078 to 0xD07F */ 
0x887B, 0x887C, 0x8880, 0x8883, 0x8886, 0x8887, 0x8889, 0x888A, 	/* 0xD080 to 0xD087 */ 
0x888C, 0x888E, 0x888F, 0x8890, 0x8891, 0x8893, 0x8894, 0x8895, 	/* 0xD088 to 0xD08F */ 
0x8897, 0x8898, 0x8899, 0x889A, 0x889B, 0x889D, 0x889E, 0x889F, 	/* 0xD090 to 0xD097 */ 
0x88A0, 0x88A1, 0x88A3, 0x88A5, 0x88A6, 0x88A7, 0x88A8, 0x88A9, 	/* 0xD098 to 0xD09F */ 
0x88AA, 0x5C0F, 0x5B5D, 0x6821, 0x8096, 0x5578, 0x7B11, 0x6548, 	/* 0xD0A0 to 0xD0A7 */ 
0x6954, 0x4E9B, 0x6B47, 0x874E, 0x978B, 0x534F, 0x631F, 0x643A, 	/* 0xD0A8 to 0xD0AF */ 
0x90AA, 0x659C, 0x80C1, 0x8C10, 0x5199, 0x68B0, 0x5378, 0x87F9, 	/* 0xD0B0 to 0xD0B7 */ 
0x61C8, 0x6CC4, 0x6CFB, 0x8C22, 0x5C51, 0x85AA, 0x82AF, 0x950C, 	/* 0xD0B8 to 0xD0BF */ 
0x6B23, 0x8F9B, 0x65B0, 0x5FFB, 0x5FC3, 0x4FE1, 0x8845, 0x661F, 	/* 0xD0C0 to 0xD0C7 */ 
0x8165, 0x7329, 0x60FA, 0x5174, 0x5211, 0x578B, 0x5F62, 0x90A2, 	/* 0xD0C8 to 0xD0CF */ 
0x884C, 0x9192, 0x5E78, 0x674F, 0x6027, 0x59D3, 0x5144, 0x51F6, 	/* 0xD0D0 to 0xD0D7 */ 
0x80F8, 0x5308, 0x6C79, 0x96C4, 0x718A, 0x4F11, 0x4FEE, 0x7F9E, 	/* 0xD0D8 to 0xD0DF */ 
0x673D, 0x55C5, 0x9508, 0x79C0, 0x8896, 0x7EE3, 0x589F, 0x620C, 	/* 0xD0E0 to 0xD0E7 */ 
0x9700, 0x865A, 0x5618, 0x987B, 0x5F90, 0x8BB8, 0x84C4, 0x9157, 	/* 0xD0E8 to 0xD0EF */ 
0x53D9, 0x65ED, 0x5E8F, 0x755C, 0x6064, 0x7D6E, 0x5A7F, 0x7EEA, 	/* 0xD0F0 to 0xD0F7 */ 
0x7EED, 0x8F69, 0x55A7, 0x5BA3, 0x60AC, 0x65CB, 0x7384, 0x0000, 	/* 0xD0F8 to 0xD0FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD100 to 0xD107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD108 to 0xD10F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD110 to 0xD117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD118 to 0xD11F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD120 to 0xD127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD128 to 0xD12F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD130 to 0xD137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD138 to 0xD13F */ 
0x88AC, 0x88AE, 0x88AF, 0x88B0, 0x88B2, 0x88B3, 0x88B4, 0x88B5, 	/* 0xD140 to 0xD147 */ 
0x88B6, 0x88B8, 0x88B9, 0x88BA, 0x88BB, 0x88BD, 0x88BE, 0x88BF, 	/* 0xD148 to 0xD14F */ 
0x88C0, 0x88C3, 0x88C4, 0x88C7, 0x88C8, 0x88CA, 0x88CB, 0x88CC, 	/* 0xD150 to 0xD157 */ 
0x88CD, 0x88CF, 0x88D0, 0x88D1, 0x88D3, 0x88D6, 0x88D7, 0x88DA, 	/* 0xD158 to 0xD15F */ 
0x88DB, 0x88DC, 0x88DD, 0x88DE, 0x88E0, 0x88E1, 0x88E6, 0x88E7, 	/* 0xD160 to 0xD167 */ 
0x88E9, 0x88EA, 0x88EB, 0x88EC, 0x88ED, 0x88EE, 0x88EF, 0x88F2, 	/* 0xD168 to 0xD16F */ 
0x88F5, 0x88F6, 0x88F7, 0x88FA, 0x88FB, 0x88FD, 0x88FF, 0x8900, 	/* 0xD170 to 0xD177 */ 
0x8901, 0x8903, 0x8904, 0x8905, 0x8906, 0x8907, 0x8908, 0x0000, 	/* 0xD178 to 0xD17F */ 
0x8909, 0x890B, 0x890C, 0x890D, 0x890E, 0x890F, 0x8911, 0x8914, 	/* 0xD180 to 0xD187 */ 
0x8915, 0x8916, 0x8917, 0x8918, 0x891C, 0x891D, 0x891E, 0x891F, 	/* 0xD188 to 0xD18F */ 
0x8920, 0x8922, 0x8923, 0x8924, 0x8926, 0x8927, 0x8928, 0x8929, 	/* 0xD190 to 0xD197 */ 
0x892C, 0x892D, 0x892E, 0x892F, 0x8931, 0x8932, 0x8933, 0x8935, 	/* 0xD198 to 0xD19F */ 
0x8937, 0x9009, 0x7663, 0x7729, 0x7EDA, 0x9774, 0x859B, 0x5B66, 	/* 0xD1A0 to 0xD1A7 */ 
0x7A74, 0x96EA, 0x8840, 0x52CB, 0x718F, 0x5FAA, 0x65EC, 0x8BE2, 	/* 0xD1A8 to 0xD1AF */ 
0x5BFB, 0x9A6F, 0x5DE1, 0x6B89, 0x6C5B, 0x8BAD, 0x8BAF, 0x900A, 	/* 0xD1B0 to 0xD1B7 */ 
0x8FC5, 0x538B, 0x62BC, 0x9E26, 0x9E2D, 0x5440, 0x4E2B, 0x82BD, 	/* 0xD1B8 to 0xD1BF */ 
0x7259, 0x869C, 0x5D16, 0x8859, 0x6DAF, 0x96C5, 0x54D1, 0x4E9A, 	/* 0xD1C0 to 0xD1C7 */ 
0x8BB6, 0x7109, 0x54BD, 0x9609, 0x70DF, 0x6DF9, 0x76D0, 0x4E25, 	/* 0xD1C8 to 0xD1CF */ 
0x7814, 0x8712, 0x5CA9, 0x5EF6, 0x8A00, 0x989C, 0x960E, 0x708E, 	/* 0xD1D0 to 0xD1D7 */ 
0x6CBF, 0x5944, 0x63A9, 0x773C, 0x884D, 0x6F14, 0x8273, 0x5830, 	/* 0xD1D8 to 0xD1DF */ 
0x71D5, 0x538C, 0x781A, 0x96C1, 0x5501, 0x5F66, 0x7130, 0x5BB4, 	/* 0xD1E0 to 0xD1E7 */ 
0x8C1A, 0x9A8C, 0x6B83, 0x592E, 0x9E2F, 0x79E7, 0x6768, 0x626C, 	/* 0xD1E8 to 0xD1EF */ 
0x4F6F, 0x75A1, 0x7F8A, 0x6D0B, 0x9633, 0x6C27, 0x4EF0, 0x75D2, 	/* 0xD1F0 to 0xD1F7 */ 
0x517B, 0x6837, 0x6F3E, 0x9080, 0x8170, 0x5996, 0x7476, 0x0000, 	/* 0xD1F8 to 0xD1FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD200 to 0xD207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD208 to 0xD20F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD210 to 0xD217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD218 to 0xD21F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD220 to 0xD227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD228 to 0xD22F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD230 to 0xD237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD238 to 0xD23F */ 
0x8938, 0x8939, 0x893A, 0x893B, 0x893C, 0x893D, 0x893E, 0x893F, 	/* 0xD240 to 0xD247 */ 
0x8940, 0x8942, 0x8943, 0x8945, 0x8946, 0x8947, 0x8948, 0x8949, 	/* 0xD248 to 0xD24F */ 
0x894A, 0x894B, 0x894C, 0x894D, 0x894E, 0x894F, 0x8950, 0x8951, 	/* 0xD250 to 0xD257 */ 
0x8952, 0x8953, 0x8954, 0x8955, 0x8956, 0x8957, 0x8958, 0x8959, 	/* 0xD258 to 0xD25F */ 
0x895A, 0x895B, 0x895C, 0x895D, 0x8960, 0x8961, 0x8962, 0x8963, 	/* 0xD260 to 0xD267 */ 
0x8964, 0x8965, 0x8967, 0x8968, 0x8969, 0x896A, 0x896B, 0x896C, 	/* 0xD268 to 0xD26F */ 
0x896D, 0x896E, 0x896F, 0x8970, 0x8971, 0x8972, 0x8973, 0x8974, 	/* 0xD270 to 0xD277 */ 
0x8975, 0x8976, 0x8977, 0x8978, 0x8979, 0x897A, 0x897C, 0x0000, 	/* 0xD278 to 0xD27F */ 
0x897D, 0x897E, 0x8980, 0x8982, 0x8984, 0x8985, 0x8987, 0x8988, 	/* 0xD280 to 0xD287 */ 
0x8989, 0x898A, 0x898B, 0x898C, 0x898D, 0x898E, 0x898F, 0x8990, 	/* 0xD288 to 0xD28F */ 
0x8991, 0x8992, 0x8993, 0x8994, 0x8995, 0x8996, 0x8997, 0x8998, 	/* 0xD290 to 0xD297 */ 
0x8999, 0x899A, 0x899B, 0x899C, 0x899D, 0x899E, 0x899F, 0x89A0, 	/* 0xD298 to 0xD29F */ 
0x89A1, 0x6447, 0x5C27, 0x9065, 0x7A91, 0x8C23, 0x59DA, 0x54AC, 	/* 0xD2A0 to 0xD2A7 */ 
0x8200, 0x836F, 0x8981, 0x8000, 0x6930, 0x564E, 0x8036, 0x7237, 	/* 0xD2A8 to 0xD2AF */ 
0x91CE, 0x51B6, 0x4E5F, 0x9875, 0x6396, 0x4E1A, 0x53F6, 0x66F3, 	/* 0xD2B0 to 0xD2B7 */ 
0x814B, 0x591C, 0x6DB2, 0x4E00, 0x58F9, 0x533B, 0x63D6, 0x94F1, 	/* 0xD2B8 to 0xD2BF */ 
0x4F9D, 0x4F0A, 0x8863, 0x9890, 0x5937, 0x9057, 0x79FB, 0x4EEA, 	/* 0xD2C0 to 0xD2C7 */ 
0x80F0, 0x7591, 0x6C82, 0x5B9C, 0x59E8, 0x5F5D, 0x6905, 0x8681, 	/* 0xD2C8 to 0xD2CF */ 
0x501A, 0x5DF2, 0x4E59, 0x77E3, 0x4EE5, 0x827A, 0x6291, 0x6613, 	/* 0xD2D0 to 0xD2D7 */ 
0x9091, 0x5C79, 0x4EBF, 0x5F79, 0x81C6, 0x9038, 0x8084, 0x75AB, 	/* 0xD2D8 to 0xD2DF */ 
0x4EA6, 0x88D4, 0x610F, 0x6BC5, 0x5FC6, 0x4E49, 0x76CA, 0x6EA2, 	/* 0xD2E0 to 0xD2E7 */ 
0x8BE3, 0x8BAE, 0x8C0A, 0x8BD1, 0x5F02, 0x7FFC, 0x7FCC, 0x7ECE, 	/* 0xD2E8 to 0xD2EF */ 
0x8335, 0x836B, 0x56E0, 0x6BB7, 0x97F3, 0x9634, 0x59FB, 0x541F, 	/* 0xD2F0 to 0xD2F7 */ 
0x94F6, 0x6DEB, 0x5BC5, 0x996E, 0x5C39, 0x5F15, 0x9690, 0x0000, 	/* 0xD2F8 to 0xD2FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD300 to 0xD307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD308 to 0xD30F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD310 to 0xD317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD318 to 0xD31F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD320 to 0xD327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD328 to 0xD32F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD330 to 0xD337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD338 to 0xD33F */ 
0x89A2, 0x89A3, 0x89A4, 0x89A5, 0x89A6, 0x89A7, 0x89A8, 0x89A9, 	/* 0xD340 to 0xD347 */ 
0x89AA, 0x89AB, 0x89AC, 0x89AD, 0x89AE, 0x89AF, 0x89B0, 0x89B1, 	/* 0xD348 to 0xD34F */ 
0x89B2, 0x89B3, 0x89B4, 0x89B5, 0x89B6, 0x89B7, 0x89B8, 0x89B9, 	/* 0xD350 to 0xD357 */ 
0x89BA, 0x89BB, 0x89BC, 0x89BD, 0x89BE, 0x89BF, 0x89C0, 0x89C3, 	/* 0xD358 to 0xD35F */ 
0x89CD, 0x89D3, 0x89D4, 0x89D5, 0x89D7, 0x89D8, 0x89D9, 0x89DB, 	/* 0xD360 to 0xD367 */ 
0x89DD, 0x89DF, 0x89E0, 0x89E1, 0x89E2, 0x89E4, 0x89E7, 0x89E8, 	/* 0xD368 to 0xD36F */ 
0x89E9, 0x89EA, 0x89EC, 0x89ED, 0x89EE, 0x89F0, 0x89F1, 0x89F2, 	/* 0xD370 to 0xD377 */ 
0x89F4, 0x89F5, 0x89F6, 0x89F7, 0x89F8, 0x89F9, 0x89FA, 0x0000, 	/* 0xD378 to 0xD37F */ 
0x89FB, 0x89FC, 0x89FD, 0x89FE, 0x89FF, 0x8A01, 0x8A02, 0x8A03, 	/* 0xD380 to 0xD387 */ 
0x8A04, 0x8A05, 0x8A06, 0x8A08, 0x8A09, 0x8A0A, 0x8A0B, 0x8A0C, 	/* 0xD388 to 0xD38F */ 
0x8A0D, 0x8A0E, 0x8A0F, 0x8A10, 0x8A11, 0x8A12, 0x8A13, 0x8A14, 	/* 0xD390 to 0xD397 */ 
0x8A15, 0x8A16, 0x8A17, 0x8A18, 0x8A19, 0x8A1A, 0x8A1B, 0x8A1C, 	/* 0xD398 to 0xD39F */ 
0x8A1D, 0x5370, 0x82F1, 0x6A31, 0x5A74, 0x9E70, 0x5E94, 0x7F28, 	/* 0xD3A0 to 0xD3A7 */ 
0x83B9, 0x8424, 0x8425, 0x8367, 0x8747, 0x8FCE, 0x8D62, 0x76C8, 	/* 0xD3A8 to 0xD3AF */ 
0x5F71, 0x9896, 0x786C, 0x6620, 0x54DF, 0x62E5, 0x4F63, 0x81C3, 	/* 0xD3B0 to 0xD3B7 */ 
0x75C8, 0x5EB8, 0x96CD, 0x8E0A, 0x86F9, 0x548F, 0x6CF3, 0x6D8C, 	/* 0xD3B8 to 0xD3BF */ 
0x6C38, 0x607F, 0x52C7, 0x7528, 0x5E7D, 0x4F18, 0x60A0, 0x5FE7, 	/* 0xD3C0 to 0xD3C7 */ 
0x5C24, 0x7531, 0x90AE, 0x94C0, 0x72B9, 0x6CB9, 0x6E38, 0x9149, 	/* 0xD3C8 to 0xD3CF */ 
0x6709, 0x53CB, 0x53F3, 0x4F51, 0x91C9, 0x8BF1, 0x53C8, 0x5E7C, 	/* 0xD3D0 to 0xD3D7 */ 
0x8FC2, 0x6DE4, 0x4E8E, 0x76C2, 0x6986, 0x865E, 0x611A, 0x8206, 	/* 0xD3D8 to 0xD3DF */ 
0x4F59, 0x4FDE, 0x903E, 0x9C7C, 0x6109, 0x6E1D, 0x6E14, 0x9685, 	/* 0xD3E0 to 0xD3E7 */ 
0x4E88, 0x5A31, 0x96E8, 0x4E0E, 0x5C7F, 0x79B9, 0x5B87, 0x8BED, 	/* 0xD3E8 to 0xD3EF */ 
0x7FBD, 0x7389, 0x57DF, 0x828B, 0x90C1, 0x5401, 0x9047, 0x55BB, 	/* 0xD3F0 to 0xD3F7 */ 
0x5CEA, 0x5FA1, 0x6108, 0x6B32, 0x72F1, 0x80B2, 0x8A89, 0x0000, 	/* 0xD3F8 to 0xD3FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD400 to 0xD407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD408 to 0xD40F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD410 to 0xD417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD418 to 0xD41F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD420 to 0xD427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD428 to 0xD42F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD430 to 0xD437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD438 to 0xD43F */ 
0x8A1E, 0x8A1F, 0x8A20, 0x8A21, 0x8A22, 0x8A23, 0x8A24, 0x8A25, 	/* 0xD440 to 0xD447 */ 
0x8A26, 0x8A27, 0x8A28, 0x8A29, 0x8A2A, 0x8A2B, 0x8A2C, 0x8A2D, 	/* 0xD448 to 0xD44F */ 
0x8A2E, 0x8A2F, 0x8A30, 0x8A31, 0x8A32, 0x8A33, 0x8A34, 0x8A35, 	/* 0xD450 to 0xD457 */ 
0x8A36, 0x8A37, 0x8A38, 0x8A39, 0x8A3A, 0x8A3B, 0x8A3C, 0x8A3D, 	/* 0xD458 to 0xD45F */ 
0x8A3F, 0x8A40, 0x8A41, 0x8A42, 0x8A43, 0x8A44, 0x8A45, 0x8A46, 	/* 0xD460 to 0xD467 */ 
0x8A47, 0x8A49, 0x8A4A, 0x8A4B, 0x8A4C, 0x8A4D, 0x8A4E, 0x8A4F, 	/* 0xD468 to 0xD46F */ 
0x8A50, 0x8A51, 0x8A52, 0x8A53, 0x8A54, 0x8A55, 0x8A56, 0x8A57, 	/* 0xD470 to 0xD477 */ 
0x8A58, 0x8A59, 0x8A5A, 0x8A5B, 0x8A5C, 0x8A5D, 0x8A5E, 0x0000, 	/* 0xD478 to 0xD47F */ 
0x8A5F, 0x8A60, 0x8A61, 0x8A62, 0x8A63, 0x8A64, 0x8A65, 0x8A66, 	/* 0xD480 to 0xD487 */ 
0x8A67, 0x8A68, 0x8A69, 0x8A6A, 0x8A6B, 0x8A6C, 0x8A6D, 0x8A6E, 	/* 0xD488 to 0xD48F */ 
0x8A6F, 0x8A70, 0x8A71, 0x8A72, 0x8A73, 0x8A74, 0x8A75, 0x8A76, 	/* 0xD490 to 0xD497 */ 
0x8A77, 0x8A78, 0x8A7A, 0x8A7B, 0x8A7C, 0x8A7D, 0x8A7E, 0x8A7F, 	/* 0xD498 to 0xD49F */ 
0x8A80, 0x6D74, 0x5BD3, 0x88D5, 0x9884, 0x8C6B, 0x9A6D, 0x9E33, 	/* 0xD4A0 to 0xD4A7 */ 
0x6E0A, 0x51A4, 0x5143, 0x57A3, 0x8881, 0x539F, 0x63F4, 0x8F95, 	/* 0xD4A8 to 0xD4AF */ 
0x56ED, 0x5458, 0x5706, 0x733F, 0x6E90, 0x7F18, 0x8FDC, 0x82D1, 	/* 0xD4B0 to 0xD4B7 */ 
0x613F, 0x6028, 0x9662, 0x66F0, 0x7EA6, 0x8D8A, 0x8DC3, 0x94A5, 	/* 0xD4B8 to 0xD4BF */ 
0x5CB3, 0x7CA4, 0x6708, 0x60A6, 0x9605, 0x8018, 0x4E91, 0x90E7, 	/* 0xD4C0 to 0xD4C7 */ 
0x5300, 0x9668, 0x5141, 0x8FD0, 0x8574, 0x915D, 0x6655, 0x97F5, 	/* 0xD4C8 to 0xD4CF */ 
0x5B55, 0x531D, 0x7838, 0x6742, 0x683D, 0x54C9, 0x707E, 0x5BB0, 	/* 0xD4D0 to 0xD4D7 */ 
0x8F7D, 0x518D, 0x5728, 0x54B1, 0x6512, 0x6682, 0x8D5E, 0x8D43, 	/* 0xD4D8 to 0xD4DF */ 
0x810F, 0x846C, 0x906D, 0x7CDF, 0x51FF, 0x85FB, 0x67A3, 0x65E9, 	/* 0xD4E0 to 0xD4E7 */ 
0x6FA1, 0x86A4, 0x8E81, 0x566A, 0x9020, 0x7682, 0x7076, 0x71E5, 	/* 0xD4E8 to 0xD4EF */ 
0x8D23, 0x62E9, 0x5219, 0x6CFD, 0x8D3C, 0x600E, 0x589E, 0x618E, 	/* 0xD4F0 to 0xD4F7 */ 
0x66FE, 0x8D60, 0x624E, 0x55B3, 0x6E23, 0x672D, 0x8F67, 0x0000, 	/* 0xD4F8 to 0xD4FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD500 to 0xD507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD508 to 0xD50F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD510 to 0xD517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD518 to 0xD51F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD520 to 0xD527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD528 to 0xD52F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD530 to 0xD537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD538 to 0xD53F */ 
0x8A81, 0x8A82, 0x8A83, 0x8A84, 0x8A85, 0x8A86, 0x8A87, 0x8A88, 	/* 0xD540 to 0xD547 */ 
0x8A8B, 0x8A8C, 0x8A8D, 0x8A8E, 0x8A8F, 0x8A90, 0x8A91, 0x8A92, 	/* 0xD548 to 0xD54F */ 
0x8A94, 0x8A95, 0x8A96, 0x8A97, 0x8A98, 0x8A99, 0x8A9A, 0x8A9B, 	/* 0xD550 to 0xD557 */ 
0x8A9C, 0x8A9D, 0x8A9E, 0x8A9F, 0x8AA0, 0x8AA1, 0x8AA2, 0x8AA3, 	/* 0xD558 to 0xD55F */ 
0x8AA4, 0x8AA5, 0x8AA6, 0x8AA7, 0x8AA8, 0x8AA9, 0x8AAA, 0x8AAB, 	/* 0xD560 to 0xD567 */ 
0x8AAC, 0x8AAD, 0x8AAE, 0x8AAF, 0x8AB0, 0x8AB1, 0x8AB2, 0x8AB3, 	/* 0xD568 to 0xD56F */ 
0x8AB4, 0x8AB5, 0x8AB6, 0x8AB7, 0x8AB8, 0x8AB9, 0x8ABA, 0x8ABB, 	/* 0xD570 to 0xD577 */ 
0x8ABC, 0x8ABD, 0x8ABE, 0x8ABF, 0x8AC0, 0x8AC1, 0x8AC2, 0x0000, 	/* 0xD578 to 0xD57F */ 
0x8AC3, 0x8AC4, 0x8AC5, 0x8AC6, 0x8AC7, 0x8AC8, 0x8AC9, 0x8ACA, 	/* 0xD580 to 0xD587 */ 
0x8ACB, 0x8ACC, 0x8ACD, 0x8ACE, 0x8ACF, 0x8AD0, 0x8AD1, 0x8AD2, 	/* 0xD588 to 0xD58F */ 
0x8AD3, 0x8AD4, 0x8AD5, 0x8AD6, 0x8AD7, 0x8AD8, 0x8AD9, 0x8ADA, 	/* 0xD590 to 0xD597 */ 
0x8ADB, 0x8ADC, 0x8ADD, 0x8ADE, 0x8ADF, 0x8AE0, 0x8AE1, 0x8AE2, 	/* 0xD598 to 0xD59F */ 
0x8AE3, 0x94E1, 0x95F8, 0x7728, 0x6805, 0x69A8, 0x548B, 0x4E4D, 	/* 0xD5A0 to 0xD5A7 */ 
0x70B8, 0x8BC8, 0x6458, 0x658B, 0x5B85, 0x7A84, 0x503A, 0x5BE8, 	/* 0xD5A8 to 0xD5AF */ 
0x77BB, 0x6BE1, 0x8A79, 0x7C98, 0x6CBE, 0x76CF, 0x65A9, 0x8F97, 	/* 0xD5B0 to 0xD5B7 */ 
0x5D2D, 0x5C55, 0x8638, 0x6808, 0x5360, 0x6218, 0x7AD9, 0x6E5B, 	/* 0xD5B8 to 0xD5BF */ 
0x7EFD, 0x6A1F, 0x7AE0, 0x5F70, 0x6F33, 0x5F20, 0x638C, 0x6DA8, 	/* 0xD5C0 to 0xD5C7 */ 
0x6756, 0x4E08, 0x5E10, 0x8D26, 0x4ED7, 0x80C0, 0x7634, 0x969C, 	/* 0xD5C8 to 0xD5CF */ 
0x62DB, 0x662D, 0x627E, 0x6CBC, 0x8D75, 0x7167, 0x7F69, 0x5146, 	/* 0xD5D0 to 0xD5D7 */ 
0x8087, 0x53EC, 0x906E, 0x6298, 0x54F2, 0x86F0, 0x8F99, 0x8005, 	/* 0xD5D8 to 0xD5DF */ 
0x9517, 0x8517, 0x8FD9, 0x6D59, 0x73CD, 0x659F, 0x771F, 0x7504, 	/* 0xD5E0 to 0xD5E7 */ 
0x7827, 0x81FB, 0x8D1E, 0x9488, 0x4FA6, 0x6795, 0x75B9, 0x8BCA, 	/* 0xD5E8 to 0xD5EF */ 
0x9707, 0x632F, 0x9547, 0x9635, 0x84B8, 0x6323, 0x7741, 0x5F81, 	/* 0xD5F0 to 0xD5F7 */ 
0x72F0, 0x4E89, 0x6014, 0x6574, 0x62EF, 0x6B63, 0x653F, 0x0000, 	/* 0xD5F8 to 0xD5FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD600 to 0xD607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD608 to 0xD60F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD610 to 0xD617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD618 to 0xD61F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD620 to 0xD627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD628 to 0xD62F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD630 to 0xD637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD638 to 0xD63F */ 
0x8AE4, 0x8AE5, 0x8AE6, 0x8AE7, 0x8AE8, 0x8AE9, 0x8AEA, 0x8AEB, 	/* 0xD640 to 0xD647 */ 
0x8AEC, 0x8AED, 0x8AEE, 0x8AEF, 0x8AF0, 0x8AF1, 0x8AF2, 0x8AF3, 	/* 0xD648 to 0xD64F */ 
0x8AF4, 0x8AF5, 0x8AF6, 0x8AF7, 0x8AF8, 0x8AF9, 0x8AFA, 0x8AFB, 	/* 0xD650 to 0xD657 */ 
0x8AFC, 0x8AFD, 0x8AFE, 0x8AFF, 0x8B00, 0x8B01, 0x8B02, 0x8B03, 	/* 0xD658 to 0xD65F */ 
0x8B04, 0x8B05, 0x8B06, 0x8B08, 0x8B09, 0x8B0A, 0x8B0B, 0x8B0C, 	/* 0xD660 to 0xD667 */ 
0x8B0D, 0x8B0E, 0x8B0F, 0x8B10, 0x8B11, 0x8B12, 0x8B13, 0x8B14, 	/* 0xD668 to 0xD66F */ 
0x8B15, 0x8B16, 0x8B17, 0x8B18, 0x8B19, 0x8B1A, 0x8B1B, 0x8B1C, 	/* 0xD670 to 0xD677 */ 
0x8B1D, 0x8B1E, 0x8B1F, 0x8B20, 0x8B21, 0x8B22, 0x8B23, 0x0000, 	/* 0xD678 to 0xD67F */ 
0x8B24, 0x8B25, 0x8B27, 0x8B28, 0x8B29, 0x8B2A, 0x8B2B, 0x8B2C, 	/* 0xD680 to 0xD687 */ 
0x8B2D, 0x8B2E, 0x8B2F, 0x8B30, 0x8B31, 0x8B32, 0x8B33, 0x8B34, 	/* 0xD688 to 0xD68F */ 
0x8B35, 0x8B36, 0x8B37, 0x8B38, 0x8B39, 0x8B3A, 0x8B3B, 0x8B3C, 	/* 0xD690 to 0xD697 */ 
0x8B3D, 0x8B3E, 0x8B3F, 0x8B40, 0x8B41, 0x8B42, 0x8B43, 0x8B44, 	/* 0xD698 to 0xD69F */ 
0x8B45, 0x5E27, 0x75C7, 0x90D1, 0x8BC1, 0x829D, 0x679D, 0x652F, 	/* 0xD6A0 to 0xD6A7 */ 
0x5431, 0x8718, 0x77E5, 0x80A2, 0x8102, 0x6C41, 0x4E4B, 0x7EC7, 	/* 0xD6A8 to 0xD6AF */ 
0x804C, 0x76F4, 0x690D, 0x6B96, 0x6267, 0x503C, 0x4F84, 0x5740, 	/* 0xD6B0 to 0xD6B7 */ 
0x6307, 0x6B62, 0x8DBE, 0x53EA, 0x65E8, 0x7EB8, 0x5FD7, 0x631A, 	/* 0xD6B8 to 0xD6BF */ 
0x63B7, 0x81F3, 0x81F4, 0x7F6E, 0x5E1C, 0x5CD9, 0x5236, 0x667A, 	/* 0xD6C0 to 0xD6C7 */ 
0x79E9, 0x7A1A, 0x8D28, 0x7099, 0x75D4, 0x6EDE, 0x6CBB, 0x7A92, 	/* 0xD6C8 to 0xD6CF */ 
0x4E2D, 0x76C5, 0x5FE0, 0x949F, 0x8877, 0x7EC8, 0x79CD, 0x80BF, 	/* 0xD6D0 to 0xD6D7 */ 
0x91CD, 0x4EF2, 0x4F17, 0x821F, 0x5468, 0x5DDE, 0x6D32, 0x8BCC, 	/* 0xD6D8 to 0xD6DF */ 
0x7CA5, 0x8F74, 0x8098, 0x5E1A, 0x5492, 0x76B1, 0x5B99, 0x663C, 	/* 0xD6E0 to 0xD6E7 */ 
0x9AA4, 0x73E0, 0x682A, 0x86DB, 0x6731, 0x732A, 0x8BF8, 0x8BDB, 	/* 0xD6E8 to 0xD6EF */ 
0x9010, 0x7AF9, 0x70DB, 0x716E, 0x62C4, 0x77A9, 0x5631, 0x4E3B, 	/* 0xD6F0 to 0xD6F7 */ 
0x8457, 0x67F1, 0x52A9, 0x86C0, 0x8D2E, 0x94F8, 0x7B51, 0x0000, 	/* 0xD6F8 to 0xD6FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD700 to 0xD707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD708 to 0xD70F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD710 to 0xD717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD718 to 0xD71F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD720 to 0xD727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD728 to 0xD72F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD730 to 0xD737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD738 to 0xD73F */ 
0x8B46, 0x8B47, 0x8B48, 0x8B49, 0x8B4A, 0x8B4B, 0x8B4C, 0x8B4D, 	/* 0xD740 to 0xD747 */ 
0x8B4E, 0x8B4F, 0x8B50, 0x8B51, 0x8B52, 0x8B53, 0x8B54, 0x8B55, 	/* 0xD748 to 0xD74F */ 
0x8B56, 0x8B57, 0x8B58, 0x8B59, 0x8B5A, 0x8B5B, 0x8B5C, 0x8B5D, 	/* 0xD750 to 0xD757 */ 
0x8B5E, 0x8B5F, 0x8B60, 0x8B61, 0x8B62, 0x8B63, 0x8B64, 0x8B65, 	/* 0xD758 to 0xD75F */ 
0x8B67, 0x8B68, 0x8B69, 0x8B6A, 0x8B6B, 0x8B6D, 0x8B6E, 0x8B6F, 	/* 0xD760 to 0xD767 */ 
0x8B70, 0x8B71, 0x8B72, 0x8B73, 0x8B74, 0x8B75, 0x8B76, 0x8B77, 	/* 0xD768 to 0xD76F */ 
0x8B78, 0x8B79, 0x8B7A, 0x8B7B, 0x8B7C, 0x8B7D, 0x8B7E, 0x8B7F, 	/* 0xD770 to 0xD777 */ 
0x8B80, 0x8B81, 0x8B82, 0x8B83, 0x8B84, 0x8B85, 0x8B86, 0x0000, 	/* 0xD778 to 0xD77F */ 
0x8B87, 0x8B88, 0x8B89, 0x8B8A, 0x8B8B, 0x8B8C, 0x8B8D, 0x8B8E, 	/* 0xD780 to 0xD787 */ 
0x8B8F, 0x8B90, 0x8B91, 0x8B92, 0x8B93, 0x8B94, 0x8B95, 0x8B96, 	/* 0xD788 to 0xD78F */ 
0x8B97, 0x8B98, 0x8B99, 0x8B9A, 0x8B9B, 0x8B9C, 0x8B9D, 0x8B9E, 	/* 0xD790 to 0xD797 */ 
0x8B9F, 0x8BAC, 0x8BB1, 0x8BBB, 0x8BC7, 0x8BD0, 0x8BEA, 0x8C09, 	/* 0xD798 to 0xD79F */ 
0x8C1E, 0x4F4F, 0x6CE8, 0x795D, 0x9A7B, 0x6293, 0x722A, 0x62FD, 	/* 0xD7A0 to 0xD7A7 */ 
0x4E13, 0x7816, 0x8F6C, 0x64B0, 0x8D5A, 0x7BC6, 0x6869, 0x5E84, 	/* 0xD7A8 to 0xD7AF */ 
0x88C5, 0x5986, 0x649E, 0x58EE, 0x72B6, 0x690E, 0x9525, 0x8FFD, 	/* 0xD7B0 to 0xD7B7 */ 
0x8D58, 0x5760, 0x7F00, 0x8C06, 0x51C6, 0x6349, 0x62D9, 0x5353, 	/* 0xD7B8 to 0xD7BF */ 
0x684C, 0x7422, 0x8301, 0x914C, 0x5544, 0x7740, 0x707C, 0x6D4A, 	/* 0xD7C0 to 0xD7C7 */ 
0x5179, 0x54A8, 0x8D44, 0x59FF, 0x6ECB, 0x6DC4, 0x5B5C, 0x7D2B, 	/* 0xD7C8 to 0xD7CF */ 
0x4ED4, 0x7C7D, 0x6ED3, 0x5B50, 0x81EA, 0x6E0D, 0x5B57, 0x9B03, 	/* 0xD7D0 to 0xD7D7 */ 
0x68D5, 0x8E2A, 0x5B97, 0x7EFC, 0x603B, 0x7EB5, 0x90B9, 0x8D70, 	/* 0xD7D8 to 0xD7DF */ 
0x594F, 0x63CD, 0x79DF, 0x8DB3, 0x5352, 0x65CF, 0x7956, 0x8BC5, 	/* 0xD7E0 to 0xD7E7 */ 
0x963B, 0x7EC4, 0x94BB, 0x7E82, 0x5634, 0x9189, 0x6700, 0x7F6A, 	/* 0xD7E8 to 0xD7EF */ 
0x5C0A, 0x9075, 0x6628, 0x5DE6, 0x4F50, 0x67DE, 0x505A, 0x4F5C, 	/* 0xD7F0 to 0xD7F7 */ 
0x5750, 0x5EA7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD7F8 to 0xD7FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD800 to 0xD807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD808 to 0xD80F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD810 to 0xD817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD818 to 0xD81F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD820 to 0xD827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD828 to 0xD82F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD830 to 0xD837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD838 to 0xD83F */ 
0x8C38, 0x8C39, 0x8C3A, 0x8C3B, 0x8C3C, 0x8C3D, 0x8C3E, 0x8C3F, 	/* 0xD840 to 0xD847 */ 
0x8C40, 0x8C42, 0x8C43, 0x8C44, 0x8C45, 0x8C48, 0x8C4A, 0x8C4B, 	/* 0xD848 to 0xD84F */ 
0x8C4D, 0x8C4E, 0x8C4F, 0x8C50, 0x8C51, 0x8C52, 0x8C53, 0x8C54, 	/* 0xD850 to 0xD857 */ 
0x8C56, 0x8C57, 0x8C58, 0x8C59, 0x8C5B, 0x8C5C, 0x8C5D, 0x8C5E, 	/* 0xD858 to 0xD85F */ 
0x8C5F, 0x8C60, 0x8C63, 0x8C64, 0x8C65, 0x8C66, 0x8C67, 0x8C68, 	/* 0xD860 to 0xD867 */ 
0x8C69, 0x8C6C, 0x8C6D, 0x8C6E, 0x8C6F, 0x8C70, 0x8C71, 0x8C72, 	/* 0xD868 to 0xD86F */ 
0x8C74, 0x8C75, 0x8C76, 0x8C77, 0x8C7B, 0x8C7C, 0x8C7D, 0x8C7E, 	/* 0xD870 to 0xD877 */ 
0x8C7F, 0x8C80, 0x8C81, 0x8C83, 0x8C84, 0x8C86, 0x8C87, 0x0000, 	/* 0xD878 to 0xD87F */ 
0x8C88, 0x8C8B, 0x8C8D, 0x8C8E, 0x8C8F, 0x8C90, 0x8C91, 0x8C92, 	/* 0xD880 to 0xD887 */ 
0x8C93, 0x8C95, 0x8C96, 0x8C97, 0x8C99, 0x8C9A, 0x8C9B, 0x8C9C, 	/* 0xD888 to 0xD88F */ 
0x8C9D, 0x8C9E, 0x8C9F, 0x8CA0, 0x8CA1, 0x8CA2, 0x8CA3, 0x8CA4, 	/* 0xD890 to 0xD897 */ 
0x8CA5, 0x8CA6, 0x8CA7, 0x8CA8, 0x8CA9, 0x8CAA, 0x8CAB, 0x8CAC, 	/* 0xD898 to 0xD89F */ 
0x8CAD, 0x4E8D, 0x4E0C, 0x5140, 0x4E10, 0x5EFF, 0x5345, 0x4E15, 	/* 0xD8A0 to 0xD8A7 */ 
0x4E98, 0x4E1E, 0x9B32, 0x5B6C, 0x5669, 0x4E28, 0x79BA, 0x4E3F, 	/* 0xD8A8 to 0xD8AF */ 
0x5315, 0x4E47, 0x592D, 0x723B, 0x536E, 0x6C10, 0x56DF, 0x80E4, 	/* 0xD8B0 to 0xD8B7 */ 
0x9997, 0x6BD3, 0x777E, 0x9F17, 0x4E36, 0x4E9F, 0x9F10, 0x4E5C, 	/* 0xD8B8 to 0xD8BF */ 
0x4E69, 0x4E93, 0x8288, 0x5B5B, 0x556C, 0x560F, 0x4EC4, 0x538D, 	/* 0xD8C0 to 0xD8C7 */ 
0x539D, 0x53A3, 0x53A5, 0x53AE, 0x9765, 0x8D5D, 0x531A, 0x53F5, 	/* 0xD8C8 to 0xD8CF */ 
0x5326, 0x532E, 0x533E, 0x8D5C, 0x5366, 0x5363, 0x5202, 0x5208, 	/* 0xD8D0 to 0xD8D7 */ 
0x520E, 0x522D, 0x5233, 0x523F, 0x5240, 0x524C, 0x525E, 0x5261, 	/* 0xD8D8 to 0xD8DF */ 
0x525C, 0x84AF, 0x527D, 0x5282, 0x5281, 0x5290, 0x5293, 0x5182, 	/* 0xD8E0 to 0xD8E7 */ 
0x7F54, 0x4EBB, 0x4EC3, 0x4EC9, 0x4EC2, 0x4EE8, 0x4EE1, 0x4EEB, 	/* 0xD8E8 to 0xD8EF */ 
0x4EDE, 0x4F1B, 0x4EF3, 0x4F22, 0x4F64, 0x4EF5, 0x4F25, 0x4F27, 	/* 0xD8F0 to 0xD8F7 */ 
0x4F09, 0x4F2B, 0x4F5E, 0x4F67, 0x6538, 0x4F5A, 0x4F5D, 0x0000, 	/* 0xD8F8 to 0xD8FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD900 to 0xD907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD908 to 0xD90F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD910 to 0xD917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD918 to 0xD91F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD920 to 0xD927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD928 to 0xD92F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD930 to 0xD937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD938 to 0xD93F */ 
0x8CAE, 0x8CAF, 0x8CB0, 0x8CB1, 0x8CB2, 0x8CB3, 0x8CB4, 0x8CB5, 	/* 0xD940 to 0xD947 */ 
0x8CB6, 0x8CB7, 0x8CB8, 0x8CB9, 0x8CBA, 0x8CBB, 0x8CBC, 0x8CBD, 	/* 0xD948 to 0xD94F */ 
0x8CBE, 0x8CBF, 0x8CC0, 0x8CC1, 0x8CC2, 0x8CC3, 0x8CC4, 0x8CC5, 	/* 0xD950 to 0xD957 */ 
0x8CC6, 0x8CC7, 0x8CC8, 0x8CC9, 0x8CCA, 0x8CCB, 0x8CCC, 0x8CCD, 	/* 0xD958 to 0xD95F */ 
0x8CCE, 0x8CCF, 0x8CD0, 0x8CD1, 0x8CD2, 0x8CD3, 0x8CD4, 0x8CD5, 	/* 0xD960 to 0xD967 */ 
0x8CD6, 0x8CD7, 0x8CD8, 0x8CD9, 0x8CDA, 0x8CDB, 0x8CDC, 0x8CDD, 	/* 0xD968 to 0xD96F */ 
0x8CDE, 0x8CDF, 0x8CE0, 0x8CE1, 0x8CE2, 0x8CE3, 0x8CE4, 0x8CE5, 	/* 0xD970 to 0xD977 */ 
0x8CE6, 0x8CE7, 0x8CE8, 0x8CE9, 0x8CEA, 0x8CEB, 0x8CEC, 0x0000, 	/* 0xD978 to 0xD97F */ 
0x8CED, 0x8CEE, 0x8CEF, 0x8CF0, 0x8CF1, 0x8CF2, 0x8CF3, 0x8CF4, 	/* 0xD980 to 0xD987 */ 
0x8CF5, 0x8CF6, 0x8CF7, 0x8CF8, 0x8CF9, 0x8CFA, 0x8CFB, 0x8CFC, 	/* 0xD988 to 0xD98F */ 
0x8CFD, 0x8CFE, 0x8CFF, 0x8D00, 0x8D01, 0x8D02, 0x8D03, 0x8D04, 	/* 0xD990 to 0xD997 */ 
0x8D05, 0x8D06, 0x8D07, 0x8D08, 0x8D09, 0x8D0A, 0x8D0B, 0x8D0C, 	/* 0xD998 to 0xD99F */ 
0x8D0D, 0x4F5F, 0x4F57, 0x4F32, 0x4F3D, 0x4F76, 0x4F74, 0x4F91, 	/* 0xD9A0 to 0xD9A7 */ 
0x4F89, 0x4F83, 0x4F8F, 0x4F7E, 0x4F7B, 0x4FAA, 0x4F7C, 0x4FAC, 	/* 0xD9A8 to 0xD9AF */ 
0x4F94, 0x4FE6, 0x4FE8, 0x4FEA, 0x4FC5, 0x4FDA, 0x4FE3, 0x4FDC, 	/* 0xD9B0 to 0xD9B7 */ 
0x4FD1, 0x4FDF, 0x4FF8, 0x5029, 0x504C, 0x4FF3, 0x502C, 0x500F, 	/* 0xD9B8 to 0xD9BF */ 
0x502E, 0x502D, 0x4FFE, 0x501C, 0x500C, 0x5025, 0x5028, 0x507E, 	/* 0xD9C0 to 0xD9C7 */ 
0x5043, 0x5055, 0x5048, 0x504E, 0x506C, 0x507B, 0x50A5, 0x50A7, 	/* 0xD9C8 to 0xD9CF */ 
0x50A9, 0x50BA, 0x50D6, 0x5106, 0x50ED, 0x50EC, 0x50E6, 0x50EE, 	/* 0xD9D0 to 0xD9D7 */ 
0x5107, 0x510B, 0x4EDD, 0x6C3D, 0x4F58, 0x4F65, 0x4FCE, 0x9FA0, 	/* 0xD9D8 to 0xD9DF */ 
0x6C46, 0x7C74, 0x516E, 0x5DFD, 0x9EC9, 0x9998, 0x5181, 0x5914, 	/* 0xD9E0 to 0xD9E7 */ 
0x52F9, 0x530D, 0x8A07, 0x5310, 0x51EB, 0x5919, 0x5155, 0x4EA0, 	/* 0xD9E8 to 0xD9EF */ 
0x5156, 0x4EB3, 0x886E, 0x88A4, 0x4EB5, 0x8114, 0x88D2, 0x7980, 	/* 0xD9F0 to 0xD9F7 */ 
0x5B34, 0x8803, 0x7FB8, 0x51AB, 0x51B1, 0x51BD, 0x51BC, 0x0000, 	/* 0xD9F8 to 0xD9FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA00 to 0xDA07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA08 to 0xDA0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA10 to 0xDA17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA18 to 0xDA1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA20 to 0xDA27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA28 to 0xDA2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA30 to 0xDA37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA38 to 0xDA3F */ 
0x8D0E, 0x8D0F, 0x8D10, 0x8D11, 0x8D12, 0x8D13, 0x8D14, 0x8D15, 	/* 0xDA40 to 0xDA47 */ 
0x8D16, 0x8D17, 0x8D18, 0x8D19, 0x8D1A, 0x8D1B, 0x8D1C, 0x8D20, 	/* 0xDA48 to 0xDA4F */ 
0x8D51, 0x8D52, 0x8D57, 0x8D5F, 0x8D65, 0x8D68, 0x8D69, 0x8D6A, 	/* 0xDA50 to 0xDA57 */ 
0x8D6C, 0x8D6E, 0x8D6F, 0x8D71, 0x8D72, 0x8D78, 0x8D79, 0x8D7A, 	/* 0xDA58 to 0xDA5F */ 
0x8D7B, 0x8D7C, 0x8D7D, 0x8D7E, 0x8D7F, 0x8D80, 0x8D82, 0x8D83, 	/* 0xDA60 to 0xDA67 */ 
0x8D86, 0x8D87, 0x8D88, 0x8D89, 0x8D8C, 0x8D8D, 0x8D8E, 0x8D8F, 	/* 0xDA68 to 0xDA6F */ 
0x8D90, 0x8D92, 0x8D93, 0x8D95, 0x8D96, 0x8D97, 0x8D98, 0x8D99, 	/* 0xDA70 to 0xDA77 */ 
0x8D9A, 0x8D9B, 0x8D9C, 0x8D9D, 0x8D9E, 0x8DA0, 0x8DA1, 0x0000, 	/* 0xDA78 to 0xDA7F */ 
0x8DA2, 0x8DA4, 0x8DA5, 0x8DA6, 0x8DA7, 0x8DA8, 0x8DA9, 0x8DAA, 	/* 0xDA80 to 0xDA87 */ 
0x8DAB, 0x8DAC, 0x8DAD, 0x8DAE, 0x8DAF, 0x8DB0, 0x8DB2, 0x8DB6, 	/* 0xDA88 to 0xDA8F */ 
0x8DB7, 0x8DB9, 0x8DBB, 0x8DBD, 0x8DC0, 0x8DC1, 0x8DC2, 0x8DC5, 	/* 0xDA90 to 0xDA97 */ 
0x8DC7, 0x8DC8, 0x8DC9, 0x8DCA, 0x8DCD, 0x8DD0, 0x8DD2, 0x8DD3, 	/* 0xDA98 to 0xDA9F */ 
0x8DD4, 0x51C7, 0x5196, 0x51A2, 0x51A5, 0x8BA0, 0x8BA6, 0x8BA7, 	/* 0xDAA0 to 0xDAA7 */ 
0x8BAA, 0x8BB4, 0x8BB5, 0x8BB7, 0x8BC2, 0x8BC3, 0x8BCB, 0x8BCF, 	/* 0xDAA8 to 0xDAAF */ 
0x8BCE, 0x8BD2, 0x8BD3, 0x8BD4, 0x8BD6, 0x8BD8, 0x8BD9, 0x8BDC, 	/* 0xDAB0 to 0xDAB7 */ 
0x8BDF, 0x8BE0, 0x8BE4, 0x8BE8, 0x8BE9, 0x8BEE, 0x8BF0, 0x8BF3, 	/* 0xDAB8 to 0xDABF */ 
0x8BF6, 0x8BF9, 0x8BFC, 0x8BFF, 0x8C00, 0x8C02, 0x8C04, 0x8C07, 	/* 0xDAC0 to 0xDAC7 */ 
0x8C0C, 0x8C0F, 0x8C11, 0x8C12, 0x8C14, 0x8C15, 0x8C16, 0x8C19, 	/* 0xDAC8 to 0xDACF */ 
0x8C1B, 0x8C18, 0x8C1D, 0x8C1F, 0x8C20, 0x8C21, 0x8C25, 0x8C27, 	/* 0xDAD0 to 0xDAD7 */ 
0x8C2A, 0x8C2B, 0x8C2E, 0x8C2F, 0x8C32, 0x8C33, 0x8C35, 0x8C36, 	/* 0xDAD8 to 0xDADF */ 
0x5369, 0x537A, 0x961D, 0x9622, 0x9621, 0x9631, 0x962A, 0x963D, 	/* 0xDAE0 to 0xDAE7 */ 
0x963C, 0x9642, 0x9649, 0x9654, 0x965F, 0x9667, 0x966C, 0x9672, 	/* 0xDAE8 to 0xDAEF */ 
0x9674, 0x9688, 0x968D, 0x9697, 0x96B0, 0x9097, 0x909B, 0x909D, 	/* 0xDAF0 to 0xDAF7 */ 
0x9099, 0x90AC, 0x90A1, 0x90B4, 0x90B3, 0x90B6, 0x90BA, 0x0000, 	/* 0xDAF8 to 0xDAFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB00 to 0xDB07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB08 to 0xDB0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB10 to 0xDB17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB18 to 0xDB1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB20 to 0xDB27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB28 to 0xDB2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB30 to 0xDB37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB38 to 0xDB3F */ 
0x8DD5, 0x8DD8, 0x8DD9, 0x8DDC, 0x8DE0, 0x8DE1, 0x8DE2, 0x8DE5, 	/* 0xDB40 to 0xDB47 */ 
0x8DE6, 0x8DE7, 0x8DE9, 0x8DED, 0x8DEE, 0x8DF0, 0x8DF1, 0x8DF2, 	/* 0xDB48 to 0xDB4F */ 
0x8DF4, 0x8DF6, 0x8DFC, 0x8DFE, 0x8DFF, 0x8E00, 0x8E01, 0x8E02, 	/* 0xDB50 to 0xDB57 */ 
0x8E03, 0x8E04, 0x8E06, 0x8E07, 0x8E08, 0x8E0B, 0x8E0D, 0x8E0E, 	/* 0xDB58 to 0xDB5F */ 
0x8E10, 0x8E11, 0x8E12, 0x8E13, 0x8E15, 0x8E16, 0x8E17, 0x8E18, 	/* 0xDB60 to 0xDB67 */ 
0x8E19, 0x8E1A, 0x8E1B, 0x8E1C, 0x8E20, 0x8E21, 0x8E24, 0x8E25, 	/* 0xDB68 to 0xDB6F */ 
0x8E26, 0x8E27, 0x8E28, 0x8E2B, 0x8E2D, 0x8E30, 0x8E32, 0x8E33, 	/* 0xDB70 to 0xDB77 */ 
0x8E34, 0x8E36, 0x8E37, 0x8E38, 0x8E3B, 0x8E3C, 0x8E3E, 0x0000, 	/* 0xDB78 to 0xDB7F */ 
0x8E3F, 0x8E43, 0x8E45, 0x8E46, 0x8E4C, 0x8E4D, 0x8E4E, 0x8E4F, 	/* 0xDB80 to 0xDB87 */ 
0x8E50, 0x8E53, 0x8E54, 0x8E55, 0x8E56, 0x8E57, 0x8E58, 0x8E5A, 	/* 0xDB88 to 0xDB8F */ 
0x8E5B, 0x8E5C, 0x8E5D, 0x8E5E, 0x8E5F, 0x8E60, 0x8E61, 0x8E62, 	/* 0xDB90 to 0xDB97 */ 
0x8E63, 0x8E64, 0x8E65, 0x8E67, 0x8E68, 0x8E6A, 0x8E6B, 0x8E6E, 	/* 0xDB98 to 0xDB9F */ 
0x8E71, 0x90B8, 0x90B0, 0x90CF, 0x90C5, 0x90BE, 0x90D0, 0x90C4, 	/* 0xDBA0 to 0xDBA7 */ 
0x90C7, 0x90D3, 0x90E6, 0x90E2, 0x90DC, 0x90D7, 0x90DB, 0x90EB, 	/* 0xDBA8 to 0xDBAF */ 
0x90EF, 0x90FE, 0x9104, 0x9122, 0x911E, 0x9123, 0x9131, 0x912F, 	/* 0xDBB0 to 0xDBB7 */ 
0x9139, 0x9143, 0x9146, 0x520D, 0x5942, 0x52A2, 0x52AC, 0x52AD, 	/* 0xDBB8 to 0xDBBF */ 
0x52BE, 0x54FF, 0x52D0, 0x52D6, 0x52F0, 0x53DF, 0x71EE, 0x77CD, 	/* 0xDBC0 to 0xDBC7 */ 
0x5EF4, 0x51F5, 0x51FC, 0x9B2F, 0x53B6, 0x5F01, 0x755A, 0x5DEF, 	/* 0xDBC8 to 0xDBCF */ 
0x574C, 0x57A9, 0x57A1, 0x587E, 0x58BC, 0x58C5, 0x58D1, 0x5729, 	/* 0xDBD0 to 0xDBD7 */ 
0x572C, 0x572A, 0x5733, 0x5739, 0x572E, 0x572F, 0x575C, 0x573B, 	/* 0xDBD8 to 0xDBDF */ 
0x5742, 0x5769, 0x5785, 0x576B, 0x5786, 0x577C, 0x577B, 0x5768, 	/* 0xDBE0 to 0xDBE7 */ 
0x576D, 0x5776, 0x5773, 0x57AD, 0x57A4, 0x578C, 0x57B2, 0x57CF, 	/* 0xDBE8 to 0xDBEF */ 
0x57A7, 0x57B4, 0x5793, 0x57A0, 0x57D5, 0x57D8, 0x57DA, 0x57D9, 	/* 0xDBF0 to 0xDBF7 */ 
0x57D2, 0x57B8, 0x57F4, 0x57EF, 0x57F8, 0x57E4, 0x57DD, 0x0000, 	/* 0xDBF8 to 0xDBFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC00 to 0xDC07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC08 to 0xDC0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC10 to 0xDC17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC18 to 0xDC1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC20 to 0xDC27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC28 to 0xDC2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC30 to 0xDC37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC38 to 0xDC3F */ 
0x8E73, 0x8E75, 0x8E77, 0x8E78, 0x8E79, 0x8E7A, 0x8E7B, 0x8E7D, 	/* 0xDC40 to 0xDC47 */ 
0x8E7E, 0x8E80, 0x8E82, 0x8E83, 0x8E84, 0x8E86, 0x8E88, 0x8E89, 	/* 0xDC48 to 0xDC4F */ 
0x8E8A, 0x8E8B, 0x8E8C, 0x8E8D, 0x8E8E, 0x8E91, 0x8E92, 0x8E93, 	/* 0xDC50 to 0xDC57 */ 
0x8E95, 0x8E96, 0x8E97, 0x8E98, 0x8E99, 0x8E9A, 0x8E9B, 0x8E9D, 	/* 0xDC58 to 0xDC5F */ 
0x8E9F, 0x8EA0, 0x8EA1, 0x8EA2, 0x8EA3, 0x8EA4, 0x8EA5, 0x8EA6, 	/* 0xDC60 to 0xDC67 */ 
0x8EA7, 0x8EA8, 0x8EA9, 0x8EAA, 0x8EAD, 0x8EAE, 0x8EB0, 0x8EB1, 	/* 0xDC68 to 0xDC6F */ 
0x8EB3, 0x8EB4, 0x8EB5, 0x8EB6, 0x8EB7, 0x8EB8, 0x8EB9, 0x8EBB, 	/* 0xDC70 to 0xDC77 */ 
0x8EBC, 0x8EBD, 0x8EBE, 0x8EBF, 0x8EC0, 0x8EC1, 0x8EC2, 0x0000, 	/* 0xDC78 to 0xDC7F */ 
0x8EC3, 0x8EC4, 0x8EC5, 0x8EC6, 0x8EC7, 0x8EC8, 0x8EC9, 0x8ECA, 	/* 0xDC80 to 0xDC87 */ 
0x8ECB, 0x8ECC, 0x8ECD, 0x8ECF, 0x8ED0, 0x8ED1, 0x8ED2, 0x8ED3, 	/* 0xDC88 to 0xDC8F */ 
0x8ED4, 0x8ED5, 0x8ED6, 0x8ED7, 0x8ED8, 0x8ED9, 0x8EDA, 0x8EDB, 	/* 0xDC90 to 0xDC97 */ 
0x8EDC, 0x8EDD, 0x8EDE, 0x8EDF, 0x8EE0, 0x8EE1, 0x8EE2, 0x8EE3, 	/* 0xDC98 to 0xDC9F */ 
0x8EE4, 0x580B, 0x580D, 0x57FD, 0x57ED, 0x5800, 0x581E, 0x5819, 	/* 0xDCA0 to 0xDCA7 */ 
0x5844, 0x5820, 0x5865, 0x586C, 0x5881, 0x5889, 0x589A, 0x5880, 	/* 0xDCA8 to 0xDCAF */ 
0x99A8, 0x9F19, 0x61FF, 0x8279, 0x827D, 0x827F, 0x828F, 0x828A, 	/* 0xDCB0 to 0xDCB7 */ 
0x82A8, 0x8284, 0x828E, 0x8291, 0x8297, 0x8299, 0x82AB, 0x82B8, 	/* 0xDCB8 to 0xDCBF */ 
0x82BE, 0x82B0, 0x82C8, 0x82CA, 0x82E3, 0x8298, 0x82B7, 0x82AE, 	/* 0xDCC0 to 0xDCC7 */ 
0x82CB, 0x82CC, 0x82C1, 0x82A9, 0x82B4, 0x82A1, 0x82AA, 0x829F, 	/* 0xDCC8 to 0xDCCF */ 
0x82C4, 0x82CE, 0x82A4, 0x82E1, 0x8309, 0x82F7, 0x82E4, 0x830F, 	/* 0xDCD0 to 0xDCD7 */ 
0x8307, 0x82DC, 0x82F4, 0x82D2, 0x82D8, 0x830C, 0x82FB, 0x82D3, 	/* 0xDCD8 to 0xDCDF */ 
0x8311, 0x831A, 0x8306, 0x8314, 0x8315, 0x82E0, 0x82D5, 0x831C, 	/* 0xDCE0 to 0xDCE7 */ 
0x8351, 0x835B, 0x835C, 0x8308, 0x8392, 0x833C, 0x8334, 0x8331, 	/* 0xDCE8 to 0xDCEF */ 
0x839B, 0x835E, 0x832F, 0x834F, 0x8347, 0x8343, 0x835F, 0x8340, 	/* 0xDCF0 to 0xDCF7 */ 
0x8317, 0x8360, 0x832D, 0x833A, 0x8333, 0x8366, 0x8365, 0x0000, 	/* 0xDCF8 to 0xDCFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD00 to 0xDD07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD08 to 0xDD0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD10 to 0xDD17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD18 to 0xDD1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD20 to 0xDD27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD28 to 0xDD2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD30 to 0xDD37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD38 to 0xDD3F */ 
0x8EE5, 0x8EE6, 0x8EE7, 0x8EE8, 0x8EE9, 0x8EEA, 0x8EEB, 0x8EEC, 	/* 0xDD40 to 0xDD47 */ 
0x8EED, 0x8EEE, 0x8EEF, 0x8EF0, 0x8EF1, 0x8EF2, 0x8EF3, 0x8EF4, 	/* 0xDD48 to 0xDD4F */ 
0x8EF5, 0x8EF6, 0x8EF7, 0x8EF8, 0x8EF9, 0x8EFA, 0x8EFB, 0x8EFC, 	/* 0xDD50 to 0xDD57 */ 
0x8EFD, 0x8EFE, 0x8EFF, 0x8F00, 0x8F01, 0x8F02, 0x8F03, 0x8F04, 	/* 0xDD58 to 0xDD5F */ 
0x8F05, 0x8F06, 0x8F07, 0x8F08, 0x8F09, 0x8F0A, 0x8F0B, 0x8F0C, 	/* 0xDD60 to 0xDD67 */ 
0x8F0D, 0x8F0E, 0x8F0F, 0x8F10, 0x8F11, 0x8F12, 0x8F13, 0x8F14, 	/* 0xDD68 to 0xDD6F */ 
0x8F15, 0x8F16, 0x8F17, 0x8F18, 0x8F19, 0x8F1A, 0x8F1B, 0x8F1C, 	/* 0xDD70 to 0xDD77 */ 
0x8F1D, 0x8F1E, 0x8F1F, 0x8F20, 0x8F21, 0x8F22, 0x8F23, 0x0000, 	/* 0xDD78 to 0xDD7F */ 
0x8F24, 0x8F25, 0x8F26, 0x8F27, 0x8F28, 0x8F29, 0x8F2A, 0x8F2B, 	/* 0xDD80 to 0xDD87 */ 
0x8F2C, 0x8F2D, 0x8F2E, 0x8F2F, 0x8F30, 0x8F31, 0x8F32, 0x8F33, 	/* 0xDD88 to 0xDD8F */ 
0x8F34, 0x8F35, 0x8F36, 0x8F37, 0x8F38, 0x8F39, 0x8F3A, 0x8F3B, 	/* 0xDD90 to 0xDD97 */ 
0x8F3C, 0x8F3D, 0x8F3E, 0x8F3F, 0x8F40, 0x8F41, 0x8F42, 0x8F43, 	/* 0xDD98 to 0xDD9F */ 
0x8F44, 0x8368, 0x831B, 0x8369, 0x836C, 0x836A, 0x836D, 0x836E, 	/* 0xDDA0 to 0xDDA7 */ 
0x83B0, 0x8378, 0x83B3, 0x83B4, 0x83A0, 0x83AA, 0x8393, 0x839C, 	/* 0xDDA8 to 0xDDAF */ 
0x8385, 0x837C, 0x83B6, 0x83A9, 0x837D, 0x83B8, 0x837B, 0x8398, 	/* 0xDDB0 to 0xDDB7 */ 
0x839E, 0x83A8, 0x83BA, 0x83BC, 0x83C1, 0x8401, 0x83E5, 0x83D8, 	/* 0xDDB8 to 0xDDBF */ 
0x5807, 0x8418, 0x840B, 0x83DD, 0x83FD, 0x83D6, 0x841C, 0x8438, 	/* 0xDDC0 to 0xDDC7 */ 
0x8411, 0x8406, 0x83D4, 0x83DF, 0x840F, 0x8403, 0x83F8, 0x83F9, 	/* 0xDDC8 to 0xDDCF */ 
0x83EA, 0x83C5, 0x83C0, 0x8426, 0x83F0, 0x83E1, 0x845C, 0x8451, 	/* 0xDDD0 to 0xDDD7 */ 
0x845A, 0x8459, 0x8473, 0x8487, 0x8488, 0x847A, 0x8489, 0x8478, 	/* 0xDDD8 to 0xDDDF */ 
0x843C, 0x8446, 0x8469, 0x8476, 0x848C, 0x848E, 0x8431, 0x846D, 	/* 0xDDE0 to 0xDDE7 */ 
0x84C1, 0x84CD, 0x84D0, 0x84E6, 0x84BD, 0x84D3, 0x84CA, 0x84BF, 	/* 0xDDE8 to 0xDDEF */ 
0x84BA, 0x84E0, 0x84A1, 0x84B9, 0x84B4, 0x8497, 0x84E5, 0x84E3, 	/* 0xDDF0 to 0xDDF7 */ 
0x850C, 0x750D, 0x8538, 0x84F0, 0x8539, 0x851F, 0x853A, 0x0000, 	/* 0xDDF8 to 0xDDFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE00 to 0xDE07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE08 to 0xDE0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE10 to 0xDE17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE18 to 0xDE1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE20 to 0xDE27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE28 to 0xDE2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE30 to 0xDE37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE38 to 0xDE3F */ 
0x8F45, 0x8F46, 0x8F47, 0x8F48, 0x8F49, 0x8F4A, 0x8F4B, 0x8F4C, 	/* 0xDE40 to 0xDE47 */ 
0x8F4D, 0x8F4E, 0x8F4F, 0x8F50, 0x8F51, 0x8F52, 0x8F53, 0x8F54, 	/* 0xDE48 to 0xDE4F */ 
0x8F55, 0x8F56, 0x8F57, 0x8F58, 0x8F59, 0x8F5A, 0x8F5B, 0x8F5C, 	/* 0xDE50 to 0xDE57 */ 
0x8F5D, 0x8F5E, 0x8F5F, 0x8F60, 0x8F61, 0x8F62, 0x8F63, 0x8F64, 	/* 0xDE58 to 0xDE5F */ 
0x8F65, 0x8F6A, 0x8F80, 0x8F8C, 0x8F92, 0x8F9D, 0x8FA0, 0x8FA1, 	/* 0xDE60 to 0xDE67 */ 
0x8FA2, 0x8FA4, 0x8FA5, 0x8FA6, 0x8FA7, 0x8FAA, 0x8FAC, 0x8FAD, 	/* 0xDE68 to 0xDE6F */ 
0x8FAE, 0x8FAF, 0x8FB2, 0x8FB3, 0x8FB4, 0x8FB5, 0x8FB7, 0x8FB8, 	/* 0xDE70 to 0xDE77 */ 
0x8FBA, 0x8FBB, 0x8FBC, 0x8FBF, 0x8FC0, 0x8FC3, 0x8FC6, 0x0000, 	/* 0xDE78 to 0xDE7F */ 
0x8FC9, 0x8FCA, 0x8FCB, 0x8FCC, 0x8FCD, 0x8FCF, 0x8FD2, 0x8FD6, 	/* 0xDE80 to 0xDE87 */ 
0x8FD7, 0x8FDA, 0x8FE0, 0x8FE1, 0x8FE3, 0x8FE7, 0x8FEC, 0x8FEF, 	/* 0xDE88 to 0xDE8F */ 
0x8FF1, 0x8FF2, 0x8FF4, 0x8FF5, 0x8FF6, 0x8FFA, 0x8FFB, 0x8FFC, 	/* 0xDE90 to 0xDE97 */ 
0x8FFE, 0x8FFF, 0x9007, 0x9008, 0x900C, 0x900E, 0x9013, 0x9015, 	/* 0xDE98 to 0xDE9F */ 
0x9018, 0x8556, 0x853B, 0x84FF, 0x84FC, 0x8559, 0x8548, 0x8568, 	/* 0xDEA0 to 0xDEA7 */ 
0x8564, 0x855E, 0x857A, 0x77A2, 0x8543, 0x8572, 0x857B, 0x85A4, 	/* 0xDEA8 to 0xDEAF */ 
0x85A8, 0x8587, 0x858F, 0x8579, 0x85AE, 0x859C, 0x8585, 0x85B9, 	/* 0xDEB0 to 0xDEB7 */ 
0x85B7, 0x85B0, 0x85D3, 0x85C1, 0x85DC, 0x85FF, 0x8627, 0x8605, 	/* 0xDEB8 to 0xDEBF */ 
0x8629, 0x8616, 0x863C, 0x5EFE, 0x5F08, 0x593C, 0x5941, 0x8037, 	/* 0xDEC0 to 0xDEC7 */ 
0x5955, 0x595A, 0x5958, 0x530F, 0x5C22, 0x5C25, 0x5C2C, 0x5C34, 	/* 0xDEC8 to 0xDECF */ 
0x624C, 0x626A, 0x629F, 0x62BB, 0x62CA, 0x62DA, 0x62D7, 0x62EE, 	/* 0xDED0 to 0xDED7 */ 
0x6322, 0x62F6, 0x6339, 0x634B, 0x6343, 0x63AD, 0x63F6, 0x6371, 	/* 0xDED8 to 0xDEDF */ 
0x637A, 0x638E, 0x63B4, 0x636D, 0x63AC, 0x638A, 0x6369, 0x63AE, 	/* 0xDEE0 to 0xDEE7 */ 
0x63BC, 0x63F2, 0x63F8, 0x63E0, 0x63FF, 0x63C4, 0x63DE, 0x63CE, 	/* 0xDEE8 to 0xDEEF */ 
0x6452, 0x63C6, 0x63BE, 0x6445, 0x6441, 0x640B, 0x641B, 0x6420, 	/* 0xDEF0 to 0xDEF7 */ 
0x640C, 0x6426, 0x6421, 0x645E, 0x6484, 0x646D, 0x6496, 0x0000, 	/* 0xDEF8 to 0xDEFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF00 to 0xDF07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF08 to 0xDF0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF10 to 0xDF17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF18 to 0xDF1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF20 to 0xDF27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF28 to 0xDF2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF30 to 0xDF37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF38 to 0xDF3F */ 
0x9019, 0x901C, 0x9023, 0x9024, 0x9025, 0x9027, 0x9028, 0x9029, 	/* 0xDF40 to 0xDF47 */ 
0x902A, 0x902B, 0x902C, 0x9030, 0x9031, 0x9032, 0x9033, 0x9034, 	/* 0xDF48 to 0xDF4F */ 
0x9037, 0x9039, 0x903A, 0x903D, 0x903F, 0x9040, 0x9043, 0x9045, 	/* 0xDF50 to 0xDF57 */ 
0x9046, 0x9048, 0x9049, 0x904A, 0x904B, 0x904C, 0x904E, 0x9054, 	/* 0xDF58 to 0xDF5F */ 
0x9055, 0x9056, 0x9059, 0x905A, 0x905C, 0x905D, 0x905E, 0x905F, 	/* 0xDF60 to 0xDF67 */ 
0x9060, 0x9061, 0x9064, 0x9066, 0x9067, 0x9069, 0x906A, 0x906B, 	/* 0xDF68 to 0xDF6F */ 
0x906C, 0x906F, 0x9070, 0x9071, 0x9072, 0x9073, 0x9076, 0x9077, 	/* 0xDF70 to 0xDF77 */ 
0x9078, 0x9079, 0x907A, 0x907B, 0x907C, 0x907E, 0x9081, 0x0000, 	/* 0xDF78 to 0xDF7F */ 
0x9084, 0x9085, 0x9086, 0x9087, 0x9089, 0x908A, 0x908C, 0x908D, 	/* 0xDF80 to 0xDF87 */ 
0x908E, 0x908F, 0x9090, 0x9092, 0x9094, 0x9096, 0x9098, 0x909A, 	/* 0xDF88 to 0xDF8F */ 
0x909C, 0x909E, 0x909F, 0x90A0, 0x90A4, 0x90A5, 0x90A7, 0x90A8, 	/* 0xDF90 to 0xDF97 */ 
0x90A9, 0x90AB, 0x90AD, 0x90B2, 0x90B7, 0x90BC, 0x90BD, 0x90BF, 	/* 0xDF98 to 0xDF9F */ 
0x90C0, 0x647A, 0x64B7, 0x64B8, 0x6499, 0x64BA, 0x64C0, 0x64D0, 	/* 0xDFA0 to 0xDFA7 */ 
0x64D7, 0x64E4, 0x64E2, 0x6509, 0x6525, 0x652E, 0x5F0B, 0x5FD2, 	/* 0xDFA8 to 0xDFAF */ 
0x7519, 0x5F11, 0x535F, 0x53F1, 0x53FD, 0x53E9, 0x53E8, 0x53FB, 	/* 0xDFB0 to 0xDFB7 */ 
0x5412, 0x5416, 0x5406, 0x544B, 0x5452, 0x5453, 0x5454, 0x5456, 	/* 0xDFB8 to 0xDFBF */ 
0x5443, 0x5421, 0x5457, 0x5459, 0x5423, 0x5432, 0x5482, 0x5494, 	/* 0xDFC0 to 0xDFC7 */ 
0x5477, 0x5471, 0x5464, 0x549A, 0x549B, 0x5484, 0x5476, 0x5466, 	/* 0xDFC8 to 0xDFCF */ 
0x549D, 0x54D0, 0x54AD, 0x54C2, 0x54B4, 0x54D2, 0x54A7, 0x54A6, 	/* 0xDFD0 to 0xDFD7 */ 
0x54D3, 0x54D4, 0x5472, 0x54A3, 0x54D5, 0x54BB, 0x54BF, 0x54CC, 	/* 0xDFD8 to 0xDFDF */ 
0x54D9, 0x54DA, 0x54DC, 0x54A9, 0x54AA, 0x54A4, 0x54DD, 0x54CF, 	/* 0xDFE0 to 0xDFE7 */ 
0x54DE, 0x551B, 0x54E7, 0x5520, 0x54FD, 0x5514, 0x54F3, 0x5522, 	/* 0xDFE8 to 0xDFEF */ 
0x5523, 0x550F, 0x5511, 0x5527, 0x552A, 0x5567, 0x558F, 0x55B5, 	/* 0xDFF0 to 0xDFF7 */ 
0x5549, 0x556D, 0x5541, 0x5555, 0x553F, 0x5550, 0x553C, 0x0000, 	/* 0xDFF8 to 0xDFFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE000 to 0xE007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE008 to 0xE00F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE010 to 0xE017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE018 to 0xE01F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE020 to 0xE027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE028 to 0xE02F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE030 to 0xE037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE038 to 0xE03F */ 
0x90C2, 0x90C3, 0x90C6, 0x90C8, 0x90C9, 0x90CB, 0x90CC, 0x90CD, 	/* 0xE040 to 0xE047 */ 
0x90D2, 0x90D4, 0x90D5, 0x90D6, 0x90D8, 0x90D9, 0x90DA, 0x90DE, 	/* 0xE048 to 0xE04F */ 
0x90DF, 0x90E0, 0x90E3, 0x90E4, 0x90E5, 0x90E9, 0x90EA, 0x90EC, 	/* 0xE050 to 0xE057 */ 
0x90EE, 0x90F0, 0x90F1, 0x90F2, 0x90F3, 0x90F5, 0x90F6, 0x90F7, 	/* 0xE058 to 0xE05F */ 
0x90F9, 0x90FA, 0x90FB, 0x90FC, 0x90FF, 0x9100, 0x9101, 0x9103, 	/* 0xE060 to 0xE067 */ 
0x9105, 0x9106, 0x9107, 0x9108, 0x9109, 0x910A, 0x910B, 0x910C, 	/* 0xE068 to 0xE06F */ 
0x910D, 0x910E, 0x910F, 0x9110, 0x9111, 0x9112, 0x9113, 0x9114, 	/* 0xE070 to 0xE077 */ 
0x9115, 0x9116, 0x9117, 0x9118, 0x911A, 0x911B, 0x911C, 0x0000, 	/* 0xE078 to 0xE07F */ 
0x911D, 0x911F, 0x9120, 0x9121, 0x9124, 0x9125, 0x9126, 0x9127, 	/* 0xE080 to 0xE087 */ 
0x9128, 0x9129, 0x912A, 0x912B, 0x912C, 0x912D, 0x912E, 0x9130, 	/* 0xE088 to 0xE08F */ 
0x9132, 0x9133, 0x9134, 0x9135, 0x9136, 0x9137, 0x9138, 0x913A, 	/* 0xE090 to 0xE097 */ 
0x913B, 0x913C, 0x913D, 0x913E, 0x913F, 0x9140, 0x9141, 0x9142, 	/* 0xE098 to 0xE09F */ 
0x9144, 0x5537, 0x5556, 0x5575, 0x5576, 0x5577, 0x5533, 0x5530, 	/* 0xE0A0 to 0xE0A7 */ 
0x555C, 0x558B, 0x55D2, 0x5583, 0x55B1, 0x55B9, 0x5588, 0x5581, 	/* 0xE0A8 to 0xE0AF */ 
0x559F, 0x557E, 0x55D6, 0x5591, 0x557B, 0x55DF, 0x55BD, 0x55BE, 	/* 0xE0B0 to 0xE0B7 */ 
0x5594, 0x5599, 0x55EA, 0x55F7, 0x55C9, 0x561F, 0x55D1, 0x55EB, 	/* 0xE0B8 to 0xE0BF */ 
0x55EC, 0x55D4, 0x55E6, 0x55DD, 0x55C4, 0x55EF, 0x55E5, 0x55F2, 	/* 0xE0C0 to 0xE0C7 */ 
0x55F3, 0x55CC, 0x55CD, 0x55E8, 0x55F5, 0x55E4, 0x8F94, 0x561E, 	/* 0xE0C8 to 0xE0CF */ 
0x5608, 0x560C, 0x5601, 0x5624, 0x5623, 0x55FE, 0x5600, 0x5627, 	/* 0xE0D0 to 0xE0D7 */ 
0x562D, 0x5658, 0x5639, 0x5657, 0x562C, 0x564D, 0x5662, 0x5659, 	/* 0xE0D8 to 0xE0DF */ 
0x565C, 0x564C, 0x5654, 0x5686, 0x5664, 0x5671, 0x566B, 0x567B, 	/* 0xE0E0 to 0xE0E7 */ 
0x567C, 0x5685, 0x5693, 0x56AF, 0x56D4, 0x56D7, 0x56DD, 0x56E1, 	/* 0xE0E8 to 0xE0EF */ 
0x56F5, 0x56EB, 0x56F9, 0x56FF, 0x5704, 0x570A, 0x5709, 0x571C, 	/* 0xE0F0 to 0xE0F7 */ 
0x5E0F, 0x5E19, 0x5E14, 0x5E11, 0x5E31, 0x5E3B, 0x5E3C, 0x0000, 	/* 0xE0F8 to 0xE0FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE100 to 0xE107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE108 to 0xE10F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE110 to 0xE117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE118 to 0xE11F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE120 to 0xE127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE128 to 0xE12F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE130 to 0xE137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE138 to 0xE13F */ 
0x9145, 0x9147, 0x9148, 0x9151, 0x9153, 0x9154, 0x9155, 0x9156, 	/* 0xE140 to 0xE147 */ 
0x9158, 0x9159, 0x915B, 0x915C, 0x915F, 0x9160, 0x9166, 0x9167, 	/* 0xE148 to 0xE14F */ 
0x9168, 0x916B, 0x916D, 0x9173, 0x917A, 0x917B, 0x917C, 0x9180, 	/* 0xE150 to 0xE157 */ 
0x9181, 0x9182, 0x9183, 0x9184, 0x9186, 0x9188, 0x918A, 0x918E, 	/* 0xE158 to 0xE15F */ 
0x918F, 0x9193, 0x9194, 0x9195, 0x9196, 0x9197, 0x9198, 0x9199, 	/* 0xE160 to 0xE167 */ 
0x919C, 0x919D, 0x919E, 0x919F, 0x91A0, 0x91A1, 0x91A4, 0x91A5, 	/* 0xE168 to 0xE16F */ 
0x91A6, 0x91A7, 0x91A8, 0x91A9, 0x91AB, 0x91AC, 0x91B0, 0x91B1, 	/* 0xE170 to 0xE177 */ 
0x91B2, 0x91B3, 0x91B6, 0x91B7, 0x91B8, 0x91B9, 0x91BB, 0x0000, 	/* 0xE178 to 0xE17F */ 
0x91BC, 0x91BD, 0x91BE, 0x91BF, 0x91C0, 0x91C1, 0x91C2, 0x91C3, 	/* 0xE180 to 0xE187 */ 
0x91C4, 0x91C5, 0x91C6, 0x91C8, 0x91CB, 0x91D0, 0x91D2, 0x91D3, 	/* 0xE188 to 0xE18F */ 
0x91D4, 0x91D5, 0x91D6, 0x91D7, 0x91D8, 0x91D9, 0x91DA, 0x91DB, 	/* 0xE190 to 0xE197 */ 
0x91DD, 0x91DE, 0x91DF, 0x91E0, 0x91E1, 0x91E2, 0x91E3, 0x91E4, 	/* 0xE198 to 0xE19F */ 
0x91E5, 0x5E37, 0x5E44, 0x5E54, 0x5E5B, 0x5E5E, 0x5E61, 0x5C8C, 	/* 0xE1A0 to 0xE1A7 */ 
0x5C7A, 0x5C8D, 0x5C90, 0x5C96, 0x5C88, 0x5C98, 0x5C99, 0x5C91, 	/* 0xE1A8 to 0xE1AF */ 
0x5C9A, 0x5C9C, 0x5CB5, 0x5CA2, 0x5CBD, 0x5CAC, 0x5CAB, 0x5CB1, 	/* 0xE1B0 to 0xE1B7 */ 
0x5CA3, 0x5CC1, 0x5CB7, 0x5CC4, 0x5CD2, 0x5CE4, 0x5CCB, 0x5CE5, 	/* 0xE1B8 to 0xE1BF */ 
0x5D02, 0x5D03, 0x5D27, 0x5D26, 0x5D2E, 0x5D24, 0x5D1E, 0x5D06, 	/* 0xE1C0 to 0xE1C7 */ 
0x5D1B, 0x5D58, 0x5D3E, 0x5D34, 0x5D3D, 0x5D6C, 0x5D5B, 0x5D6F, 	/* 0xE1C8 to 0xE1CF */ 
0x5D5D, 0x5D6B, 0x5D4B, 0x5D4A, 0x5D69, 0x5D74, 0x5D82, 0x5D99, 	/* 0xE1D0 to 0xE1D7 */ 
0x5D9D, 0x8C73, 0x5DB7, 0x5DC5, 0x5F73, 0x5F77, 0x5F82, 0x5F87, 	/* 0xE1D8 to 0xE1DF */ 
0x5F89, 0x5F8C, 0x5F95, 0x5F99, 0x5F9C, 0x5FA8, 0x5FAD, 0x5FB5, 	/* 0xE1E0 to 0xE1E7 */ 
0x5FBC, 0x8862, 0x5F61, 0x72AD, 0x72B0, 0x72B4, 0x72B7, 0x72B8, 	/* 0xE1E8 to 0xE1EF */ 
0x72C3, 0x72C1, 0x72CE, 0x72CD, 0x72D2, 0x72E8, 0x72EF, 0x72E9, 	/* 0xE1F0 to 0xE1F7 */ 
0x72F2, 0x72F4, 0x72F7, 0x7301, 0x72F3, 0x7303, 0x72FA, 0x0000, 	/* 0xE1F8 to 0xE1FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE200 to 0xE207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE208 to 0xE20F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE210 to 0xE217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE218 to 0xE21F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE220 to 0xE227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE228 to 0xE22F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE230 to 0xE237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE238 to 0xE23F */ 
0x91E6, 0x91E7, 0x91E8, 0x91E9, 0x91EA, 0x91EB, 0x91EC, 0x91ED, 	/* 0xE240 to 0xE247 */ 
0x91EE, 0x91EF, 0x91F0, 0x91F1, 0x91F2, 0x91F3, 0x91F4, 0x91F5, 	/* 0xE248 to 0xE24F */ 
0x91F6, 0x91F7, 0x91F8, 0x91F9, 0x91FA, 0x91FB, 0x91FC, 0x91FD, 	/* 0xE250 to 0xE257 */ 
0x91FE, 0x91FF, 0x9200, 0x9201, 0x9202, 0x9203, 0x9204, 0x9205, 	/* 0xE258 to 0xE25F */ 
0x9206, 0x9207, 0x9208, 0x9209, 0x920A, 0x920B, 0x920C, 0x920D, 	/* 0xE260 to 0xE267 */ 
0x920E, 0x920F, 0x9210, 0x9211, 0x9212, 0x9213, 0x9214, 0x9215, 	/* 0xE268 to 0xE26F */ 
0x9216, 0x9217, 0x9218, 0x9219, 0x921A, 0x921B, 0x921C, 0x921D, 	/* 0xE270 to 0xE277 */ 
0x921E, 0x921F, 0x9220, 0x9221, 0x9222, 0x9223, 0x9224, 0x0000, 	/* 0xE278 to 0xE27F */ 
0x9225, 0x9226, 0x9227, 0x9228, 0x9229, 0x922A, 0x922B, 0x922C, 	/* 0xE280 to 0xE287 */ 
0x922D, 0x922E, 0x922F, 0x9230, 0x9231, 0x9232, 0x9233, 0x9234, 	/* 0xE288 to 0xE28F */ 
0x9235, 0x9236, 0x9237, 0x9238, 0x9239, 0x923A, 0x923B, 0x923C, 	/* 0xE290 to 0xE297 */ 
0x923D, 0x923E, 0x923F, 0x9240, 0x9241, 0x9242, 0x9243, 0x9244, 	/* 0xE298 to 0xE29F */ 
0x9245, 0x72FB, 0x7317, 0x7313, 0x7321, 0x730A, 0x731E, 0x731D, 	/* 0xE2A0 to 0xE2A7 */ 
0x7315, 0x7322, 0x7339, 0x7325, 0x732C, 0x7338, 0x7331, 0x7350, 	/* 0xE2A8 to 0xE2AF */ 
0x734D, 0x7357, 0x7360, 0x736C, 0x736F, 0x737E, 0x821B, 0x5925, 	/* 0xE2B0 to 0xE2B7 */ 
0x98E7, 0x5924, 0x5902, 0x9963, 0x9967, 0x9968, 0x9969, 0x996A, 	/* 0xE2B8 to 0xE2BF */ 
0x996B, 0x996C, 0x9974, 0x9977, 0x997D, 0x9980, 0x9984, 0x9987, 	/* 0xE2C0 to 0xE2C7 */ 
0x998A, 0x998D, 0x9990, 0x9991, 0x9993, 0x9994, 0x9995, 0x5E80, 	/* 0xE2C8 to 0xE2CF */ 
0x5E91, 0x5E8B, 0x5E96, 0x5EA5, 0x5EA0, 0x5EB9, 0x5EB5, 0x5EBE, 	/* 0xE2D0 to 0xE2D7 */ 
0x5EB3, 0x8D53, 0x5ED2, 0x5ED1, 0x5EDB, 0x5EE8, 0x5EEA, 0x81BA, 	/* 0xE2D8 to 0xE2DF */ 
0x5FC4, 0x5FC9, 0x5FD6, 0x5FCF, 0x6003, 0x5FEE, 0x6004, 0x5FE1, 	/* 0xE2E0 to 0xE2E7 */ 
0x5FE4, 0x5FFE, 0x6005, 0x6006, 0x5FEA, 0x5FED, 0x5FF8, 0x6019, 	/* 0xE2E8 to 0xE2EF */ 
0x6035, 0x6026, 0x601B, 0x600F, 0x600D, 0x6029, 0x602B, 0x600A, 	/* 0xE2F0 to 0xE2F7 */ 
0x603F, 0x6021, 0x6078, 0x6079, 0x607B, 0x607A, 0x6042, 0x0000, 	/* 0xE2F8 to 0xE2FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE300 to 0xE307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE308 to 0xE30F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE310 to 0xE317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE318 to 0xE31F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE320 to 0xE327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE328 to 0xE32F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE330 to 0xE337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE338 to 0xE33F */ 
0x9246, 0x9247, 0x9248, 0x9249, 0x924A, 0x924B, 0x924C, 0x924D, 	/* 0xE340 to 0xE347 */ 
0x924E, 0x924F, 0x9250, 0x9251, 0x9252, 0x9253, 0x9254, 0x9255, 	/* 0xE348 to 0xE34F */ 
0x9256, 0x9257, 0x9258, 0x9259, 0x925A, 0x925B, 0x925C, 0x925D, 	/* 0xE350 to 0xE357 */ 
0x925E, 0x925F, 0x9260, 0x9261, 0x9262, 0x9263, 0x9264, 0x9265, 	/* 0xE358 to 0xE35F */ 
0x9266, 0x9267, 0x9268, 0x9269, 0x926A, 0x926B, 0x926C, 0x926D, 	/* 0xE360 to 0xE367 */ 
0x926E, 0x926F, 0x9270, 0x9271, 0x9272, 0x9273, 0x9275, 0x9276, 	/* 0xE368 to 0xE36F */ 
0x9277, 0x9278, 0x9279, 0x927A, 0x927B, 0x927C, 0x927D, 0x927E, 	/* 0xE370 to 0xE377 */ 
0x927F, 0x9280, 0x9281, 0x9282, 0x9283, 0x9284, 0x9285, 0x0000, 	/* 0xE378 to 0xE37F */ 
0x9286, 0x9287, 0x9288, 0x9289, 0x928A, 0x928B, 0x928C, 0x928D, 	/* 0xE380 to 0xE387 */ 
0x928F, 0x9290, 0x9291, 0x9292, 0x9293, 0x9294, 0x9295, 0x9296, 	/* 0xE388 to 0xE38F */ 
0x9297, 0x9298, 0x9299, 0x929A, 0x929B, 0x929C, 0x929D, 0x929E, 	/* 0xE390 to 0xE397 */ 
0x929F, 0x92A0, 0x92A1, 0x92A2, 0x92A3, 0x92A4, 0x92A5, 0x92A6, 	/* 0xE398 to 0xE39F */ 
0x92A7, 0x606A, 0x607D, 0x6096, 0x609A, 0x60AD, 0x609D, 0x6083, 	/* 0xE3A0 to 0xE3A7 */ 
0x6092, 0x608C, 0x609B, 0x60EC, 0x60BB, 0x60B1, 0x60DD, 0x60D8, 	/* 0xE3A8 to 0xE3AF */ 
0x60C6, 0x60DA, 0x60B4, 0x6120, 0x6126, 0x6115, 0x6123, 0x60F4, 	/* 0xE3B0 to 0xE3B7 */ 
0x6100, 0x610E, 0x612B, 0x614A, 0x6175, 0x61AC, 0x6194, 0x61A7, 	/* 0xE3B8 to 0xE3BF */ 
0x61B7, 0x61D4, 0x61F5, 0x5FDD, 0x96B3, 0x95E9, 0x95EB, 0x95F1, 	/* 0xE3C0 to 0xE3C7 */ 
0x95F3, 0x95F5, 0x95F6, 0x95FC, 0x95FE, 0x9603, 0x9604, 0x9606, 	/* 0xE3C8 to 0xE3CF */ 
0x9608, 0x960A, 0x960B, 0x960C, 0x960D, 0x960F, 0x9612, 0x9615, 	/* 0xE3D0 to 0xE3D7 */ 
0x9616, 0x9617, 0x9619, 0x961A, 0x4E2C, 0x723F, 0x6215, 0x6C35, 	/* 0xE3D8 to 0xE3DF */ 
0x6C54, 0x6C5C, 0x6C4A, 0x6CA3, 0x6C85, 0x6C90, 0x6C94, 0x6C8C, 	/* 0xE3E0 to 0xE3E7 */ 
0x6C68, 0x6C69, 0x6C74, 0x6C76, 0x6C86, 0x6CA9, 0x6CD0, 0x6CD4, 	/* 0xE3E8 to 0xE3EF */ 
0x6CAD, 0x6CF7, 0x6CF8, 0x6CF1, 0x6CD7, 0x6CB2, 0x6CE0, 0x6CD6, 	/* 0xE3F0 to 0xE3F7 */ 
0x6CFA, 0x6CEB, 0x6CEE, 0x6CB1, 0x6CD3, 0x6CEF, 0x6CFE, 0x0000, 	/* 0xE3F8 to 0xE3FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE400 to 0xE407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE408 to 0xE40F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE410 to 0xE417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE418 to 0xE41F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE420 to 0xE427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE428 to 0xE42F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE430 to 0xE437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE438 to 0xE43F */ 
0x92A8, 0x92A9, 0x92AA, 0x92AB, 0x92AC, 0x92AD, 0x92AF, 0x92B0, 	/* 0xE440 to 0xE447 */ 
0x92B1, 0x92B2, 0x92B3, 0x92B4, 0x92B5, 0x92B6, 0x92B7, 0x92B8, 	/* 0xE448 to 0xE44F */ 
0x92B9, 0x92BA, 0x92BB, 0x92BC, 0x92BD, 0x92BE, 0x92BF, 0x92C0, 	/* 0xE450 to 0xE457 */ 
0x92C1, 0x92C2, 0x92C3, 0x92C4, 0x92C5, 0x92C6, 0x92C7, 0x92C9, 	/* 0xE458 to 0xE45F */ 
0x92CA, 0x92CB, 0x92CC, 0x92CD, 0x92CE, 0x92CF, 0x92D0, 0x92D1, 	/* 0xE460 to 0xE467 */ 
0x92D2, 0x92D3, 0x92D4, 0x92D5, 0x92D6, 0x92D7, 0x92D8, 0x92D9, 	/* 0xE468 to 0xE46F */ 
0x92DA, 0x92DB, 0x92DC, 0x92DD, 0x92DE, 0x92DF, 0x92E0, 0x92E1, 	/* 0xE470 to 0xE477 */ 
0x92E2, 0x92E3, 0x92E4, 0x92E5, 0x92E6, 0x92E7, 0x92E8, 0x0000, 	/* 0xE478 to 0xE47F */ 
0x92E9, 0x92EA, 0x92EB, 0x92EC, 0x92ED, 0x92EE, 0x92EF, 0x92F0, 	/* 0xE480 to 0xE487 */ 
0x92F1, 0x92F2, 0x92F3, 0x92F4, 0x92F5, 0x92F6, 0x92F7, 0x92F8, 	/* 0xE488 to 0xE48F */ 
0x92F9, 0x92FA, 0x92FB, 0x92FC, 0x92FD, 0x92FE, 0x92FF, 0x9300, 	/* 0xE490 to 0xE497 */ 
0x9301, 0x9302, 0x9303, 0x9304, 0x9305, 0x9306, 0x9307, 0x9308, 	/* 0xE498 to 0xE49F */ 
0x9309, 0x6D39, 0x6D27, 0x6D0C, 0x6D43, 0x6D48, 0x6D07, 0x6D04, 	/* 0xE4A0 to 0xE4A7 */ 
0x6D19, 0x6D0E, 0x6D2B, 0x6D4D, 0x6D2E, 0x6D35, 0x6D1A, 0x6D4F, 	/* 0xE4A8 to 0xE4AF */ 
0x6D52, 0x6D54, 0x6D33, 0x6D91, 0x6D6F, 0x6D9E, 0x6DA0, 0x6D5E, 	/* 0xE4B0 to 0xE4B7 */ 
0x6D93, 0x6D94, 0x6D5C, 0x6D60, 0x6D7C, 0x6D63, 0x6E1A, 0x6DC7, 	/* 0xE4B8 to 0xE4BF */ 
0x6DC5, 0x6DDE, 0x6E0E, 0x6DBF, 0x6DE0, 0x6E11, 0x6DE6, 0x6DDD, 	/* 0xE4C0 to 0xE4C7 */ 
0x6DD9, 0x6E16, 0x6DAB, 0x6E0C, 0x6DAE, 0x6E2B, 0x6E6E, 0x6E4E, 	/* 0xE4C8 to 0xE4CF */ 
0x6E6B, 0x6EB2, 0x6E5F, 0x6E86, 0x6E53, 0x6E54, 0x6E32, 0x6E25, 	/* 0xE4D0 to 0xE4D7 */ 
0x6E44, 0x6EDF, 0x6EB1, 0x6E98, 0x6EE0, 0x6F2D, 0x6EE2, 0x6EA5, 	/* 0xE4D8 to 0xE4DF */ 
0x6EA7, 0x6EBD, 0x6EBB, 0x6EB7, 0x6ED7, 0x6EB4, 0x6ECF, 0x6E8F, 	/* 0xE4E0 to 0xE4E7 */ 
0x6EC2, 0x6E9F, 0x6F62, 0x6F46, 0x6F47, 0x6F24, 0x6F15, 0x6EF9, 	/* 0xE4E8 to 0xE4EF */ 
0x6F2F, 0x6F36, 0x6F4B, 0x6F74, 0x6F2A, 0x6F09, 0x6F29, 0x6F89, 	/* 0xE4F0 to 0xE4F7 */ 
0x6F8D, 0x6F8C, 0x6F78, 0x6F72, 0x6F7C, 0x6F7A, 0x6FD1, 0x0000, 	/* 0xE4F8 to 0xE4FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE500 to 0xE507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE508 to 0xE50F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE510 to 0xE517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE518 to 0xE51F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE520 to 0xE527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE528 to 0xE52F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE530 to 0xE537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE538 to 0xE53F */ 
0x930A, 0x930B, 0x930C, 0x930D, 0x930E, 0x930F, 0x9310, 0x9311, 	/* 0xE540 to 0xE547 */ 
0x9312, 0x9313, 0x9314, 0x9315, 0x9316, 0x9317, 0x9318, 0x9319, 	/* 0xE548 to 0xE54F */ 
0x931A, 0x931B, 0x931C, 0x931D, 0x931E, 0x931F, 0x9320, 0x9321, 	/* 0xE550 to 0xE557 */ 
0x9322, 0x9323, 0x9324, 0x9325, 0x9326, 0x9327, 0x9328, 0x9329, 	/* 0xE558 to 0xE55F */ 
0x932A, 0x932B, 0x932C, 0x932D, 0x932E, 0x932F, 0x9330, 0x9331, 	/* 0xE560 to 0xE567 */ 
0x9332, 0x9333, 0x9334, 0x9335, 0x9336, 0x9337, 0x9338, 0x9339, 	/* 0xE568 to 0xE56F */ 
0x933A, 0x933B, 0x933C, 0x933D, 0x933F, 0x9340, 0x9341, 0x9342, 	/* 0xE570 to 0xE577 */ 
0x9343, 0x9344, 0x9345, 0x9346, 0x9347, 0x9348, 0x9349, 0x0000, 	/* 0xE578 to 0xE57F */ 
0x934A, 0x934B, 0x934C, 0x934D, 0x934E, 0x934F, 0x9350, 0x9351, 	/* 0xE580 to 0xE587 */ 
0x9352, 0x9353, 0x9354, 0x9355, 0x9356, 0x9357, 0x9358, 0x9359, 	/* 0xE588 to 0xE58F */ 
0x935A, 0x935B, 0x935C, 0x935D, 0x935E, 0x935F, 0x9360, 0x9361, 	/* 0xE590 to 0xE597 */ 
0x9362, 0x9363, 0x9364, 0x9365, 0x9366, 0x9367, 0x9368, 0x9369, 	/* 0xE598 to 0xE59F */ 
0x936B, 0x6FC9, 0x6FA7, 0x6FB9, 0x6FB6, 0x6FC2, 0x6FE1, 0x6FEE, 	/* 0xE5A0 to 0xE5A7 */ 
0x6FDE, 0x6FE0, 0x6FEF, 0x701A, 0x7023, 0x701B, 0x7039, 0x7035, 	/* 0xE5A8 to 0xE5AF */ 
0x704F, 0x705E, 0x5B80, 0x5B84, 0x5B95, 0x5B93, 0x5BA5, 0x5BB8, 	/* 0xE5B0 to 0xE5B7 */ 
0x752F, 0x9A9E, 0x6434, 0x5BE4, 0x5BEE, 0x8930, 0x5BF0, 0x8E47, 	/* 0xE5B8 to 0xE5BF */ 
0x8B07, 0x8FB6, 0x8FD3, 0x8FD5, 0x8FE5, 0x8FEE, 0x8FE4, 0x8FE9, 	/* 0xE5C0 to 0xE5C7 */ 
0x8FE6, 0x8FF3, 0x8FE8, 0x9005, 0x9004, 0x900B, 0x9026, 0x9011, 	/* 0xE5C8 to 0xE5CF */ 
0x900D, 0x9016, 0x9021, 0x9035, 0x9036, 0x902D, 0x902F, 0x9044, 	/* 0xE5D0 to 0xE5D7 */ 
0x9051, 0x9052, 0x9050, 0x9068, 0x9058, 0x9062, 0x905B, 0x66B9, 	/* 0xE5D8 to 0xE5DF */ 
0x9074, 0x907D, 0x9082, 0x9088, 0x9083, 0x908B, 0x5F50, 0x5F57, 	/* 0xE5E0 to 0xE5E7 */ 
0x5F56, 0x5F58, 0x5C3B, 0x54AB, 0x5C50, 0x5C59, 0x5B71, 0x5C63, 	/* 0xE5E8 to 0xE5EF */ 
0x5C66, 0x7FBC, 0x5F2A, 0x5F29, 0x5F2D, 0x8274, 0x5F3C, 0x9B3B, 	/* 0xE5F0 to 0xE5F7 */ 
0x5C6E, 0x5981, 0x5983, 0x598D, 0x59A9, 0x59AA, 0x59A3, 0x0000, 	/* 0xE5F8 to 0xE5FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE600 to 0xE607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE608 to 0xE60F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE610 to 0xE617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE618 to 0xE61F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE620 to 0xE627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE628 to 0xE62F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE630 to 0xE637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE638 to 0xE63F */ 
0x936C, 0x936D, 0x936E, 0x936F, 0x9370, 0x9371, 0x9372, 0x9373, 	/* 0xE640 to 0xE647 */ 
0x9374, 0x9375, 0x9376, 0x9377, 0x9378, 0x9379, 0x937A, 0x937B, 	/* 0xE648 to 0xE64F */ 
0x937C, 0x937D, 0x937E, 0x937F, 0x9380, 0x9381, 0x9382, 0x9383, 	/* 0xE650 to 0xE657 */ 
0x9384, 0x9385, 0x9386, 0x9387, 0x9388, 0x9389, 0x938A, 0x938B, 	/* 0xE658 to 0xE65F */ 
0x938C, 0x938D, 0x938E, 0x9390, 0x9391, 0x9392, 0x9393, 0x9394, 	/* 0xE660 to 0xE667 */ 
0x9395, 0x9396, 0x9397, 0x9398, 0x9399, 0x939A, 0x939B, 0x939C, 	/* 0xE668 to 0xE66F */ 
0x939D, 0x939E, 0x939F, 0x93A0, 0x93A1, 0x93A2, 0x93A3, 0x93A4, 	/* 0xE670 to 0xE677 */ 
0x93A5, 0x93A6, 0x93A7, 0x93A8, 0x93A9, 0x93AA, 0x93AB, 0x0000, 	/* 0xE678 to 0xE67F */ 
0x93AC, 0x93AD, 0x93AE, 0x93AF, 0x93B0, 0x93B1, 0x93B2, 0x93B3, 	/* 0xE680 to 0xE687 */ 
0x93B4, 0x93B5, 0x93B6, 0x93B7, 0x93B8, 0x93B9, 0x93BA, 0x93BB, 	/* 0xE688 to 0xE68F */ 
0x93BC, 0x93BD, 0x93BE, 0x93BF, 0x93C0, 0x93C1, 0x93C2, 0x93C3, 	/* 0xE690 to 0xE697 */ 
0x93C4, 0x93C5, 0x93C6, 0x93C7, 0x93C8, 0x93C9, 0x93CB, 0x93CC, 	/* 0xE698 to 0xE69F */ 
0x93CD, 0x5997, 0x59CA, 0x59AB, 0x599E, 0x59A4, 0x59D2, 0x59B2, 	/* 0xE6A0 to 0xE6A7 */ 
0x59AF, 0x59D7, 0x59BE, 0x5A05, 0x5A06, 0x59DD, 0x5A08, 0x59E3, 	/* 0xE6A8 to 0xE6AF */ 
0x59D8, 0x59F9, 0x5A0C, 0x5A09, 0x5A32, 0x5A34, 0x5A11, 0x5A23, 	/* 0xE6B0 to 0xE6B7 */ 
0x5A13, 0x5A40, 0x5A67, 0x5A4A, 0x5A55, 0x5A3C, 0x5A62, 0x5A75, 	/* 0xE6B8 to 0xE6BF */ 
0x80EC, 0x5AAA, 0x5A9B, 0x5A77, 0x5A7A, 0x5ABE, 0x5AEB, 0x5AB2, 	/* 0xE6C0 to 0xE6C7 */ 
0x5AD2, 0x5AD4, 0x5AB8, 0x5AE0, 0x5AE3, 0x5AF1, 0x5AD6, 0x5AE6, 	/* 0xE6C8 to 0xE6CF */ 
0x5AD8, 0x5ADC, 0x5B09, 0x5B17, 0x5B16, 0x5B32, 0x5B37, 0x5B40, 	/* 0xE6D0 to 0xE6D7 */ 
0x5C15, 0x5C1C, 0x5B5A, 0x5B65, 0x5B73, 0x5B51, 0x5B53, 0x5B62, 	/* 0xE6D8 to 0xE6DF */ 
0x9A75, 0x9A77, 0x9A78, 0x9A7A, 0x9A7F, 0x9A7D, 0x9A80, 0x9A81, 	/* 0xE6E0 to 0xE6E7 */ 
0x9A85, 0x9A88, 0x9A8A, 0x9A90, 0x9A92, 0x9A93, 0x9A96, 0x9A98, 	/* 0xE6E8 to 0xE6EF */ 
0x9A9B, 0x9A9C, 0x9A9D, 0x9A9F, 0x9AA0, 0x9AA2, 0x9AA3, 0x9AA5, 	/* 0xE6F0 to 0xE6F7 */ 
0x9AA7, 0x7E9F, 0x7EA1, 0x7EA3, 0x7EA5, 0x7EA8, 0x7EA9, 0x0000, 	/* 0xE6F8 to 0xE6FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE700 to 0xE707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE708 to 0xE70F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE710 to 0xE717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE718 to 0xE71F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE720 to 0xE727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE728 to 0xE72F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE730 to 0xE737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE738 to 0xE73F */ 
0x93CE, 0x93CF, 0x93D0, 0x93D1, 0x93D2, 0x93D3, 0x93D4, 0x93D5, 	/* 0xE740 to 0xE747 */ 
0x93D7, 0x93D8, 0x93D9, 0x93DA, 0x93DB, 0x93DC, 0x93DD, 0x93DE, 	/* 0xE748 to 0xE74F */ 
0x93DF, 0x93E0, 0x93E1, 0x93E2, 0x93E3, 0x93E4, 0x93E5, 0x93E6, 	/* 0xE750 to 0xE757 */ 
0x93E7, 0x93E8, 0x93E9, 0x93EA, 0x93EB, 0x93EC, 0x93ED, 0x93EE, 	/* 0xE758 to 0xE75F */ 
0x93EF, 0x93F0, 0x93F1, 0x93F2, 0x93F3, 0x93F4, 0x93F5, 0x93F6, 	/* 0xE760 to 0xE767 */ 
0x93F7, 0x93F8, 0x93F9, 0x93FA, 0x93FB, 0x93FC, 0x93FD, 0x93FE, 	/* 0xE768 to 0xE76F */ 
0x93FF, 0x9400, 0x9401, 0x9402, 0x9403, 0x9404, 0x9405, 0x9406, 	/* 0xE770 to 0xE777 */ 
0x9407, 0x9408, 0x9409, 0x940A, 0x940B, 0x940C, 0x940D, 0x0000, 	/* 0xE778 to 0xE77F */ 
0x940E, 0x940F, 0x9410, 0x9411, 0x9412, 0x9413, 0x9414, 0x9415, 	/* 0xE780 to 0xE787 */ 
0x9416, 0x9417, 0x9418, 0x9419, 0x941A, 0x941B, 0x941C, 0x941D, 	/* 0xE788 to 0xE78F */ 
0x941E, 0x941F, 0x9420, 0x9421, 0x9422, 0x9423, 0x9424, 0x9425, 	/* 0xE790 to 0xE797 */ 
0x9426, 0x9427, 0x9428, 0x9429, 0x942A, 0x942B, 0x942C, 0x942D, 	/* 0xE798 to 0xE79F */ 
0x942E, 0x7EAD, 0x7EB0, 0x7EBE, 0x7EC0, 0x7EC1, 0x7EC2, 0x7EC9, 	/* 0xE7A0 to 0xE7A7 */ 
0x7ECB, 0x7ECC, 0x7ED0, 0x7ED4, 0x7ED7, 0x7EDB, 0x7EE0, 0x7EE1, 	/* 0xE7A8 to 0xE7AF */ 
0x7EE8, 0x7EEB, 0x7EEE, 0x7EEF, 0x7EF1, 0x7EF2, 0x7F0D, 0x7EF6, 	/* 0xE7B0 to 0xE7B7 */ 
0x7EFA, 0x7EFB, 0x7EFE, 0x7F01, 0x7F02, 0x7F03, 0x7F07, 0x7F08, 	/* 0xE7B8 to 0xE7BF */ 
0x7F0B, 0x7F0C, 0x7F0F, 0x7F11, 0x7F12, 0x7F17, 0x7F19, 0x7F1C, 	/* 0xE7C0 to 0xE7C7 */ 
0x7F1B, 0x7F1F, 0x7F21, 0x7F22, 0x7F23, 0x7F24, 0x7F25, 0x7F26, 	/* 0xE7C8 to 0xE7CF */ 
0x7F27, 0x7F2A, 0x7F2B, 0x7F2C, 0x7F2D, 0x7F2F, 0x7F30, 0x7F31, 	/* 0xE7D0 to 0xE7D7 */ 
0x7F32, 0x7F33, 0x7F35, 0x5E7A, 0x757F, 0x5DDB, 0x753E, 0x9095, 	/* 0xE7D8 to 0xE7DF */ 
0x738E, 0x7391, 0x73AE, 0x73A2, 0x739F, 0x73CF, 0x73C2, 0x73D1, 	/* 0xE7E0 to 0xE7E7 */ 
0x73B7, 0x73B3, 0x73C0, 0x73C9, 0x73C8, 0x73E5, 0x73D9, 0x987C, 	/* 0xE7E8 to 0xE7EF */ 
0x740A, 0x73E9, 0x73E7, 0x73DE, 0x73BA, 0x73F2, 0x740F, 0x742A, 	/* 0xE7F0 to 0xE7F7 */ 
0x745B, 0x7426, 0x7425, 0x7428, 0x7430, 0x742E, 0x742C, 0x0000, 	/* 0xE7F8 to 0xE7FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE800 to 0xE807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE808 to 0xE80F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE810 to 0xE817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE818 to 0xE81F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE820 to 0xE827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE828 to 0xE82F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE830 to 0xE837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE838 to 0xE83F */ 
0x942F, 0x9430, 0x9431, 0x9432, 0x9433, 0x9434, 0x9435, 0x9436, 	/* 0xE840 to 0xE847 */ 
0x9437, 0x9438, 0x9439, 0x943A, 0x943B, 0x943C, 0x943D, 0x943F, 	/* 0xE848 to 0xE84F */ 
0x9440, 0x9441, 0x9442, 0x9443, 0x9444, 0x9445, 0x9446, 0x9447, 	/* 0xE850 to 0xE857 */ 
0x9448, 0x9449, 0x944A, 0x944B, 0x944C, 0x944D, 0x944E, 0x944F, 	/* 0xE858 to 0xE85F */ 
0x9450, 0x9451, 0x9452, 0x9453, 0x9454, 0x9455, 0x9456, 0x9457, 	/* 0xE860 to 0xE867 */ 
0x9458, 0x9459, 0x945A, 0x945B, 0x945C, 0x945D, 0x945E, 0x945F, 	/* 0xE868 to 0xE86F */ 
0x9460, 0x9461, 0x9462, 0x9463, 0x9464, 0x9465, 0x9466, 0x9467, 	/* 0xE870 to 0xE877 */ 
0x9468, 0x9469, 0x946A, 0x946C, 0x946D, 0x946E, 0x946F, 0x0000, 	/* 0xE878 to 0xE87F */ 
0x9470, 0x9471, 0x9472, 0x9473, 0x9474, 0x9475, 0x9476, 0x9477, 	/* 0xE880 to 0xE887 */ 
0x9478, 0x9479, 0x947A, 0x947B, 0x947C, 0x947D, 0x947E, 0x947F, 	/* 0xE888 to 0xE88F */ 
0x9480, 0x9481, 0x9482, 0x9483, 0x9484, 0x9491, 0x9496, 0x9498, 	/* 0xE890 to 0xE897 */ 
0x94C7, 0x94CF, 0x94D3, 0x94D4, 0x94DA, 0x94E6, 0x94FB, 0x951C, 	/* 0xE898 to 0xE89F */ 
0x9520, 0x741B, 0x741A, 0x7441, 0x745C, 0x7457, 0x7455, 0x7459, 	/* 0xE8A0 to 0xE8A7 */ 
0x7477, 0x746D, 0x747E, 0x749C, 0x748E, 0x7480, 0x7481, 0x7487, 	/* 0xE8A8 to 0xE8AF */ 
0x748B, 0x749E, 0x74A8, 0x74A9, 0x7490, 0x74A7, 0x74D2, 0x74BA, 	/* 0xE8B0 to 0xE8B7 */ 
0x97EA, 0x97EB, 0x97EC, 0x674C, 0x6753, 0x675E, 0x6748, 0x6769, 	/* 0xE8B8 to 0xE8BF */ 
0x67A5, 0x6787, 0x676A, 0x6773, 0x6798, 0x67A7, 0x6775, 0x67A8, 	/* 0xE8C0 to 0xE8C7 */ 
0x679E, 0x67AD, 0x678B, 0x6777, 0x677C, 0x67F0, 0x6809, 0x67D8, 	/* 0xE8C8 to 0xE8CF */ 
0x680A, 0x67E9, 0x67B0, 0x680C, 0x67D9, 0x67B5, 0x67DA, 0x67B3, 	/* 0xE8D0 to 0xE8D7 */ 
0x67DD, 0x6800, 0x67C3, 0x67B8, 0x67E2, 0x680E, 0x67C1, 0x67FD, 	/* 0xE8D8 to 0xE8DF */ 
0x6832, 0x6833, 0x6860, 0x6861, 0x684E, 0x6862, 0x6844, 0x6864, 	/* 0xE8E0 to 0xE8E7 */ 
0x6883, 0x681D, 0x6855, 0x6866, 0x6841, 0x6867, 0x6840, 0x683E, 	/* 0xE8E8 to 0xE8EF */ 
0x684A, 0x6849, 0x6829, 0x68B5, 0x688F, 0x6874, 0x6877, 0x6893, 	/* 0xE8F0 to 0xE8F7 */ 
0x686B, 0x68C2, 0x696E, 0x68FC, 0x691F, 0x6920, 0x68F9, 0x0000, 	/* 0xE8F8 to 0xE8FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE900 to 0xE907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE908 to 0xE90F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE910 to 0xE917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE918 to 0xE91F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE920 to 0xE927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE928 to 0xE92F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE930 to 0xE937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE938 to 0xE93F */ 
0x9527, 0x9533, 0x953D, 0x9543, 0x9548, 0x954B, 0x9555, 0x955A, 	/* 0xE940 to 0xE947 */ 
0x9560, 0x956E, 0x9574, 0x9575, 0x9577, 0x9578, 0x9579, 0x957A, 	/* 0xE948 to 0xE94F */ 
0x957B, 0x957C, 0x957D, 0x957E, 0x9580, 0x9581, 0x9582, 0x9583, 	/* 0xE950 to 0xE957 */ 
0x9584, 0x9585, 0x9586, 0x9587, 0x9588, 0x9589, 0x958A, 0x958B, 	/* 0xE958 to 0xE95F */ 
0x958C, 0x958D, 0x958E, 0x958F, 0x9590, 0x9591, 0x9592, 0x9593, 	/* 0xE960 to 0xE967 */ 
0x9594, 0x9595, 0x9596, 0x9597, 0x9598, 0x9599, 0x959A, 0x959B, 	/* 0xE968 to 0xE96F */ 
0x959C, 0x959D, 0x959E, 0x959F, 0x95A0, 0x95A1, 0x95A2, 0x95A3, 	/* 0xE970 to 0xE977 */ 
0x95A4, 0x95A5, 0x95A6, 0x95A7, 0x95A8, 0x95A9, 0x95AA, 0x0000, 	/* 0xE978 to 0xE97F */ 
0x95AB, 0x95AC, 0x95AD, 0x95AE, 0x95AF, 0x95B0, 0x95B1, 0x95B2, 	/* 0xE980 to 0xE987 */ 
0x95B3, 0x95B4, 0x95B5, 0x95B6, 0x95B7, 0x95B8, 0x95B9, 0x95BA, 	/* 0xE988 to 0xE98F */ 
0x95BB, 0x95BC, 0x95BD, 0x95BE, 0x95BF, 0x95C0, 0x95C1, 0x95C2, 	/* 0xE990 to 0xE997 */ 
0x95C3, 0x95C4, 0x95C5, 0x95C6, 0x95C7, 0x95C8, 0x95C9, 0x95CA, 	/* 0xE998 to 0xE99F */ 
0x95CB, 0x6924, 0x68F0, 0x690B, 0x6901, 0x6957, 0x68E3, 0x6910, 	/* 0xE9A0 to 0xE9A7 */ 
0x6971, 0x6939, 0x6960, 0x6942, 0x695D, 0x6984, 0x696B, 0x6980, 	/* 0xE9A8 to 0xE9AF */ 
0x6998, 0x6978, 0x6934, 0x69CC, 0x6987, 0x6988, 0x69CE, 0x6989, 	/* 0xE9B0 to 0xE9B7 */ 
0x6966, 0x6963, 0x6979, 0x699B, 0x69A7, 0x69BB, 0x69AB, 0x69AD, 	/* 0xE9B8 to 0xE9BF */ 
0x69D4, 0x69B1, 0x69C1, 0x69CA, 0x69DF, 0x6995, 0x69E0, 0x698D, 	/* 0xE9C0 to 0xE9C7 */ 
0x69FF, 0x6A2F, 0x69ED, 0x6A17, 0x6A18, 0x6A65, 0x69F2, 0x6A44, 	/* 0xE9C8 to 0xE9CF */ 
0x6A3E, 0x6AA0, 0x6A50, 0x6A5B, 0x6A35, 0x6A8E, 0x6A79, 0x6A3D, 	/* 0xE9D0 to 0xE9D7 */ 
0x6A28, 0x6A58, 0x6A7C, 0x6A91, 0x6A90, 0x6AA9, 0x6A97, 0x6AAB, 	/* 0xE9D8 to 0xE9DF */ 
0x7337, 0x7352, 0x6B81, 0x6B82, 0x6B87, 0x6B84, 0x6B92, 0x6B93, 	/* 0xE9E0 to 0xE9E7 */ 
0x6B8D, 0x6B9A, 0x6B9B, 0x6BA1, 0x6BAA, 0x8F6B, 0x8F6D, 0x8F71, 	/* 0xE9E8 to 0xE9EF */ 
0x8F72, 0x8F73, 0x8F75, 0x8F76, 0x8F78, 0x8F77, 0x8F79, 0x8F7A, 	/* 0xE9F0 to 0xE9F7 */ 
0x8F7C, 0x8F7E, 0x8F81, 0x8F82, 0x8F84, 0x8F87, 0x8F8B, 0x0000, 	/* 0xE9F8 to 0xE9FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA00 to 0xEA07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA08 to 0xEA0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA10 to 0xEA17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA18 to 0xEA1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA20 to 0xEA27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA28 to 0xEA2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA30 to 0xEA37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA38 to 0xEA3F */ 
0x95CC, 0x95CD, 0x95CE, 0x95CF, 0x95D0, 0x95D1, 0x95D2, 0x95D3, 	/* 0xEA40 to 0xEA47 */ 
0x95D4, 0x95D5, 0x95D6, 0x95D7, 0x95D8, 0x95D9, 0x95DA, 0x95DB, 	/* 0xEA48 to 0xEA4F */ 
0x95DC, 0x95DD, 0x95DE, 0x95DF, 0x95E0, 0x95E1, 0x95E2, 0x95E3, 	/* 0xEA50 to 0xEA57 */ 
0x95E4, 0x95E5, 0x95E6, 0x95E7, 0x95EC, 0x95FF, 0x9607, 0x9613, 	/* 0xEA58 to 0xEA5F */ 
0x9618, 0x961B, 0x961E, 0x9620, 0x9623, 0x9624, 0x9625, 0x9626, 	/* 0xEA60 to 0xEA67 */ 
0x9627, 0x9628, 0x9629, 0x962B, 0x962C, 0x962D, 0x962F, 0x9630, 	/* 0xEA68 to 0xEA6F */ 
0x9637, 0x9638, 0x9639, 0x963A, 0x963E, 0x9641, 0x9643, 0x964A, 	/* 0xEA70 to 0xEA77 */ 
0x964E, 0x964F, 0x9651, 0x9652, 0x9653, 0x9656, 0x9657, 0x0000, 	/* 0xEA78 to 0xEA7F */ 
0x9658, 0x9659, 0x965A, 0x965C, 0x965D, 0x965E, 0x9660, 0x9663, 	/* 0xEA80 to 0xEA87 */ 
0x9665, 0x9666, 0x966B, 0x966D, 0x966E, 0x966F, 0x9670, 0x9671, 	/* 0xEA88 to 0xEA8F */ 
0x9673, 0x9678, 0x9679, 0x967A, 0x967B, 0x967C, 0x967D, 0x967E, 	/* 0xEA90 to 0xEA97 */ 
0x967F, 0x9680, 0x9681, 0x9682, 0x9683, 0x9684, 0x9687, 0x9689, 	/* 0xEA98 to 0xEA9F */ 
0x968A, 0x8F8D, 0x8F8E, 0x8F8F, 0x8F98, 0x8F9A, 0x8ECE, 0x620B, 	/* 0xEAA0 to 0xEAA7 */ 
0x6217, 0x621B, 0x621F, 0x6222, 0x6221, 0x6225, 0x6224, 0x622C, 	/* 0xEAA8 to 0xEAAF */ 
0x81E7, 0x74EF, 0x74F4, 0x74FF, 0x750F, 0x7511, 0x7513, 0x6534, 	/* 0xEAB0 to 0xEAB7 */ 
0x65EE, 0x65EF, 0x65F0, 0x660A, 0x6619, 0x6772, 0x6603, 0x6615, 	/* 0xEAB8 to 0xEABF */ 
0x6600, 0x7085, 0x66F7, 0x661D, 0x6634, 0x6631, 0x6636, 0x6635, 	/* 0xEAC0 to 0xEAC7 */ 
0x8006, 0x665F, 0x6654, 0x6641, 0x664F, 0x6656, 0x6661, 0x6657, 	/* 0xEAC8 to 0xEACF */ 
0x6677, 0x6684, 0x668C, 0x66A7, 0x669D, 0x66BE, 0x66DB, 0x66DC, 	/* 0xEAD0 to 0xEAD7 */ 
0x66E6, 0x66E9, 0x8D32, 0x8D33, 0x8D36, 0x8D3B, 0x8D3D, 0x8D40, 	/* 0xEAD8 to 0xEADF */ 
0x8D45, 0x8D46, 0x8D48, 0x8D49, 0x8D47, 0x8D4D, 0x8D55, 0x8D59, 	/* 0xEAE0 to 0xEAE7 */ 
0x89C7, 0x89CA, 0x89CB, 0x89CC, 0x89CE, 0x89CF, 0x89D0, 0x89D1, 	/* 0xEAE8 to 0xEAEF */ 
0x726E, 0x729F, 0x725D, 0x7266, 0x726F, 0x727E, 0x727F, 0x7284, 	/* 0xEAF0 to 0xEAF7 */ 
0x728B, 0x728D, 0x728F, 0x7292, 0x6308, 0x6332, 0x63B0, 0x0000, 	/* 0xEAF8 to 0xEAFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB00 to 0xEB07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB08 to 0xEB0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB10 to 0xEB17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB18 to 0xEB1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB20 to 0xEB27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB28 to 0xEB2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB30 to 0xEB37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB38 to 0xEB3F */ 
0x968C, 0x968E, 0x9691, 0x9692, 0x9693, 0x9695, 0x9696, 0x969A, 	/* 0xEB40 to 0xEB47 */ 
0x969B, 0x969D, 0x969E, 0x969F, 0x96A0, 0x96A1, 0x96A2, 0x96A3, 	/* 0xEB48 to 0xEB4F */ 
0x96A4, 0x96A5, 0x96A6, 0x96A8, 0x96A9, 0x96AA, 0x96AB, 0x96AC, 	/* 0xEB50 to 0xEB57 */ 
0x96AD, 0x96AE, 0x96AF, 0x96B1, 0x96B2, 0x96B4, 0x96B5, 0x96B7, 	/* 0xEB58 to 0xEB5F */ 
0x96B8, 0x96BA, 0x96BB, 0x96BF, 0x96C2, 0x96C3, 0x96C8, 0x96CA, 	/* 0xEB60 to 0xEB67 */ 
0x96CB, 0x96D0, 0x96D1, 0x96D3, 0x96D4, 0x96D6, 0x96D7, 0x96D8, 	/* 0xEB68 to 0xEB6F */ 
0x96D9, 0x96DA, 0x96DB, 0x96DC, 0x96DD, 0x96DE, 0x96DF, 0x96E1, 	/* 0xEB70 to 0xEB77 */ 
0x96E2, 0x96E3, 0x96E4, 0x96E5, 0x96E6, 0x96E7, 0x96EB, 0x0000, 	/* 0xEB78 to 0xEB7F */ 
0x96EC, 0x96ED, 0x96EE, 0x96F0, 0x96F1, 0x96F2, 0x96F4, 0x96F5, 	/* 0xEB80 to 0xEB87 */ 
0x96F8, 0x96FA, 0x96FB, 0x96FC, 0x96FD, 0x96FF, 0x9702, 0x9703, 	/* 0xEB88 to 0xEB8F */ 
0x9705, 0x970A, 0x970B, 0x970C, 0x9710, 0x9711, 0x9712, 0x9714, 	/* 0xEB90 to 0xEB97 */ 
0x9715, 0x9717, 0x9718, 0x9719, 0x971A, 0x971B, 0x971D, 0x971F, 	/* 0xEB98 to 0xEB9F */ 
0x9720, 0x643F, 0x64D8, 0x8004, 0x6BEA, 0x6BF3, 0x6BFD, 0x6BF5, 	/* 0xEBA0 to 0xEBA7 */ 
0x6BF9, 0x6C05, 0x6C07, 0x6C06, 0x6C0D, 0x6C15, 0x6C18, 0x6C19, 	/* 0xEBA8 to 0xEBAF */ 
0x6C1A, 0x6C21, 0x6C29, 0x6C24, 0x6C2A, 0x6C32, 0x6535, 0x6555, 	/* 0xEBB0 to 0xEBB7 */ 
0x656B, 0x724D, 0x7252, 0x7256, 0x7230, 0x8662, 0x5216, 0x809F, 	/* 0xEBB8 to 0xEBBF */ 
0x809C, 0x8093, 0x80BC, 0x670A, 0x80BD, 0x80B1, 0x80AB, 0x80AD, 	/* 0xEBC0 to 0xEBC7 */ 
0x80B4, 0x80B7, 0x80E7, 0x80E8, 0x80E9, 0x80EA, 0x80DB, 0x80C2, 	/* 0xEBC8 to 0xEBCF */ 
0x80C4, 0x80D9, 0x80CD, 0x80D7, 0x6710, 0x80DD, 0x80EB, 0x80F1, 	/* 0xEBD0 to 0xEBD7 */ 
0x80F4, 0x80ED, 0x810D, 0x810E, 0x80F2, 0x80FC, 0x6715, 0x8112, 	/* 0xEBD8 to 0xEBDF */ 
0x8C5A, 0x8136, 0x811E, 0x812C, 0x8118, 0x8132, 0x8148, 0x814C, 	/* 0xEBE0 to 0xEBE7 */ 
0x8153, 0x8174, 0x8159, 0x815A, 0x8171, 0x8160, 0x8169, 0x817C, 	/* 0xEBE8 to 0xEBEF */ 
0x817D, 0x816D, 0x8167, 0x584D, 0x5AB5, 0x8188, 0x8182, 0x8191, 	/* 0xEBF0 to 0xEBF7 */ 
0x6ED5, 0x81A3, 0x81AA, 0x81CC, 0x6726, 0x81CA, 0x81BB, 0x0000, 	/* 0xEBF8 to 0xEBFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC00 to 0xEC07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC08 to 0xEC0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC10 to 0xEC17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC18 to 0xEC1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC20 to 0xEC27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC28 to 0xEC2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC30 to 0xEC37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC38 to 0xEC3F */ 
0x9721, 0x9722, 0x9723, 0x9724, 0x9725, 0x9726, 0x9727, 0x9728, 	/* 0xEC40 to 0xEC47 */ 
0x9729, 0x972B, 0x972C, 0x972E, 0x972F, 0x9731, 0x9733, 0x9734, 	/* 0xEC48 to 0xEC4F */ 
0x9735, 0x9736, 0x9737, 0x973A, 0x973B, 0x973C, 0x973D, 0x973F, 	/* 0xEC50 to 0xEC57 */ 
0x9740, 0x9741, 0x9742, 0x9743, 0x9744, 0x9745, 0x9746, 0x9747, 	/* 0xEC58 to 0xEC5F */ 
0x9748, 0x9749, 0x974A, 0x974B, 0x974C, 0x974D, 0x974E, 0x974F, 	/* 0xEC60 to 0xEC67 */ 
0x9750, 0x9751, 0x9754, 0x9755, 0x9757, 0x9758, 0x975A, 0x975C, 	/* 0xEC68 to 0xEC6F */ 
0x975D, 0x975F, 0x9763, 0x9764, 0x9766, 0x9767, 0x9768, 0x976A, 	/* 0xEC70 to 0xEC77 */ 
0x976B, 0x976C, 0x976D, 0x976E, 0x976F, 0x9770, 0x9771, 0x0000, 	/* 0xEC78 to 0xEC7F */ 
0x9772, 0x9775, 0x9777, 0x9778, 0x9779, 0x977A, 0x977B, 0x977D, 	/* 0xEC80 to 0xEC87 */ 
0x977E, 0x977F, 0x9780, 0x9781, 0x9782, 0x9783, 0x9784, 0x9786, 	/* 0xEC88 to 0xEC8F */ 
0x9787, 0x9788, 0x9789, 0x978A, 0x978C, 0x978E, 0x978F, 0x9790, 	/* 0xEC90 to 0xEC97 */ 
0x9793, 0x9795, 0x9796, 0x9797, 0x9799, 0x979A, 0x979B, 0x979C, 	/* 0xEC98 to 0xEC9F */ 
0x979D, 0x81C1, 0x81A6, 0x6B24, 0x6B37, 0x6B39, 0x6B43, 0x6B46, 	/* 0xECA0 to 0xECA7 */ 
0x6B59, 0x98D1, 0x98D2, 0x98D3, 0x98D5, 0x98D9, 0x98DA, 0x6BB3, 	/* 0xECA8 to 0xECAF */ 
0x5F40, 0x6BC2, 0x89F3, 0x6590, 0x9F51, 0x6593, 0x65BC, 0x65C6, 	/* 0xECB0 to 0xECB7 */ 
0x65C4, 0x65C3, 0x65CC, 0x65CE, 0x65D2, 0x65D6, 0x7080, 0x709C, 	/* 0xECB8 to 0xECBF */ 
0x7096, 0x709D, 0x70BB, 0x70C0, 0x70B7, 0x70AB, 0x70B1, 0x70E8, 	/* 0xECC0 to 0xECC7 */ 
0x70CA, 0x7110, 0x7113, 0x7116, 0x712F, 0x7131, 0x7173, 0x715C, 	/* 0xECC8 to 0xECCF */ 
0x7168, 0x7145, 0x7172, 0x714A, 0x7178, 0x717A, 0x7198, 0x71B3, 	/* 0xECD0 to 0xECD7 */ 
0x71B5, 0x71A8, 0x71A0, 0x71E0, 0x71D4, 0x71E7, 0x71F9, 0x721D, 	/* 0xECD8 to 0xECDF */ 
0x7228, 0x706C, 0x7118, 0x7166, 0x71B9, 0x623E, 0x623D, 0x6243, 	/* 0xECE0 to 0xECE7 */ 
0x6248, 0x6249, 0x793B, 0x7940, 0x7946, 0x7949, 0x795B, 0x795C, 	/* 0xECE8 to 0xECEF */ 
0x7953, 0x795A, 0x7962, 0x7957, 0x7960, 0x796F, 0x7967, 0x797A, 	/* 0xECF0 to 0xECF7 */ 
0x7985, 0x798A, 0x799A, 0x79A7, 0x79B3, 0x5FD1, 0x5FD0, 0x0000, 	/* 0xECF8 to 0xECFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED00 to 0xED07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED08 to 0xED0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED10 to 0xED17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED18 to 0xED1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED20 to 0xED27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED28 to 0xED2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED30 to 0xED37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED38 to 0xED3F */ 
0x979E, 0x979F, 0x97A1, 0x97A2, 0x97A4, 0x97A5, 0x97A6, 0x97A7, 	/* 0xED40 to 0xED47 */ 
0x97A8, 0x97A9, 0x97AA, 0x97AC, 0x97AE, 0x97B0, 0x97B1, 0x97B3, 	/* 0xED48 to 0xED4F */ 
0x97B5, 0x97B6, 0x97B7, 0x97B8, 0x97B9, 0x97BA, 0x97BB, 0x97BC, 	/* 0xED50 to 0xED57 */ 
0x97BD, 0x97BE, 0x97BF, 0x97C0, 0x97C1, 0x97C2, 0x97C3, 0x97C4, 	/* 0xED58 to 0xED5F */ 
0x97C5, 0x97C6, 0x97C7, 0x97C8, 0x97C9, 0x97CA, 0x97CB, 0x97CC, 	/* 0xED60 to 0xED67 */ 
0x97CD, 0x97CE, 0x97CF, 0x97D0, 0x97D1, 0x97D2, 0x97D3, 0x97D4, 	/* 0xED68 to 0xED6F */ 
0x97D5, 0x97D6, 0x97D7, 0x97D8, 0x97D9, 0x97DA, 0x97DB, 0x97DC, 	/* 0xED70 to 0xED77 */ 
0x97DD, 0x97DE, 0x97DF, 0x97E0, 0x97E1, 0x97E2, 0x97E3, 0x0000, 	/* 0xED78 to 0xED7F */ 
0x97E4, 0x97E5, 0x97E8, 0x97EE, 0x97EF, 0x97F0, 0x97F1, 0x97F2, 	/* 0xED80 to 0xED87 */ 
0x97F4, 0x97F7, 0x97F8, 0x97F9, 0x97FA, 0x97FB, 0x97FC, 0x97FD, 	/* 0xED88 to 0xED8F */ 
0x97FE, 0x97FF, 0x9800, 0x9801, 0x9802, 0x9803, 0x9804, 0x9805, 	/* 0xED90 to 0xED97 */ 
0x9806, 0x9807, 0x9808, 0x9809, 0x980A, 0x980B, 0x980C, 0x980D, 	/* 0xED98 to 0xED9F */ 
0x980E, 0x603C, 0x605D, 0x605A, 0x6067, 0x6041, 0x6059, 0x6063, 	/* 0xEDA0 to 0xEDA7 */ 
0x60AB, 0x6106, 0x610D, 0x615D, 0x61A9, 0x619D, 0x61CB, 0x61D1, 	/* 0xEDA8 to 0xEDAF */ 
0x6206, 0x8080, 0x807F, 0x6C93, 0x6CF6, 0x6DFC, 0x77F6, 0x77F8, 	/* 0xEDB0 to 0xEDB7 */ 
0x7800, 0x7809, 0x7817, 0x7818, 0x7811, 0x65AB, 0x782D, 0x781C, 	/* 0xEDB8 to 0xEDBF */ 
0x781D, 0x7839, 0x783A, 0x783B, 0x781F, 0x783C, 0x7825, 0x782C, 	/* 0xEDC0 to 0xEDC7 */ 
0x7823, 0x7829, 0x784E, 0x786D, 0x7856, 0x7857, 0x7826, 0x7850, 	/* 0xEDC8 to 0xEDCF */ 
0x7847, 0x784C, 0x786A, 0x789B, 0x7893, 0x789A, 0x7887, 0x789C, 	/* 0xEDD0 to 0xEDD7 */ 
0x78A1, 0x78A3, 0x78B2, 0x78B9, 0x78A5, 0x78D4, 0x78D9, 0x78C9, 	/* 0xEDD8 to 0xEDDF */ 
0x78EC, 0x78F2, 0x7905, 0x78F4, 0x7913, 0x7924, 0x791E, 0x7934, 	/* 0xEDE0 to 0xEDE7 */ 
0x9F9B, 0x9EF9, 0x9EFB, 0x9EFC, 0x76F1, 0x7704, 0x770D, 0x76F9, 	/* 0xEDE8 to 0xEDEF */ 
0x7707, 0x7708, 0x771A, 0x7722, 0x7719, 0x772D, 0x7726, 0x7735, 	/* 0xEDF0 to 0xEDF7 */ 
0x7738, 0x7750, 0x7751, 0x7747, 0x7743, 0x775A, 0x7768, 0x0000, 	/* 0xEDF8 to 0xEDFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE00 to 0xEE07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE08 to 0xEE0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE10 to 0xEE17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE18 to 0xEE1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE20 to 0xEE27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE28 to 0xEE2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE30 to 0xEE37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE38 to 0xEE3F */ 
0x980F, 0x9810, 0x9811, 0x9812, 0x9813, 0x9814, 0x9815, 0x9816, 	/* 0xEE40 to 0xEE47 */ 
0x9817, 0x9818, 0x9819, 0x981A, 0x981B, 0x981C, 0x981D, 0x981E, 	/* 0xEE48 to 0xEE4F */ 
0x981F, 0x9820, 0x9821, 0x9822, 0x9823, 0x9824, 0x9825, 0x9826, 	/* 0xEE50 to 0xEE57 */ 
0x9827, 0x9828, 0x9829, 0x982A, 0x982B, 0x982C, 0x982D, 0x982E, 	/* 0xEE58 to 0xEE5F */ 
0x982F, 0x9830, 0x9831, 0x9832, 0x9833, 0x9834, 0x9835, 0x9836, 	/* 0xEE60 to 0xEE67 */ 
0x9837, 0x9838, 0x9839, 0x983A, 0x983B, 0x983C, 0x983D, 0x983E, 	/* 0xEE68 to 0xEE6F */ 
0x983F, 0x9840, 0x9841, 0x9842, 0x9843, 0x9844, 0x9845, 0x9846, 	/* 0xEE70 to 0xEE77 */ 
0x9847, 0x9848, 0x9849, 0x984A, 0x984B, 0x984C, 0x984D, 0x0000, 	/* 0xEE78 to 0xEE7F */ 
0x984E, 0x984F, 0x9850, 0x9851, 0x9852, 0x9853, 0x9854, 0x9855, 	/* 0xEE80 to 0xEE87 */ 
0x9856, 0x9857, 0x9858, 0x9859, 0x985A, 0x985B, 0x985C, 0x985D, 	/* 0xEE88 to 0xEE8F */ 
0x985E, 0x985F, 0x9860, 0x9861, 0x9862, 0x9863, 0x9864, 0x9865, 	/* 0xEE90 to 0xEE97 */ 
0x9866, 0x9867, 0x9868, 0x9869, 0x986A, 0x986B, 0x986C, 0x986D, 	/* 0xEE98 to 0xEE9F */ 
0x986E, 0x7762, 0x7765, 0x777F, 0x778D, 0x777D, 0x7780, 0x778C, 	/* 0xEEA0 to 0xEEA7 */ 
0x7791, 0x779F, 0x77A0, 0x77B0, 0x77B5, 0x77BD, 0x753A, 0x7540, 	/* 0xEEA8 to 0xEEAF */ 
0x754E, 0x754B, 0x7548, 0x755B, 0x7572, 0x7579, 0x7583, 0x7F58, 	/* 0xEEB0 to 0xEEB7 */ 
0x7F61, 0x7F5F, 0x8A48, 0x7F68, 0x7F74, 0x7F71, 0x7F79, 0x7F81, 	/* 0xEEB8 to 0xEEBF */ 
0x7F7E, 0x76CD, 0x76E5, 0x8832, 0x9485, 0x9486, 0x9487, 0x948B, 	/* 0xEEC0 to 0xEEC7 */ 
0x948A, 0x948C, 0x948D, 0x948F, 0x9490, 0x9494, 0x9497, 0x9495, 	/* 0xEEC8 to 0xEECF */ 
0x949A, 0x949B, 0x949C, 0x94A3, 0x94A4, 0x94AB, 0x94AA, 0x94AD, 	/* 0xEED0 to 0xEED7 */ 
0x94AC, 0x94AF, 0x94B0, 0x94B2, 0x94B4, 0x94B6, 0x94B7, 0x94B8, 	/* 0xEED8 to 0xEEDF */ 
0x94B9, 0x94BA, 0x94BC, 0x94BD, 0x94BF, 0x94C4, 0x94C8, 0x94C9, 	/* 0xEEE0 to 0xEEE7 */ 
0x94CA, 0x94CB, 0x94CC, 0x94CD, 0x94CE, 0x94D0, 0x94D1, 0x94D2, 	/* 0xEEE8 to 0xEEEF */ 
0x94D5, 0x94D6, 0x94D7, 0x94D9, 0x94D8, 0x94DB, 0x94DE, 0x94DF, 	/* 0xEEF0 to 0xEEF7 */ 
0x94E0, 0x94E2, 0x94E4, 0x94E5, 0x94E7, 0x94E8, 0x94EA, 0x0000, 	/* 0xEEF8 to 0xEEFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF00 to 0xEF07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF08 to 0xEF0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF10 to 0xEF17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF18 to 0xEF1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF20 to 0xEF27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF28 to 0xEF2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF30 to 0xEF37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF38 to 0xEF3F */ 
0x986F, 0x9870, 0x9871, 0x9872, 0x9873, 0x9874, 0x988B, 0x988E, 	/* 0xEF40 to 0xEF47 */ 
0x9892, 0x9895, 0x9899, 0x98A3, 0x98A8, 0x98A9, 0x98AA, 0x98AB, 	/* 0xEF48 to 0xEF4F */ 
0x98AC, 0x98AD, 0x98AE, 0x98AF, 0x98B0, 0x98B1, 0x98B2, 0x98B3, 	/* 0xEF50 to 0xEF57 */ 
0x98B4, 0x98B5, 0x98B6, 0x98B7, 0x98B8, 0x98B9, 0x98BA, 0x98BB, 	/* 0xEF58 to 0xEF5F */ 
0x98BC, 0x98BD, 0x98BE, 0x98BF, 0x98C0, 0x98C1, 0x98C2, 0x98C3, 	/* 0xEF60 to 0xEF67 */ 
0x98C4, 0x98C5, 0x98C6, 0x98C7, 0x98C8, 0x98C9, 0x98CA, 0x98CB, 	/* 0xEF68 to 0xEF6F */ 
0x98CC, 0x98CD, 0x98CF, 0x98D0, 0x98D4, 0x98D6, 0x98D7, 0x98DB, 	/* 0xEF70 to 0xEF77 */ 
0x98DC, 0x98DD, 0x98E0, 0x98E1, 0x98E2, 0x98E3, 0x98E4, 0x0000, 	/* 0xEF78 to 0xEF7F */ 
0x98E5, 0x98E6, 0x98E9, 0x98EA, 0x98EB, 0x98EC, 0x98ED, 0x98EE, 	/* 0xEF80 to 0xEF87 */ 
0x98EF, 0x98F0, 0x98F1, 0x98F2, 0x98F3, 0x98F4, 0x98F5, 0x98F6, 	/* 0xEF88 to 0xEF8F */ 
0x98F7, 0x98F8, 0x98F9, 0x98FA, 0x98FB, 0x98FC, 0x98FD, 0x98FE, 	/* 0xEF90 to 0xEF97 */ 
0x98FF, 0x9900, 0x9901, 0x9902, 0x9903, 0x9904, 0x9905, 0x9906, 	/* 0xEF98 to 0xEF9F */ 
0x9907, 0x94E9, 0x94EB, 0x94EE, 0x94EF, 0x94F3, 0x94F4, 0x94F5, 	/* 0xEFA0 to 0xEFA7 */ 
0x94F7, 0x94F9, 0x94FC, 0x94FD, 0x94FF, 0x9503, 0x9502, 0x9506, 	/* 0xEFA8 to 0xEFAF */ 
0x9507, 0x9509, 0x950A, 0x950D, 0x950E, 0x950F, 0x9512, 0x9513, 	/* 0xEFB0 to 0xEFB7 */ 
0x9514, 0x9515, 0x9516, 0x9518, 0x951B, 0x951D, 0x951E, 0x951F, 	/* 0xEFB8 to 0xEFBF */ 
0x9522, 0x952A, 0x952B, 0x9529, 0x952C, 0x9531, 0x9532, 0x9534, 	/* 0xEFC0 to 0xEFC7 */ 
0x9536, 0x9537, 0x9538, 0x953C, 0x953E, 0x953F, 0x9542, 0x9535, 	/* 0xEFC8 to 0xEFCF */ 
0x9544, 0x9545, 0x9546, 0x9549, 0x954C, 0x954E, 0x954F, 0x9552, 	/* 0xEFD0 to 0xEFD7 */ 
0x9553, 0x9554, 0x9556, 0x9557, 0x9558, 0x9559, 0x955B, 0x955E, 	/* 0xEFD8 to 0xEFDF */ 
0x955F, 0x955D, 0x9561, 0x9562, 0x9564, 0x9565, 0x9566, 0x9567, 	/* 0xEFE0 to 0xEFE7 */ 
0x9568, 0x9569, 0x956A, 0x956B, 0x956C, 0x956F, 0x9571, 0x9572, 	/* 0xEFE8 to 0xEFEF */ 
0x9573, 0x953A, 0x77E7, 0x77EC, 0x96C9, 0x79D5, 0x79ED, 0x79E3, 	/* 0xEFF0 to 0xEFF7 */ 
0x79EB, 0x7A06, 0x5D47, 0x7A03, 0x7A02, 0x7A1E, 0x7A14, 0x0000, 	/* 0xEFF8 to 0xEFFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF000 to 0xF007 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF008 to 0xF00F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF010 to 0xF017 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF018 to 0xF01F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF020 to 0xF027 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF028 to 0xF02F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF030 to 0xF037 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF038 to 0xF03F */ 
0x9908, 0x9909, 0x990A, 0x990B, 0x990C, 0x990E, 0x990F, 0x9911, 	/* 0xF040 to 0xF047 */ 
0x9912, 0x9913, 0x9914, 0x9915, 0x9916, 0x9917, 0x9918, 0x9919, 	/* 0xF048 to 0xF04F */ 
0x991A, 0x991B, 0x991C, 0x991D, 0x991E, 0x991F, 0x9920, 0x9921, 	/* 0xF050 to 0xF057 */ 
0x9922, 0x9923, 0x9924, 0x9925, 0x9926, 0x9927, 0x9928, 0x9929, 	/* 0xF058 to 0xF05F */ 
0x992A, 0x992B, 0x992C, 0x992D, 0x992F, 0x9930, 0x9931, 0x9932, 	/* 0xF060 to 0xF067 */ 
0x9933, 0x9934, 0x9935, 0x9936, 0x9937, 0x9938, 0x9939, 0x993A, 	/* 0xF068 to 0xF06F */ 
0x993B, 0x993C, 0x993D, 0x993E, 0x993F, 0x9940, 0x9941, 0x9942, 	/* 0xF070 to 0xF077 */ 
0x9943, 0x9944, 0x9945, 0x9946, 0x9947, 0x9948, 0x9949, 0x0000, 	/* 0xF078 to 0xF07F */ 
0x994A, 0x994B, 0x994C, 0x994D, 0x994E, 0x994F, 0x9950, 0x9951, 	/* 0xF080 to 0xF087 */ 
0x9952, 0x9953, 0x9956, 0x9957, 0x9958, 0x9959, 0x995A, 0x995B, 	/* 0xF088 to 0xF08F */ 
0x995C, 0x995D, 0x995E, 0x995F, 0x9960, 0x9961, 0x9962, 0x9964, 	/* 0xF090 to 0xF097 */ 
0x9966, 0x9973, 0x9978, 0x9979, 0x997B, 0x997E, 0x9982, 0x9983, 	/* 0xF098 to 0xF09F */ 
0x9989, 0x7A39, 0x7A37, 0x7A51, 0x9ECF, 0x99A5, 0x7A70, 0x7688, 	/* 0xF0A0 to 0xF0A7 */ 
0x768E, 0x7693, 0x7699, 0x76A4, 0x74DE, 0x74E0, 0x752C, 0x9E20, 	/* 0xF0A8 to 0xF0AF */ 
0x9E22, 0x9E28, 0x9E29, 0x9E2A, 0x9E2B, 0x9E2C, 0x9E32, 0x9E31, 	/* 0xF0B0 to 0xF0B7 */ 
0x9E36, 0x9E38, 0x9E37, 0x9E39, 0x9E3A, 0x9E3E, 0x9E41, 0x9E42, 	/* 0xF0B8 to 0xF0BF */ 
0x9E44, 0x9E46, 0x9E47, 0x9E48, 0x9E49, 0x9E4B, 0x9E4C, 0x9E4E, 	/* 0xF0C0 to 0xF0C7 */ 
0x9E51, 0x9E55, 0x9E57, 0x9E5A, 0x9E5B, 0x9E5C, 0x9E5E, 0x9E63, 	/* 0xF0C8 to 0xF0CF */ 
0x9E66, 0x9E67, 0x9E68, 0x9E69, 0x9E6A, 0x9E6B, 0x9E6C, 0x9E71, 	/* 0xF0D0 to 0xF0D7 */ 
0x9E6D, 0x9E73, 0x7592, 0x7594, 0x7596, 0x75A0, 0x759D, 0x75AC, 	/* 0xF0D8 to 0xF0DF */ 
0x75A3, 0x75B3, 0x75B4, 0x75B8, 0x75C4, 0x75B1, 0x75B0, 0x75C3, 	/* 0xF0E0 to 0xF0E7 */ 
0x75C2, 0x75D6, 0x75CD, 0x75E3, 0x75E8, 0x75E6, 0x75E4, 0x75EB, 	/* 0xF0E8 to 0xF0EF */ 
0x75E7, 0x7603, 0x75F1, 0x75FC, 0x75FF, 0x7610, 0x7600, 0x7605, 	/* 0xF0F0 to 0xF0F7 */ 
0x760C, 0x7617, 0x760A, 0x7625, 0x7618, 0x7615, 0x7619, 0x0000, 	/* 0xF0F8 to 0xF0FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF100 to 0xF107 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF108 to 0xF10F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF110 to 0xF117 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF118 to 0xF11F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF120 to 0xF127 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF128 to 0xF12F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF130 to 0xF137 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF138 to 0xF13F */ 
0x998C, 0x998E, 0x999A, 0x999B, 0x999C, 0x999D, 0x999E, 0x999F, 	/* 0xF140 to 0xF147 */ 
0x99A0, 0x99A1, 0x99A2, 0x99A3, 0x99A4, 0x99A6, 0x99A7, 0x99A9, 	/* 0xF148 to 0xF14F */ 
0x99AA, 0x99AB, 0x99AC, 0x99AD, 0x99AE, 0x99AF, 0x99B0, 0x99B1, 	/* 0xF150 to 0xF157 */ 
0x99B2, 0x99B3, 0x99B4, 0x99B5, 0x99B6, 0x99B7, 0x99B8, 0x99B9, 	/* 0xF158 to 0xF15F */ 
0x99BA, 0x99BB, 0x99BC, 0x99BD, 0x99BE, 0x99BF, 0x99C0, 0x99C1, 	/* 0xF160 to 0xF167 */ 
0x99C2, 0x99C3, 0x99C4, 0x99C5, 0x99C6, 0x99C7, 0x99C8, 0x99C9, 	/* 0xF168 to 0xF16F */ 
0x99CA, 0x99CB, 0x99CC, 0x99CD, 0x99CE, 0x99CF, 0x99D0, 0x99D1, 	/* 0xF170 to 0xF177 */ 
0x99D2, 0x99D3, 0x99D4, 0x99D5, 0x99D6, 0x99D7, 0x99D8, 0x0000, 	/* 0xF178 to 0xF17F */ 
0x99D9, 0x99DA, 0x99DB, 0x99DC, 0x99DD, 0x99DE, 0x99DF, 0x99E0, 	/* 0xF180 to 0xF187 */ 
0x99E1, 0x99E2, 0x99E3, 0x99E4, 0x99E5, 0x99E6, 0x99E7, 0x99E8, 	/* 0xF188 to 0xF18F */ 
0x99E9, 0x99EA, 0x99EB, 0x99EC, 0x99ED, 0x99EE, 0x99EF, 0x99F0, 	/* 0xF190 to 0xF197 */ 
0x99F1, 0x99F2, 0x99F3, 0x99F4, 0x99F5, 0x99F6, 0x99F7, 0x99F8, 	/* 0xF198 to 0xF19F */ 
0x99F9, 0x761B, 0x763C, 0x7622, 0x7620, 0x7640, 0x762D, 0x7630, 	/* 0xF1A0 to 0xF1A7 */ 
0x763F, 0x7635, 0x7643, 0x763E, 0x7633, 0x764D, 0x765E, 0x7654, 	/* 0xF1A8 to 0xF1AF */ 
0x765C, 0x7656, 0x766B, 0x766F, 0x7FCA, 0x7AE6, 0x7A78, 0x7A79, 	/* 0xF1B0 to 0xF1B7 */ 
0x7A80, 0x7A86, 0x7A88, 0x7A95, 0x7AA6, 0x7AA0, 0x7AAC, 0x7AA8, 	/* 0xF1B8 to 0xF1BF */ 
0x7AAD, 0x7AB3, 0x8864, 0x8869, 0x8872, 0x887D, 0x887F, 0x8882, 	/* 0xF1C0 to 0xF1C7 */ 
0x88A2, 0x88C6, 0x88B7, 0x88BC, 0x88C9, 0x88E2, 0x88CE, 0x88E3, 	/* 0xF1C8 to 0xF1CF */ 
0x88E5, 0x88F1, 0x891A, 0x88FC, 0x88E8, 0x88FE, 0x88F0, 0x8921, 	/* 0xF1D0 to 0xF1D7 */ 
0x8919, 0x8913, 0x891B, 0x890A, 0x8934, 0x892B, 0x8936, 0x8941, 	/* 0xF1D8 to 0xF1DF */ 
0x8966, 0x897B, 0x758B, 0x80E5, 0x76B2, 0x76B4, 0x77DC, 0x8012, 	/* 0xF1E0 to 0xF1E7 */ 
0x8014, 0x8016, 0x801C, 0x8020, 0x8022, 0x8025, 0x8026, 0x8027, 	/* 0xF1E8 to 0xF1EF */ 
0x8029, 0x8028, 0x8031, 0x800B, 0x8035, 0x8043, 0x8046, 0x804D, 	/* 0xF1F0 to 0xF1F7 */ 
0x8052, 0x8069, 0x8071, 0x8983, 0x9878, 0x9880, 0x9883, 0x0000, 	/* 0xF1F8 to 0xF1FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF200 to 0xF207 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF208 to 0xF20F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF210 to 0xF217 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF218 to 0xF21F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF220 to 0xF227 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF228 to 0xF22F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF230 to 0xF237 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF238 to 0xF23F */ 
0x99FA, 0x99FB, 0x99FC, 0x99FD, 0x99FE, 0x99FF, 0x9A00, 0x9A01, 	/* 0xF240 to 0xF247 */ 
0x9A02, 0x9A03, 0x9A04, 0x9A05, 0x9A06, 0x9A07, 0x9A08, 0x9A09, 	/* 0xF248 to 0xF24F */ 
0x9A0A, 0x9A0B, 0x9A0C, 0x9A0D, 0x9A0E, 0x9A0F, 0x9A10, 0x9A11, 	/* 0xF250 to 0xF257 */ 
0x9A12, 0x9A13, 0x9A14, 0x9A15, 0x9A16, 0x9A17, 0x9A18, 0x9A19, 	/* 0xF258 to 0xF25F */ 
0x9A1A, 0x9A1B, 0x9A1C, 0x9A1D, 0x9A1E, 0x9A1F, 0x9A20, 0x9A21, 	/* 0xF260 to 0xF267 */ 
0x9A22, 0x9A23, 0x9A24, 0x9A25, 0x9A26, 0x9A27, 0x9A28, 0x9A29, 	/* 0xF268 to 0xF26F */ 
0x9A2A, 0x9A2B, 0x9A2C, 0x9A2D, 0x9A2E, 0x9A2F, 0x9A30, 0x9A31, 	/* 0xF270 to 0xF277 */ 
0x9A32, 0x9A33, 0x9A34, 0x9A35, 0x9A36, 0x9A37, 0x9A38, 0x0000, 	/* 0xF278 to 0xF27F */ 
0x9A39, 0x9A3A, 0x9A3B, 0x9A3C, 0x9A3D, 0x9A3E, 0x9A3F, 0x9A40, 	/* 0xF280 to 0xF287 */ 
0x9A41, 0x9A42, 0x9A43, 0x9A44, 0x9A45, 0x9A46, 0x9A47, 0x9A48, 	/* 0xF288 to 0xF28F */ 
0x9A49, 0x9A4A, 0x9A4B, 0x9A4C, 0x9A4D, 0x9A4E, 0x9A4F, 0x9A50, 	/* 0xF290 to 0xF297 */ 
0x9A51, 0x9A52, 0x9A53, 0x9A54, 0x9A55, 0x9A56, 0x9A57, 0x9A58, 	/* 0xF298 to 0xF29F */ 
0x9A59, 0x9889, 0x988C, 0x988D, 0x988F, 0x9894, 0x989A, 0x989B, 	/* 0xF2A0 to 0xF2A7 */ 
0x989E, 0x989F, 0x98A1, 0x98A2, 0x98A5, 0x98A6, 0x864D, 0x8654, 	/* 0xF2A8 to 0xF2AF */ 
0x866C, 0x866E, 0x867F, 0x867A, 0x867C, 0x867B, 0x86A8, 0x868D, 	/* 0xF2B0 to 0xF2B7 */ 
0x868B, 0x86AC, 0x869D, 0x86A7, 0x86A3, 0x86AA, 0x8693, 0x86A9, 	/* 0xF2B8 to 0xF2BF */ 
0x86B6, 0x86C4, 0x86B5, 0x86CE, 0x86B0, 0x86BA, 0x86B1, 0x86AF, 	/* 0xF2C0 to 0xF2C7 */ 
0x86C9, 0x86CF, 0x86B4, 0x86E9, 0x86F1, 0x86F2, 0x86ED, 0x86F3, 	/* 0xF2C8 to 0xF2CF */ 
0x86D0, 0x8713, 0x86DE, 0x86F4, 0x86DF, 0x86D8, 0x86D1, 0x8703, 	/* 0xF2D0 to 0xF2D7 */ 
0x8707, 0x86F8, 0x8708, 0x870A, 0x870D, 0x8709, 0x8723, 0x873B, 	/* 0xF2D8 to 0xF2DF */ 
0x871E, 0x8725, 0x872E, 0x871A, 0x873E, 0x8748, 0x8734, 0x8731, 	/* 0xF2E0 to 0xF2E7 */ 
0x8729, 0x8737, 0x873F, 0x8782, 0x8722, 0x877D, 0x877E, 0x877B, 	/* 0xF2E8 to 0xF2EF */ 
0x8760, 0x8770, 0x874C, 0x876E, 0x878B, 0x8753, 0x8763, 0x877C, 	/* 0xF2F0 to 0xF2F7 */ 
0x8764, 0x8759, 0x8765, 0x8793, 0x87AF, 0x87A8, 0x87D2, 0x0000, 	/* 0xF2F8 to 0xF2FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF300 to 0xF307 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF308 to 0xF30F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF310 to 0xF317 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF318 to 0xF31F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF320 to 0xF327 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF328 to 0xF32F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF330 to 0xF337 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF338 to 0xF33F */ 
0x9A5A, 0x9A5B, 0x9A5C, 0x9A5D, 0x9A5E, 0x9A5F, 0x9A60, 0x9A61, 	/* 0xF340 to 0xF347 */ 
0x9A62, 0x9A63, 0x9A64, 0x9A65, 0x9A66, 0x9A67, 0x9A68, 0x9A69, 	/* 0xF348 to 0xF34F */ 
0x9A6A, 0x9A6B, 0x9A72, 0x9A83, 0x9A89, 0x9A8D, 0x9A8E, 0x9A94, 	/* 0xF350 to 0xF357 */ 
0x9A95, 0x9A99, 0x9AA6, 0x9AA9, 0x9AAA, 0x9AAB, 0x9AAC, 0x9AAD, 	/* 0xF358 to 0xF35F */ 
0x9AAE, 0x9AAF, 0x9AB2, 0x9AB3, 0x9AB4, 0x9AB5, 0x9AB9, 0x9ABB, 	/* 0xF360 to 0xF367 */ 
0x9ABD, 0x9ABE, 0x9ABF, 0x9AC3, 0x9AC4, 0x9AC6, 0x9AC7, 0x9AC8, 	/* 0xF368 to 0xF36F */ 
0x9AC9, 0x9ACA, 0x9ACD, 0x9ACE, 0x9ACF, 0x9AD0, 0x9AD2, 0x9AD4, 	/* 0xF370 to 0xF377 */ 
0x9AD5, 0x9AD6, 0x9AD7, 0x9AD9, 0x9ADA, 0x9ADB, 0x9ADC, 0x0000, 	/* 0xF378 to 0xF37F */ 
0x9ADD, 0x9ADE, 0x9AE0, 0x9AE2, 0x9AE3, 0x9AE4, 0x9AE5, 0x9AE7, 	/* 0xF380 to 0xF387 */ 
0x9AE8, 0x9AE9, 0x9AEA, 0x9AEC, 0x9AEE, 0x9AF0, 0x9AF1, 0x9AF2, 	/* 0xF388 to 0xF38F */ 
0x9AF3, 0x9AF4, 0x9AF5, 0x9AF6, 0x9AF7, 0x9AF8, 0x9AFA, 0x9AFC, 	/* 0xF390 to 0xF397 */ 
0x9AFD, 0x9AFE, 0x9AFF, 0x9B00, 0x9B01, 0x9B02, 0x9B04, 0x9B05, 	/* 0xF398 to 0xF39F */ 
0x9B06, 0x87C6, 0x8788, 0x8785, 0x87AD, 0x8797, 0x8783, 0x87AB, 	/* 0xF3A0 to 0xF3A7 */ 
0x87E5, 0x87AC, 0x87B5, 0x87B3, 0x87CB, 0x87D3, 0x87BD, 0x87D1, 	/* 0xF3A8 to 0xF3AF */ 
0x87C0, 0x87CA, 0x87DB, 0x87EA, 0x87E0, 0x87EE, 0x8816, 0x8813, 	/* 0xF3B0 to 0xF3B7 */ 
0x87FE, 0x880A, 0x881B, 0x8821, 0x8839, 0x883C, 0x7F36, 0x7F42, 	/* 0xF3B8 to 0xF3BF */ 
0x7F44, 0x7F45, 0x8210, 0x7AFA, 0x7AFD, 0x7B08, 0x7B03, 0x7B04, 	/* 0xF3C0 to 0xF3C7 */ 
0x7B15, 0x7B0A, 0x7B2B, 0x7B0F, 0x7B47, 0x7B38, 0x7B2A, 0x7B19, 	/* 0xF3C8 to 0xF3CF */ 
0x7B2E, 0x7B31, 0x7B20, 0x7B25, 0x7B24, 0x7B33, 0x7B3E, 0x7B1E, 	/* 0xF3D0 to 0xF3D7 */ 
0x7B58, 0x7B5A, 0x7B45, 0x7B75, 0x7B4C, 0x7B5D, 0x7B60, 0x7B6E, 	/* 0xF3D8 to 0xF3DF */ 
0x7B7B, 0x7B62, 0x7B72, 0x7B71, 0x7B90, 0x7BA6, 0x7BA7, 0x7BB8, 	/* 0xF3E0 to 0xF3E7 */ 
0x7BAC, 0x7B9D, 0x7BA8, 0x7B85, 0x7BAA, 0x7B9C, 0x7BA2, 0x7BAB, 	/* 0xF3E8 to 0xF3EF */ 
0x7BB4, 0x7BD1, 0x7BC1, 0x7BCC, 0x7BDD, 0x7BDA, 0x7BE5, 0x7BE6, 	/* 0xF3F0 to 0xF3F7 */ 
0x7BEA, 0x7C0C, 0x7BFE, 0x7BFC, 0x7C0F, 0x7C16, 0x7C0B, 0x0000, 	/* 0xF3F8 to 0xF3FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF400 to 0xF407 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF408 to 0xF40F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF410 to 0xF417 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF418 to 0xF41F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF420 to 0xF427 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF428 to 0xF42F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF430 to 0xF437 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF438 to 0xF43F */ 
0x9B07, 0x9B09, 0x9B0A, 0x9B0B, 0x9B0C, 0x9B0D, 0x9B0E, 0x9B10, 	/* 0xF440 to 0xF447 */ 
0x9B11, 0x9B12, 0x9B14, 0x9B15, 0x9B16, 0x9B17, 0x9B18, 0x9B19, 	/* 0xF448 to 0xF44F */ 
0x9B1A, 0x9B1B, 0x9B1C, 0x9B1D, 0x9B1E, 0x9B20, 0x9B21, 0x9B22, 	/* 0xF450 to 0xF457 */ 
0x9B24, 0x9B25, 0x9B26, 0x9B27, 0x9B28, 0x9B29, 0x9B2A, 0x9B2B, 	/* 0xF458 to 0xF45F */ 
0x9B2C, 0x9B2D, 0x9B2E, 0x9B30, 0x9B31, 0x9B33, 0x9B34, 0x9B35, 	/* 0xF460 to 0xF467 */ 
0x9B36, 0x9B37, 0x9B38, 0x9B39, 0x9B3A, 0x9B3D, 0x9B3E, 0x9B3F, 	/* 0xF468 to 0xF46F */ 
0x9B40, 0x9B46, 0x9B4A, 0x9B4B, 0x9B4C, 0x9B4E, 0x9B50, 0x9B52, 	/* 0xF470 to 0xF477 */ 
0x9B53, 0x9B55, 0x9B56, 0x9B57, 0x9B58, 0x9B59, 0x9B5A, 0x0000, 	/* 0xF478 to 0xF47F */ 
0x9B5B, 0x9B5C, 0x9B5D, 0x9B5E, 0x9B5F, 0x9B60, 0x9B61, 0x9B62, 	/* 0xF480 to 0xF487 */ 
0x9B63, 0x9B64, 0x9B65, 0x9B66, 0x9B67, 0x9B68, 0x9B69, 0x9B6A, 	/* 0xF488 to 0xF48F */ 
0x9B6B, 0x9B6C, 0x9B6D, 0x9B6E, 0x9B6F, 0x9B70, 0x9B71, 0x9B72, 	/* 0xF490 to 0xF497 */ 
0x9B73, 0x9B74, 0x9B75, 0x9B76, 0x9B77, 0x9B78, 0x9B79, 0x9B7A, 	/* 0xF498 to 0xF49F */ 
0x9B7B, 0x7C1F, 0x7C2A, 0x7C26, 0x7C38, 0x7C41, 0x7C40, 0x81FE, 	/* 0xF4A0 to 0xF4A7 */ 
0x8201, 0x8202, 0x8204, 0x81EC, 0x8844, 0x8221, 0x8222, 0x8223, 	/* 0xF4A8 to 0xF4AF */ 
0x822D, 0x822F, 0x8228, 0x822B, 0x8238, 0x823B, 0x8233, 0x8234, 	/* 0xF4B0 to 0xF4B7 */ 
0x823E, 0x8244, 0x8249, 0x824B, 0x824F, 0x825A, 0x825F, 0x8268, 	/* 0xF4B8 to 0xF4BF */ 
0x887E, 0x8885, 0x8888, 0x88D8, 0x88DF, 0x895E, 0x7F9D, 0x7F9F, 	/* 0xF4C0 to 0xF4C7 */ 
0x7FA7, 0x7FAF, 0x7FB0, 0x7FB2, 0x7C7C, 0x6549, 0x7C91, 0x7C9D, 	/* 0xF4C8 to 0xF4CF */ 
0x7C9C, 0x7C9E, 0x7CA2, 0x7CB2, 0x7CBC, 0x7CBD, 0x7CC1, 0x7CC7, 	/* 0xF4D0 to 0xF4D7 */ 
0x7CCC, 0x7CCD, 0x7CC8, 0x7CC5, 0x7CD7, 0x7CE8, 0x826E, 0x66A8, 	/* 0xF4D8 to 0xF4DF */ 
0x7FBF, 0x7FCE, 0x7FD5, 0x7FE5, 0x7FE1, 0x7FE6, 0x7FE9, 0x7FEE, 	/* 0xF4E0 to 0xF4E7 */ 
0x7FF3, 0x7CF8, 0x7D77, 0x7DA6, 0x7DAE, 0x7E47, 0x7E9B, 0x9EB8, 	/* 0xF4E8 to 0xF4EF */ 
0x9EB4, 0x8D73, 0x8D84, 0x8D94, 0x8D91, 0x8DB1, 0x8D67, 0x8D6D, 	/* 0xF4F0 to 0xF4F7 */ 
0x8C47, 0x8C49, 0x914A, 0x9150, 0x914E, 0x914F, 0x9164, 0x0000, 	/* 0xF4F8 to 0xF4FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF500 to 0xF507 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF508 to 0xF50F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF510 to 0xF517 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF518 to 0xF51F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF520 to 0xF527 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF528 to 0xF52F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF530 to 0xF537 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF538 to 0xF53F */ 
0x9B7C, 0x9B7D, 0x9B7E, 0x9B7F, 0x9B80, 0x9B81, 0x9B82, 0x9B83, 	/* 0xF540 to 0xF547 */ 
0x9B84, 0x9B85, 0x9B86, 0x9B87, 0x9B88, 0x9B89, 0x9B8A, 0x9B8B, 	/* 0xF548 to 0xF54F */ 
0x9B8C, 0x9B8D, 0x9B8E, 0x9B8F, 0x9B90, 0x9B91, 0x9B92, 0x9B93, 	/* 0xF550 to 0xF557 */ 
0x9B94, 0x9B95, 0x9B96, 0x9B97, 0x9B98, 0x9B99, 0x9B9A, 0x9B9B, 	/* 0xF558 to 0xF55F */ 
0x9B9C, 0x9B9D, 0x9B9E, 0x9B9F, 0x9BA0, 0x9BA1, 0x9BA2, 0x9BA3, 	/* 0xF560 to 0xF567 */ 
0x9BA4, 0x9BA5, 0x9BA6, 0x9BA7, 0x9BA8, 0x9BA9, 0x9BAA, 0x9BAB, 	/* 0xF568 to 0xF56F */ 
0x9BAC, 0x9BAD, 0x9BAE, 0x9BAF, 0x9BB0, 0x9BB1, 0x9BB2, 0x9BB3, 	/* 0xF570 to 0xF577 */ 
0x9BB4, 0x9BB5, 0x9BB6, 0x9BB7, 0x9BB8, 0x9BB9, 0x9BBA, 0x0000, 	/* 0xF578 to 0xF57F */ 
0x9BBB, 0x9BBC, 0x9BBD, 0x9BBE, 0x9BBF, 0x9BC0, 0x9BC1, 0x9BC2, 	/* 0xF580 to 0xF587 */ 
0x9BC3, 0x9BC4, 0x9BC5, 0x9BC6, 0x9BC7, 0x9BC8, 0x9BC9, 0x9BCA, 	/* 0xF588 to 0xF58F */ 
0x9BCB, 0x9BCC, 0x9BCD, 0x9BCE, 0x9BCF, 0x9BD0, 0x9BD1, 0x9BD2, 	/* 0xF590 to 0xF597 */ 
0x9BD3, 0x9BD4, 0x9BD5, 0x9BD6, 0x9BD7, 0x9BD8, 0x9BD9, 0x9BDA, 	/* 0xF598 to 0xF59F */ 
0x9BDB, 0x9162, 0x9161, 0x9170, 0x9169, 0x916F, 0x917D, 0x917E, 	/* 0xF5A0 to 0xF5A7 */ 
0x9172, 0x9174, 0x9179, 0x918C, 0x9185, 0x9190, 0x918D, 0x9191, 	/* 0xF5A8 to 0xF5AF */ 
0x91A2, 0x91A3, 0x91AA, 0x91AD, 0x91AE, 0x91AF, 0x91B5, 0x91B4, 	/* 0xF5B0 to 0xF5B7 */ 
0x91BA, 0x8C55, 0x9E7E, 0x8DB8, 0x8DEB, 0x8E05, 0x8E59, 0x8E69, 	/* 0xF5B8 to 0xF5BF */ 
0x8DB5, 0x8DBF, 0x8DBC, 0x8DBA, 0x8DC4, 0x8DD6, 0x8DD7, 0x8DDA, 	/* 0xF5C0 to 0xF5C7 */ 
0x8DDE, 0x8DCE, 0x8DCF, 0x8DDB, 0x8DC6, 0x8DEC, 0x8DF7, 0x8DF8, 	/* 0xF5C8 to 0xF5CF */ 
0x8DE3, 0x8DF9, 0x8DFB, 0x8DE4, 0x8E09, 0x8DFD, 0x8E14, 0x8E1D, 	/* 0xF5D0 to 0xF5D7 */ 
0x8E1F, 0x8E2C, 0x8E2E, 0x8E23, 0x8E2F, 0x8E3A, 0x8E40, 0x8E39, 	/* 0xF5D8 to 0xF5DF */ 
0x8E35, 0x8E3D, 0x8E31, 0x8E49, 0x8E41, 0x8E42, 0x8E51, 0x8E52, 	/* 0xF5E0 to 0xF5E7 */ 
0x8E4A, 0x8E70, 0x8E76, 0x8E7C, 0x8E6F, 0x8E74, 0x8E85, 0x8E8F, 	/* 0xF5E8 to 0xF5EF */ 
0x8E94, 0x8E90, 0x8E9C, 0x8E9E, 0x8C78, 0x8C82, 0x8C8A, 0x8C85, 	/* 0xF5F0 to 0xF5F7 */ 
0x8C98, 0x8C94, 0x659B, 0x89D6, 0x89DE, 0x89DA, 0x89DC, 0x0000, 	/* 0xF5F8 to 0xF5FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF600 to 0xF607 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF608 to 0xF60F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF610 to 0xF617 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF618 to 0xF61F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF620 to 0xF627 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF628 to 0xF62F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF630 to 0xF637 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF638 to 0xF63F */ 
0x9BDC, 0x9BDD, 0x9BDE, 0x9BDF, 0x9BE0, 0x9BE1, 0x9BE2, 0x9BE3, 	/* 0xF640 to 0xF647 */ 
0x9BE4, 0x9BE5, 0x9BE6, 0x9BE7, 0x9BE8, 0x9BE9, 0x9BEA, 0x9BEB, 	/* 0xF648 to 0xF64F */ 
0x9BEC, 0x9BED, 0x9BEE, 0x9BEF, 0x9BF0, 0x9BF1, 0x9BF2, 0x9BF3, 	/* 0xF650 to 0xF657 */ 
0x9BF4, 0x9BF5, 0x9BF6, 0x9BF7, 0x9BF8, 0x9BF9, 0x9BFA, 0x9BFB, 	/* 0xF658 to 0xF65F */ 
0x9BFC, 0x9BFD, 0x9BFE, 0x9BFF, 0x9C00, 0x9C01, 0x9C02, 0x9C03, 	/* 0xF660 to 0xF667 */ 
0x9C04, 0x9C05, 0x9C06, 0x9C07, 0x9C08, 0x9C09, 0x9C0A, 0x9C0B, 	/* 0xF668 to 0xF66F */ 
0x9C0C, 0x9C0D, 0x9C0E, 0x9C0F, 0x9C10, 0x9C11, 0x9C12, 0x9C13, 	/* 0xF670 to 0xF677 */ 
0x9C14, 0x9C15, 0x9C16, 0x9C17, 0x9C18, 0x9C19, 0x9C1A, 0x0000, 	/* 0xF678 to 0xF67F */ 
0x9C1B, 0x9C1C, 0x9C1D, 0x9C1E, 0x9C1F, 0x9C20, 0x9C21, 0x9C22, 	/* 0xF680 to 0xF687 */ 
0x9C23, 0x9C24, 0x9C25, 0x9C26, 0x9C27, 0x9C28, 0x9C29, 0x9C2A, 	/* 0xF688 to 0xF68F */ 
0x9C2B, 0x9C2C, 0x9C2D, 0x9C2E, 0x9C2F, 0x9C30, 0x9C31, 0x9C32, 	/* 0xF690 to 0xF697 */ 
0x9C33, 0x9C34, 0x9C35, 0x9C36, 0x9C37, 0x9C38, 0x9C39, 0x9C3A, 	/* 0xF698 to 0xF69F */ 
0x9C3B, 0x89E5, 0x89EB, 0x89EF, 0x8A3E, 0x8B26, 0x9753, 0x96E9, 	/* 0xF6A0 to 0xF6A7 */ 
0x96F3, 0x96EF, 0x9706, 0x9701, 0x9708, 0x970F, 0x970E, 0x972A, 	/* 0xF6A8 to 0xF6AF */ 
0x972D, 0x9730, 0x973E, 0x9F80, 0x9F83, 0x9F85, 0x9F86, 0x9F87, 	/* 0xF6B0 to 0xF6B7 */ 
0x9F88, 0x9F89, 0x9F8A, 0x9F8C, 0x9EFE, 0x9F0B, 0x9F0D, 0x96B9, 	/* 0xF6B8 to 0xF6BF */ 
0x96BC, 0x96BD, 0x96CE, 0x96D2, 0x77BF, 0x96E0, 0x928E, 0x92AE, 	/* 0xF6C0 to 0xF6C7 */ 
0x92C8, 0x933E, 0x936A, 0x93CA, 0x938F, 0x943E, 0x946B, 0x9C7F, 	/* 0xF6C8 to 0xF6CF */ 
0x9C82, 0x9C85, 0x9C86, 0x9C87, 0x9C88, 0x7A23, 0x9C8B, 0x9C8E, 	/* 0xF6D0 to 0xF6D7 */ 
0x9C90, 0x9C91, 0x9C92, 0x9C94, 0x9C95, 0x9C9A, 0x9C9B, 0x9C9E, 	/* 0xF6D8 to 0xF6DF */ 
0x9C9F, 0x9CA0, 0x9CA1, 0x9CA2, 0x9CA3, 0x9CA5, 0x9CA6, 0x9CA7, 	/* 0xF6E0 to 0xF6E7 */ 
0x9CA8, 0x9CA9, 0x9CAB, 0x9CAD, 0x9CAE, 0x9CB0, 0x9CB1, 0x9CB2, 	/* 0xF6E8 to 0xF6EF */ 
0x9CB3, 0x9CB4, 0x9CB5, 0x9CB6, 0x9CB7, 0x9CBA, 0x9CBB, 0x9CBC, 	/* 0xF6F0 to 0xF6F7 */ 
0x9CBD, 0x9CC4, 0x9CC5, 0x9CC6, 0x9CC7, 0x9CCA, 0x9CCB, 0x0000, 	/* 0xF6F8 to 0xF6FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF700 to 0xF707 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF708 to 0xF70F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF710 to 0xF717 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF718 to 0xF71F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF720 to 0xF727 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF728 to 0xF72F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF730 to 0xF737 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF738 to 0xF73F */ 
0x9C3C, 0x9C3D, 0x9C3E, 0x9C3F, 0x9C40, 0x9C41, 0x9C42, 0x9C43, 	/* 0xF740 to 0xF747 */ 
0x9C44, 0x9C45, 0x9C46, 0x9C47, 0x9C48, 0x9C49, 0x9C4A, 0x9C4B, 	/* 0xF748 to 0xF74F */ 
0x9C4C, 0x9C4D, 0x9C4E, 0x9C4F, 0x9C50, 0x9C51, 0x9C52, 0x9C53, 	/* 0xF750 to 0xF757 */ 
0x9C54, 0x9C55, 0x9C56, 0x9C57, 0x9C58, 0x9C59, 0x9C5A, 0x9C5B, 	/* 0xF758 to 0xF75F */ 
0x9C5C, 0x9C5D, 0x9C5E, 0x9C5F, 0x9C60, 0x9C61, 0x9C62, 0x9C63, 	/* 0xF760 to 0xF767 */ 
0x9C64, 0x9C65, 0x9C66, 0x9C67, 0x9C68, 0x9C69, 0x9C6A, 0x9C6B, 	/* 0xF768 to 0xF76F */ 
0x9C6C, 0x9C6D, 0x9C6E, 0x9C6F, 0x9C70, 0x9C71, 0x9C72, 0x9C73, 	/* 0xF770 to 0xF777 */ 
0x9C74, 0x9C75, 0x9C76, 0x9C77, 0x9C78, 0x9C79, 0x9C7A, 0x0000, 	/* 0xF778 to 0xF77F */ 
0x9C7B, 0x9C7D, 0x9C7E, 0x9C80, 0x9C83, 0x9C84, 0x9C89, 0x9C8A, 	/* 0xF780 to 0xF787 */ 
0x9C8C, 0x9C8F, 0x9C93, 0x9C96, 0x9C97, 0x9C98, 0x9C99, 0x9C9D, 	/* 0xF788 to 0xF78F */ 
0x9CAA, 0x9CAC, 0x9CAF, 0x9CB9, 0x9CBE, 0x9CBF, 0x9CC0, 0x9CC1, 	/* 0xF790 to 0xF797 */ 
0x9CC2, 0x9CC8, 0x9CC9, 0x9CD1, 0x9CD2, 0x9CDA, 0x9CDB, 0x9CE0, 	/* 0xF798 to 0xF79F */ 
0x9CE1, 0x9CCC, 0x9CCD, 0x9CCE, 0x9CCF, 0x9CD0, 0x9CD3, 0x9CD4, 	/* 0xF7A0 to 0xF7A7 */ 
0x9CD5, 0x9CD7, 0x9CD8, 0x9CD9, 0x9CDC, 0x9CDD, 0x9CDF, 0x9CE2, 	/* 0xF7A8 to 0xF7AF */ 
0x977C, 0x9785, 0x9791, 0x9792, 0x9794, 0x97AF, 0x97AB, 0x97A3, 	/* 0xF7B0 to 0xF7B7 */ 
0x97B2, 0x97B4, 0x9AB1, 0x9AB0, 0x9AB7, 0x9E58, 0x9AB6, 0x9ABA, 	/* 0xF7B8 to 0xF7BF */ 
0x9ABC, 0x9AC1, 0x9AC0, 0x9AC5, 0x9AC2, 0x9ACB, 0x9ACC, 0x9AD1, 	/* 0xF7C0 to 0xF7C7 */ 
0x9B45, 0x9B43, 0x9B47, 0x9B49, 0x9B48, 0x9B4D, 0x9B51, 0x98E8, 	/* 0xF7C8 to 0xF7CF */ 
0x990D, 0x992E, 0x9955, 0x9954, 0x9ADF, 0x9AE1, 0x9AE6, 0x9AEF, 	/* 0xF7D0 to 0xF7D7 */ 
0x9AEB, 0x9AFB, 0x9AED, 0x9AF9, 0x9B08, 0x9B0F, 0x9B13, 0x9B1F, 	/* 0xF7D8 to 0xF7DF */ 
0x9B23, 0x9EBD, 0x9EBE, 0x7E3B, 0x9E82, 0x9E87, 0x9E88, 0x9E8B, 	/* 0xF7E0 to 0xF7E7 */ 
0x9E92, 0x93D6, 0x9E9D, 0x9E9F, 0x9EDB, 0x9EDC, 0x9EDD, 0x9EE0, 	/* 0xF7E8 to 0xF7EF */ 
0x9EDF, 0x9EE2, 0x9EE9, 0x9EE7, 0x9EE5, 0x9EEA, 0x9EEF, 0x9F22, 	/* 0xF7F0 to 0xF7F7 */ 
0x9F2C, 0x9F2F, 0x9F39, 0x9F37, 0x9F3D, 0x9F3E, 0x9F44, 0x0000, 	/* 0xF7F8 to 0xF7FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF800 to 0xF807 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF808 to 0xF80F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF810 to 0xF817 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF818 to 0xF81F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF820 to 0xF827 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF828 to 0xF82F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF830 to 0xF837 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF838 to 0xF83F */ 
0x9CE3, 0x9CE4, 0x9CE5, 0x9CE6, 0x9CE7, 0x9CE8, 0x9CE9, 0x9CEA, 	/* 0xF840 to 0xF847 */ 
0x9CEB, 0x9CEC, 0x9CED, 0x9CEE, 0x9CEF, 0x9CF0, 0x9CF1, 0x9CF2, 	/* 0xF848 to 0xF84F */ 
0x9CF3, 0x9CF4, 0x9CF5, 0x9CF6, 0x9CF7, 0x9CF8, 0x9CF9, 0x9CFA, 	/* 0xF850 to 0xF857 */ 
0x9CFB, 0x9CFC, 0x9CFD, 0x9CFE, 0x9CFF, 0x9D00, 0x9D01, 0x9D02, 	/* 0xF858 to 0xF85F */ 
0x9D03, 0x9D04, 0x9D05, 0x9D06, 0x9D07, 0x9D08, 0x9D09, 0x9D0A, 	/* 0xF860 to 0xF867 */ 
0x9D0B, 0x9D0C, 0x9D0D, 0x9D0E, 0x9D0F, 0x9D10, 0x9D11, 0x9D12, 	/* 0xF868 to 0xF86F */ 
0x9D13, 0x9D14, 0x9D15, 0x9D16, 0x9D17, 0x9D18, 0x9D19, 0x9D1A, 	/* 0xF870 to 0xF877 */ 
0x9D1B, 0x9D1C, 0x9D1D, 0x9D1E, 0x9D1F, 0x9D20, 0x9D21, 0x0000, 	/* 0xF878 to 0xF87F */ 
0x9D22, 0x9D23, 0x9D24, 0x9D25, 0x9D26, 0x9D27, 0x9D28, 0x9D29, 	/* 0xF880 to 0xF887 */ 
0x9D2A, 0x9D2B, 0x9D2C, 0x9D2D, 0x9D2E, 0x9D2F, 0x9D30, 0x9D31, 	/* 0xF888 to 0xF88F */ 
0x9D32, 0x9D33, 0x9D34, 0x9D35, 0x9D36, 0x9D37, 0x9D38, 0x9D39, 	/* 0xF890 to 0xF897 */ 
0x9D3A, 0x9D3B, 0x9D3C, 0x9D3D, 0x9D3E, 0x9D3F, 0x9D40, 0x9D41, 	/* 0xF898 to 0xF89F */ 
0x9D42, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8A0 to 0xF8A7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8A8 to 0xF8AF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8B0 to 0xF8B7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8B8 to 0xF8BF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8C0 to 0xF8C7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8C8 to 0xF8CF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8D0 to 0xF8D7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8D8 to 0xF8DF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8E0 to 0xF8E7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8E8 to 0xF8EF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8F0 to 0xF8F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF8F8 to 0xF8FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF900 to 0xF907 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF908 to 0xF90F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF910 to 0xF917 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF918 to 0xF91F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF920 to 0xF927 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF928 to 0xF92F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF930 to 0xF937 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF938 to 0xF93F */ 
0x9D43, 0x9D44, 0x9D45, 0x9D46, 0x9D47, 0x9D48, 0x9D49, 0x9D4A, 	/* 0xF940 to 0xF947 */ 
0x9D4B, 0x9D4C, 0x9D4D, 0x9D4E, 0x9D4F, 0x9D50, 0x9D51, 0x9D52, 	/* 0xF948 to 0xF94F */ 
0x9D53, 0x9D54, 0x9D55, 0x9D56, 0x9D57, 0x9D58, 0x9D59, 0x9D5A, 	/* 0xF950 to 0xF957 */ 
0x9D5B, 0x9D5C, 0x9D5D, 0x9D5E, 0x9D5F, 0x9D60, 0x9D61, 0x9D62, 	/* 0xF958 to 0xF95F */ 
0x9D63, 0x9D64, 0x9D65, 0x9D66, 0x9D67, 0x9D68, 0x9D69, 0x9D6A, 	/* 0xF960 to 0xF967 */ 
0x9D6B, 0x9D6C, 0x9D6D, 0x9D6E, 0x9D6F, 0x9D70, 0x9D71, 0x9D72, 	/* 0xF968 to 0xF96F */ 
0x9D73, 0x9D74, 0x9D75, 0x9D76, 0x9D77, 0x9D78, 0x9D79, 0x9D7A, 	/* 0xF970 to 0xF977 */ 
0x9D7B, 0x9D7C, 0x9D7D, 0x9D7E, 0x9D7F, 0x9D80, 0x9D81, 0x0000, 	/* 0xF978 to 0xF97F */ 
0x9D82, 0x9D83, 0x9D84, 0x9D85, 0x9D86, 0x9D87, 0x9D88, 0x9D89, 	/* 0xF980 to 0xF987 */ 
0x9D8A, 0x9D8B, 0x9D8C, 0x9D8D, 0x9D8E, 0x9D8F, 0x9D90, 0x9D91, 	/* 0xF988 to 0xF98F */ 
0x9D92, 0x9D93, 0x9D94, 0x9D95, 0x9D96, 0x9D97, 0x9D98, 0x9D99, 	/* 0xF990 to 0xF997 */ 
0x9D9A, 0x9D9B, 0x9D9C, 0x9D9D, 0x9D9E, 0x9D9F, 0x9DA0, 0x9DA1, 	/* 0xF998 to 0xF99F */ 
0x9DA2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9A0 to 0xF9A7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9A8 to 0xF9AF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9B0 to 0xF9B7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9B8 to 0xF9BF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9C0 to 0xF9C7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9C8 to 0xF9CF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9D0 to 0xF9D7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9D8 to 0xF9DF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9E0 to 0xF9E7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9E8 to 0xF9EF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9F0 to 0xF9F7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF9F8 to 0xF9FF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA00 to 0xFA07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA08 to 0xFA0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA10 to 0xFA17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA18 to 0xFA1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA20 to 0xFA27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA28 to 0xFA2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA30 to 0xFA37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA38 to 0xFA3F */ 
0x9DA3, 0x9DA4, 0x9DA5, 0x9DA6, 0x9DA7, 0x9DA8, 0x9DA9, 0x9DAA, 	/* 0xFA40 to 0xFA47 */ 
0x9DAB, 0x9DAC, 0x9DAD, 0x9DAE, 0x9DAF, 0x9DB0, 0x9DB1, 0x9DB2, 	/* 0xFA48 to 0xFA4F */ 
0x9DB3, 0x9DB4, 0x9DB5, 0x9DB6, 0x9DB7, 0x9DB8, 0x9DB9, 0x9DBA, 	/* 0xFA50 to 0xFA57 */ 
0x9DBB, 0x9DBC, 0x9DBD, 0x9DBE, 0x9DBF, 0x9DC0, 0x9DC1, 0x9DC2, 	/* 0xFA58 to 0xFA5F */ 
0x9DC3, 0x9DC4, 0x9DC5, 0x9DC6, 0x9DC7, 0x9DC8, 0x9DC9, 0x9DCA, 	/* 0xFA60 to 0xFA67 */ 
0x9DCB, 0x9DCC, 0x9DCD, 0x9DCE, 0x9DCF, 0x9DD0, 0x9DD1, 0x9DD2, 	/* 0xFA68 to 0xFA6F */ 
0x9DD3, 0x9DD4, 0x9DD5, 0x9DD6, 0x9DD7, 0x9DD8, 0x9DD9, 0x9DDA, 	/* 0xFA70 to 0xFA77 */ 
0x9DDB, 0x9DDC, 0x9DDD, 0x9DDE, 0x9DDF, 0x9DE0, 0x9DE1, 0x0000, 	/* 0xFA78 to 0xFA7F */ 
0x9DE2, 0x9DE3, 0x9DE4, 0x9DE5, 0x9DE6, 0x9DE7, 0x9DE8, 0x9DE9, 	/* 0xFA80 to 0xFA87 */ 
0x9DEA, 0x9DEB, 0x9DEC, 0x9DED, 0x9DEE, 0x9DEF, 0x9DF0, 0x9DF1, 	/* 0xFA88 to 0xFA8F */ 
0x9DF2, 0x9DF3, 0x9DF4, 0x9DF5, 0x9DF6, 0x9DF7, 0x9DF8, 0x9DF9, 	/* 0xFA90 to 0xFA97 */ 
0x9DFA, 0x9DFB, 0x9DFC, 0x9DFD, 0x9DFE, 0x9DFF, 0x9E00, 0x9E01, 	/* 0xFA98 to 0xFA9F */ 
0x9E02, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAA0 to 0xFAA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAA8 to 0xFAAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAB0 to 0xFAB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAB8 to 0xFABF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAC0 to 0xFAC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAC8 to 0xFACF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAD0 to 0xFAD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAD8 to 0xFADF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAE0 to 0xFAE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAE8 to 0xFAEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAF0 to 0xFAF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFAF8 to 0xFAFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB00 to 0xFB07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB08 to 0xFB0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB10 to 0xFB17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB18 to 0xFB1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB20 to 0xFB27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB28 to 0xFB2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB30 to 0xFB37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB38 to 0xFB3F */ 
0x9E03, 0x9E04, 0x9E05, 0x9E06, 0x9E07, 0x9E08, 0x9E09, 0x9E0A, 	/* 0xFB40 to 0xFB47 */ 
0x9E0B, 0x9E0C, 0x9E0D, 0x9E0E, 0x9E0F, 0x9E10, 0x9E11, 0x9E12, 	/* 0xFB48 to 0xFB4F */ 
0x9E13, 0x9E14, 0x9E15, 0x9E16, 0x9E17, 0x9E18, 0x9E19, 0x9E1A, 	/* 0xFB50 to 0xFB57 */ 
0x9E1B, 0x9E1C, 0x9E1D, 0x9E1E, 0x9E24, 0x9E27, 0x9E2E, 0x9E30, 	/* 0xFB58 to 0xFB5F */ 
0x9E34, 0x9E3B, 0x9E3C, 0x9E40, 0x9E4D, 0x9E50, 0x9E52, 0x9E53, 	/* 0xFB60 to 0xFB67 */ 
0x9E54, 0x9E56, 0x9E59, 0x9E5D, 0x9E5F, 0x9E60, 0x9E61, 0x9E62, 	/* 0xFB68 to 0xFB6F */ 
0x9E65, 0x9E6E, 0x9E6F, 0x9E72, 0x9E74, 0x9E75, 0x9E76, 0x9E77, 	/* 0xFB70 to 0xFB77 */ 
0x9E78, 0x9E79, 0x9E7A, 0x9E7B, 0x9E7C, 0x9E7D, 0x9E80, 0x0000, 	/* 0xFB78 to 0xFB7F */ 
0x9E81, 0x9E83, 0x9E84, 0x9E85, 0x9E86, 0x9E89, 0x9E8A, 0x9E8C, 	/* 0xFB80 to 0xFB87 */ 
0x9E8D, 0x9E8E, 0x9E8F, 0x9E90, 0x9E91, 0x9E94, 0x9E95, 0x9E96, 	/* 0xFB88 to 0xFB8F */ 
0x9E97, 0x9E98, 0x9E99, 0x9E9A, 0x9E9B, 0x9E9C, 0x9E9E, 0x9EA0, 	/* 0xFB90 to 0xFB97 */ 
0x9EA1, 0x9EA2, 0x9EA3, 0x9EA4, 0x9EA5, 0x9EA7, 0x9EA8, 0x9EA9, 	/* 0xFB98 to 0xFB9F */ 
0x9EAA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBA0 to 0xFBA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBA8 to 0xFBAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBB0 to 0xFBB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBB8 to 0xFBBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBC0 to 0xFBC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBC8 to 0xFBCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBD0 to 0xFBD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBD8 to 0xFBDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBE0 to 0xFBE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBE8 to 0xFBEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBF0 to 0xFBF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFBF8 to 0xFBFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC00 to 0xFC07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC08 to 0xFC0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC10 to 0xFC17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC18 to 0xFC1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC20 to 0xFC27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC28 to 0xFC2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC30 to 0xFC37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC38 to 0xFC3F */ 
0x9EAB, 0x9EAC, 0x9EAD, 0x9EAE, 0x9EAF, 0x9EB0, 0x9EB1, 0x9EB2, 	/* 0xFC40 to 0xFC47 */ 
0x9EB3, 0x9EB5, 0x9EB6, 0x9EB7, 0x9EB9, 0x9EBA, 0x9EBC, 0x9EBF, 	/* 0xFC48 to 0xFC4F */ 
0x9EC0, 0x9EC1, 0x9EC2, 0x9EC3, 0x9EC5, 0x9EC6, 0x9EC7, 0x9EC8, 	/* 0xFC50 to 0xFC57 */ 
0x9ECA, 0x9ECB, 0x9ECC, 0x9ED0, 0x9ED2, 0x9ED3, 0x9ED5, 0x9ED6, 	/* 0xFC58 to 0xFC5F */ 
0x9ED7, 0x9ED9, 0x9EDA, 0x9EDE, 0x9EE1, 0x9EE3, 0x9EE4, 0x9EE6, 	/* 0xFC60 to 0xFC67 */ 
0x9EE8, 0x9EEB, 0x9EEC, 0x9EED, 0x9EEE, 0x9EF0, 0x9EF1, 0x9EF2, 	/* 0xFC68 to 0xFC6F */ 
0x9EF3, 0x9EF4, 0x9EF5, 0x9EF6, 0x9EF7, 0x9EF8, 0x9EFA, 0x9EFD, 	/* 0xFC70 to 0xFC77 */ 
0x9EFF, 0x9F00, 0x9F01, 0x9F02, 0x9F03, 0x9F04, 0x9F05, 0x0000, 	/* 0xFC78 to 0xFC7F */ 
0x9F06, 0x9F07, 0x9F08, 0x9F09, 0x9F0A, 0x9F0C, 0x9F0F, 0x9F11, 	/* 0xFC80 to 0xFC87 */ 
0x9F12, 0x9F14, 0x9F15, 0x9F16, 0x9F18, 0x9F1A, 0x9F1B, 0x9F1C, 	/* 0xFC88 to 0xFC8F */ 
0x9F1D, 0x9F1E, 0x9F1F, 0x9F21, 0x9F23, 0x9F24, 0x9F25, 0x9F26, 	/* 0xFC90 to 0xFC97 */ 
0x9F27, 0x9F28, 0x9F29, 0x9F2A, 0x9F2B, 0x9F2D, 0x9F2E, 0x9F30, 	/* 0xFC98 to 0xFC9F */ 
0x9F31, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCA0 to 0xFCA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCA8 to 0xFCAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCB0 to 0xFCB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCB8 to 0xFCBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCC0 to 0xFCC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCC8 to 0xFCCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCD0 to 0xFCD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCD8 to 0xFCDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCE0 to 0xFCE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCE8 to 0xFCEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCF0 to 0xFCF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFCF8 to 0xFCFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD00 to 0xFD07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD08 to 0xFD0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD10 to 0xFD17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD18 to 0xFD1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD20 to 0xFD27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD28 to 0xFD2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD30 to 0xFD37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD38 to 0xFD3F */ 
0x9F32, 0x9F33, 0x9F34, 0x9F35, 0x9F36, 0x9F38, 0x9F3A, 0x9F3C, 	/* 0xFD40 to 0xFD47 */ 
0x9F3F, 0x9F40, 0x9F41, 0x9F42, 0x9F43, 0x9F45, 0x9F46, 0x9F47, 	/* 0xFD48 to 0xFD4F */ 
0x9F48, 0x9F49, 0x9F4A, 0x9F4B, 0x9F4C, 0x9F4D, 0x9F4E, 0x9F4F, 	/* 0xFD50 to 0xFD57 */ 
0x9F52, 0x9F53, 0x9F54, 0x9F55, 0x9F56, 0x9F57, 0x9F58, 0x9F59, 	/* 0xFD58 to 0xFD5F */ 
0x9F5A, 0x9F5B, 0x9F5C, 0x9F5D, 0x9F5E, 0x9F5F, 0x9F60, 0x9F61, 	/* 0xFD60 to 0xFD67 */ 
0x9F62, 0x9F63, 0x9F64, 0x9F65, 0x9F66, 0x9F67, 0x9F68, 0x9F69, 	/* 0xFD68 to 0xFD6F */ 
0x9F6A, 0x9F6B, 0x9F6C, 0x9F6D, 0x9F6E, 0x9F6F, 0x9F70, 0x9F71, 	/* 0xFD70 to 0xFD77 */ 
0x9F72, 0x9F73, 0x9F74, 0x9F75, 0x9F76, 0x9F77, 0x9F78, 0x0000, 	/* 0xFD78 to 0xFD7F */ 
0x9F79, 0x9F7A, 0x9F7B, 0x9F7C, 0x9F7D, 0x9F7E, 0x9F81, 0x9F82, 	/* 0xFD80 to 0xFD87 */ 
0x9F8D, 0x9F8E, 0x9F8F, 0x9F90, 0x9F91, 0x9F92, 0x9F93, 0x9F94, 	/* 0xFD88 to 0xFD8F */ 
0x9F95, 0x9F96, 0x9F97, 0x9F98, 0x9F9C, 0x9F9D, 0x9F9E, 0x9FA1, 	/* 0xFD90 to 0xFD97 */ 
0x9FA2, 0x9FA3, 0x9FA4, 0x9FA5, 0xF92C, 0xF979, 0xF995, 0xF9E7, 	/* 0xFD98 to 0xFD9F */ 
0xF9F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDA0 to 0xFDA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDA8 to 0xFDAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDB0 to 0xFDB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDB8 to 0xFDBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDC0 to 0xFDC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDC8 to 0xFDCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDD0 to 0xFDD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDD8 to 0xFDDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDE0 to 0xFDE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDE8 to 0xFDEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDF0 to 0xFDF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFDF8 to 0xFDFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE00 to 0xFE07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE08 to 0xFE0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE10 to 0xFE17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE18 to 0xFE1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE20 to 0xFE27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE28 to 0xFE2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE30 to 0xFE37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE38 to 0xFE3F */ 
0xFA0C, 0xFA0D, 0xFA0E, 0xFA0F, 0xFA11, 0xFA13, 0xFA14, 0xFA18, 	/* 0xFE40 to 0xFE47 */ 
0xFA1F, 0xFA20, 0xFA21, 0xFA23, 0xFA24, 0xFA27, 0xFA28, 0xFA29, 	/* 0xFE48 to 0xFE4F */ 
0x2E81, 0xE816, 0xE817, 0xE818, 0x2E84, 0x3473, 0x3447, 0x2E88, 	/* 0xFE50 to 0xFE57 */ 
0x2E8B, 0x9FB4, 0x359E, 0x361A, 0x360E, 0x2E8C, 0x2E97, 0x396E, 	/* 0xFE58 to 0xFE5F */ 
0x3918, 0x9FB5, 0x39CF, 0x39DF, 0x3A73, 0x39D0, 0x9FB6, 0x9FB7, 	/* 0xFE60 to 0xFE67 */ 
0x3B4E, 0x3C6E, 0x3CE0, 0x2EA7, 0xE831, 0x9FB8, 0x2EAA, 0x4056, 	/* 0xFE68 to 0xFE6F */ 
0x415F, 0x2EAE, 0x4337, 0x2EB3, 0x2EB6, 0x2EB7, 0xE83B, 0x43B1, 	/* 0xFE70 to 0xFE77 */ 
0x43AC, 0x2EBB, 0x43DD, 0x44D6, 0x4661, 0x464C, 0x9FB9, 0x0000, 	/* 0xFE78 to 0xFE7F */ 
0x4723, 0x4729, 0x477C, 0x478D, 0x2ECA, 0x4947, 0x497A, 0x497D, 	/* 0xFE80 to 0xFE87 */ 
0x4982, 0x4983, 0x4985, 0x4986, 0x499F, 0x499B, 0x49B7, 0x49B6, 	/* 0xFE88 to 0xFE8F */ 
0x9FBA, 0xE855, 0x4CA3, 0x4C9F, 0x4CA0, 0x4CA1, 0x4C77, 0x4CA2, 	/* 0xFE90 to 0xFE97 */ 
0x4D13, 0x4D14, 0x4D15, 0x4D16, 0x4D17, 0x4D18, 0x4D19, 0x4DAE, 	/* 0xFE98 to 0xFE9F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEA0 to 0xFEA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEA8 to 0xFEAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEB0 to 0xFEB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEB8 to 0xFEBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEC0 to 0xFEC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEC8 to 0xFECF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFED0 to 0xFED7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFED8 to 0xFEDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEE0 to 0xFEE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEE8 to 0xFEEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEF0 to 0xFEF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFEF8 to 0xFEFF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF00 to 0xFF07 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF08 to 0xFF0F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF10 to 0xFF17 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF18 to 0xFF1F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF20 to 0xFF27 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF28 to 0xFF2F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF30 to 0xFF37 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF38 to 0xFF3F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF40 to 0xFF47 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF48 to 0xFF4F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF50 to 0xFF57 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF58 to 0xFF5F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF60 to 0xFF67 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF68 to 0xFF6F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF70 to 0xFF77 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF78 to 0xFF7F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF80 to 0xFF87 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF88 to 0xFF8F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF90 to 0xFF97 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF98 to 0xFF9F */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFA0 to 0xFFA7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFA8 to 0xFFAF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFB0 to 0xFFB7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFB8 to 0xFFBF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFC0 to 0xFFC7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFC8 to 0xFFCF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFD0 to 0xFFD7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFD8 to 0xFFDF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFE0 to 0xFFE7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFE8 to 0xFFEF */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFF0 to 0xFFF7 */ 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFF8 to 0xFFFF */ 
};

static unsigned short B2U[32768] = {
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8000 to 0x8007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8008 to 0x800F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8010 to 0x8017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8018 to 0x801F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8020 to 0x8027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8028 to 0x802F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8030 to 0x8037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8038 to 0x803F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8040 to 0x8047 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8048 to 0x804F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8050 to 0x8057 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8058 to 0x805F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8060 to 0x8067 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8068 to 0x806F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8070 to 0x8077 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8078 to 0x807F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8080 to 0x8087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8088 to 0x808F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8090 to 0x8097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8098 to 0x809F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80A0 to 0x80A7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80A8 to 0x80AF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80B0 to 0x80B7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80B8 to 0x80BF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80C0 to 0x80C7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80C8 to 0x80CF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80D0 to 0x80D7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80D8 to 0x80DF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80E0 to 0x80E7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80E8 to 0x80EF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80F0 to 0x80F7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x80F8 to 0x80FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8100 to 0x8107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8108 to 0x810F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8110 to 0x8117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8118 to 0x811F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8120 to 0x8127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8128 to 0x812F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8130 to 0x8137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8138 to 0x813F */
0x4E17, 0x4E22, 0x4E2C, 0x4E55, 0x4E62, 0x4E8A, 0x4EB0, 0x4EEB, 	/* 0x8140 to 0x8147 */
0x4EED, 0x4EFC, 0x4F1C, 0x4F8A, 0x4FFF, 0x5042, 0x5050, 0x5078, 	/* 0x8148 to 0x814F */
0x50D8, 0x50DE, 0x50F4, 0x5116, 0x514A, 0x5151, 0x5164, 0x516A, 	/* 0x8150 to 0x8157 */
0x5185, 0x5190, 0x519D, 0x51A6, 0x51A8, 0x51A9, 0x51C7, 0x51D6, 	/* 0x8158 to 0x815F */
0x51DB, 0x51EC, 0x51FC, 0x520B, 0x5214, 0x5215, 0x5220, 0x522B, 	/* 0x8160 to 0x8167 */
0x5239, 0x524F, 0x5271, 0x5290, 0x5292, 0x5294, 0x529C, 0x52AF, 	/* 0x8168 to 0x816F */
0x52B5, 0x52D0, 0x5300, 0x5307, 0x5324, 0x5346, 0x535F, 0x5393, 	/* 0x8170 to 0x8177 */
0x53B0, 0x53DD, 0x5423, 0x5450, 0x5451, 0x548A, 0x549D, 0x0000, 	/* 0x8178 to 0x817F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8180 to 0x8187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8188 to 0x818F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8190 to 0x8197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8198 to 0x819F */
0x0000, 0x54A3, 0x54B4, 0x54D0, 0x5523, 0x553F, 0x554C, 0x5553, 	/* 0x81A0 to 0x81A7 */
0x555D, 0x556C, 0x559E, 0x55A9, 0x55EC, 0x55F5, 0x5623, 0x5650, 	/* 0x81A8 to 0x81AF */
0x567C, 0x568A, 0x5694, 0x56A0, 0x56AF, 0x56D8, 0x5700, 0x5759, 	/* 0x81B0 to 0x81B7 */
0x5765, 0x577F, 0x5785, 0x5789, 0x57A1, 0x57AC, 0x57B4, 0x57C0, 	/* 0x81B8 to 0x81BF */
0x57C8, 0x57D3, 0x57EF, 0x5844, 0x586C, 0x5892, 0x589A, 0x58B2, 	/* 0x81C0 to 0x81C7 */
0x58B8, 0x58E5, 0x58FB, 0x5902, 0x590B, 0x5910, 0x5918, 0x591B, 	/* 0x81C8 to 0x81CF */
0x748C, 0x748D, 0x7499, 0x749B, 0x74A4, 0x74B4, 0x74B9, 0x74C8, 	/* 0x81D0 to 0x81D7 */
0x74CC, 0x74D0, 0x74D3, 0x7542, 0x7555, 0x756E, 0x758D, 0x759E, 	/* 0x81D8 to 0x81DF */
0x75DC, 0x762C, 0x764F, 0x7651, 0x7673, 0x7674, 0x76A5, 0x76D9, 	/* 0x81E0 to 0x81E7 */
0x770E, 0x770F, 0x7758, 0x7772, 0x7777, 0x7778, 0x777A, 0x777B, 	/* 0x81E8 to 0x81EF */
0x7798, 0x77AF, 0x77BE, 0x77C3, 0x77C5, 0x77CB, 0x77DD, 0x77E6, 	/* 0x81F0 to 0x81F7 */
0x77F4, 0x781E, 0x783D, 0x7842, 0x7844, 0x784B, 0x7851, 0x0000, 	/* 0x81F8 to 0x81FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8200 to 0x8207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8208 to 0x820F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8210 to 0x8217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8218 to 0x821F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8220 to 0x8227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8228 to 0x822F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8230 to 0x8237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8238 to 0x823F */
0x5516, 0x58F7, 0x9834, 0x845B, 0x7114, 0x8276, 0x8956, 0x9D2C, 	/* 0x8240 to 0x8247 */
0x9D0E, 0x8EAF, 0x6062, 0x6666, 0x86CE, 0x64B9, 0x938C, 0x565B, 	/* 0x8248 to 0x824F */
0x6F45, 0x8ACC, 0x7149, 0x5DCC, 0x8749, 0x9A28, 0x7BAA, 0x8D0B, 	/* 0x8250 to 0x8257 */
0x9957, 0x5C2D, 0x7E4B, 0x981A, 0x5026, 0x6372, 0x9E78, 0x783F, 	/* 0x8258 to 0x825F */
0x9EB9, 0x9EBA, 0x8CCE, 0x8B83, 0xEF79, 0x848B, 0x91A4, 0x7A63, 	/* 0x8260 to 0x8267 */
0x64B0, 0x5DFD, 0x5E96, 0x8061, 0x6955, 0x7AEA, 0x7026, 0x68BC, 	/* 0x8268 to 0x826F */
0x7977, 0x6D9C, 0x8FE9, 0x7962, 0x56A2, 0x877F, 0x5265, 0x7984, 	/* 0x8270 to 0x8277 */
0x6E8C, 0x9197, 0x7B86, 0x982C, 0x685D, 0x4FAD, 0x85AE, 0x0000, 	/* 0x8278 to 0x827F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8280 to 0x8287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8288 to 0x828F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8290 to 0x8297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8298 to 0x829F */
0x0000, 0x7BED, 0x874B, 0x5036, 0x690D, 0x6B96, 0x614E, 0x5177, 	/* 0x82A0 to 0x82A7 */
0x771F, 0x5024, 0x7F6E, 0x76F4, 0x69D9, 0x60E3, 0x62F6, 0x545F, 	/* 0x82A8 to 0x82AF */
0x9784, 0x564C, 0x50C5, 0x5618, 0x865E, 0x5932, 0x595B, 0x595D, 	/* 0x82B0 to 0x82B7 */
0x5963, 0x596C, 0x599B, 0x59D7, 0x59EB, 0x5A1A, 0x5AAA, 0x5AD0, 	/* 0x82B8 to 0x82BF */
0x5AF1, 0x5B36, 0x5BC9, 0x5BF3, 0x5C13, 0x5C1C, 0x5C1E, 0x5C53, 	/* 0x82C0 to 0x82C7 */
0x5C99, 0x5C9C, 0x5CBA, 0x5CBB, 0x5CC1, 0x5CF5, 0x5CFA, 0x5D15, 	/* 0x82C8 to 0x82CF */
0x5D18, 0x5D3E, 0x5D53, 0x5D5C, 0x5D6D, 0x5D73, 0x5D74, 0x5D8C, 	/* 0x82D0 to 0x82D7 */
0x5D90, 0x5DB9, 0x5DD0, 0x5DD3, 0x5E47, 0x5E64, 0x5ECF, 0x5ED0, 	/* 0x82D8 to 0x82DF */
0x5EEA, 0x5EF0, 0x5F09, 0x5F0C, 0x5F11, 0x5F21, 0x5F34, 0x5F41, 	/* 0x82E0 to 0x82E7 */
0x5F45, 0x5F51, 0x5F5C, 0x5F66, 0x5F83, 0x5FF0, 0x604A, 0x6060, 	/* 0x82E8 to 0x82EF */
0x608B, 0x60A6, 0x60DE, 0x6111, 0x6120, 0x6121, 0x613C, 0x613D, 	/* 0x82F0 to 0x82F7 */
0x6198, 0x61B7, 0x61F4, 0x6213, 0x621D, 0x621E, 0x6237, 0x0000, 	/* 0x82F8 to 0x82FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8300 to 0x8307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8308 to 0x830F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8310 to 0x8317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8318 to 0x831F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8320 to 0x8327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8328 to 0x832F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8330 to 0x8337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8338 to 0x833F */
0x5E7A, 0x6C10, 0x53CE, 0x4F2B, 0x4F4E, 0x5434, 0x56F1, 0x58EE, 	/* 0x8340 to 0x8347 */
0x5939, 0x5986, 0x5C2C, 0x51B3, 0x51B2, 0x707E, 0x89C1, 0x89D2, 	/* 0x8348 to 0x834F */
0x8D1D, 0x8F66, 0x4E9A, 0x6765, 0x4ED1, 0x4E24, 0x534F, 0x5C4A, 	/* 0x8350 to 0x8357 */
0x5188, 0x5E95, 0x62B5, 0x4E1C, 0x4E89, 0x72B6, 0x7C7C, 0x7EA0, 	/* 0x8358 to 0x835F */
0x5367, 0x8F67, 0x90B8, 0x957F, 0x95E8, 0x4FA0, 0x4FA3, 0x5156, 	/* 0x8360 to 0x8367 */
0x5219, 0x52B2, 0x5374, 0x5942, 0x5E05, 0x67E2, 0x6C79, 0x4E3A, 	/* 0x8368 to 0x836F */
0x7EA3, 0x7EA2, 0x7EAA, 0x7EAB, 0x7EA5, 0x7EA6, 0x7EA1, 0x80DD, 	/* 0x8370 to 0x8377 */
0x82CE, 0x8BA1, 0x8BA2, 0x8BA3, 0x8D1E, 0x8D1F, 0x519B, 0x0000, 	/* 0x8378 to 0x837F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8380 to 0x8387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8388 to 0x838F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8390 to 0x8397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8398 to 0x839F */
0x0000, 0x8F68, 0x95E9, 0x97E6, 0x9875, 0x98CE, 0x98DE, 0x4FE9, 	/* 0x83A0 to 0x83A7 */
0x4EEC, 0x4F25, 0x4E2A, 0x4F26, 0x4ED3, 0x51BB, 0x521A, 0x5265, 	/* 0x83A8 to 0x83AF */
0x5458, 0x5A31, 0x5B59, 0x5CE1, 0x5C9B, 0x5C98, 0x5E08, 0x5E93, 	/* 0x83B0 to 0x83B7 */
0x5F84, 0x631F, 0x65F6, 0x664B, 0x4E66, 0x6CFE, 0x6D43, 0x4E4C, 	/* 0x83B8 to 0x83BF */
0x72ED, 0x72C8, 0x4EA9, 0x7825, 0x79EA, 0x7EBA, 0x7EB1, 0x7EB9, 	/* 0x83C0 to 0x83C7 */
0x7EAF, 0x7EBD, 0x7EB0, 0x7EA7, 0x7EAD, 0x7EB3, 0x7EB8, 0x7EB7, 	/* 0x83C8 to 0x83CF */
0x80C1, 0x8109, 0x520D, 0x8BB0, 0x8BA6, 0x8BA8, 0x8BA7, 0x8BAA, 	/* 0x83D0 to 0x83D7 */
0x8BAF, 0x8BAD, 0x8BAB, 0x5C82, 0x8D22, 0x8D21, 0x8F69, 0x8F6B, 	/* 0x83D8 to 0x83DF */
0x9489, 0x9488, 0x948A, 0x948B, 0x95EA, 0x9635, 0x9655, 0x9649, 	/* 0x83E0 to 0x83E7 */
0x9965, 0x9A6C, 0x9AA8, 0x4F2A, 0x4F1F, 0x4FA6, 0x4FA7, 0x52A1, 	/* 0x83E8 to 0x83EF */
0x52A8, 0x533A, 0x53C2, 0x54D1, 0x95EE, 0x8854, 0x56FD, 0x575A, 	/* 0x83F0 to 0x83F7 */
0x57A9, 0x6267, 0x591F, 0x5A04, 0x5987, 0x4E13, 0x5C06, 0x0000, 	/* 0x83F8 to 0x83FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8400 to 0x8407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8408 to 0x840F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8410 to 0x8417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8418 to 0x841F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8420 to 0x8427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8428 to 0x842F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8430 to 0x8437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8438 to 0x843F */
0x5C49, 0x5CE5, 0x5C97, 0x5E26, 0x5E10, 0x5F20, 0x5F3A, 0x4ECE, 	/* 0x8440 to 0x8447 */
0x5F95, 0x51C4, 0x6005, 0x626B, 0x6302, 0x626A, 0x62A1, 0x6323, 	/* 0x8448 to 0x844F */
0x8D25, 0x542F, 0x659B, 0x65A9, 0x663C, 0x52D6, 0x5F03, 0x6761, 	/* 0x8450 to 0x8457 */
0x67AD, 0x6740, 0x6C22, 0x51C9, 0x6D45, 0x6E0A, 0x6CEA, 0x6CA6, 	/* 0x8458 to 0x845F */
0x51C0, 0x7275, 0x72F0, 0x73B0, 0x4EA7, 0x6BD5, 0x5F02, 0x4F17, 	/* 0x8460 to 0x8467 */
0x7ECA, 0x7EDF, 0x7ECD, 0x7ECB, 0x7ECC, 0x7EC6, 0x7EC5, 0x7EC4, 	/* 0x8468 to 0x846F */
0x7EC8, 0x7EC1, 0x7EC2, 0x94B5, 0x4E60, 0x835A, 0x830E, 0x8392, 	/* 0x8470 to 0x8477 */
0x5E84, 0x82CB, 0x5904, 0x672F, 0x886E, 0x89C5, 0x89C4, 0x0000, 	/* 0x8478 to 0x847F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8480 to 0x8487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8488 to 0x848F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8490 to 0x8497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8498 to 0x849F */
0x0000, 0x8BBF, 0x8BB6, 0x8BC0, 0x8BB7, 0x8BB8, 0x8BBE, 0x8BBC, 	/* 0x84A0 to 0x84A7 */
0x8BB9, 0x8D29, 0x8D23, 0x8D2F, 0x8D27, 0x8D2A, 0x8D2B, 0x8F6D, 	/* 0x84A8 to 0x84AF */
0x8F6F, 0x8FD9, 0x8FDE, 0x8FF3, 0x9497, 0x9493, 0x948F, 0x9492, 	/* 0x84B0 to 0x84B7 */
0x95ED, 0x9648, 0x9646, 0x9634, 0x9876, 0x9877, 0x9C7C, 0x9E1F, 	/* 0x84B8 to 0x84BF */
0x5364, 0x9EA6, 0x5907, 0x4F27, 0x4F1E, 0x51EF, 0x5240, 0x521B, 	/* 0x84C0 to 0x84C7 */
0x52B3, 0x52CB, 0x4E27, 0x5355, 0x54DF, 0x5524, 0x4E54, 0x56F4, 	/* 0x84C8 to 0x84CF */
0x5C27, 0x573A, 0x62A5, 0x57DA, 0x58F6, 0x5A32, 0x5BFB, 0x5C9A, 	/* 0x84D0 to 0x84D7 */
0x5E27, 0x5E0F, 0x5395, 0x53A9, 0x6076, 0x95F7, 0x60EC, 0x607B, 	/* 0x84D8 to 0x84DF */
0x607C, 0x62E3, 0x6325, 0x6362, 0x626C, 0x67A3, 0x680B, 0x6808, 	/* 0x84E0 to 0x84E7 */
0x94A6, 0x6B8B, 0x58F3, 0x6C2F, 0x6C29, 0x6D8C, 0x51D1, 0x6E6E, 	/* 0x84E8 to 0x84EF */
0x6DA1, 0x6C64, 0x6D4B, 0x6D51, 0x6DA3, 0x65E0, 0x72B9, 0x82CF, 	/* 0x84F0 to 0x84F7 */
0x753B, 0x75C9, 0x53D1, 0x76D7, 0x781A, 0x79C6, 0x7A97, 0x0000, 	/* 0x84F8 to 0x84FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8500 to 0x8507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8508 to 0x850F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8510 to 0x8517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8518 to 0x851F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8520 to 0x8527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8528 to 0x852F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8530 to 0x8537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8538 to 0x853F */
0x7B14, 0x7B0B, 0x7EDE, 0x7ED3, 0x7ED2, 0x7EDD, 0x4E1D, 0x7EDC, 	/* 0x8540 to 0x8547 */
0x7ED9, 0x7EDA, 0x7ED6, 0x7EDB, 0x8083, 0x80BE, 0x80C0, 0x534E, 	/* 0x8548 to 0x854F */
0x83B1, 0x82CC, 0x865A, 0x89C6, 0x8BC4, 0x8BCD, 0x8BC1, 0x8BC2, 	/* 0x8550 to 0x8557 */
0x8BCF, 0x8BC5, 0x8BC8, 0x8BCB, 0x8BC9, 0x8BCA, 0x8BC3, 0x8D2E, 	/* 0x8558 to 0x855F */
0x8D34, 0x8D30, 0x8D3B, 0x8D32, 0x8D39, 0x8D3A, 0x8D35, 0x4E70, 	/* 0x8560 to 0x8567 */
0x8D2C, 0x8D38, 0x8D37, 0x8F72, 0x8F74, 0x8F76, 0x8FDB, 0x90AE, 	/* 0x8568 to 0x856F */
0x4E61, 0x949E, 0x94AE, 0x9499, 0x94A0, 0x94A7, 0x949D, 0x94A4, 	/* 0x8570 to 0x8577 */
0x94A3, 0x95F5, 0x95F0, 0x5F00, 0x95F2, 0x95F4, 0x95F3, 0x0000, 	/* 0x8578 to 0x857F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8580 to 0x8587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8588 to 0x858F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8590 to 0x8597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8598 to 0x859F */
0x0000, 0x961F, 0x9636, 0x9633, 0x97E7, 0x9879, 0x987A, 0x987B, 	/* 0x85A0 to 0x85A7 */
0x996A, 0x996D, 0x9968, 0x996E, 0x996C, 0x51AF, 0x9A6D, 0x4E71, 	/* 0x85A8 to 0x85AF */
0x503A, 0x4F20, 0x4EC5, 0x503E, 0x4F24, 0x506C, 0x94F2, 0x52BF, 	/* 0x85B0 to 0x85B7 */
0x79EF, 0x6C47, 0x5417, 0x545C, 0x545B, 0x56ED, 0x5706, 0x6D82, 	/* 0x85B8 to 0x85BF */
0x5757, 0x575E, 0x57D8, 0x8314, 0x5965, 0x5988, 0x7231, 0x5FFE, 	/* 0x85C0 to 0x85C7 */
0x6006, 0x607A, 0x635F, 0x62A2, 0x6363, 0x6784, 0x6656, 0x6655, 	/* 0x85C8 to 0x85CF */
0x65F8, 0x4F1A, 0x4E1A, 0x6781, 0x6768, 0x6862, 0x67AB, 0x5C81, 	/* 0x85D0 to 0x85D7 */
0x6C9F, 0x706D, 0x6E7F, 0x6ED1, 0x6CA7, 0x70E6, 0x70BC, 0x7080, 	/* 0x85D8 to 0x85DF */
0x7115, 0x7237, 0x72EE, 0x733E, 0x73F2, 0x5F53, 0x76CF, 0x7750, 	/* 0x85E0 to 0x85E7 */
0x7741, 0x96CE, 0x788C, 0x8282, 0x7B15, 0x7CA4, 0x7ECF, 0x7EE2, 	/* 0x85E8 to 0x85EF */
0x7ED1, 0x7EE5, 0x7EE6, 0x4E49, 0x7FA1, 0x5723, 0x80A0, 0x811A, 	/* 0x85F0 to 0x85F7 */
0x80BF, 0x8111, 0x8364, 0x82C7, 0x53F6, 0x83B4, 0x865E, 0x0000, 	/* 0x85F8 to 0x85FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8600 to 0x8607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8608 to 0x860F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8610 to 0x8617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8618 to 0x861F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8620 to 0x8627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8628 to 0x862F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8630 to 0x8637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8638 to 0x863F */
0x864F, 0x53F7, 0x8708, 0x86AC, 0x8865, 0x88C5, 0x8BE7, 0x8BE5, 	/* 0x8640 to 0x8647 */
0x8BE6, 0x8BD5, 0x8BD7, 0x8BD8, 0x8BD9, 0x8BE3, 0x8BDA, 0x8BDD, 	/* 0x8648 to 0x864F */
0x8BDB, 0x8BE1, 0x8BE2, 0x8BE0, 0x8BDF, 0x8D3C, 0x8D44, 0x8D3E, 	/* 0x8650 to 0x8657 */
0x8D3F, 0x8D40, 0x8D41, 0x8D42, 0x8D45, 0x8F83, 0x8F7D, 0x8F7C, 	/* 0x8658 to 0x865F */
0x8F7E, 0x519C, 0x8FD0, 0x8FBE, 0x8FDD, 0x8FC7, 0x90B9, 0x94B4, 	/* 0x8660 to 0x8667 */
0x94B3, 0x94B9, 0x94B8, 0x94BE, 0x94C0, 0x94C5, 0x94A9, 0x94C2, 	/* 0x8668 to 0x866F */
0x94C3, 0x94C9, 0x94CB, 0x949C, 0x94CD, 0x94BF, 0x94C6, 0x95F8, 	/* 0x8670 to 0x8677 */
0x9668, 0x96BD, 0x7535, 0x9884, 0x987D, 0x987F, 0x987C, 0x0000, 	/* 0x8678 to 0x867F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8680 to 0x8687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8688 to 0x868F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8690 to 0x8697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8698 to 0x869F */
0x0000, 0x9881, 0x9882, 0x9972, 0x9974, 0x9971, 0x9970, 0x9A70, 	/* 0x86A0 to 0x86A7 */
0x9A6E, 0x9A6F, 0x9E20, 0x4FA5, 0x4FA8, 0x532E, 0x538C, 0x5C1D, 	/* 0x86A8 to 0x86AF */
0x5455, 0x53F9, 0x55BD, 0x5567, 0x54D4, 0x56E2, 0x56FE, 0x5C18, 	/* 0x86B0 to 0x86B7 */
0x57AB, 0x5811, 0x5BFF, 0x68A6, 0x593A, 0x5941, 0x59AA, 0x5B9E, 	/* 0x86B8 to 0x86BF */
0x5BDD, 0x5BF9, 0x5C61, 0x5D2D, 0x5C96, 0x5E01, 0x5E3C, 0x5F7B, 	/* 0x86C0 to 0x86C7 */
0x6001, 0x60EF, 0x6078, 0x60ED, 0x60E8, 0x6402, 0x63B4, 0x63BA, 	/* 0x86C8 to 0x86CF */
0x7545, 0x8363, 0x67AA, 0x6EDA, 0x6E0D, 0x6C49, 0x6EE1, 0x6EDE, 	/* 0x86D0 to 0x86D7 */
0x6E10, 0x6DA8, 0x6D9F, 0x6CAA, 0x6E14, 0x6E17, 0x6DA4, 0x8367, 	/* 0x86D8 to 0x86DF */
0x5C14, 0x8366, 0x72F1, 0x7410, 0x739B, 0x759F, 0x75A1, 0x75AF, 	/* 0x86E0 to 0x86E7 */
0x75EA, 0x5C3D, 0x76D1, 0x7855, 0x796F, 0x7978, 0x79CD, 0x79F0, 	/* 0x86E8 to 0x86EF */
0x6D3C, 0x7A9D, 0x7B3A, 0x7B5D, 0x7EFD, 0x7EFE, 0x7EFC, 0x7EF0, 	/* 0x86F0 to 0x86F7 */
0x7EEB, 0x7EFF, 0x7D27, 0x7F00, 0x7EB2, 0x7EEE, 0x7EF8, 0x0000, 	/* 0x86F8 to 0x86FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8700 to 0x8707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8708 to 0x870F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8710 to 0x8717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8718 to 0x871F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8720 to 0x8727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8728 to 0x872F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8730 to 0x8737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8738 to 0x873F */
0x7EF5, 0x7EB6, 0x7EF4, 0x7EEA, 0x7F01, 0x7EF6, 0x7F5A, 0x95FB, 	/* 0x8740 to 0x8747 */
0x8385, 0x76D6, 0x836A, 0x82CD, 0x8680, 0x8BF5, 0x8BED, 0x8BEC, 	/* 0x8748 to 0x874F */
0x8BA4, 0x8BEB, 0x8BEF, 0x8BF4, 0x8BF0, 0x8BF2, 0x8BF1, 0x8BF3, 	/* 0x8750 to 0x8757 */
0x8BEE, 0x5BBE, 0x8D48, 0x8D4A, 0x8D75, 0x8D76, 0x8F85, 0x8F84, 	/* 0x8758 to 0x875F */
0x8F7B, 0x8FDC, 0x900A, 0x9012, 0x94F0, 0x94F6, 0x94DC, 0x94ED, 	/* 0x8760 to 0x8767 */
0x94E2, 0x94EC, 0x94E8, 0x94F5, 0x94E3, 0x9602, 0x95FA, 0x95FD, 	/* 0x8768 to 0x876F */
0x9601, 0x9600, 0x9645, 0x9887, 0x9886, 0x98D2, 0x997A, 0x997C, 	/* 0x8770 to 0x8777 */
0x9975, 0x9977, 0x9A73, 0x80AE, 0x9AB0, 0x9E23, 0x9E22, 0x0000, 	/* 0x8778 to 0x877F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8780 to 0x8787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8788 to 0x878F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8790 to 0x8797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8798 to 0x879F */
0x0000, 0x51E4, 0x9F50, 0x4EBF, 0x4EEA, 0x4EF7, 0x4FAC, 0x4FA9, 	/* 0x87A0 to 0x87A7 */
0x4FED, 0x5267, 0x5218, 0x5251, 0x523D, 0x5389, 0x5520, 0x5634, 	/* 0x87A8 to 0x87AF */
0x54D7, 0x5618, 0x55B7, 0x5578, 0x53FD, 0x589F, 0x575F, 0x5760, 	/* 0x87B0 to 0x87B7 */
0x5815, 0x5A34, 0x5A75, 0x59A9, 0x5A07, 0x5A06, 0x5BBD, 0x5BA1, 	/* 0x87B8 to 0x87BF */
0x5199, 0x5C42, 0x5D94, 0x5E1C, 0x5E9F, 0x53A8, 0x5E99, 0x53AE, 	/* 0x87C0 to 0x87C7 */
0x5E7F, 0x5F39, 0x5E86, 0x8651, 0x5FE7, 0x6002, 0x60AF, 0x60EE, 	/* 0x87C8 to 0x87CF */
0x6124, 0x6003, 0x631A, 0x6251, 0x635E, 0x62E8, 0x6320, 0x629A, 	/* 0x87D0 to 0x87D7 */
0x63B8, 0x63FF, 0x654C, 0x6570, 0x6682, 0x6635, 0x6837, 0x6869, 	/* 0x87D8 to 0x87DF */
0x67A2, 0x6807, 0x697C, 0x6868, 0x4E50, 0x679E, 0x6B27, 0x6B87, 	/* 0x87E0 to 0x87E7 */
0x6BB4, 0x6D46, 0x6CFC, 0x6D01, 0x6D47, 0x6E83, 0x6DA6, 0x6DA7, 	/* 0x87E8 to 0x87EF */
0x6D54, 0x70ED, 0x5956, 0x83B9, 0x75AE, 0x7691, 0x76B1, 0x76D8, 	/* 0x87F0 to 0x87F7 */
0x786E, 0x7801, 0x7A91, 0x7A77, 0x7F14, 0x7EC3, 0x7EAC, 0x0000, 	/* 0x87F8 to 0x87FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8800 to 0x8807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8808 to 0x880F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8810 to 0x8817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8818 to 0x881F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8820 to 0x8827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8828 to 0x882F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8830 to 0x8837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8838 to 0x883F */
0x7F04, 0x7F05, 0x7F09, 0x7F16, 0x7F18, 0x7EBF, 0x7F0E, 0x7F13, 	/* 0x8840 to 0x8847 */
0x7F0D, 0x7F02, 0x7F08, 0x7F07, 0x9A82, 0x7F62, 0x80F6, 0x80A4, 	/* 0x8848 to 0x884F */
0x83B2, 0x836B, 0x848B, 0x867E, 0x8717, 0x536B, 0x8C0A, 0x8C05, 	/* 0x8850 to 0x8857 */
0x8C08, 0x8C06, 0x8BDE, 0x8BF7, 0x8BF8, 0x8BFE, 0x8BFF, 0x8C04, 	/* 0x8858 to 0x885F */
0x8C03, 0x8C01, 0x8BBA, 0x8BE4, 0x8C07, 0x8BFD, 0x8C00, 0x7AD6, 	/* 0x8860 to 0x8867 */
0x8D54, 0x8D4F, 0x8D4B, 0x8D31, 0x8D26, 0x8D4C, 0x8D24, 0x5356, 	/* 0x8868 to 0x886F */
0x8D50, 0x8D28, 0x8D53, 0x8DF5, 0x8F89, 0x8F86, 0x8F8D, 0x8F88, 	/* 0x8870 to 0x8877 */
0x8F87, 0x8F6E, 0x8F8E, 0x8F8B, 0x8F8A, 0x9002, 0x8FC1, 0x0000, 	/* 0x8878 to 0x887F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8880 to 0x8887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8888 to 0x888F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8890 to 0x8897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8898 to 0x889F */
0x0000, 0x90BB, 0x90D1, 0x9093, 0x950C, 0x9511, 0x9500, 0x94FA, 	/* 0x88A0 to 0x88A7 */
0x94D0, 0x9504, 0x94DD, 0x9510, 0x9509, 0x950B, 0x94A1, 0x9502, 	/* 0x88A8 to 0x88AF */
0x95FE, 0x9605, 0x5DE9, 0x9889, 0x988C, 0x517B, 0x997F, 0x9981, 	/* 0x88B0 to 0x88B7 */
0x9A7C, 0x9A7B, 0x9A77, 0x9A76, 0x9A7D, 0x9A7E, 0x9A79, 0x9A78, 	/* 0x88B8 to 0x88BF */
0x9AB7, 0x95F9, 0x9C7F, 0x9C81, 0x9E29, 0x9E26, 0x9EB8, 0x9F7F, 	/* 0x88C0 to 0x88C7 */
0x4FE6, 0x50A7, 0x4FAA, 0x5E42, 0x5242, 0x5428, 0x54DD, 0x55F3, 	/* 0x88C8 to 0x88CF */
0x57A6, 0x575B, 0x594B, 0x8885, 0x5B66, 0x5BFC, 0x5BAA, 0x51ED, 	/* 0x88D0 to 0x88D7 */
0x60EB, 0x61D4, 0x5FC6, 0x6218, 0x62E5, 0x6321, 0x631E, 0x636E, 	/* 0x88D8 to 0x88DF */
0x63B3, 0x62E9, 0x6361, 0x62C5, 0x631D, 0x5386, 0x6653, 0x6654, 	/* 0x88E0 to 0x88E7 */
0x6619, 0x6866, 0x6A2A, 0x6811, 0x692D, 0x6865, 0x673A, 0x6861, 	/* 0x88E8 to 0x88EF */
0x6DC0, 0x6D53, 0x6CFD, 0x6D4A, 0x6CA3, 0x6FA6, 0x6E11, 0x70BD, 	/* 0x88F0 to 0x88F7 */
0x70E7, 0x706F, 0x70EB, 0x7116, 0x72EC, 0x7391, 0x74EF, 0x0000, 	/* 0x88F8 to 0x88FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8900 to 0x8907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8908 to 0x890F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8910 to 0x8917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8918 to 0x891F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8920 to 0x8927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8928 to 0x892F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8930 to 0x8937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8938 to 0x893F */
0x7618, 0x5362, 0x7792, 0x7816, 0x789B, 0x79EF, 0x9896, 0x7A23, 	/* 0x8940 to 0x8947 */
0x7AA5, 0x7B03, 0x7B5B, 0x7F22, 0x7F23, 0x8426, 0x7F1A, 0x53BF, 	/* 0x8948 to 0x894F */
0x7F1F, 0x7F1C, 0x7F19, 0x7EC9, 0x817B, 0x5174, 0x8231, 0x8361, 	/* 0x8950 to 0x8957 */
0x8427, 0x829C, 0x8682, 0x8424, 0x88E4, 0x4EB2, 0x89CE, 0x8C1B, 	/* 0x8958 to 0x895F */
0x8C1A, 0x8C0F, 0x8BB3, 0x8C0B, 0x8C0D, 0x8C10, 0x8C18, 0x8BFA, 	/* 0x8960 to 0x8967 */
0x8C12, 0x8C13, 0x8BBD, 0x8C15, 0x8C19, 0x8C0C, 0x8C16, 0x8D56, 	/* 0x8968 to 0x896F */
0x8F90, 0x8F91, 0x8F93, 0x8F8F, 0x529E, 0x9009, 0x8FDF, 0x8FBD, 	/* 0x8970 to 0x8977 */
0x9057, 0x90BA, 0x952D, 0x952F, 0x9530, 0x9519, 0x94B1, 0x0000, 	/* 0x8978 to 0x897F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8980 to 0x8987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8988 to 0x898F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8990 to 0x8997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8998 to 0x899F */
0x0000, 0x94A2, 0x9521, 0x5F55, 0x94EE, 0x9525, 0x9526, 0x951F, 	/* 0x89A0 to 0x89A7 */
0x9522, 0x9531, 0x960E, 0x968F, 0x9669, 0x9759, 0x817C, 0x988A, 	/* 0x89A8 to 0x89AF */
0x9888, 0x9891, 0x9894, 0x5934, 0x9893, 0x9890, 0x9986, 0x996F, 	/* 0x89B0 to 0x89B7 */
0x9984, 0x9985, 0x9A87, 0x9A88, 0x9A86, 0x9AB8, 0x9ABC, 0x9C8D, 	/* 0x89B8 to 0x89BF */
0x9E35, 0x9E2A, 0x9E2F, 0x9E2D, 0x9E33, 0x9F99, 0x9F9F, 0x4F18, 	/* 0x89C0 to 0x89C7 */
0x507F, 0x50A8, 0x52B1, 0x549B, 0x5413, 0x538B, 0x57D9, 0x5A74, 	/* 0x89C8 to 0x89CF */
0x5AD4, 0x5B37, 0x5C34, 0x5C66, 0x5C7F, 0x5D58, 0x5E2E, 0x5F25, 	/* 0x89D0 to 0x89D7 */
0x5E94, 0x6073, 0x620F, 0x51FB, 0x6324, 0x62E7, 0x62DF, 0x6401, 	/* 0x89D8 to 0x89DF */
0x655B, 0x6BD9, 0x66A7, 0x6863, 0x68C0, 0x6867, 0x6809, 0x6A2F, 	/* 0x89E0 to 0x89E7 */
0x6B93, 0x6BE1, 0x6CDE, 0x6EE8, 0x6D4E, 0x6D9B, 0x6EE5, 0x6DA9, 	/* 0x89E8 to 0x89EF */
0x6F4D, 0x8425, 0x707F, 0x70DB, 0x70E9, 0x5899, 0x72DE, 0x83B7, 	/* 0x89F0 to 0x89F7 */
0x73AF, 0x7477, 0x75E8, 0x7597, 0x77EB, 0x78FA, 0x77F6, 0x0000, 	/* 0x89F8 to 0x89FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A00 to 0x8A07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A08 to 0x8A0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A10 to 0x8A17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A18 to 0x8A1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A20 to 0x8A27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A28 to 0x8A2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A30 to 0x8A37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A38 to 0x8A3F */
0x7BD3, 0x7CAA, 0x9546, 0x7CC1, 0x7F29, 0x7EE9, 0x7F2A, 0x7F15, 	/* 0x8A40 to 0x8A47 */
0x7F27, 0x7EF7, 0x7F1D, 0x603B, 0x7EB5, 0x7F2B, 0x7EA4, 0x7F25, 	/* 0x8A48 to 0x8A4F */
0x7E66, 0x7F26, 0x58F0, 0x806A, 0x8054, 0x8038, 0x8113, 0x80C6, 	/* 0x8A50 to 0x8A57 */
0x8138, 0x810D, 0x4E34, 0x4E3E, 0x8270, 0x8537, 0x84DF, 0x4E8F, 	/* 0x8A58 to 0x8A5F */
0x877C, 0x8748, 0x4EB5, 0x891B, 0x89CA, 0x8C1C, 0x8C24, 0x8C26, 	/* 0x8A60 to 0x8A67 */
0x8BB2, 0x8C0E, 0x8C23, 0x8C22, 0x8A8A, 0x8C27, 0x8D5A, 0x8D5B, 	/* 0x8A68 to 0x8A6F */
0x8D2D, 0x8D59, 0x8D8B, 0x8F96, 0x8F97, 0x6BC2, 0x8F95, 0x8206, 	/* 0x8A70 to 0x8A77 */
0x8FD8, 0x8FC8, 0x915D, 0x9540, 0x9541, 0x951A, 0x952E, 0x0000, 	/* 0x8A78 to 0x8A7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A80 to 0x8A87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A88 to 0x8A8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A90 to 0x8A97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8A98 to 0x8A9F */
0x0000, 0x9532, 0x9505, 0x9524, 0x953A, 0x9539, 0x953B, 0x953E, 	/* 0x8AA0 to 0x8AA7 */
0x9537, 0x9614, 0x9615, 0x9611, 0x95F1, 0x9690, 0x96B6, 0x867D, 	/* 0x8AA8 to 0x8AAF */
0x97E9, 0x9897, 0x98D3, 0x9A8B, 0x9A8F, 0x9C9C, 0x9C9B, 0x9C94, 	/* 0x8AB0 to 0x8AB7 */
0x9C91, 0x9E3F, 0x9E3D, 0x70B9, 0x658B, 0x4E1B, 0x565C, 0x5739, 	/* 0x8AB8 to 0x8ABF */
0x5792, 0x5A76, 0x61D1, 0x6269, 0x63B7, 0x6270, 0x64B5, 0x6446, 	/* 0x8AC0 to 0x8AC7 */
0x64DE, 0x64B7, 0x65AD, 0x69DF, 0x67DC, 0x69DB, 0x67E0, 0x6B24, 	/* 0x8AC8 to 0x8ACF */
0x5F52, 0x6BA1, 0x6CFB, 0x6E16, 0x6EE4, 0x6E0E, 0x6E85, 0x6D4F, 	/* 0x8AD0 to 0x8AD7 */
0x70EC, 0x7118, 0x72B7, 0x730E, 0x74EE, 0x75A0, 0x7751, 0x7840, 	/* 0x8AD8 to 0x8ADF */
0x793C, 0x7A51, 0x79FD, 0x7A9C, 0x7A8D, 0x7BAB, 0x7C27, 0x7BAA, 	/* 0x8AE0 to 0x8AE7 */
0x7BD1, 0x7B80, 0x7CAE, 0x7EC7, 0x7F2E, 0x7ED5, 0x7F2D, 0x7EE3, 	/* 0x8AE8 to 0x8AEF */
0x7F2F, 0x7FD8, 0x804C, 0x8042, 0x8110, 0x8191, 0x65E7, 0x8428, 	/* 0x8AF0 to 0x8AF7 */
0x84DD, 0x8360, 0x86F2, 0x8749, 0x89D0, 0x89DE, 0x8C1F, 0x0000, 	/* 0x8AF8 to 0x8AFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B00 to 0x8B07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B08 to 0x8B0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B10 to 0x8B17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B18 to 0x8B1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B20 to 0x8B27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B28 to 0x8B2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B30 to 0x8B37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B38 to 0x8B3F */
0x8C28, 0x8C2C, 0x8C2A, 0x8D58, 0x8E52, 0x8FF9, 0x8DF8, 0x8EAF, 	/* 0x8B40 to 0x8B47 */
0x8F6C, 0x8F99, 0x8FE9, 0x533B, 0x9171, 0x9551, 0x9501, 0x94A8, 	/* 0x8B48 to 0x8B4F */
0x954D, 0x9547, 0x9550, 0x9552, 0x9549, 0x9616, 0x95EF, 0x9617, 	/* 0x8B50 to 0x8B57 */
0x9619, 0x6742, 0x53CC, 0x96CF, 0x9E21, 0x989D, 0x989C, 0x9898, 	/* 0x8B58 to 0x8B5F */
0x989A, 0x989B, 0x998F, 0x998A, 0x9988, 0x9A91, 0x9AC1, 0x9CA8, 	/* 0x8B60 to 0x8B67 */
0x9CA4, 0x9CAB, 0x9CA7, 0x9E43, 0x9E45, 0x9E44, 0x5784, 0x575C, 	/* 0x8B68 to 0x8B6F */
0x5BA0, 0x5E9E, 0x5E90, 0x60E9, 0x6000, 0x61D2, 0x62E2, 0x65F7, 	/* 0x8B70 to 0x8B77 */
0x6A71, 0x691F, 0x6988, 0x6A79, 0x6F47, 0x6FD1, 0x6CA5, 0x0000, 	/* 0x8B78 to 0x8B7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B80 to 0x8B87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B88 to 0x8B8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B90 to 0x8B97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8B98 to 0x8B9F */
0x0000, 0x6FD2, 0x6CF8, 0x70C1, 0x724D, 0x728A, 0x517D, 0x736D, 	/* 0x8BA0 to 0x8BA7 */
0x73BA, 0x743C, 0x7574, 0x762A, 0x788D, 0x7977, 0x7A33, 0x7B7E, 	/* 0x8BA8 to 0x8BAF */
0x8327, 0x7ECE, 0x7EF3, 0x7ED8, 0x7F57, 0x7F34, 0x81BB, 0x827A, 	/* 0x8BB0 to 0x8BB7 */
0x85AE, 0x836F, 0x8681, 0x8747, 0x88C6, 0x8884, 0x8C31, 0x8BC6, 	/* 0x8BB8 to 0x8BBF */
0x8C2D, 0x8C32, 0x8BA5, 0x8C2F, 0x8D60, 0x8D5E, 0x8DF7, 0x8F9A, 	/* 0x8BC0 to 0x8BC7 */
0x8F7F, 0x8F9E, 0x8FB9, 0x955C, 0x955D, 0x955E, 0x94FE, 0x9557, 	/* 0x8BC8 to 0x8BCF */
0x9558, 0x9556, 0x9559, 0x9535, 0x9542, 0x94FF, 0x933E, 0x5173, 	/* 0x8BD0 to 0x8BD7 */
0x9647, 0x96BE, 0x96FE, 0x97EC, 0x97F5, 0x7C7B, 0x98A0, 0x98D5, 	/* 0x8BD8 to 0x8BDF */
0x9992, 0x9991, 0x9A9B, 0x9A97, 0x9CB8, 0x9CB3, 0x9CAD, 0x9CB7, 	/* 0x8BE0 to 0x8BE7 */
0x9E51, 0x9E49, 0x9E4A, 0x9E4C, 0x9E4F, 0x4E3D, 0x9EB4, 0x529D, 	/* 0x8BE8 to 0x8BEF */
0x5499, 0x5624, 0x4E25, 0x5B9D, 0x60AC, 0x5FCF, 0x62E6, 0x6400, 	/* 0x8BF0 to 0x8BF7 */
0x80E7, 0x6987, 0x6F9C, 0x6F4B, 0x7089, 0x73D1, 0x77FF, 0x0000, 	/* 0x8BF8 to 0x8BFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C00 to 0x8C07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C08 to 0x8C0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C10 to 0x8C17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C18 to 0x8C1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C20 to 0x8C27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C28 to 0x8C2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C30 to 0x8C37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C38 to 0x8C3F */
0x783A, 0x77FE, 0x783E, 0x7AA6, 0x7ADE, 0x7B79, 0x7BEE, 0x8FAB, 	/* 0x8C40 to 0x8C47 */
0x7F24, 0x7EE7, 0x7F42, 0x80EA, 0x8230, 0x853C, 0x853A, 0x82A6, 	/* 0x8C48 to 0x8C4F */
0x82F9, 0x8574, 0x869D, 0x8934, 0x89C9, 0x89E6, 0x8BAE, 0x8BD1, 	/* 0x8C50 to 0x8C57 */
0x8C35, 0x8D62, 0x8D61, 0x8DB8, 0x91CA, 0x949F, 0x94D9, 0x9508, 	/* 0x8C58 to 0x8C5F */
0x9610, 0x98D8, 0x9976, 0x9965, 0x9A9E, 0x817E, 0x9A9A, 0x9CC3, 	/* 0x8C60 to 0x8C67 */
0x9CC5, 0x515A, 0x9F83, 0x9F84, 0x4FEA, 0x55EB, 0x556D, 0x56A3, 	/* 0x8C68 to 0x8C6F */
0x5C5E, 0x60E7, 0x6151, 0x6444, 0x643A, 0x6593, 0x6A31, 0x680F, 	/* 0x8C70 to 0x8C77 */
0x68C2, 0x6B7C, 0x70C2, 0x727A, 0x9576, 0x748E, 0x765E, 0x0000, 	/* 0x8C78 to 0x8C7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C80 to 0x8C87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C88 to 0x8C8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C90 to 0x8C97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8C98 to 0x8C9F */
0x0000, 0x7F20, 0x7EED, 0x5170, 0x85D3, 0x86CE, 0x89C8, 0x8C34, 	/* 0x8CA0 to 0x8CA7 */
0x62A4, 0x8A89, 0x8D43, 0x8E0C, 0x8DC3, 0x8DFB, 0x8F70, 0x8FA9, 	/* 0x8CA8 to 0x8CAF */
0x9570, 0x956D, 0x94C1, 0x94DB, 0x94CE, 0x956F, 0x954C, 0x54CD, 	/* 0x8CB0 to 0x8CB7 */
0x987E, 0x98A2, 0x98E8, 0x9A71, 0x9AA0, 0x84E6, 0x9AA1, 0x9AC5, 	/* 0x8CB8 to 0x8CBF */
0x9CCD, 0x9CCF, 0x83BA, 0x9E64, 0x9E5E, 0x9F87, 0x9F88, 0x556E, 	/* 0x8CC0 to 0x8CC7 */
0x4FE8, 0x50A5, 0x5453, 0x5B6A, 0x5DC5, 0x5CE6, 0x5F2F, 0x644A, 	/* 0x8CC8 to 0x8CCF */
0x6743, 0x6B22, 0x6EE9, 0x7321, 0x53E0, 0x763E, 0x7663, 0x7B3C, 	/* 0x8CD0 to 0x8CD7 */
0x7C41, 0x804B, 0x810F, 0x88AD, 0x886C, 0x8BFB, 0x8D4E, 0x8D5D, 	/* 0x8CD8 to 0x8CDF */
0x8E2F, 0x8E2C, 0x8F94, 0x90E6, 0x94F8, 0x9274, 0x9701, 0x9791, 	/* 0x8CE0 to 0x8CE7 */
0x7E6E, 0x98A4, 0x9A84, 0x9A81, 0x9CD6, 0x9CA2, 0x9CD4, 0x9CD7, 	/* 0x8CE8 to 0x8CEF */
0x9E67, 0x9E25, 0x9F39, 0x9F89, 0x9F8A, 0x9F9A, 0x604B, 0x631B, 	/* 0x8CF0 to 0x8CF7 */
0x6405, 0x74D2, 0x7A83, 0x7F28, 0x81E2, 0x841D, 0x86CA, 0x0000, 	/* 0x8CF8 to 0x8CFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D00 to 0x8D07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D08 to 0x8D0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D10 to 0x8D17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D18 to 0x8D1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D20 to 0x8D27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D28 to 0x8D2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D30 to 0x8D37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D38 to 0x8D3F */
0x53D8, 0x9026, 0x903B, 0x9573, 0x94C4, 0x9765, 0x663E, 0x990D, 	/* 0x8D40 to 0x8D47 */
0x60CA, 0x9A7F, 0x9A8C, 0x9AD3, 0x9AD1, 0x9CDD, 0x9CDE, 0x9CDC, 	/* 0x8D48 to 0x8D4F */
0x9E36, 0x5631, 0x575D, 0x63FD, 0x762B, 0x766B, 0x7F81, 0x8695, 	/* 0x8D50 to 0x8D57 */
0x8BA9, 0x8C17, 0x8C36, 0x8273, 0x8D63, 0x917F, 0x96F3, 0x7075, 	/* 0x8D58 to 0x8D5F */
0x972D, 0x98A6, 0x9AA4, 0x9B13, 0x9B47, 0x9C8E, 0x9E70, 0x9E6D, 	/* 0x8D60 to 0x8D67 */
0x7877, 0x76D0, 0x9CCC, 0x9F8C, 0x9F8B, 0x5385, 0x6984, 0x6E7E, 	/* 0x8D68 to 0x8D6F */
0x7BF1, 0x7BA9, 0x86EE, 0x89C2, 0x8E51, 0x8845, 0x94A5, 0x9885, 	/* 0x8D70 to 0x8D77 */
0x998B, 0x9ACB, 0x9EC9, 0x6EE6, 0x77A9, 0x954A, 0x97AF, 0x0000, 	/* 0x8D78 to 0x8D7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D80 to 0x8D87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D88 to 0x8D8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D90 to 0x8D97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8D98 to 0x8D9F */
0x0000, 0x9A74, 0x9AA5, 0x7F06, 0x8C20, 0x8E8F, 0x917D, 0x94BB, 	/* 0x8DA0 to 0x8DA7 */
0x92AE, 0x9523, 0x9CC4, 0x9C88, 0x9EE9, 0x51FF, 0x9E66, 0x9A8A, 	/* 0x8DA8 to 0x8DAF */
0x9E73, 0x9E3E, 0x94BA, 0x4EC2, 0x864D, 0x6B92, 0x57A7, 0x577B, 	/* 0x8DB0 to 0x8DB7 */
0x620B, 0x4FE3, 0x522D, 0x538D, 0x5459, 0x537A, 0x7EA8, 0x8307, 	/* 0x8DB8 to 0x8DBF */
0x9487, 0x9486, 0x5457, 0x5F2A, 0x7953, 0x7EBE, 0x90CF, 0x948C, 	/* 0x8DC0 to 0x8DC7 */
0x5250, 0x5326, 0x56F5, 0x57AD, 0x5A05, 0x5CBD, 0x5D03, 0x6D9E, 	/* 0x8DC8 to 0x8DCF */
0x6E0C, 0x70C3, 0x7726, 0x7EC0, 0x7ED0, 0x80EB, 0x948E, 0x9490, 	/* 0x8DD0 to 0x8DD7 */
0x9495, 0x948D, 0x95EB, 0x59AB, 0x5D5B, 0x607D, 0x6860, 0x67A8, 	/* 0x8DD8 to 0x8DDF */
0x6CA9, 0x6D48, 0x7572, 0x7817, 0x7ED7, 0x83DD, 0x89C7, 0x8BB5, 	/* 0x8DE0 to 0x8DE7 */
0x8BCE, 0x8BD2, 0x8D36, 0x8D33, 0x8F7A, 0x8F75, 0x8F78, 0x902F, 	/* 0x8DE8 to 0x8DEF */
0x90D3, 0x9104, 0x94AB, 0x94AC, 0x949B, 0x94AF, 0x94AD, 0x94AA, 	/* 0x8DF0 to 0x8DF7 */
0x95F6, 0x9667, 0x9878, 0x996B, 0x9EF9, 0x4F1B, 0x507B, 0x0000, 	/* 0x8DF8 to 0x8DFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E00 to 0x8E07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E08 to 0x8E0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E10 to 0x8E17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E18 to 0x8E1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E20 to 0x8E27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E28 to 0x8E2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E30 to 0x8E37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E38 to 0x8E3F */
0x4F65, 0x5522, 0x57B2, 0x5DEF, 0x5FAD, 0x709C, 0x8315, 0x72F2, 	/* 0x8E40 to 0x8E47 */
0x73AE, 0x7EE8, 0x7EE0, 0x7EE1, 0x7F9F, 0x836D, 0x86F1, 0x8BD3, 	/* 0x8E48 to 0x8E4F */
0x8BD6, 0x8BE9, 0x8BD4, 0x8BDC, 0x8D91, 0x8F82, 0x8F81, 0x90AC, 	/* 0x8E50 to 0x8E57 */
0x94CA, 0x94C8, 0x94B0, 0x94B2, 0x94B6, 0x950D, 0x94CC, 0x94BD, 	/* 0x8E58 to 0x8E5F */
0x94BC, 0x9883, 0x9880, 0x51EB, 0x9EFE, 0x507E, 0x551B, 0x5D5D, 	/* 0x8E60 to 0x8E67 */
0x5E3B, 0x60AB, 0x60AD, 0x6004, 0x622C, 0x6217, 0x629F, 0x62A0, 	/* 0x8E68 to 0x8E6F */
0x63BC, 0x6864, 0x6769, 0x8365, 0x6D52, 0x6CA4, 0x709D, 0x76B2, 	/* 0x8E70 to 0x8E77 */
0x7800, 0x7EFB, 0x7EF2, 0x7EEF, 0x7EFA, 0x83B3, 0x89CB, 0x0000, 	/* 0x8E78 to 0x8E7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E80 to 0x8E87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E88 to 0x8E8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E90 to 0x8E97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8E98 to 0x8E9F */
0x0000, 0x8BF6, 0x8D47, 0x94F1, 0x94D2, 0x94D1, 0x94D5, 0x94DF, 	/* 0x8EA0 to 0x8EA7 */
0x94EB, 0x94EF, 0x94EA, 0x94F7, 0x94D6, 0x94E5, 0x98D1, 0x523F, 	/* 0x8EA8 to 0x8EAF */
0x52A2, 0x54D3, 0x5452, 0x5D02, 0x5CE4, 0x5E91, 0x6126, 0x6322, 	/* 0x8EB0 to 0x8EB7 */
0x6920, 0x6BF5, 0x988D, 0x6D9D, 0x6F62, 0x6DA0, 0x6ED7, 0x740F, 	/* 0x8EB8 to 0x8EBF */
0x7481, 0x7617, 0x7F03, 0x7F17, 0x7F0C, 0x7F0F, 0x7F11, 0x835C, 	/* 0x8EC0 to 0x8EC7 */
0x848C, 0x8311, 0x82C1, 0x8BF9, 0x8BFC, 0x8C02, 0x8D55, 0x90F8, 	/* 0x8EC8 to 0x8ECF */
0x9512, 0x94D7, 0x94FD, 0x9513, 0x950A, 0x94E4, 0x9506, 0x9507, 	/* 0x8ED0 to 0x8ED7 */
0x9514, 0x9606, 0x9603, 0x9753, 0x988F, 0x997D, 0x9A75, 0x9A80, 	/* 0x8ED8 to 0x8EDF */
0x9C82, 0x9E28, 0x54D2, 0x54D5, 0x54D9, 0x5AD2, 0x5CC4, 0x603F, 	/* 0x8EE0 to 0x8EE7 */
0x6B9A, 0x6D4D, 0x70E8, 0x7303, 0x72EF, 0x789C, 0x7AAD, 0x7E17, 	/* 0x8EE8 to 0x8EEF */
0x7F1B, 0x8487, 0x8368, 0x8489, 0x835E, 0x83B8, 0x8297, 0x86F3, 	/* 0x8EF0 to 0x8EF7 */
0x8BE8, 0x8C11, 0x8C14, 0x8C1D, 0x90D0, 0x9529, 0x952C, 0x0000, 	/* 0x8EF8 to 0x8EFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F00 to 0x8F07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F08 to 0x8F0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F10 to 0x8F17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F18 to 0x8F1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F20 to 0x8F27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F28 to 0x8F2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F30 to 0x8F37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F38 to 0x8F3F */
0x9516, 0x9517, 0x94FC, 0x951B, 0x9515, 0x951E, 0x9494, 0x960F, 	/* 0x8F40 to 0x8F47 */
0x9608, 0x9609, 0x960A, 0x960C, 0x960D, 0x9E32, 0x9E31, 0x54DC, 	/* 0x8F48 to 0x8F4F */
0x5E31, 0x6079, 0x6448, 0xE3C1, 0x6CF6, 0x7315, 0x7513, 0x7605, 	/* 0x8F50 to 0x8F57 */
0x75EB, 0x7857, 0x7BA6, 0x7B5A, 0x7CE8, 0x7F21, 0x8027, 0x835F, 	/* 0x8F58 to 0x8F5F */
0x83B6, 0x86F0, 0x88E2, 0x89CF, 0x8C21, 0x8BCC, 0x8C25, 0x8DC4, 	/* 0x8F60 to 0x8F67 */
0x9538, 0x9534, 0x94E1, 0x9536, 0x9612, 0x9967, 0x9C92, 0x9C95, 	/* 0x8F68 to 0x8F6F */
0x9E38, 0x9E39, 0x9E3A, 0x9F80, 0x603C, 0x6445, 0x64B8, 0x6CFA, 	/* 0x8F70 to 0x8F77 */
0x7596, 0x7F0B, 0x8069, 0x8369, 0x87E5, 0x866E, 0x8BB4, 0x0000, 	/* 0x8F78 to 0x8F7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F80 to 0x8F87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F88 to 0x8F8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F90 to 0x8F97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x8F98 to 0x8F9F */
0x0000, 0x8C29, 0x8D5C, 0x8D3D, 0x8F98, 0x909D, 0x9553, 0x94E0, 	/* 0x8FA0 to 0x8FA7 */
0x953C, 0x954F, 0x84E5, 0x97EA, 0x9969, 0x9A90, 0x9A92, 0x9A93, 	/* 0x8FA8 to 0x8FAF */
0x960B, 0x9CA9, 0x9CA0, 0x9E48, 0x9E41, 0x9E46, 0x53A3, 0x5456, 	/* 0x8FB0 to 0x8FB7 */
0x5786, 0x69E0, 0x680E, 0x6C07, 0x6CF7, 0x6F46, 0x7962, 0x7F32, 	/* 0x8FB8 to 0x8FBF */
0x7F33, 0x7F74, 0x8223, 0x86CF, 0x867F, 0x88E3, 0x89D1, 0x89EF, 	/* 0x8FC0 to 0x8FC7 */
0x8C2E, 0x955B, 0x955F, 0x956A, 0x9546, 0x94E9, 0x97EB, 0x98A1, 	/* 0x8FC8 to 0x8FCF */
0x9990, 0x9AC2, 0x9CB5, 0x9CB6, 0x9CBB, 0x9CB1, 0x9E4E, 0x9E2B, 	/* 0x8FD0 to 0x8FD7 */
0x9EFC, 0x55BE, 0x6484, 0x680A, 0x67A5, 0x680C, 0x7F31, 0x804D, 	/* 0x8FD8 to 0x8FDF */
0x830F, 0x82C8, 0x8572, 0x86F4, 0x877E, 0x94F4, 0x9566, 0x9568, 	/* 0x8FE0 to 0x8FE7 */
0x9561, 0x9563, 0x9544, 0x956B, 0x94E7, 0x9564, 0x94F9, 0x961A, 	/* 0x8FE8 to 0x8FEF */
0x989F, 0x9994, 0x9A7A, 0x9A9D, 0x9A9F, 0x9A98, 0x9E57, 0x9E5A, 	/* 0x8FF0 to 0x8FF7 */
0x9E5C, 0x9F86, 0x9F85, 0x50A9, 0x5CBF, 0x75C8, 0x64BA, 0x0000, 	/* 0x8FF8 to 0x8FFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9000 to 0x9007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9008 to 0x900F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9010 to 0x9017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9018 to 0x901F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9020 to 0x9027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9028 to 0x902F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9030 to 0x9037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9038 to 0x903F */
0x6989, 0x6EE0, 0x783B, 0x7C9D, 0x7EA9, 0x7F2C, 0x8539, 0x8D46, 	/* 0x9040 to 0x9047 */
0x9571, 0x95FC, 0x98D9, 0x9AA2, 0x9A96, 0x9A9C, 0x9CA5, 0x9CCE, 	/* 0x9048 to 0x904F */
0x9CD0, 0x9E63, 0x9E58, 0x9E7E, 0x5181, 0x5A08, 0x7055, 0x6512, 	/* 0x9050 to 0x9057 */
0x763F, 0x7BA8, 0x7C74, 0x823B, 0x89CC, 0x8DF9, 0x8DDE, 0x8F79, 	/* 0x9058 to 0x905F */
0x9554, 0x956C, 0x9AA3, 0x9A85, 0x9CD5, 0x9CA3, 0x9CA6, 0x9E68, 	/* 0x9060 to 0x9067 */
0x9E37, 0x9F9B, 0x683E, 0x6924, 0x84E0, 0x96E0, 0x8F73, 0x9CDF, 	/* 0x9068 to 0x906F */
0x9C9F, 0x9E69, 0x9E6C, 0x9E6A, 0x9E6B, 0x9E47, 0x704F, 0x7C16, 	/* 0x9070 to 0x9077 */
0x8C30, 0x9ACC, 0x7B3E, 0x7C9C, 0x7F35, 0x8114, 0x8E7F, 0x0000, 	/* 0x9078 to 0x907F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9080 to 0x9087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9088 to 0x908F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9090 to 0x9097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9098 to 0x909F */
0x0000, 0x9567, 0x9C9A, 0x8DB1, 0x8E9C, 0x917E, 0x8C33, 0x989E, 	/* 0x90A0 to 0x90A7 */
0x98A7, 0x9AA7, 0x9E2C, 0x6206, 0x9604, 0x9CA1, 0x9E42, 0x79B8, 	/* 0x90A8 to 0x90AF */
0x62D4, 0x8DCB, 0x73D0, 0x5BAB, 0x62D0, 0x6BC1, 0x51CF, 0x7984, 	/* 0x90B0 to 0x90B7 */
0x5415, 0x6F5C, 0x889C, 0x90E7, 0x5179, 0x6238, 0x629B, 0x6327, 	/* 0x90B8 to 0x90BF */
0x63BB, 0x63DE, 0x63FA, 0x6491, 0x64C0, 0x64E1, 0x64F6, 0x6505, 	/* 0x90C0 to 0x90C7 */
0x6535, 0x654E, 0x656B, 0x6588, 0x65D9, 0x661E, 0x663B, 0x663F, 	/* 0x90C8 to 0x90CF */
0x6644, 0x6657, 0x6669, 0x6673, 0x6683, 0x66BC, 0x66BF, 0x66C1, 	/* 0x90D0 to 0x90D7 */
0x66F5, 0x66FA, 0x66FB, 0x670E, 0x6716, 0x6737, 0x6764, 0x6766, 	/* 0x90D8 to 0x90DF */
0x67A6, 0x67A7, 0x67A9, 0x67FB, 0x67FD, 0x6800, 0x6801, 0x6805, 	/* 0x90E0 to 0x90E7 */
0x681E, 0x684A, 0x6852, 0x6855, 0x6859, 0x688D, 0x68B9, 0x68CF, 	/* 0x90E8 to 0x90EF */
0x5088, 0x9528, 0x9C97, 0x6922, 0x6926, 0x00DC, 0xE4DF, 0xE4E0, 	/* 0x90F0 to 0x90F7 */
0x00FC, 0xE4E2, 0xE4E3, 0x00DC, 0x00FC, 0x6936, 0x6961, 0x0000, 	/* 0x90F8 to 0x90FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9100 to 0x9107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9108 to 0x910F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9110 to 0x9117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9118 to 0x911F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9120 to 0x9127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9128 to 0x912F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9130 to 0x9137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9138 to 0x913F */
0x82C5, 0x82CA, 0x82D8, 0x8318, 0x831A, 0x8323, 0x8346, 0x835B, 	/* 0x9140 to 0x9147 */
0x8362, 0x836C, 0x836E, 0x839C, 0x839F, 0x83B5, 0x83BC, 0x83F7, 	/* 0x9148 to 0x914F */
0x842A, 0x8448, 0x845C, 0x8462, 0x8484, 0x8488, 0x84DC, 0x84E3, 	/* 0x9150 to 0x9157 */
0x8538, 0x855A, 0x8597, 0x85AB, 0x85C1, 0x8613, 0x8616, 0x220B, 	/* 0x9158 to 0x915F */
0x8715, 0x8770, 0x877D, 0x878B, 0x87A8, 0x87C7, 0x87D0, 0x8807, 	/* 0x9160 to 0x9167 */
0x880E, 0x8827, 0x88AE, 0x2208, 0x88B5, 0x88BF, 0x88E5, 0x88F5, 	/* 0x9168 to 0x916F */
0x891C, 0x891D, 0x8977, 0x89E7, 0x8A37, 0x8AAC, 0x8ADA, 0x8B5B, 	/* 0x9170 to 0x9177 */
0x8B71, 0x8C2B, 0x8C3A, 0x8C7C, 0x8C8E, 0x8CAE, 0x8D12, 0x0000, 	/* 0x9178 to 0x917F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9180 to 0x9187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9188 to 0x918F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9190 to 0x9197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9198 to 0x919F */
0x0000, 0x8D49, 0x8D4D, 0x8D71, 0x8E08, 0x8E3A, 0x8E70, 0x8E99, 	/* 0x91A0 to 0x91A7 */
0x8EB0, 0x8EB1, 0x8EC5, 0x8EC6, 0x8ECE, 0x8EE3, 0x8F0C, 0x8F71, 	/* 0x91A8 to 0x91AF */
0x8F77, 0x8FA7, 0x8FEF, 0x900E, 0x9039, 0x9065, 0x9089, 0x90DE, 	/* 0x91B0 to 0x91B7 */
0x9115, 0x91D6, 0x91DB, 0x91DE, 0x91E1, 0x91E5, 0x91F6, 0x91FC, 	/* 0x91B8 to 0x91BF */
0x9229, 0x922C, 0xFF07, 0x9259, 0x9277, 0x92ED, 0x933A, 0xE54D, 	/* 0x91C0 to 0x91C7 */
0xE54E, 0x722B, 0x5182, 0x5196, 0x4E37, 0x516B, 0x513F, 0xE555, 	/* 0x91C8 to 0x91CF */
0xE556, 0x6729, 0x6C3A, 0x5382, 0x7592, 0x8080, 0x8864, 0x4E06, 	/* 0x91D0 to 0x91D7 */
0xE55E, 0xE55F, 0xE560, 0x2E97, 0x52F9, 0x5315, 0x2021, 0xE565, 	/* 0x91D8 to 0x91DF */
0x3404, 0xE567, 0xE568, 0xE569, 0xE56A, 0xE56B, 0x51F5, 0xE56D, 	/* 0x91E0 to 0x91E7 */
0x5C6E, 0xE56F, 0x56D7, 0x4EA0, 0x51AB, 0x2E80, 0x69C7, 0xE575, 	/* 0x91E8 to 0x91EF */
0x254E, 0x25D8, 0x25D9, 0x2642, 0x25B6, 0x25C4, 0x2195, 0x203C, 	/* 0x91F0 to 0x91F7 */
0x00B6, 0x2200, 0x21A8, 0x2194, 0x2302, 0xE583, 0xE584, 0x0000, 	/* 0x91F8 to 0x91FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9200 to 0x9207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9208 to 0x920F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9210 to 0x9217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9218 to 0x921F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9220 to 0x9227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9228 to 0x922F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9230 to 0x9237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9238 to 0x923F */
0x4E9C, 0x60AA, 0x5727, 0x56F2, 0x533B, 0x58F1, 0x9038, 0x96A0, 	/* 0x9240 to 0x9247 */
0x6804, 0x55B6, 0x99C5, 0x8B01, 0x5186, 0x7E01, 0x5FDC, 0x6B27, 	/* 0x9248 to 0x924F */
0x6BB4, 0x685C, 0x5965, 0x7A4F, 0x4EEE, 0x4FA1, 0x753B, 0x7070, 	/* 0x9250 to 0x9257 */
0x4F1A, 0x6094, 0x6D77, 0x7D75, 0x58CA, 0x61D0, 0x62E1, 0x6BBB, 	/* 0x9258 to 0x925F */
0x899A, 0x5B66, 0x697D, 0x559D, 0x6E07, 0xE5AA, 0x5DFB, 0x9665, 	/* 0x9260 to 0x9267 */
0x52E7, 0x5BDB, 0x6F22, 0x95A2, 0x6B53, 0x89B3, 0x6C17, 0x5E30, 	/* 0x9268 to 0x926F */
0x622F, 0x72A0, 0x8650, 0x65E7, 0x6025, 0x62E0, 0x6319, 0x865A, 	/* 0x9270 to 0x9277 */
0x5CE1, 0x631F, 0x72ED, 0x90F7, 0x97FF, 0x6681, 0x52E4, 0x0000, 	/* 0x9278 to 0x927F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9280 to 0x9287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9288 to 0x928F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9290 to 0x9297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9298 to 0x929F */
0x0000, 0x8B39, 0x533A, 0x99C6, 0x52F2, 0xE5C8, 0x5F84, 0x830E, 	/* 0x92A0 to 0x92A7 */
0x6075, 0x63B2, 0x6E13, 0x7D4C, 0x86CD, 0x8EFD, 0x7D99, 0x9D8F, 	/* 0x92A8 to 0x92AF */
0x6483, 0x770C, 0x5039, 0x5263, 0x967A, 0x570F, 0x691C, 0x6A29, 	/* 0x92B0 to 0x92B7 */
0x9855, 0x9A13, 0x53B3, 0x5449, 0x5A2F, 0x8AA4, 0x5E83, 0x6E2F, 	/* 0x92B8 to 0x92BF */
0x9271, 0x53F7, 0x56FD, 0x9ED2, 0x7A40, 0x7815, 0x6E08, 0x658E, 	/* 0x92C0 to 0x92C7 */
0x6B73, 0x5264, 0x96D1, 0x53C2, 0x685F, 0x60E8, 0x8CDB, 0x6B8B, 	/* 0x92C8 to 0x92CF */
0x6B6F, 0x5150, 0x8F9E, 0x6E7F, 0x5B9F, 0x5199, 0x820E, 0x6368, 	/* 0x92D0 to 0x92D7 */
0x91C8, 0x5BFF, 0x53CE, 0x8846, 0x5F93, 0x6E0B, 0x7363, 0x7E26, 	/* 0x92D8 to 0x92DF */
0x7C9B, 0x51E6, 0x5C06, 0x79F0, 0x6E09, 0x713C, 0x5968, 0x6761, 	/* 0x92E0 to 0x92E7 */
0x72B6, 0x4E57, 0x6D44, 0x5270, 0x7573, 0x7E04, 0x58CC, 0x5B22, 	/* 0x92E8 to 0x92EF */
0x8B72, 0x91B8, 0x89E6, 0x5631, 0x5BDD, 0x5C3D, 0x56F3, 0x7C8B, 	/* 0x92F0 to 0x92F7 */
0x9154, 0x7A42, 0x968F, 0x9AC4, 0x67A2, 0x6570, 0x636E, 0x0000, 	/* 0x92F8 to 0x92FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9300 to 0x9307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9308 to 0x930F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9310 to 0x9317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9318 to 0x931F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9320 to 0x9327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9328 to 0x932F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9330 to 0x9337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9338 to 0x933F */
0x702C, 0x58F0, 0x6589, 0x9759, 0x7A83, 0x6442, 0x7D76, 0x5C02, 	/* 0x9340 to 0x9347 */
0x6D45, 0x6226, 0x8DF5, 0x92AD, 0x6F5C, 0x9077, 0x9078, 0x7E4A, 	/* 0x9348 to 0x934F */
0x7985, 0x758E, 0x58EE, 0x4E89, 0x8358, 0x635C, 0x633F, 0x5DE3, 	/* 0x9350 to 0x9357 */
0x7A93, 0x88C5, 0x50E7, 0x5C64, 0x7DCF, 0x9A12, 0x5897, 0x618E, 	/* 0x9358 to 0x935F */
0x8535, 0x8D08, 0x81D3, 0x5C5E, 0x7D9A, 0x5815, 0x5BFE, 0x5E2F, 	/* 0x9360 to 0x9367 */
0x6EDE, 0x6EDD, 0x629E, 0x6CA2, 0x6FEF, 0x5358, 0x5606, 0x56E3, 	/* 0x9368 to 0x936F */
0x65AD, 0x5F3E, 0x9045, 0x663C, 0x92F3, 0x5E81, 0x5FB4, 0x8074, 	/* 0x9370 to 0x9377 */
0x61F2, 0x585A, 0x9013, 0x9244, 0x70B9, 0x8EE2, 0x4F1D, 0x0000, 	/* 0x9378 to 0x937F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9380 to 0x9387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9388 to 0x938F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9390 to 0x9397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9398 to 0x939F */
0x0000, 0x96FB, 0x706F, 0x5F53, 0x515A, 0x76D7, 0x7A32, 0x95D8, 	/* 0x93A0 to 0x93A7 */
0x5FB3, 0x6BD2, 0x72EC, 0x8AAD, 0x5C4A, 0x96E3, 0x5F10, 0x60A9, 	/* 0x93A8 to 0x93AF */
0x8133, 0x62DD, 0x5EC3, 0x58F2, 0x6885, 0x535A, 0x8584, 0x9EA6, 	/* 0x93B0 to 0x93B7 */
0x7E1B, 0x767A, 0x9AEA, 0x629C, 0x6D5C, 0x6D5C, 0x654F, 0x6577, 	/* 0x93B8 to 0x93BF */
0x4FAE, 0x6255, 0x4ECF, 0x8FBA, 0x5909, 0x6B69, 0x8217, 0x7C3F, 	/* 0x93C0 to 0x93C7 */
0x5305, 0x5B9D, 0x62B1, 0x6CE1, 0x80DE, 0x7832, 0x8C4A, 0x98FD, 	/* 0x93C8 to 0x93CF */
0x58A8, 0x6BCE, 0x6E80, 0x8108, 0x9ED9, 0x8A33, 0x85AC, 0x8E8D, 	/* 0x93D0 to 0x93D7 */
0x4E0E, 0x8A89, 0x6447, 0x69D8, 0x8B21, 0x66DC, 0x6765, 0x983C, 	/* 0x93D8 to 0x93DF */
0x4E71, 0x89A7, 0x7ADC, 0x9686, 0x65C5, 0x4E21, 0x731F, 0x7DD1, 	/* 0x93E0 to 0x93E7 */
0x6D99, 0x5841, 0x793C, 0x52B1, 0x623B, 0x970A, 0x9F62, 0x66A6, 	/* 0x93E8 to 0x93EF */
0x6B74, 0x604B, 0x7DF4, 0x932C, 0x7089, 0x52B4, 0x697C, 0x9332, 	/* 0x93F0 to 0x93F7 */
0x6E7E, 0x5F25, 0x4E80, 0x66FD, 0x59C9, 0x5B8D, 0x5D8B, 0x0000, 	/* 0x93F8 to 0x93FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9400 to 0x9407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9408 to 0x940F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9410 to 0x9417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9418 to 0x941F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9420 to 0x9427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9428 to 0x942F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9430 to 0x9437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9438 to 0x943F */
0x6A2B, 0x691B, 0x55B0, 0x7C82, 0x8FBC, 0x698A, 0x54B2, 0x9D2B, 	/* 0x9440 to 0x9447 */
0x96EB, 0x6919, 0x63C3, 0x99C4, 0x51E7, 0x6802, 0x8FBB, 0x50CD, 	/* 0x9448 to 0x944F */
0x5CE0, 0x6803, 0x51EA, 0x5302, 0x7872, 0x7551, 0x7560, 0x567A, 	/* 0x9450 to 0x9457 */
0x92F2, 0x5840, 0x67FE, 0x4FE3, 0x6762, 0x7C7E, 0x5301, 0x4FE4, 	/* 0x9458 to 0x945F */
0x4FE5, 0x51E9, 0x53FA, 0x54D8, 0x56CE, 0x5726, 0x5737, 0x5738, 	/* 0x9460 to 0x9467 */
0x5788, 0x57B3, 0x57AA, 0x57B0, 0x57D6, 0x5870, 0x58B9, 0x58D7, 	/* 0x9468 to 0x946F */
0x5C76, 0x5CBC, 0x5CC5, 0x5CBE, 0x5D76, 0x5F16, 0x603A, 0x63B5, 	/* 0x9470 to 0x9477 */
0x6741, 0x6763, 0x67A1, 0x68BA, 0x6925, 0x6928, 0x6A7A, 0x0000, 	/* 0x9478 to 0x947F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9480 to 0x9487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9488 to 0x948F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9490 to 0x9497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9498 to 0x949F */
0x0000, 0x6923, 0x6921, 0x697E, 0x6981, 0x69DD, 0x6A2E, 0x6A72, 	/* 0x94A0 to 0x94A7 */
0x6B1F, 0x6BDF, 0x6E15, 0x7195, 0x74E7, 0x74F2, 0x74F0, 0x74F1, 	/* 0x94A8 to 0x94AF */
0x74F8, 0x7505, 0x7569, 0x766A, 0x7874, 0x7ACD, 0x7ACF, 0x7AD5, 	/* 0x94B0 to 0x94B7 */
0x7AD3, 0x7AE1, 0x7AF0, 0x7B02, 0x7C13, 0x7C17, 0x7C90, 0x7CAD, 	/* 0x94B8 to 0x94BF */
0x7CC0, 0x7CD8, 0x7D9B, 0x7E05, 0x7E67, 0x7E83, 0x7E90, 0x81A4, 	/* 0x94C0 to 0x94C7 */
0x825D, 0x8422, 0x84D9, 0x8630, 0x86AB, 0x86EF, 0x88B0, 0x88C3, 	/* 0x94C8 to 0x94CF */
0x88C4, 0x8904, 0xE72F, 0x8EBE, 0x8EC8, 0x8F4C, 0x8FB7, 0x8FDA, 	/* 0x94D0 to 0x94D7 */
0x9027, 0x9056, 0x9335, 0x933B, 0x93B9, 0x958A, 0x9596, 0x9779, 	/* 0x94D8 to 0x94DF */
0x9786, 0x9790, 0x98AA, 0x9B96, 0x9B97, 0x9BB4, 0x9BCF, 0x9BD1, 	/* 0x94E0 to 0x94E7 */
0x9BD2, 0x9BF2, 0x9BF1, 0x9C30, 0x9C47, 0x9C5A, 0x9CF0, 0x9D46, 	/* 0x94E8 to 0x94EF */
0x9D64, 0x9DAB, 0x4E44, 0x544F, 0x6318, 0x9BB1, 0x9C69, 0x9D47, 	/* 0x94F0 to 0x94F7 */
0x9D65, 0x9C2F, 0x9EBF, 0x51B4, 0x546A, 0x67A0, 0x9B8E, 0x0000, 	/* 0x94F8 to 0x94FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9500 to 0x9507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9508 to 0x950F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9510 to 0x9517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9518 to 0x951F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9520 to 0x9527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9528 to 0x952F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9530 to 0x9537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9538 to 0x953F */
0x90A8, 0x51B2, 0x362D, 0x62C5, 0x52C5, 0x67B1, 0x54CD, 0x6052, 	/* 0x9540 to 0x9547 */
0x53C1, 0x70F1, 0x5803, 0x555F, 0x920E, 0x7740, 0x743C, 0x714A, 	/* 0x9548 to 0x954F */
0x6ED9, 0x53E0, 0x732E, 0x88CF, 0x788D, 0x7FA3, 0x7DAB, 0x8E2A, 	/* 0x9550 to 0x9557 */
0x945B, 0x636C, 0x5FA7, 0x5C05, 0x803B, 0x5CEF, 0x39B8, 0x7151, 	/* 0x9558 to 0x955F */
0x8CCD, 0x97EE, 0x5872, 0x5A63, 0x7F78, 0x5D57, 0x616F, 0x6998, 	/* 0x9560 to 0x9567 */
0x7D89, 0x7CAE, 0x7DB3, 0x6F81, 0x5AFA, 0x58BB, 0x7255, 0x764E, 	/* 0x9568 to 0x956F */
0x8F2D, 0x92B9, 0x9D5E, 0x9EAF, 0x7F47, 0x9DC4, 0x8D18, 0x51B3, 	/* 0x9570 to 0x9577 */
0x866C, 0x54A4, 0x53A6, 0x5226, 0x6736, 0x4E21, 0x5374, 0x0000, 	/* 0x9578 to 0x957F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9580 to 0x9587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9588 to 0x958F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9590 to 0x9597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9598 to 0x959F */
0x0000, 0x5EF9, 0x52B9, 0x548F, 0x5EF8, 0x59AC, 0x6031, 0x7240, 	/* 0x95A0 to 0x95A7 */
0x8117, 0x763B, 0x5F0D, 0x664B, 0x66A8, 0x6164, 0x634F, 0x70DF, 	/* 0x95A8 to 0x95AF */
0x6D24, 0x7CA7, 0x7CC9, 0x53D9, 0x654D, 0x5742, 0x73CF, 0x80C6, 	/* 0x95B0 to 0x95B7 */
0x3551, 0x6B35, 0x7881, 0x53CC, 0x732B, 0x732A, 0x73C9, 0x754A, 	/* 0x95B8 to 0x95BF */
0x59F9, 0x71C4, 0x750E, 0x7DDC, 0x99E1, 0x89A9, 0x6FF6, 0x3A57, 	/* 0x95C0 to 0x95C7 */
0x64EA, 0x3BED, 0x6CA1, 0x6E7C, 0x7567, 0x5869, 0x5869, 0x5204, 	/* 0x95C8 to 0x95CF */
0xE7CA, 0x6187, 0x643A, 0x81EF, 0xE7CE, 0x51B5, 0x51D1, 0x6C79, 	/* 0x95D0 to 0x95D7 */
0x591F, 0x8FF9, 0x98F1, 0x6537, 0x8109, 0x88B4, 0x3A2A, 0x8EAD, 	/* 0x95D8 to 0x95DF */
0x7F97, 0x9A10, 0x7D25, 0x6AC8, 0x518C, 0x5227, 0xE7E0, 0x811A, 	/* 0x95E0 to 0x95E7 */
0x53A0, 0x53A2, 0x6C5A, 0x6C37, 0x8218, 0x5586, 0x5EFB, 0x51C9, 	/* 0x95E8 to 0x95EF */
0x78B1, 0x9262, 0x536D, 0x51C3, 0xE7EE, 0x8471, 0x8987, 0x976D, 	/* 0x95F0 to 0x95F7 */
0x8B90, 0x96A3, 0x5EFC, 0x96B7, 0x514E, 0x9C10, 0x6630, 0x0000, 	/* 0x95F8 to 0x95FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9600 to 0x9607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9608 to 0x960F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9610 to 0x9617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9618 to 0x961F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9620 to 0x9627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9628 to 0x962F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9630 to 0x9637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9638 to 0x963F */
0x9255, 0x7808, 0x9345, 0x9273, 0x9369, 0xE7FE, 0xE7FF, 0xE800, 	/* 0x9640 to 0x9647 */
0xE801, 0x91DF, 0x91DA, 0x7854, 0x7866, 0x7888, 0x78B6, 0x78C7, 	/* 0x9648 to 0x964F */
0x78D2, 0x78D7, 0x212B, 0x21CB, 0x78E4, 0x78EE, 0x78F0, 0x78F1, 	/* 0x9650 to 0x9657 */
0x78F5, 0x7932, 0x7933, 0x7936, 0x7958, 0x3013, 0x7959, 0x7971, 	/* 0x9658 to 0x965F */
0x797E, 0x7983, 0x7986, 0x7987, 0x7991, 0x7999, 0x799F, 0x79A5, 	/* 0x9660 to 0x9667 */
0x79E2, 0x79F1, 0x79F4, 0x7A2A, 0x7A3A, 0x7A45, 0x7A65, 0x7ABC, 	/* 0x9668 to 0x966F */
0x7AC2, 0x7AC9, 0x7ADB, 0x7AE9, 0x7AFE, 0x7B0C, 0x7B27, 0x7B29, 	/* 0x9670 to 0x9677 */
0x7B42, 0x7B43, 0x7B55, 0x7B6F, 0x7BB2, 0x69DE, 0x69F9, 0x0000, 	/* 0x9678 to 0x967F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9680 to 0x9687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9688 to 0x968F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9690 to 0x9697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9698 to 0x969F */
0x0000, 0x9176, 0x815A, 0x82F7, 0x544B, 0x8132, 0x80BD, 0x8418, 	/* 0x96A0 to 0x96A7 */
0x915E, 0x9170, 0x918C, 0x8148, 0xE843, 0x4436, 0x8159, 0x809F, 	/* 0x96A8 to 0x96AF */
0xE847, 0x5549, 0x5421, 0x54DA, 0x5432, 0x55B9, 0x5494, 0xE84E, 	/* 0x96B0 to 0x96B7 */
0x7852, 0x7845, 0x784C, 0xE852, 0x84BD, 0x841C, 0x82C4, 0xE856, 	/* 0x96B8 to 0x96BF */
0x847B, 0x8B2D, 0xE859, 0x574B, 0xE85B, 0xE85C, 0x5745, 0x87CE, 	/* 0x96C0 to 0x96C7 */
0x5660, 0x55EA, 0x567B, 0x80BC, 0xE863, 0x78B8, 0x6A0C, 0x54CC, 	/* 0x96C8 to 0x96CF */
0x7BD0, 0x7BEC, 0x7BFA, 0x7C15, 0x7C1B, 0x7C35, 0x7C44, 0x7C6D, 	/* 0x96D0 to 0x96D7 */
0x7C8E, 0x7CB8, 0x7CC3, 0x7CE6, 0x7CED, 0x7CF3, 0x7CF5, 0x7CF9, 	/* 0x96D8 to 0x96DF */
0xE877, 0x7CFC, 0x7D8B, 0x7D97, 0x7DA4, 0x7DA8, 0x7DCD, 0x7DD0, 	/* 0x96E0 to 0x96E7 */
0x7DD3, 0x7DE5, 0x7DFD, 0x6A12, 0x6A22, 0x6A30, 0x6A36, 0x6A65, 	/* 0x96E8 to 0x96EF */
0xE887, 0xE888, 0xE889, 0xE88A, 0xE88B, 0xE88C, 0xE88D, 0xE88E, 	/* 0x96F0 to 0x96F7 */
0x6A73, 0x6A78, 0xE891, 0xE892, 0x6A7C, 0x6AA9, 0x6AAA, 0x0000, 	/* 0x96F8 to 0x96FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9700 to 0x9707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9708 to 0x970F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9710 to 0x9717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9718 to 0x971F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9720 to 0x9727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9728 to 0x972F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9730 to 0x9737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9738 to 0x973F */
0x24EA, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 	/* 0x9740 to 0x9747 */
0x2467, 0x2468, 0x2469, 0x246A, 0x246B, 0x246C, 0x246D, 0x246E, 	/* 0x9748 to 0x974F */
0x246F, 0x2470, 0x2471, 0x2472, 0x2473, 0x9344, 0x93AD, 0x93C6, 	/* 0x9750 to 0x9757 */
0x93E5, 0x941A, 0x9421, 0x943E, 0x9441, 0x9453, 0x945A, 0x949A, 	/* 0x9758 to 0x975F */
0x94B7, 0x94D8, 0x94DE, 0x94F3, 0x9503, 0x950E, 0x950F, 0x9518, 	/* 0x9760 to 0x9767 */
0x951D, 0x952A, 0x952B, 0x953F, 0x9545, 0x954E, 0x9562, 0x9565, 	/* 0x9768 to 0x976F */
0x9569, 0x9572, 0x9587, 0x9599, 0x95A0, 0x95B2, 0x9666, 0x969D, 	/* 0x9770 to 0x9777 */
0x96AF, 0x96B2, 0x9733, 0x973B, 0x974D, 0x974F, 0x9751, 0x0000, 	/* 0x9778 to 0x977F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9780 to 0x9787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9788 to 0x978F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9790 to 0x9797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9798 to 0x979F */
0x0000, 0x9755, 0x9764, 0x976B, 0x9771, 0x9792, 0x97B2, 0x97F2, 	/* 0x97A0 to 0x97A7 */
0x983D, 0x9854, 0x98A5, 0x98C3, 0x98DA, 0x98EE, 0x991D, 0x9920, 	/* 0x97A8 to 0x97AF */
0x9963, 0x9980, 0x9987, 0x998D, 0x9993, 0x9995, 0x99BC, 0x99C8, 	/* 0x97B0 to 0x97B7 */
0x99F2, 0x9AB6, 0x9AD9, 0x9ADE, 0x9B0F, 0x9B49, 0x9B72, 0x9B83, 	/* 0x97B8 to 0x97BF */
0x9B9F, 0x9BBB, 0x9BE3, 0x9BF5, 0x9C00, 0x9C04, 0x9C1B, 0x24B6, 	/* 0x97C0 to 0x97C7 */
0x24B7, 0x24B8, 0x24B9, 0x24BA, 0x24BB, 0x24BC, 0x24BD, 0x24BE, 	/* 0x97C8 to 0x97CF */
0x24BF, 0x24C0, 0x24C1, 0x24C2, 0x24C3, 0x24C4, 0x24C5, 0x24C6, 	/* 0x97D0 to 0x97D7 */
0x24C7, 0x24C8, 0x24C9, 0x24CA, 0x24CB, 0x24CC, 0x24CD, 0x24CE, 	/* 0x97D8 to 0x97DF */
0x24CF, 0x24D0, 0x24D1, 0x24D2, 0x24D3, 0x24D4, 0x24D5, 0x24D6, 	/* 0x97E0 to 0x97E7 */
0x24D7, 0x24D8, 0x24D9, 0x24DA, 0x24DB, 0x24DC, 0x24DD, 0x24DE, 	/* 0x97E8 to 0x97EF */
0x24DF, 0x24E0, 0x24E1, 0x24E2, 0x24E3, 0x24E4, 0x24E5, 0x24E6, 	/* 0x97F0 to 0x97F7 */
0x24E7, 0x24E8, 0x24E9, 0x00AE, 0x2122, 0xE931, 0xE932, 0x0000, 	/* 0x97F8 to 0x97FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9800 to 0x9807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9808 to 0x980F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9810 to 0x9817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9818 to 0x981F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9820 to 0x9827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9828 to 0x982F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9830 to 0x9837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9838 to 0x983F */
0x9C76, 0x278A, 0x278B, 0x278C, 0x278D, 0x278E, 0x278F, 0x2790, 	/* 0x9840 to 0x9847 */
0x2791, 0x2792, 0x2793, 0x9C85, 0x9C86, 0x9C87, 0x9C8B, 0x9C90, 	/* 0x9848 to 0x984F */
0x9C9E, 0x9CAE, 0x9CB0, 0x9CB2, 0x9CB4, 0x9CBA, 0x9CBC, 0x9CBD, 	/* 0x9850 to 0x9857 */
0x9CC6, 0x9CC7, 0x9CCA, 0x9CCB, 0x9CD3, 0x9CD8, 0x9CD9, 0x9CE2, 	/* 0x9858 to 0x985F */
0x9CEB, 0x9CEC, 0x9D2A, 0x9D48, 0x9D50, 0x9D7A, 0x9DC6, 0x9E4B, 	/* 0x9860 to 0x9867 */
0x9E55, 0x9E5B, 0x9E71, 0x9EAA, 0x9EBD, 0x9EC4, 0x9EE2, 0x9EEA, 	/* 0x9868 to 0x986F */
0x9F08, 0x9F0B, 0x9F0D, 0x9F21, 0x9F44, 0x9F51, 0x9F9D, 0xFA0E, 	/* 0x9870 to 0x9877 */
0xFA0F, 0xFA11, 0xFA13, 0xFA14, 0xFA18, 0xFA1F, 0xFA20, 0x0000, 	/* 0x9878 to 0x987F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9880 to 0x9887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9888 to 0x988F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9890 to 0x9897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9898 to 0x989F */
0x0000, 0xFA21, 0xFA23, 0xFA24, 0xFA27, 0xFA28, 0xFA29, 0x4E04, 	/* 0x98A0 to 0x98A7 */
0x4E2F, 0x4E81, 0x4E87, 0x4EA3, 0x4EB7, 0x4EBC, 0x4EF8, 0x4F28, 	/* 0x98A8 to 0x98AF */
0x4F29, 0x4F37, 0x4F42, 0x4F45, 0x4F4B, 0x4F72, 0x4FA2, 0x4FB0, 	/* 0x98B0 to 0x98B7 */
0x4FBD, 0x4FC8, 0x4FCC, 0x4FF0, 0x4FF2, 0x4FF9, 0x5003, 0x5008, 	/* 0x98B8 to 0x98BF */
0x5034, 0x503B, 0x5058, 0x5066, 0x5081, 0x5090, 0x50BC, 0x50D0, 	/* 0x98C0 to 0x98C7 */
0x50DF, 0x50E1, 0x50FC, 0x510D, 0x512B, 0x5160, 0x51AE, 0x51B8, 	/* 0x98C8 to 0x98CF */
0x51D2, 0x51E2, 0x5205, 0x5234, 0x523C, 0x5259, 0x5268, 0x5279, 	/* 0x98D0 to 0x98D7 */
0x52A4, 0x52CC, 0x5327, 0x5342, 0x535D, 0x537D, 0x537E, 0x53C5, 	/* 0x98D8 to 0x98DF */
0x53D0, 0x53D2, 0x53FE, 0x546D, 0x5485, 0x5493, 0x549E, 0x54B9, 	/* 0x98E0 to 0x98E7 */
0x54E3, 0x54EF, 0x550D, 0x5518, 0x5525, 0x5528, 0x552B, 0x5547, 	/* 0x98E8 to 0x98EF */
0x5579, 0x5590, 0x55B4, 0x55C1, 0x55D7, 0x55D8, 0x55FB, 0x4FB4, 	/* 0x98F0 to 0x98F7 */
0x5621, 0x2203, 0x5652, 0xE9CC, 0x263B, 0xE9CE, 0xE9CF, 0x0000, 	/* 0x98F8 to 0x98FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9900 to 0x9907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9908 to 0x990F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9910 to 0x9917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9918 to 0x991F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9920 to 0x9927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9928 to 0x992F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9930 to 0x9937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9938 to 0x993F */
0x565D, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247A, 	/* 0x9940 to 0x9947 */
0x247B, 0x247C, 0x247D, 0x247E, 0x247F, 0x2480, 0x2481, 0x2482, 	/* 0x9948 to 0x994F */
0x2483, 0x2484, 0x2485, 0x2486, 0x2487, 0x5661, 0x5689, 0x568B, 	/* 0x9950 to 0x9957 */
0x569E, 0x56A1, 0x56B1, 0x56B9, 0x56BF, 0x56D6, 0x56EF, 0x5715, 	/* 0x9958 to 0x995F */
0x571D, 0x5732, 0x573D, 0x573F, 0x5743, 0x21D4, 0x577E, 0x578A, 	/* 0x9960 to 0x9967 */
0x578D, 0x5790, 0x579C, 0x57BB, 0x57BE, 0x57C4, 0x57DE, 0x57FE, 	/* 0x9968 to 0x996F */
0x5812, 0x5822, 0x5847, 0x585C, 0x585F, 0x5873, 0x58A7, 0x58AA, 	/* 0x9970 to 0x9977 */
0x58B0, 0x58B5, 0x58B6, 0x58CB, 0x58D0, 0x58E0, 0x5905, 0x0000, 	/* 0x9978 to 0x997F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9980 to 0x9987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9988 to 0x998F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9990 to 0x9997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9998 to 0x999F */
0x0000, 0x5911, 0x5989, 0x5994, 0x599A, 0x599F, 0x59B0, 0x59B8, 	/* 0x99A0 to 0x99A7 */
0x59C4, 0x59EF, 0x59F0, 0x59F8, 0x5A02, 0x5A0B, 0x5A0D, 0x5A12, 	/* 0x99A8 to 0x99AF */
0x5A21, 0x5A24, 0x5A27, 0x5A2A, 0x5A2B, 0x5A2C, 0x5A3D, 0x5A45, 	/* 0x99B0 to 0x99B7 */
0x5A54, 0x5A59, 0x5A61, 0x5A68, 0x5A6B, 0x5A6E, 0x5A71, 0x5A79, 	/* 0x99B8 to 0x99BF */
0x5A7E, 0x5A81, 0x5A82, 0x5A86, 0x5A88, 0x5A91, 0x5A99, 0x5AA0, 	/* 0x99C0 to 0x99C7 */
0x5AA1, 0x5AAB, 0x5AC3, 0x5ACE, 0x5ACF, 0x5AD3, 0x5AE4, 0x5AF0, 	/* 0x99C8 to 0x99CF */
0x5AFE, 0x5B0D, 0x5B11, 0x5B15, 0x5B1F, 0x5B2B, 0x5B41, 0x5B44, 	/* 0x99D0 to 0x99D7 */
0x5B46, 0x5B4A, 0x5B4F, 0x5B68, 0x5B74, 0x5B76, 0x5B7C, 0x5B82, 	/* 0x99D8 to 0x99DF */
0x5B90, 0x249C, 0x249D, 0x249E, 0x249F, 0x24A0, 0x24A1, 0x24A2, 	/* 0x99E0 to 0x99E7 */
0x24A3, 0x24A4, 0x24A5, 0x24A6, 0x24A7, 0x24A8, 0x24A9, 0x24AA, 	/* 0x99E8 to 0x99EF */
0x24AB, 0x24AC, 0x24AD, 0x24AE, 0x24AF, 0x24B0, 0x24B1, 0x24B2, 	/* 0x99F0 to 0x99F7 */
0x24B3, 0x24B4, 0x24B5, 0xEA69, 0x3232, 0x3231, 0x6AAB, 0x0000, 	/* 0x99F8 to 0x99FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A00 to 0x9A07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A08 to 0x9A0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A10 to 0x9A17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A18 to 0x9A1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A20 to 0x9A27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A28 to 0x9A2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A30 to 0x9A37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A38 to 0x9A3F */
0x5B96, 0x2488, 0x2489, 0x248A, 0x248B, 0x248C, 0x248D, 0x248E, 	/* 0x9A40 to 0x9A47 */
0x248F, 0x2490, 0x2491, 0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 	/* 0x9A48 to 0x9A4F */
0x2497, 0x2498, 0x2499, 0x249A, 0x249B, 0x5BD5, 0x5BD7, 0x5C23, 	/* 0x9A50 to 0x9A57 */
0x5C85, 0x5C9E, 0x5CC2, 0x5D10, 0x5D2C, 0x5D2F, 0x5D48, 0x5D56, 	/* 0x9A58 to 0x9A5F */
0x5D70, 0x5D7B, 0x5D85, 0x5DA4, 0x5DAB, 0x5DB6, 0x5DC1, 0x5DD7, 	/* 0x9A60 to 0x9A67 */
0x5E09, 0x5E48, 0x5E92, 0x5EBD, 0x5F0E, 0x5F72, 0x5FB1, 0x5FC2, 	/* 0x9A68 to 0x9A6F */
0x5FDB, 0x5FDF, 0x6023, 0x607E, 0x60D7, 0x6107, 0x610C, 0x6119, 	/* 0x9A70 to 0x9A77 */
0x6122, 0x6150, 0x6160, 0x6181, 0x6195, 0x61B9, 0x61C0, 0x0000, 	/* 0x9A78 to 0x9A7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A80 to 0x9A87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A88 to 0x9A8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A90 to 0x9A97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9A98 to 0x9A9F */
0x0000, 0x61CF, 0x61D3, 0x61DA, 0x6290, 0x6331, 0x2283, 0x6337, 	/* 0x9AA0 to 0x9AA7 */
0x6379, 0x638B, 0x63C1, 0x63E2, 0x63E6, 0x63FB, 0x63FE, 0x6407, 	/* 0x9AA8 to 0x9AAF */
0x6432, 0x6438, 0x643B, 0x645A, 0x6471, 0x647C, 0x648D, 0x64AF, 	/* 0x9AB0 to 0x9AB7 */
0x64B4, 0x64B6, 0x64DD, 0x64E5, 0x650A, 0x6511, 0x651F, 0x655F, 	/* 0x9AB8 to 0x9ABF */
0x656D, 0x6586, 0x65B5, 0x65BE, 0x65D1, 0x65D4, 0x65E3, 0x65FF, 	/* 0x9AC0 to 0x9AC7 */
0x6618, 0x6623, 0x6663, 0x666B, 0x667D, 0x6685, 0x6692, 0x669A, 	/* 0x9AC8 to 0x9ACF */
0x66A4, 0x66AD, 0x66B3, 0x66B6, 0x66CD, 0x66CE, 0x6702, 0x670C, 	/* 0x9AD0 to 0x9AD7 */
0x6719, 0x6744, 0x676B, 0x678F, 0x67A4, 0x67BF, 0x67D6, 0x67D7, 	/* 0x9AD8 to 0x9ADF */
0x2282, 0x680D, 0x6810, 0x681B, 0x6836, 0x6847, 0x6856, 0x6884, 	/* 0x9AE0 to 0x9AE7 */
0x6888, 0x68BD, 0x68C3, 0x68C5, 0x6902, 0x6903, 0x6909, 0x6918, 	/* 0x9AE8 to 0x9AEF */
0x6943, 0x6946, 0x6964, 0x6967, 0x6972, 0x6985, 0x699F, 0x69A2, 	/* 0x9AF0 to 0x9AF7 */
0x69D1, 0x69D5, 0x69D6, 0x9A21, 0x9A26, 0x9A2F, 0x6AC1, 0x0000, 	/* 0x9AF8 to 0x9AFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B00 to 0x9B07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B08 to 0x9B0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B10 to 0x9B17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B18 to 0x9B1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B20 to 0x9B27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B28 to 0x9B2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B30 to 0x9B37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B38 to 0x9B3F */
0x59BF, 0x69E1, 0x6A03, 0x6A1A, 0x6A1C, 0x6A2C, 0x6A2D, 0x6A33, 	/* 0x9B40 to 0x9B47 */
0x6A43, 0x6A45, 0x6A4C, 0x6A53, 0x6A57, 0x6A63, 0x6A74, 0x6A82, 	/* 0x9B48 to 0x9B4F */
0x6A8A, 0x6A8F, 0x6A99, 0x6AA7, 0x6AB1, 0x6AB5, 0x6ABE, 0x6AC9, 	/* 0x9B50 to 0x9B57 */
0x6AD4, 0x6AD8, 0x6AF6, 0x6B57, 0x6B7A, 0x6BDC, 0x6C1C, 0x6C31, 	/* 0x9B58 to 0x9B5F */
0x6C58, 0x6C6E, 0x6C75, 0x6C7F, 0x6CAF, 0x6CCB, 0x6CDF, 0x6CFF, 	/* 0x9B60 to 0x9B67 */
0x6D02, 0x6D05, 0x6D06, 0x6D26, 0x6D57, 0x6D5B, 0x6D71, 0x6D81, 	/* 0x9B68 to 0x9B6F */
0x6D8F, 0x6DA5, 0x6DB1, 0x6DFE, 0x6E02, 0x6E04, 0x6E0F, 0x6E18, 	/* 0x9B70 to 0x9B77 */
0x6E2A, 0x6E50, 0x6E59, 0x6E9A, 0x6EB5, 0x6EB8, 0x6EDB, 0x0000, 	/* 0x9B78 to 0x9B7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B80 to 0x9B87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B88 to 0x9B8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B90 to 0x9B97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9B98 to 0x9B9F */
0x0000, 0x6EFA, 0x6F04, 0x6F0B, 0x6F0C, 0x6F16, 0x6F17, 0x6F34, 	/* 0x9BA0 to 0x9BA7 */
0x6F3D, 0x6F56, 0x6F79, 0x6F8A, 0x6F9D, 0x6F9F, 0x6FBB, 0x6FBE, 	/* 0x9BA8 to 0x9BAF */
0x6FD3, 0x6FD9, 0x6FF8, 0x7003, 0x704B, 0x704D, 0x7050, 0x7054, 	/* 0x9BB0 to 0x9BB7 */
0x705C, 0x7067, 0x7077, 0x7079, 0x708B, 0x708F, 0x70A0, 0x70A3, 	/* 0x9BB8 to 0x9BBF */
0x70A5, 0x70A6, 0x70A7, 0x70C4, 0x70CC, 0x70D0, 0x70D6, 0x026A, 	/* 0x9BC0 to 0x9BC7 */
0x025B, 0x00E6, 0x028C, 0x0251, 0x0254, 0x028A, 0x025D, 0x0259, 	/* 0x9BC8 to 0x9BCF */
0x025A, 0x025C, 0x0261, 0x1E43, 0x1E49, 0x014A, 0x1E3B, 0x0275, 	/* 0x9BD0 to 0x9BD7 */
0x00F0, 0x0283, 0x0292, 0x02A7, 0x02A4, 0x00E3, 0xEB86, 0xEB87, 	/* 0x9BD8 to 0x9BDF */
0x026F, 0x0278, 0x0287, 0xEB8B, 0x00C7, 0x0153, 0x0252, 0xFF47, 	/* 0x9BE0 to 0x9BE7 */
0x02CB, 0x02CF, 0xFF41, 0xFF42, 0xFF44, 0xFF45, 0xFF46, 0xFF48, 	/* 0x9BE8 to 0x9BEF */
0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 	/* 0x9BF0 to 0x9BF7 */
0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF5A, 0x0000, 	/* 0x9BF8 to 0x9BFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C00 to 0x9C07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C08 to 0x9C0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C10 to 0x9C17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C18 to 0x9C1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C20 to 0x9C27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C28 to 0x9C2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C30 to 0x9C37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C38 to 0x9C3F */
0x70F5, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225, 0x3226, 	/* 0x9C40 to 0x9C47 */
0x3227, 0x3228, 0x3229, 0x70FE, 0x7105, 0x711D, 0x7129, 0x712B, 	/* 0x9C48 to 0x9C4F */
0x712C, 0x7133, 0x7135, 0x713B, 0x713E, 0x7140, 0x714F, 0x716B, 	/* 0x9C50 to 0x9C57 */
0x7175, 0x7177, 0x717C, 0x717E, 0x718C, 0x718E, 0x7191, 0x7196, 	/* 0x9C58 to 0x9C5F */
0x71A2, 0x71A3, 0x71AD, 0x71B4, 0x71B7, 0x71BA, 0x71D1, 0x71DD, 	/* 0x9C60 to 0x9C67 */
0x71EB, 0x7200, 0x7209, 0x720E, 0x720F, 0x7216, 0x7217, 0x7224, 	/* 0x9C68 to 0x9C6F */
0x5AA4, 0x722E, 0x2286, 0x7257, 0x725C, 0x7294, 0x7304, 0x7310, 	/* 0x9C70 to 0x9C77 */
0x7341, 0x7374, 0x738C, 0x738F, 0x7398, 0x739C, 0x739E, 0x0000, 	/* 0x9C78 to 0x9C7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C80 to 0x9C87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C88 to 0x9C8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C90 to 0x9C97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9C98 to 0x9C9F */
0x0000, 0x73A7, 0x73AA, 0x73D5, 0x73E1, 0x73E2, 0x73E4, 0x73E6, 	/* 0x9CA0 to 0x9CA7 */
0x73EF, 0x73F3, 0x2287, 0x73F9, 0x73FB, 0x7402, 0x7411, 0x7412, 	/* 0x9CA8 to 0x9CAF */
0x7414, 0x7415, 0x7417, 0x7419, 0x741C, 0x741E, 0x741F, 0x7437, 	/* 0x9CB0 to 0x9CB7 */
0x7438, 0x7439, 0x7443, 0x7445, 0x7447, 0x7448, 0x7449, 0x7453, 	/* 0x9CB8 to 0x9CBF */
0x7456, 0x7465, 0x746B, 0x746C, 0x7474, 0x747A, 0x7482, 0x5382, 	/* 0x9CC0 to 0x9CC7 */
0x5E7F, 0x4E28, 0x5E7A, 0x5196, 0x5B80, 0x5369, 0x2E87, 0xEC14, 	/* 0x9CC8 to 0x9CCF */
0x5303, 0x2612, 0x8279, 0x4491, 0x2E8C, 0x2E8A, 0x4E36, 0xEC1C, 	/* 0x9CD0 to 0x9CD7 */
0x531A, 0xEC1E, 0xEC1F, 0x2E95, 0xEC21, 0xEC22, 0x2514, 0x4E5A, 	/* 0x9CD8 to 0x9CDF */
0x8FB6, 0x5EF4, 0x5188, 0x4E85, 0xEC29, 0x4E3F, 0xEC2B, 0xEC2C, 	/* 0x9CE0 to 0x9CE7 */
0x4E5B, 0x53B6, 0x8F66, 0x7E9F, 0x8BA0, 0x8D1D, 0x9E1F, 0x95E8, 	/* 0x9CE8 to 0x9CEF */
0x9485, 0x961D, 0x624C, 0x6C35, 0x4EBB, 0x5FC4, 0x706C, 0x2EAE, 	/* 0x9CF0 to 0x9CF7 */
0x53E3, 0x6AE2, 0x9A3B, 0x9A3C, 0x9A58, 0x9A5C, 0x9A63, 0x0000, 	/* 0x9CF8 to 0x9CFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D00 to 0x9D07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D08 to 0x9D0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D10 to 0x9D17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D18 to 0x9D1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D20 to 0x9D27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D28 to 0x9D2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D30 to 0x9D37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D38 to 0x9D3F */
0x260E, 0x2192, 0x2190, 0x2191, 0x2193, 0x21E8, 0x21E6, 0x21E7, 	/* 0x9D40 to 0x9D47 */
0x21E9, 0x21E8, 0x21E6, 0x21E7, 0x21E9, 0x261E, 0x261C, 0x261B, 	/* 0x9D48 to 0x9D4F */
0x261F, 0x3016, 0x3017, 0x25CB, 0x2715, 0x2713, 0x56FB, 0x263D, 	/* 0x9D50 to 0x9D57 */
0x591D, 0x664D, 0x7225, 0x2729, 0x2721, 0x263A, 0x2639, 0xEC63, 	/* 0x9D58 to 0x9D5F */
0xEC64, 0xEC65, 0xEC66, 0xEC67, 0x5C78, 0x266C, 0x266A, 0x5AD1, 	/* 0x9D60 to 0x9D67 */
0x5BB7, 0x5CFC, 0xEC6E, 0x2709, 0x2702, 0xEC71, 0xEC72, 0xEC73, 	/* 0x9D68 to 0x9D6F */
0xEC74, 0x5CD5, 0x676E, 0x7461, 0x749D, 0x7F53, 0x8593, 0x274F, 	/* 0x9D70 to 0x9D77 */
0xEC7C, 0xEC7D, 0x5D78, 0x5F3B, 0xEC80, 0x2501, 0x2503, 0x0000, 	/* 0x9D78 to 0x9D7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D80 to 0x9D87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D88 to 0x9D8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D90 to 0x9D97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9D98 to 0x9D9F */
0x0000, 0xEC83, 0xEC84, 0xEC85, 0xEC86, 0xEC87, 0xEC88, 0xEC89, 	/* 0x9DA0 to 0x9DA7 */
0xEC8A, 0xEC8B, 0xEC8C, 0xEC8D, 0xEC8E, 0xEC8F, 0xEC90, 0xEC91, 	/* 0x9DA8 to 0x9DAF */
0x9AB2, 0x9AE0, 0x9B14, 0x9B34, 0x9B39, 0x9B40, 0x9B50, 0x9B7F, 	/* 0x9DB0 to 0x9DB7 */
0x263C, 0x7D95, 0x2601, 0x9734, 0x2602, 0xEC9F, 0xECA0, 0xECA1, 	/* 0x9DB8 to 0x9DBF */
0x2708, 0xECA3, 0xECA4, 0xECA5, 0xECA6, 0xECA7, 0xECA8, 0xECA9, 	/* 0x9DC0 to 0x9DC7 */
0x213B, 0x2121, 0x66E7, 0x6E57, 0xECAE, 0x7157, 0x79CA, 0x2116, 	/* 0x9DC8 to 0x9DCF */
0x816C, 0x8AF9, 0x9856, 0xECB5, 0xECB6, 0x2620, 0xECB8, 0x2664, 	/* 0x9DD0 to 0x9DD7 */
0x2660, 0x2667, 0x2663, 0x2662, 0x2666, 0x2661, 0x2665, 0xECC1, 	/* 0x9DD8 to 0x9DDF */
0xECC2, 0x6AE4, 0x211E, 0x33C2, 0x33D8, 0x33A1, 0xECC8, 0x33A5, 	/* 0x9DE0 to 0x9DE7 */
0xECCA, 0xECCB, 0xECCC, 0xECCD, 0xECCE, 0x2611, 0x9B81, 0x9B8B, 	/* 0x9DE8 to 0x9DEF */
0x9B8D, 0x9BDD, 0x9BE9, 0x9BED, 0x9BF4, 0x9C1F, 0x9C20, 0x9C26, 	/* 0x9DF0 to 0x9DF7 */
0x9C53, 0x9C5D, 0x9C7B, 0x9D0C, 0x9D16, 0x21B2, 0x6B05, 0x0000, 	/* 0x9DF8 to 0x9DFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E00 to 0x9E07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E08 to 0x9E0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E10 to 0x9E17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E18 to 0x9E1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E20 to 0x9E27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E28 to 0x9E2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E30 to 0x9E37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E38 to 0x9E3F */
0x8CE9, 0x8CF2, 0x8D03, 0x8D11, 0x8D1C, 0x8D7A, 0x8DA9, 0x8DC0, 	/* 0x9E40 to 0x9E47 */
0x8E01, 0x8E0E, 0x8E46, 0x8E68, 0x8E71, 0x8E7E, 0x8E80, 0x8EB6, 	/* 0x9E48 to 0x9E4F */
0x8EB9, 0x8EBC, 0x8EC3, 0x8EE4, 0x8EED, 0x8EF2, 0x8F30, 0x8F41, 	/* 0x9E50 to 0x9E57 */
0x8F4A, 0x8FA5, 0x8FB3, 0x8FB8, 0x8FCA, 0x8FCF, 0x9008, 0x9033, 	/* 0x9E58 to 0x9E5F */
0x9037, 0x9064, 0x906C, 0x91A9, 0x91B6, 0x91C4, 0x91FA, 0x9208, 	/* 0x9E60 to 0x9E67 */
0x9213, 0x9221, 0x9228, 0x922B, 0x9235, 0x923C, 0x9241, 0x9258, 	/* 0x9E68 to 0x9E6F */
0x925D, 0x925F, 0x926B, 0x926E, 0x9281, 0x9284, 0x9289, 0x928F, 	/* 0x9E70 to 0x9E77 */
0x92B1, 0x92BA, 0x92BF, 0x92D4, 0x92DB, 0x92E3, 0x92E5, 0x0000, 	/* 0x9E78 to 0x9E7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E80 to 0x9E87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E88 to 0x9E8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E90 to 0x9E97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9E98 to 0x9E9F */
0x0000, 0x92EB, 0x92EC, 0x92F4, 0x92F6, 0x92FD, 0x9303, 0x9307, 	/* 0x9EA0 to 0x9EA7 */
0x9330, 0x9331, 0x9340, 0x9342, 0x9343, 0x935F, 0x9362, 0x9366, 	/* 0x9EA8 to 0x9EAF */
0x9368, 0x9373, 0x9374, 0x9378, 0x937D, 0x9381, 0x9384, 0x9386, 	/* 0x9EB0 to 0x9EB7 */
0x9387, 0x9390, 0x939C, 0x93A0, 0x93B8, 0x93BB, 0x93BD, 0x93BF, 	/* 0x9EB8 to 0x9EBF */
0x93CB, 0x93D3, 0x93DB, 0x93E0, 0x93F0, 0x93F1, 0x93F3, 0x93F4, 	/* 0x9EC0 to 0x9EC7 */
0x9401, 0x9404, 0x9408, 0x9417, 0x941B, 0x941D, 0x9424, 0x9425, 	/* 0x9EC8 to 0x9ECF */
0x9426, 0x942D, 0x9442, 0x9443, 0x944D, 0x9454, 0x9458, 0x9465, 	/* 0x9ED0 to 0x9ED7 */
0x9467, 0x946C, 0x9479, 0x947B, 0x9578, 0x9585, 0x95A6, 0x95AA, 	/* 0x9ED8 to 0x9EDF */
0x9656, 0x967B, 0x96A5, 0x96F4, 0x971B, 0x9736, 0x9740, 0x9741, 	/* 0x9EE0 to 0x9EE7 */
0x9757, 0x9787, 0x9789, 0x979B, 0x97B1, 0x97BD, 0x97C0, 0x97C2, 	/* 0x9EE8 to 0x9EEF */
0x97D2, 0x97E0, 0x9814, 0x9815, 0x9823, 0x9833, 0x9868, 0x98B7, 	/* 0x9EF0 to 0x9EF7 */
0x98B9, 0x98C7, 0x98CA, 0x98E0, 0x98E1, 0x98EC, 0x98F5, 0x0000, 	/* 0x9EF8 to 0x9EFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F00 to 0x9F07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F08 to 0x9F0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F10 to 0x9F17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F18 to 0x9F1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F20 to 0x9F27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F28 to 0x9F2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F30 to 0x9F37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F38 to 0x9F3F */
0x9D21, 0x9D34, 0x9D39, 0x9D49, 0x9D4E, 0x9D6D, 0x2237, 0x9D6E, 	/* 0x9F40 to 0x9F47 */
0x9D7C, 0x9D83, 0x9D93, 0x9DA5, 0x222C, 0x9DBD, 0x6B81, 0x6BB1, 	/* 0x9F48 to 0x9F4F */
0x9C4F, 0x9E90, 0x9DC0, 0xED91, 0xED92, 0x262F, 0x2630, 0x2637, 	/* 0x9F50 to 0x9F57 */
0x2633, 0x2634, 0x2635, 0x2632, 0x2636, 0x2631, 0x9DC9, 0x9DD4, 	/* 0x9F58 to 0x9F5F */
0x9DFC, 0x9E0A, 0x9E0C, 0x9E0E, 0x9E18, 0x9E7B, 0x9E85, 0x9EA2, 	/* 0x9F60 to 0x9F67 */
0x9EAC, 0x9EB1, 0x9EC1, 0x9EC6, 0x9EC7, 0x9EF1, 0x9EF8, 0x9F27, 	/* 0x9F68 to 0x9F6F */
0x990E, 0x9919, 0x991C, 0x9937, 0x995D, 0x9962, 0x999B, 0x99A4, 	/* 0x9F70 to 0x9F77 */
0x99AA, 0x99B8, 0x99E0, 0x99E6, 0x99F5, 0x9A1F, 0x7DFE, 0x0000, 	/* 0x9F78 to 0x9F7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F80 to 0x9F87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F88 to 0x9F8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F90 to 0x9F97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0x9F98 to 0x9F9F */
0x0000, 0x7E07, 0x7E5B, 0x7E65, 0x7E6C, 0x7F37, 0x7F40, 0x7F41, 	/* 0x9FA0 to 0x9FA7 */
0x7F49, 0x7F52, 0x7F8F, 0x7F93, 0x7FB4, 0x7FDD, 0x7FE7, 0x7FFA, 	/* 0x9FA8 to 0x9FAF */
0x8002, 0x8008, 0x802E, 0x802F, 0x803C, 0x80A7, 0x810C, 0x812A, 	/* 0x9FB0 to 0x9FB7 */
0x8134, 0x8142, 0x8156, 0x8184, 0x81A5, 0x81E4, 0x8254, 0x8265, 	/* 0x9FB8 to 0x9FBF */
0x827B, 0x8287, 0x82BF, 0x82E2, 0x82EE, 0x82F8, 0x82FC, 0x82FF, 	/* 0x9FC0 to 0x9FC7 */
0x830B, 0x831D, 0x833D, 0x8357, 0x8391, 0x83AC, 0x83CD, 0x83ED, 	/* 0x9FC8 to 0x9FCF */
0x8405, 0x8414, 0x8416, 0x8421, 0x842E, 0x843E, 0x844A, 0x8453, 	/* 0x9FD0 to 0x9FD7 */
0x8455, 0x8458, 0x8464, 0x8472, 0x847F, 0x8480, 0x8492, 0x8493, 	/* 0x9FD8 to 0x9FDF */
0x8496, 0x84A3, 0x84BE, 0x84DE, 0x84E1, 0x84E2, 0x84E4, 0x84F8, 	/* 0x9FE0 to 0x9FE7 */
0x8503, 0x8505, 0x8510, 0x8533, 0x2010, 0x8542, 0x854C, 0x8552, 	/* 0x9FE8 to 0x9FEF */
0x855F, 0x856F, 0x8570, 0x8573, 0x85D6, 0x85E0, 0x85EE, 0x85FC, 	/* 0x9FF0 to 0x9FF7 */
0x860D, 0x860F, 0x8614, 0x8628, 0x8642, 0x8645, 0x8672, 0x0000, 	/* 0x9FF8 to 0x9FFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA000 to 0xA007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA008 to 0xA00F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA010 to 0xA017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA018 to 0xA01F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA020 to 0xA027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA028 to 0xA02F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA030 to 0xA037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA038 to 0xA03F */
0x889C, 0x5B6D, 0x8137, 0xEE1E, 0x9938, 0x5572, 0x556B, 0xEE22, 	/* 0xA040 to 0xA047 */
0x35CE, 0x5571, 0x55BA, 0x55F1, 0x35D2, 0x55F0, 0x5605, 0x5622, 	/* 0xA048 to 0xA04F */
0x562D, 0x5643, 0x561E, 0x5692, 0x7CCD, 0x541A, 0x5413, 0x5497, 	/* 0xA050 to 0xA057 */
0x66F1, 0x7534, 0x544D, 0x56A4, 0x569F, 0x64D3, 0x632E, 0x63F8, 	/* 0xA058 to 0xA05F */
0x651E, 0x4E78, 0x6BEA, 0x6C32, 0x6C3D, 0x6C62, 0x6CB2, 0x6DF8, 	/* 0xA060 to 0xA067 */
0x6E29, 0x6E76, 0x6E82, 0x6E86, 0x6EBB, 0x6EDF, 0x6EE2, 0x6F11, 	/* 0xA068 to 0xA06F */
0x6F24, 0x6F74, 0x6F91, 0x6FB5, 0x6FF3, 0x6FF5, 0x70BB, 0x70C0, 	/* 0xA070 to 0xA077 */
0x710F, 0x2202, 0x7155, 0x7173, 0x717A, 0xEE58, 0x5223, 0x0000, 	/* 0xA078 to 0xA07F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA080 to 0xA087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA088 to 0xA08F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA090 to 0xA097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA098 to 0xA09F */
0x0000, 0xEE5A, 0x3451, 0xEE5C, 0x8FCC, 0xEE5E, 0xEE5F, 0x00C0, 	/* 0xA0A0 to 0xA0A7 */
0x00C8, 0x00CC, 0x00D2, 0x00D9, 0x00C1, 0x00CD, 0x00D3, 0x00DA, 	/* 0xA0A8 to 0xA0AF */
0x0101, 0x0113, 0x012B, 0x014D, 0x016B, 0x01D6, 0x00C4, 0x00CB, 	/* 0xA0B0 to 0xA0B7 */
0x00CF, 0x00D6, 0x00DC, 0x00C6, 0x00C7, 0x00D1, 0x00C3, 0x00D5, 	/* 0xA0B8 to 0xA0BF */
0x00E1, 0x00E9, 0x00ED, 0x00F3, 0x00FA, 0x01D8, 0x00E4, 0x00EB, 	/* 0xA0C0 to 0xA0C7 */
0x00EF, 0x00F6, 0x00FC, 0x00E6, 0x00E7, 0x00F1, 0x00E3, 0x00F5, 	/* 0xA0C8 to 0xA0CF */
0x01CE, 0x011B, 0x01D0, 0x01D2, 0x01D4, 0x01DA, 0x00C5, 0x00C9, 	/* 0xA0D0 to 0xA0D7 */
0x7188, 0x00D8, 0x00D0, 0x1EF2, 0x00DE, 0x00DF, 0x00AA, 0x00A1, 	/* 0xA0D8 to 0xA0DF */
0x00E0, 0x00E8, 0x00EC, 0x00F2, 0x00F9, 0x01DC, 0x00E5, 0x7198, 	/* 0xA0E0 to 0xA0E7 */
0x71D7, 0x00F8, 0x00F0, 0x1EF3, 0x00FE, 0x00FF, 0x00BA, 0x00BF, 	/* 0xA0E8 to 0xA0EF */
0x00E2, 0x00EA, 0x00EE, 0x00F4, 0x00FB, 0x71F5, 0x00C2, 0x00CA, 	/* 0xA0F0 to 0xA0F7 */
0x00CE, 0x00D4, 0x00DB, 0x00B8, 0x00A4, 0xEEB6, 0x0192, 0x0000, 	/* 0xA0F8 to 0xA0FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA100 to 0xA107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA108 to 0xA10F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA110 to 0xA117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA118 to 0xA11F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA120 to 0xA127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA128 to 0xA12F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA130 to 0xA137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA138 to 0xA13F */
0x3000, 0xFF0C, 0x3001, 0x3002, 0xFF0E, 0x2027, 0xFF1B, 0xFF1A, 	/* 0xA140 to 0xA147 */
0xFF1F, 0xFF01, 0xFE30, 0x2026, 0x2025, 0xFE50, 0xFE51, 0xFE52, 	/* 0xA148 to 0xA14F */
0x00B7, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFF5C, 0x2013, 0xFE31, 	/* 0xA150 to 0xA157 */
0x2014, 0xFE33, 0x2574, 0xFE34, 0xFE4F, 0xFF08, 0xFF09, 0xFE35, 	/* 0xA158 to 0xA15F */
0xFE36, 0xFF5B, 0xFF5D, 0xFE37, 0xFE38, 0x3014, 0x3015, 0xFE39, 	/* 0xA160 to 0xA167 */
0xFE3A, 0x3010, 0x3011, 0xFE3B, 0xFE3C, 0x300A, 0x300B, 0xFE3D, 	/* 0xA168 to 0xA16F */
0xFE3E, 0x3008, 0x3009, 0xFE3F, 0xFE40, 0x300C, 0x300D, 0xFE41, 	/* 0xA170 to 0xA177 */
0xFE42, 0x300E, 0x300F, 0xFE43, 0xFE44, 0xFE59, 0xFE5A, 0x0000, 	/* 0xA178 to 0xA17F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA180 to 0xA187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA188 to 0xA18F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA190 to 0xA197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA198 to 0xA19F */
0x0000, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0x2018, 0x2019, 0x201C, 	/* 0xA1A0 to 0xA1A7 */
0x201D, 0x301D, 0x301E, 0x2035, 0x2032, 0xFF03, 0xFF06, 0xFF0A, 	/* 0xA1A8 to 0xA1AF */
0x203B, 0x00A7, 0x3003, 0x25CB, 0x25CF, 0x25B3, 0x25B2, 0x25CE, 	/* 0xA1B0 to 0xA1B7 */
0x2606, 0x2605, 0x25C7, 0x25C6, 0x25A1, 0x25A0, 0x25BD, 0x25BC, 	/* 0xA1B8 to 0xA1BF */
0x32A3, 0x2105, 0x00AF, 0xFFE3, 0xFF3F, 0x02CD, 0xFE49, 0xFE4A, 	/* 0xA1C0 to 0xA1C7 */
0xFE4D, 0xFE4E, 0xFE4B, 0xFE4C, 0xFE5F, 0xFE60, 0xFE61, 0xFF0B, 	/* 0xA1C8 to 0xA1CF */
0xFF0D, 0x00D7, 0x00F7, 0x00B1, 0x221A, 0xFF1C, 0xFF1E, 0xFF1D, 	/* 0xA1D0 to 0xA1D7 */
0x2266, 0x2267, 0x2260, 0x221E, 0x2252, 0x2261, 0xFE62, 0xFE63, 	/* 0xA1D8 to 0xA1DF */
0xFE64, 0xFE65, 0xFE66, 0xFF5E, 0x2229, 0x222A, 0x22A5, 0x2220, 	/* 0xA1E0 to 0xA1E7 */
0x221F, 0x22BF, 0x33D2, 0x33D1, 0x222B, 0x222E, 0x2235, 0x2234, 	/* 0xA1E8 to 0xA1EF */
0x2640, 0x2642, 0x2295, 0x2299, 0x2191, 0x2193, 0x2190, 0x2192, 	/* 0xA1F0 to 0xA1F7 */
0x2196, 0x2197, 0x2199, 0x2198, 0x2225, 0x2223, 0xFF0F, 0x0000, 	/* 0xA1F8 to 0xA1FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA200 to 0xA207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA208 to 0xA20F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA210 to 0xA217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA218 to 0xA21F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA220 to 0xA227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA228 to 0xA22F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA230 to 0xA237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA238 to 0xA23F */
0xFF3C, 0x2215, 0xFE68, 0xFF04, 0xFFE5, 0x3012, 0xFFE0, 0xFFE1, 	/* 0xA240 to 0xA247 */
0xFF05, 0xFF20, 0x2103, 0x2109, 0xFE69, 0xFE6A, 0xFE6B, 0x33D5, 	/* 0xA248 to 0xA24F */
0x339C, 0x339D, 0x339E, 0x33CE, 0x33A1, 0x338E, 0x338F, 0x33C4, 	/* 0xA250 to 0xA257 */
0x00B0, 0x5159, 0x515B, 0x515E, 0x515D, 0x5161, 0x5163, 0x55E7, 	/* 0xA258 to 0xA25F */
0x74E9, 0x7CCE, 0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2586, 	/* 0xA260 to 0xA267 */
0x2587, 0x2588, 0x258F, 0x258E, 0x258D, 0x258C, 0x258B, 0x258A, 	/* 0xA268 to 0xA26F */
0x2589, 0x253C, 0x2534, 0x252C, 0x2524, 0x251C, 0x2594, 0x2500, 	/* 0xA270 to 0xA277 */
0x2502, 0x2595, 0x250C, 0x2510, 0x2514, 0x2518, 0x256D, 0x0000, 	/* 0xA278 to 0xA27F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA280 to 0xA287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA288 to 0xA28F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA290 to 0xA297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA298 to 0xA29F */
0x0000, 0x256E, 0x2570, 0x256F, 0x2550, 0x255E, 0x256A, 0x2561, 	/* 0xA2A0 to 0xA2A7 */
0x25E2, 0x25E3, 0x25E5, 0x25E4, 0x2571, 0x2572, 0x2573, 0xFF10, 	/* 0xA2A8 to 0xA2AF */
0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18, 	/* 0xA2B0 to 0xA2B7 */
0xFF19, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 	/* 0xA2B8 to 0xA2BF */
0x2167, 0x2168, 0x2169, 0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 	/* 0xA2C0 to 0xA2C7 */
0x3026, 0x3027, 0x3028, 0x3029, 0x5341, 0x5344, 0x5345, 0xFF21, 	/* 0xA2C8 to 0xA2CF */
0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 	/* 0xA2D0 to 0xA2D7 */
0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 	/* 0xA2D8 to 0xA2DF */
0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38, 0xFF39, 	/* 0xA2E0 to 0xA2E7 */
0xFF3A, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 	/* 0xA2E8 to 0xA2EF */
0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 	/* 0xA2F0 to 0xA2F7 */
0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0x0000, 	/* 0xA2F8 to 0xA2FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA300 to 0xA307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA308 to 0xA30F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA310 to 0xA317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA318 to 0xA31F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA320 to 0xA327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA328 to 0xA32F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA330 to 0xA337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA338 to 0xA33F */
0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0x0391, 0x0392, 0x0393, 0x0394, 	/* 0xA340 to 0xA347 */
0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 	/* 0xA348 to 0xA34F */
0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3, 0x03A4, 0x03A5, 	/* 0xA350 to 0xA357 */
0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 	/* 0xA358 to 0xA35F */
0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 	/* 0xA360 to 0xA367 */
0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 	/* 0xA368 to 0xA36F */
0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x3105, 0x3106, 0x3107, 0x3108, 	/* 0xA370 to 0xA377 */
0x3109, 0x310A, 0x310B, 0x310C, 0x310D, 0x310E, 0x310F, 0x0000, 	/* 0xA378 to 0xA37F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA380 to 0xA387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA388 to 0xA38F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA390 to 0xA397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA398 to 0xA39F */
0x0000, 0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116, 	/* 0xA3A0 to 0xA3A7 */
0x3117, 0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D, 0x311E, 	/* 0xA3A8 to 0xA3AF */
0x311F, 0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126, 	/* 0xA3B0 to 0xA3B7 */
0x3127, 0x3128, 0x3129, 0x02D9, 0x02C9, 0x02CA, 0x02C7, 0x02CB, 	/* 0xA3B8 to 0xA3BF */
0x2400, 0x2401, 0x2402, 0x2403, 0x2404, 0x2405, 0x2406, 0x2407, 	/* 0xA3C0 to 0xA3C7 */
0x2408, 0x2409, 0x240A, 0x240B, 0x240C, 0x240D, 0x240E, 0x240F, 	/* 0xA3C8 to 0xA3CF */
0x2410, 0x2411, 0x2412, 0x2413, 0x2414, 0x2415, 0x2416, 0x2417, 	/* 0xA3D0 to 0xA3D7 */
0x2418, 0x2419, 0x241A, 0x241B, 0x241C, 0x241D, 0x241E, 0x241F, 	/* 0xA3D8 to 0xA3DF */
0x2421, 0x20AC, 0xF849, 0xF84A, 0xF84B, 0xF84C, 0xF84D, 0xF84E, 	/* 0xA3E0 to 0xA3E7 */
0xF84F, 0xF850, 0xF851, 0xF852, 0xF853, 0xF854, 0xF855, 0xF856, 	/* 0xA3E8 to 0xA3EF */
0xF857, 0xF858, 0xF859, 0xF85A, 0xF85B, 0xF85C, 0xF85D, 0xF85E, 	/* 0xA3F0 to 0xA3F7 */
0xF85F, 0xF860, 0xF861, 0xF862, 0xF863, 0xF864, 0xF865, 0x0000, 	/* 0xA3F8 to 0xA3FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA400 to 0xA407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA408 to 0xA40F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA410 to 0xA417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA418 to 0xA41F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA420 to 0xA427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA428 to 0xA42F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA430 to 0xA437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA438 to 0xA43F */
0x4E00, 0x4E59, 0x4E01, 0x4E03, 0x4E43, 0x4E5D, 0x4E86, 0x4E8C, 	/* 0xA440 to 0xA447 */
0x4EBA, 0x513F, 0x5165, 0x516B, 0x51E0, 0x5200, 0x5201, 0x529B, 	/* 0xA448 to 0xA44F */
0x5315, 0x5341, 0x535C, 0x53C8, 0x4E09, 0x4E0B, 0x4E08, 0x4E0A, 	/* 0xA450 to 0xA457 */
0x4E2B, 0x4E38, 0x51E1, 0x4E45, 0x4E48, 0x4E5F, 0x4E5E, 0x4E8E, 	/* 0xA458 to 0xA45F */
0x4EA1, 0x5140, 0x5203, 0x52FA, 0x5343, 0x53C9, 0x53E3, 0x571F, 	/* 0xA460 to 0xA467 */
0x58EB, 0x5915, 0x5927, 0x5973, 0x5B50, 0x5B51, 0x5B53, 0x5BF8, 	/* 0xA468 to 0xA46F */
0x5C0F, 0x5C22, 0x5C38, 0x5C71, 0x5DDD, 0x5DE5, 0x5DF1, 0x5DF2, 	/* 0xA470 to 0xA477 */
0x5DF3, 0x5DFE, 0x5E72, 0x5EFE, 0x5F0B, 0x5F13, 0x624D, 0x0000, 	/* 0xA478 to 0xA47F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA480 to 0xA487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA488 to 0xA48F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA490 to 0xA497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA498 to 0xA49F */
0x0000, 0x4E11, 0x4E10, 0x4E0D, 0x4E2D, 0x4E30, 0x4E39, 0x4E4B, 	/* 0xA4A0 to 0xA4A7 */
0x5C39, 0x4E88, 0x4E91, 0x4E95, 0x4E92, 0x4E94, 0x4EA2, 0x4EC1, 	/* 0xA4A8 to 0xA4AF */
0x4EC0, 0x4EC3, 0x4EC6, 0x4EC7, 0x4ECD, 0x4ECA, 0x4ECB, 0x4EC4, 	/* 0xA4B0 to 0xA4B7 */
0x5143, 0x5141, 0x5167, 0x516D, 0x516E, 0x516C, 0x5197, 0x51F6, 	/* 0xA4B8 to 0xA4BF */
0x5206, 0x5207, 0x5208, 0x52FB, 0x52FE, 0x52FF, 0x5316, 0x5339, 	/* 0xA4C0 to 0xA4C7 */
0x5348, 0x5347, 0x5345, 0x535E, 0x5384, 0x53CB, 0x53CA, 0x53CD, 	/* 0xA4C8 to 0xA4CF */
0x58EC, 0x5929, 0x592B, 0x592A, 0x592D, 0x5B54, 0x5C11, 0x5C24, 	/* 0xA4D0 to 0xA4D7 */
0x5C3A, 0x5C6F, 0x5DF4, 0x5E7B, 0x5EFF, 0x5F14, 0x5F15, 0x5FC3, 	/* 0xA4D8 to 0xA4DF */
0x6208, 0x6236, 0x624B, 0x624E, 0x652F, 0x6587, 0x6597, 0x65A4, 	/* 0xA4E0 to 0xA4E7 */
0x65B9, 0x65E5, 0x66F0, 0x6708, 0x6728, 0x6B20, 0x6B62, 0x6B79, 	/* 0xA4E8 to 0xA4EF */
0x6BCB, 0x6BD4, 0x6BDB, 0x6C0F, 0x6C34, 0x706B, 0x722A, 0x7236, 	/* 0xA4F0 to 0xA4F7 */
0x723B, 0x7247, 0x7259, 0x725B, 0x72AC, 0x738B, 0x4E19, 0x0000, 	/* 0xA4F8 to 0xA4FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA500 to 0xA507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA508 to 0xA50F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA510 to 0xA517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA518 to 0xA51F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA520 to 0xA527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA528 to 0xA52F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA530 to 0xA537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA538 to 0xA53F */
0x4E16, 0x4E15, 0x4E14, 0x4E18, 0x4E3B, 0x4E4D, 0x4E4F, 0x4E4E, 	/* 0xA540 to 0xA547 */
0x4EE5, 0x4ED8, 0x4ED4, 0x4ED5, 0x4ED6, 0x4ED7, 0x4EE3, 0x4EE4, 	/* 0xA548 to 0xA54F */
0x4ED9, 0x4EDE, 0x5145, 0x5144, 0x5189, 0x518A, 0x51AC, 0x51F9, 	/* 0xA550 to 0xA557 */
0x51FA, 0x51F8, 0x520A, 0x52A0, 0x529F, 0x5305, 0x5306, 0x5317, 	/* 0xA558 to 0xA55F */
0x531D, 0x4EDF, 0x534A, 0x5349, 0x5361, 0x5360, 0x536F, 0x536E, 	/* 0xA560 to 0xA567 */
0x53BB, 0x53EF, 0x53E4, 0x53F3, 0x53EC, 0x53EE, 0x53E9, 0x53E8, 	/* 0xA568 to 0xA56F */
0x53FC, 0x53F8, 0x53F5, 0x53EB, 0x53E6, 0x53EA, 0x53F2, 0x53F1, 	/* 0xA570 to 0xA577 */
0x53F0, 0x53E5, 0x53ED, 0x53FB, 0x56DB, 0x56DA, 0x5916, 0x0000, 	/* 0xA578 to 0xA57F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA580 to 0xA587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA588 to 0xA58F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA590 to 0xA597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA598 to 0xA59F */
0x0000, 0x592E, 0x5931, 0x5974, 0x5976, 0x5B55, 0x5B83, 0x5C3C, 	/* 0xA5A0 to 0xA5A7 */
0x5DE8, 0x5DE7, 0x5DE6, 0x5E02, 0x5E03, 0x5E73, 0x5E7C, 0x5F01, 	/* 0xA5A8 to 0xA5AF */
0x5F18, 0x5F17, 0x5FC5, 0x620A, 0x6253, 0x6254, 0x6252, 0x6251, 	/* 0xA5B0 to 0xA5B7 */
0x65A5, 0x65E6, 0x672E, 0x672C, 0x672A, 0x672B, 0x672D, 0x6B63, 	/* 0xA5B8 to 0xA5BF */
0x6BCD, 0x6C11, 0x6C10, 0x6C38, 0x6C41, 0x6C40, 0x6C3E, 0x72AF, 	/* 0xA5C0 to 0xA5C7 */
0x7384, 0x7389, 0x74DC, 0x74E6, 0x7518, 0x751F, 0x7528, 0x7529, 	/* 0xA5C8 to 0xA5CF */
0x7530, 0x7531, 0x7532, 0x7533, 0x758B, 0x767D, 0x76AE, 0x76BF, 	/* 0xA5D0 to 0xA5D7 */
0x76EE, 0x77DB, 0x77E2, 0x77F3, 0x793A, 0x79BE, 0x7A74, 0x7ACB, 	/* 0xA5D8 to 0xA5DF */
0x4E1E, 0x4E1F, 0x4E52, 0x4E53, 0x4E69, 0x4E99, 0x4EA4, 0x4EA6, 	/* 0xA5E0 to 0xA5E7 */
0x4EA5, 0x4EFF, 0x4F09, 0x4F19, 0x4F0A, 0x4F15, 0x4F0D, 0x4F10, 	/* 0xA5E8 to 0xA5EF */
0x4F11, 0x4F0F, 0x4EF2, 0x4EF6, 0x4EFB, 0x4EF0, 0x4EF3, 0x4EFD, 	/* 0xA5F0 to 0xA5F7 */
0x4F01, 0x4F0B, 0x5149, 0x5147, 0x5146, 0x5148, 0x5168, 0x0000, 	/* 0xA5F8 to 0xA5FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA600 to 0xA607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA608 to 0xA60F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA610 to 0xA617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA618 to 0xA61F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA620 to 0xA627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA628 to 0xA62F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA630 to 0xA637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA638 to 0xA63F */
0x5171, 0x518D, 0x51B0, 0x5217, 0x5211, 0x5212, 0x520E, 0x5216, 	/* 0xA640 to 0xA647 */
0x52A3, 0x5308, 0x5321, 0x5320, 0x5370, 0x5371, 0x5409, 0x540F, 	/* 0xA648 to 0xA64F */
0x540C, 0x540A, 0x5410, 0x5401, 0x540B, 0x5404, 0x5411, 0x540D, 	/* 0xA650 to 0xA657 */
0x5408, 0x5403, 0x540E, 0x5406, 0x5412, 0x56E0, 0x56DE, 0x56DD, 	/* 0xA658 to 0xA65F */
0x5733, 0x5730, 0x5728, 0x572D, 0x572C, 0x572F, 0x5729, 0x5919, 	/* 0xA660 to 0xA667 */
0x591A, 0x5937, 0x5938, 0x5984, 0x5978, 0x5983, 0x597D, 0x5979, 	/* 0xA668 to 0xA66F */
0x5982, 0x5981, 0x5B57, 0x5B58, 0x5B87, 0x5B88, 0x5B85, 0x5B89, 	/* 0xA670 to 0xA677 */
0x5BFA, 0x5C16, 0x5C79, 0x5DDE, 0x5E06, 0x5E76, 0x5E74, 0x0000, 	/* 0xA678 to 0xA67F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA680 to 0xA687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA688 to 0xA68F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA690 to 0xA697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA698 to 0xA69F */
0x0000, 0x5F0F, 0x5F1B, 0x5FD9, 0x5FD6, 0x620E, 0x620C, 0x620D, 	/* 0xA6A0 to 0xA6A7 */
0x6210, 0x6263, 0x625B, 0x6258, 0x6536, 0x65E9, 0x65E8, 0x65EC, 	/* 0xA6A8 to 0xA6AF */
0x65ED, 0x66F2, 0x66F3, 0x6709, 0x673D, 0x6734, 0x6731, 0x6735, 	/* 0xA6B0 to 0xA6B7 */
0x6B21, 0x6B64, 0x6B7B, 0x6C16, 0x6C5D, 0x6C57, 0x6C59, 0x6C5F, 	/* 0xA6B8 to 0xA6BF */
0x6C60, 0x6C50, 0x6C55, 0x6C61, 0x6C5B, 0x6C4D, 0x6C4E, 0x7070, 	/* 0xA6C0 to 0xA6C7 */
0x725F, 0x725D, 0x767E, 0x7AF9, 0x7C73, 0x7CF8, 0x7F36, 0x7F8A, 	/* 0xA6C8 to 0xA6CF */
0x7FBD, 0x8001, 0x8003, 0x800C, 0x8012, 0x8033, 0x807F, 0x8089, 	/* 0xA6D0 to 0xA6D7 */
0x808B, 0x808C, 0x81E3, 0x81EA, 0x81F3, 0x81FC, 0x820C, 0x821B, 	/* 0xA6D8 to 0xA6DF */
0x821F, 0x826E, 0x8272, 0x827E, 0x866B, 0x8840, 0x884C, 0x8863, 	/* 0xA6E0 to 0xA6E7 */
0x897F, 0x9621, 0x4E32, 0x4EA8, 0x4F4D, 0x4F4F, 0x4F47, 0x4F57, 	/* 0xA6E8 to 0xA6EF */
0x4F5E, 0x4F34, 0x4F5B, 0x4F55, 0x4F30, 0x4F50, 0x4F51, 0x4F3D, 	/* 0xA6F0 to 0xA6F7 */
0x4F3A, 0x4F38, 0x4F43, 0x4F54, 0x4F3C, 0x4F46, 0x4F63, 0x0000, 	/* 0xA6F8 to 0xA6FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA700 to 0xA707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA708 to 0xA70F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA710 to 0xA717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA718 to 0xA71F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA720 to 0xA727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA728 to 0xA72F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA730 to 0xA737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA738 to 0xA73F */
0x4F5C, 0x4F60, 0x4F2F, 0x4F4E, 0x4F36, 0x4F59, 0x4F5D, 0x4F48, 	/* 0xA740 to 0xA747 */
0x4F5A, 0x514C, 0x514B, 0x514D, 0x5175, 0x51B6, 0x51B7, 0x5225, 	/* 0xA748 to 0xA74F */
0x5224, 0x5229, 0x522A, 0x5228, 0x52AB, 0x52A9, 0x52AA, 0x52AC, 	/* 0xA750 to 0xA757 */
0x5323, 0x5373, 0x5375, 0x541D, 0x542D, 0x541E, 0x543E, 0x5426, 	/* 0xA758 to 0xA75F */
0x544E, 0x5427, 0x5446, 0x5443, 0x5433, 0x5448, 0x5442, 0x541B, 	/* 0xA760 to 0xA767 */
0x5429, 0x544A, 0x5439, 0x543B, 0x5438, 0x542E, 0x5435, 0x5436, 	/* 0xA768 to 0xA76F */
0x5420, 0x543C, 0x5440, 0x5431, 0x542B, 0x541F, 0x542C, 0x56EA, 	/* 0xA770 to 0xA777 */
0x56F0, 0x56E4, 0x56EB, 0x574A, 0x5751, 0x5740, 0x574D, 0x0000, 	/* 0xA778 to 0xA77F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA780 to 0xA787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA788 to 0xA78F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA790 to 0xA797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA798 to 0xA79F */
0x0000, 0x5747, 0x574E, 0x573E, 0x5750, 0x574F, 0x573B, 0x58EF, 	/* 0xA7A0 to 0xA7A7 */
0x593E, 0x599D, 0x5992, 0x59A8, 0x599E, 0x59A3, 0x5999, 0x5996, 	/* 0xA7A8 to 0xA7AF */
0x598D, 0x59A4, 0x5993, 0x598A, 0x59A5, 0x5B5D, 0x5B5C, 0x5B5A, 	/* 0xA7B0 to 0xA7B7 */
0x5B5B, 0x5B8C, 0x5B8B, 0x5B8F, 0x5C2C, 0x5C40, 0x5C41, 0x5C3F, 	/* 0xA7B8 to 0xA7BF */
0x5C3E, 0x5C90, 0x5C91, 0x5C94, 0x5C8C, 0x5DEB, 0x5E0C, 0x5E8F, 	/* 0xA7C0 to 0xA7C7 */
0x5E87, 0x5E8A, 0x5EF7, 0x5F04, 0x5F1F, 0x5F64, 0x5F62, 0x5F77, 	/* 0xA7C8 to 0xA7CF */
0x5F79, 0x5FD8, 0x5FCC, 0x5FD7, 0x5FCD, 0x5FF1, 0x5FEB, 0x5FF8, 	/* 0xA7D0 to 0xA7D7 */
0x5FEA, 0x6212, 0x6211, 0x6284, 0x6297, 0x6296, 0x6280, 0x6276, 	/* 0xA7D8 to 0xA7DF */
0x6289, 0x626D, 0x628A, 0x627C, 0x627E, 0x6279, 0x6273, 0x6292, 	/* 0xA7E0 to 0xA7E7 */
0x626F, 0x6298, 0x626E, 0x6295, 0x6293, 0x6291, 0x6286, 0x6539, 	/* 0xA7E8 to 0xA7EF */
0x653B, 0x6538, 0x65F1, 0x66F4, 0x675F, 0x674E, 0x674F, 0x6750, 	/* 0xA7F0 to 0xA7F7 */
0x6751, 0x675C, 0x6756, 0x675E, 0x6749, 0x6746, 0x6760, 0x0000, 	/* 0xA7F8 to 0xA7FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA800 to 0xA807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA808 to 0xA80F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA810 to 0xA817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA818 to 0xA81F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA820 to 0xA827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA828 to 0xA82F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA830 to 0xA837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA838 to 0xA83F */
0x6753, 0x6757, 0x6B65, 0x6BCF, 0x6C42, 0x6C5E, 0x6C99, 0x6C81, 	/* 0xA840 to 0xA847 */
0x6C88, 0x6C89, 0x6C85, 0x6C9B, 0x6C6A, 0x6C7A, 0x6C90, 0x6C70, 	/* 0xA848 to 0xA84F */
0x6C8C, 0x6C68, 0x6C96, 0x6C92, 0x6C7D, 0x6C83, 0x6C72, 0x6C7E, 	/* 0xA850 to 0xA857 */
0x6C74, 0x6C86, 0x6C76, 0x6C8D, 0x6C94, 0x6C98, 0x6C82, 0x7076, 	/* 0xA858 to 0xA85F */
0x707C, 0x707D, 0x7078, 0x7262, 0x7261, 0x7260, 0x72C4, 0x72C2, 	/* 0xA860 to 0xA867 */
0x7396, 0x752C, 0x752B, 0x7537, 0x7538, 0x7682, 0x76EF, 0x77E3, 	/* 0xA868 to 0xA86F */
0x79C1, 0x79C0, 0x79BF, 0x7A76, 0x7CFB, 0x7F55, 0x8096, 0x8093, 	/* 0xA870 to 0xA877 */
0x809D, 0x8098, 0x809B, 0x809A, 0x80B2, 0x826F, 0x8292, 0x0000, 	/* 0xA878 to 0xA87F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA880 to 0xA887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA888 to 0xA88F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA890 to 0xA897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA898 to 0xA89F */
0x0000, 0x828B, 0x828D, 0x898B, 0x89D2, 0x8A00, 0x8C37, 0x8C46, 	/* 0xA8A0 to 0xA8A7 */
0x8C55, 0x8C9D, 0x8D64, 0x8D70, 0x8DB3, 0x8EAB, 0x8ECA, 0x8F9B, 	/* 0xA8A8 to 0xA8AF */
0x8FB0, 0x8FC2, 0x8FC6, 0x8FC5, 0x8FC4, 0x5DE1, 0x9091, 0x90A2, 	/* 0xA8B0 to 0xA8B7 */
0x90AA, 0x90A6, 0x90A3, 0x9149, 0x91C6, 0x91CC, 0x9632, 0x962E, 	/* 0xA8B8 to 0xA8BF */
0x9631, 0x962A, 0x962C, 0x4E26, 0x4E56, 0x4E73, 0x4E8B, 0x4E9B, 	/* 0xA8C0 to 0xA8C7 */
0x4E9E, 0x4EAB, 0x4EAC, 0x4F6F, 0x4F9D, 0x4F8D, 0x4F73, 0x4F7F, 	/* 0xA8C8 to 0xA8CF */
0x4F6C, 0x4F9B, 0x4F8B, 0x4F86, 0x4F83, 0x4F70, 0x4F75, 0x4F88, 	/* 0xA8D0 to 0xA8D7 */
0x4F69, 0x4F7B, 0x4F96, 0x4F7E, 0x4F8F, 0x4F91, 0x4F7A, 0x5154, 	/* 0xA8D8 to 0xA8DF */
0x5152, 0x5155, 0x5169, 0x5177, 0x5176, 0x5178, 0x51BD, 0x51FD, 	/* 0xA8E0 to 0xA8E7 */
0x523B, 0x5238, 0x5237, 0x523A, 0x5230, 0x522E, 0x5236, 0x5241, 	/* 0xA8E8 to 0xA8EF */
0x52BE, 0x52BB, 0x5352, 0x5354, 0x5353, 0x5351, 0x5366, 0x5377, 	/* 0xA8F0 to 0xA8F7 */
0x5378, 0x5379, 0x53D6, 0x53D4, 0x53D7, 0x5473, 0x5475, 0x0000, 	/* 0xA8F8 to 0xA8FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA900 to 0xA907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA908 to 0xA90F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA910 to 0xA917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA918 to 0xA91F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA920 to 0xA927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA928 to 0xA92F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA930 to 0xA937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA938 to 0xA93F */
0x5496, 0x5478, 0x5495, 0x5480, 0x547B, 0x5477, 0x5484, 0x5492, 	/* 0xA940 to 0xA947 */
0x5486, 0x547C, 0x5490, 0x5471, 0x5476, 0x548C, 0x549A, 0x5462, 	/* 0xA948 to 0xA94F */
0x5468, 0x548B, 0x547D, 0x548E, 0x56FA, 0x5783, 0x5777, 0x576A, 	/* 0xA950 to 0xA957 */
0x5769, 0x5761, 0x5766, 0x5764, 0x577C, 0x591C, 0x5949, 0x5947, 	/* 0xA958 to 0xA95F */
0x5948, 0x5944, 0x5954, 0x59BE, 0x59BB, 0x59D4, 0x59B9, 0x59AE, 	/* 0xA960 to 0xA967 */
0x59D1, 0x59C6, 0x59D0, 0x59CD, 0x59CB, 0x59D3, 0x59CA, 0x59AF, 	/* 0xA968 to 0xA96F */
0x59B3, 0x59D2, 0x59C5, 0x5B5F, 0x5B64, 0x5B63, 0x5B97, 0x5B9A, 	/* 0xA970 to 0xA977 */
0x5B98, 0x5B9C, 0x5B99, 0x5B9B, 0x5C1A, 0x5C48, 0x5C45, 0x0000, 	/* 0xA978 to 0xA97F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA980 to 0xA987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA988 to 0xA98F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA990 to 0xA997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xA998 to 0xA99F */
0x0000, 0x5C46, 0x5CB7, 0x5CA1, 0x5CB8, 0x5CA9, 0x5CAB, 0x5CB1, 	/* 0xA9A0 to 0xA9A7 */
0x5CB3, 0x5E18, 0x5E1A, 0x5E16, 0x5E15, 0x5E1B, 0x5E11, 0x5E78, 	/* 0xA9A8 to 0xA9AF */
0x5E9A, 0x5E97, 0x5E9C, 0x5E95, 0x5E96, 0x5EF6, 0x5F26, 0x5F27, 	/* 0xA9B0 to 0xA9B7 */
0x5F29, 0x5F80, 0x5F81, 0x5F7F, 0x5F7C, 0x5FDD, 0x5FE0, 0x5FFD, 	/* 0xA9B8 to 0xA9BF */
0x5FF5, 0x5FFF, 0x600F, 0x6014, 0x602F, 0x6035, 0x6016, 0x602A, 	/* 0xA9C0 to 0xA9C7 */
0x6015, 0x6021, 0x6027, 0x6029, 0x602B, 0x601B, 0x6216, 0x6215, 	/* 0xA9C8 to 0xA9CF */
0x623F, 0x623E, 0x6240, 0x627F, 0x62C9, 0x62CC, 0x62C4, 0x62BF, 	/* 0xA9D0 to 0xA9D7 */
0x62C2, 0x62B9, 0x62D2, 0x62DB, 0x62AB, 0x62D3, 0x62D4, 0x62CB, 	/* 0xA9D8 to 0xA9DF */
0x62C8, 0x62A8, 0x62BD, 0x62BC, 0x62D0, 0x62D9, 0x62C7, 0x62CD, 	/* 0xA9E0 to 0xA9E7 */
0x62B5, 0x62DA, 0x62B1, 0x62D8, 0x62D6, 0x62D7, 0x62C6, 0x62AC, 	/* 0xA9E8 to 0xA9EF */
0x62CE, 0x653E, 0x65A7, 0x65BC, 0x65FA, 0x6614, 0x6613, 0x660C, 	/* 0xA9F0 to 0xA9F7 */
0x6606, 0x6602, 0x660E, 0x6600, 0x660F, 0x6615, 0x660A, 0x0000, 	/* 0xA9F8 to 0xA9FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA00 to 0xAA07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA08 to 0xAA0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA10 to 0xAA17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA18 to 0xAA1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA20 to 0xAA27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA28 to 0xAA2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA30 to 0xAA37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA38 to 0xAA3F */
0x6607, 0x670D, 0x670B, 0x676D, 0x678B, 0x6795, 0x6771, 0x679C, 	/* 0xAA40 to 0xAA47 */
0x6773, 0x6777, 0x6787, 0x679D, 0x6797, 0x676F, 0x6770, 0x677F, 	/* 0xAA48 to 0xAA4F */
0x6789, 0x677E, 0x6790, 0x6775, 0x679A, 0x6793, 0x677C, 0x676A, 	/* 0xAA50 to 0xAA57 */
0x6772, 0x6B23, 0x6B66, 0x6B67, 0x6B7F, 0x6C13, 0x6C1B, 0x6CE3, 	/* 0xAA58 to 0xAA5F */
0x6CE8, 0x6CF3, 0x6CB1, 0x6CCC, 0x6CE5, 0x6CB3, 0x6CBD, 0x6CBE, 	/* 0xAA60 to 0xAA67 */
0x6CBC, 0x6CE2, 0x6CAB, 0x6CD5, 0x6CD3, 0x6CB8, 0x6CC4, 0x6CB9, 	/* 0xAA68 to 0xAA6F */
0x6CC1, 0x6CAE, 0x6CD7, 0x6CC5, 0x6CF1, 0x6CBF, 0x6CBB, 0x6CE1, 	/* 0xAA70 to 0xAA77 */
0x6CDB, 0x6CCA, 0x6CAC, 0x6CEF, 0x6CDC, 0x6CD6, 0x6CE0, 0x0000, 	/* 0xAA78 to 0xAA7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA80 to 0xAA87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA88 to 0xAA8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA90 to 0xAA97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAA98 to 0xAA9F */
0x0000, 0x7095, 0x708E, 0x7092, 0x708A, 0x7099, 0x722C, 0x722D, 	/* 0xAAA0 to 0xAAA7 */
0x7238, 0x7248, 0x7267, 0x7269, 0x72C0, 0x72CE, 0x72D9, 0x72D7, 	/* 0xAAA8 to 0xAAAF */
0x72D0, 0x73A9, 0x73A8, 0x739F, 0x73AB, 0x73A5, 0x753D, 0x759D, 	/* 0xAAB0 to 0xAAB7 */
0x7599, 0x759A, 0x7684, 0x76C2, 0x76F2, 0x76F4, 0x77E5, 0x77FD, 	/* 0xAAB8 to 0xAABF */
0x793E, 0x7940, 0x7941, 0x79C9, 0x79C8, 0x7A7A, 0x7A79, 0x7AFA, 	/* 0xAAC0 to 0xAAC7 */
0x7CFE, 0x7F54, 0x7F8C, 0x7F8B, 0x8005, 0x80BA, 0x80A5, 0x80A2, 	/* 0xAAC8 to 0xAACF */
0x80B1, 0x80A1, 0x80AB, 0x80A9, 0x80B4, 0x80AA, 0x80AF, 0x81E5, 	/* 0xAAD0 to 0xAAD7 */
0x81FE, 0x820D, 0x82B3, 0x829D, 0x8299, 0x82AD, 0x82BD, 0x829F, 	/* 0xAAD8 to 0xAADF */
0x82B9, 0x82B1, 0x82AC, 0x82A5, 0x82AF, 0x82B8, 0x82A3, 0x82B0, 	/* 0xAAE0 to 0xAAE7 */
0x82BE, 0x82B7, 0x864E, 0x8671, 0x521D, 0x8868, 0x8ECB, 0x8FCE, 	/* 0xAAE8 to 0xAAEF */
0x8FD4, 0x8FD1, 0x90B5, 0x90B8, 0x90B1, 0x90B6, 0x91C7, 0x91D1, 	/* 0xAAF0 to 0xAAF7 */
0x9577, 0x9580, 0x961C, 0x9640, 0x963F, 0x963B, 0x9644, 0x0000, 	/* 0xAAF8 to 0xAAFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB00 to 0xAB07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB08 to 0xAB0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB10 to 0xAB17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB18 to 0xAB1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB20 to 0xAB27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB28 to 0xAB2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB30 to 0xAB37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB38 to 0xAB3F */
0x9642, 0x96B9, 0x96E8, 0x9752, 0x975E, 0x4E9F, 0x4EAD, 0x4EAE, 	/* 0xAB40 to 0xAB47 */
0x4FE1, 0x4FB5, 0x4FAF, 0x4FBF, 0x4FE0, 0x4FD1, 0x4FCF, 0x4FDD, 	/* 0xAB48 to 0xAB4F */
0x4FC3, 0x4FB6, 0x4FD8, 0x4FDF, 0x4FCA, 0x4FD7, 0x4FAE, 0x4FD0, 	/* 0xAB50 to 0xAB57 */
0x4FC4, 0x4FC2, 0x4FDA, 0x4FCE, 0x4FDE, 0x4FB7, 0x5157, 0x5192, 	/* 0xAB58 to 0xAB5F */
0x5191, 0x51A0, 0x524E, 0x5243, 0x524A, 0x524D, 0x524C, 0x524B, 	/* 0xAB60 to 0xAB67 */
0x5247, 0x52C7, 0x52C9, 0x52C3, 0x52C1, 0x530D, 0x5357, 0x537B, 	/* 0xAB68 to 0xAB6F */
0x539A, 0x53DB, 0x54AC, 0x54C0, 0x54A8, 0x54CE, 0x54C9, 0x54B8, 	/* 0xAB70 to 0xAB77 */
0x54A6, 0x54B3, 0x54C7, 0x54C2, 0x54BD, 0x54AA, 0x54C1, 0x0000, 	/* 0xAB78 to 0xAB7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB80 to 0xAB87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB88 to 0xAB8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB90 to 0xAB97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAB98 to 0xAB9F */
0x0000, 0x54C4, 0x54C8, 0x54AF, 0x54AB, 0x54B1, 0x54BB, 0x54A9, 	/* 0xABA0 to 0xABA7 */
0x54A7, 0x54BF, 0x56FF, 0x5782, 0x578B, 0x57A0, 0x57A3, 0x57A2, 	/* 0xABA8 to 0xABAF */
0x57CE, 0x57AE, 0x5793, 0x5955, 0x5951, 0x594F, 0x594E, 0x5950, 	/* 0xABB0 to 0xABB7 */
0x59DC, 0x59D8, 0x59FF, 0x59E3, 0x59E8, 0x5A03, 0x59E5, 0x59EA, 	/* 0xABB8 to 0xABBF */
0x59DA, 0x59E6, 0x5A01, 0x59FB, 0x5B69, 0x5BA3, 0x5BA6, 0x5BA4, 	/* 0xABC0 to 0xABC7 */
0x5BA2, 0x5BA5, 0x5C01, 0x5C4E, 0x5C4F, 0x5C4D, 0x5C4B, 0x5CD9, 	/* 0xABC8 to 0xABCF */
0x5CD2, 0x5DF7, 0x5E1D, 0x5E25, 0x5E1F, 0x5E7D, 0x5EA0, 0x5EA6, 	/* 0xABD0 to 0xABD7 */
0x5EFA, 0x5F08, 0x5F2D, 0x5F65, 0x5F88, 0x5F85, 0x5F8A, 0x5F8B, 	/* 0xABD8 to 0xABDF */
0x5F87, 0x5F8C, 0x5F89, 0x6012, 0x601D, 0x6020, 0x6025, 0x600E, 	/* 0xABE0 to 0xABE7 */
0x6028, 0x604D, 0x6070, 0x6068, 0x6062, 0x6046, 0x6043, 0x606C, 	/* 0xABE8 to 0xABEF */
0x606B, 0x606A, 0x6064, 0x6241, 0x62DC, 0x6316, 0x6309, 0x62FC, 	/* 0xABF0 to 0xABF7 */
0x62ED, 0x6301, 0x62EE, 0x62FD, 0x6307, 0x62F1, 0x62F7, 0x0000, 	/* 0xABF8 to 0xABFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC00 to 0xAC07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC08 to 0xAC0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC10 to 0xAC17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC18 to 0xAC1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC20 to 0xAC27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC28 to 0xAC2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC30 to 0xAC37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC38 to 0xAC3F */
0x62EF, 0x62EC, 0x62FE, 0x62F4, 0x6311, 0x6302, 0x653F, 0x6545, 	/* 0xAC40 to 0xAC47 */
0x65AB, 0x65BD, 0x65E2, 0x6625, 0x662D, 0x6620, 0x6627, 0x662F, 	/* 0xAC48 to 0xAC4F */
0x661F, 0x6628, 0x6631, 0x6624, 0x66F7, 0x67FF, 0x67D3, 0x67F1, 	/* 0xAC50 to 0xAC57 */
0x67D4, 0x67D0, 0x67EC, 0x67B6, 0x67AF, 0x67F5, 0x67E9, 0x67EF, 	/* 0xAC58 to 0xAC5F */
0x67C4, 0x67D1, 0x67B4, 0x67DA, 0x67E5, 0x67B8, 0x67CF, 0x67DE, 	/* 0xAC60 to 0xAC67 */
0x67F3, 0x67B0, 0x67D9, 0x67E2, 0x67DD, 0x67D2, 0x6B6A, 0x6B83, 	/* 0xAC68 to 0xAC6F */
0x6B86, 0x6BB5, 0x6BD2, 0x6BD7, 0x6C1F, 0x6CC9, 0x6D0B, 0x6D32, 	/* 0xAC70 to 0xAC77 */
0x6D2A, 0x6D41, 0x6D25, 0x6D0C, 0x6D31, 0x6D1E, 0x6D17, 0x0000, 	/* 0xAC78 to 0xAC7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC80 to 0xAC87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC88 to 0xAC8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC90 to 0xAC97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAC98 to 0xAC9F */
0x0000, 0x6D3B, 0x6D3D, 0x6D3E, 0x6D36, 0x6D1B, 0x6CF5, 0x6D39, 	/* 0xACA0 to 0xACA7 */
0x6D27, 0x6D38, 0x6D29, 0x6D2E, 0x6D35, 0x6D0E, 0x6D2B, 0x70AB, 	/* 0xACA8 to 0xACAF */
0x70BA, 0x70B3, 0x70AC, 0x70AF, 0x70AD, 0x70B8, 0x70AE, 0x70A4, 	/* 0xACB0 to 0xACB7 */
0x7230, 0x7272, 0x726F, 0x7274, 0x72E9, 0x72E0, 0x72E1, 0x73B7, 	/* 0xACB8 to 0xACBF */
0x73CA, 0x73BB, 0x73B2, 0x73CD, 0x73C0, 0x73B3, 0x751A, 0x752D, 	/* 0xACC0 to 0xACC7 */
0x754F, 0x754C, 0x754E, 0x754B, 0x75AB, 0x75A4, 0x75A5, 0x75A2, 	/* 0xACC8 to 0xACCF */
0x75A3, 0x7678, 0x7686, 0x7687, 0x7688, 0x76C8, 0x76C6, 0x76C3, 	/* 0xACD0 to 0xACD7 */
0x76C5, 0x7701, 0x76F9, 0x76F8, 0x7709, 0x770B, 0x76FE, 0x76FC, 	/* 0xACD8 to 0xACDF */
0x7707, 0x77DC, 0x7802, 0x7814, 0x780C, 0x780D, 0x7946, 0x7949, 	/* 0xACE0 to 0xACE7 */
0x7948, 0x7947, 0x79B9, 0x79BA, 0x79D1, 0x79D2, 0x79CB, 0x7A7F, 	/* 0xACE8 to 0xACEF */
0x7A81, 0x7AFF, 0x7AFD, 0x7C7D, 0x7D02, 0x7D05, 0x7D00, 0x7D09, 	/* 0xACF0 to 0xACF7 */
0x7D07, 0x7D04, 0x7D06, 0x7F38, 0x7F8E, 0x7FBF, 0x8004, 0x0000, 	/* 0xACF8 to 0xACFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD00 to 0xAD07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD08 to 0xAD0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD10 to 0xAD17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD18 to 0xAD1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD20 to 0xAD27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD28 to 0xAD2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD30 to 0xAD37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD38 to 0xAD3F */
0x8010, 0x800D, 0x8011, 0x8036, 0x80D6, 0x80E5, 0x80DA, 0x80C3, 	/* 0xAD40 to 0xAD47 */
0x80C4, 0x80CC, 0x80E1, 0x80DB, 0x80CE, 0x80DE, 0x80E4, 0x80DD, 	/* 0xAD48 to 0xAD4F */
0x81F4, 0x8222, 0x82E7, 0x8303, 0x8305, 0x82E3, 0x82DB, 0x82E6, 	/* 0xAD50 to 0xAD57 */
0x8304, 0x82E5, 0x8302, 0x8309, 0x82D2, 0x82D7, 0x82F1, 0x8301, 	/* 0xAD58 to 0xAD5F */
0x82DC, 0x82D4, 0x82D1, 0x82DE, 0x82D3, 0x82DF, 0x82EF, 0x8306, 	/* 0xAD60 to 0xAD67 */
0x8650, 0x8679, 0x867B, 0x867A, 0x884D, 0x886B, 0x8981, 0x89D4, 	/* 0xAD68 to 0xAD6F */
0x8A08, 0x8A02, 0x8A03, 0x8C9E, 0x8CA0, 0x8D74, 0x8D73, 0x8DB4, 	/* 0xAD70 to 0xAD77 */
0x8ECD, 0x8ECC, 0x8FF0, 0x8FE6, 0x8FE2, 0x8FEA, 0x8FE5, 0x0000, 	/* 0xAD78 to 0xAD7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD80 to 0xAD87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD88 to 0xAD8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD90 to 0xAD97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAD98 to 0xAD9F */
0x0000, 0x8FED, 0x8FEB, 0x8FE4, 0x8FE8, 0x90CA, 0x90CE, 0x90C1, 	/* 0xADA0 to 0xADA7 */
0x90C3, 0x914B, 0x914A, 0x91CD, 0x9582, 0x9650, 0x964B, 0x964C, 	/* 0xADA8 to 0xADAF */
0x964D, 0x9762, 0x9769, 0x97CB, 0x97ED, 0x97F3, 0x9801, 0x98A8, 	/* 0xADB0 to 0xADB7 */
0x98DB, 0x98DF, 0x9996, 0x9999, 0x4E58, 0x4EB3, 0x500C, 0x500D, 	/* 0xADB8 to 0xADBF */
0x5023, 0x4FEF, 0x5026, 0x5025, 0x4FF8, 0x5029, 0x5016, 0x5006, 	/* 0xADC0 to 0xADC7 */
0x503C, 0x501F, 0x501A, 0x5012, 0x5011, 0x4FFA, 0x5000, 0x5014, 	/* 0xADC8 to 0xADCF */
0x5028, 0x4FF1, 0x5021, 0x500B, 0x5019, 0x5018, 0x4FF3, 0x4FEE, 	/* 0xADD0 to 0xADD7 */
0x502D, 0x502A, 0x4FFE, 0x502B, 0x5009, 0x517C, 0x51A4, 0x51A5, 	/* 0xADD8 to 0xADDF */
0x51A2, 0x51CD, 0x51CC, 0x51C6, 0x51CB, 0x5256, 0x525C, 0x5254, 	/* 0xADE0 to 0xADE7 */
0x525B, 0x525D, 0x532A, 0x537F, 0x539F, 0x539D, 0x53DF, 0x54E8, 	/* 0xADE8 to 0xADEF */
0x5510, 0x5501, 0x5537, 0x54FC, 0x54E5, 0x54F2, 0x5506, 0x54FA, 	/* 0xADF0 to 0xADF7 */
0x5514, 0x54E9, 0x54ED, 0x54E1, 0x5509, 0x54EE, 0x54EA, 0x0000, 	/* 0xADF8 to 0xADFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE00 to 0xAE07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE08 to 0xAE0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE10 to 0xAE17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE18 to 0xAE1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE20 to 0xAE27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE28 to 0xAE2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE30 to 0xAE37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE38 to 0xAE3F */
0x54E6, 0x5527, 0x5507, 0x54FD, 0x550F, 0x5703, 0x5704, 0x57C2, 	/* 0xAE40 to 0xAE47 */
0x57D4, 0x57CB, 0x57C3, 0x5809, 0x590F, 0x5957, 0x5958, 0x595A, 	/* 0xAE48 to 0xAE4F */
0x5A11, 0x5A18, 0x5A1C, 0x5A1F, 0x5A1B, 0x5A13, 0x59EC, 0x5A20, 	/* 0xAE50 to 0xAE57 */
0x5A23, 0x5A29, 0x5A25, 0x5A0C, 0x5A09, 0x5B6B, 0x5C58, 0x5BB0, 	/* 0xAE58 to 0xAE5F */
0x5BB3, 0x5BB6, 0x5BB4, 0x5BAE, 0x5BB5, 0x5BB9, 0x5BB8, 0x5C04, 	/* 0xAE60 to 0xAE67 */
0x5C51, 0x5C55, 0x5C50, 0x5CED, 0x5CFD, 0x5CFB, 0x5CEA, 0x5CE8, 	/* 0xAE68 to 0xAE6F */
0x5CF0, 0x5CF6, 0x5D01, 0x5CF4, 0x5DEE, 0x5E2D, 0x5E2B, 0x5EAB, 	/* 0xAE70 to 0xAE77 */
0x5EAD, 0x5EA7, 0x5F31, 0x5F92, 0x5F91, 0x5F90, 0x6059, 0x0000, 	/* 0xAE78 to 0xAE7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE80 to 0xAE87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE88 to 0xAE8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE90 to 0xAE97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAE98 to 0xAE9F */
0x0000, 0x6063, 0x6065, 0x6050, 0x6055, 0x606D, 0x6069, 0x606F, 	/* 0xAEA0 to 0xAEA7 */
0x6084, 0x609F, 0x609A, 0x608D, 0x6094, 0x608C, 0x6085, 0x6096, 	/* 0xAEA8 to 0xAEAF */
0x6247, 0x62F3, 0x6308, 0x62FF, 0x634E, 0x633E, 0x632F, 0x6355, 	/* 0xAEB0 to 0xAEB7 */
0x6342, 0x6346, 0x634F, 0x6349, 0x633A, 0x6350, 0x633D, 0x632A, 	/* 0xAEB8 to 0xAEBF */
0x632B, 0x6328, 0x634D, 0x634C, 0x6548, 0x6549, 0x6599, 0x65C1, 	/* 0xAEC0 to 0xAEC7 */
0x65C5, 0x6642, 0x6649, 0x664F, 0x6643, 0x6652, 0x664C, 0x6645, 	/* 0xAEC8 to 0xAECF */
0x6641, 0x66F8, 0x6714, 0x6715, 0x6717, 0x6821, 0x6838, 0x6848, 	/* 0xAED0 to 0xAED7 */
0x6846, 0x6853, 0x6839, 0x6842, 0x6854, 0x6829, 0x68B3, 0x6817, 	/* 0xAED8 to 0xAEDF */
0x684C, 0x6851, 0x683D, 0x67F4, 0x6850, 0x6840, 0x683C, 0x6843, 	/* 0xAEE0 to 0xAEE7 */
0x682A, 0x6845, 0x6813, 0x6818, 0x6841, 0x6B8A, 0x6B89, 0x6BB7, 	/* 0xAEE8 to 0xAEEF */
0x6C23, 0x6C27, 0x6C28, 0x6C26, 0x6C24, 0x6CF0, 0x6D6A, 0x6D95, 	/* 0xAEF0 to 0xAEF7 */
0x6D88, 0x6D87, 0x6D66, 0x6D78, 0x6D77, 0x6D59, 0x6D93, 0x0000, 	/* 0xAEF8 to 0xAEFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF00 to 0xAF07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF08 to 0xAF0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF10 to 0xAF17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF18 to 0xAF1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF20 to 0xAF27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF28 to 0xAF2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF30 to 0xAF37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF38 to 0xAF3F */
0x6D6C, 0x6D89, 0x6D6E, 0x6D5A, 0x6D74, 0x6D69, 0x6D8C, 0x6D8A, 	/* 0xAF40 to 0xAF47 */
0x6D79, 0x6D85, 0x6D65, 0x6D94, 0x70CA, 0x70D8, 0x70E4, 0x70D9, 	/* 0xAF48 to 0xAF4F */
0x70C8, 0x70CF, 0x7239, 0x7279, 0x72FC, 0x72F9, 0x72FD, 0x72F8, 	/* 0xAF50 to 0xAF57 */
0x72F7, 0x7386, 0x73ED, 0x7409, 0x73EE, 0x73E0, 0x73EA, 0x73DE, 	/* 0xAF58 to 0xAF5F */
0x7554, 0x755D, 0x755C, 0x755A, 0x7559, 0x75BE, 0x75C5, 0x75C7, 	/* 0xAF60 to 0xAF67 */
0x75B2, 0x75B3, 0x75BD, 0x75BC, 0x75B9, 0x75C2, 0x75B8, 0x768B, 	/* 0xAF68 to 0xAF6F */
0x76B0, 0x76CA, 0x76CD, 0x76CE, 0x7729, 0x771F, 0x7720, 0x7728, 	/* 0xAF70 to 0xAF77 */
0x77E9, 0x7830, 0x7827, 0x7838, 0x781D, 0x7834, 0x7837, 0x0000, 	/* 0xAF78 to 0xAF7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF80 to 0xAF87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF88 to 0xAF8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF90 to 0xAF97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xAF98 to 0xAF9F */
0x0000, 0x7825, 0x782D, 0x7820, 0x781F, 0x7832, 0x7955, 0x7950, 	/* 0xAFA0 to 0xAFA7 */
0x7960, 0x795F, 0x7956, 0x795E, 0x795D, 0x7957, 0x795A, 0x79E4, 	/* 0xAFA8 to 0xAFAF */
0x79E3, 0x79E7, 0x79DF, 0x79E6, 0x79E9, 0x79D8, 0x7A84, 0x7A88, 	/* 0xAFB0 to 0xAFB7 */
0x7AD9, 0x7B06, 0x7B11, 0x7C89, 0x7D21, 0x7D17, 0x7D0B, 0x7D0A, 	/* 0xAFB8 to 0xAFBF */
0x7D20, 0x7D22, 0x7D14, 0x7D10, 0x7D15, 0x7D1A, 0x7D1C, 0x7D0D, 	/* 0xAFC0 to 0xAFC7 */
0x7D19, 0x7D1B, 0x7F3A, 0x7F5F, 0x7F94, 0x7FC5, 0x7FC1, 0x8006, 	/* 0xAFC8 to 0xAFCF */
0x8018, 0x8015, 0x8019, 0x8017, 0x803D, 0x803F, 0x80F1, 0x8102, 	/* 0xAFD0 to 0xAFD7 */
0x80F0, 0x8105, 0x80ED, 0x80F4, 0x8106, 0x80F8, 0x80F3, 0x8108, 	/* 0xAFD8 to 0xAFDF */
0x80FD, 0x810A, 0x80FC, 0x80EF, 0x81ED, 0x81EC, 0x8200, 0x8210, 	/* 0xAFE0 to 0xAFE7 */
0x822A, 0x822B, 0x8228, 0x822C, 0x82BB, 0x832B, 0x8352, 0x8354, 	/* 0xAFE8 to 0xAFEF */
0x834A, 0x8338, 0x8350, 0x8349, 0x8335, 0x8334, 0x834F, 0x8332, 	/* 0xAFF0 to 0xAFF7 */
0x8339, 0x8336, 0x8317, 0x8340, 0x8331, 0x8328, 0x8343, 0x0000, 	/* 0xAFF8 to 0xAFFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB000 to 0xB007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB008 to 0xB00F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB010 to 0xB017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB018 to 0xB01F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB020 to 0xB027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB028 to 0xB02F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB030 to 0xB037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB038 to 0xB03F */
0x8654, 0x868A, 0x86AA, 0x8693, 0x86A4, 0x86A9, 0x868C, 0x86A3, 	/* 0xB040 to 0xB047 */
0x869C, 0x8870, 0x8877, 0x8881, 0x8882, 0x887D, 0x8879, 0x8A18, 	/* 0xB048 to 0xB04F */
0x8A10, 0x8A0E, 0x8A0C, 0x8A15, 0x8A0A, 0x8A17, 0x8A13, 0x8A16, 	/* 0xB050 to 0xB057 */
0x8A0F, 0x8A11, 0x8C48, 0x8C7A, 0x8C79, 0x8CA1, 0x8CA2, 0x8D77, 	/* 0xB058 to 0xB05F */
0x8EAC, 0x8ED2, 0x8ED4, 0x8ECF, 0x8FB1, 0x9001, 0x9006, 0x8FF7, 	/* 0xB060 to 0xB067 */
0x9000, 0x8FFA, 0x8FF4, 0x9003, 0x8FFD, 0x9005, 0x8FF8, 0x9095, 	/* 0xB068 to 0xB06F */
0x90E1, 0x90DD, 0x90E2, 0x9152, 0x914D, 0x914C, 0x91D8, 0x91DD, 	/* 0xB070 to 0xB077 */
0x91D7, 0x91DC, 0x91D9, 0x9583, 0x9662, 0x9663, 0x9661, 0x0000, 	/* 0xB078 to 0xB07F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB080 to 0xB087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB088 to 0xB08F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB090 to 0xB097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB098 to 0xB09F */
0x0000, 0x965B, 0x965D, 0x9664, 0x9658, 0x965E, 0x96BB, 0x98E2, 	/* 0xB0A0 to 0xB0A7 */
0x99AC, 0x9AA8, 0x9AD8, 0x9B25, 0x9B32, 0x9B3C, 0x4E7E, 0x507A, 	/* 0xB0A8 to 0xB0AF */
0x507D, 0x505C, 0x5047, 0x5043, 0x504C, 0x505A, 0x5049, 0x5065, 	/* 0xB0B0 to 0xB0B7 */
0x5076, 0x504E, 0x5055, 0x5075, 0x5074, 0x5077, 0x504F, 0x500F, 	/* 0xB0B8 to 0xB0BF */
0x506F, 0x506D, 0x515C, 0x5195, 0x51F0, 0x526A, 0x526F, 0x52D2, 	/* 0xB0C0 to 0xB0C7 */
0x52D9, 0x52D8, 0x52D5, 0x5310, 0x530F, 0x5319, 0x533F, 0x5340, 	/* 0xB0C8 to 0xB0CF */
0x533E, 0x53C3, 0x66FC, 0x5546, 0x556A, 0x5566, 0x5544, 0x555E, 	/* 0xB0D0 to 0xB0D7 */
0x5561, 0x5543, 0x554A, 0x5531, 0x5556, 0x554F, 0x5555, 0x552F, 	/* 0xB0D8 to 0xB0DF */
0x5564, 0x5538, 0x552E, 0x555C, 0x552C, 0x5563, 0x5533, 0x5541, 	/* 0xB0E0 to 0xB0E7 */
0x5557, 0x5708, 0x570B, 0x5709, 0x57DF, 0x5805, 0x580A, 0x5806, 	/* 0xB0E8 to 0xB0EF */
0x57E0, 0x57E4, 0x57FA, 0x5802, 0x5835, 0x57F7, 0x57F9, 0x5920, 	/* 0xB0F0 to 0xB0F7 */
0x5962, 0x5A36, 0x5A41, 0x5A49, 0x5A66, 0x5A6A, 0x5A40, 0x0000, 	/* 0xB0F8 to 0xB0FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB100 to 0xB107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB108 to 0xB10F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB110 to 0xB117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB118 to 0xB11F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB120 to 0xB127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB128 to 0xB12F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB130 to 0xB137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB138 to 0xB13F */
0x5A3C, 0x5A62, 0x5A5A, 0x5A46, 0x5A4A, 0x5B70, 0x5BC7, 0x5BC5, 	/* 0xB140 to 0xB147 */
0x5BC4, 0x5BC2, 0x5BBF, 0x5BC6, 0x5C09, 0x5C08, 0x5C07, 0x5C60, 	/* 0xB148 to 0xB14F */
0x5C5C, 0x5C5D, 0x5D07, 0x5D06, 0x5D0E, 0x5D1B, 0x5D16, 0x5D22, 	/* 0xB150 to 0xB157 */
0x5D11, 0x5D29, 0x5D14, 0x5D19, 0x5D24, 0x5D27, 0x5D17, 0x5DE2, 	/* 0xB158 to 0xB15F */
0x5E38, 0x5E36, 0x5E33, 0x5E37, 0x5EB7, 0x5EB8, 0x5EB6, 0x5EB5, 	/* 0xB160 to 0xB167 */
0x5EBE, 0x5F35, 0x5F37, 0x5F57, 0x5F6C, 0x5F69, 0x5F6B, 0x5F97, 	/* 0xB168 to 0xB16F */
0x5F99, 0x5F9E, 0x5F98, 0x5FA1, 0x5FA0, 0x5F9C, 0x607F, 0x60A3, 	/* 0xB170 to 0xB177 */
0x6089, 0x60A0, 0x60A8, 0x60CB, 0x60B4, 0x60E6, 0x60BD, 0x0000, 	/* 0xB178 to 0xB17F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB180 to 0xB187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB188 to 0xB18F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB190 to 0xB197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB198 to 0xB19F */
0x0000, 0x60C5, 0x60BB, 0x60B5, 0x60DC, 0x60BC, 0x60D8, 0x60D5, 	/* 0xB1A0 to 0xB1A7 */
0x60C6, 0x60DF, 0x60B8, 0x60DA, 0x60C7, 0x621A, 0x621B, 0x6248, 	/* 0xB1A8 to 0xB1AF */
0x63A0, 0x63A7, 0x6372, 0x6396, 0x63A2, 0x63A5, 0x6377, 0x6367, 	/* 0xB1B0 to 0xB1B7 */
0x6398, 0x63AA, 0x6371, 0x63A9, 0x6389, 0x6383, 0x639B, 0x636B, 	/* 0xB1B8 to 0xB1BF */
0x63A8, 0x6384, 0x6388, 0x6399, 0x63A1, 0x63AC, 0x6392, 0x638F, 	/* 0xB1C0 to 0xB1C7 */
0x6380, 0x637B, 0x6369, 0x6368, 0x637A, 0x655D, 0x6556, 0x6551, 	/* 0xB1C8 to 0xB1CF */
0x6559, 0x6557, 0x555F, 0x654F, 0x6558, 0x6555, 0x6554, 0x659C, 	/* 0xB1D0 to 0xB1D7 */
0x659B, 0x65AC, 0x65CF, 0x65CB, 0x65CC, 0x65CE, 0x665D, 0x665A, 	/* 0xB1D8 to 0xB1DF */
0x6664, 0x6668, 0x6666, 0x665E, 0x66F9, 0x52D7, 0x671B, 0x6881, 	/* 0xB1E0 to 0xB1E7 */
0x68AF, 0x68A2, 0x6893, 0x68B5, 0x687F, 0x6876, 0x68B1, 0x68A7, 	/* 0xB1E8 to 0xB1EF */
0x6897, 0x68B0, 0x6883, 0x68C4, 0x68AD, 0x6886, 0x6885, 0x6894, 	/* 0xB1F0 to 0xB1F7 */
0x689D, 0x68A8, 0x689F, 0x68A1, 0x6882, 0x6B32, 0x6BBA, 0x0000, 	/* 0xB1F8 to 0xB1FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB200 to 0xB207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB208 to 0xB20F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB210 to 0xB217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB218 to 0xB21F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB220 to 0xB227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB228 to 0xB22F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB230 to 0xB237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB238 to 0xB23F */
0x6BEB, 0x6BEC, 0x6C2B, 0x6D8E, 0x6DBC, 0x6DF3, 0x6DD9, 0x6DB2, 	/* 0xB240 to 0xB247 */
0x6DE1, 0x6DCC, 0x6DE4, 0x6DFB, 0x6DFA, 0x6E05, 0x6DC7, 0x6DCB, 	/* 0xB248 to 0xB24F */
0x6DAF, 0x6DD1, 0x6DAE, 0x6DDE, 0x6DF9, 0x6DB8, 0x6DF7, 0x6DF5, 	/* 0xB250 to 0xB257 */
0x6DC5, 0x6DD2, 0x6E1A, 0x6DB5, 0x6DDA, 0x6DEB, 0x6DD8, 0x6DEA, 	/* 0xB258 to 0xB25F */
0x6DF1, 0x6DEE, 0x6DE8, 0x6DC6, 0x6DC4, 0x6DAA, 0x6DEC, 0x6DBF, 	/* 0xB260 to 0xB267 */
0x6DE6, 0x70F9, 0x7109, 0x710A, 0x70FD, 0x70EF, 0x723D, 0x727D, 	/* 0xB268 to 0xB26F */
0x7281, 0x731C, 0x731B, 0x7316, 0x7313, 0x7319, 0x7387, 0x7405, 	/* 0xB270 to 0xB277 */
0x740A, 0x7403, 0x7406, 0x73FE, 0x740D, 0x74E0, 0x74F6, 0x0000, 	/* 0xB278 to 0xB27F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB280 to 0xB287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB288 to 0xB28F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB290 to 0xB297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB298 to 0xB29F */
0x0000, 0x74F7, 0x751C, 0x7522, 0x7565, 0x7566, 0x7562, 0x7570, 	/* 0xB2A0 to 0xB2A7 */
0x758F, 0x75D4, 0x75D5, 0x75B5, 0x75CA, 0x75CD, 0x768E, 0x76D4, 	/* 0xB2A8 to 0xB2AF */
0x76D2, 0x76DB, 0x7737, 0x773E, 0x773C, 0x7736, 0x7738, 0x773A, 	/* 0xB2B0 to 0xB2B7 */
0x786B, 0x7843, 0x784E, 0x7965, 0x7968, 0x796D, 0x79FB, 0x7A92, 	/* 0xB2B8 to 0xB2BF */
0x7A95, 0x7B20, 0x7B28, 0x7B1B, 0x7B2C, 0x7B26, 0x7B19, 0x7B1E, 	/* 0xB2C0 to 0xB2C7 */
0x7B2E, 0x7C92, 0x7C97, 0x7C95, 0x7D46, 0x7D43, 0x7D71, 0x7D2E, 	/* 0xB2C8 to 0xB2CF */
0x7D39, 0x7D3C, 0x7D40, 0x7D30, 0x7D33, 0x7D44, 0x7D2F, 0x7D42, 	/* 0xB2D0 to 0xB2D7 */
0x7D32, 0x7D31, 0x7F3D, 0x7F9E, 0x7F9A, 0x7FCC, 0x7FCE, 0x7FD2, 	/* 0xB2D8 to 0xB2DF */
0x801C, 0x804A, 0x8046, 0x812F, 0x8116, 0x8123, 0x812B, 0x8129, 	/* 0xB2E0 to 0xB2E7 */
0x8130, 0x8124, 0x8202, 0x8235, 0x8237, 0x8236, 0x8239, 0x838E, 	/* 0xB2E8 to 0xB2EF */
0x839E, 0x8398, 0x8378, 0x83A2, 0x8396, 0x83BD, 0x83AB, 0x8392, 	/* 0xB2F0 to 0xB2F7 */
0x838A, 0x8393, 0x8389, 0x83A0, 0x8377, 0x837B, 0x837C, 0x0000, 	/* 0xB2F8 to 0xB2FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB300 to 0xB307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB308 to 0xB30F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB310 to 0xB317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB318 to 0xB31F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB320 to 0xB327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB328 to 0xB32F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB330 to 0xB337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB338 to 0xB33F */
0x8386, 0x83A7, 0x8655, 0x5F6A, 0x86C7, 0x86C0, 0x86B6, 0x86C4, 	/* 0xB340 to 0xB347 */
0x86B5, 0x86C6, 0x86CB, 0x86B1, 0x86AF, 0x86C9, 0x8853, 0x889E, 	/* 0xB348 to 0xB34F */
0x8888, 0x88AB, 0x8892, 0x8896, 0x888D, 0x888B, 0x8993, 0x898F, 	/* 0xB350 to 0xB357 */
0x8A2A, 0x8A1D, 0x8A23, 0x8A25, 0x8A31, 0x8A2D, 0x8A1F, 0x8A1B, 	/* 0xB358 to 0xB35F */
0x8A22, 0x8C49, 0x8C5A, 0x8CA9, 0x8CAC, 0x8CAB, 0x8CA8, 0x8CAA, 	/* 0xB360 to 0xB367 */
0x8CA7, 0x8D67, 0x8D66, 0x8DBE, 0x8DBA, 0x8EDB, 0x8EDF, 0x9019, 	/* 0xB368 to 0xB36F */
0x900D, 0x901A, 0x9017, 0x9023, 0x901F, 0x901D, 0x9010, 0x9015, 	/* 0xB370 to 0xB377 */
0x901E, 0x9020, 0x900F, 0x9022, 0x9016, 0x901B, 0x9014, 0x0000, 	/* 0xB378 to 0xB37F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB380 to 0xB387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB388 to 0xB38F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB390 to 0xB397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB398 to 0xB39F */
0x0000, 0x90E8, 0x90ED, 0x90FD, 0x9157, 0x91CE, 0x91F5, 0x91E6, 	/* 0xB3A0 to 0xB3A7 */
0x91E3, 0x91E7, 0x91ED, 0x91E9, 0x9589, 0x966A, 0x9675, 0x9673, 	/* 0xB3A8 to 0xB3AF */
0x9678, 0x9670, 0x9674, 0x9676, 0x9677, 0x966C, 0x96C0, 0x96EA, 	/* 0xB3B0 to 0xB3B7 */
0x96E9, 0x7AE0, 0x7ADF, 0x9802, 0x9803, 0x9B5A, 0x9CE5, 0x9E75, 	/* 0xB3B8 to 0xB3BF */
0x9E7F, 0x9EA5, 0x9EBB, 0x50A2, 0x508D, 0x5085, 0x5099, 0x5091, 	/* 0xB3C0 to 0xB3C7 */
0x5080, 0x5096, 0x5098, 0x509A, 0x6700, 0x51F1, 0x5272, 0x5274, 	/* 0xB3C8 to 0xB3CF */
0x5275, 0x5269, 0x52DE, 0x52DD, 0x52DB, 0x535A, 0x53A5, 0x557B, 	/* 0xB3D0 to 0xB3D7 */
0x5580, 0x55A7, 0x557C, 0x558A, 0x559D, 0x5598, 0x5582, 0x559C, 	/* 0xB3D8 to 0xB3DF */
0x55AA, 0x5594, 0x5587, 0x558B, 0x5583, 0x55B3, 0x55AE, 0x559F, 	/* 0xB3E0 to 0xB3E7 */
0x553E, 0x55B2, 0x559A, 0x55BB, 0x55AC, 0x55B1, 0x557E, 0x5589, 	/* 0xB3E8 to 0xB3EF */
0x55AB, 0x5599, 0x570D, 0x582F, 0x582A, 0x5834, 0x5824, 0x5830, 	/* 0xB3F0 to 0xB3F7 */
0x5831, 0x5821, 0x581D, 0x5820, 0x58F9, 0x58FA, 0x5960, 0x0000, 	/* 0xB3F8 to 0xB3FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB400 to 0xB407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB408 to 0xB40F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB410 to 0xB417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB418 to 0xB41F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB420 to 0xB427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB428 to 0xB42F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB430 to 0xB437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB438 to 0xB43F */
0x5A77, 0x5A9A, 0x5A7F, 0x5A92, 0x5A9B, 0x5AA7, 0x5B73, 0x5B71, 	/* 0xB440 to 0xB447 */
0x5BD2, 0x5BCC, 0x5BD3, 0x5BD0, 0x5C0A, 0x5C0B, 0x5C31, 0x5D4C, 	/* 0xB448 to 0xB44F */
0x5D50, 0x5D34, 0x5D47, 0x5DFD, 0x5E45, 0x5E3D, 0x5E40, 0x5E43, 	/* 0xB450 to 0xB457 */
0x5E7E, 0x5ECA, 0x5EC1, 0x5EC2, 0x5EC4, 0x5F3C, 0x5F6D, 0x5FA9, 	/* 0xB458 to 0xB45F */
0x5FAA, 0x5FA8, 0x60D1, 0x60E1, 0x60B2, 0x60B6, 0x60E0, 0x611C, 	/* 0xB460 to 0xB467 */
0x6123, 0x60FA, 0x6115, 0x60F0, 0x60FB, 0x60F4, 0x6168, 0x60F1, 	/* 0xB468 to 0xB46F */
0x610E, 0x60F6, 0x6109, 0x6100, 0x6112, 0x621F, 0x6249, 0x63A3, 	/* 0xB470 to 0xB477 */
0x638C, 0x63CF, 0x63C0, 0x63E9, 0x63C9, 0x63C6, 0x63CD, 0x0000, 	/* 0xB478 to 0xB47F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB480 to 0xB487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB488 to 0xB48F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB490 to 0xB497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB498 to 0xB49F */
0x0000, 0x63D2, 0x63E3, 0x63D0, 0x63E1, 0x63D6, 0x63ED, 0x63EE, 	/* 0xB4A0 to 0xB4A7 */
0x6376, 0x63F4, 0x63EA, 0x63DB, 0x6452, 0x63DA, 0x63F9, 0x655E, 	/* 0xB4A8 to 0xB4AF */
0x6566, 0x6562, 0x6563, 0x6591, 0x6590, 0x65AF, 0x666E, 0x6670, 	/* 0xB4B0 to 0xB4B7 */
0x6674, 0x6676, 0x666F, 0x6691, 0x667A, 0x667E, 0x6677, 0x66FE, 	/* 0xB4B8 to 0xB4BF */
0x66FF, 0x671F, 0x671D, 0x68FA, 0x68D5, 0x68E0, 0x68D8, 0x68D7, 	/* 0xB4C0 to 0xB4C7 */
0x6905, 0x68DF, 0x68F5, 0x68EE, 0x68E7, 0x68F9, 0x68D2, 0x68F2, 	/* 0xB4C8 to 0xB4CF */
0x68E3, 0x68CB, 0x68CD, 0x690D, 0x6912, 0x690E, 0x68C9, 0x68DA, 	/* 0xB4D0 to 0xB4D7 */
0x696E, 0x68FB, 0x6B3E, 0x6B3A, 0x6B3D, 0x6B98, 0x6B96, 0x6BBC, 	/* 0xB4D8 to 0xB4DF */
0x6BEF, 0x6C2E, 0x6C2F, 0x6C2C, 0x6E2F, 0x6E38, 0x6E54, 0x6E21, 	/* 0xB4E0 to 0xB4E7 */
0x6E32, 0x6E67, 0x6E4A, 0x6E20, 0x6E25, 0x6E23, 0x6E1B, 0x6E5B, 	/* 0xB4E8 to 0xB4EF */
0x6E58, 0x6E24, 0x6E56, 0x6E6E, 0x6E2D, 0x6E26, 0x6E6F, 0x6E34, 	/* 0xB4F0 to 0xB4F7 */
0x6E4D, 0x6E3A, 0x6E2C, 0x6E43, 0x6E1D, 0x6E3E, 0x6ECB, 0x0000, 	/* 0xB4F8 to 0xB4FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB500 to 0xB507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB508 to 0xB50F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB510 to 0xB517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB518 to 0xB51F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB520 to 0xB527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB528 to 0xB52F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB530 to 0xB537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB538 to 0xB53F */
0x6E89, 0x6E19, 0x6E4E, 0x6E63, 0x6E44, 0x6E72, 0x6E69, 0x6E5F, 	/* 0xB540 to 0xB547 */
0x7119, 0x711A, 0x7126, 0x7130, 0x7121, 0x7136, 0x716E, 0x711C, 	/* 0xB548 to 0xB54F */
0x724C, 0x7284, 0x7280, 0x7336, 0x7325, 0x7334, 0x7329, 0x743A, 	/* 0xB550 to 0xB557 */
0x742A, 0x7433, 0x7422, 0x7425, 0x7435, 0x7436, 0x7434, 0x742F, 	/* 0xB558 to 0xB55F */
0x741B, 0x7426, 0x7428, 0x7525, 0x7526, 0x756B, 0x756A, 0x75E2, 	/* 0xB560 to 0xB567 */
0x75DB, 0x75E3, 0x75D9, 0x75D8, 0x75DE, 0x75E0, 0x767B, 0x767C, 	/* 0xB568 to 0xB56F */
0x7696, 0x7693, 0x76B4, 0x76DC, 0x774F, 0x77ED, 0x785D, 0x786C, 	/* 0xB570 to 0xB577 */
0x786F, 0x7A0D, 0x7A08, 0x7A0B, 0x7A05, 0x7A00, 0x7A98, 0x0000, 	/* 0xB578 to 0xB57F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB580 to 0xB587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB588 to 0xB58F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB590 to 0xB597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB598 to 0xB59F */
0x0000, 0x7A97, 0x7A96, 0x7AE5, 0x7AE3, 0x7B49, 0x7B56, 0x7B46, 	/* 0xB5A0 to 0xB5A7 */
0x7B50, 0x7B52, 0x7B54, 0x7B4D, 0x7B4B, 0x7B4F, 0x7B51, 0x7C9F, 	/* 0xB5A8 to 0xB5AF */
0x7CA5, 0x7D5E, 0x7D50, 0x7D68, 0x7D55, 0x7D2B, 0x7D6E, 0x7D72, 	/* 0xB5B0 to 0xB5B7 */
0x7D61, 0x7D66, 0x7D62, 0x7D70, 0x7D73, 0x5584, 0x7FD4, 0x7FD5, 	/* 0xB5B8 to 0xB5BF */
0x800B, 0x8052, 0x8085, 0x8155, 0x8154, 0x814B, 0x8151, 0x814E, 	/* 0xB5C0 to 0xB5C7 */
0x8139, 0x8146, 0x813E, 0x814C, 0x8153, 0x8174, 0x8212, 0x821C, 	/* 0xB5C8 to 0xB5CF */
0x83E9, 0x8403, 0x83F8, 0x840D, 0x83E0, 0x83C5, 0x840B, 0x83C1, 	/* 0xB5D0 to 0xB5D7 */
0x83EF, 0x83F1, 0x83F4, 0x8457, 0x840A, 0x83F0, 0x840C, 0x83CC, 	/* 0xB5D8 to 0xB5DF */
0x83FD, 0x83F2, 0x83CA, 0x8438, 0x840E, 0x8404, 0x83DC, 0x8407, 	/* 0xB5E0 to 0xB5E7 */
0x83D4, 0x83DF, 0x865B, 0x86DF, 0x86D9, 0x86ED, 0x86D4, 0x86DB, 	/* 0xB5E8 to 0xB5EF */
0x86E4, 0x86D0, 0x86DE, 0x8857, 0x88C1, 0x88C2, 0x88B1, 0x8983, 	/* 0xB5F0 to 0xB5F7 */
0x8996, 0x8A3B, 0x8A60, 0x8A55, 0x8A5E, 0x8A3C, 0x8A41, 0x0000, 	/* 0xB5F8 to 0xB5FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB600 to 0xB607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB608 to 0xB60F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB610 to 0xB617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB618 to 0xB61F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB620 to 0xB627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB628 to 0xB62F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB630 to 0xB637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB638 to 0xB63F */
0x8A54, 0x8A5B, 0x8A50, 0x8A46, 0x8A34, 0x8A3A, 0x8A36, 0x8A56, 	/* 0xB640 to 0xB647 */
0x8C61, 0x8C82, 0x8CAF, 0x8CBC, 0x8CB3, 0x8CBD, 0x8CC1, 0x8CBB, 	/* 0xB648 to 0xB64F */
0x8CC0, 0x8CB4, 0x8CB7, 0x8CB6, 0x8CBF, 0x8CB8, 0x8D8A, 0x8D85, 	/* 0xB650 to 0xB657 */
0x8D81, 0x8DCE, 0x8DDD, 0x8DCB, 0x8DDA, 0x8DD1, 0x8DCC, 0x8DDB, 	/* 0xB658 to 0xB65F */
0x8DC6, 0x8EFB, 0x8EF8, 0x8EFC, 0x8F9C, 0x902E, 0x9035, 0x9031, 	/* 0xB660 to 0xB667 */
0x9038, 0x9032, 0x9036, 0x9102, 0x90F5, 0x9109, 0x90FE, 0x9163, 	/* 0xB668 to 0xB66F */
0x9165, 0x91CF, 0x9214, 0x9215, 0x9223, 0x9209, 0x921E, 0x920D, 	/* 0xB670 to 0xB677 */
0x9210, 0x9207, 0x9211, 0x9594, 0x958F, 0x958B, 0x9591, 0x0000, 	/* 0xB678 to 0xB67F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB680 to 0xB687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB688 to 0xB68F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB690 to 0xB697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB698 to 0xB69F */
0x0000, 0x9593, 0x9592, 0x958E, 0x968A, 0x968E, 0x968B, 0x967D, 	/* 0xB6A0 to 0xB6A7 */
0x9685, 0x9686, 0x968D, 0x9672, 0x9684, 0x96C1, 0x96C5, 0x96C4, 	/* 0xB6A8 to 0xB6AF */
0x96C6, 0x96C7, 0x96EF, 0x96F2, 0x97CC, 0x9805, 0x9806, 0x9808, 	/* 0xB6B0 to 0xB6B7 */
0x98E7, 0x98EA, 0x98EF, 0x98E9, 0x98F2, 0x98ED, 0x99AE, 0x99AD, 	/* 0xB6B8 to 0xB6BF */
0x9EC3, 0x9ECD, 0x9ED1, 0x4E82, 0x50AD, 0x50B5, 0x50B2, 0x50B3, 	/* 0xB6C0 to 0xB6C7 */
0x50C5, 0x50BE, 0x50AC, 0x50B7, 0x50BB, 0x50AF, 0x50C7, 0x527F, 	/* 0xB6C8 to 0xB6CF */
0x5277, 0x527D, 0x52DF, 0x52E6, 0x52E4, 0x52E2, 0x52E3, 0x532F, 	/* 0xB6D0 to 0xB6D7 */
0x55DF, 0x55E8, 0x55D3, 0x55E6, 0x55CE, 0x55DC, 0x55C7, 0x55D1, 	/* 0xB6D8 to 0xB6DF */
0x55E3, 0x55E4, 0x55EF, 0x55DA, 0x55E1, 0x55C5, 0x55C6, 0x55E5, 	/* 0xB6E0 to 0xB6E7 */
0x55C9, 0x5712, 0x5713, 0x585E, 0x5851, 0x5858, 0x5857, 0x585A, 	/* 0xB6E8 to 0xB6EF */
0x5854, 0x586B, 0x584C, 0x586D, 0x584A, 0x5862, 0x5852, 0x584B, 	/* 0xB6F0 to 0xB6F7 */
0x5967, 0x5AC1, 0x5AC9, 0x5ACC, 0x5ABE, 0x5ABD, 0x5ABC, 0x0000, 	/* 0xB6F8 to 0xB6FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB700 to 0xB707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB708 to 0xB70F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB710 to 0xB717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB718 to 0xB71F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB720 to 0xB727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB728 to 0xB72F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB730 to 0xB737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB738 to 0xB73F */
0x5AB3, 0x5AC2, 0x5AB2, 0x5D69, 0x5D6F, 0x5E4C, 0x5E79, 0x5EC9, 	/* 0xB740 to 0xB747 */
0x5EC8, 0x5F12, 0x5F59, 0x5FAC, 0x5FAE, 0x611A, 0x610F, 0x6148, 	/* 0xB748 to 0xB74F */
0x611F, 0x60F3, 0x611B, 0x60F9, 0x6101, 0x6108, 0x614E, 0x614C, 	/* 0xB750 to 0xB757 */
0x6144, 0x614D, 0x613E, 0x6134, 0x6127, 0x610D, 0x6106, 0x6137, 	/* 0xB758 to 0xB75F */
0x6221, 0x6222, 0x6413, 0x643E, 0x641E, 0x642A, 0x642D, 0x643D, 	/* 0xB760 to 0xB767 */
0x642C, 0x640F, 0x641C, 0x6414, 0x640D, 0x6436, 0x6416, 0x6417, 	/* 0xB768 to 0xB76F */
0x6406, 0x656C, 0x659F, 0x65B0, 0x6697, 0x6689, 0x6687, 0x6688, 	/* 0xB770 to 0xB777 */
0x6696, 0x6684, 0x6698, 0x668D, 0x6703, 0x6994, 0x696D, 0x0000, 	/* 0xB778 to 0xB77F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB780 to 0xB787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB788 to 0xB78F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB790 to 0xB797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB798 to 0xB79F */
0x0000, 0x695A, 0x6977, 0x6960, 0x6954, 0x6975, 0x6930, 0x6982, 	/* 0xB7A0 to 0xB7A7 */
0x694A, 0x6968, 0x696B, 0x695E, 0x6953, 0x6979, 0x6986, 0x695D, 	/* 0xB7A8 to 0xB7AF */
0x6963, 0x695B, 0x6B47, 0x6B72, 0x6BC0, 0x6BBF, 0x6BD3, 0x6BFD, 	/* 0xB7B0 to 0xB7B7 */
0x6EA2, 0x6EAF, 0x6ED3, 0x6EB6, 0x6EC2, 0x6E90, 0x6E9D, 0x6EC7, 	/* 0xB7B8 to 0xB7BF */
0x6EC5, 0x6EA5, 0x6E98, 0x6EBC, 0x6EBA, 0x6EAB, 0x6ED1, 0x6E96, 	/* 0xB7C0 to 0xB7C7 */
0x6E9C, 0x6EC4, 0x6ED4, 0x6EAA, 0x6EA7, 0x6EB4, 0x714E, 0x7159, 	/* 0xB7C8 to 0xB7CF */
0x7169, 0x7164, 0x7149, 0x7167, 0x715C, 0x716C, 0x7166, 0x714C, 	/* 0xB7D0 to 0xB7D7 */
0x7165, 0x715E, 0x7146, 0x7168, 0x7156, 0x723A, 0x7252, 0x7337, 	/* 0xB7D8 to 0xB7DF */
0x7345, 0x733F, 0x733E, 0x746F, 0x745A, 0x7455, 0x745F, 0x745E, 	/* 0xB7E0 to 0xB7E7 */
0x7441, 0x743F, 0x7459, 0x745B, 0x745C, 0x7576, 0x7578, 0x7600, 	/* 0xB7E8 to 0xB7EF */
0x75F0, 0x7601, 0x75F2, 0x75F1, 0x75FA, 0x75FF, 0x75F4, 0x75F3, 	/* 0xB7F0 to 0xB7F7 */
0x76DE, 0x76DF, 0x775B, 0x776B, 0x7766, 0x775E, 0x7763, 0x0000, 	/* 0xB7F8 to 0xB7FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB800 to 0xB807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB808 to 0xB80F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB810 to 0xB817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB818 to 0xB81F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB820 to 0xB827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB828 to 0xB82F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB830 to 0xB837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB838 to 0xB83F */
0x7779, 0x776A, 0x776C, 0x775C, 0x7765, 0x7768, 0x7762, 0x77EE, 	/* 0xB840 to 0xB847 */
0x788E, 0x78B0, 0x7897, 0x7898, 0x788C, 0x7889, 0x787C, 0x7891, 	/* 0xB848 to 0xB84F */
0x7893, 0x787F, 0x797A, 0x797F, 0x7981, 0x842C, 0x79BD, 0x7A1C, 	/* 0xB850 to 0xB857 */
0x7A1A, 0x7A20, 0x7A14, 0x7A1F, 0x7A1E, 0x7A9F, 0x7AA0, 0x7B77, 	/* 0xB858 to 0xB85F */
0x7BC0, 0x7B60, 0x7B6E, 0x7B67, 0x7CB1, 0x7CB3, 0x7CB5, 0x7D93, 	/* 0xB860 to 0xB867 */
0x7D79, 0x7D91, 0x7D81, 0x7D8F, 0x7D5B, 0x7F6E, 0x7F69, 0x7F6A, 	/* 0xB868 to 0xB86F */
0x7F72, 0x7FA9, 0x7FA8, 0x7FA4, 0x8056, 0x8058, 0x8086, 0x8084, 	/* 0xB870 to 0xB877 */
0x8171, 0x8170, 0x8178, 0x8165, 0x816E, 0x8173, 0x816B, 0x0000, 	/* 0xB878 to 0xB87F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB880 to 0xB887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB888 to 0xB88F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB890 to 0xB897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB898 to 0xB89F */
0x0000, 0x8179, 0x817A, 0x8166, 0x8205, 0x8247, 0x8482, 0x8477, 	/* 0xB8A0 to 0xB8A7 */
0x843D, 0x8431, 0x8475, 0x8466, 0x846B, 0x8449, 0x846C, 0x845B, 	/* 0xB8A8 to 0xB8AF */
0x843C, 0x8435, 0x8461, 0x8463, 0x8469, 0x846D, 0x8446, 0x865E, 	/* 0xB8B0 to 0xB8B7 */
0x865C, 0x865F, 0x86F9, 0x8713, 0x8708, 0x8707, 0x8700, 0x86FE, 	/* 0xB8B8 to 0xB8BF */
0x86FB, 0x8702, 0x8703, 0x8706, 0x870A, 0x8859, 0x88DF, 0x88D4, 	/* 0xB8C0 to 0xB8C7 */
0x88D9, 0x88DC, 0x88D8, 0x88DD, 0x88E1, 0x88CA, 0x88D5, 0x88D2, 	/* 0xB8C8 to 0xB8CF */
0x899C, 0x89E3, 0x8A6B, 0x8A72, 0x8A73, 0x8A66, 0x8A69, 0x8A70, 	/* 0xB8D0 to 0xB8D7 */
0x8A87, 0x8A7C, 0x8A63, 0x8AA0, 0x8A71, 0x8A85, 0x8A6D, 0x8A62, 	/* 0xB8D8 to 0xB8DF */
0x8A6E, 0x8A6C, 0x8A79, 0x8A7B, 0x8A3E, 0x8A68, 0x8C62, 0x8C8A, 	/* 0xB8E0 to 0xB8E7 */
0x8C89, 0x8CCA, 0x8CC7, 0x8CC8, 0x8CC4, 0x8CB2, 0x8CC3, 0x8CC2, 	/* 0xB8E8 to 0xB8EF */
0x8CC5, 0x8DE1, 0x8DDF, 0x8DE8, 0x8DEF, 0x8DF3, 0x8DFA, 0x8DEA, 	/* 0xB8F0 to 0xB8F7 */
0x8DE4, 0x8DE6, 0x8EB2, 0x8F03, 0x8F09, 0x8EFE, 0x8F0A, 0x0000, 	/* 0xB8F8 to 0xB8FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB900 to 0xB907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB908 to 0xB90F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB910 to 0xB917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB918 to 0xB91F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB920 to 0xB927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB928 to 0xB92F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB930 to 0xB937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB938 to 0xB93F */
0x8F9F, 0x8FB2, 0x904B, 0x904A, 0x9053, 0x9042, 0x9054, 0x903C, 	/* 0xB940 to 0xB947 */
0x9055, 0x9050, 0x9047, 0x904F, 0x904E, 0x904D, 0x9051, 0x903E, 	/* 0xB948 to 0xB94F */
0x9041, 0x9112, 0x9117, 0x916C, 0x916A, 0x9169, 0x91C9, 0x9237, 	/* 0xB950 to 0xB957 */
0x9257, 0x9238, 0x923D, 0x9240, 0x923E, 0x925B, 0x924B, 0x9264, 	/* 0xB958 to 0xB95F */
0x9251, 0x9234, 0x9249, 0x924D, 0x9245, 0x9239, 0x923F, 0x925A, 	/* 0xB960 to 0xB967 */
0x9598, 0x9698, 0x9694, 0x9695, 0x96CD, 0x96CB, 0x96C9, 0x96CA, 	/* 0xB968 to 0xB96F */
0x96F7, 0x96FB, 0x96F9, 0x96F6, 0x9756, 0x9774, 0x9776, 0x9810, 	/* 0xB970 to 0xB977 */
0x9811, 0x9813, 0x980A, 0x9812, 0x980C, 0x98FC, 0x98F4, 0x0000, 	/* 0xB978 to 0xB97F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB980 to 0xB987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB988 to 0xB98F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB990 to 0xB997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xB998 to 0xB99F */
0x0000, 0x98FD, 0x98FE, 0x99B3, 0x99B1, 0x99B4, 0x9AE1, 0x9CE9, 	/* 0xB9A0 to 0xB9A7 */
0x9E82, 0x9F0E, 0x9F13, 0x9F20, 0x50E7, 0x50EE, 0x50E5, 0x50D6, 	/* 0xB9A8 to 0xB9AF */
0x50ED, 0x50DA, 0x50D5, 0x50CF, 0x50D1, 0x50F1, 0x50CE, 0x50E9, 	/* 0xB9B0 to 0xB9B7 */
0x5162, 0x51F3, 0x5283, 0x5282, 0x5331, 0x53AD, 0x55FE, 0x5600, 	/* 0xB9B8 to 0xB9BF */
0x561B, 0x5617, 0x55FD, 0x5614, 0x5606, 0x5609, 0x560D, 0x560E, 	/* 0xB9C0 to 0xB9C7 */
0x55F7, 0x5616, 0x561F, 0x5608, 0x5610, 0x55F6, 0x5718, 0x5716, 	/* 0xB9C8 to 0xB9CF */
0x5875, 0x587E, 0x5883, 0x5893, 0x588A, 0x5879, 0x5885, 0x587D, 	/* 0xB9D0 to 0xB9D7 */
0x58FD, 0x5925, 0x5922, 0x5924, 0x596A, 0x5969, 0x5AE1, 0x5AE6, 	/* 0xB9D8 to 0xB9DF */
0x5AE9, 0x5AD7, 0x5AD6, 0x5AD8, 0x5AE3, 0x5B75, 0x5BDE, 0x5BE7, 	/* 0xB9E0 to 0xB9E7 */
0x5BE1, 0x5BE5, 0x5BE6, 0x5BE8, 0x5BE2, 0x5BE4, 0x5BDF, 0x5C0D, 	/* 0xB9E8 to 0xB9EF */
0x5C62, 0x5D84, 0x5D87, 0x5E5B, 0x5E63, 0x5E55, 0x5E57, 0x5E54, 	/* 0xB9F0 to 0xB9F7 */
0x5ED3, 0x5ED6, 0x5F0A, 0x5F46, 0x5F70, 0x5FB9, 0x6147, 0x0000, 	/* 0xB9F8 to 0xB9FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA00 to 0xBA07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA08 to 0xBA0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA10 to 0xBA17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA18 to 0xBA1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA20 to 0xBA27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA28 to 0xBA2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA30 to 0xBA37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA38 to 0xBA3F */
0x613F, 0x614B, 0x6177, 0x6162, 0x6163, 0x615F, 0x615A, 0x6158, 	/* 0xBA40 to 0xBA47 */
0x6175, 0x622A, 0x6487, 0x6458, 0x6454, 0x64A4, 0x6478, 0x645F, 	/* 0xBA48 to 0xBA4F */
0x647A, 0x6451, 0x6467, 0x6434, 0x646D, 0x647B, 0x6572, 0x65A1, 	/* 0xBA50 to 0xBA57 */
0x65D7, 0x65D6, 0x66A2, 0x66A8, 0x669D, 0x699C, 0x69A8, 0x6995, 	/* 0xBA58 to 0xBA5F */
0x69C1, 0x69AE, 0x69D3, 0x69CB, 0x699B, 0x69B7, 0x69BB, 0x69AB, 	/* 0xBA60 to 0xBA67 */
0x69B4, 0x69D0, 0x69CD, 0x69AD, 0x69CC, 0x69A6, 0x69C3, 0x69A3, 	/* 0xBA68 to 0xBA6F */
0x6B49, 0x6B4C, 0x6C33, 0x6F33, 0x6F14, 0x6EFE, 0x6F13, 0x6EF4, 	/* 0xBA70 to 0xBA77 */
0x6F29, 0x6F3E, 0x6F20, 0x6F2C, 0x6F0F, 0x6F02, 0x6F22, 0x0000, 	/* 0xBA78 to 0xBA7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA80 to 0xBA87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA88 to 0xBA8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA90 to 0xBA97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBA98 to 0xBA9F */
0x0000, 0x6EFF, 0x6EEF, 0x6F06, 0x6F31, 0x6F38, 0x6F32, 0x6F23, 	/* 0xBAA0 to 0xBAA7 */
0x6F15, 0x6F2B, 0x6F2F, 0x6F88, 0x6F2A, 0x6EEC, 0x6F01, 0x6EF2, 	/* 0xBAA8 to 0xBAAF */
0x6ECC, 0x6EF7, 0x7194, 0x7199, 0x717D, 0x718A, 0x7184, 0x7192, 	/* 0xBAB0 to 0xBAB7 */
0x723E, 0x7292, 0x7296, 0x7344, 0x7350, 0x7464, 0x7463, 0x746A, 	/* 0xBAB8 to 0xBABF */
0x7470, 0x746D, 0x7504, 0x7591, 0x7627, 0x760D, 0x760B, 0x7609, 	/* 0xBAC0 to 0xBAC7 */
0x7613, 0x76E1, 0x76E3, 0x7784, 0x777D, 0x777F, 0x7761, 0x78C1, 	/* 0xBAC8 to 0xBACF */
0x789F, 0x78A7, 0x78B3, 0x78A9, 0x78A3, 0x798E, 0x798F, 0x798D, 	/* 0xBAD0 to 0xBAD7 */
0x7A2E, 0x7A31, 0x7AAA, 0x7AA9, 0x7AED, 0x7AEF, 0x7BA1, 0x7B95, 	/* 0xBAD8 to 0xBADF */
0x7B8B, 0x7B75, 0x7B97, 0x7B9D, 0x7B94, 0x7B8F, 0x7BB8, 0x7B87, 	/* 0xBAE0 to 0xBAE7 */
0x7B84, 0x7CB9, 0x7CBD, 0x7CBE, 0x7DBB, 0x7DB0, 0x7D9C, 0x7DBD, 	/* 0xBAE8 to 0xBAEF */
0x7DBE, 0x7DA0, 0x7DCA, 0x7DB4, 0x7DB2, 0x7DB1, 0x7DBA, 0x7DA2, 	/* 0xBAF0 to 0xBAF7 */
0x7DBF, 0x7DB5, 0x7DB8, 0x7DAD, 0x7DD2, 0x7DC7, 0x7DAC, 0x0000, 	/* 0xBAF8 to 0xBAFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB00 to 0xBB07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB08 to 0xBB0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB10 to 0xBB17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB18 to 0xBB1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB20 to 0xBB27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB28 to 0xBB2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB30 to 0xBB37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB38 to 0xBB3F */
0x7F70, 0x7FE0, 0x7FE1, 0x7FDF, 0x805E, 0x805A, 0x8087, 0x8150, 	/* 0xBB40 to 0xBB47 */
0x8180, 0x818F, 0x8188, 0x818A, 0x817F, 0x8182, 0x81E7, 0x81FA, 	/* 0xBB48 to 0xBB4F */
0x8207, 0x8214, 0x821E, 0x824B, 0x84C9, 0x84BF, 0x84C6, 0x84C4, 	/* 0xBB50 to 0xBB57 */
0x8499, 0x849E, 0x84B2, 0x849C, 0x84CB, 0x84B8, 0x84C0, 0x84D3, 	/* 0xBB58 to 0xBB5F */
0x8490, 0x84BC, 0x84D1, 0x84CA, 0x873F, 0x871C, 0x873B, 0x8722, 	/* 0xBB60 to 0xBB67 */
0x8725, 0x8734, 0x8718, 0x8755, 0x8737, 0x8729, 0x88F3, 0x8902, 	/* 0xBB68 to 0xBB6F */
0x88F4, 0x88F9, 0x88F8, 0x88FD, 0x88E8, 0x891A, 0x88EF, 0x8AA6, 	/* 0xBB70 to 0xBB77 */
0x8A8C, 0x8A9E, 0x8AA3, 0x8A8D, 0x8AA1, 0x8A93, 0x8AA4, 0x0000, 	/* 0xBB78 to 0xBB7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB80 to 0xBB87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB88 to 0xBB8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB90 to 0xBB97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBB98 to 0xBB9F */
0x0000, 0x8AAA, 0x8AA5, 0x8AA8, 0x8A98, 0x8A91, 0x8A9A, 0x8AA7, 	/* 0xBBA0 to 0xBBA7 */
0x8C6A, 0x8C8D, 0x8C8C, 0x8CD3, 0x8CD1, 0x8CD2, 0x8D6B, 0x8D99, 	/* 0xBBA8 to 0xBBAF */
0x8D95, 0x8DFC, 0x8F14, 0x8F12, 0x8F15, 0x8F13, 0x8FA3, 0x9060, 	/* 0xBBB0 to 0xBBB7 */
0x9058, 0x905C, 0x9063, 0x9059, 0x905E, 0x9062, 0x905D, 0x905B, 	/* 0xBBB8 to 0xBBBF */
0x9119, 0x9118, 0x911E, 0x9175, 0x9178, 0x9177, 0x9174, 0x9278, 	/* 0xBBC0 to 0xBBC7 */
0x9280, 0x9285, 0x9298, 0x9296, 0x927B, 0x9293, 0x929C, 0x92A8, 	/* 0xBBC8 to 0xBBCF */
0x927C, 0x9291, 0x95A1, 0x95A8, 0x95A9, 0x95A3, 0x95A5, 0x95A4, 	/* 0xBBD0 to 0xBBD7 */
0x9699, 0x969C, 0x969B, 0x96CC, 0x96D2, 0x9700, 0x977C, 0x9785, 	/* 0xBBD8 to 0xBBDF */
0x97F6, 0x9817, 0x9818, 0x98AF, 0x98B1, 0x9903, 0x9905, 0x990C, 	/* 0xBBE0 to 0xBBE7 */
0x9909, 0x99C1, 0x9AAF, 0x9AB0, 0x9AE6, 0x9B41, 0x9B42, 0x9CF4, 	/* 0xBBE8 to 0xBBEF */
0x9CF6, 0x9CF3, 0x9EBC, 0x9F3B, 0x9F4A, 0x5104, 0x5100, 0x50FB, 	/* 0xBBF0 to 0xBBF7 */
0x50F5, 0x50F9, 0x5102, 0x5108, 0x5109, 0x5105, 0x51DC, 0x0000, 	/* 0xBBF8 to 0xBBFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC00 to 0xBC07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC08 to 0xBC0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC10 to 0xBC17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC18 to 0xBC1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC20 to 0xBC27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC28 to 0xBC2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC30 to 0xBC37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC38 to 0xBC3F */
0x5287, 0x5288, 0x5289, 0x528D, 0x528A, 0x52F0, 0x53B2, 0x562E, 	/* 0xBC40 to 0xBC47 */
0x563B, 0x5639, 0x5632, 0x563F, 0x5634, 0x5629, 0x5653, 0x564E, 	/* 0xBC48 to 0xBC4F */
0x5657, 0x5674, 0x5636, 0x562F, 0x5630, 0x5880, 0x589F, 0x589E, 	/* 0xBC50 to 0xBC57 */
0x58B3, 0x589C, 0x58AE, 0x58A9, 0x58A6, 0x596D, 0x5B09, 0x5AFB, 	/* 0xBC58 to 0xBC5F */
0x5B0B, 0x5AF5, 0x5B0C, 0x5B08, 0x5BEE, 0x5BEC, 0x5BE9, 0x5BEB, 	/* 0xBC60 to 0xBC67 */
0x5C64, 0x5C65, 0x5D9D, 0x5D94, 0x5E62, 0x5E5F, 0x5E61, 0x5EE2, 	/* 0xBC68 to 0xBC6F */
0x5EDA, 0x5EDF, 0x5EDD, 0x5EE3, 0x5EE0, 0x5F48, 0x5F71, 0x5FB7, 	/* 0xBC70 to 0xBC77 */
0x5FB5, 0x6176, 0x6167, 0x616E, 0x615D, 0x6155, 0x6182, 0x0000, 	/* 0xBC78 to 0xBC7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC80 to 0xBC87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC88 to 0xBC8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC90 to 0xBC97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBC98 to 0xBC9F */
0x0000, 0x617C, 0x6170, 0x616B, 0x617E, 0x61A7, 0x6190, 0x61AB, 	/* 0xBCA0 to 0xBCA7 */
0x618E, 0x61AC, 0x619A, 0x61A4, 0x6194, 0x61AE, 0x622E, 0x6469, 	/* 0xBCA8 to 0xBCAF */
0x646F, 0x6479, 0x649E, 0x64B2, 0x6488, 0x6490, 0x64B0, 0x64A5, 	/* 0xBCB0 to 0xBCB7 */
0x6493, 0x6495, 0x64A9, 0x6492, 0x64AE, 0x64AD, 0x64AB, 0x649A, 	/* 0xBCB8 to 0xBCBF */
0x64AC, 0x6499, 0x64A2, 0x64B3, 0x6575, 0x6577, 0x6578, 0x66AE, 	/* 0xBCC0 to 0xBCC7 */
0x66AB, 0x66B4, 0x66B1, 0x6A23, 0x6A1F, 0x69E8, 0x6A01, 0x6A1E, 	/* 0xBCC8 to 0xBCCF */
0x6A19, 0x69FD, 0x6A21, 0x6A13, 0x6A0A, 0x69F3, 0x6A02, 0x6A05, 	/* 0xBCD0 to 0xBCD7 */
0x69ED, 0x6A11, 0x6B50, 0x6B4E, 0x6BA4, 0x6BC5, 0x6BC6, 0x6F3F, 	/* 0xBCD8 to 0xBCDF */
0x6F7C, 0x6F84, 0x6F51, 0x6F66, 0x6F54, 0x6F86, 0x6F6D, 0x6F5B, 	/* 0xBCE0 to 0xBCE7 */
0x6F78, 0x6F6E, 0x6F8E, 0x6F7A, 0x6F70, 0x6F64, 0x6F97, 0x6F58, 	/* 0xBCE8 to 0xBCEF */
0x6ED5, 0x6F6F, 0x6F60, 0x6F5F, 0x719F, 0x71AC, 0x71B1, 0x71A8, 	/* 0xBCF0 to 0xBCF7 */
0x7256, 0x729B, 0x734E, 0x7357, 0x7469, 0x748B, 0x7483, 0x0000, 	/* 0xBCF8 to 0xBCFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD00 to 0xBD07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD08 to 0xBD0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD10 to 0xBD17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD18 to 0xBD1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD20 to 0xBD27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD28 to 0xBD2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD30 to 0xBD37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD38 to 0xBD3F */
0x747E, 0x7480, 0x757F, 0x7620, 0x7629, 0x761F, 0x7624, 0x7626, 	/* 0xBD40 to 0xBD47 */
0x7621, 0x7622, 0x769A, 0x76BA, 0x76E4, 0x778E, 0x7787, 0x778C, 	/* 0xBD48 to 0xBD4F */
0x7791, 0x778B, 0x78CB, 0x78C5, 0x78BA, 0x78CA, 0x78BE, 0x78D5, 	/* 0xBD50 to 0xBD57 */
0x78BC, 0x78D0, 0x7A3F, 0x7A3C, 0x7A40, 0x7A3D, 0x7A37, 0x7A3B, 	/* 0xBD58 to 0xBD5F */
0x7AAF, 0x7AAE, 0x7BAD, 0x7BB1, 0x7BC4, 0x7BB4, 0x7BC6, 0x7BC7, 	/* 0xBD60 to 0xBD67 */
0x7BC1, 0x7BA0, 0x7BCC, 0x7CCA, 0x7DE0, 0x7DF4, 0x7DEF, 0x7DFB, 	/* 0xBD68 to 0xBD6F */
0x7DD8, 0x7DEC, 0x7DDD, 0x7DE8, 0x7DE3, 0x7DDA, 0x7DDE, 0x7DE9, 	/* 0xBD70 to 0xBD77 */
0x7D9E, 0x7DD9, 0x7DF2, 0x7DF9, 0x7F75, 0x7F77, 0x7FAF, 0x0000, 	/* 0xBD78 to 0xBD7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD80 to 0xBD87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD88 to 0xBD8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD90 to 0xBD97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBD98 to 0xBD9F */
0x0000, 0x7FE9, 0x8026, 0x819B, 0x819C, 0x819D, 0x81A0, 0x819A, 	/* 0xBDA0 to 0xBDA7 */
0x8198, 0x8517, 0x853D, 0x851A, 0x84EE, 0x852C, 0x852D, 0x8513, 	/* 0xBDA8 to 0xBDAF */
0x8511, 0x8523, 0x8521, 0x8514, 0x84EC, 0x8525, 0x84FF, 0x8506, 	/* 0xBDB0 to 0xBDB7 */
0x8782, 0x8774, 0x8776, 0x8760, 0x8766, 0x8778, 0x8768, 0x8759, 	/* 0xBDB8 to 0xBDBF */
0x8757, 0x874C, 0x8753, 0x885B, 0x885D, 0x8910, 0x8907, 0x8912, 	/* 0xBDC0 to 0xBDC7 */
0x8913, 0x8915, 0x890A, 0x8ABC, 0x8AD2, 0x8AC7, 0x8AC4, 0x8A95, 	/* 0xBDC8 to 0xBDCF */
0x8ACB, 0x8AF8, 0x8AB2, 0x8AC9, 0x8AC2, 0x8ABF, 0x8AB0, 0x8AD6, 	/* 0xBDD0 to 0xBDD7 */
0x8ACD, 0x8AB6, 0x8AB9, 0x8ADB, 0x8C4C, 0x8C4E, 0x8C6C, 0x8CE0, 	/* 0xBDD8 to 0xBDDF */
0x8CDE, 0x8CE6, 0x8CE4, 0x8CEC, 0x8CED, 0x8CE2, 0x8CE3, 0x8CDC, 	/* 0xBDE0 to 0xBDE7 */
0x8CEA, 0x8CE1, 0x8D6D, 0x8D9F, 0x8DA3, 0x8E2B, 0x8E10, 0x8E1D, 	/* 0xBDE8 to 0xBDEF */
0x8E22, 0x8E0F, 0x8E29, 0x8E1F, 0x8E21, 0x8E1E, 0x8EBA, 0x8F1D, 	/* 0xBDF0 to 0xBDF7 */
0x8F1B, 0x8F1F, 0x8F29, 0x8F26, 0x8F2A, 0x8F1C, 0x8F1E, 0x0000, 	/* 0xBDF8 to 0xBDFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE00 to 0xBE07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE08 to 0xBE0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE10 to 0xBE17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE18 to 0xBE1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE20 to 0xBE27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE28 to 0xBE2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE30 to 0xBE37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE38 to 0xBE3F */
0x8F25, 0x9069, 0x906E, 0x9068, 0x906D, 0x9077, 0x9130, 0x912D, 	/* 0xBE40 to 0xBE47 */
0x9127, 0x9131, 0x9187, 0x9189, 0x918B, 0x9183, 0x92C5, 0x92BB, 	/* 0xBE48 to 0xBE4F */
0x92B7, 0x92EA, 0x92AC, 0x92E4, 0x92C1, 0x92B3, 0x92BC, 0x92D2, 	/* 0xBE50 to 0xBE57 */
0x92C7, 0x92F0, 0x92B2, 0x95AD, 0x95B1, 0x9704, 0x9706, 0x9707, 	/* 0xBE58 to 0xBE5F */
0x9709, 0x9760, 0x978D, 0x978B, 0x978F, 0x9821, 0x982B, 0x981C, 	/* 0xBE60 to 0xBE67 */
0x98B3, 0x990A, 0x9913, 0x9912, 0x9918, 0x99DD, 0x99D0, 0x99DF, 	/* 0xBE68 to 0xBE6F */
0x99DB, 0x99D1, 0x99D5, 0x99D2, 0x99D9, 0x9AB7, 0x9AEE, 0x9AEF, 	/* 0xBE70 to 0xBE77 */
0x9B27, 0x9B45, 0x9B44, 0x9B77, 0x9B6F, 0x9D06, 0x9D09, 0x0000, 	/* 0xBE78 to 0xBE7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE80 to 0xBE87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE88 to 0xBE8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE90 to 0xBE97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBE98 to 0xBE9F */
0x0000, 0x9D03, 0x9EA9, 0x9EBE, 0x9ECE, 0x58A8, 0x9F52, 0x5112, 	/* 0xBEA0 to 0xBEA7 */
0x5118, 0x5114, 0x5110, 0x5115, 0x5180, 0x51AA, 0x51DD, 0x5291, 	/* 0xBEA8 to 0xBEAF */
0x5293, 0x52F3, 0x5659, 0x566B, 0x5679, 0x5669, 0x5664, 0x5678, 	/* 0xBEB0 to 0xBEB7 */
0x566A, 0x5668, 0x5665, 0x5671, 0x566F, 0x566C, 0x5662, 0x5676, 	/* 0xBEB8 to 0xBEBF */
0x58C1, 0x58BE, 0x58C7, 0x58C5, 0x596E, 0x5B1D, 0x5B34, 0x5B78, 	/* 0xBEC0 to 0xBEC7 */
0x5BF0, 0x5C0E, 0x5F4A, 0x61B2, 0x6191, 0x61A9, 0x618A, 0x61CD, 	/* 0xBEC8 to 0xBECF */
0x61B6, 0x61BE, 0x61CA, 0x61C8, 0x6230, 0x64C5, 0x64C1, 0x64CB, 	/* 0xBED0 to 0xBED7 */
0x64BB, 0x64BC, 0x64DA, 0x64C4, 0x64C7, 0x64C2, 0x64CD, 0x64BF, 	/* 0xBED8 to 0xBEDF */
0x64D2, 0x64D4, 0x64BE, 0x6574, 0x66C6, 0x66C9, 0x66B9, 0x66C4, 	/* 0xBEE0 to 0xBEE7 */
0x66C7, 0x66B8, 0x6A3D, 0x6A38, 0x6A3A, 0x6A59, 0x6A6B, 0x6A58, 	/* 0xBEE8 to 0xBEEF */
0x6A39, 0x6A44, 0x6A62, 0x6A61, 0x6A4B, 0x6A47, 0x6A35, 0x6A5F, 	/* 0xBEF0 to 0xBEF7 */
0x6A48, 0x6B59, 0x6B77, 0x6C05, 0x6FC2, 0x6FB1, 0x6FA1, 0x0000, 	/* 0xBEF8 to 0xBEFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF00 to 0xBF07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF08 to 0xBF0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF10 to 0xBF17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF18 to 0xBF1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF20 to 0xBF27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF28 to 0xBF2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF30 to 0xBF37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF38 to 0xBF3F */
0x6FC3, 0x6FA4, 0x6FC1, 0x6FA7, 0x6FB3, 0x6FC0, 0x6FB9, 0x6FB6, 	/* 0xBF40 to 0xBF47 */
0x6FA6, 0x6FA0, 0x6FB4, 0x71BE, 0x71C9, 0x71D0, 0x71D2, 0x71C8, 	/* 0xBF48 to 0xBF4F */
0x71D5, 0x71B9, 0x71CE, 0x71D9, 0x71DC, 0x71C3, 0x71C4, 0x7368, 	/* 0xBF50 to 0xBF57 */
0x749C, 0x74A3, 0x7498, 0x749F, 0x749E, 0x74E2, 0x750C, 0x750D, 	/* 0xBF58 to 0xBF5F */
0x7634, 0x7638, 0x763A, 0x76E7, 0x76E5, 0x77A0, 0x779E, 0x779F, 	/* 0xBF60 to 0xBF67 */
0x77A5, 0x78E8, 0x78DA, 0x78EC, 0x78E7, 0x79A6, 0x7A4D, 0x7A4E, 	/* 0xBF68 to 0xBF6F */
0x7A46, 0x7A4C, 0x7A4B, 0x7ABA, 0x7BD9, 0x7C11, 0x7BC9, 0x7BE4, 	/* 0xBF70 to 0xBF77 */
0x7BDB, 0x7BE1, 0x7BE9, 0x7BE6, 0x7CD5, 0x7CD6, 0x7E0A, 0x0000, 	/* 0xBF78 to 0xBF7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF80 to 0xBF87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF88 to 0xBF8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF90 to 0xBF97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xBF98 to 0xBF9F */
0x0000, 0x7E11, 0x7E08, 0x7E1B, 0x7E23, 0x7E1E, 0x7E1D, 0x7E09, 	/* 0xBFA0 to 0xBFA7 */
0x7E10, 0x7F79, 0x7FB2, 0x7FF0, 0x7FF1, 0x7FEE, 0x8028, 0x81B3, 	/* 0xBFA8 to 0xBFAF */
0x81A9, 0x81A8, 0x81FB, 0x8208, 0x8258, 0x8259, 0x854A, 0x8559, 	/* 0xBFB0 to 0xBFB7 */
0x8548, 0x8568, 0x8569, 0x8543, 0x8549, 0x856D, 0x856A, 0x855E, 	/* 0xBFB8 to 0xBFBF */
0x8783, 0x879F, 0x879E, 0x87A2, 0x878D, 0x8861, 0x892A, 0x8932, 	/* 0xBFC0 to 0xBFC7 */
0x8925, 0x892B, 0x8921, 0x89AA, 0x89A6, 0x8AE6, 0x8AFA, 0x8AEB, 	/* 0xBFC8 to 0xBFCF */
0x8AF1, 0x8B00, 0x8ADC, 0x8AE7, 0x8AEE, 0x8AFE, 0x8B01, 0x8B02, 	/* 0xBFD0 to 0xBFD7 */
0x8AF7, 0x8AED, 0x8AF3, 0x8AF6, 0x8AFC, 0x8C6B, 0x8C6D, 0x8C93, 	/* 0xBFD8 to 0xBFDF */
0x8CF4, 0x8E44, 0x8E31, 0x8E34, 0x8E42, 0x8E39, 0x8E35, 0x8F3B, 	/* 0xBFE0 to 0xBFE7 */
0x8F2F, 0x8F38, 0x8F33, 0x8FA8, 0x8FA6, 0x9075, 0x9074, 0x9078, 	/* 0xBFE8 to 0xBFEF */
0x9072, 0x907C, 0x907A, 0x9134, 0x9192, 0x9320, 0x9336, 0x92F8, 	/* 0xBFF0 to 0xBFF7 */
0x9333, 0x932F, 0x9322, 0x92FC, 0x932B, 0x9304, 0x931A, 0x0000, 	/* 0xBFF8 to 0xBFFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC000 to 0xC007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC008 to 0xC00F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC010 to 0xC017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC018 to 0xC01F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC020 to 0xC027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC028 to 0xC02F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC030 to 0xC037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC038 to 0xC03F */
0x9310, 0x9326, 0x9321, 0x9315, 0x932E, 0x9319, 0x95BB, 0x96A7, 	/* 0xC040 to 0xC047 */
0x96A8, 0x96AA, 0x96D5, 0x970E, 0x9711, 0x9716, 0x970D, 0x9713, 	/* 0xC048 to 0xC04F */
0x970F, 0x975B, 0x975C, 0x9766, 0x9798, 0x9830, 0x9838, 0x983B, 	/* 0xC050 to 0xC057 */
0x9837, 0x982D, 0x9839, 0x9824, 0x9910, 0x9928, 0x991E, 0x991B, 	/* 0xC058 to 0xC05F */
0x9921, 0x991A, 0x99ED, 0x99E2, 0x99F1, 0x9AB8, 0x9ABC, 0x9AFB, 	/* 0xC060 to 0xC067 */
0x9AED, 0x9B28, 0x9B91, 0x9D15, 0x9D23, 0x9D26, 0x9D28, 0x9D12, 	/* 0xC068 to 0xC06F */
0x9D1B, 0x9ED8, 0x9ED4, 0x9F8D, 0x9F9C, 0x512A, 0x511F, 0x5121, 	/* 0xC070 to 0xC077 */
0x5132, 0x52F5, 0x568E, 0x5680, 0x5690, 0x5685, 0x5687, 0x0000, 	/* 0xC078 to 0xC07F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC080 to 0xC087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC088 to 0xC08F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC090 to 0xC097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC098 to 0xC09F */
0x0000, 0x568F, 0x58D5, 0x58D3, 0x58D1, 0x58CE, 0x5B30, 0x5B2A, 	/* 0xC0A0 to 0xC0A7 */
0x5B24, 0x5B7A, 0x5C37, 0x5C68, 0x5DBC, 0x5DBA, 0x5DBD, 0x5DB8, 	/* 0xC0A8 to 0xC0AF */
0x5E6B, 0x5F4C, 0x5FBD, 0x61C9, 0x61C2, 0x61C7, 0x61E6, 0x61CB, 	/* 0xC0B0 to 0xC0B7 */
0x6232, 0x6234, 0x64CE, 0x64CA, 0x64D8, 0x64E0, 0x64F0, 0x64E6, 	/* 0xC0B8 to 0xC0BF */
0x64EC, 0x64F1, 0x64E2, 0x64ED, 0x6582, 0x6583, 0x66D9, 0x66D6, 	/* 0xC0C0 to 0xC0C7 */
0x6A80, 0x6A94, 0x6A84, 0x6AA2, 0x6A9C, 0x6ADB, 0x6AA3, 0x6A7E, 	/* 0xC0C8 to 0xC0CF */
0x6A97, 0x6A90, 0x6AA0, 0x6B5C, 0x6BAE, 0x6BDA, 0x6C08, 0x6FD8, 	/* 0xC0D0 to 0xC0D7 */
0x6FF1, 0x6FDF, 0x6FE0, 0x6FDB, 0x6FE4, 0x6FEB, 0x6FEF, 0x6F80, 	/* 0xC0D8 to 0xC0DF */
0x6FEC, 0x6FE1, 0x6FE9, 0x6FD5, 0x6FEE, 0x6FF0, 0x71E7, 0x71DF, 	/* 0xC0E0 to 0xC0E7 */
0x71EE, 0x71E6, 0x71E5, 0x71ED, 0x71EC, 0x71F4, 0x71E0, 0x7235, 	/* 0xC0E8 to 0xC0EF */
0x7246, 0x7370, 0x7372, 0x74A9, 0x74B0, 0x74A6, 0x74A8, 0x7646, 	/* 0xC0F0 to 0xC0F7 */
0x7642, 0x764C, 0x76EA, 0x77B3, 0x77AA, 0x77B0, 0x77AC, 0x0000, 	/* 0xC0F8 to 0xC0FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC100 to 0xC107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC108 to 0xC10F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC110 to 0xC117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC118 to 0xC11F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC120 to 0xC127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC128 to 0xC12F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC130 to 0xC137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC138 to 0xC13F */
0x77A7, 0x77AD, 0x77EF, 0x78F7, 0x78FA, 0x78F4, 0x78EF, 0x7901, 	/* 0xC140 to 0xC147 */
0x79A7, 0x79AA, 0x7A57, 0x7ABF, 0x7C07, 0x7C0D, 0x7BFE, 0x7BF7, 	/* 0xC148 to 0xC14F */
0x7C0C, 0x7BE0, 0x7CE0, 0x7CDC, 0x7CDE, 0x7CE2, 0x7CDF, 0x7CD9, 	/* 0xC150 to 0xC157 */
0x7CDD, 0x7E2E, 0x7E3E, 0x7E46, 0x7E37, 0x7E32, 0x7E43, 0x7E2B, 	/* 0xC158 to 0xC15F */
0x7E3D, 0x7E31, 0x7E45, 0x7E41, 0x7E34, 0x7E39, 0x7E48, 0x7E35, 	/* 0xC160 to 0xC167 */
0x7E3F, 0x7E2F, 0x7F44, 0x7FF3, 0x7FFC, 0x8071, 0x8072, 0x8070, 	/* 0xC168 to 0xC16F */
0x806F, 0x8073, 0x81C6, 0x81C3, 0x81BA, 0x81C2, 0x81C0, 0x81BF, 	/* 0xC170 to 0xC177 */
0x81BD, 0x81C9, 0x81BE, 0x81E8, 0x8209, 0x8271, 0x85AA, 0x0000, 	/* 0xC178 to 0xC17F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC180 to 0xC187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC188 to 0xC18F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC190 to 0xC197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC198 to 0xC19F */
0x0000, 0x8584, 0x857E, 0x859C, 0x8591, 0x8594, 0x85AF, 0x859B, 	/* 0xC1A0 to 0xC1A7 */
0x8587, 0x85A8, 0x858A, 0x8667, 0x87C0, 0x87D1, 0x87B3, 0x87D2, 	/* 0xC1A8 to 0xC1AF */
0x87C6, 0x87AB, 0x87BB, 0x87BA, 0x87C8, 0x87CB, 0x893B, 0x8936, 	/* 0xC1B0 to 0xC1B7 */
0x8944, 0x8938, 0x893D, 0x89AC, 0x8B0E, 0x8B17, 0x8B19, 0x8B1B, 	/* 0xC1B8 to 0xC1BF */
0x8B0A, 0x8B20, 0x8B1D, 0x8B04, 0x8B10, 0x8C41, 0x8C3F, 0x8C73, 	/* 0xC1C0 to 0xC1C7 */
0x8CFA, 0x8CFD, 0x8CFC, 0x8CF8, 0x8CFB, 0x8DA8, 0x8E49, 0x8E4B, 	/* 0xC1C8 to 0xC1CF */
0x8E48, 0x8E4A, 0x8F44, 0x8F3E, 0x8F42, 0x8F45, 0x8F3F, 0x907F, 	/* 0xC1D0 to 0xC1D7 */
0x907D, 0x9084, 0x9081, 0x9082, 0x9080, 0x9139, 0x91A3, 0x919E, 	/* 0xC1D8 to 0xC1DF */
0x919C, 0x934D, 0x9382, 0x9328, 0x9375, 0x934A, 0x9365, 0x934B, 	/* 0xC1E0 to 0xC1E7 */
0x9318, 0x937E, 0x936C, 0x935B, 0x9370, 0x935A, 0x9354, 0x95CA, 	/* 0xC1E8 to 0xC1EF */
0x95CB, 0x95CC, 0x95C8, 0x95C6, 0x96B1, 0x96B8, 0x96D6, 0x971C, 	/* 0xC1F0 to 0xC1F7 */
0x971E, 0x97A0, 0x97D3, 0x9846, 0x98B6, 0x9935, 0x9A01, 0x0000, 	/* 0xC1F8 to 0xC1FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC200 to 0xC207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC208 to 0xC20F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC210 to 0xC217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC218 to 0xC21F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC220 to 0xC227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC228 to 0xC22F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC230 to 0xC237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC238 to 0xC23F */
0x99FF, 0x9BAE, 0x9BAB, 0x9BAA, 0x9BAD, 0x9D3B, 0x9D3F, 0x9E8B, 	/* 0xC240 to 0xC247 */
0x9ECF, 0x9EDE, 0x9EDC, 0x9EDD, 0x9EDB, 0x9F3E, 0x9F4B, 0x53E2, 	/* 0xC248 to 0xC24F */
0x5695, 0x56AE, 0x58D9, 0x58D8, 0x5B38, 0x5F5D, 0x61E3, 0x6233, 	/* 0xC250 to 0xC257 */
0x64F4, 0x64F2, 0x64FE, 0x6506, 0x64FA, 0x64FB, 0x64F7, 0x65B7, 	/* 0xC258 to 0xC25F */
0x66DC, 0x6726, 0x6AB3, 0x6AAC, 0x6AC3, 0x6ABB, 0x6AB8, 0x6AC2, 	/* 0xC260 to 0xC267 */
0x6AAE, 0x6AAF, 0x6B5F, 0x6B78, 0x6BAF, 0x7009, 0x700B, 0x6FFE, 	/* 0xC268 to 0xC26F */
0x7006, 0x6FFA, 0x7011, 0x700F, 0x71FB, 0x71FC, 0x71FE, 0x71F8, 	/* 0xC270 to 0xC277 */
0x7377, 0x7375, 0x74A7, 0x74BF, 0x7515, 0x7656, 0x7658, 0x0000, 	/* 0xC278 to 0xC27F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC280 to 0xC287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC288 to 0xC28F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC290 to 0xC297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC298 to 0xC29F */
0x0000, 0x7652, 0x77BD, 0x77BF, 0x77BB, 0x77BC, 0x790E, 0x79AE, 	/* 0xC2A0 to 0xC2A7 */
0x7A61, 0x7A62, 0x7A60, 0x7AC4, 0x7AC5, 0x7C2B, 0x7C27, 0x7C2A, 	/* 0xC2A8 to 0xC2AF */
0x7C1E, 0x7C23, 0x7C21, 0x7CE7, 0x7E54, 0x7E55, 0x7E5E, 0x7E5A, 	/* 0xC2B0 to 0xC2B7 */
0x7E61, 0x7E52, 0x7E59, 0x7F48, 0x7FF9, 0x7FFB, 0x8077, 0x8076, 	/* 0xC2B8 to 0xC2BF */
0x81CD, 0x81CF, 0x820A, 0x85CF, 0x85A9, 0x85CD, 0x85D0, 0x85C9, 	/* 0xC2C0 to 0xC2C7 */
0x85B0, 0x85BA, 0x85B9, 0x85A6, 0x87EF, 0x87EC, 0x87F2, 0x87E0, 	/* 0xC2C8 to 0xC2CF */
0x8986, 0x89B2, 0x89F4, 0x8B28, 0x8B39, 0x8B2C, 0x8B2B, 0x8C50, 	/* 0xC2D0 to 0xC2D7 */
0x8D05, 0x8E59, 0x8E63, 0x8E66, 0x8E64, 0x8E5F, 0x8E55, 0x8EC0, 	/* 0xC2D8 to 0xC2DF */
0x8F49, 0x8F4D, 0x9087, 0x9083, 0x9088, 0x91AB, 0x91AC, 0x91D0, 	/* 0xC2E0 to 0xC2E7 */
0x9394, 0x938A, 0x9396, 0x93A2, 0x93B3, 0x93AE, 0x93AC, 0x93B0, 	/* 0xC2E8 to 0xC2EF */
0x9398, 0x939A, 0x9397, 0x95D4, 0x95D6, 0x95D0, 0x95D5, 0x96E2, 	/* 0xC2F0 to 0xC2F7 */
0x96DC, 0x96D9, 0x96DB, 0x96DE, 0x9724, 0x97A3, 0x97A6, 0x0000, 	/* 0xC2F8 to 0xC2FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC300 to 0xC307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC308 to 0xC30F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC310 to 0xC317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC318 to 0xC31F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC320 to 0xC327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC328 to 0xC32F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC330 to 0xC337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC338 to 0xC33F */
0x97AD, 0x97F9, 0x984D, 0x984F, 0x984C, 0x984E, 0x9853, 0x98BA, 	/* 0xC340 to 0xC347 */
0x993E, 0x993F, 0x993D, 0x992E, 0x99A5, 0x9A0E, 0x9AC1, 0x9B03, 	/* 0xC348 to 0xC34F */
0x9B06, 0x9B4F, 0x9B4E, 0x9B4D, 0x9BCA, 0x9BC9, 0x9BFD, 0x9BC8, 	/* 0xC350 to 0xC357 */
0x9BC0, 0x9D51, 0x9D5D, 0x9D60, 0x9EE0, 0x9F15, 0x9F2C, 0x5133, 	/* 0xC358 to 0xC35F */
0x56A5, 0x58DE, 0x58DF, 0x58E2, 0x5BF5, 0x9F90, 0x5EEC, 0x61F2, 	/* 0xC360 to 0xC367 */
0x61F7, 0x61F6, 0x61F5, 0x6500, 0x650F, 0x66E0, 0x66DD, 0x6AE5, 	/* 0xC368 to 0xC36F */
0x6ADD, 0x6ADA, 0x6AD3, 0x701B, 0x701F, 0x7028, 0x701A, 0x701D, 	/* 0xC370 to 0xC377 */
0x7015, 0x7018, 0x7206, 0x720D, 0x7258, 0x72A2, 0x7378, 0x0000, 	/* 0xC378 to 0xC37F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC380 to 0xC387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC388 to 0xC38F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC390 to 0xC397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC398 to 0xC39F */
0x0000, 0x737A, 0x74BD, 0x74CA, 0x74E3, 0x7587, 0x7586, 0x765F, 	/* 0xC3A0 to 0xC3A7 */
0x7661, 0x77C7, 0x7919, 0x79B1, 0x7A6B, 0x7A69, 0x7C3E, 0x7C3F, 	/* 0xC3A8 to 0xC3AF */
0x7C38, 0x7C3D, 0x7C37, 0x7C40, 0x7E6B, 0x7E6D, 0x7E79, 0x7E69, 	/* 0xC3B0 to 0xC3B7 */
0x7E6A, 0x7F85, 0x7E73, 0x7FB6, 0x7FB9, 0x7FB8, 0x81D8, 0x85E9, 	/* 0xC3B8 to 0xC3BF */
0x85DD, 0x85EA, 0x85D5, 0x85E4, 0x85E5, 0x85F7, 0x87FB, 0x8805, 	/* 0xC3C0 to 0xC3C7 */
0x880D, 0x87F9, 0x87FE, 0x8960, 0x895F, 0x8956, 0x895E, 0x8B41, 	/* 0xC3C8 to 0xC3CF */
0x8B5C, 0x8B58, 0x8B49, 0x8B5A, 0x8B4E, 0x8B4F, 0x8B46, 0x8B59, 	/* 0xC3D0 to 0xC3D7 */
0x8D08, 0x8D0A, 0x8E7C, 0x8E72, 0x8E87, 0x8E76, 0x8E6C, 0x8E7A, 	/* 0xC3D8 to 0xC3DF */
0x8E74, 0x8F54, 0x8F4E, 0x8FAD, 0x908A, 0x908B, 0x91B1, 0x91AE, 	/* 0xC3E0 to 0xC3E7 */
0x93E1, 0x93D1, 0x93DF, 0x93C3, 0x93C8, 0x93DC, 0x93DD, 0x93D6, 	/* 0xC3E8 to 0xC3EF */
0x93E2, 0x93CD, 0x93D8, 0x93E4, 0x93D7, 0x93E8, 0x95DC, 0x96B4, 	/* 0xC3F0 to 0xC3F7 */
0x96E3, 0x972A, 0x9727, 0x9761, 0x97DC, 0x97FB, 0x985E, 0x0000, 	/* 0xC3F8 to 0xC3FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC400 to 0xC407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC408 to 0xC40F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC410 to 0xC417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC418 to 0xC41F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC420 to 0xC427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC428 to 0xC42F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC430 to 0xC437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC438 to 0xC43F */
0x9858, 0x985B, 0x98BC, 0x9945, 0x9949, 0x9A16, 0x9A19, 0x9B0D, 	/* 0xC440 to 0xC447 */
0x9BE8, 0x9BE7, 0x9BD6, 0x9BDB, 0x9D89, 0x9D61, 0x9D72, 0x9D6A, 	/* 0xC448 to 0xC44F */
0x9D6C, 0x9E92, 0x9E97, 0x9E93, 0x9EB4, 0x52F8, 0x56A8, 0x56B7, 	/* 0xC450 to 0xC457 */
0x56B6, 0x56B4, 0x56BC, 0x58E4, 0x5B40, 0x5B43, 0x5B7D, 0x5BF6, 	/* 0xC458 to 0xC45F */
0x5DC9, 0x61F8, 0x61FA, 0x6518, 0x6514, 0x6519, 0x66E6, 0x6727, 	/* 0xC460 to 0xC467 */
0x6AEC, 0x703E, 0x7030, 0x7032, 0x7210, 0x737B, 0x74CF, 0x7662, 	/* 0xC468 to 0xC46F */
0x7665, 0x7926, 0x792A, 0x792C, 0x792B, 0x7AC7, 0x7AF6, 0x7C4C, 	/* 0xC470 to 0xC477 */
0x7C43, 0x7C4D, 0x7CEF, 0x7CF0, 0x8FAE, 0x7E7D, 0x7E7C, 0x0000, 	/* 0xC478 to 0xC47F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC480 to 0xC487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC488 to 0xC48F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC490 to 0xC497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC498 to 0xC49F */
0x0000, 0x7E82, 0x7F4C, 0x8000, 0x81DA, 0x8266, 0x85FB, 0x85F9, 	/* 0xC4A0 to 0xC4A7 */
0x8611, 0x85FA, 0x8606, 0x860B, 0x8607, 0x860A, 0x8814, 0x8815, 	/* 0xC4A8 to 0xC4AF */
0x8964, 0x89BA, 0x89F8, 0x8B70, 0x8B6C, 0x8B66, 0x8B6F, 0x8B5F, 	/* 0xC4B0 to 0xC4B7 */
0x8B6B, 0x8D0F, 0x8D0D, 0x8E89, 0x8E81, 0x8E85, 0x8E82, 0x91B4, 	/* 0xC4B8 to 0xC4BF */
0x91CB, 0x9418, 0x9403, 0x93FD, 0x95E1, 0x9730, 0x98C4, 0x9952, 	/* 0xC4C0 to 0xC4C7 */
0x9951, 0x99A8, 0x9A2B, 0x9A30, 0x9A37, 0x9A35, 0x9C13, 0x9C0D, 	/* 0xC4C8 to 0xC4CF */
0x9E79, 0x9EB5, 0x9EE8, 0x9F2F, 0x9F5F, 0x9F63, 0x9F61, 0x5137, 	/* 0xC4D0 to 0xC4D7 */
0x5138, 0x56C1, 0x56C0, 0x56C2, 0x5914, 0x5C6C, 0x5DCD, 0x61FC, 	/* 0xC4D8 to 0xC4DF */
0x61FE, 0x651D, 0x651C, 0x6595, 0x66E9, 0x6AFB, 0x6B04, 0x6AFA, 	/* 0xC4E0 to 0xC4E7 */
0x6BB2, 0x704C, 0x721B, 0x72A7, 0x74D6, 0x74D4, 0x7669, 0x77D3, 	/* 0xC4E8 to 0xC4EF */
0x7C50, 0x7E8F, 0x7E8C, 0x7FBC, 0x8617, 0x862D, 0x861A, 0x8823, 	/* 0xC4F0 to 0xC4F7 */
0x8822, 0x8821, 0x881F, 0x896A, 0x896C, 0x89BD, 0x8B74, 0x0000, 	/* 0xC4F8 to 0xC4FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC500 to 0xC507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC508 to 0xC50F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC510 to 0xC517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC518 to 0xC51F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC520 to 0xC527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC528 to 0xC52F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC530 to 0xC537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC538 to 0xC53F */
0x8B77, 0x8B7D, 0x8D13, 0x8E8A, 0x8E8D, 0x8E8B, 0x8F5F, 0x8FAF, 	/* 0xC540 to 0xC547 */
0x91BA, 0x942E, 0x9433, 0x9435, 0x943A, 0x9438, 0x9432, 0x942B, 	/* 0xC548 to 0xC54F */
0x95E2, 0x9738, 0x9739, 0x9732, 0x97FF, 0x9867, 0x9865, 0x9957, 	/* 0xC550 to 0xC557 */
0x9A45, 0x9A43, 0x9A40, 0x9A3E, 0x9ACF, 0x9B54, 0x9B51, 0x9C2D, 	/* 0xC558 to 0xC55F */
0x9C25, 0x9DAF, 0x9DB4, 0x9DC2, 0x9DB8, 0x9E9D, 0x9EEF, 0x9F19, 	/* 0xC560 to 0xC567 */
0x9F5C, 0x9F66, 0x9F67, 0x513C, 0x513B, 0x56C8, 0x56CA, 0x56C9, 	/* 0xC568 to 0xC56F */
0x5B7F, 0x5DD4, 0x5DD2, 0x5F4E, 0x61FF, 0x6524, 0x6B0A, 0x6B61, 	/* 0xC570 to 0xC577 */
0x7051, 0x7058, 0x7380, 0x74E4, 0x758A, 0x766E, 0x766C, 0x0000, 	/* 0xC578 to 0xC57F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC580 to 0xC587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC588 to 0xC58F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC590 to 0xC597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC598 to 0xC59F */
0x0000, 0x79B3, 0x7C60, 0x7C5F, 0x807E, 0x807D, 0x81DF, 0x8972, 	/* 0xC5A0 to 0xC5A7 */
0x896F, 0x89FC, 0x8B80, 0x8D16, 0x8D17, 0x8E91, 0x8E93, 0x8F61, 	/* 0xC5A8 to 0xC5AF */
0x9148, 0x9444, 0x9451, 0x9452, 0x973D, 0x973E, 0x97C3, 0x97C1, 	/* 0xC5B0 to 0xC5B7 */
0x986B, 0x9955, 0x9A55, 0x9A4D, 0x9AD2, 0x9B1A, 0x9C49, 0x9C31, 	/* 0xC5B8 to 0xC5BF */
0x9C3E, 0x9C3B, 0x9DD3, 0x9DD7, 0x9F34, 0x9F6C, 0x9F6A, 0x9F94, 	/* 0xC5C0 to 0xC5C7 */
0x56CC, 0x5DD6, 0x6200, 0x6523, 0x652B, 0x652A, 0x66EC, 0x6B10, 	/* 0xC5C8 to 0xC5CF */
0x74DA, 0x7ACA, 0x7C64, 0x7C63, 0x7C65, 0x7E93, 0x7E96, 0x7E94, 	/* 0xC5D0 to 0xC5D7 */
0x81E2, 0x8638, 0x863F, 0x8831, 0x8B8A, 0x9090, 0x908F, 0x9463, 	/* 0xC5D8 to 0xC5DF */
0x9460, 0x9464, 0x9768, 0x986F, 0x995C, 0x9A5A, 0x9A5B, 0x9A57, 	/* 0xC5E0 to 0xC5E7 */
0x9AD3, 0x9AD4, 0x9AD1, 0x9C54, 0x9C57, 0x9C56, 0x9DE5, 0x9E9F, 	/* 0xC5E8 to 0xC5EF */
0x9EF4, 0x56D1, 0x58E9, 0x652C, 0x705E, 0x7671, 0x7672, 0x77D7, 	/* 0xC5F0 to 0xC5F7 */
0x7F50, 0x7F88, 0x8836, 0x8839, 0x8862, 0x8B93, 0x8B92, 0x0000, 	/* 0xC5F8 to 0xC5FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC600 to 0xC607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC608 to 0xC60F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC610 to 0xC617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC618 to 0xC61F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC620 to 0xC627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC628 to 0xC62F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC630 to 0xC637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC638 to 0xC63F */
0x8B96, 0x8277, 0x8D1B, 0x91C0, 0x946A, 0x9742, 0x9748, 0x9744, 	/* 0xC640 to 0xC647 */
0x97C6, 0x9870, 0x9A5F, 0x9B22, 0x9B58, 0x9C5F, 0x9DF9, 0x9DFA, 	/* 0xC648 to 0xC64F */
0x9E7C, 0x9E7D, 0x9F07, 0x9F77, 0x9F72, 0x5EF3, 0x6B16, 0x7063, 	/* 0xC650 to 0xC657 */
0x7C6C, 0x7C6E, 0x883B, 0x89C0, 0x8EA1, 0x91C1, 0x9472, 0x9470, 	/* 0xC658 to 0xC65F */
0x9871, 0x995E, 0x9AD6, 0x9B23, 0x9ECC, 0x7064, 0x77DA, 0x8B9A, 	/* 0xC660 to 0xC667 */
0x9477, 0x97C9, 0x9A62, 0x9A65, 0x7E9C, 0x8B9C, 0x8EAA, 0x91C5, 	/* 0xC668 to 0xC66F */
0x947D, 0x947E, 0x947C, 0x9C77, 0x9C78, 0x9EF7, 0x8C54, 0x947F, 	/* 0xC670 to 0xC677 */
0x9E1A, 0x7228, 0x9A6A, 0x9B31, 0x9E1B, 0x9E1E, 0x7C72, 0x0000, 	/* 0xC678 to 0xC67F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC680 to 0xC687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC688 to 0xC68F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC690 to 0xC697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC698 to 0xC69F */
0x0000, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 	/* 0xC6A0 to 0xC6A7 */
0x2467, 0x2468, 0x2469, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 	/* 0xC6A8 to 0xC6AF */
0x2479, 0x247A, 0x247B, 0x247C, 0x247D, 0x2170, 0x2171, 0x2172, 	/* 0xC6B0 to 0xC6B7 */
0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x4E36, 	/* 0xC6B8 to 0xC6BF */
0x4E3F, 0x4E85, 0x4EA0, 0x5182, 0x5196, 0x51AB, 0x52F9, 0x5338, 	/* 0xC6C0 to 0xC6C7 */
0x5369, 0x53B6, 0x590A, 0x5B80, 0x5DDB, 0x5E7A, 0x5E7F, 0x5EF4, 	/* 0xC6C8 to 0xC6CF */
0x5F50, 0x5F61, 0x6534, 0x65E0, 0x7592, 0x7676, 0x8FB5, 0x96B6, 	/* 0xC6D0 to 0xC6D7 */
0x00A8, 0x02C6, 0x30FD, 0x30FE, 0x309D, 0x309E, 0x3003, 0x4EDD, 	/* 0xC6D8 to 0xC6DF */
0x3005, 0x3006, 0x3007, 0x30FC, 0xFF3B, 0xFF3D, 0x273D, 0x3041, 	/* 0xC6E0 to 0xC6E7 */
0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 	/* 0xC6E8 to 0xC6EF */
0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051, 	/* 0xC6F0 to 0xC6F7 */
0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x0000, 	/* 0xC6F8 to 0xC6FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC700 to 0xC707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC708 to 0xC70F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC710 to 0xC717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC718 to 0xC71F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC720 to 0xC727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC728 to 0xC72F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC730 to 0xC737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC738 to 0xC73F */
0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 	/* 0xC740 to 0xC747 */
0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 	/* 0xC748 to 0xC74F */
0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070, 	/* 0xC750 to 0xC757 */
0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 	/* 0xC758 to 0xC75F */
0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080, 	/* 0xC760 to 0xC767 */
0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 	/* 0xC768 to 0xC76F */
0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 	/* 0xC770 to 0xC777 */
0x3091, 0x3092, 0x3093, 0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x0000, 	/* 0xC778 to 0xC77F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC780 to 0xC787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC788 to 0xC78F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC790 to 0xC797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC798 to 0xC79F */
0x0000, 0x30A5, 0x30A6, 0x30A7, 0x30A8, 0x30A9, 0x30AA, 0x30AB, 	/* 0xC7A0 to 0xC7A7 */
0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 0x30B1, 0x30B2, 0x30B3, 	/* 0xC7A8 to 0xC7AF */
0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 	/* 0xC7B0 to 0xC7B7 */
0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3, 	/* 0xC7B8 to 0xC7BF */
0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB, 	/* 0xC7C0 to 0xC7C7 */
0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3, 	/* 0xC7C8 to 0xC7CF */
0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB, 	/* 0xC7D0 to 0xC7D7 */
0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E3, 	/* 0xC7D8 to 0xC7DF */
0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 0x30E9, 0x30EA, 0x30EB, 	/* 0xC7E0 to 0xC7E7 */
0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 0x30F1, 0x30F2, 0x30F3, 	/* 0xC7E8 to 0xC7EF */
0x30F4, 0x30F5, 0x30F6, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 	/* 0xC7F0 to 0xC7F7 */
0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x0000, 	/* 0xC7F8 to 0xC7FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC800 to 0xC807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC808 to 0xC80F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC810 to 0xC817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC818 to 0xC81F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC820 to 0xC827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC828 to 0xC82F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC830 to 0xC837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC838 to 0xC83F */
0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 0x0421, 0x0422, 	/* 0xC840 to 0xC847 */
0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 	/* 0xC848 to 0xC84F */
0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 	/* 0xC850 to 0xC857 */
0x0433, 0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 	/* 0xC858 to 0xC85F */
0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 	/* 0xC860 to 0xC867 */
0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 	/* 0xC868 to 0xC86F */
0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x21E7, 0x21B8, 	/* 0xC870 to 0xC877 */
0x21B9, 0x31CF, 0xF7E6, 0x4E5A, 0xF7E8, 0x5202, 0x4491, 0x0000, 	/* 0xC878 to 0xC87F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC880 to 0xC887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC888 to 0xC88F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC890 to 0xC897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC898 to 0xC89F */
0x0000, 0x9FB0, 0x5188, 0x9FB1, 0xF7EE, 0xF7EF, 0xF7F0, 0xF7F1, 	/* 0xC8A0 to 0xC8A7 */
0xF7F2, 0xF7F3, 0xF7F4, 0xF7F5, 0xF7F6, 0xF7F7, 0xF7F8, 0xF7F9, 	/* 0xC8A8 to 0xC8AF */
0xF7FA, 0x309B, 0x309C, 0x3094, 0x30F7, 0x30F8, 0x30F9, 0x30FA, 	/* 0xC8B0 to 0xC8B7 */
0x30FB, 0xFF61, 0xFF62, 0xFF63, 0xFF64, 0xFF65, 0xFF66, 0xFF67, 	/* 0xC8B8 to 0xC8BF */
0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C, 0xFF6D, 0xFF6E, 0xFF6F, 	/* 0xC8C0 to 0xC8C7 */
0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74, 0xFFE2, 0xFFE4, 0xFF07, 	/* 0xC8C8 to 0xC8CF */
0xFF02, 0x3231, 0x2116, 0x2121, 0xFF75, 0xFF76, 0xFF77, 0xFF78, 	/* 0xC8D0 to 0xC8D7 */
0xFF79, 0xFF7A, 0xFF7B, 0xFF7C, 0xFF7D, 0xFF7E, 0xFF7F, 0xFF80, 	/* 0xC8D8 to 0xC8DF */
0xFF81, 0xFF82, 0xFF83, 0xFF84, 0xFF85, 0xFF86, 0xFF87, 0xFF88, 	/* 0xC8E0 to 0xC8E7 */
0xFF89, 0xFF8A, 0xFF8B, 0xFF8C, 0xFF8D, 0xFF8E, 0xFF8F, 0xFF90, 	/* 0xC8E8 to 0xC8EF */
0xFF91, 0xFF92, 0xFF93, 0xFF94, 0xFF95, 0xFF96, 0xFF97, 0xFF98, 	/* 0xC8F0 to 0xC8F7 */
0xFF99, 0xFF9A, 0xFF9B, 0xFF9C, 0xFF9D, 0xFF9E, 0xFF9F, 0x0000, 	/* 0xC8F8 to 0xC8FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC900 to 0xC907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC908 to 0xC90F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC910 to 0xC917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC918 to 0xC91F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC920 to 0xC927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC928 to 0xC92F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC930 to 0xC937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC938 to 0xC93F */
0x4E42, 0x4E5C, 0x51F5, 0x531A, 0x5382, 0x4E07, 0x4E0C, 0x4E47, 	/* 0xC940 to 0xC947 */
0x4E8D, 0x56D7, 0xFA0C, 0x5C6E, 0x5F73, 0x4E0F, 0x5187, 0x4E0E, 	/* 0xC948 to 0xC94F */
0x4E2E, 0x4E93, 0x4EC2, 0x4EC9, 0x4EC8, 0x5198, 0x52FC, 0x536C, 	/* 0xC950 to 0xC957 */
0x53B9, 0x5720, 0x5903, 0x592C, 0x5C10, 0x5DFF, 0x65E1, 0x6BB3, 	/* 0xC958 to 0xC95F */
0x6BCC, 0x6C14, 0x723F, 0x4E31, 0x4E3C, 0x4EE8, 0x4EDC, 0x4EE9, 	/* 0xC960 to 0xC967 */
0x4EE1, 0x4EDD, 0x4EDA, 0x520C, 0x531C, 0x534C, 0x5722, 0x5723, 	/* 0xC968 to 0xC96F */
0x5917, 0x592F, 0x5B81, 0x5B84, 0x5C12, 0x5C3B, 0x5C74, 0x5C73, 	/* 0xC970 to 0xC977 */
0x5E04, 0x5E80, 0x5E82, 0x5FC9, 0x6209, 0x6250, 0x6C15, 0x0000, 	/* 0xC978 to 0xC97F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC980 to 0xC987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC988 to 0xC98F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC990 to 0xC997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xC998 to 0xC99F */
0x0000, 0x6C36, 0x6C43, 0x6C3F, 0x6C3B, 0x72AE, 0x72B0, 0x738A, 	/* 0xC9A0 to 0xC9A7 */
0x79B8, 0x808A, 0x961E, 0x4F0E, 0x4F18, 0x4F2C, 0x4EF5, 0x4F14, 	/* 0xC9A8 to 0xC9AF */
0x4EF1, 0x4F00, 0x4EF7, 0x4F08, 0x4F1D, 0x4F02, 0x4F05, 0x4F22, 	/* 0xC9B0 to 0xC9B7 */
0x4F13, 0x4F04, 0x4EF4, 0x4F12, 0x51B1, 0x5213, 0x5209, 0x5210, 	/* 0xC9B8 to 0xC9BF */
0x52A6, 0x5322, 0x531F, 0x534D, 0x538A, 0x5407, 0x56E1, 0x56DF, 	/* 0xC9C0 to 0xC9C7 */
0x572E, 0x572A, 0x5734, 0x593C, 0x5980, 0x597C, 0x5985, 0x597B, 	/* 0xC9C8 to 0xC9CF */
0x597E, 0x5977, 0x597F, 0x5B56, 0x5C15, 0x5C25, 0x5C7C, 0x5C7A, 	/* 0xC9D0 to 0xC9D7 */
0x5C7B, 0x5C7E, 0x5DDF, 0x5E75, 0x5E84, 0x5F02, 0x5F1A, 0x5F74, 	/* 0xC9D8 to 0xC9DF */
0x5FD5, 0x5FD4, 0x5FCF, 0x625C, 0x625E, 0x6264, 0x6261, 0x6266, 	/* 0xC9E0 to 0xC9E7 */
0x6262, 0x6259, 0x6260, 0x625A, 0x6265, 0x65EF, 0x65EE, 0x673E, 	/* 0xC9E8 to 0xC9EF */
0x6739, 0x6738, 0x673B, 0x673A, 0x673F, 0x673C, 0x6733, 0x6C18, 	/* 0xC9F0 to 0xC9F7 */
0x6C46, 0x6C52, 0x6C5C, 0x6C4F, 0x6C4A, 0x6C54, 0x6C4B, 0x0000, 	/* 0xC9F8 to 0xC9FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA00 to 0xCA07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA08 to 0xCA0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA10 to 0xCA17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA18 to 0xCA1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA20 to 0xCA27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA28 to 0xCA2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA30 to 0xCA37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA38 to 0xCA3F */
0x6C4C, 0x7071, 0x725E, 0x72B4, 0x72B5, 0x738E, 0x752A, 0x767F, 	/* 0xCA40 to 0xCA47 */
0x7A75, 0x7F51, 0x8278, 0x827C, 0x8280, 0x827D, 0x827F, 0x864D, 	/* 0xCA48 to 0xCA4F */
0x897E, 0x9099, 0x9097, 0x9098, 0x909B, 0x9094, 0x9622, 0x9624, 	/* 0xCA50 to 0xCA57 */
0x9620, 0x9623, 0x4F56, 0x4F3B, 0x4F62, 0x4F49, 0x4F53, 0x4F64, 	/* 0xCA58 to 0xCA5F */
0x4F3E, 0x4F67, 0x4F52, 0x4F5F, 0x4F41, 0x4F58, 0x4F2D, 0x4F33, 	/* 0xCA60 to 0xCA67 */
0x4F3F, 0x4F61, 0x518F, 0x51B9, 0x521C, 0x521E, 0x5221, 0x52AD, 	/* 0xCA68 to 0xCA6F */
0x52AE, 0x5309, 0x5363, 0x5372, 0x538E, 0x538F, 0x5430, 0x5437, 	/* 0xCA70 to 0xCA77 */
0x542A, 0x5454, 0x5445, 0x5419, 0x541C, 0x5425, 0x5418, 0x0000, 	/* 0xCA78 to 0xCA7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA80 to 0xCA87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA88 to 0xCA8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA90 to 0xCA97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCA98 to 0xCA9F */
0x0000, 0x543D, 0x544F, 0x5441, 0x5428, 0x5424, 0x5447, 0x56EE, 	/* 0xCAA0 to 0xCAA7 */
0x56E7, 0x56E5, 0x5741, 0x5745, 0x574C, 0x5749, 0x574B, 0x5752, 	/* 0xCAA8 to 0xCAAF */
0x5906, 0x5940, 0x59A6, 0x5998, 0x59A0, 0x5997, 0x598E, 0x59A2, 	/* 0xCAB0 to 0xCAB7 */
0x5990, 0x598F, 0x59A7, 0x59A1, 0x5B8E, 0x5B92, 0x5C28, 0x5C2A, 	/* 0xCAB8 to 0xCABF */
0x5C8D, 0x5C8F, 0x5C88, 0x5C8B, 0x5C89, 0x5C92, 0x5C8A, 0x5C86, 	/* 0xCAC0 to 0xCAC7 */
0x5C93, 0x5C95, 0x5DE0, 0x5E0A, 0x5E0E, 0x5E8B, 0x5E89, 0x5E8C, 	/* 0xCAC8 to 0xCACF */
0x5E88, 0x5E8D, 0x5F05, 0x5F1D, 0x5F78, 0x5F76, 0x5FD2, 0x5FD1, 	/* 0xCAD0 to 0xCAD7 */
0x5FD0, 0x5FED, 0x5FE8, 0x5FEE, 0x5FF3, 0x5FE1, 0x5FE4, 0x5FE3, 	/* 0xCAD8 to 0xCADF */
0x5FFA, 0x5FEF, 0x5FF7, 0x5FFB, 0x6000, 0x5FF4, 0x623A, 0x6283, 	/* 0xCAE0 to 0xCAE7 */
0x628C, 0x628E, 0x628F, 0x6294, 0x6287, 0x6271, 0x627B, 0x627A, 	/* 0xCAE8 to 0xCAEF */
0x6270, 0x6281, 0x6288, 0x6277, 0x627D, 0x6272, 0x6274, 0x6537, 	/* 0xCAF0 to 0xCAF7 */
0x65F0, 0x65F4, 0x65F3, 0x65F2, 0x65F5, 0x6745, 0x6747, 0x0000, 	/* 0xCAF8 to 0xCAFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB00 to 0xCB07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB08 to 0xCB0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB10 to 0xCB17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB18 to 0xCB1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB20 to 0xCB27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB28 to 0xCB2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB30 to 0xCB37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB38 to 0xCB3F */
0x6759, 0x6755, 0x674C, 0x6748, 0x675D, 0x674D, 0x675A, 0x674B, 	/* 0xCB40 to 0xCB47 */
0x6BD0, 0x6C19, 0x6C1A, 0x6C78, 0x6C67, 0x6C6B, 0x6C84, 0x6C8B, 	/* 0xCB48 to 0xCB4F */
0x6C8F, 0x6C71, 0x6C6F, 0x6C69, 0x6C9A, 0x6C6D, 0x6C87, 0x6C95, 	/* 0xCB50 to 0xCB57 */
0x6C9C, 0x6C66, 0x6C73, 0x6C65, 0x6C7B, 0x6C8E, 0x7074, 0x707A, 	/* 0xCB58 to 0xCB5F */
0x7263, 0x72BF, 0x72BD, 0x72C3, 0x72C6, 0x72C1, 0x72BA, 0x72C5, 	/* 0xCB60 to 0xCB67 */
0x7395, 0x7397, 0x7393, 0x7394, 0x7392, 0x753A, 0x7539, 0x7594, 	/* 0xCB68 to 0xCB6F */
0x7595, 0x7681, 0x793D, 0x8034, 0x8095, 0x8099, 0x8090, 0x8092, 	/* 0xCB70 to 0xCB77 */
0x809C, 0x8290, 0x828F, 0x8285, 0x828E, 0x8291, 0x8293, 0x0000, 	/* 0xCB78 to 0xCB7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB80 to 0xCB87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB88 to 0xCB8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB90 to 0xCB97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCB98 to 0xCB9F */
0x0000, 0x828A, 0x8283, 0x8284, 0x8C78, 0x8FC9, 0x8FBF, 0x909F, 	/* 0xCBA0 to 0xCBA7 */
0x90A1, 0x90A5, 0x909E, 0x90A7, 0x90A0, 0x9630, 0x9628, 0x962F, 	/* 0xCBA8 to 0xCBAF */
0x962D, 0x4E33, 0x4F98, 0x4F7C, 0x4F85, 0x4F7D, 0x4F80, 0x4F87, 	/* 0xCBB0 to 0xCBB7 */
0x4F76, 0x4F74, 0x4F89, 0x4F84, 0x4F77, 0x4F4C, 0x4F97, 0x4F6A, 	/* 0xCBB8 to 0xCBBF */
0x4F9A, 0x4F79, 0x4F81, 0x4F78, 0x4F90, 0x4F9C, 0x4F94, 0x4F9E, 	/* 0xCBC0 to 0xCBC7 */
0x4F92, 0x4F82, 0x4F95, 0x4F6B, 0x4F6E, 0x519E, 0x51BC, 0x51BE, 	/* 0xCBC8 to 0xCBCF */
0x5235, 0x5232, 0x5233, 0x5246, 0x5231, 0x52BC, 0x530A, 0x530B, 	/* 0xCBD0 to 0xCBD7 */
0x533C, 0x5392, 0x5394, 0x5487, 0x547F, 0x5481, 0x5491, 0x5482, 	/* 0xCBD8 to 0xCBDF */
0x5488, 0x546B, 0x547A, 0x547E, 0x5465, 0x546C, 0x5474, 0x5466, 	/* 0xCBE0 to 0xCBE7 */
0x548D, 0x546F, 0x5461, 0x5460, 0x5498, 0x5463, 0x5467, 0x5464, 	/* 0xCBE8 to 0xCBEF */
0x56F7, 0x56F9, 0x576F, 0x5772, 0x576D, 0x576B, 0x5771, 0x5770, 	/* 0xCBF0 to 0xCBF7 */
0x5776, 0x5780, 0x5775, 0x577B, 0x5773, 0x5774, 0x5762, 0x0000, 	/* 0xCBF8 to 0xCBFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC00 to 0xCC07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC08 to 0xCC0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC10 to 0xCC17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC18 to 0xCC1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC20 to 0xCC27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC28 to 0xCC2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC30 to 0xCC37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC38 to 0xCC3F */
0x5768, 0x577D, 0x590C, 0x5945, 0x59B5, 0x59BA, 0x59CF, 0x59CE, 	/* 0xCC40 to 0xCC47 */
0x59B2, 0x59CC, 0x59C1, 0x59B6, 0x59BC, 0x59C3, 0x59D6, 0x59B1, 	/* 0xCC48 to 0xCC4F */
0x59BD, 0x59C0, 0x59C8, 0x59B4, 0x59C7, 0x5B62, 0x5B65, 0x5B93, 	/* 0xCC50 to 0xCC57 */
0x5B95, 0x5C44, 0x5C47, 0x5CAE, 0x5CA4, 0x5CA0, 0x5CB5, 0x5CAF, 	/* 0xCC58 to 0xCC5F */
0x5CA8, 0x5CAC, 0x5C9F, 0x5CA3, 0x5CAD, 0x5CA2, 0x5CAA, 0x5CA7, 	/* 0xCC60 to 0xCC67 */
0x5C9D, 0x5CA5, 0x5CB6, 0x5CB0, 0x5CA6, 0x5E17, 0x5E14, 0x5E19, 	/* 0xCC68 to 0xCC6F */
0x5F28, 0x5F22, 0x5F23, 0x5F24, 0x5F54, 0x5F82, 0x5F7E, 0x5F7D, 	/* 0xCC70 to 0xCC77 */
0x5FDE, 0x5FE5, 0x602D, 0x6026, 0x6019, 0x6032, 0x600B, 0x0000, 	/* 0xCC78 to 0xCC7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC80 to 0xCC87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC88 to 0xCC8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC90 to 0xCC97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCC98 to 0xCC9F */
0x0000, 0x6034, 0x600A, 0x6017, 0x6033, 0x601A, 0x601E, 0x602C, 	/* 0xCCA0 to 0xCCA7 */
0x6022, 0x600D, 0x6010, 0x602E, 0x6013, 0x6011, 0x600C, 0x6009, 	/* 0xCCA8 to 0xCCAF */
0x601C, 0x6214, 0x623D, 0x62AD, 0x62B4, 0x62D1, 0x62BE, 0x62AA, 	/* 0xCCB0 to 0xCCB7 */
0x62B6, 0x62CA, 0x62AE, 0x62B3, 0x62AF, 0x62BB, 0x62A9, 0x62B0, 	/* 0xCCB8 to 0xCCBF */
0x62B8, 0x653D, 0x65A8, 0x65BB, 0x6609, 0x65FC, 0x6604, 0x6612, 	/* 0xCCC0 to 0xCCC7 */
0x6608, 0x65FB, 0x6603, 0x660B, 0x660D, 0x6605, 0x65FD, 0x6611, 	/* 0xCCC8 to 0xCCCF */
0x6610, 0x66F6, 0x670A, 0x6785, 0x676C, 0x678E, 0x6792, 0x6776, 	/* 0xCCD0 to 0xCCD7 */
0x677B, 0x6798, 0x6786, 0x6784, 0x6774, 0x678D, 0x678C, 0x677A, 	/* 0xCCD8 to 0xCCDF */
0x679F, 0x6791, 0x6799, 0x6783, 0x677D, 0x6781, 0x6778, 0x6779, 	/* 0xCCE0 to 0xCCE7 */
0x6794, 0x6B25, 0x6B80, 0x6B7E, 0x6BDE, 0x6C1D, 0x6C93, 0x6CEC, 	/* 0xCCE8 to 0xCCEF */
0x6CEB, 0x6CEE, 0x6CD9, 0x6CB6, 0x6CD4, 0x6CAD, 0x6CE7, 0x6CB7, 	/* 0xCCF0 to 0xCCF7 */
0x6CD0, 0x6CC2, 0x6CBA, 0x6CC3, 0x6CC6, 0x6CED, 0x6CF2, 0x0000, 	/* 0xCCF8 to 0xCCFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD00 to 0xCD07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD08 to 0xCD0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD10 to 0xCD17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD18 to 0xCD1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD20 to 0xCD27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD28 to 0xCD2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD30 to 0xCD37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD38 to 0xCD3F */
0x6CD2, 0x6CDD, 0x6CB4, 0x6C8A, 0x6C9D, 0x6C80, 0x6CDE, 0x6CC0, 	/* 0xCD40 to 0xCD47 */
0x6D30, 0x6CCD, 0x6CC7, 0x6CB0, 0x6CF9, 0x6CCF, 0x6CE9, 0x6CD1, 	/* 0xCD48 to 0xCD4F */
0x7094, 0x7098, 0x7085, 0x7093, 0x7086, 0x7084, 0x7091, 0x7096, 	/* 0xCD50 to 0xCD57 */
0x7082, 0x709A, 0x7083, 0x726A, 0x72D6, 0x72CB, 0x72D8, 0x72C9, 	/* 0xCD58 to 0xCD5F */
0x72DC, 0x72D2, 0x72D4, 0x72DA, 0x72CC, 0x72D1, 0x73A4, 0x73A1, 	/* 0xCD60 to 0xCD67 */
0x73AD, 0x73A6, 0x73A2, 0x73A0, 0x73AC, 0x739D, 0x74DD, 0x74E8, 	/* 0xCD68 to 0xCD6F */
0x753F, 0x7540, 0x753E, 0x758C, 0x7598, 0x76AF, 0x76F3, 0x76F1, 	/* 0xCD70 to 0xCD77 */
0x76F0, 0x76F5, 0x77F8, 0x77FC, 0x77F9, 0x77FB, 0x77FA, 0x0000, 	/* 0xCD78 to 0xCD7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD80 to 0xCD87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD88 to 0xCD8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD90 to 0xCD97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCD98 to 0xCD9F */
0x0000, 0x77F7, 0x7942, 0x793F, 0x79C5, 0x7A78, 0x7A7B, 0x7AFB, 	/* 0xCDA0 to 0xCDA7 */
0x7C75, 0x7CFD, 0x8035, 0x808F, 0x80AE, 0x80A3, 0x80B8, 0x80B5, 	/* 0xCDA8 to 0xCDAF */
0x80AD, 0x8220, 0x82A0, 0x82C0, 0x82AB, 0x829A, 0x8298, 0x829B, 	/* 0xCDB0 to 0xCDB7 */
0x82B5, 0x82A7, 0x82AE, 0x82BC, 0x829E, 0x82BA, 0x82B4, 0x82A8, 	/* 0xCDB8 to 0xCDBF */
0x82A1, 0x82A9, 0x82C2, 0x82A4, 0x82C3, 0x82B6, 0x82A2, 0x8670, 	/* 0xCDC0 to 0xCDC7 */
0x866F, 0x866D, 0x866E, 0x8C56, 0x8FD2, 0x8FCB, 0x8FD3, 0x8FCD, 	/* 0xCDC8 to 0xCDCF */
0x8FD6, 0x8FD5, 0x8FD7, 0x90B2, 0x90B4, 0x90AF, 0x90B3, 0x90B0, 	/* 0xCDD0 to 0xCDD7 */
0x9639, 0x963D, 0x963C, 0x963A, 0x9643, 0x4FCD, 0x4FC5, 0x4FD3, 	/* 0xCDD8 to 0xCDDF */
0x4FB2, 0x4FC9, 0x4FCB, 0x4FC1, 0x4FD4, 0x4FDC, 0x4FD9, 0x4FBB, 	/* 0xCDE0 to 0xCDE7 */
0x4FB3, 0x4FDB, 0x4FC7, 0x4FD6, 0x4FBA, 0x4FC0, 0x4FB9, 0x4FEC, 	/* 0xCDE8 to 0xCDEF */
0x5244, 0x5249, 0x52C0, 0x52C2, 0x533D, 0x537C, 0x5397, 0x5396, 	/* 0xCDF0 to 0xCDF7 */
0x5399, 0x5398, 0x54BA, 0x54A1, 0x54AD, 0x54A5, 0x54CF, 0x0000, 	/* 0xCDF8 to 0xCDFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE00 to 0xCE07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE08 to 0xCE0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE10 to 0xCE17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE18 to 0xCE1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE20 to 0xCE27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE28 to 0xCE2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE30 to 0xCE37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE38 to 0xCE3F */
0x54C3, 0x830D, 0x54B7, 0x54AE, 0x54D6, 0x54B6, 0x54C5, 0x54C6, 	/* 0xCE40 to 0xCE47 */
0x54A0, 0x5470, 0x54BC, 0x54A2, 0x54BE, 0x5472, 0x54DE, 0x54B0, 	/* 0xCE48 to 0xCE4F */
0x57B5, 0x579E, 0x579F, 0x57A4, 0x578C, 0x5797, 0x579D, 0x579B, 	/* 0xCE50 to 0xCE57 */
0x5794, 0x5798, 0x578F, 0x5799, 0x57A5, 0x579A, 0x5795, 0x58F4, 	/* 0xCE58 to 0xCE5F */
0x590D, 0x5953, 0x59E1, 0x59DE, 0x59EE, 0x5A00, 0x59F1, 0x59DD, 	/* 0xCE60 to 0xCE67 */
0x59FA, 0x59FD, 0x59FC, 0x59F6, 0x59E4, 0x59F2, 0x59F7, 0x59DB, 	/* 0xCE68 to 0xCE6F */
0x59E9, 0x59F3, 0x59F5, 0x59E0, 0x59FE, 0x59F4, 0x59ED, 0x5BA8, 	/* 0xCE70 to 0xCE77 */
0x5C4C, 0x5CD0, 0x5CD8, 0x5CCC, 0x5CD7, 0x5CCB, 0x5CDB, 0x0000, 	/* 0xCE78 to 0xCE7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE80 to 0xCE87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE88 to 0xCE8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE90 to 0xCE97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCE98 to 0xCE9F */
0x0000, 0x5CDE, 0x5CDA, 0x5CC9, 0x5CC7, 0x5CCA, 0x5CD6, 0x5CD3, 	/* 0xCEA0 to 0xCEA7 */
0x5CD4, 0x5CCF, 0x5CC8, 0x5CC6, 0x5CCE, 0x5CDF, 0x5CF8, 0x5DF9, 	/* 0xCEA8 to 0xCEAF */
0x5E21, 0x5E22, 0x5E23, 0x5E20, 0x5E24, 0x5EB0, 0x5EA4, 0x5EA2, 	/* 0xCEB0 to 0xCEB7 */
0x5E9B, 0x5EA3, 0x5EA5, 0x5F07, 0x5F2E, 0x5F56, 0x5F86, 0x6037, 	/* 0xCEB8 to 0xCEBF */
0x6039, 0x6054, 0x6072, 0x605E, 0x6045, 0x6053, 0x6047, 0x6049, 	/* 0xCEC0 to 0xCEC7 */
0x605B, 0x604C, 0x6040, 0x6042, 0x605F, 0x6024, 0x6044, 0x6058, 	/* 0xCEC8 to 0xCECF */
0x6066, 0x606E, 0x6242, 0x6243, 0x62CF, 0x630D, 0x630B, 0x62F5, 	/* 0xCED0 to 0xCED7 */
0x630E, 0x6303, 0x62EB, 0x62F9, 0x630F, 0x630C, 0x62F8, 0x62F6, 	/* 0xCED8 to 0xCEDF */
0x6300, 0x6313, 0x6314, 0x62FA, 0x6315, 0x62FB, 0x62F0, 0x6541, 	/* 0xCEE0 to 0xCEE7 */
0x6543, 0x65AA, 0x65BF, 0x6636, 0x6621, 0x6632, 0x6635, 0x661C, 	/* 0xCEE8 to 0xCEEF */
0x6626, 0x6622, 0x6633, 0x662B, 0x663A, 0x661D, 0x6634, 0x6639, 	/* 0xCEF0 to 0xCEF7 */
0x662E, 0x670F, 0x6710, 0x67C1, 0x67F2, 0x67C8, 0x67BA, 0x0000, 	/* 0xCEF8 to 0xCEFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF00 to 0xCF07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF08 to 0xCF0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF10 to 0xCF17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF18 to 0xCF1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF20 to 0xCF27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF28 to 0xCF2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF30 to 0xCF37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF38 to 0xCF3F */
0x67DC, 0x67BB, 0x67F8, 0x67D8, 0x67C0, 0x67B7, 0x67C5, 0x67EB, 	/* 0xCF40 to 0xCF47 */
0x67E4, 0x67DF, 0x67B5, 0x67CD, 0x67B3, 0x67F7, 0x67F6, 0x67EE, 	/* 0xCF48 to 0xCF4F */
0x67E3, 0x67C2, 0x67B9, 0x67CE, 0x67E7, 0x67F0, 0x67B2, 0x67FC, 	/* 0xCF50 to 0xCF57 */
0x67C6, 0x67ED, 0x67CC, 0x67AE, 0x67E6, 0x67DB, 0x67FA, 0x67C9, 	/* 0xCF58 to 0xCF5F */
0x67CA, 0x67C3, 0x67EA, 0x67CB, 0x6B28, 0x6B82, 0x6B84, 0x6BB6, 	/* 0xCF60 to 0xCF67 */
0x6BD6, 0x6BD8, 0x6BE0, 0x6C20, 0x6C21, 0x6D28, 0x6D34, 0x6D2D, 	/* 0xCF68 to 0xCF6F */
0x6D1F, 0x6D3C, 0x6D3F, 0x6D12, 0x6D0A, 0x6CDA, 0x6D33, 0x6D04, 	/* 0xCF70 to 0xCF77 */
0x6D19, 0x6D3A, 0x6D1A, 0x6D11, 0x6D00, 0x6D1D, 0x6D42, 0x0000, 	/* 0xCF78 to 0xCF7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF80 to 0xCF87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF88 to 0xCF8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF90 to 0xCF97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xCF98 to 0xCF9F */
0x0000, 0x6D01, 0x6D18, 0x6D37, 0x6D03, 0x6D0F, 0x6D40, 0x6D07, 	/* 0xCFA0 to 0xCFA7 */
0x6D20, 0x6D2C, 0x6D08, 0x6D22, 0x6D09, 0x6D10, 0x70B7, 0x709F, 	/* 0xCFA8 to 0xCFAF */
0x70BE, 0x70B1, 0x70B0, 0x70A1, 0x70B4, 0x70B5, 0x70A9, 0x7241, 	/* 0xCFB0 to 0xCFB7 */
0x7249, 0x724A, 0x726C, 0x7270, 0x7273, 0x726E, 0x72CA, 0x72E4, 	/* 0xCFB8 to 0xCFBF */
0x72E8, 0x72EB, 0x72DF, 0x72EA, 0x72E6, 0x72E3, 0x7385, 0x73CC, 	/* 0xCFC0 to 0xCFC7 */
0x73C2, 0x73C8, 0x73C5, 0x73B9, 0x73B6, 0x73B5, 0x73B4, 0x73EB, 	/* 0xCFC8 to 0xCFCF */
0x73BF, 0x73C7, 0x73BE, 0x73C3, 0x73C6, 0x73B8, 0x73CB, 0x74EC, 	/* 0xCFD0 to 0xCFD7 */
0x74EE, 0x752E, 0x7547, 0x7548, 0x75A7, 0x75AA, 0x7679, 0x76C4, 	/* 0xCFD8 to 0xCFDF */
0x7708, 0x7703, 0x7704, 0x7705, 0x770A, 0x76F7, 0x76FB, 0x76FA, 	/* 0xCFE0 to 0xCFE7 */
0x77E7, 0x77E8, 0x7806, 0x7811, 0x7812, 0x7805, 0x7810, 0x780F, 	/* 0xCFE8 to 0xCFEF */
0x780E, 0x7809, 0x7803, 0x7813, 0x794A, 0x794C, 0x794B, 0x7945, 	/* 0xCFF0 to 0xCFF7 */
0x7944, 0x79D5, 0x79CD, 0x79CF, 0x79D6, 0x79CE, 0x7A80, 0x0000, 	/* 0xCFF8 to 0xCFFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD000 to 0xD007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD008 to 0xD00F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD010 to 0xD017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD018 to 0xD01F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD020 to 0xD027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD028 to 0xD02F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD030 to 0xD037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD038 to 0xD03F */
0x7A7E, 0x7AD1, 0x7B00, 0x7B01, 0x7C7A, 0x7C78, 0x7C79, 0x7C7F, 	/* 0xD040 to 0xD047 */
0x7C80, 0x7C81, 0x7D03, 0x7D08, 0x7D01, 0x7F58, 0x7F91, 0x7F8D, 	/* 0xD048 to 0xD04F */
0x7FBE, 0x8007, 0x800E, 0x800F, 0x8014, 0x8037, 0x80D8, 0x80C7, 	/* 0xD050 to 0xD057 */
0x80E0, 0x80D1, 0x80C8, 0x80C2, 0x80D0, 0x80C5, 0x80E3, 0x80D9, 	/* 0xD058 to 0xD05F */
0x80DC, 0x80CA, 0x80D5, 0x80C9, 0x80CF, 0x80D7, 0x80E6, 0x80CD, 	/* 0xD060 to 0xD067 */
0x81FF, 0x8221, 0x8294, 0x82D9, 0x82FE, 0x82F9, 0x8307, 0x82E8, 	/* 0xD068 to 0xD06F */
0x8300, 0x82D5, 0x833A, 0x82EB, 0x82D6, 0x82F4, 0x82EC, 0x82E1, 	/* 0xD070 to 0xD077 */
0x82F2, 0x82F5, 0x830C, 0x82FB, 0x82F6, 0x82F0, 0x82EA, 0x0000, 	/* 0xD078 to 0xD07F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD080 to 0xD087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD088 to 0xD08F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD090 to 0xD097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD098 to 0xD09F */
0x0000, 0x82E4, 0x82E0, 0x82FA, 0x82F3, 0x82ED, 0x8677, 0x8674, 	/* 0xD0A0 to 0xD0A7 */
0x867C, 0x8673, 0x8841, 0x884E, 0x8867, 0x886A, 0x8869, 0x89D3, 	/* 0xD0A8 to 0xD0AF */
0x8A04, 0x8A07, 0x8D72, 0x8FE3, 0x8FE1, 0x8FEE, 0x8FE0, 0x90F1, 	/* 0xD0B0 to 0xD0B7 */
0x90BD, 0x90BF, 0x90D5, 0x90C5, 0x90BE, 0x90C7, 0x90CB, 0x90C8, 	/* 0xD0B8 to 0xD0BF */
0x91D4, 0x91D3, 0x9654, 0x964F, 0x9651, 0x9653, 0x964A, 0x964E, 	/* 0xD0C0 to 0xD0C7 */
0x501E, 0x5005, 0x5007, 0x5013, 0x5022, 0x5030, 0x501B, 0x4FF5, 	/* 0xD0C8 to 0xD0CF */
0x4FF4, 0x5033, 0x5037, 0x502C, 0x4FF6, 0x4FF7, 0x5017, 0x501C, 	/* 0xD0D0 to 0xD0D7 */
0x5020, 0x5027, 0x5035, 0x502F, 0x5031, 0x500E, 0x515A, 0x5194, 	/* 0xD0D8 to 0xD0DF */
0x5193, 0x51CA, 0x51C4, 0x51C5, 0x51C8, 0x51CE, 0x5261, 0x525A, 	/* 0xD0E0 to 0xD0E7 */
0x5252, 0x525E, 0x525F, 0x5255, 0x5262, 0x52CD, 0x530E, 0x539E, 	/* 0xD0E8 to 0xD0EF */
0x5526, 0x54E2, 0x5517, 0x5512, 0x54E7, 0x54F3, 0x54E4, 0x551A, 	/* 0xD0F0 to 0xD0F7 */
0x54FF, 0x5504, 0x5508, 0x54EB, 0x5511, 0x5505, 0x54F1, 0x0000, 	/* 0xD0F8 to 0xD0FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD100 to 0xD107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD108 to 0xD10F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD110 to 0xD117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD118 to 0xD11F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD120 to 0xD127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD128 to 0xD12F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD130 to 0xD137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD138 to 0xD13F */
0x550A, 0x54FB, 0x54F7, 0x54F8, 0x54E0, 0x550E, 0x5503, 0x550B, 	/* 0xD140 to 0xD147 */
0x5701, 0x5702, 0x57CC, 0x5832, 0x57D5, 0x57D2, 0x57BA, 0x57C6, 	/* 0xD148 to 0xD14F */
0x57BD, 0x57BC, 0x57B8, 0x57B6, 0x57BF, 0x57C7, 0x57D0, 0x57B9, 	/* 0xD150 to 0xD157 */
0x57C1, 0x590E, 0x594A, 0x5A19, 0x5A16, 0x5A2D, 0x5A2E, 0x5A15, 	/* 0xD158 to 0xD15F */
0x5A0F, 0x5A17, 0x5A0A, 0x5A1E, 0x5A33, 0x5B6C, 0x5BA7, 0x5BAD, 	/* 0xD160 to 0xD167 */
0x5BAC, 0x5C03, 0x5C56, 0x5C54, 0x5CEC, 0x5CFF, 0x5CEE, 0x5CF1, 	/* 0xD168 to 0xD16F */
0x5CF7, 0x5D00, 0x5CF9, 0x5E29, 0x5E28, 0x5EA8, 0x5EAE, 0x5EAA, 	/* 0xD170 to 0xD177 */
0x5EAC, 0x5F33, 0x5F30, 0x5F67, 0x605D, 0x605A, 0x6067, 0x0000, 	/* 0xD178 to 0xD17F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD180 to 0xD187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD188 to 0xD18F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD190 to 0xD197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD198 to 0xD19F */
0x0000, 0x6041, 0x60A2, 0x6088, 0x6080, 0x6092, 0x6081, 0x609D, 	/* 0xD1A0 to 0xD1A7 */
0x6083, 0x6095, 0x609B, 0x6097, 0x6087, 0x609C, 0x608E, 0x6219, 	/* 0xD1A8 to 0xD1AF */
0x6246, 0x62F2, 0x6310, 0x6356, 0x632C, 0x6344, 0x6345, 0x6336, 	/* 0xD1B0 to 0xD1B7 */
0x6343, 0x63E4, 0x6339, 0x634B, 0x634A, 0x633C, 0x6329, 0x6341, 	/* 0xD1B8 to 0xD1BF */
0x6334, 0x6358, 0x6354, 0x6359, 0x632D, 0x6347, 0x6333, 0x635A, 	/* 0xD1C0 to 0xD1C7 */
0x6351, 0x6338, 0x6357, 0x6340, 0x6348, 0x654A, 0x6546, 0x65C6, 	/* 0xD1C8 to 0xD1CF */
0x65C3, 0x65C4, 0x65C2, 0x664A, 0x665F, 0x6647, 0x6651, 0x6712, 	/* 0xD1D0 to 0xD1D7 */
0x6713, 0x681F, 0x681A, 0x6849, 0x6832, 0x6833, 0x683B, 0x684B, 	/* 0xD1D8 to 0xD1DF */
0x684F, 0x6816, 0x6831, 0x681C, 0x6835, 0x682B, 0x682D, 0x682F, 	/* 0xD1E0 to 0xD1E7 */
0x684E, 0x6844, 0x6834, 0x681D, 0x6812, 0x6814, 0x6826, 0x6828, 	/* 0xD1E8 to 0xD1EF */
0x682E, 0x684D, 0x683A, 0x6825, 0x6820, 0x6B2C, 0x6B2F, 0x6B2D, 	/* 0xD1F0 to 0xD1F7 */
0x6B31, 0x6B34, 0x6B6D, 0x8082, 0x6B88, 0x6BE6, 0x6BE4, 0x0000, 	/* 0xD1F8 to 0xD1FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD200 to 0xD207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD208 to 0xD20F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD210 to 0xD217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD218 to 0xD21F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD220 to 0xD227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD228 to 0xD22F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD230 to 0xD237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD238 to 0xD23F */
0x6BE8, 0x6BE3, 0x6BE2, 0x6BE7, 0x6C25, 0x6D7A, 0x6D63, 0x6D64, 	/* 0xD240 to 0xD247 */
0x6D76, 0x6D0D, 0x6D61, 0x6D92, 0x6D58, 0x6D62, 0x6D6D, 0x6D6F, 	/* 0xD248 to 0xD24F */
0x6D91, 0x6D8D, 0x6DEF, 0x6D7F, 0x6D86, 0x6D5E, 0x6D67, 0x6D60, 	/* 0xD250 to 0xD257 */
0x6D97, 0x6D70, 0x6D7C, 0x6D5F, 0x6D82, 0x6D98, 0x6D2F, 0x6D68, 	/* 0xD258 to 0xD25F */
0x6D8B, 0x6D7E, 0x6D80, 0x6D84, 0x6D16, 0x6D83, 0x6D7B, 0x6D7D, 	/* 0xD260 to 0xD267 */
0x6D75, 0x6D90, 0x70DC, 0x70D3, 0x70D1, 0x70DD, 0x70CB, 0x7F39, 	/* 0xD268 to 0xD26F */
0x70E2, 0x70D7, 0x70D2, 0x70DE, 0x70E0, 0x70D4, 0x70CD, 0x70C5, 	/* 0xD270 to 0xD277 */
0x70C6, 0x70C7, 0x70DA, 0x70CE, 0x70E1, 0x7242, 0x7278, 0x0000, 	/* 0xD278 to 0xD27F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD280 to 0xD287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD288 to 0xD28F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD290 to 0xD297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD298 to 0xD29F */
0x0000, 0x7277, 0x7276, 0x7300, 0x72FA, 0x72F4, 0x72FE, 0x72F6, 	/* 0xD2A0 to 0xD2A7 */
0x72F3, 0x72FB, 0x7301, 0x73D3, 0x73D9, 0x73E5, 0x73D6, 0x73BC, 	/* 0xD2A8 to 0xD2AF */
0x73E7, 0x73E3, 0x73E9, 0x73DC, 0x73D2, 0x73DB, 0x73D4, 0x73DD, 	/* 0xD2B0 to 0xD2B7 */
0x73DA, 0x73D7, 0x73D8, 0x73E8, 0x74DE, 0x74DF, 0x74F4, 0x74F5, 	/* 0xD2B8 to 0xD2BF */
0x7521, 0x755B, 0x755F, 0x75B0, 0x75C1, 0x75BB, 0x75C4, 0x75C0, 	/* 0xD2C0 to 0xD2C7 */
0x75BF, 0x75B6, 0x75BA, 0x768A, 0x76C9, 0x771D, 0x771B, 0x7710, 	/* 0xD2C8 to 0xD2CF */
0x7713, 0x7712, 0x7723, 0x7711, 0x7715, 0x7719, 0x771A, 0x7722, 	/* 0xD2D0 to 0xD2D7 */
0x7727, 0x7823, 0x782C, 0x7822, 0x7835, 0x782F, 0x7828, 0x782E, 	/* 0xD2D8 to 0xD2DF */
0x782B, 0x7821, 0x7829, 0x7833, 0x782A, 0x7831, 0x7954, 0x795B, 	/* 0xD2E0 to 0xD2E7 */
0x794F, 0x795C, 0x7953, 0x7952, 0x7951, 0x79EB, 0x79EC, 0x79E0, 	/* 0xD2E8 to 0xD2EF */
0x79EE, 0x79ED, 0x79EA, 0x79DC, 0x79DE, 0x79DD, 0x7A86, 0x7A89, 	/* 0xD2F0 to 0xD2F7 */
0x7A85, 0x7A8B, 0x7A8C, 0x7A8A, 0x7A87, 0x7AD8, 0x7B10, 0x0000, 	/* 0xD2F8 to 0xD2FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD300 to 0xD307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD308 to 0xD30F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD310 to 0xD317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD318 to 0xD31F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD320 to 0xD327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD328 to 0xD32F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD330 to 0xD337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD338 to 0xD33F */
0x7B04, 0x7B13, 0x7B05, 0x7B0F, 0x7B08, 0x7B0A, 0x7B0E, 0x7B09, 	/* 0xD340 to 0xD347 */
0x7B12, 0x7C84, 0x7C91, 0x7C8A, 0x7C8C, 0x7C88, 0x7C8D, 0x7C85, 	/* 0xD348 to 0xD34F */
0x7D1E, 0x7D1D, 0x7D11, 0x7D0E, 0x7D18, 0x7D16, 0x7D13, 0x7D1F, 	/* 0xD350 to 0xD357 */
0x7D12, 0x7D0F, 0x7D0C, 0x7F5C, 0x7F61, 0x7F5E, 0x7F60, 0x7F5D, 	/* 0xD358 to 0xD35F */
0x7F5B, 0x7F96, 0x7F92, 0x7FC3, 0x7FC2, 0x7FC0, 0x8016, 0x803E, 	/* 0xD360 to 0xD367 */
0x8039, 0x80FA, 0x80F2, 0x80F9, 0x80F5, 0x8101, 0x80FB, 0x8100, 	/* 0xD368 to 0xD36F */
0x8201, 0x822F, 0x8225, 0x8333, 0x832D, 0x8344, 0x8319, 0x8351, 	/* 0xD370 to 0xD377 */
0x8325, 0x8356, 0x833F, 0x8341, 0x8326, 0x831C, 0x8322, 0x0000, 	/* 0xD378 to 0xD37F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD380 to 0xD387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD388 to 0xD38F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD390 to 0xD397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD398 to 0xD39F */
0x0000, 0x8342, 0x834E, 0x831B, 0x832A, 0x8308, 0x833C, 0x834D, 	/* 0xD3A0 to 0xD3A7 */
0x8316, 0x8324, 0x8320, 0x8337, 0x832F, 0x8329, 0x8347, 0x8345, 	/* 0xD3A8 to 0xD3AF */
0x834C, 0x8353, 0x831E, 0x832C, 0x834B, 0x8327, 0x8348, 0x8653, 	/* 0xD3B0 to 0xD3B7 */
0x8652, 0x86A2, 0x86A8, 0x8696, 0x868D, 0x8691, 0x869E, 0x8687, 	/* 0xD3B8 to 0xD3BF */
0x8697, 0x8686, 0x868B, 0x869A, 0x8685, 0x86A5, 0x8699, 0x86A1, 	/* 0xD3C0 to 0xD3C7 */
0x86A7, 0x8695, 0x8698, 0x868E, 0x869D, 0x8690, 0x8694, 0x8843, 	/* 0xD3C8 to 0xD3CF */
0x8844, 0x886D, 0x8875, 0x8876, 0x8872, 0x8880, 0x8871, 0x887F, 	/* 0xD3D0 to 0xD3D7 */
0x886F, 0x8883, 0x887E, 0x8874, 0x887C, 0x8A12, 0x8C47, 0x8C57, 	/* 0xD3D8 to 0xD3DF */
0x8C7B, 0x8CA4, 0x8CA3, 0x8D76, 0x8D78, 0x8DB5, 0x8DB7, 0x8DB6, 	/* 0xD3E0 to 0xD3E7 */
0x8ED1, 0x8ED3, 0x8FFE, 0x8FF5, 0x9002, 0x8FFF, 0x8FFB, 0x9004, 	/* 0xD3E8 to 0xD3EF */
0x8FFC, 0x8FF6, 0x90D6, 0x90E0, 0x90D9, 0x90DA, 0x90E3, 0x90DF, 	/* 0xD3F0 to 0xD3F7 */
0x90E5, 0x90D8, 0x90DB, 0x90D7, 0x90DC, 0x90E4, 0x9150, 0x0000, 	/* 0xD3F8 to 0xD3FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD400 to 0xD407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD408 to 0xD40F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD410 to 0xD417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD418 to 0xD41F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD420 to 0xD427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD428 to 0xD42F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD430 to 0xD437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD438 to 0xD43F */
0x914E, 0x914F, 0x91D5, 0x91E2, 0x91DA, 0x965C, 0x965F, 0x96BC, 	/* 0xD440 to 0xD447 */
0x98E3, 0x9ADF, 0x9B2F, 0x4E7F, 0x5070, 0x506A, 0x5061, 0x505E, 	/* 0xD448 to 0xD44F */
0x5060, 0x5053, 0x504B, 0x505D, 0x5072, 0x5048, 0x504D, 0x5041, 	/* 0xD450 to 0xD457 */
0x505B, 0x504A, 0x5062, 0x5015, 0x5045, 0x505F, 0x5069, 0x506B, 	/* 0xD458 to 0xD45F */
0x5063, 0x5064, 0x5046, 0x5040, 0x506E, 0x5073, 0x5057, 0x5051, 	/* 0xD460 to 0xD467 */
0x51D0, 0x526B, 0x526D, 0x526C, 0x526E, 0x52D6, 0x52D3, 0x532D, 	/* 0xD468 to 0xD46F */
0x539C, 0x5575, 0x5576, 0x553C, 0x554D, 0x5550, 0x5534, 0x552A, 	/* 0xD470 to 0xD477 */
0x5551, 0x5562, 0x5536, 0x5535, 0x5530, 0x5552, 0x5545, 0x0000, 	/* 0xD478 to 0xD47F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD480 to 0xD487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD488 to 0xD48F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD490 to 0xD497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD498 to 0xD49F */
0x0000, 0x550C, 0x5532, 0x5565, 0x554E, 0x5539, 0x5548, 0x552D, 	/* 0xD4A0 to 0xD4A7 */
0x553B, 0x5540, 0x554B, 0x570A, 0x5707, 0x57FB, 0x5814, 0x57E2, 	/* 0xD4A8 to 0xD4AF */
0x57F6, 0x57DC, 0x57F4, 0x5800, 0x57ED, 0x57FD, 0x5808, 0x57F8, 	/* 0xD4B0 to 0xD4B7 */
0x580B, 0x57F3, 0x57CF, 0x5807, 0x57EE, 0x57E3, 0x57F2, 0x57E5, 	/* 0xD4B8 to 0xD4BF */
0x57EC, 0x57E1, 0x580E, 0x57FC, 0x5810, 0x57E7, 0x5801, 0x580C, 	/* 0xD4C0 to 0xD4C7 */
0x57F1, 0x57E9, 0x57F0, 0x580D, 0x5804, 0x595C, 0x5A60, 0x5A58, 	/* 0xD4C8 to 0xD4CF */
0x5A55, 0x5A67, 0x5A5E, 0x5A38, 0x5A35, 0x5A6D, 0x5A50, 0x5A5F, 	/* 0xD4D0 to 0xD4D7 */
0x5A65, 0x5A6C, 0x5A53, 0x5A64, 0x5A57, 0x5A43, 0x5A5D, 0x5A52, 	/* 0xD4D8 to 0xD4DF */
0x5A44, 0x5A5B, 0x5A48, 0x5A8E, 0x5A3E, 0x5A4D, 0x5A39, 0x5A4C, 	/* 0xD4E0 to 0xD4E7 */
0x5A70, 0x5A69, 0x5A47, 0x5A51, 0x5A56, 0x5A42, 0x5A5C, 0x5B72, 	/* 0xD4E8 to 0xD4EF */
0x5B6E, 0x5BC1, 0x5BC0, 0x5C59, 0x5D1E, 0x5D0B, 0x5D1D, 0x5D1A, 	/* 0xD4F0 to 0xD4F7 */
0x5D20, 0x5D0C, 0x5D28, 0x5D0D, 0x5D26, 0x5D25, 0x5D0F, 0x0000, 	/* 0xD4F8 to 0xD4FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD500 to 0xD507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD508 to 0xD50F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD510 to 0xD517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD518 to 0xD51F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD520 to 0xD527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD528 to 0xD52F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD530 to 0xD537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD538 to 0xD53F */
0x5D30, 0x5D12, 0x5D23, 0x5D1F, 0x5D2E, 0x5E3E, 0x5E34, 0x5EB1, 	/* 0xD540 to 0xD547 */
0x5EB4, 0x5EB9, 0x5EB2, 0x5EB3, 0x5F36, 0x5F38, 0x5F9B, 0x5F96, 	/* 0xD548 to 0xD54F */
0x5F9F, 0x608A, 0x6090, 0x6086, 0x60BE, 0x60B0, 0x60BA, 0x60D3, 	/* 0xD550 to 0xD557 */
0x60D4, 0x60CF, 0x60E4, 0x60D9, 0x60DD, 0x60C8, 0x60B1, 0x60DB, 	/* 0xD558 to 0xD55F */
0x60B7, 0x60CA, 0x60BF, 0x60C3, 0x60CD, 0x60C0, 0x6332, 0x6365, 	/* 0xD560 to 0xD567 */
0x638A, 0x6382, 0x637D, 0x63BD, 0x639E, 0x63AD, 0x639D, 0x6397, 	/* 0xD568 to 0xD56F */
0x63AB, 0x638E, 0x636F, 0x6387, 0x6390, 0x636E, 0x63AF, 0x6375, 	/* 0xD570 to 0xD577 */
0x639C, 0x636D, 0x63AE, 0x637C, 0x63A4, 0x633B, 0x639F, 0x0000, 	/* 0xD578 to 0xD57F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD580 to 0xD587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD588 to 0xD58F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD590 to 0xD597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD598 to 0xD59F */
0x0000, 0x6378, 0x6385, 0x6381, 0x6391, 0x638D, 0x6370, 0x6553, 	/* 0xD5A0 to 0xD5A7 */
0x65CD, 0x6665, 0x6661, 0x665B, 0x6659, 0x665C, 0x6662, 0x6718, 	/* 0xD5A8 to 0xD5AF */
0x6879, 0x6887, 0x6890, 0x689C, 0x686D, 0x686E, 0x68AE, 0x68AB, 	/* 0xD5B0 to 0xD5B7 */
0x6956, 0x686F, 0x68A3, 0x68AC, 0x68A9, 0x6875, 0x6874, 0x68B2, 	/* 0xD5B8 to 0xD5BF */
0x688F, 0x6877, 0x6892, 0x687C, 0x686B, 0x6872, 0x68AA, 0x6880, 	/* 0xD5C0 to 0xD5C7 */
0x6871, 0x687E, 0x689B, 0x6896, 0x688B, 0x68A0, 0x6889, 0x68A4, 	/* 0xD5C8 to 0xD5CF */
0x6878, 0x687B, 0x6891, 0x688C, 0x688A, 0x687D, 0x6B36, 0x6B33, 	/* 0xD5D0 to 0xD5D7 */
0x6B37, 0x6B38, 0x6B91, 0x6B8F, 0x6B8D, 0x6B8E, 0x6B8C, 0x6C2A, 	/* 0xD5D8 to 0xD5DF */
0x6DC0, 0x6DAB, 0x6DB4, 0x6DB3, 0x6E74, 0x6DAC, 0x6DE9, 0x6DE2, 	/* 0xD5E0 to 0xD5E7 */
0x6DB7, 0x6DF6, 0x6DD4, 0x6E00, 0x6DC8, 0x6DE0, 0x6DDF, 0x6DD6, 	/* 0xD5E8 to 0xD5EF */
0x6DBE, 0x6DE5, 0x6DDC, 0x6DDD, 0x6DDB, 0x6DF4, 0x6DCA, 0x6DBD, 	/* 0xD5F0 to 0xD5F7 */
0x6DED, 0x6DF0, 0x6DBA, 0x6DD5, 0x6DC2, 0x6DCF, 0x6DC9, 0x0000, 	/* 0xD5F8 to 0xD5FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD600 to 0xD607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD608 to 0xD60F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD610 to 0xD617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD618 to 0xD61F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD620 to 0xD627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD628 to 0xD62F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD630 to 0xD637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD638 to 0xD63F */
0x6DD0, 0x6DF2, 0x6DD3, 0x6DFD, 0x6DD7, 0x6DCD, 0x6DE3, 0x6DBB, 	/* 0xD640 to 0xD647 */
0x70FA, 0x710D, 0x70F7, 0x7117, 0x70F4, 0x710C, 0x70F0, 0x7104, 	/* 0xD648 to 0xD64F */
0x70F3, 0x7110, 0x70FC, 0x70FF, 0x7106, 0x7113, 0x7100, 0x70F8, 	/* 0xD650 to 0xD657 */
0x70F6, 0x710B, 0x7102, 0x710E, 0x727E, 0x727B, 0x727C, 0x727F, 	/* 0xD658 to 0xD65F */
0x731D, 0x7317, 0x7307, 0x7311, 0x7318, 0x730A, 0x7308, 0x72FF, 	/* 0xD660 to 0xD667 */
0x730F, 0x731E, 0x7388, 0x73F6, 0x73F8, 0x73F5, 0x7404, 0x7401, 	/* 0xD668 to 0xD66F */
0x73FD, 0x7407, 0x7400, 0x73FA, 0x73FC, 0x73FF, 0x740C, 0x740B, 	/* 0xD670 to 0xD677 */
0x73F4, 0x7408, 0x7564, 0x7563, 0x75CE, 0x75D2, 0x75CF, 0x0000, 	/* 0xD678 to 0xD67F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD680 to 0xD687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD688 to 0xD68F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD690 to 0xD697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD698 to 0xD69F */
0x0000, 0x75CB, 0x75CC, 0x75D1, 0x75D0, 0x768F, 0x7689, 0x76D3, 	/* 0xD6A0 to 0xD6A7 */
0x7739, 0x772F, 0x772D, 0x7731, 0x7732, 0x7734, 0x7733, 0x773D, 	/* 0xD6A8 to 0xD6AF */
0x7725, 0x773B, 0x7735, 0x7848, 0x7852, 0x7849, 0x784D, 0x784A, 	/* 0xD6B0 to 0xD6B7 */
0x784C, 0x7826, 0x7845, 0x7850, 0x7964, 0x7967, 0x7969, 0x796A, 	/* 0xD6B8 to 0xD6BF */
0x7963, 0x796B, 0x7961, 0x79BB, 0x79FA, 0x79F8, 0x79F6, 0x79F7, 	/* 0xD6C0 to 0xD6C7 */
0x7A8F, 0x7A94, 0x7A90, 0x7B35, 0x7B47, 0x7B34, 0x7B25, 0x7B30, 	/* 0xD6C8 to 0xD6CF */
0x7B22, 0x7B24, 0x7B33, 0x7B18, 0x7B2A, 0x7B1D, 0x7B31, 0x7B2B, 	/* 0xD6D0 to 0xD6D7 */
0x7B2D, 0x7B2F, 0x7B32, 0x7B38, 0x7B1A, 0x7B23, 0x7C94, 0x7C98, 	/* 0xD6D8 to 0xD6DF */
0x7C96, 0x7CA3, 0x7D35, 0x7D3D, 0x7D38, 0x7D36, 0x7D3A, 0x7D45, 	/* 0xD6E0 to 0xD6E7 */
0x7D2C, 0x7D29, 0x7D41, 0x7D47, 0x7D3E, 0x7D3F, 0x7D4A, 0x7D3B, 	/* 0xD6E8 to 0xD6EF */
0x7D28, 0x7F63, 0x7F95, 0x7F9C, 0x7F9D, 0x7F9B, 0x7FCA, 0x7FCB, 	/* 0xD6F0 to 0xD6F7 */
0x7FCD, 0x7FD0, 0x7FD1, 0x7FC7, 0x7FCF, 0x7FC9, 0x801F, 0x0000, 	/* 0xD6F8 to 0xD6FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD700 to 0xD707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD708 to 0xD70F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD710 to 0xD717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD718 to 0xD71F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD720 to 0xD727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD728 to 0xD72F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD730 to 0xD737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD738 to 0xD73F */
0x801E, 0x801B, 0x8047, 0x8043, 0x8048, 0x8118, 0x8125, 0x8119, 	/* 0xD740 to 0xD747 */
0x811B, 0x812D, 0x811F, 0x812C, 0x811E, 0x8121, 0x8115, 0x8127, 	/* 0xD748 to 0xD74F */
0x811D, 0x8122, 0x8211, 0x8238, 0x8233, 0x823A, 0x8234, 0x8232, 	/* 0xD750 to 0xD757 */
0x8274, 0x8390, 0x83A3, 0x83A8, 0x838D, 0x837A, 0x8373, 0x83A4, 	/* 0xD758 to 0xD75F */
0x8374, 0x838F, 0x8381, 0x8395, 0x8399, 0x8375, 0x8394, 0x83A9, 	/* 0xD760 to 0xD767 */
0x837D, 0x8383, 0x838C, 0x839D, 0x839B, 0x83AA, 0x838B, 0x837E, 	/* 0xD768 to 0xD76F */
0x83A5, 0x83AF, 0x8388, 0x8397, 0x83B0, 0x837F, 0x83A6, 0x8387, 	/* 0xD770 to 0xD777 */
0x83AE, 0x8376, 0x839A, 0x8659, 0x8656, 0x86BF, 0x86B7, 0x0000, 	/* 0xD778 to 0xD77F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD780 to 0xD787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD788 to 0xD78F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD790 to 0xD797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD798 to 0xD79F */
0x0000, 0x86C2, 0x86C1, 0x86C5, 0x86BA, 0x86B0, 0x86C8, 0x86B9, 	/* 0xD7A0 to 0xD7A7 */
0x86B3, 0x86B8, 0x86CC, 0x86B4, 0x86BB, 0x86BC, 0x86C3, 0x86BD, 	/* 0xD7A8 to 0xD7AF */
0x86BE, 0x8852, 0x8889, 0x8895, 0x88A8, 0x88A2, 0x88AA, 0x889A, 	/* 0xD7B0 to 0xD7B7 */
0x8891, 0x88A1, 0x889F, 0x8898, 0x88A7, 0x8899, 0x889B, 0x8897, 	/* 0xD7B8 to 0xD7BF */
0x88A4, 0x88AC, 0x888C, 0x8893, 0x888E, 0x8982, 0x89D6, 0x89D9, 	/* 0xD7C0 to 0xD7C7 */
0x89D5, 0x8A30, 0x8A27, 0x8A2C, 0x8A1E, 0x8C39, 0x8C3B, 0x8C5C, 	/* 0xD7C8 to 0xD7CF */
0x8C5D, 0x8C7D, 0x8CA5, 0x8D7D, 0x8D7B, 0x8D79, 0x8DBC, 0x8DC2, 	/* 0xD7D0 to 0xD7D7 */
0x8DB9, 0x8DBF, 0x8DC1, 0x8ED8, 0x8EDE, 0x8EDD, 0x8EDC, 0x8ED7, 	/* 0xD7D8 to 0xD7DF */
0x8EE0, 0x8EE1, 0x9024, 0x900B, 0x9011, 0x901C, 0x900C, 0x9021, 	/* 0xD7E0 to 0xD7E7 */
0x90EF, 0x90EA, 0x90F0, 0x90F4, 0x90F2, 0x90F3, 0x90D4, 0x90EB, 	/* 0xD7E8 to 0xD7EF */
0x90EC, 0x90E9, 0x9156, 0x9158, 0x915A, 0x9153, 0x9155, 0x91EC, 	/* 0xD7F0 to 0xD7F7 */
0x91F4, 0x91F1, 0x91F3, 0x91F8, 0x91E4, 0x91F9, 0x91EA, 0x0000, 	/* 0xD7F8 to 0xD7FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD800 to 0xD807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD808 to 0xD80F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD810 to 0xD817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD818 to 0xD81F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD820 to 0xD827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD828 to 0xD82F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD830 to 0xD837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD838 to 0xD83F */
0x91EB, 0x91F7, 0x91E8, 0x91EE, 0x957A, 0x9586, 0x9588, 0x967C, 	/* 0xD840 to 0xD847 */
0x966D, 0x966B, 0x9671, 0x966F, 0x96BF, 0x976A, 0x9804, 0x98E5, 	/* 0xD848 to 0xD84F */
0x9997, 0x509B, 0x5095, 0x5094, 0x509E, 0x508B, 0x50A3, 0x5083, 	/* 0xD850 to 0xD857 */
0x508C, 0x508E, 0x509D, 0x5068, 0x509C, 0x5092, 0x5082, 0x5087, 	/* 0xD858 to 0xD85F */
0x515F, 0x51D4, 0x5312, 0x5311, 0x53A4, 0x53A7, 0x5591, 0x55A8, 	/* 0xD860 to 0xD867 */
0x55A5, 0x55AD, 0x5577, 0x5645, 0x55A2, 0x5593, 0x5588, 0x558F, 	/* 0xD868 to 0xD86F */
0x55B5, 0x5581, 0x55A3, 0x5592, 0x55A4, 0x557D, 0x558C, 0x55A6, 	/* 0xD870 to 0xD877 */
0x557F, 0x5595, 0x55A1, 0x558E, 0x570C, 0x5829, 0x5837, 0x0000, 	/* 0xD878 to 0xD87F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD880 to 0xD887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD888 to 0xD88F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD890 to 0xD897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD898 to 0xD89F */
0x0000, 0x5819, 0x581E, 0x5827, 0x5823, 0x5828, 0x57F5, 0x5848, 	/* 0xD8A0 to 0xD8A7 */
0x5825, 0x581C, 0x581B, 0x5833, 0x583F, 0x5836, 0x582E, 0x5839, 	/* 0xD8A8 to 0xD8AF */
0x5838, 0x582D, 0x582C, 0x583B, 0x5961, 0x5AAF, 0x5A94, 0x5A9F, 	/* 0xD8B0 to 0xD8B7 */
0x5A7A, 0x5AA2, 0x5A9E, 0x5A78, 0x5AA6, 0x5A7C, 0x5AA5, 0x5AAC, 	/* 0xD8B8 to 0xD8BF */
0x5A95, 0x5AAE, 0x5A37, 0x5A84, 0x5A8A, 0x5A97, 0x5A83, 0x5A8B, 	/* 0xD8C0 to 0xD8C7 */
0x5AA9, 0x5A7B, 0x5A7D, 0x5A8C, 0x5A9C, 0x5A8F, 0x5A93, 0x5A9D, 	/* 0xD8C8 to 0xD8CF */
0x5BEA, 0x5BCD, 0x5BCB, 0x5BD4, 0x5BD1, 0x5BCA, 0x5BCE, 0x5C0C, 	/* 0xD8D0 to 0xD8D7 */
0x5C30, 0x5D37, 0x5D43, 0x5D6B, 0x5D41, 0x5D4B, 0x5D3F, 0x5D35, 	/* 0xD8D8 to 0xD8DF */
0x5D51, 0x5D4E, 0x5D55, 0x5D33, 0x5D3A, 0x5D52, 0x5D3D, 0x5D31, 	/* 0xD8E0 to 0xD8E7 */
0x5D59, 0x5D42, 0x5D39, 0x5D49, 0x5D38, 0x5D3C, 0x5D32, 0x5D36, 	/* 0xD8E8 to 0xD8EF */
0x5D40, 0x5D45, 0x5E44, 0x5E41, 0x5F58, 0x5FA6, 0x5FA5, 0x5FAB, 	/* 0xD8F0 to 0xD8F7 */
0x60C9, 0x60B9, 0x60CC, 0x60E2, 0x60CE, 0x60C4, 0x6114, 0x0000, 	/* 0xD8F8 to 0xD8FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD900 to 0xD907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD908 to 0xD90F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD910 to 0xD917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD918 to 0xD91F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD920 to 0xD927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD928 to 0xD92F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD930 to 0xD937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD938 to 0xD93F */
0x60F2, 0x610A, 0x6116, 0x6105, 0x60F5, 0x6113, 0x60F8, 0x60FC, 	/* 0xD940 to 0xD947 */
0x60FE, 0x60C1, 0x6103, 0x6118, 0x611D, 0x6110, 0x60FF, 0x6104, 	/* 0xD948 to 0xD94F */
0x610B, 0x624A, 0x6394, 0x63B1, 0x63B0, 0x63CE, 0x63E5, 0x63E8, 	/* 0xD950 to 0xD957 */
0x63EF, 0x63C3, 0x649D, 0x63F3, 0x63CA, 0x63E0, 0x63F6, 0x63D5, 	/* 0xD958 to 0xD95F */
0x63F2, 0x63F5, 0x6461, 0x63DF, 0x63BE, 0x63DD, 0x63DC, 0x63C4, 	/* 0xD960 to 0xD967 */
0x63D8, 0x63D3, 0x63C2, 0x63C7, 0x63CC, 0x63CB, 0x63C8, 0x63F0, 	/* 0xD968 to 0xD96F */
0x63D7, 0x63D9, 0x6532, 0x6567, 0x656A, 0x6564, 0x655C, 0x6568, 	/* 0xD970 to 0xD977 */
0x6565, 0x658C, 0x659D, 0x659E, 0x65AE, 0x65D0, 0x65D2, 0x0000, 	/* 0xD978 to 0xD97F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD980 to 0xD987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD988 to 0xD98F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD990 to 0xD997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xD998 to 0xD99F */
0x0000, 0x667C, 0x666C, 0x667B, 0x6680, 0x6671, 0x6679, 0x666A, 	/* 0xD9A0 to 0xD9A7 */
0x6672, 0x6701, 0x690C, 0x68D3, 0x6904, 0x68DC, 0x692A, 0x68EC, 	/* 0xD9A8 to 0xD9AF */
0x68EA, 0x68F1, 0x690F, 0x68D6, 0x68F7, 0x68EB, 0x68E4, 0x68F6, 	/* 0xD9B0 to 0xD9B7 */
0x6913, 0x6910, 0x68F3, 0x68E1, 0x6907, 0x68CC, 0x6908, 0x6970, 	/* 0xD9B8 to 0xD9BF */
0x68B4, 0x6911, 0x68EF, 0x68C6, 0x6914, 0x68F8, 0x68D0, 0x68FD, 	/* 0xD9C0 to 0xD9C7 */
0x68FC, 0x68E8, 0x690B, 0x690A, 0x6917, 0x68CE, 0x68C8, 0x68DD, 	/* 0xD9C8 to 0xD9CF */
0x68DE, 0x68E6, 0x68F4, 0x68D1, 0x6906, 0x68D4, 0x68E9, 0x6915, 	/* 0xD9D0 to 0xD9D7 */
0x6925, 0x68C7, 0x6B39, 0x6B3B, 0x6B3F, 0x6B3C, 0x6B94, 0x6B97, 	/* 0xD9D8 to 0xD9DF */
0x6B99, 0x6B95, 0x6BBD, 0x6BF0, 0x6BF2, 0x6BF3, 0x6C30, 0x6DFC, 	/* 0xD9E0 to 0xD9E7 */
0x6E46, 0x6E47, 0x6E1F, 0x6E49, 0x6E88, 0x6E3C, 0x6E3D, 0x6E45, 	/* 0xD9E8 to 0xD9EF */
0x6E62, 0x6E2B, 0x6E3F, 0x6E41, 0x6E5D, 0x6E73, 0x6E1C, 0x6E33, 	/* 0xD9F0 to 0xD9F7 */
0x6E4B, 0x6E40, 0x6E51, 0x6E3B, 0x6E03, 0x6E2E, 0x6E5E, 0x0000, 	/* 0xD9F8 to 0xD9FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA00 to 0xDA07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA08 to 0xDA0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA10 to 0xDA17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA18 to 0xDA1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA20 to 0xDA27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA28 to 0xDA2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA30 to 0xDA37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA38 to 0xDA3F */
0x6E68, 0x6E5C, 0x6E61, 0x6E31, 0x6E28, 0x6E60, 0x6E71, 0x6E6B, 	/* 0xDA40 to 0xDA47 */
0x6E39, 0x6E22, 0x6E30, 0x6E53, 0x6E65, 0x6E27, 0x6E78, 0x6E64, 	/* 0xDA48 to 0xDA4F */
0x6E77, 0x6E55, 0x6E79, 0x6E52, 0x6E66, 0x6E35, 0x6E36, 0x6E5A, 	/* 0xDA50 to 0xDA57 */
0x7120, 0x711E, 0x712F, 0x70FB, 0x712E, 0x7131, 0x7123, 0x7125, 	/* 0xDA58 to 0xDA5F */
0x7122, 0x7132, 0x711F, 0x7128, 0x713A, 0x711B, 0x724B, 0x725A, 	/* 0xDA60 to 0xDA67 */
0x7288, 0x7289, 0x7286, 0x7285, 0x728B, 0x7312, 0x730B, 0x7330, 	/* 0xDA68 to 0xDA6F */
0x7322, 0x7331, 0x7333, 0x7327, 0x7332, 0x732D, 0x7326, 0x7323, 	/* 0xDA70 to 0xDA77 */
0x7335, 0x730C, 0x742E, 0x742C, 0x7430, 0x742B, 0x7416, 0x0000, 	/* 0xDA78 to 0xDA7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA80 to 0xDA87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA88 to 0xDA8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA90 to 0xDA97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDA98 to 0xDA9F */
0x0000, 0x741A, 0x7421, 0x742D, 0x7431, 0x7424, 0x7423, 0x741D, 	/* 0xDAA0 to 0xDAA7 */
0x7429, 0x7420, 0x7432, 0x74FB, 0x752F, 0x756F, 0x756C, 0x75E7, 	/* 0xDAA8 to 0xDAAF */
0x75DA, 0x75E1, 0x75E6, 0x75DD, 0x75DF, 0x75E4, 0x75D7, 0x7695, 	/* 0xDAB0 to 0xDAB7 */
0x7692, 0x76DA, 0x7746, 0x7747, 0x7744, 0x774D, 0x7745, 0x774A, 	/* 0xDAB8 to 0xDABF */
0x774E, 0x774B, 0x774C, 0x77DE, 0x77EC, 0x7860, 0x7864, 0x7865, 	/* 0xDAC0 to 0xDAC7 */
0x785C, 0x786D, 0x7871, 0x786A, 0x786E, 0x7870, 0x7869, 0x7868, 	/* 0xDAC8 to 0xDACF */
0x785E, 0x7862, 0x7974, 0x7973, 0x7972, 0x7970, 0x7A02, 0x7A0A, 	/* 0xDAD0 to 0xDAD7 */
0x7A03, 0x7A0C, 0x7A04, 0x7A99, 0x7AE6, 0x7AE4, 0x7B4A, 0x7B3B, 	/* 0xDAD8 to 0xDADF */
0x7B44, 0x7B48, 0x7B4C, 0x7B4E, 0x7B40, 0x7B58, 0x7B45, 0x7CA2, 	/* 0xDAE0 to 0xDAE7 */
0x7C9E, 0x7CA8, 0x7CA1, 0x7D58, 0x7D6F, 0x7D63, 0x7D53, 0x7D56, 	/* 0xDAE8 to 0xDAEF */
0x7D67, 0x7D6A, 0x7D4F, 0x7D6D, 0x7D5C, 0x7D6B, 0x7D52, 0x7D54, 	/* 0xDAF0 to 0xDAF7 */
0x7D69, 0x7D51, 0x7D5F, 0x7D4E, 0x7F3E, 0x7F3F, 0x7F65, 0x0000, 	/* 0xDAF8 to 0xDAFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB00 to 0xDB07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB08 to 0xDB0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB10 to 0xDB17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB18 to 0xDB1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB20 to 0xDB27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB28 to 0xDB2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB30 to 0xDB37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB38 to 0xDB3F */
0x7F66, 0x7FA2, 0x7FA0, 0x7FA1, 0x7FD7, 0x8051, 0x804F, 0x8050, 	/* 0xDB40 to 0xDB47 */
0x80FE, 0x80D4, 0x8143, 0x814A, 0x8152, 0x814F, 0x8147, 0x813D, 	/* 0xDB48 to 0xDB4F */
0x814D, 0x813A, 0x81E6, 0x81EE, 0x81F7, 0x81F8, 0x81F9, 0x8204, 	/* 0xDB50 to 0xDB57 */
0x823C, 0x823D, 0x823F, 0x8275, 0x833B, 0x83CF, 0x83F9, 0x8423, 	/* 0xDB58 to 0xDB5F */
0x83C0, 0x83E8, 0x8412, 0x83E7, 0x83E4, 0x83FC, 0x83F6, 0x8410, 	/* 0xDB60 to 0xDB67 */
0x83C6, 0x83C8, 0x83EB, 0x83E3, 0x83BF, 0x8401, 0x83DD, 0x83E5, 	/* 0xDB68 to 0xDB6F */
0x83D8, 0x83FF, 0x83E1, 0x83CB, 0x83CE, 0x83D6, 0x83F5, 0x83C9, 	/* 0xDB70 to 0xDB77 */
0x8409, 0x840F, 0x83DE, 0x8411, 0x8406, 0x83C2, 0x83F3, 0x0000, 	/* 0xDB78 to 0xDB7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB80 to 0xDB87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB88 to 0xDB8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB90 to 0xDB97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDB98 to 0xDB9F */
0x0000, 0x83D5, 0x83FA, 0x83C7, 0x83D1, 0x83EA, 0x8413, 0x83C3, 	/* 0xDBA0 to 0xDBA7 */
0x83EC, 0x83EE, 0x83C4, 0x83FB, 0x83D7, 0x83E2, 0x841B, 0x83DB, 	/* 0xDBA8 to 0xDBAF */
0x83FE, 0x86D8, 0x86E2, 0x86E6, 0x86D3, 0x86E3, 0x86DA, 0x86EA, 	/* 0xDBB0 to 0xDBB7 */
0x86DD, 0x86EB, 0x86DC, 0x86EC, 0x86E9, 0x86D7, 0x86E8, 0x86D1, 	/* 0xDBB8 to 0xDBBF */
0x8848, 0x8856, 0x8855, 0x88BA, 0x88D7, 0x88B9, 0x88B8, 0x88C0, 	/* 0xDBC0 to 0xDBC7 */
0x88BE, 0x88B6, 0x88BC, 0x88B7, 0x88BD, 0x88B2, 0x8901, 0x88C9, 	/* 0xDBC8 to 0xDBCF */
0x8995, 0x8998, 0x8997, 0x89DD, 0x89DA, 0x89DB, 0x8A4E, 0x8A4D, 	/* 0xDBD0 to 0xDBD7 */
0x8A39, 0x8A59, 0x8A40, 0x8A57, 0x8A58, 0x8A44, 0x8A45, 0x8A52, 	/* 0xDBD8 to 0xDBDF */
0x8A48, 0x8A51, 0x8A4A, 0x8A4C, 0x8A4F, 0x8C5F, 0x8C81, 0x8C80, 	/* 0xDBE0 to 0xDBE7 */
0x8CBA, 0x8CBE, 0x8CB0, 0x8CB9, 0x8CB5, 0x8D84, 0x8D80, 0x8D89, 	/* 0xDBE8 to 0xDBEF */
0x8DD8, 0x8DD3, 0x8DCD, 0x8DC7, 0x8DD6, 0x8DDC, 0x8DCF, 0x8DD5, 	/* 0xDBF0 to 0xDBF7 */
0x8DD9, 0x8DC8, 0x8DD7, 0x8DC5, 0x8EEF, 0x8EF7, 0x8EFA, 0x0000, 	/* 0xDBF8 to 0xDBFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC00 to 0xDC07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC08 to 0xDC0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC10 to 0xDC17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC18 to 0xDC1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC20 to 0xDC27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC28 to 0xDC2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC30 to 0xDC37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC38 to 0xDC3F */
0x8EF9, 0x8EE6, 0x8EEE, 0x8EE5, 0x8EF5, 0x8EE7, 0x8EE8, 0x8EF6, 	/* 0xDC40 to 0xDC47 */
0x8EEB, 0x8EF1, 0x8EEC, 0x8EF4, 0x8EE9, 0x902D, 0x9034, 0x902F, 	/* 0xDC48 to 0xDC4F */
0x9106, 0x912C, 0x9104, 0x90FF, 0x90FC, 0x9108, 0x90F9, 0x90FB, 	/* 0xDC50 to 0xDC57 */
0x9101, 0x9100, 0x9107, 0x9105, 0x9103, 0x9161, 0x9164, 0x915F, 	/* 0xDC58 to 0xDC5F */
0x9162, 0x9160, 0x9201, 0x920A, 0x9225, 0x9203, 0x921A, 0x9226, 	/* 0xDC60 to 0xDC67 */
0x920F, 0x920C, 0x9200, 0x9212, 0x91FF, 0x91FD, 0x9206, 0x9204, 	/* 0xDC68 to 0xDC6F */
0x9227, 0x9202, 0x921C, 0x9224, 0x9219, 0x9217, 0x9205, 0x9216, 	/* 0xDC70 to 0xDC77 */
0x957B, 0x958D, 0x958C, 0x9590, 0x9687, 0x967E, 0x9688, 0x0000, 	/* 0xDC78 to 0xDC7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC80 to 0xDC87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC88 to 0xDC8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC90 to 0xDC97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDC98 to 0xDC9F */
0x0000, 0x9689, 0x9683, 0x9680, 0x96C2, 0x96C8, 0x96C3, 0x96F1, 	/* 0xDCA0 to 0xDCA7 */
0x96F0, 0x976C, 0x9770, 0x976E, 0x9807, 0x98A9, 0x98EB, 0x9CE6, 	/* 0xDCA8 to 0xDCAF */
0x9EF9, 0x4E83, 0x4E84, 0x4EB6, 0x50BD, 0x50BF, 0x50C6, 0x50AE, 	/* 0xDCB0 to 0xDCB7 */
0x50C4, 0x50CA, 0x50B4, 0x50C8, 0x50C2, 0x50B0, 0x50C1, 0x50BA, 	/* 0xDCB8 to 0xDCBF */
0x50B1, 0x50CB, 0x50C9, 0x50B6, 0x50B8, 0x51D7, 0x527A, 0x5278, 	/* 0xDCC0 to 0xDCC7 */
0x527B, 0x527C, 0x55C3, 0x55DB, 0x55CC, 0x55D0, 0x55CB, 0x55CA, 	/* 0xDCC8 to 0xDCCF */
0x55DD, 0x55C0, 0x55D4, 0x55C4, 0x55E9, 0x55BF, 0x55D2, 0x558D, 	/* 0xDCD0 to 0xDCD7 */
0x55CF, 0x55D5, 0x55E2, 0x55D6, 0x55C8, 0x55F2, 0x55CD, 0x55D9, 	/* 0xDCD8 to 0xDCDF */
0x55C2, 0x5714, 0x5853, 0x5868, 0x5864, 0x584F, 0x584D, 0x5849, 	/* 0xDCE0 to 0xDCE7 */
0x586F, 0x5855, 0x584E, 0x585D, 0x5859, 0x5865, 0x585B, 0x583D, 	/* 0xDCE8 to 0xDCEF */
0x5863, 0x5871, 0x58FC, 0x5AC7, 0x5AC4, 0x5ACB, 0x5ABA, 0x5AB8, 	/* 0xDCF0 to 0xDCF7 */
0x5AB1, 0x5AB5, 0x5AB0, 0x5ABF, 0x5AC8, 0x5ABB, 0x5AC6, 0x0000, 	/* 0xDCF8 to 0xDCFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD00 to 0xDD07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD08 to 0xDD0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD10 to 0xDD17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD18 to 0xDD1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD20 to 0xDD27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD28 to 0xDD2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD30 to 0xDD37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD38 to 0xDD3F */
0x5AB7, 0x5AC0, 0x5ACA, 0x5AB4, 0x5AB6, 0x5ACD, 0x5AB9, 0x5A90, 	/* 0xDD40 to 0xDD47 */
0x5BD6, 0x5BD8, 0x5BD9, 0x5C1F, 0x5C33, 0x5D71, 0x5D63, 0x5D4A, 	/* 0xDD48 to 0xDD4F */
0x5D65, 0x5D72, 0x5D6C, 0x5D5E, 0x5D68, 0x5D67, 0x5D62, 0x5DF0, 	/* 0xDD50 to 0xDD57 */
0x5E4F, 0x5E4E, 0x5E4A, 0x5E4D, 0x5E4B, 0x5EC5, 0x5ECC, 0x5EC6, 	/* 0xDD58 to 0xDD5F */
0x5ECB, 0x5EC7, 0x5F40, 0x5FAF, 0x5FAD, 0x60F7, 0x6149, 0x614A, 	/* 0xDD60 to 0xDD67 */
0x612B, 0x6145, 0x6136, 0x6132, 0x612E, 0x6146, 0x612F, 0x614F, 	/* 0xDD68 to 0xDD6F */
0x6129, 0x6140, 0x6220, 0x9168, 0x6223, 0x6225, 0x6224, 0x63C5, 	/* 0xDD70 to 0xDD77 */
0x63F1, 0x63EB, 0x6410, 0x6412, 0x6409, 0x6420, 0x6424, 0x0000, 	/* 0xDD78 to 0xDD7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD80 to 0xDD87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD88 to 0xDD8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD90 to 0xDD97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDD98 to 0xDD9F */
0x0000, 0x6433, 0x6443, 0x641F, 0x6415, 0x6418, 0x6439, 0x6437, 	/* 0xDDA0 to 0xDDA7 */
0x6422, 0x6423, 0x640C, 0x6426, 0x6430, 0x6428, 0x6441, 0x6435, 	/* 0xDDA8 to 0xDDAF */
0x642F, 0x640A, 0x641A, 0x6440, 0x6425, 0x6427, 0x640B, 0x63E7, 	/* 0xDDB0 to 0xDDB7 */
0x641B, 0x642E, 0x6421, 0x640E, 0x656F, 0x6592, 0x65D3, 0x6686, 	/* 0xDDB8 to 0xDDBF */
0x668C, 0x6695, 0x6690, 0x668B, 0x668A, 0x6699, 0x6694, 0x6678, 	/* 0xDDC0 to 0xDDC7 */
0x6720, 0x6966, 0x695F, 0x6938, 0x694E, 0x6962, 0x6971, 0x693F, 	/* 0xDDC8 to 0xDDCF */
0x6945, 0x696A, 0x6939, 0x6942, 0x6957, 0x6959, 0x697A, 0x6948, 	/* 0xDDD0 to 0xDDD7 */
0x6949, 0x6935, 0x696C, 0x6933, 0x693D, 0x6965, 0x68F0, 0x6978, 	/* 0xDDD8 to 0xDDDF */
0x6934, 0x6969, 0x6940, 0x696F, 0x6944, 0x6976, 0x6958, 0x6941, 	/* 0xDDE0 to 0xDDE7 */
0x6974, 0x694C, 0x693B, 0x694B, 0x6937, 0x695C, 0x694F, 0x6951, 	/* 0xDDE8 to 0xDDEF */
0x6932, 0x6952, 0x692F, 0x697B, 0x693C, 0x6B46, 0x6B45, 0x6B43, 	/* 0xDDF0 to 0xDDF7 */
0x6B42, 0x6B48, 0x6B41, 0x6B9B, 0xFA0D, 0x6BFB, 0x6BFC, 0x0000, 	/* 0xDDF8 to 0xDDFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE00 to 0xDE07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE08 to 0xDE0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE10 to 0xDE17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE18 to 0xDE1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE20 to 0xDE27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE28 to 0xDE2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE30 to 0xDE37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE38 to 0xDE3F */
0x6BF9, 0x6BF7, 0x6BF8, 0x6E9B, 0x6ED6, 0x6EC8, 0x6E8F, 0x6EC0, 	/* 0xDE40 to 0xDE47 */
0x6E9F, 0x6E93, 0x6E94, 0x6EA0, 0x6EB1, 0x6EB9, 0x6EC6, 0x6ED2, 	/* 0xDE48 to 0xDE4F */
0x6EBD, 0x6EC1, 0x6E9E, 0x6EC9, 0x6EB7, 0x6EB0, 0x6ECD, 0x6EA6, 	/* 0xDE50 to 0xDE57 */
0x6ECF, 0x6EB2, 0x6EBE, 0x6EC3, 0x6EDC, 0x6ED8, 0x6E99, 0x6E92, 	/* 0xDE58 to 0xDE5F */
0x6E8E, 0x6E8D, 0x6EA4, 0x6EA1, 0x6EBF, 0x6EB3, 0x6ED0, 0x6ECA, 	/* 0xDE60 to 0xDE67 */
0x6E97, 0x6EAE, 0x6EA3, 0x7147, 0x7154, 0x7152, 0x7163, 0x7160, 	/* 0xDE68 to 0xDE6F */
0x7141, 0x715D, 0x7162, 0x7172, 0x7178, 0x716A, 0x7161, 0x7142, 	/* 0xDE70 to 0xDE77 */
0x7158, 0x7143, 0x714B, 0x7170, 0x715F, 0x7150, 0x7153, 0x0000, 	/* 0xDE78 to 0xDE7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE80 to 0xDE87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE88 to 0xDE8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE90 to 0xDE97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDE98 to 0xDE9F */
0x0000, 0x7144, 0x714D, 0x715A, 0x724F, 0x728D, 0x728C, 0x7291, 	/* 0xDEA0 to 0xDEA7 */
0x7290, 0x728E, 0x733C, 0x7342, 0x733B, 0x733A, 0x7340, 0x734A, 	/* 0xDEA8 to 0xDEAF */
0x7349, 0x7444, 0x744A, 0x744B, 0x7452, 0x7451, 0x7457, 0x7440, 	/* 0xDEB0 to 0xDEB7 */
0x744F, 0x7450, 0x744E, 0x7442, 0x7446, 0x744D, 0x7454, 0x74E1, 	/* 0xDEB8 to 0xDEBF */
0x74FF, 0x74FE, 0x74FD, 0x751D, 0x7579, 0x7577, 0x6983, 0x75EF, 	/* 0xDEC0 to 0xDEC7 */
0x760F, 0x7603, 0x75F7, 0x75FE, 0x75FC, 0x75F9, 0x75F8, 0x7610, 	/* 0xDEC8 to 0xDECF */
0x75FB, 0x75F6, 0x75ED, 0x75F5, 0x75FD, 0x7699, 0x76B5, 0x76DD, 	/* 0xDED0 to 0xDED7 */
0x7755, 0x775F, 0x7760, 0x7752, 0x7756, 0x775A, 0x7769, 0x7767, 	/* 0xDED8 to 0xDEDF */
0x7754, 0x7759, 0x776D, 0x77E0, 0x7887, 0x789A, 0x7894, 0x788F, 	/* 0xDEE0 to 0xDEE7 */
0x7884, 0x7895, 0x7885, 0x7886, 0x78A1, 0x7883, 0x7879, 0x7899, 	/* 0xDEE8 to 0xDEEF */
0x7880, 0x7896, 0x787B, 0x797C, 0x7982, 0x797D, 0x7979, 0x7A11, 	/* 0xDEF0 to 0xDEF7 */
0x7A18, 0x7A19, 0x7A12, 0x7A17, 0x7A15, 0x7A22, 0x7A13, 0x0000, 	/* 0xDEF8 to 0xDEFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF00 to 0xDF07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF08 to 0xDF0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF10 to 0xDF17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF18 to 0xDF1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF20 to 0xDF27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF28 to 0xDF2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF30 to 0xDF37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF38 to 0xDF3F */
0x7A1B, 0x7A10, 0x7AA3, 0x7AA2, 0x7A9E, 0x7AEB, 0x7B66, 0x7B64, 	/* 0xDF40 to 0xDF47 */
0x7B6D, 0x7B74, 0x7B69, 0x7B72, 0x7B65, 0x7B73, 0x7B71, 0x7B70, 	/* 0xDF48 to 0xDF4F */
0x7B61, 0x7B78, 0x7B76, 0x7B63, 0x7CB2, 0x7CB4, 0x7CAF, 0x7D88, 	/* 0xDF50 to 0xDF57 */
0x7D86, 0x7D80, 0x7D8D, 0x7D7F, 0x7D85, 0x7D7A, 0x7D8E, 0x7D7B, 	/* 0xDF58 to 0xDF5F */
0x7D83, 0x7D7C, 0x7D8C, 0x7D94, 0x7D84, 0x7D7D, 0x7D92, 0x7F6D, 	/* 0xDF60 to 0xDF67 */
0x7F6B, 0x7F67, 0x7F68, 0x7F6C, 0x7FA6, 0x7FA5, 0x7FA7, 0x7FDB, 	/* 0xDF68 to 0xDF6F */
0x7FDC, 0x8021, 0x8164, 0x8160, 0x8177, 0x815C, 0x8169, 0x815B, 	/* 0xDF70 to 0xDF77 */
0x8162, 0x8172, 0x6721, 0x815E, 0x8176, 0x8167, 0x816F, 0x0000, 	/* 0xDF78 to 0xDF7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF80 to 0xDF87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF88 to 0xDF8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF90 to 0xDF97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xDF98 to 0xDF9F */
0x0000, 0x8144, 0x8161, 0x821D, 0x8249, 0x8244, 0x8240, 0x8242, 	/* 0xDFA0 to 0xDFA7 */
0x8245, 0x84F1, 0x843F, 0x8456, 0x8476, 0x8479, 0x848F, 0x848D, 	/* 0xDFA8 to 0xDFAF */
0x8465, 0x8451, 0x8440, 0x8486, 0x8467, 0x8430, 0x844D, 0x847D, 	/* 0xDFB0 to 0xDFB7 */
0x845A, 0x8459, 0x8474, 0x8473, 0x845D, 0x8507, 0x845E, 0x8437, 	/* 0xDFB8 to 0xDFBF */
0x843A, 0x8434, 0x847A, 0x8443, 0x8478, 0x8432, 0x8445, 0x8429, 	/* 0xDFC0 to 0xDFC7 */
0x83D9, 0x844B, 0x842F, 0x8442, 0x842D, 0x845F, 0x8470, 0x8439, 	/* 0xDFC8 to 0xDFCF */
0x844E, 0x844C, 0x8452, 0x846F, 0x84C5, 0x848E, 0x843B, 0x8447, 	/* 0xDFD0 to 0xDFD7 */
0x8436, 0x8433, 0x8468, 0x847E, 0x8444, 0x842B, 0x8460, 0x8454, 	/* 0xDFD8 to 0xDFDF */
0x846E, 0x8450, 0x870B, 0x8704, 0x86F7, 0x870C, 0x86FA, 0x86D6, 	/* 0xDFE0 to 0xDFE7 */
0x86F5, 0x874D, 0x86F8, 0x870E, 0x8709, 0x8701, 0x86F6, 0x870D, 	/* 0xDFE8 to 0xDFEF */
0x8705, 0x88D6, 0x88CB, 0x88CD, 0x88CE, 0x88DE, 0x88DB, 0x88DA, 	/* 0xDFF0 to 0xDFF7 */
0x88CC, 0x88D0, 0x8985, 0x899B, 0x89DF, 0x89E5, 0x89E4, 0x0000, 	/* 0xDFF8 to 0xDFFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE000 to 0xE007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE008 to 0xE00F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE010 to 0xE017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE018 to 0xE01F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE020 to 0xE027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE028 to 0xE02F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE030 to 0xE037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE038 to 0xE03F */
0x89E1, 0x89E0, 0x89E2, 0x89DC, 0x89E6, 0x8A76, 0x8A86, 0x8A7F, 	/* 0xE040 to 0xE047 */
0x8A61, 0x8A3F, 0x8A77, 0x8A82, 0x8A84, 0x8A75, 0x8A83, 0x8A81, 	/* 0xE048 to 0xE04F */
0x8A74, 0x8A7A, 0x8C3C, 0x8C4B, 0x8C4A, 0x8C65, 0x8C64, 0x8C66, 	/* 0xE050 to 0xE057 */
0x8C86, 0x8C84, 0x8C85, 0x8CCC, 0x8D68, 0x8D69, 0x8D91, 0x8D8C, 	/* 0xE058 to 0xE05F */
0x8D8E, 0x8D8F, 0x8D8D, 0x8D93, 0x8D94, 0x8D90, 0x8D92, 0x8DF0, 	/* 0xE060 to 0xE067 */
0x8DE0, 0x8DEC, 0x8DF1, 0x8DEE, 0x8DD0, 0x8DE9, 0x8DE3, 0x8DE2, 	/* 0xE068 to 0xE06F */
0x8DE7, 0x8DF2, 0x8DEB, 0x8DF4, 0x8F06, 0x8EFF, 0x8F01, 0x8F00, 	/* 0xE070 to 0xE077 */
0x8F05, 0x8F07, 0x8F08, 0x8F02, 0x8F0B, 0x9052, 0x903F, 0x0000, 	/* 0xE078 to 0xE07F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE080 to 0xE087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE088 to 0xE08F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE090 to 0xE097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE098 to 0xE09F */
0x0000, 0x9044, 0x9049, 0x903D, 0x9110, 0x910D, 0x910F, 0x9111, 	/* 0xE0A0 to 0xE0A7 */
0x9116, 0x9114, 0x910B, 0x910E, 0x916E, 0x916F, 0x9248, 0x9252, 	/* 0xE0A8 to 0xE0AF */
0x9230, 0x923A, 0x9266, 0x9233, 0x9265, 0x925E, 0x9283, 0x922E, 	/* 0xE0B0 to 0xE0B7 */
0x924A, 0x9246, 0x926D, 0x926C, 0x924F, 0x9260, 0x9267, 0x926F, 	/* 0xE0B8 to 0xE0BF */
0x9236, 0x9261, 0x9270, 0x9231, 0x9254, 0x9263, 0x9250, 0x9272, 	/* 0xE0C0 to 0xE0C7 */
0x924E, 0x9253, 0x924C, 0x9256, 0x9232, 0x959F, 0x959C, 0x959E, 	/* 0xE0C8 to 0xE0CF */
0x959B, 0x9692, 0x9693, 0x9691, 0x9697, 0x96CE, 0x96FA, 0x96FD, 	/* 0xE0D0 to 0xE0D7 */
0x96F8, 0x96F5, 0x9773, 0x9777, 0x9778, 0x9772, 0x980F, 0x980D, 	/* 0xE0D8 to 0xE0DF */
0x980E, 0x98AC, 0x98F6, 0x98F9, 0x99AF, 0x99B2, 0x99B0, 0x99B5, 	/* 0xE0E0 to 0xE0E7 */
0x9AAD, 0x9AAB, 0x9B5B, 0x9CEA, 0x9CED, 0x9CE7, 0x9E80, 0x9EFD, 	/* 0xE0E8 to 0xE0EF */
0x50E6, 0x50D4, 0x50D7, 0x50E8, 0x50F3, 0x50DB, 0x50EA, 0x50DD, 	/* 0xE0F0 to 0xE0F7 */
0x50E4, 0x50D3, 0x50EC, 0x50F0, 0x50EF, 0x50E3, 0x50E0, 0x0000, 	/* 0xE0F8 to 0xE0FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE100 to 0xE107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE108 to 0xE10F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE110 to 0xE117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE118 to 0xE11F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE120 to 0xE127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE128 to 0xE12F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE130 to 0xE137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE138 to 0xE13F */
0x51D8, 0x5280, 0x5281, 0x52E9, 0x52EB, 0x5330, 0x53AC, 0x5627, 	/* 0xE140 to 0xE147 */
0x5615, 0x560C, 0x5612, 0x55FC, 0x560F, 0x561C, 0x5601, 0x5613, 	/* 0xE148 to 0xE14F */
0x5602, 0x55FA, 0x561D, 0x5604, 0x55FF, 0x55F9, 0x5889, 0x587C, 	/* 0xE150 to 0xE157 */
0x5890, 0x5898, 0x5886, 0x5881, 0x587F, 0x5874, 0x588B, 0x587A, 	/* 0xE158 to 0xE15F */
0x5887, 0x5891, 0x588E, 0x5876, 0x5882, 0x5888, 0x587B, 0x5894, 	/* 0xE160 to 0xE167 */
0x588F, 0x58FE, 0x596B, 0x5ADC, 0x5AEE, 0x5AE5, 0x5AD5, 0x5AEA, 	/* 0xE168 to 0xE16F */
0x5ADA, 0x5AED, 0x5AEB, 0x5AF3, 0x5AE2, 0x5AE0, 0x5ADB, 0x5AEC, 	/* 0xE170 to 0xE177 */
0x5ADE, 0x5ADD, 0x5AD9, 0x5AE8, 0x5ADF, 0x5B77, 0x5BE0, 0x0000, 	/* 0xE178 to 0xE17F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE180 to 0xE187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE188 to 0xE18F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE190 to 0xE197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE198 to 0xE19F */
0x0000, 0x5BE3, 0x5C63, 0x5D82, 0x5D80, 0x5D7D, 0x5D86, 0x5D7A, 	/* 0xE1A0 to 0xE1A7 */
0x5D81, 0x5D77, 0x5D8A, 0x5D89, 0x5D88, 0x5D7E, 0x5D7C, 0x5D8D, 	/* 0xE1A8 to 0xE1AF */
0x5D79, 0x5D7F, 0x5E58, 0x5E59, 0x5E53, 0x5ED8, 0x5ED1, 0x5ED7, 	/* 0xE1B0 to 0xE1B7 */
0x5ECE, 0x5EDC, 0x5ED5, 0x5ED9, 0x5ED2, 0x5ED4, 0x5F44, 0x5F43, 	/* 0xE1B8 to 0xE1BF */
0x5F6F, 0x5FB6, 0x612C, 0x6128, 0x6141, 0x615E, 0x6171, 0x6173, 	/* 0xE1C0 to 0xE1C7 */
0x6152, 0x6153, 0x6172, 0x616C, 0x6180, 0x6174, 0x6154, 0x617A, 	/* 0xE1C8 to 0xE1CF */
0x615B, 0x6165, 0x613B, 0x616A, 0x6161, 0x6156, 0x6229, 0x6227, 	/* 0xE1D0 to 0xE1D7 */
0x622B, 0x642B, 0x644D, 0x645B, 0x645D, 0x6474, 0x6476, 0x6472, 	/* 0xE1D8 to 0xE1DF */
0x6473, 0x647D, 0x6475, 0x6466, 0x64A6, 0x644E, 0x6482, 0x645E, 	/* 0xE1E0 to 0xE1E7 */
0x645C, 0x644B, 0x6453, 0x6460, 0x6450, 0x647F, 0x643F, 0x646C, 	/* 0xE1E8 to 0xE1EF */
0x646B, 0x6459, 0x6465, 0x6477, 0x6573, 0x65A0, 0x66A1, 0x66A0, 	/* 0xE1F0 to 0xE1F7 */
0x669F, 0x6705, 0x6704, 0x6722, 0x69B1, 0x69B6, 0x69C9, 0x0000, 	/* 0xE1F8 to 0xE1FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE200 to 0xE207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE208 to 0xE20F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE210 to 0xE217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE218 to 0xE21F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE220 to 0xE227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE228 to 0xE22F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE230 to 0xE237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE238 to 0xE23F */
0x69A0, 0x69CE, 0x6996, 0x69B0, 0x69AC, 0x69BC, 0x6991, 0x6999, 	/* 0xE240 to 0xE247 */
0x698E, 0x69A7, 0x698D, 0x69A9, 0x69BE, 0x69AF, 0x69BF, 0x69C4, 	/* 0xE248 to 0xE24F */
0x69BD, 0x69A4, 0x69D4, 0x69B9, 0x69CA, 0x699A, 0x69CF, 0x69B3, 	/* 0xE250 to 0xE257 */
0x6993, 0x69AA, 0x69A1, 0x699E, 0x69D9, 0x6997, 0x6990, 0x69C2, 	/* 0xE258 to 0xE25F */
0x69B5, 0x69A5, 0x69C6, 0x6B4A, 0x6B4D, 0x6B4B, 0x6B9E, 0x6B9F, 	/* 0xE260 to 0xE267 */
0x6BA0, 0x6BC3, 0x6BC4, 0x6BFE, 0x6ECE, 0x6EF5, 0x6EF1, 0x6F03, 	/* 0xE268 to 0xE26F */
0x6F25, 0x6EF8, 0x6F37, 0x6EFB, 0x6F2E, 0x6F09, 0x6F4E, 0x6F19, 	/* 0xE270 to 0xE277 */
0x6F1A, 0x6F27, 0x6F18, 0x6F3B, 0x6F12, 0x6EED, 0x6F0A, 0x0000, 	/* 0xE278 to 0xE27F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE280 to 0xE287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE288 to 0xE28F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE290 to 0xE297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE298 to 0xE29F */
0x0000, 0x6F36, 0x6F73, 0x6EF9, 0x6EEE, 0x6F2D, 0x6F40, 0x6F30, 	/* 0xE2A0 to 0xE2A7 */
0x6F3C, 0x6F35, 0x6EEB, 0x6F07, 0x6F0E, 0x6F43, 0x6F05, 0x6EFD, 	/* 0xE2A8 to 0xE2AF */
0x6EF6, 0x6F39, 0x6F1C, 0x6EFC, 0x6F3A, 0x6F1F, 0x6F0D, 0x6F1E, 	/* 0xE2B0 to 0xE2B7 */
0x6F08, 0x6F21, 0x7187, 0x7190, 0x7189, 0x7180, 0x7185, 0x7182, 	/* 0xE2B8 to 0xE2BF */
0x718F, 0x717B, 0x7186, 0x7181, 0x7197, 0x7244, 0x7253, 0x7297, 	/* 0xE2C0 to 0xE2C7 */
0x7295, 0x7293, 0x7343, 0x734D, 0x7351, 0x734C, 0x7462, 0x7473, 	/* 0xE2C8 to 0xE2CF */
0x7471, 0x7475, 0x7472, 0x7467, 0x746E, 0x7500, 0x7502, 0x7503, 	/* 0xE2D0 to 0xE2D7 */
0x757D, 0x7590, 0x7616, 0x7608, 0x760C, 0x7615, 0x7611, 0x760A, 	/* 0xE2D8 to 0xE2DF */
0x7614, 0x76B8, 0x7781, 0x777C, 0x7785, 0x7782, 0x776E, 0x7780, 	/* 0xE2E0 to 0xE2E7 */
0x776F, 0x777E, 0x7783, 0x78B2, 0x78AA, 0x78B4, 0x78AD, 0x78A8, 	/* 0xE2E8 to 0xE2EF */
0x787E, 0x78AB, 0x789E, 0x78A5, 0x78A0, 0x78AC, 0x78A2, 0x78A4, 	/* 0xE2F0 to 0xE2F7 */
0x7998, 0x798A, 0x798B, 0x7996, 0x7995, 0x7994, 0x7993, 0x0000, 	/* 0xE2F8 to 0xE2FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE300 to 0xE307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE308 to 0xE30F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE310 to 0xE317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE318 to 0xE31F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE320 to 0xE327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE328 to 0xE32F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE330 to 0xE337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE338 to 0xE33F */
0x7997, 0x7988, 0x7992, 0x7990, 0x7A2B, 0x7A4A, 0x7A30, 0x7A2F, 	/* 0xE340 to 0xE347 */
0x7A28, 0x7A26, 0x7AA8, 0x7AAB, 0x7AAC, 0x7AEE, 0x7B88, 0x7B9C, 	/* 0xE348 to 0xE34F */
0x7B8A, 0x7B91, 0x7B90, 0x7B96, 0x7B8D, 0x7B8C, 0x7B9B, 0x7B8E, 	/* 0xE350 to 0xE357 */
0x7B85, 0x7B98, 0x5284, 0x7B99, 0x7BA4, 0x7B82, 0x7CBB, 0x7CBF, 	/* 0xE358 to 0xE35F */
0x7CBC, 0x7CBA, 0x7DA7, 0x7DB7, 0x7DC2, 0x7DA3, 0x7DAA, 0x7DC1, 	/* 0xE360 to 0xE367 */
0x7DC0, 0x7DC5, 0x7D9D, 0x7DCE, 0x7DC4, 0x7DC6, 0x7DCB, 0x7DCC, 	/* 0xE368 to 0xE36F */
0x7DAF, 0x7DB9, 0x7D96, 0x7DBC, 0x7D9F, 0x7DA6, 0x7DAE, 0x7DA9, 	/* 0xE370 to 0xE377 */
0x7DA1, 0x7DC9, 0x7F73, 0x7FE2, 0x7FE3, 0x7FE5, 0x7FDE, 0x0000, 	/* 0xE378 to 0xE37F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE380 to 0xE387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE388 to 0xE38F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE390 to 0xE397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE398 to 0xE39F */
0x0000, 0x8024, 0x805D, 0x805C, 0x8189, 0x8186, 0x8183, 0x8187, 	/* 0xE3A0 to 0xE3A7 */
0x818D, 0x818C, 0x818B, 0x8215, 0x8497, 0x84A4, 0x84A1, 0x849F, 	/* 0xE3A8 to 0xE3AF */
0x84BA, 0x84CE, 0x84C2, 0x84AC, 0x84AE, 0x84AB, 0x84B9, 0x84B4, 	/* 0xE3B0 to 0xE3B7 */
0x84C1, 0x84CD, 0x84AA, 0x849A, 0x84B1, 0x84D0, 0x849D, 0x84A7, 	/* 0xE3B8 to 0xE3BF */
0x84BB, 0x84A2, 0x8494, 0x84C7, 0x84CC, 0x849B, 0x84A9, 0x84AF, 	/* 0xE3C0 to 0xE3C7 */
0x84A8, 0x84D6, 0x8498, 0x84B6, 0x84CF, 0x84A0, 0x84D7, 0x84D4, 	/* 0xE3C8 to 0xE3CF */
0x84D2, 0x84DB, 0x84B0, 0x8491, 0x8661, 0x8733, 0x8723, 0x8728, 	/* 0xE3D0 to 0xE3D7 */
0x876B, 0x8740, 0x872E, 0x871E, 0x8721, 0x8719, 0x871B, 0x8743, 	/* 0xE3D8 to 0xE3DF */
0x872C, 0x8741, 0x873E, 0x8746, 0x8720, 0x8732, 0x872A, 0x872D, 	/* 0xE3E0 to 0xE3E7 */
0x873C, 0x8712, 0x873A, 0x8731, 0x8735, 0x8742, 0x8726, 0x8727, 	/* 0xE3E8 to 0xE3EF */
0x8738, 0x8724, 0x871A, 0x8730, 0x8711, 0x88F7, 0x88E7, 0x88F1, 	/* 0xE3F0 to 0xE3F7 */
0x88F2, 0x88FA, 0x88FE, 0x88EE, 0x88FC, 0x88F6, 0x88FB, 0x0000, 	/* 0xE3F8 to 0xE3FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE400 to 0xE407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE408 to 0xE40F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE410 to 0xE417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE418 to 0xE41F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE420 to 0xE427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE428 to 0xE42F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE430 to 0xE437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE438 to 0xE43F */
0x88F0, 0x88EC, 0x88EB, 0x899D, 0x89A1, 0x899F, 0x899E, 0x89E9, 	/* 0xE440 to 0xE447 */
0x89EB, 0x89E8, 0x8AAB, 0x8A99, 0x8A8B, 0x8A92, 0x8A8F, 0x8A96, 	/* 0xE448 to 0xE44F */
0x8C3D, 0x8C68, 0x8C69, 0x8CD5, 0x8CCF, 0x8CD7, 0x8D96, 0x8E09, 	/* 0xE450 to 0xE457 */
0x8E02, 0x8DFF, 0x8E0D, 0x8DFD, 0x8E0A, 0x8E03, 0x8E07, 0x8E06, 	/* 0xE458 to 0xE45F */
0x8E05, 0x8DFE, 0x8E00, 0x8E04, 0x8F10, 0x8F11, 0x8F0E, 0x8F0D, 	/* 0xE460 to 0xE467 */
0x9123, 0x911C, 0x9120, 0x9122, 0x911F, 0x911D, 0x911A, 0x9124, 	/* 0xE468 to 0xE46F */
0x9121, 0x911B, 0x917A, 0x9172, 0x9179, 0x9173, 0x92A5, 0x92A4, 	/* 0xE470 to 0xE477 */
0x9276, 0x929B, 0x927A, 0x92A0, 0x9294, 0x92AA, 0x928D, 0x0000, 	/* 0xE478 to 0xE47F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE480 to 0xE487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE488 to 0xE48F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE490 to 0xE497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE498 to 0xE49F */
0x0000, 0x92A6, 0x929A, 0x92AB, 0x9279, 0x9297, 0x927F, 0x92A3, 	/* 0xE4A0 to 0xE4A7 */
0x92EE, 0x928E, 0x9282, 0x9295, 0x92A2, 0x927D, 0x9288, 0x92A1, 	/* 0xE4A8 to 0xE4AF */
0x928A, 0x9286, 0x928C, 0x9299, 0x92A7, 0x927E, 0x9287, 0x92A9, 	/* 0xE4B0 to 0xE4B7 */
0x929D, 0x928B, 0x922D, 0x969E, 0x96A1, 0x96FF, 0x9758, 0x977D, 	/* 0xE4B8 to 0xE4BF */
0x977A, 0x977E, 0x9783, 0x9780, 0x9782, 0x977B, 0x9784, 0x9781, 	/* 0xE4C0 to 0xE4C7 */
0x977F, 0x97CE, 0x97CD, 0x9816, 0x98AD, 0x98AE, 0x9902, 0x9900, 	/* 0xE4C8 to 0xE4CF */
0x9907, 0x999D, 0x999C, 0x99C3, 0x99B9, 0x99BB, 0x99BA, 0x99C2, 	/* 0xE4D0 to 0xE4D7 */
0x99BD, 0x99C7, 0x9AB1, 0x9AE3, 0x9AE7, 0x9B3E, 0x9B3F, 0x9B60, 	/* 0xE4D8 to 0xE4DF */
0x9B61, 0x9B5F, 0x9CF1, 0x9CF2, 0x9CF5, 0x9EA7, 0x50FF, 0x5103, 	/* 0xE4E0 to 0xE4E7 */
0x5130, 0x50F8, 0x5106, 0x5107, 0x50F6, 0x50FE, 0x510B, 0x510C, 	/* 0xE4E8 to 0xE4EF */
0x50FD, 0x510A, 0x528B, 0x528C, 0x52F1, 0x52EF, 0x5648, 0x5642, 	/* 0xE4F0 to 0xE4F7 */
0x564C, 0x5635, 0x5641, 0x564A, 0x5649, 0x5646, 0x5658, 0x0000, 	/* 0xE4F8 to 0xE4FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE500 to 0xE507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE508 to 0xE50F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE510 to 0xE517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE518 to 0xE51F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE520 to 0xE527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE528 to 0xE52F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE530 to 0xE537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE538 to 0xE53F */
0x565A, 0x5640, 0x5633, 0x563D, 0x562C, 0x563E, 0x5638, 0x562A, 	/* 0xE540 to 0xE547 */
0x563A, 0x571A, 0x58AB, 0x589D, 0x58B1, 0x58A0, 0x58A3, 0x58AF, 	/* 0xE548 to 0xE54F */
0x58AC, 0x58A5, 0x58A1, 0x58FF, 0x5AFF, 0x5AF4, 0x5AFD, 0x5AF7, 	/* 0xE550 to 0xE557 */
0x5AF6, 0x5B03, 0x5AF8, 0x5B02, 0x5AF9, 0x5B01, 0x5B07, 0x5B05, 	/* 0xE558 to 0xE55F */
0x5B0F, 0x5C67, 0x5D99, 0x5D97, 0x5D9F, 0x5D92, 0x5DA2, 0x5D93, 	/* 0xE560 to 0xE567 */
0x5D95, 0x5DA0, 0x5D9C, 0x5DA1, 0x5D9A, 0x5D9E, 0x5E69, 0x5E5D, 	/* 0xE568 to 0xE56F */
0x5E60, 0x5E5C, 0x7DF3, 0x5EDB, 0x5EDE, 0x5EE1, 0x5F49, 0x5FB2, 	/* 0xE570 to 0xE577 */
0x618B, 0x6183, 0x6179, 0x61B1, 0x61B0, 0x61A2, 0x6189, 0x0000, 	/* 0xE578 to 0xE57F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE580 to 0xE587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE588 to 0xE58F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE590 to 0xE597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE598 to 0xE59F */
0x0000, 0x619B, 0x6193, 0x61AF, 0x61AD, 0x619F, 0x6192, 0x61AA, 	/* 0xE5A0 to 0xE5A7 */
0x61A1, 0x618D, 0x6166, 0x61B3, 0x622D, 0x646E, 0x6470, 0x6496, 	/* 0xE5A8 to 0xE5AF */
0x64A0, 0x6485, 0x6497, 0x649C, 0x648F, 0x648B, 0x648A, 0x648C, 	/* 0xE5B0 to 0xE5B7 */
0x64A3, 0x649F, 0x6468, 0x64B1, 0x6498, 0x6576, 0x657A, 0x6579, 	/* 0xE5B8 to 0xE5BF */
0x657B, 0x65B2, 0x65B3, 0x66B5, 0x66B0, 0x66A9, 0x66B2, 0x66B7, 	/* 0xE5C0 to 0xE5C7 */
0x66AA, 0x66AF, 0x6A00, 0x6A06, 0x6A17, 0x69E5, 0x69F8, 0x6A15, 	/* 0xE5C8 to 0xE5CF */
0x69F1, 0x69E4, 0x6A20, 0x69FF, 0x69EC, 0x69E2, 0x6A1B, 0x6A1D, 	/* 0xE5D0 to 0xE5D7 */
0x69FE, 0x6A27, 0x69F2, 0x69EE, 0x6A14, 0x69F7, 0x69E7, 0x6A40, 	/* 0xE5D8 to 0xE5DF */
0x6A08, 0x69E6, 0x69FB, 0x6A0D, 0x69FC, 0x69EB, 0x6A09, 0x6A04, 	/* 0xE5E0 to 0xE5E7 */
0x6A18, 0x6A25, 0x6A0F, 0x69F6, 0x6A26, 0x6A07, 0x69F4, 0x6A16, 	/* 0xE5E8 to 0xE5EF */
0x6B51, 0x6BA5, 0x6BA3, 0x6BA2, 0x6BA6, 0x6C01, 0x6C00, 0x6BFF, 	/* 0xE5F0 to 0xE5F7 */
0x6C02, 0x6F41, 0x6F26, 0x6F7E, 0x6F87, 0x6FC6, 0x6F92, 0x0000, 	/* 0xE5F8 to 0xE5FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE600 to 0xE607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE608 to 0xE60F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE610 to 0xE617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE618 to 0xE61F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE620 to 0xE627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE628 to 0xE62F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE630 to 0xE637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE638 to 0xE63F */
0x6F8D, 0x6F89, 0x6F8C, 0x6F62, 0x6F4F, 0x6F85, 0x6F5A, 0x6F96, 	/* 0xE640 to 0xE647 */
0x6F76, 0x6F6C, 0x6F82, 0x6F55, 0x6F72, 0x6F52, 0x6F50, 0x6F57, 	/* 0xE648 to 0xE64F */
0x6F94, 0x6F93, 0x6F5D, 0x6F00, 0x6F61, 0x6F6B, 0x6F7D, 0x6F67, 	/* 0xE650 to 0xE657 */
0x6F90, 0x6F53, 0x6F8B, 0x6F69, 0x6F7F, 0x6F95, 0x6F63, 0x6F77, 	/* 0xE658 to 0xE65F */
0x6F6A, 0x6F7B, 0x71B2, 0x71AF, 0x719B, 0x71B0, 0x71A0, 0x719A, 	/* 0xE660 to 0xE667 */
0x71A9, 0x71B5, 0x719D, 0x71A5, 0x719E, 0x71A4, 0x71A1, 0x71AA, 	/* 0xE668 to 0xE66F */
0x719C, 0x71A7, 0x71B3, 0x7298, 0x729A, 0x7358, 0x7352, 0x735E, 	/* 0xE670 to 0xE677 */
0x735F, 0x7360, 0x735D, 0x735B, 0x7361, 0x735A, 0x7359, 0x0000, 	/* 0xE678 to 0xE67F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE680 to 0xE687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE688 to 0xE68F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE690 to 0xE697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE698 to 0xE69F */
0x0000, 0x7362, 0x7487, 0x7489, 0x748A, 0x7486, 0x7481, 0x747D, 	/* 0xE6A0 to 0xE6A7 */
0x7485, 0x7488, 0x747C, 0x7479, 0x7508, 0x7507, 0x757E, 0x7625, 	/* 0xE6A8 to 0xE6AF */
0x761E, 0x7619, 0x761D, 0x761C, 0x7623, 0x761A, 0x7628, 0x761B, 	/* 0xE6B0 to 0xE6B7 */
0x769C, 0x769D, 0x769E, 0x769B, 0x778D, 0x778F, 0x7789, 0x7788, 	/* 0xE6B8 to 0xE6BF */
0x78CD, 0x78BB, 0x78CF, 0x78CC, 0x78D1, 0x78CE, 0x78D4, 0x78C8, 	/* 0xE6C0 to 0xE6C7 */
0x78C3, 0x78C4, 0x78C9, 0x799A, 0x79A1, 0x79A0, 0x799C, 0x79A2, 	/* 0xE6C8 to 0xE6CF */
0x799B, 0x6B76, 0x7A39, 0x7AB2, 0x7AB4, 0x7AB3, 0x7BB7, 0x7BCB, 	/* 0xE6D0 to 0xE6D7 */
0x7BBE, 0x7BAC, 0x7BCE, 0x7BAF, 0x7BB9, 0x7BCA, 0x7BB5, 0x7CC5, 	/* 0xE6D8 to 0xE6DF */
0x7CC8, 0x7CCC, 0x7CCB, 0x7DF7, 0x7DDB, 0x7DEA, 0x7DE7, 0x7DD7, 	/* 0xE6E0 to 0xE6E7 */
0x7DE1, 0x7E03, 0x7DFA, 0x7DE6, 0x7DF6, 0x7DF1, 0x7DF0, 0x7DEE, 	/* 0xE6E8 to 0xE6EF */
0x7DDF, 0x7F76, 0x7FAC, 0x7FB0, 0x7FAD, 0x7FED, 0x7FEB, 0x7FEA, 	/* 0xE6F0 to 0xE6F7 */
0x7FEC, 0x7FE6, 0x7FE8, 0x8064, 0x8067, 0x81A3, 0x819F, 0x0000, 	/* 0xE6F8 to 0xE6FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE700 to 0xE707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE708 to 0xE70F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE710 to 0xE717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE718 to 0xE71F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE720 to 0xE727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE728 to 0xE72F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE730 to 0xE737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE738 to 0xE73F */
0x819E, 0x8195, 0x81A2, 0x8199, 0x8197, 0x8216, 0x824F, 0x8253, 	/* 0xE740 to 0xE747 */
0x8252, 0x8250, 0x824E, 0x8251, 0x8524, 0x853B, 0x850F, 0x8500, 	/* 0xE748 to 0xE74F */
0x8529, 0x850E, 0x8509, 0x850D, 0x851F, 0x850A, 0x8527, 0x851C, 	/* 0xE750 to 0xE757 */
0x84FB, 0x852B, 0x84FA, 0x8508, 0x850C, 0x84F4, 0x852A, 0x84F2, 	/* 0xE758 to 0xE75F */
0x8515, 0x84F7, 0x84EB, 0x84F3, 0x84FC, 0x8512, 0x84EA, 0x84E9, 	/* 0xE760 to 0xE767 */
0x8516, 0x84FE, 0x8528, 0x851D, 0x852E, 0x8502, 0x84FD, 0x851E, 	/* 0xE768 to 0xE76F */
0x84F6, 0x8531, 0x8526, 0x84E7, 0x84E8, 0x84F0, 0x84EF, 0x84F9, 	/* 0xE770 to 0xE777 */
0x8518, 0x8520, 0x8530, 0x850B, 0x8519, 0x852F, 0x8662, 0x0000, 	/* 0xE778 to 0xE77F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE780 to 0xE787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE788 to 0xE78F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE790 to 0xE797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE798 to 0xE79F */
0x0000, 0x8756, 0x8763, 0x8764, 0x8777, 0x87E1, 0x8773, 0x8758, 	/* 0xE7A0 to 0xE7A7 */
0x8754, 0x875B, 0x8752, 0x8761, 0x875A, 0x8751, 0x875E, 0x876D, 	/* 0xE7A8 to 0xE7AF */
0x876A, 0x8750, 0x874E, 0x875F, 0x875D, 0x876F, 0x876C, 0x877A, 	/* 0xE7B0 to 0xE7B7 */
0x876E, 0x875C, 0x8765, 0x874F, 0x877B, 0x8775, 0x8762, 0x8767, 	/* 0xE7B8 to 0xE7BF */
0x8769, 0x885A, 0x8905, 0x890C, 0x8914, 0x890B, 0x8917, 0x8918, 	/* 0xE7C0 to 0xE7C7 */
0x8919, 0x8906, 0x8916, 0x8911, 0x890E, 0x8909, 0x89A2, 0x89A4, 	/* 0xE7C8 to 0xE7CF */
0x89A3, 0x89ED, 0x89F0, 0x89EC, 0x8ACF, 0x8AC6, 0x8AB8, 0x8AD3, 	/* 0xE7D0 to 0xE7D7 */
0x8AD1, 0x8AD4, 0x8AD5, 0x8ABB, 0x8AD7, 0x8ABE, 0x8AC0, 0x8AC5, 	/* 0xE7D8 to 0xE7DF */
0x8AD8, 0x8AC3, 0x8ABA, 0x8ABD, 0x8AD9, 0x8C3E, 0x8C4D, 0x8C8F, 	/* 0xE7E0 to 0xE7E7 */
0x8CE5, 0x8CDF, 0x8CD9, 0x8CE8, 0x8CDA, 0x8CDD, 0x8CE7, 0x8DA0, 	/* 0xE7E8 to 0xE7EF */
0x8D9C, 0x8DA1, 0x8D9B, 0x8E20, 0x8E23, 0x8E25, 0x8E24, 0x8E2E, 	/* 0xE7F0 to 0xE7F7 */
0x8E15, 0x8E1B, 0x8E16, 0x8E11, 0x8E19, 0x8E26, 0x8E27, 0x0000, 	/* 0xE7F8 to 0xE7FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE800 to 0xE807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE808 to 0xE80F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE810 to 0xE817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE818 to 0xE81F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE820 to 0xE827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE828 to 0xE82F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE830 to 0xE837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE838 to 0xE83F */
0x8E14, 0x8E12, 0x8E18, 0x8E13, 0x8E1C, 0x8E17, 0x8E1A, 0x8F2C, 	/* 0xE840 to 0xE847 */
0x8F24, 0x8F18, 0x8F1A, 0x8F20, 0x8F23, 0x8F16, 0x8F17, 0x9073, 	/* 0xE848 to 0xE84F */
0x9070, 0x906F, 0x9067, 0x906B, 0x912F, 0x912B, 0x9129, 0x912A, 	/* 0xE850 to 0xE857 */
0x9132, 0x9126, 0x912E, 0x9185, 0x9186, 0x918A, 0x9181, 0x9182, 	/* 0xE858 to 0xE85F */
0x9184, 0x9180, 0x92D0, 0x92C3, 0x92C4, 0x92C0, 0x92D9, 0x92B6, 	/* 0xE860 to 0xE867 */
0x92CF, 0x92F1, 0x92DF, 0x92D8, 0x92E9, 0x92D7, 0x92DD, 0x92CC, 	/* 0xE868 to 0xE86F */
0x92EF, 0x92C2, 0x92E8, 0x92CA, 0x92C8, 0x92CE, 0x92E6, 0x92CD, 	/* 0xE870 to 0xE877 */
0x92D5, 0x92C9, 0x92E0, 0x92DE, 0x92E7, 0x92D1, 0x92D3, 0x0000, 	/* 0xE878 to 0xE87F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE880 to 0xE887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE888 to 0xE88F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE890 to 0xE897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE898 to 0xE89F */
0x0000, 0x92B5, 0x92E1, 0x92C6, 0x92B4, 0x957C, 0x95AC, 0x95AB, 	/* 0xE8A0 to 0xE8A7 */
0x95AE, 0x95B0, 0x96A4, 0x96A2, 0x96D3, 0x9705, 0x9708, 0x9702, 	/* 0xE8A8 to 0xE8AF */
0x975A, 0x978A, 0x978E, 0x9788, 0x97D0, 0x97CF, 0x981E, 0x981D, 	/* 0xE8B0 to 0xE8B7 */
0x9826, 0x9829, 0x9828, 0x9820, 0x981B, 0x9827, 0x98B2, 0x9908, 	/* 0xE8B8 to 0xE8BF */
0x98FA, 0x9911, 0x9914, 0x9916, 0x9917, 0x9915, 0x99DC, 0x99CD, 	/* 0xE8C0 to 0xE8C7 */
0x99CF, 0x99D3, 0x99D4, 0x99CE, 0x99C9, 0x99D6, 0x99D8, 0x99CB, 	/* 0xE8C8 to 0xE8CF */
0x99D7, 0x99CC, 0x9AB3, 0x9AEC, 0x9AEB, 0x9AF3, 0x9AF2, 0x9AF1, 	/* 0xE8D0 to 0xE8D7 */
0x9B46, 0x9B43, 0x9B67, 0x9B74, 0x9B71, 0x9B66, 0x9B76, 0x9B75, 	/* 0xE8D8 to 0xE8DF */
0x9B70, 0x9B68, 0x9B64, 0x9B6C, 0x9CFC, 0x9CFA, 0x9CFD, 0x9CFF, 	/* 0xE8E0 to 0xE8E7 */
0x9CF7, 0x9D07, 0x9D00, 0x9CF9, 0x9CFB, 0x9D08, 0x9D05, 0x9D04, 	/* 0xE8E8 to 0xE8EF */
0x9E83, 0x9ED3, 0x9F0F, 0x9F10, 0x511C, 0x5113, 0x5117, 0x511A, 	/* 0xE8F0 to 0xE8F7 */
0x5111, 0x51DE, 0x5334, 0x53E1, 0x5670, 0x5660, 0x566E, 0x0000, 	/* 0xE8F8 to 0xE8FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE900 to 0xE907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE908 to 0xE90F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE910 to 0xE917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE918 to 0xE91F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE920 to 0xE927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE928 to 0xE92F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE930 to 0xE937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE938 to 0xE93F */
0x5673, 0x5666, 0x5663, 0x566D, 0x5672, 0x565E, 0x5677, 0x571C, 	/* 0xE940 to 0xE947 */
0x571B, 0x58C8, 0x58BD, 0x58C9, 0x58BF, 0x58BA, 0x58C2, 0x58BC, 	/* 0xE948 to 0xE94F */
0x58C6, 0x5B17, 0x5B19, 0x5B1B, 0x5B21, 0x5B14, 0x5B13, 0x5B10, 	/* 0xE950 to 0xE957 */
0x5B16, 0x5B28, 0x5B1A, 0x5B20, 0x5B1E, 0x5BEF, 0x5DAC, 0x5DB1, 	/* 0xE958 to 0xE95F */
0x5DA9, 0x5DA7, 0x5DB5, 0x5DB0, 0x5DAE, 0x5DAA, 0x5DA8, 0x5DB2, 	/* 0xE960 to 0xE967 */
0x5DAD, 0x5DAF, 0x5DB4, 0x5E67, 0x5E68, 0x5E66, 0x5E6F, 0x5EE9, 	/* 0xE968 to 0xE96F */
0x5EE7, 0x5EE6, 0x5EE8, 0x5EE5, 0x5F4B, 0x5FBC, 0x619D, 0x61A8, 	/* 0xE970 to 0xE977 */
0x6196, 0x61C5, 0x61B4, 0x61C6, 0x61C1, 0x61CC, 0x61BA, 0x0000, 	/* 0xE978 to 0xE97F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE980 to 0xE987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE988 to 0xE98F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE990 to 0xE997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xE998 to 0xE99F */
0x0000, 0x61BF, 0x61B8, 0x618C, 0x64D7, 0x64D6, 0x64D0, 0x64CF, 	/* 0xE9A0 to 0xE9A7 */
0x64C9, 0x64BD, 0x6489, 0x64C3, 0x64DB, 0x64F3, 0x64D9, 0x6533, 	/* 0xE9A8 to 0xE9AF */
0x657F, 0x657C, 0x65A2, 0x66C8, 0x66BE, 0x66C0, 0x66CA, 0x66CB, 	/* 0xE9B0 to 0xE9B7 */
0x66CF, 0x66BD, 0x66BB, 0x66BA, 0x66CC, 0x6723, 0x6A34, 0x6A66, 	/* 0xE9B8 to 0xE9BF */
0x6A49, 0x6A67, 0x6A32, 0x6A68, 0x6A3E, 0x6A5D, 0x6A6D, 0x6A76, 	/* 0xE9C0 to 0xE9C7 */
0x6A5B, 0x6A51, 0x6A28, 0x6A5A, 0x6A3B, 0x6A3F, 0x6A41, 0x6A6A, 	/* 0xE9C8 to 0xE9CF */
0x6A64, 0x6A50, 0x6A4F, 0x6A54, 0x6A6F, 0x6A69, 0x6A60, 0x6A3C, 	/* 0xE9D0 to 0xE9D7 */
0x6A5E, 0x6A56, 0x6A55, 0x6A4D, 0x6A4E, 0x6A46, 0x6B55, 0x6B54, 	/* 0xE9D8 to 0xE9DF */
0x6B56, 0x6BA7, 0x6BAA, 0x6BAB, 0x6BC8, 0x6BC7, 0x6C04, 0x6C03, 	/* 0xE9E0 to 0xE9E7 */
0x6C06, 0x6FAD, 0x6FCB, 0x6FA3, 0x6FC7, 0x6FBC, 0x6FCE, 0x6FC8, 	/* 0xE9E8 to 0xE9EF */
0x6F5E, 0x6FC4, 0x6FBD, 0x6F9E, 0x6FCA, 0x6FA8, 0x7004, 0x6FA5, 	/* 0xE9F0 to 0xE9F7 */
0x6FAE, 0x6FBA, 0x6FAC, 0x6FAA, 0x6FCF, 0x6FBF, 0x6FB8, 0x0000, 	/* 0xE9F8 to 0xE9FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA00 to 0xEA07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA08 to 0xEA0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA10 to 0xEA17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA18 to 0xEA1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA20 to 0xEA27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA28 to 0xEA2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA30 to 0xEA37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA38 to 0xEA3F */
0x6FA2, 0x6FC9, 0x6FAB, 0x6FCD, 0x6FAF, 0x6FB2, 0x6FB0, 0x71C5, 	/* 0xEA40 to 0xEA47 */
0x71C2, 0x71BF, 0x71B8, 0x71D6, 0x71C0, 0x71C1, 0x71CB, 0x71D4, 	/* 0xEA48 to 0xEA4F */
0x71CA, 0x71C7, 0x71CF, 0x71BD, 0x71D8, 0x71BC, 0x71C6, 0x71DA, 	/* 0xEA50 to 0xEA57 */
0x71DB, 0x729D, 0x729E, 0x7369, 0x7366, 0x7367, 0x736C, 0x7365, 	/* 0xEA58 to 0xEA5F */
0x736B, 0x736A, 0x747F, 0x749A, 0x74A0, 0x7494, 0x7492, 0x7495, 	/* 0xEA60 to 0xEA67 */
0x74A1, 0x750B, 0x7580, 0x762F, 0x762D, 0x7631, 0x763D, 0x7633, 	/* 0xEA68 to 0xEA6F */
0x763C, 0x7635, 0x7632, 0x7630, 0x76BB, 0x76E6, 0x779A, 0x779D, 	/* 0xEA70 to 0xEA77 */
0x77A1, 0x779C, 0x779B, 0x77A2, 0x77A3, 0x7795, 0x7799, 0x0000, 	/* 0xEA78 to 0xEA7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA80 to 0xEA87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA88 to 0xEA8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA90 to 0xEA97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEA98 to 0xEA9F */
0x0000, 0x7797, 0x78DD, 0x78E9, 0x78E5, 0x78EA, 0x78DE, 0x78E3, 	/* 0xEAA0 to 0xEAA7 */
0x78DB, 0x78E1, 0x78E2, 0x78ED, 0x78DF, 0x78E0, 0x79A4, 0x7A44, 	/* 0xEAA8 to 0xEAAF */
0x7A48, 0x7A47, 0x7AB6, 0x7AB8, 0x7AB5, 0x7AB1, 0x7AB7, 0x7BDE, 	/* 0xEAB0 to 0xEAB7 */
0x7BE3, 0x7BE7, 0x7BDD, 0x7BD5, 0x7BE5, 0x7BDA, 0x7BE8, 0x7BF9, 	/* 0xEAB8 to 0xEABF */
0x7BD4, 0x7BEA, 0x7BE2, 0x7BDC, 0x7BEB, 0x7BD8, 0x7BDF, 0x7CD2, 	/* 0xEAC0 to 0xEAC7 */
0x7CD4, 0x7CD7, 0x7CD0, 0x7CD1, 0x7E12, 0x7E21, 0x7E17, 0x7E0C, 	/* 0xEAC8 to 0xEACF */
0x7E1F, 0x7E20, 0x7E13, 0x7E0E, 0x7E1C, 0x7E15, 0x7E1A, 0x7E22, 	/* 0xEAD0 to 0xEAD7 */
0x7E0B, 0x7E0F, 0x7E16, 0x7E0D, 0x7E14, 0x7E25, 0x7E24, 0x7F43, 	/* 0xEAD8 to 0xEADF */
0x7F7B, 0x7F7C, 0x7F7A, 0x7FB1, 0x7FEF, 0x802A, 0x8029, 0x806C, 	/* 0xEAE0 to 0xEAE7 */
0x81B1, 0x81A6, 0x81AE, 0x81B9, 0x81B5, 0x81AB, 0x81B0, 0x81AC, 	/* 0xEAE8 to 0xEAEF */
0x81B4, 0x81B2, 0x81B7, 0x81A7, 0x81F2, 0x8255, 0x8256, 0x8257, 	/* 0xEAF0 to 0xEAF7 */
0x8556, 0x8545, 0x856B, 0x854D, 0x8553, 0x8561, 0x8558, 0x0000, 	/* 0xEAF8 to 0xEAFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB00 to 0xEB07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB08 to 0xEB0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB10 to 0xEB17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB18 to 0xEB1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB20 to 0xEB27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB28 to 0xEB2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB30 to 0xEB37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB38 to 0xEB3F */
0x8540, 0x8546, 0x8564, 0x8541, 0x8562, 0x8544, 0x8551, 0x8547, 	/* 0xEB40 to 0xEB47 */
0x8563, 0x853E, 0x855B, 0x8571, 0x854E, 0x856E, 0x8575, 0x8555, 	/* 0xEB48 to 0xEB4F */
0x8567, 0x8560, 0x858C, 0x8566, 0x855D, 0x8554, 0x8565, 0x856C, 	/* 0xEB50 to 0xEB57 */
0x8663, 0x8665, 0x8664, 0x879B, 0x878F, 0x8797, 0x8793, 0x8792, 	/* 0xEB58 to 0xEB5F */
0x8788, 0x8781, 0x8796, 0x8798, 0x8779, 0x8787, 0x87A3, 0x8785, 	/* 0xEB60 to 0xEB67 */
0x8790, 0x8791, 0x879D, 0x8784, 0x8794, 0x879C, 0x879A, 0x8789, 	/* 0xEB68 to 0xEB6F */
0x891E, 0x8926, 0x8930, 0x892D, 0x892E, 0x8927, 0x8931, 0x8922, 	/* 0xEB70 to 0xEB77 */
0x8929, 0x8923, 0x892F, 0x892C, 0x891F, 0x89F1, 0x8AE0, 0x0000, 	/* 0xEB78 to 0xEB7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB80 to 0xEB87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB88 to 0xEB8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB90 to 0xEB97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEB98 to 0xEB9F */
0x0000, 0x8AE2, 0x8AF2, 0x8AF4, 0x8AF5, 0x8ADD, 0x8B14, 0x8AE4, 	/* 0xEBA0 to 0xEBA7 */
0x8ADF, 0x8AF0, 0x8AC8, 0x8ADE, 0x8AE1, 0x8AE8, 0x8AFF, 0x8AEF, 	/* 0xEBA8 to 0xEBAF */
0x8AFB, 0x8C91, 0x8C92, 0x8C90, 0x8CF5, 0x8CEE, 0x8CF1, 0x8CF0, 	/* 0xEBB0 to 0xEBB7 */
0x8CF3, 0x8D6C, 0x8D6E, 0x8DA5, 0x8DA7, 0x8E33, 0x8E3E, 0x8E38, 	/* 0xEBB8 to 0xEBBF */
0x8E40, 0x8E45, 0x8E36, 0x8E3C, 0x8E3D, 0x8E41, 0x8E30, 0x8E3F, 	/* 0xEBC0 to 0xEBC7 */
0x8EBD, 0x8F36, 0x8F2E, 0x8F35, 0x8F32, 0x8F39, 0x8F37, 0x8F34, 	/* 0xEBC8 to 0xEBCF */
0x9076, 0x9079, 0x907B, 0x9086, 0x90FA, 0x9133, 0x9135, 0x9136, 	/* 0xEBD0 to 0xEBD7 */
0x9193, 0x9190, 0x9191, 0x918D, 0x918F, 0x9327, 0x931E, 0x9308, 	/* 0xEBD8 to 0xEBDF */
0x931F, 0x9306, 0x930F, 0x937A, 0x9338, 0x933C, 0x931B, 0x9323, 	/* 0xEBE0 to 0xEBE7 */
0x9312, 0x9301, 0x9346, 0x932D, 0x930E, 0x930D, 0x92CB, 0x931D, 	/* 0xEBE8 to 0xEBEF */
0x92FA, 0x9325, 0x9313, 0x92F9, 0x92F7, 0x9334, 0x9302, 0x9324, 	/* 0xEBF0 to 0xEBF7 */
0x92FF, 0x9329, 0x9339, 0x9335, 0x932A, 0x9314, 0x930C, 0x0000, 	/* 0xEBF8 to 0xEBFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC00 to 0xEC07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC08 to 0xEC0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC10 to 0xEC17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC18 to 0xEC1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC20 to 0xEC27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC28 to 0xEC2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC30 to 0xEC37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC38 to 0xEC3F */
0x930B, 0x92FE, 0x9309, 0x9300, 0x92FB, 0x9316, 0x95BC, 0x95CD, 	/* 0xEC40 to 0xEC47 */
0x95BE, 0x95B9, 0x95BA, 0x95B6, 0x95BF, 0x95B5, 0x95BD, 0x96A9, 	/* 0xEC48 to 0xEC4F */
0x96D4, 0x970B, 0x9712, 0x9710, 0x9799, 0x9797, 0x9794, 0x97F0, 	/* 0xEC50 to 0xEC57 */
0x97F8, 0x9835, 0x982F, 0x9832, 0x9924, 0x991F, 0x9927, 0x9929, 	/* 0xEC58 to 0xEC5F */
0x999E, 0x99EE, 0x99EC, 0x99E5, 0x99E4, 0x99F0, 0x99E3, 0x99EA, 	/* 0xEC60 to 0xEC67 */
0x99E9, 0x99E7, 0x9AB9, 0x9ABF, 0x9AB4, 0x9ABB, 0x9AF6, 0x9AFA, 	/* 0xEC68 to 0xEC6F */
0x9AF9, 0x9AF7, 0x9B33, 0x9B80, 0x9B85, 0x9B87, 0x9B7C, 0x9B7E, 	/* 0xEC70 to 0xEC77 */
0x9B7B, 0x9B82, 0x9B93, 0x9B92, 0x9B90, 0x9B7A, 0x9B95, 0x0000, 	/* 0xEC78 to 0xEC7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC80 to 0xEC87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC88 to 0xEC8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC90 to 0xEC97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEC98 to 0xEC9F */
0x0000, 0x9B7D, 0x9B88, 0x9D25, 0x9D17, 0x9D20, 0x9D1E, 0x9D14, 	/* 0xECA0 to 0xECA7 */
0x9D29, 0x9D1D, 0x9D18, 0x9D22, 0x9D10, 0x9D19, 0x9D1F, 0x9E88, 	/* 0xECA8 to 0xECAF */
0x9E86, 0x9E87, 0x9EAE, 0x9EAD, 0x9ED5, 0x9ED6, 0x9EFA, 0x9F12, 	/* 0xECB0 to 0xECB7 */
0x9F3D, 0x5126, 0x5125, 0x5122, 0x5124, 0x5120, 0x5129, 0x52F4, 	/* 0xECB8 to 0xECBF */
0x5693, 0x568C, 0x568D, 0x5686, 0x5684, 0x5683, 0x567E, 0x5682, 	/* 0xECC0 to 0xECC7 */
0x567F, 0x5681, 0x58D6, 0x58D4, 0x58CF, 0x58D2, 0x5B2D, 0x5B25, 	/* 0xECC8 to 0xECCF */
0x5B32, 0x5B23, 0x5B2C, 0x5B27, 0x5B26, 0x5B2F, 0x5B2E, 0x5B7B, 	/* 0xECD0 to 0xECD7 */
0x5BF1, 0x5BF2, 0x5DB7, 0x5E6C, 0x5E6A, 0x5FBE, 0x5FBB, 0x61C3, 	/* 0xECD8 to 0xECDF */
0x61B5, 0x61BC, 0x61E7, 0x61E0, 0x61E5, 0x61E4, 0x61E8, 0x61DE, 	/* 0xECE0 to 0xECE7 */
0x64EF, 0x64E9, 0x64E3, 0x64EB, 0x64E4, 0x64E8, 0x6581, 0x6580, 	/* 0xECE8 to 0xECEF */
0x65B6, 0x65DA, 0x66D2, 0x6A8D, 0x6A96, 0x6A81, 0x6AA5, 0x6A89, 	/* 0xECF0 to 0xECF7 */
0x6A9F, 0x6A9B, 0x6AA1, 0x6A9E, 0x6A87, 0x6A93, 0x6A8E, 0x0000, 	/* 0xECF8 to 0xECFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED00 to 0xED07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED08 to 0xED0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED10 to 0xED17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED18 to 0xED1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED20 to 0xED27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED28 to 0xED2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED30 to 0xED37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED38 to 0xED3F */
0x6A95, 0x6A83, 0x6AA8, 0x6AA4, 0x6A91, 0x6A7F, 0x6AA6, 0x6A9A, 	/* 0xED40 to 0xED47 */
0x6A85, 0x6A8C, 0x6A92, 0x6B5B, 0x6BAD, 0x6C09, 0x6FCC, 0x6FA9, 	/* 0xED48 to 0xED4F */
0x6FF4, 0x6FD4, 0x6FE3, 0x6FDC, 0x6FED, 0x6FE7, 0x6FE6, 0x6FDE, 	/* 0xED50 to 0xED57 */
0x6FF2, 0x6FDD, 0x6FE2, 0x6FE8, 0x71E1, 0x71F1, 0x71E8, 0x71F2, 	/* 0xED58 to 0xED5F */
0x71E4, 0x71F0, 0x71E2, 0x7373, 0x736E, 0x736F, 0x7497, 0x74B2, 	/* 0xED60 to 0xED67 */
0x74AB, 0x7490, 0x74AA, 0x74AD, 0x74B1, 0x74A5, 0x74AF, 0x7510, 	/* 0xED68 to 0xED6F */
0x7511, 0x7512, 0x750F, 0x7584, 0x7643, 0x7648, 0x7649, 0x7647, 	/* 0xED70 to 0xED77 */
0x76A4, 0x76E9, 0x77B5, 0x77AB, 0x77B2, 0x77B7, 0x77B6, 0x0000, 	/* 0xED78 to 0xED7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED80 to 0xED87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED88 to 0xED8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED90 to 0xED97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xED98 to 0xED9F */
0x0000, 0x77B4, 0x77B1, 0x77A8, 0x77F0, 0x78F3, 0x78FD, 0x7902, 	/* 0xEDA0 to 0xEDA7 */
0x78FB, 0x78FC, 0x78F2, 0x7905, 0x78F9, 0x78FE, 0x7904, 0x79AB, 	/* 0xEDA8 to 0xEDAF */
0x79A8, 0x7A5C, 0x7A5B, 0x7A56, 0x7A58, 0x7A54, 0x7A5A, 0x7ABE, 	/* 0xEDB0 to 0xEDB7 */
0x7AC0, 0x7AC1, 0x7C05, 0x7C0F, 0x7BF2, 0x7C00, 0x7BFF, 0x7BFB, 	/* 0xEDB8 to 0xEDBF */
0x7C0E, 0x7BF4, 0x7C0B, 0x7BF3, 0x7C02, 0x7C09, 0x7C03, 0x7C01, 	/* 0xEDC0 to 0xEDC7 */
0x7BF8, 0x7BFD, 0x7C06, 0x7BF0, 0x7BF1, 0x7C10, 0x7C0A, 0x7CE8, 	/* 0xEDC8 to 0xEDCF */
0x7E2D, 0x7E3C, 0x7E42, 0x7E33, 0x9848, 0x7E38, 0x7E2A, 0x7E49, 	/* 0xEDD0 to 0xEDD7 */
0x7E40, 0x7E47, 0x7E29, 0x7E4C, 0x7E30, 0x7E3B, 0x7E36, 0x7E44, 	/* 0xEDD8 to 0xEDDF */
0x7E3A, 0x7F45, 0x7F7F, 0x7F7E, 0x7F7D, 0x7FF4, 0x7FF2, 0x802C, 	/* 0xEDE0 to 0xEDE7 */
0x81BB, 0x81C4, 0x81CC, 0x81CA, 0x81C5, 0x81C7, 0x81BC, 0x81E9, 	/* 0xEDE8 to 0xEDEF */
0x825B, 0x825A, 0x825C, 0x8583, 0x8580, 0x858F, 0x85A7, 0x8595, 	/* 0xEDF0 to 0xEDF7 */
0x85A0, 0x858B, 0x85A3, 0x857B, 0x85A4, 0x859A, 0x859E, 0x0000, 	/* 0xEDF8 to 0xEDFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE00 to 0xEE07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE08 to 0xEE0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE10 to 0xEE17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE18 to 0xEE1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE20 to 0xEE27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE28 to 0xEE2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE30 to 0xEE37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE38 to 0xEE3F */
0x8577, 0x857C, 0x8589, 0x85A1, 0x857A, 0x8578, 0x8557, 0x858E, 	/* 0xEE40 to 0xEE47 */
0x8596, 0x8586, 0x858D, 0x8599, 0x859D, 0x8581, 0x85A2, 0x8582, 	/* 0xEE48 to 0xEE4F */
0x8588, 0x8585, 0x8579, 0x8576, 0x8598, 0x8590, 0x859F, 0x8668, 	/* 0xEE50 to 0xEE57 */
0x87BE, 0x87AA, 0x87AD, 0x87C5, 0x87B0, 0x87AC, 0x87B9, 0x87B5, 	/* 0xEE58 to 0xEE5F */
0x87BC, 0x87AE, 0x87C9, 0x87C3, 0x87C2, 0x87CC, 0x87B7, 0x87AF, 	/* 0xEE60 to 0xEE67 */
0x87C4, 0x87CA, 0x87B4, 0x87B6, 0x87BF, 0x87B8, 0x87BD, 0x87DE, 	/* 0xEE68 to 0xEE6F */
0x87B2, 0x8935, 0x8933, 0x893C, 0x893E, 0x8941, 0x8952, 0x8937, 	/* 0xEE70 to 0xEE77 */
0x8942, 0x89AD, 0x89AF, 0x89AE, 0x89F2, 0x89F3, 0x8B1E, 0x0000, 	/* 0xEE78 to 0xEE7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE80 to 0xEE87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE88 to 0xEE8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE90 to 0xEE97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEE98 to 0xEE9F */
0x0000, 0x8B18, 0x8B16, 0x8B11, 0x8B05, 0x8B0B, 0x8B22, 0x8B0F, 	/* 0xEEA0 to 0xEEA7 */
0x8B12, 0x8B15, 0x8B07, 0x8B0D, 0x8B08, 0x8B06, 0x8B1C, 0x8B13, 	/* 0xEEA8 to 0xEEAF */
0x8B1A, 0x8C4F, 0x8C70, 0x8C72, 0x8C71, 0x8C6F, 0x8C95, 0x8C94, 	/* 0xEEB0 to 0xEEB7 */
0x8CF9, 0x8D6F, 0x8E4E, 0x8E4D, 0x8E53, 0x8E50, 0x8E4C, 0x8E47, 	/* 0xEEB8 to 0xEEBF */
0x8F43, 0x8F40, 0x9085, 0x907E, 0x9138, 0x919A, 0x91A2, 0x919B, 	/* 0xEEC0 to 0xEEC7 */
0x9199, 0x919F, 0x91A1, 0x919D, 0x91A0, 0x93A1, 0x9383, 0x93AF, 	/* 0xEEC8 to 0xEECF */
0x9364, 0x9356, 0x9347, 0x937C, 0x9358, 0x935C, 0x9376, 0x9349, 	/* 0xEED0 to 0xEED7 */
0x9350, 0x9351, 0x9360, 0x936D, 0x938F, 0x934C, 0x936A, 0x9379, 	/* 0xEED8 to 0xEEDF */
0x9357, 0x9355, 0x9352, 0x934F, 0x9371, 0x9377, 0x937B, 0x9361, 	/* 0xEEE0 to 0xEEE7 */
0x935E, 0x9363, 0x9367, 0x9380, 0x934E, 0x9359, 0x95C7, 0x95C0, 	/* 0xEEE8 to 0xEEEF */
0x95C9, 0x95C3, 0x95C5, 0x95B7, 0x96AE, 0x96B0, 0x96AC, 0x9720, 	/* 0xEEF0 to 0xEEF7 */
0x971F, 0x9718, 0x971D, 0x9719, 0x979A, 0x97A1, 0x979C, 0x0000, 	/* 0xEEF8 to 0xEEFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF00 to 0xEF07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF08 to 0xEF0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF10 to 0xEF17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF18 to 0xEF1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF20 to 0xEF27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF28 to 0xEF2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF30 to 0xEF37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF38 to 0xEF3F */
0x979E, 0x979D, 0x97D5, 0x97D4, 0x97F1, 0x9841, 0x9844, 0x984A, 	/* 0xEF40 to 0xEF47 */
0x9849, 0x9845, 0x9843, 0x9925, 0x992B, 0x992C, 0x992A, 0x9933, 	/* 0xEF48 to 0xEF4F */
0x9932, 0x992F, 0x992D, 0x9931, 0x9930, 0x9998, 0x99A3, 0x99A1, 	/* 0xEF50 to 0xEF57 */
0x9A02, 0x99FA, 0x99F4, 0x99F7, 0x99F9, 0x99F8, 0x99F6, 0x99FB, 	/* 0xEF58 to 0xEF5F */
0x99FD, 0x99FE, 0x99FC, 0x9A03, 0x9ABE, 0x9AFE, 0x9AFD, 0x9B01, 	/* 0xEF60 to 0xEF67 */
0x9AFC, 0x9B48, 0x9B9A, 0x9BA8, 0x9B9E, 0x9B9B, 0x9BA6, 0x9BA1, 	/* 0xEF68 to 0xEF6F */
0x9BA5, 0x9BA4, 0x9B86, 0x9BA2, 0x9BA0, 0x9BAF, 0x9D33, 0x9D41, 	/* 0xEF70 to 0xEF77 */
0x9D67, 0x9D36, 0x9D2E, 0x9D2F, 0x9D31, 0x9D38, 0x9D30, 0x0000, 	/* 0xEF78 to 0xEF7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF80 to 0xEF87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF88 to 0xEF8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF90 to 0xEF97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xEF98 to 0xEF9F */
0x0000, 0x9D45, 0x9D42, 0x9D43, 0x9D3E, 0x9D37, 0x9D40, 0x9D3D, 	/* 0xEFA0 to 0xEFA7 */
0x7FF5, 0x9D2D, 0x9E8A, 0x9E89, 0x9E8D, 0x9EB0, 0x9EC8, 0x9EDA, 	/* 0xEFA8 to 0xEFAF */
0x9EFB, 0x9EFF, 0x9F24, 0x9F23, 0x9F22, 0x9F54, 0x9FA0, 0x5131, 	/* 0xEFB0 to 0xEFB7 */
0x512D, 0x512E, 0x5698, 0x569C, 0x5697, 0x569A, 0x569D, 0x5699, 	/* 0xEFB8 to 0xEFBF */
0x5970, 0x5B3C, 0x5C69, 0x5C6A, 0x5DC0, 0x5E6D, 0x5E6E, 0x61D8, 	/* 0xEFC0 to 0xEFC7 */
0x61DF, 0x61ED, 0x61EE, 0x61F1, 0x61EA, 0x61F0, 0x61EB, 0x61D6, 	/* 0xEFC8 to 0xEFCF */
0x61E9, 0x64FF, 0x6504, 0x64FD, 0x64F8, 0x6501, 0x6503, 0x64FC, 	/* 0xEFD0 to 0xEFD7 */
0x6594, 0x65DB, 0x66DA, 0x66DB, 0x66D8, 0x6AC5, 0x6AB9, 0x6ABD, 	/* 0xEFD8 to 0xEFDF */
0x6AE1, 0x6AC6, 0x6ABA, 0x6AB6, 0x6AB7, 0x6AC7, 0x6AB4, 0x6AAD, 	/* 0xEFE0 to 0xEFE7 */
0x6B5E, 0x6BC9, 0x6C0B, 0x7007, 0x700C, 0x700D, 0x7001, 0x7005, 	/* 0xEFE8 to 0xEFEF */
0x7014, 0x700E, 0x6FFF, 0x7000, 0x6FFB, 0x7026, 0x6FFC, 0x6FF7, 	/* 0xEFF0 to 0xEFF7 */
0x700A, 0x7201, 0x71FF, 0x71F9, 0x7203, 0x71FD, 0x7376, 0x0000, 	/* 0xEFF8 to 0xEFFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF000 to 0xF007 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF008 to 0xF00F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF010 to 0xF017 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF018 to 0xF01F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF020 to 0xF027 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF028 to 0xF02F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF030 to 0xF037 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF038 to 0xF03F */
0x74B8, 0x74C0, 0x74B5, 0x74C1, 0x74BE, 0x74B6, 0x74BB, 0x74C2, 	/* 0xF040 to 0xF047 */
0x7514, 0x7513, 0x765C, 0x7664, 0x7659, 0x7650, 0x7653, 0x7657, 	/* 0xF048 to 0xF04F */
0x765A, 0x76A6, 0x76BD, 0x76EC, 0x77C2, 0x77BA, 0x78FF, 0x790C, 	/* 0xF050 to 0xF057 */
0x7913, 0x7914, 0x7909, 0x7910, 0x7912, 0x7911, 0x79AD, 0x79AC, 	/* 0xF058 to 0xF05F */
0x7A5F, 0x7C1C, 0x7C29, 0x7C19, 0x7C20, 0x7C1F, 0x7C2D, 0x7C1D, 	/* 0xF060 to 0xF067 */
0x7C26, 0x7C28, 0x7C22, 0x7C25, 0x7C30, 0x7E5C, 0x7E50, 0x7E56, 	/* 0xF068 to 0xF06F */
0x7E63, 0x7E58, 0x7E62, 0x7E5F, 0x7E51, 0x7E60, 0x7E57, 0x7E53, 	/* 0xF070 to 0xF077 */
0x7FB5, 0x7FB3, 0x7FF7, 0x7FF8, 0x8075, 0x81D1, 0x81D2, 0x0000, 	/* 0xF078 to 0xF07F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF080 to 0xF087 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF088 to 0xF08F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF090 to 0xF097 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF098 to 0xF09F */
0x0000, 0x81D0, 0x825F, 0x825E, 0x85B4, 0x85C6, 0x85C0, 0x85C3, 	/* 0xF0A0 to 0xF0A7 */
0x85C2, 0x85B3, 0x85B5, 0x85BD, 0x85C7, 0x85C4, 0x85BF, 0x85CB, 	/* 0xF0A8 to 0xF0AF */
0x85CE, 0x85C8, 0x85C5, 0x85B1, 0x85B6, 0x85D2, 0x8624, 0x85B8, 	/* 0xF0B0 to 0xF0B7 */
0x85B7, 0x85BE, 0x8669, 0x87E7, 0x87E6, 0x87E2, 0x87DB, 0x87EB, 	/* 0xF0B8 to 0xF0BF */
0x87EA, 0x87E5, 0x87DF, 0x87F3, 0x87E4, 0x87D4, 0x87DC, 0x87D3, 	/* 0xF0C0 to 0xF0C7 */
0x87ED, 0x87D8, 0x87E3, 0x87A4, 0x87D7, 0x87D9, 0x8801, 0x87F4, 	/* 0xF0C8 to 0xF0CF */
0x87E8, 0x87DD, 0x8953, 0x894B, 0x894F, 0x894C, 0x8946, 0x8950, 	/* 0xF0D0 to 0xF0D7 */
0x8951, 0x8949, 0x8B2A, 0x8B27, 0x8B23, 0x8B33, 0x8B30, 0x8B35, 	/* 0xF0D8 to 0xF0DF */
0x8B47, 0x8B2F, 0x8B3C, 0x8B3E, 0x8B31, 0x8B25, 0x8B37, 0x8B26, 	/* 0xF0E0 to 0xF0E7 */
0x8B36, 0x8B2E, 0x8B24, 0x8B3B, 0x8B3D, 0x8B3A, 0x8C42, 0x8C75, 	/* 0xF0E8 to 0xF0EF */
0x8C99, 0x8C98, 0x8C97, 0x8CFE, 0x8D04, 0x8D02, 0x8D00, 0x8E5C, 	/* 0xF0F0 to 0xF0F7 */
0x8E62, 0x8E60, 0x8E57, 0x8E56, 0x8E5E, 0x8E65, 0x8E67, 0x0000, 	/* 0xF0F8 to 0xF0FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF100 to 0xF107 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF108 to 0xF10F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF110 to 0xF117 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF118 to 0xF11F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF120 to 0xF127 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF128 to 0xF12F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF130 to 0xF137 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF138 to 0xF13F */
0x8E5B, 0x8E5A, 0x8E61, 0x8E5D, 0x8E69, 0x8E54, 0x8F46, 0x8F47, 	/* 0xF140 to 0xF147 */
0x8F48, 0x8F4B, 0x9128, 0x913A, 0x913B, 0x913E, 0x91A8, 0x91A5, 	/* 0xF148 to 0xF14F */
0x91A7, 0x91AF, 0x91AA, 0x93B5, 0x938C, 0x9392, 0x93B7, 0x939B, 	/* 0xF150 to 0xF157 */
0x939D, 0x9389, 0x93A7, 0x938E, 0x93AA, 0x939E, 0x93A6, 0x9395, 	/* 0xF158 to 0xF15F */
0x9388, 0x9399, 0x939F, 0x938D, 0x93B1, 0x9391, 0x93B2, 0x93A4, 	/* 0xF160 to 0xF167 */
0x93A8, 0x93B4, 0x93A3, 0x93A5, 0x95D2, 0x95D3, 0x95D1, 0x96B3, 	/* 0xF168 to 0xF16F */
0x96D7, 0x96DA, 0x5DC2, 0x96DF, 0x96D8, 0x96DD, 0x9723, 0x9722, 	/* 0xF170 to 0xF177 */
0x9725, 0x97AC, 0x97AE, 0x97A8, 0x97AB, 0x97A4, 0x97AA, 0x0000, 	/* 0xF178 to 0xF17F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF180 to 0xF187 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF188 to 0xF18F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF190 to 0xF197 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF198 to 0xF19F */
0x0000, 0x97A2, 0x97A5, 0x97D7, 0x97D9, 0x97D6, 0x97D8, 0x97FA, 	/* 0xF1A0 to 0xF1A7 */
0x9850, 0x9851, 0x9852, 0x98B8, 0x9941, 0x993C, 0x993A, 0x9A0F, 	/* 0xF1A8 to 0xF1AF */
0x9A0B, 0x9A09, 0x9A0D, 0x9A04, 0x9A11, 0x9A0A, 0x9A05, 0x9A07, 	/* 0xF1B0 to 0xF1B7 */
0x9A06, 0x9AC0, 0x9ADC, 0x9B08, 0x9B04, 0x9B05, 0x9B29, 0x9B35, 	/* 0xF1B8 to 0xF1BF */
0x9B4A, 0x9B4C, 0x9B4B, 0x9BC7, 0x9BC6, 0x9BC3, 0x9BBF, 0x9BC1, 	/* 0xF1C0 to 0xF1C7 */
0x9BB5, 0x9BB8, 0x9BD3, 0x9BB6, 0x9BC4, 0x9BB9, 0x9BBD, 0x9D5C, 	/* 0xF1C8 to 0xF1CF */
0x9D53, 0x9D4F, 0x9D4A, 0x9D5B, 0x9D4B, 0x9D59, 0x9D56, 0x9D4C, 	/* 0xF1D0 to 0xF1D7 */
0x9D57, 0x9D52, 0x9D54, 0x9D5F, 0x9D58, 0x9D5A, 0x9E8E, 0x9E8C, 	/* 0xF1D8 to 0xF1DF */
0x9EDF, 0x9F01, 0x9F00, 0x9F16, 0x9F25, 0x9F2B, 0x9F2A, 0x9F29, 	/* 0xF1E0 to 0xF1E7 */
0x9F28, 0x9F4C, 0x9F55, 0x5134, 0x5135, 0x5296, 0x52F7, 0x53B4, 	/* 0xF1E8 to 0xF1EF */
0x56AB, 0x56AD, 0x56A6, 0x56A7, 0x56AA, 0x56AC, 0x58DA, 0x58DD, 	/* 0xF1F0 to 0xF1F7 */
0x58DB, 0x5912, 0x5B3D, 0x5B3E, 0x5B3F, 0x5DC3, 0x5E70, 0x0000, 	/* 0xF1F8 to 0xF1FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF200 to 0xF207 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF208 to 0xF20F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF210 to 0xF217 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF218 to 0xF21F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF220 to 0xF227 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF228 to 0xF22F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF230 to 0xF237 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF238 to 0xF23F */
0x5FBF, 0x61FB, 0x6507, 0x6510, 0x650D, 0x6509, 0x650C, 0x650E, 	/* 0xF240 to 0xF247 */
0x6584, 0x65DE, 0x65DD, 0x66DE, 0x6AE7, 0x6AE0, 0x6ACC, 0x6AD1, 	/* 0xF248 to 0xF24F */
0x6AD9, 0x6ACB, 0x6ADF, 0x6ADC, 0x6AD0, 0x6AEB, 0x6ACF, 0x6ACD, 	/* 0xF250 to 0xF257 */
0x6ADE, 0x6B60, 0x6BB0, 0x6C0C, 0x7019, 0x7027, 0x7020, 0x7016, 	/* 0xF258 to 0xF25F */
0x702B, 0x7021, 0x7022, 0x7023, 0x7029, 0x7017, 0x7024, 0x701C, 	/* 0xF260 to 0xF267 */
0x702A, 0x720C, 0x720A, 0x7207, 0x7202, 0x7205, 0x72A5, 0x72A6, 	/* 0xF268 to 0xF26F */
0x72A4, 0x72A3, 0x72A1, 0x74CB, 0x74C5, 0x74B7, 0x74C3, 0x7516, 	/* 0xF270 to 0xF277 */
0x7660, 0x77C9, 0x77CA, 0x77C4, 0x77F1, 0x791D, 0x791B, 0x0000, 	/* 0xF278 to 0xF27F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF280 to 0xF287 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF288 to 0xF28F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF290 to 0xF297 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF298 to 0xF29F */
0x0000, 0x7921, 0x791C, 0x7917, 0x791E, 0x79B0, 0x7A67, 0x7A68, 	/* 0xF2A0 to 0xF2A7 */
0x7C33, 0x7C3C, 0x7C39, 0x7C2C, 0x7C3B, 0x7CEC, 0x7CEA, 0x7E76, 	/* 0xF2A8 to 0xF2AF */
0x7E75, 0x7E78, 0x7E70, 0x7E77, 0x7E6F, 0x7E7A, 0x7E72, 0x7E74, 	/* 0xF2B0 to 0xF2B7 */
0x7E68, 0x7F4B, 0x7F4A, 0x7F83, 0x7F86, 0x7FB7, 0x7FFD, 0x7FFE, 	/* 0xF2B8 to 0xF2BF */
0x8078, 0x81D7, 0x81D5, 0x8264, 0x8261, 0x8263, 0x85EB, 0x85F1, 	/* 0xF2C0 to 0xF2C7 */
0x85ED, 0x85D9, 0x85E1, 0x85E8, 0x85DA, 0x85D7, 0x85EC, 0x85F2, 	/* 0xF2C8 to 0xF2CF */
0x85F8, 0x85D8, 0x85DF, 0x85E3, 0x85DC, 0x85D1, 0x85F0, 0x85E6, 	/* 0xF2D0 to 0xF2D7 */
0x85EF, 0x85DE, 0x85E2, 0x8800, 0x87FA, 0x8803, 0x87F6, 0x87F7, 	/* 0xF2D8 to 0xF2DF */
0x8809, 0x880C, 0x880B, 0x8806, 0x87FC, 0x8808, 0x87FF, 0x880A, 	/* 0xF2E0 to 0xF2E7 */
0x8802, 0x8962, 0x895A, 0x895B, 0x8957, 0x8961, 0x895C, 0x8958, 	/* 0xF2E8 to 0xF2EF */
0x895D, 0x8959, 0x8988, 0x89B7, 0x89B6, 0x89F6, 0x8B50, 0x8B48, 	/* 0xF2F0 to 0xF2F7 */
0x8B4A, 0x8B40, 0x8B53, 0x8B56, 0x8B54, 0x8B4B, 0x8B55, 0x0000, 	/* 0xF2F8 to 0xF2FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF300 to 0xF307 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF308 to 0xF30F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF310 to 0xF317 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF318 to 0xF31F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF320 to 0xF327 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF328 to 0xF32F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF330 to 0xF337 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF338 to 0xF33F */
0x8B51, 0x8B42, 0x8B52, 0x8B57, 0x8C43, 0x8C77, 0x8C76, 0x8C9A, 	/* 0xF340 to 0xF347 */
0x8D06, 0x8D07, 0x8D09, 0x8DAC, 0x8DAA, 0x8DAD, 0x8DAB, 0x8E6D, 	/* 0xF348 to 0xF34F */
0x8E78, 0x8E73, 0x8E6A, 0x8E6F, 0x8E7B, 0x8EC2, 0x8F52, 0x8F51, 	/* 0xF350 to 0xF357 */
0x8F4F, 0x8F50, 0x8F53, 0x8FB4, 0x9140, 0x913F, 0x91B0, 0x91AD, 	/* 0xF358 to 0xF35F */
0x93DE, 0x93C7, 0x93CF, 0x93C2, 0x93DA, 0x93D0, 0x93F9, 0x93EC, 	/* 0xF360 to 0xF367 */
0x93CC, 0x93D9, 0x93A9, 0x93E6, 0x93CA, 0x93D4, 0x93EE, 0x93E3, 	/* 0xF368 to 0xF36F */
0x93D5, 0x93C4, 0x93CE, 0x93C0, 0x93D2, 0x93E7, 0x957D, 0x95DA, 	/* 0xF370 to 0xF377 */
0x95DB, 0x96E1, 0x9729, 0x972B, 0x972C, 0x9728, 0x9726, 0x0000, 	/* 0xF378 to 0xF37F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF380 to 0xF387 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF388 to 0xF38F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF390 to 0xF397 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF398 to 0xF39F */
0x0000, 0x97B3, 0x97B7, 0x97B6, 0x97DD, 0x97DE, 0x97DF, 0x985C, 	/* 0xF3A0 to 0xF3A7 */
0x9859, 0x985D, 0x9857, 0x98BF, 0x98BD, 0x98BB, 0x98BE, 0x9948, 	/* 0xF3A8 to 0xF3AF */
0x9947, 0x9943, 0x99A6, 0x99A7, 0x9A1A, 0x9A15, 0x9A25, 0x9A1D, 	/* 0xF3B0 to 0xF3B7 */
0x9A24, 0x9A1B, 0x9A22, 0x9A20, 0x9A27, 0x9A23, 0x9A1E, 0x9A1C, 	/* 0xF3B8 to 0xF3BF */
0x9A14, 0x9AC2, 0x9B0B, 0x9B0A, 0x9B0E, 0x9B0C, 0x9B37, 0x9BEA, 	/* 0xF3C0 to 0xF3C7 */
0x9BEB, 0x9BE0, 0x9BDE, 0x9BE4, 0x9BE6, 0x9BE2, 0x9BF0, 0x9BD4, 	/* 0xF3C8 to 0xF3CF */
0x9BD7, 0x9BEC, 0x9BDC, 0x9BD9, 0x9BE5, 0x9BD5, 0x9BE1, 0x9BDA, 	/* 0xF3D0 to 0xF3D7 */
0x9D77, 0x9D81, 0x9D8A, 0x9D84, 0x9D88, 0x9D71, 0x9D80, 0x9D78, 	/* 0xF3D8 to 0xF3DF */
0x9D86, 0x9D8B, 0x9D8C, 0x9D7D, 0x9D6B, 0x9D74, 0x9D75, 0x9D70, 	/* 0xF3E0 to 0xF3E7 */
0x9D69, 0x9D85, 0x9D73, 0x9D7B, 0x9D82, 0x9D6F, 0x9D79, 0x9D7F, 	/* 0xF3E8 to 0xF3EF */
0x9D87, 0x9D68, 0x9E94, 0x9E91, 0x9EC0, 0x9EFC, 0x9F2D, 0x9F40, 	/* 0xF3F0 to 0xF3F7 */
0x9F41, 0x9F4D, 0x9F56, 0x9F57, 0x9F58, 0x5337, 0x56B2, 0x0000, 	/* 0xF3F8 to 0xF3FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF400 to 0xF407 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF408 to 0xF40F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF410 to 0xF417 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF418 to 0xF41F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF420 to 0xF427 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF428 to 0xF42F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF430 to 0xF437 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF438 to 0xF43F */
0x56B5, 0x56B3, 0x58E3, 0x5B45, 0x5DC6, 0x5DC7, 0x5EEE, 0x5EEF, 	/* 0xF440 to 0xF447 */
0x5FC0, 0x5FC1, 0x61F9, 0x6517, 0x6516, 0x6515, 0x6513, 0x65DF, 	/* 0xF448 to 0xF44F */
0x66E8, 0x66E3, 0x66E4, 0x6AF3, 0x6AF0, 0x6AEA, 0x6AE8, 0x6AF9, 	/* 0xF450 to 0xF457 */
0x6AF1, 0x6AEE, 0x6AEF, 0x703C, 0x7035, 0x702F, 0x7037, 0x7034, 	/* 0xF458 to 0xF45F */
0x7031, 0x7042, 0x7038, 0x703F, 0x703A, 0x7039, 0x7040, 0x703B, 	/* 0xF460 to 0xF467 */
0x7033, 0x7041, 0x7213, 0x7214, 0x72A8, 0x737D, 0x737C, 0x74BA, 	/* 0xF468 to 0xF46F */
0x76AB, 0x76AA, 0x76BE, 0x76ED, 0x77CC, 0x77CE, 0x77CF, 0x77CD, 	/* 0xF470 to 0xF477 */
0x77F2, 0x7925, 0x7923, 0x7927, 0x7928, 0x7924, 0x7929, 0x0000, 	/* 0xF478 to 0xF47F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF480 to 0xF487 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF488 to 0xF48F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF490 to 0xF497 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF498 to 0xF49F */
0x0000, 0x79B2, 0x7A6E, 0x7A6C, 0x7A6D, 0x7AF7, 0x7C49, 0x7C48, 	/* 0xF4A0 to 0xF4A7 */
0x7C4A, 0x7C47, 0x7C45, 0x7CEE, 0x7E7B, 0x7E7E, 0x7E81, 0x7E80, 	/* 0xF4A8 to 0xF4AF */
0x7FBA, 0x7FFF, 0x8079, 0x81DB, 0x81D9, 0x820B, 0x8268, 0x8269, 	/* 0xF4B0 to 0xF4B7 */
0x8622, 0x85FF, 0x8601, 0x85FE, 0x861B, 0x8600, 0x85F6, 0x8604, 	/* 0xF4B8 to 0xF4BF */
0x8609, 0x8605, 0x860C, 0x85FD, 0x8819, 0x8810, 0x8811, 0x8817, 	/* 0xF4C0 to 0xF4C7 */
0x8813, 0x8816, 0x8963, 0x8966, 0x89B9, 0x89F7, 0x8B60, 0x8B6A, 	/* 0xF4C8 to 0xF4CF */
0x8B5D, 0x8B68, 0x8B63, 0x8B65, 0x8B67, 0x8B6D, 0x8DAE, 0x8E86, 	/* 0xF4D0 to 0xF4D7 */
0x8E88, 0x8E84, 0x8F59, 0x8F56, 0x8F57, 0x8F55, 0x8F58, 0x8F5A, 	/* 0xF4D8 to 0xF4DF */
0x908D, 0x9143, 0x9141, 0x91B7, 0x91B5, 0x91B2, 0x91B3, 0x940B, 	/* 0xF4E0 to 0xF4E7 */
0x9413, 0x93FB, 0x9420, 0x940F, 0x9414, 0x93FE, 0x9415, 0x9410, 	/* 0xF4E8 to 0xF4EF */
0x9428, 0x9419, 0x940D, 0x93F5, 0x9400, 0x93F7, 0x9407, 0x940E, 	/* 0xF4F0 to 0xF4F7 */
0x9416, 0x9412, 0x93FA, 0x9409, 0x93F8, 0x940A, 0x93FF, 0x0000, 	/* 0xF4F8 to 0xF4FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF500 to 0xF507 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF508 to 0xF50F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF510 to 0xF517 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF518 to 0xF51F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF520 to 0xF527 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF528 to 0xF52F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF530 to 0xF537 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF538 to 0xF53F */
0x93FC, 0x940C, 0x93F6, 0x9411, 0x9406, 0x95DE, 0x95E0, 0x95DF, 	/* 0xF540 to 0xF547 */
0x972E, 0x972F, 0x97B9, 0x97BB, 0x97FD, 0x97FE, 0x9860, 0x9862, 	/* 0xF548 to 0xF54F */
0x9863, 0x985F, 0x98C1, 0x98C2, 0x9950, 0x994E, 0x9959, 0x994C, 	/* 0xF550 to 0xF557 */
0x994B, 0x9953, 0x9A32, 0x9A34, 0x9A31, 0x9A2C, 0x9A2A, 0x9A36, 	/* 0xF558 to 0xF55F */
0x9A29, 0x9A2E, 0x9A38, 0x9A2D, 0x9AC7, 0x9ACA, 0x9AC6, 0x9B10, 	/* 0xF560 to 0xF567 */
0x9B12, 0x9B11, 0x9C0B, 0x9C08, 0x9BF7, 0x9C05, 0x9C12, 0x9BF8, 	/* 0xF568 to 0xF56F */
0x9C40, 0x9C07, 0x9C0E, 0x9C06, 0x9C17, 0x9C14, 0x9C09, 0x9D9F, 	/* 0xF570 to 0xF577 */
0x9D99, 0x9DA4, 0x9D9D, 0x9D92, 0x9D98, 0x9D90, 0x9D9B, 0x0000, 	/* 0xF578 to 0xF57F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF580 to 0xF587 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF588 to 0xF58F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF590 to 0xF597 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF598 to 0xF59F */
0x0000, 0x9DA0, 0x9D94, 0x9D9C, 0x9DAA, 0x9D97, 0x9DA1, 0x9D9A, 	/* 0xF5A0 to 0xF5A7 */
0x9DA2, 0x9DA8, 0x9D9E, 0x9DA3, 0x9DBF, 0x9DA9, 0x9D96, 0x9DA6, 	/* 0xF5A8 to 0xF5AF */
0x9DA7, 0x9E99, 0x9E9B, 0x9E9A, 0x9EE5, 0x9EE4, 0x9EE7, 0x9EE6, 	/* 0xF5B0 to 0xF5B7 */
0x9F30, 0x9F2E, 0x9F5B, 0x9F60, 0x9F5E, 0x9F5D, 0x9F59, 0x9F91, 	/* 0xF5B8 to 0xF5BF */
0x513A, 0x5139, 0x5298, 0x5297, 0x56C3, 0x56BD, 0x56BE, 0x5B48, 	/* 0xF5C0 to 0xF5C7 */
0x5B47, 0x5DCB, 0x5DCF, 0x5EF1, 0x61FD, 0x651B, 0x6B02, 0x6AFC, 	/* 0xF5C8 to 0xF5CF */
0x6B03, 0x6AF8, 0x6B00, 0x7043, 0x7044, 0x704A, 0x7048, 0x7049, 	/* 0xF5D0 to 0xF5D7 */
0x7045, 0x7046, 0x721D, 0x721A, 0x7219, 0x737E, 0x7517, 0x766A, 	/* 0xF5D8 to 0xF5DF */
0x77D0, 0x792D, 0x7931, 0x792F, 0x7C54, 0x7C53, 0x7CF2, 0x7E8A, 	/* 0xF5E0 to 0xF5E7 */
0x7E87, 0x7E88, 0x7E8B, 0x7E86, 0x7E8D, 0x7F4D, 0x7FBB, 0x8030, 	/* 0xF5E8 to 0xF5EF */
0x81DD, 0x8618, 0x862A, 0x8626, 0x861F, 0x8623, 0x861C, 0x8619, 	/* 0xF5F0 to 0xF5F7 */
0x8627, 0x862E, 0x8621, 0x8620, 0x8629, 0x861E, 0x8625, 0x0000, 	/* 0xF5F8 to 0xF5FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF600 to 0xF607 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF608 to 0xF60F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF610 to 0xF617 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF618 to 0xF61F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF620 to 0xF627 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF628 to 0xF62F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF630 to 0xF637 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF638 to 0xF63F */
0x8829, 0x881D, 0x881B, 0x8820, 0x8824, 0x881C, 0x882B, 0x884A, 	/* 0xF640 to 0xF647 */
0x896D, 0x8969, 0x896E, 0x896B, 0x89FA, 0x8B79, 0x8B78, 0x8B45, 	/* 0xF648 to 0xF64F */
0x8B7A, 0x8B7B, 0x8D10, 0x8D14, 0x8DAF, 0x8E8E, 0x8E8C, 0x8F5E, 	/* 0xF650 to 0xF657 */
0x8F5B, 0x8F5D, 0x9146, 0x9144, 0x9145, 0x91B9, 0x943F, 0x943B, 	/* 0xF658 to 0xF65F */
0x9436, 0x9429, 0x943D, 0x943C, 0x9430, 0x9439, 0x942A, 0x9437, 	/* 0xF660 to 0xF667 */
0x942C, 0x9440, 0x9431, 0x95E5, 0x95E4, 0x95E3, 0x9735, 0x973A, 	/* 0xF668 to 0xF66F */
0x97BF, 0x97E1, 0x9864, 0x98C9, 0x98C6, 0x98C0, 0x9958, 0x9956, 	/* 0xF670 to 0xF677 */
0x9A39, 0x9A3D, 0x9A46, 0x9A44, 0x9A42, 0x9A41, 0x9A3A, 0x0000, 	/* 0xF678 to 0xF67F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF680 to 0xF687 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF688 to 0xF68F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF690 to 0xF697 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF698 to 0xF69F */
0x0000, 0x9A3F, 0x9ACD, 0x9B15, 0x9B17, 0x9B18, 0x9B16, 0x9B3A, 	/* 0xF6A0 to 0xF6A7 */
0x9B52, 0x9C2B, 0x9C1D, 0x9C1C, 0x9C2C, 0x9C23, 0x9C28, 0x9C29, 	/* 0xF6A8 to 0xF6AF */
0x9C24, 0x9C21, 0x9DB7, 0x9DB6, 0x9DBC, 0x9DC1, 0x9DC7, 0x9DCA, 	/* 0xF6B0 to 0xF6B7 */
0x9DCF, 0x9DBE, 0x9DC5, 0x9DC3, 0x9DBB, 0x9DB5, 0x9DCE, 0x9DB9, 	/* 0xF6B8 to 0xF6BF */
0x9DBA, 0x9DAC, 0x9DC8, 0x9DB1, 0x9DAD, 0x9DCC, 0x9DB3, 0x9DCD, 	/* 0xF6C0 to 0xF6C7 */
0x9DB2, 0x9E7A, 0x9E9C, 0x9EEB, 0x9EEE, 0x9EED, 0x9F1B, 0x9F18, 	/* 0xF6C8 to 0xF6CF */
0x9F1A, 0x9F31, 0x9F4E, 0x9F65, 0x9F64, 0x9F92, 0x4EB9, 0x56C6, 	/* 0xF6D0 to 0xF6D7 */
0x56C5, 0x56CB, 0x5971, 0x5B4B, 0x5B4C, 0x5DD5, 0x5DD1, 0x5EF2, 	/* 0xF6D8 to 0xF6DF */
0x6521, 0x6520, 0x6526, 0x6522, 0x6B0B, 0x6B08, 0x6B09, 0x6C0D, 	/* 0xF6E0 to 0xF6E7 */
0x7055, 0x7056, 0x7057, 0x7052, 0x721E, 0x721F, 0x72A9, 0x737F, 	/* 0xF6E8 to 0xF6EF */
0x74D8, 0x74D5, 0x74D9, 0x74D7, 0x766D, 0x76AD, 0x7935, 0x79B4, 	/* 0xF6F0 to 0xF6F7 */
0x7A70, 0x7A71, 0x7C57, 0x7C5C, 0x7C59, 0x7C5B, 0x7C5A, 0x0000, 	/* 0xF6F8 to 0xF6FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF700 to 0xF707 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF708 to 0xF70F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF710 to 0xF717 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF718 to 0xF71F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF720 to 0xF727 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF728 to 0xF72F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF730 to 0xF737 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF738 to 0xF73F */
0x7CF4, 0x7CF1, 0x7E91, 0x7F4F, 0x7F87, 0x81DE, 0x826B, 0x8634, 	/* 0xF740 to 0xF747 */
0x8635, 0x8633, 0x862C, 0x8632, 0x8636, 0x882C, 0x8828, 0x8826, 	/* 0xF748 to 0xF74F */
0x882A, 0x8825, 0x8971, 0x89BF, 0x89BE, 0x89FB, 0x8B7E, 0x8B84, 	/* 0xF750 to 0xF757 */
0x8B82, 0x8B86, 0x8B85, 0x8B7F, 0x8D15, 0x8E95, 0x8E94, 0x8E9A, 	/* 0xF758 to 0xF75F */
0x8E92, 0x8E90, 0x8E96, 0x8E97, 0x8F60, 0x8F62, 0x9147, 0x944C, 	/* 0xF760 to 0xF767 */
0x9450, 0x944A, 0x944B, 0x944F, 0x9447, 0x9445, 0x9448, 0x9449, 	/* 0xF768 to 0xF76F */
0x9446, 0x973F, 0x97E3, 0x986A, 0x9869, 0x98CB, 0x9954, 0x995B, 	/* 0xF770 to 0xF777 */
0x9A4E, 0x9A53, 0x9A54, 0x9A4C, 0x9A4F, 0x9A48, 0x9A4A, 0x0000, 	/* 0xF778 to 0xF77F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF780 to 0xF787 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF788 to 0xF78F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF790 to 0xF797 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF798 to 0xF79F */
0x0000, 0x9A49, 0x9A52, 0x9A50, 0x9AD0, 0x9B19, 0x9B2B, 0x9B3B, 	/* 0xF7A0 to 0xF7A7 */
0x9B56, 0x9B55, 0x9C46, 0x9C48, 0x9C3F, 0x9C44, 0x9C39, 0x9C33, 	/* 0xF7A8 to 0xF7AF */
0x9C41, 0x9C3C, 0x9C37, 0x9C34, 0x9C32, 0x9C3D, 0x9C36, 0x9DDB, 	/* 0xF7B0 to 0xF7B7 */
0x9DD2, 0x9DDE, 0x9DDA, 0x9DCB, 0x9DD0, 0x9DDC, 0x9DD1, 0x9DDF, 	/* 0xF7B8 to 0xF7BF */
0x9DE9, 0x9DD9, 0x9DD8, 0x9DD6, 0x9DF5, 0x9DD5, 0x9DDD, 0x9EB6, 	/* 0xF7C0 to 0xF7C7 */
0x9EF0, 0x9F35, 0x9F33, 0x9F32, 0x9F42, 0x9F6B, 0x9F95, 0x9FA2, 	/* 0xF7C8 to 0xF7CF */
0x513D, 0x5299, 0x58E8, 0x58E7, 0x5972, 0x5B4D, 0x5DD8, 0x882F, 	/* 0xF7D0 to 0xF7D7 */
0x5F4F, 0x6201, 0x6203, 0x6204, 0x6529, 0x6525, 0x6596, 0x66EB, 	/* 0xF7D8 to 0xF7DF */
0x6B11, 0x6B12, 0x6B0F, 0x6BCA, 0x705B, 0x705A, 0x7222, 0x7382, 	/* 0xF7E0 to 0xF7E7 */
0x7381, 0x7383, 0x7670, 0x77D4, 0x7C67, 0x7C66, 0x7E95, 0x826C, 	/* 0xF7E8 to 0xF7EF */
0x863A, 0x8640, 0x8639, 0x863C, 0x8631, 0x863B, 0x863E, 0x8830, 	/* 0xF7F0 to 0xF7F7 */
0x8832, 0x882E, 0x8833, 0x8976, 0x8974, 0x8973, 0x89FE, 0x0000, 	/* 0xF7F8 to 0xF7FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF800 to 0xF807 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF808 to 0xF80F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF810 to 0xF817 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF818 to 0xF81F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF820 to 0xF827 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF828 to 0xF82F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF830 to 0xF837 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF838 to 0xF83F */
0x8B8C, 0x8B8E, 0x8B8B, 0x8B88, 0x8C45, 0x8D19, 0x8E98, 0x8F64, 	/* 0xF840 to 0xF847 */
0x8F63, 0x91BC, 0x9462, 0x9455, 0x945D, 0x9457, 0x945E, 0x97C4, 	/* 0xF848 to 0xF84F */
0x97C5, 0x9800, 0x9A56, 0x9A59, 0x9B1E, 0x9B1F, 0x9B20, 0x9C52, 	/* 0xF850 to 0xF857 */
0x9C58, 0x9C50, 0x9C4A, 0x9C4D, 0x9C4B, 0x9C55, 0x9C59, 0x9C4C, 	/* 0xF858 to 0xF85F */
0x9C4E, 0x9DFB, 0x9DF7, 0x9DEF, 0x9DE3, 0x9DEB, 0x9DF8, 0x9DE4, 	/* 0xF860 to 0xF867 */
0x9DF6, 0x9DE1, 0x9DEE, 0x9DE6, 0x9DF2, 0x9DF0, 0x9DE2, 0x9DEC, 	/* 0xF868 to 0xF86F */
0x9DF4, 0x9DF3, 0x9DE8, 0x9DED, 0x9EC2, 0x9ED0, 0x9EF2, 0x9EF3, 	/* 0xF870 to 0xF877 */
0x9F06, 0x9F1C, 0x9F38, 0x9F37, 0x9F36, 0x9F43, 0x9F4F, 0x0000, 	/* 0xF878 to 0xF87F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF880 to 0xF887 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF888 to 0xF88F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF890 to 0xF897 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF898 to 0xF89F */
0x0000, 0x9F71, 0x9F70, 0x9F6E, 0x9F6F, 0x56D3, 0x56CD, 0x5B4E, 	/* 0xF8A0 to 0xF8A7 */
0x5C6D, 0x652D, 0x66ED, 0x66EE, 0x6B13, 0x705F, 0x7061, 0x705D, 	/* 0xF8A8 to 0xF8AF */
0x7060, 0x7223, 0x74DB, 0x74E5, 0x77D5, 0x7938, 0x79B7, 0x79B6, 	/* 0xF8B0 to 0xF8B7 */
0x7C6A, 0x7E97, 0x7F89, 0x826D, 0x8643, 0x8838, 0x8837, 0x8835, 	/* 0xF8B8 to 0xF8BF */
0x884B, 0x8B94, 0x8B95, 0x8E9E, 0x8E9F, 0x8EA0, 0x8E9D, 0x91BE, 	/* 0xF8C0 to 0xF8C7 */
0x91BD, 0x91C2, 0x946B, 0x9468, 0x9469, 0x96E5, 0x9746, 0x9743, 	/* 0xF8C8 to 0xF8CF */
0x9747, 0x97C7, 0x97E5, 0x9A5E, 0x9AD5, 0x9B59, 0x9C63, 0x9C67, 	/* 0xF8D0 to 0xF8D7 */
0x9C66, 0x9C62, 0x9C5E, 0x9C60, 0x9E02, 0x9DFE, 0x9E07, 0x9E03, 	/* 0xF8D8 to 0xF8DF */
0x9E06, 0x9E05, 0x9E00, 0x9E01, 0x9E09, 0x9DFF, 0x9DFD, 0x9E04, 	/* 0xF8E0 to 0xF8E7 */
0x9EA0, 0x9F1E, 0x9F46, 0x9F74, 0x9F75, 0x9F76, 0x56D4, 0x652E, 	/* 0xF8E8 to 0xF8EF */
0x65B8, 0x6B18, 0x6B19, 0x6B17, 0x6B1A, 0x7062, 0x7226, 0x72AA, 	/* 0xF8F0 to 0xF8F7 */
0x77D8, 0x77D9, 0x7939, 0x7C69, 0x7C6B, 0x7CF6, 0x7E9A, 0x0000, 	/* 0xF8F8 to 0xF8FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF900 to 0xF907 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF908 to 0xF90F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF910 to 0xF917 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF918 to 0xF91F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF920 to 0xF927 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF928 to 0xF92F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF930 to 0xF937 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF938 to 0xF93F */
0x7E98, 0x7E9B, 0x7E99, 0x81E0, 0x81E1, 0x8646, 0x8647, 0x8648, 	/* 0xF940 to 0xF947 */
0x8979, 0x897A, 0x897C, 0x897B, 0x89FF, 0x8B98, 0x8B99, 0x8EA5, 	/* 0xF948 to 0xF94F */
0x8EA4, 0x8EA3, 0x946E, 0x946D, 0x946F, 0x9471, 0x9473, 0x9749, 	/* 0xF950 to 0xF957 */
0x9872, 0x995F, 0x9C68, 0x9C6E, 0x9C6D, 0x9E0B, 0x9E0D, 0x9E10, 	/* 0xF958 to 0xF95F */
0x9E0F, 0x9E12, 0x9E11, 0x9EA1, 0x9EF5, 0x9F09, 0x9F47, 0x9F78, 	/* 0xF960 to 0xF967 */
0x9F7B, 0x9F7A, 0x9F79, 0x571E, 0x7066, 0x7C6F, 0x883C, 0x8DB2, 	/* 0xF968 to 0xF96F */
0x8EA6, 0x91C3, 0x9474, 0x9478, 0x9476, 0x9475, 0x9A60, 0x9C74, 	/* 0xF970 to 0xF977 */
0x9C73, 0x9C71, 0x9C75, 0x9E14, 0x9E13, 0x9EF6, 0x9F0A, 0x0000, 	/* 0xF978 to 0xF97F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF980 to 0xF987 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF988 to 0xF98F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF990 to 0xF997 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xF998 to 0xF99F */
0x0000, 0x9FA4, 0x7068, 0x7065, 0x7CF7, 0x866A, 0x883E, 0x883D, 	/* 0xF9A0 to 0xF9A7 */
0x883F, 0x8B9E, 0x8C9C, 0x8EA9, 0x8EC9, 0x974B, 0x9873, 0x9874, 	/* 0xF9A8 to 0xF9AF */
0x98CC, 0x9961, 0x99AB, 0x9A64, 0x9A66, 0x9A67, 0x9B24, 0x9E15, 	/* 0xF9B0 to 0xF9B7 */
0x9E17, 0x9F48, 0x6207, 0x6B1E, 0x7227, 0x864C, 0x8EA8, 0x9482, 	/* 0xF9B8 to 0xF9BF */
0x9480, 0x9481, 0x9A69, 0x9A68, 0x9B2E, 0x9E19, 0x7229, 0x864B, 	/* 0xF9C0 to 0xF9C7 */
0x8B9F, 0x9483, 0x9C79, 0x9EB7, 0x7675, 0x9A6B, 0x9C7A, 0x9E1D, 	/* 0xF9C8 to 0xF9CF */
0x7069, 0x706A, 0x9EA4, 0x9F7E, 0x9F49, 0x9F98, 0x7881, 0x92B9, 	/* 0xF9D0 to 0xF9D7 */
0x88CF, 0x58BB, 0x6052, 0x7CA7, 0x5AFA, 0x2554, 0x2566, 0x2557, 	/* 0xF9D8 to 0xF9DF */
0x2560, 0x256C, 0x2563, 0x255A, 0x2569, 0x255D, 0x2552, 0x2564, 	/* 0xF9E0 to 0xF9E7 */
0x2555, 0x255E, 0x256A, 0x2561, 0x2558, 0x2567, 0x255B, 0x2553, 	/* 0xF9E8 to 0xF9EF */
0x2565, 0x2556, 0x255F, 0x256B, 0x2562, 0x2559, 0x2568, 0x255C, 	/* 0xF9F0 to 0xF9F7 */
0x2551, 0x2550, 0x256D, 0x256E, 0x2570, 0x256F, 0x2593, 0x0000, 	/* 0xF9F8 to 0xF9FF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA00 to 0xFA07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA08 to 0xFA0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA10 to 0xFA17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA18 to 0xFA1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA20 to 0xFA27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA28 to 0xFA2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA30 to 0xFA37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA38 to 0xFA3F */
0xE000, 0xE001, 0xE002, 0xE003, 0xE004, 0xE005, 0xE006, 0xE007, 	/* 0xFA40 to 0xFA47 */
0xE008, 0xE009, 0xE00A, 0xE00B, 0xE00C, 0xE00D, 0xE00E, 0xE00F, 	/* 0xFA48 to 0xFA4F */
0xE010, 0xE011, 0xE012, 0xE013, 0xE014, 0xE015, 0xE016, 0xE017, 	/* 0xFA50 to 0xFA57 */
0xE018, 0xE019, 0xE01A, 0xE01B, 0xE01C, 0xE01D, 0xE01E, 0xE01F, 	/* 0xFA58 to 0xFA5F */
0xE020, 0xE021, 0xE022, 0xE023, 0x7232, 0x723C, 0x7266, 0x7282, 	/* 0xFA60 to 0xFA67 */
0x728F, 0x729F, 0x72AD, 0x72B1, 0x72B8, 0x72BE, 0x72CD, 0x72DB, 	/* 0xFA68 to 0xFA6F */
0x7324, 0x732F, 0x7338, 0x7339, 0x73BD, 0x73CE, 0x73F1, 0x7476, 	/* 0xFA70 to 0xFA77 */
0x74A2, 0x7501, 0x7519, 0x7523, 0x753C, 0x7544, 0x7549, 0x0000, 	/* 0xFA78 to 0xFA7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA80 to 0xFA87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA88 to 0xFA8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA90 to 0xFA97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFA98 to 0xFA9F */
0x0000, 0x754D, 0x756D, 0x7582, 0x7583, 0x7589, 0x75AC, 0x75D6, 	/* 0xFAA0 to 0xFAA7 */
0x75E9, 0x7640, 0x764D, 0x7654, 0x7668, 0x7680, 0x7683, 0x7690, 	/* 0xFAA8 to 0xFAAF */
0x76B7, 0x76B9, 0x770D, 0x771E, 0x7743, 0x7818, 0x781C, 0x7839, 	/* 0xFAB0 to 0xFAB7 */
0x783C, 0x7847, 0x7856, 0x787A, 0x78B5, 0x78B9, 0x78C6, 0x78D9, 	/* 0xFAB8 to 0xFABF */
0x7907, 0x7930, 0x7934, 0x793B, 0x7980, 0x799D, 0x79C3, 0x79E1, 	/* 0xFAC0 to 0xFAC7 */
0x7A06, 0x7A0E, 0x7A43, 0x7A50, 0x7AC3, 0x7AD2, 0x7AE2, 0x7AE7, 	/* 0xFAC8 to 0xFACF */
0x7AF8, 0x7B36, 0x7B62, 0x7B6C, 0x7B7A, 0x7B7B, 0x7B9A, 0x7B9E, 	/* 0xFAD0 to 0xFAD7 */
0x7B9F, 0x7BA2, 0x7BA7, 0x7BF6, 0x7C12, 0x7C14, 0x7C4F, 0x7C56, 	/* 0xFAD8 to 0xFADF */
0x7C58, 0x7CAB, 0x7CFA, 0x7D48, 0x7D4B, 0x7D77, 0x7DD4, 0x7DD5, 	/* 0xFAE0 to 0xFAE7 */
0x7DD6, 0x7DE4, 0x7E4D, 0x7E5D, 0x7E7F, 0x7E89, 0x7E8E, 0x7E92, 	/* 0xFAE8 to 0xFAEF */
0x7ED4, 0x7EF1, 0x7F12, 0x7F30, 0x7F71, 0x7F82, 0x7FAE, 0x7FC6, 	/* 0xFAF0 to 0xFAF7 */
0x8020, 0x8022, 0x8025, 0x8031, 0x805F, 0x8068, 0x80AC, 0x0000, 	/* 0xFAF8 to 0xFAFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB00 to 0xFB07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB08 to 0xFB0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB10 to 0xFB17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB18 to 0xFB1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB20 to 0xFB27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB28 to 0xFB2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB30 to 0xFB37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB38 to 0xFB3F */
0x80B7, 0x519A, 0x5416, 0x5414, 0x34DF, 0x4C7D, 0x62C3, 0xE0A4, 	/* 0xFB40 to 0xFB47 */
0xE0A5, 0xE0A6, 0x54CB, 0xE0A8, 0x55BC, 0x80B6, 0x51A7, 0xE0AC, 	/* 0xFB48 to 0xFB4F */
0xE0AD, 0xE0AE, 0x5513, 0x8226, 0xE0B1, 0x551E, 0x55DE, 0x63B9, 	/* 0xFB50 to 0xFB57 */
0x6898, 0xE0B6, 0x5502, 0x5569, 0x75B4, 0x63FC, 0x9E84, 0x922A, 	/* 0xFB58 to 0xFB5F */
0xE0BD, 0xE0BE, 0xE0BF, 0x88C7, 0x609E, 0x5625, 0x7145, 0x5AF2, 	/* 0xFB60 to 0xFB67 */
0xE0C5, 0x528F, 0x564F, 0x7793, 0x8786, 0x8E2D, 0x81B6, 0x35FE, 	/* 0xFB68 to 0xFB6F */
0x71F6, 0xE0CE, 0x8804, 0x9385, 0xE0D1, 0xE0D2, 0x7666, 0xE0D4, 	/* 0xFB70 to 0xFB77 */
0x9C72, 0xE0D6, 0x62CE, 0xE0D8, 0x9E96, 0x4989, 0x7CD3, 0x0000, 	/* 0xFB78 to 0xFB7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB80 to 0xFB87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB88 to 0xFB8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB90 to 0xFB97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFB98 to 0xFB9F */
0x0000, 0x8EDA, 0x9EAB, 0x64E7, 0xE0DF, 0x82AA, 0x6767, 0x6D72, 	/* 0xFBA0 to 0xFBA7 */
0x7906, 0x79C4, 0x7F4E, 0x87EE, 0xE0E7, 0x83BE, 0x862F, 0x89A5, 	/* 0xFBA8 to 0xFBAF */
0x460F, 0xE0EC, 0x98C8, 0x9940, 0x994D, 0x9A0C, 0x9AD7, 0x9E98, 	/* 0xFBB0 to 0xFBB7 */
0x9F26, 0xE0F4, 0x4F03, 0xE0F6, 0x4F39, 0x4F32, 0x4FAB, 0x5056, 	/* 0xFBB8 to 0xFBBF */
0xE0FB, 0x502E, 0x50A6, 0x50D9, 0x510E, 0x50ED, 0x5101, 0x51F4, 	/* 0xFBC0 to 0xFBC7 */
0x521F, 0x5260, 0x5257, 0x529A, 0x52D1, 0x52E0, 0x52E1, 0x51D3, 	/* 0xFBC8 to 0xFBCF */
0x51DF, 0x7546, 0x51FE, 0x5332, 0x532C, 0x5333, 0x53AB, 0x53AA, 	/* 0xFBD0 to 0xFBD7 */
0x9F8E, 0x5469, 0x549C, 0x53DA, 0x6ACA, 0x5573, 0xE119, 0x35D6, 	/* 0xFBD8 to 0xFBDF */
0xE11B, 0x5611, 0x564D, 0xE11E, 0x5654, 0x35F3, 0xE121, 0x5746, 	/* 0xFBE0 to 0xFBE7 */
0x577A, 0x5767, 0x583A, 0x57E6, 0x57DD, 0x5840, 0xE129, 0x5826, 	/* 0xFBE8 to 0xFBEF */
0x58DC, 0x59B7, 0x59D9, 0x5C20, 0xE12F, 0x5CD1, 0x5CE9, 0x5D46, 	/* 0xFBF0 to 0xFBF7 */
0x5D8E, 0xE134, 0x5DF5, 0x5E0B, 0x5E12, 0x5E2E, 0x5E5E, 0x0000, 	/* 0xFBF8 to 0xFBFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC00 to 0xFC07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC08 to 0xFC0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC10 to 0xFC17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC18 to 0xFC1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC20 to 0xFC27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC28 to 0xFC2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC30 to 0xFC37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC38 to 0xFC3F */
0xE13A, 0x5F4D, 0x7A7D, 0x5BC3, 0x7ABB, 0xE13F, 0xE140, 0x5FA4, 	/* 0xFC40 to 0xFC47 */
0x5FBA, 0x5FBC, 0xE144, 0x6077, 0x60A4, 0x60B3, 0x60FD, 0x6130, 	/* 0xFC48 to 0xFC4F */
0xE14A, 0x619C, 0x6159, 0x617D, 0x615C, 0x637F, 0x61E2, 0x70D5, 	/* 0xFC50 to 0xFC57 */
0x6239, 0x6268, 0x6285, 0x6282, 0x62A6, 0x62D5, 0x6364, 0x6335, 	/* 0xFC58 to 0xFC5F */
0x6490, 0x3A5C, 0x6648, 0x6667, 0x671E, 0x6803, 0x67AC, 0x67F9, 	/* 0xFC60 to 0xFC67 */
0x68B6, 0x692C, 0x6901, 0x6900, 0x68CA, 0x6973, 0x6980, 0x693E, 	/* 0xFC68 to 0xFC6F */
0xE16A, 0x69B2, 0x69C0, 0x698A, 0x69FA, 0x69E9, 0x6AB2, 0x6A52, 	/* 0xFC70 to 0xFC77 */
0x6A9D, 0x6B1D, 0x6B52, 0x6BFA, 0x3CD1, 0x6CCE, 0x6E4F, 0x0000, 	/* 0xFC78 to 0xFC7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC80 to 0xFC87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC88 to 0xFC8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC90 to 0xFC97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFC98 to 0xFC9F */
0x0000, 0x6DB9, 0x6F44, 0xE17B, 0x6FDA, 0x7081, 0x79CC, 0x7134, 	/* 0xFCA0 to 0xFCA7 */
0x3DCC, 0x7176, 0xE182, 0xE183, 0x7215, 0x7250, 0x7287, 0x732C, 	/* 0xFCA8 to 0xFCAF */
0x72B2, 0x72E2, 0x7302, 0x7348, 0x7328, 0x734F, 0x7371, 0x6585, 	/* 0xFCB0 to 0xFCB7 */
0xE190, 0x745D, 0x7468, 0x751E, 0x7553, 0x757A, 0x76A1, 0x76CC, 	/* 0xFCB8 to 0xFCBF */
0x7724, 0x772B, 0x4065, 0x7853, 0x78D3, 0x78D8, 0x9D7E, 0x78AF, 	/* 0xFCC0 to 0xFCC7 */
0xE1A0, 0x6142, 0x79A9, 0x9C3A, 0x79D4, 0xE1A5, 0x7A2D, 0x7A3E, 	/* 0xFCC8 to 0xFCCF */
0x7A49, 0x7ADD, 0x7ADA, 0x75C3, 0x7607, 0x7602, 0xE1AE, 0x7667, 	/* 0xFCD0 to 0xFCD7 */
0x766F, 0x5620, 0x8A67, 0x9F17, 0x7B1F, 0x7B92, 0x7BA3, 0x7BCF, 	/* 0xFCD8 to 0xFCDF */
0xE1B8, 0x7BFC, 0x7C42, 0x7C51, 0x7C5D, 0x7C70, 0x7C7E, 0x7C86, 	/* 0xFCE0 to 0xFCE7 */
0x7C83, 0x7CAC, 0x7CC7, 0x7CC2, 0xE1C4, 0x7CDA, 0xE1C6, 0x7D4D, 	/* 0xFCE8 to 0xFCEF */
0x7D5A, 0x7DF5, 0x7E27, 0x7E6E, 0x9E95, 0x5273, 0x801D, 0x8062, 	/* 0xFCF0 to 0xFCF7 */
0x8063, 0x8066, 0x805B, 0x80A6, 0x8103, 0x9E81, 0x81C8, 0x0000, 	/* 0xFCF8 to 0xFCFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD00 to 0xFD07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD08 to 0xFD0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD10 to 0xFD17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD18 to 0xFD1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD20 to 0xFD27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD28 to 0xFD2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD30 to 0xFD37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD38 to 0xFD3F */
0xE1D7, 0x8FA0, 0x81F6, 0x821A, 0xE1DB, 0x8771, 0x87A9, 0x878C, 	/* 0xFD40 to 0xFD47 */
0x9E9E, 0x87C1, 0x9E1C, 0xE1E2, 0x87D6, 0x87F5, 0x880F, 0x8818, 	/* 0xFD48 to 0xFD4F */
0x882D, 0x8842, 0x8845, 0x9C35, 0x886E, 0x88AA, 0x88A0, 0x629D, 	/* 0xFD50 to 0xFD57 */
0x8943, 0x894D, 0x7172, 0x885E, 0xE1F3, 0x82FD, 0x44B7, 0x82D0, 	/* 0xFD58 to 0xFD5F */
0x8385, 0x9D02, 0x9F69, 0x8420, 0xE1FB, 0x84DA, 0x84AD, 0x44FB, 	/* 0xFD60 to 0xFD67 */
0x854B, 0xE200, 0x8602, 0x8610, 0x63D1, 0x8989, 0x898A, 0x8994, 	/* 0xFD68 to 0xFD6F */
0x9C45, 0x89BC, 0x8A7E, 0x8A49, 0x8B0C, 0x8B43, 0x8B81, 0x8B4C, 	/* 0xFD70 to 0xFD77 */
0xE20F, 0x8CAD, 0x8CEB, 0x8CF7, 0x8D0C, 0x8D82, 0x8DA6, 0x0000, 	/* 0xFD78 to 0xFD7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD80 to 0xFD87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD88 to 0xFD8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD90 to 0xFD97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFD98 to 0xFD9F */
0x0000, 0x8DD4, 0x8E28, 0x8E4F, 0x8E77, 0x8E75, 0x8EA7, 0x8F19, 	/* 0xFDA0 to 0xFDA7 */
0xE21D, 0x8F5C, 0x9D44, 0x90C4, 0x9151, 0xE222, 0x915C, 0x9159, 	/* 0xFDA8 to 0xFDAF */
0x9167, 0x917C, 0x918E, 0x91BB, 0x9EA8, 0x9056, 0x904C, 0x91FE, 	/* 0xFDB0 to 0xFDB7 */
0x9262, 0x92BE, 0x936B, 0x936E, 0x93BA, 0x9427, 0x9597, 0x95A7, 	/* 0xFDB8 to 0xFDBF */
0xE235, 0x9638, 0xE237, 0x9683, 0x9696, 0x9681, 0x96BD, 0x9703, 	/* 0xFDC0 to 0xFDC7 */
0x9721, 0x9731, 0x975F, 0x979F, 0x97B4, 0x97B8, 0x97BA, 0x97BE, 	/* 0xFDC8 to 0xFDCF */
0x97C8, 0x9EBF, 0x981F, 0x982E, 0x9FA5, 0x9847, 0x984B, 0x9866, 	/* 0xFDD0 to 0xFDD7 */
0x986C, 0x98B4, 0x9F5A, 0x98DC, 0x98E6, 0x9942, 0x9939, 0x993B, 	/* 0xFDD8 to 0xFDDF */
0x9F53, 0x994A, 0x9F45, 0x4B7E, 0x99DA, 0x7AC8, 0x9ABA, 0x9ABD, 	/* 0xFDE0 to 0xFDE7 */
0x9F02, 0x9B2A, 0xE25F, 0x9B2D, 0x9AE2, 0x9B02, 0x9AFF, 0x4C07, 	/* 0xFDE8 to 0xFDEF */
0x9B09, 0x4C04, 0x4C3B, 0x9B8F, 0x9B9D, 0x9BB0, 0x9C0C, 0x9C15, 	/* 0xFDF0 to 0xFDF7 */
0x9C0A, 0x9BFF, 0x9C2E, 0x80E8, 0x80E9, 0x80EC, 0x810E, 0x0000, 	/* 0xFDF8 to 0xFDFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE00 to 0xFE07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE08 to 0xFE0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE10 to 0xFE17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE18 to 0xFE1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE20 to 0xFE27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE28 to 0xFE2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE30 to 0xFE37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE38 to 0xFE3F */
0x6C39, 0x4E6A, 0x9641, 0x58F2, 0x7962, 0x6822, 0xE27A, 0xE27B, 	/* 0xFE40 to 0xFE47 */
0x8107, 0x57D7, 0x44EA, 0x6435, 0x8534, 0x40DF, 0xE282, 0x691A, 	/* 0xFE48 to 0xFE4F */
0x9C02, 0x75B1, 0x83D3, 0x7171, 0x6A0B, 0xE289, 0x6A7A, 0x9AF4, 	/* 0xFE50 to 0xFE57 */
0xE28C, 0xE28D, 0x77B9, 0x6530, 0x6D96, 0x5637, 0x6725, 0x6A2B, 	/* 0xFE58 to 0xFE5F */
0x7D5D, 0x9061, 0x4E98, 0x7CA6, 0x7B39, 0xE299, 0x5975, 0x36C7, 	/* 0xFE60 to 0xFE67 */
0x707F, 0xE29D, 0x6E8B, 0xE29F, 0xE2A0, 0x975D, 0x92D0, 0x5754, 	/* 0xFE68 to 0xFE6F */
0xE2A4, 0x3ED9, 0xE2A6, 0xE2A7, 0x6199, 0x7460, 0x713F, 0x792E, 	/* 0xFE70 to 0xFE77 */
0x5A96, 0x9348, 0x668E, 0x4FFD, 0x9341, 0x3654, 0x5D75, 0x0000, 	/* 0xFE78 to 0xFE7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE80 to 0xFE87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE88 to 0xFE8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE90 to 0xFE97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFE98 to 0xFE9F */
0x0000, 0x701E, 0x657B, 0x708D, 0x5ECD, 0xE2B7, 0x60A7, 0x7AB0, 	/* 0xFEA0 to 0xFEA7 */
0x5F63, 0xE2BB, 0x73F7, 0xE2BD, 0x7468, 0x75B4, 0xE2C0, 0x9B69, 	/* 0xFEA8 to 0xFEAF */
0x00BD, 0x2153, 0x2154, 0x00BC, 0x00BE, 0x2155, 0x2156, 0x2157, 	/* 0xFEB0 to 0xFEB7 */
0x2158, 0x2159, 0x215A, 0x8692, 0x86A0, 0x86AD, 0x86B2, 0x87A5, 	/* 0xFEB8 to 0xFEBF */
0x87B1, 0x215B, 0x215C, 0x215D, 0x215E, 0x87DA, 0x884F, 0x8860, 	/* 0xFEC0 to 0xFEC7 */
0x8887, 0x888F, 0x8890, 0x88E6, 0x88FF, 0x8900, 0x8924, 0x8947, 	/* 0xFEC8 to 0xFECF */
0x8954, 0x8965, 0x8980, 0x8991, 0x8A1C, 0x8A29, 0x8A2B, 0x8A38, 	/* 0xFED0 to 0xFED7 */
0x8A3D, 0x2312, 0x8A90, 0x8A94, 0x8A9C, 0x8AA9, 0x8AAF, 0x8AB4, 	/* 0xFED8 to 0xFEDF */
0x8AEA, 0x8B1F, 0x2030, 0x8B3F, 0x8B4D, 0x8B5E, 0x8B62, 0x8B69, 	/* 0xFEE0 to 0xFEE7 */
0x8B9B, 0x8C51, 0x8C9B, 0x8C9F, 0x8CD4, 0x8CD6, 0x8112, 0x8131, 	/* 0xFEE8 to 0xFEEF */
0x8136, 0x815F, 0x816D, 0x817D, 0x8193, 0x81AA, 0x81B8, 0x81C1, 	/* 0xFEF0 to 0xFEF7 */
0x8229, 0x822D, 0x822E, 0x823E, 0x8262, 0x826A, 0x8288, 0x0000, 	/* 0xFEF8 to 0xFEFF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF00 to 0xFF07 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF08 to 0xFF0F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF10 to 0xFF17 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF18 to 0xFF1F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF20 to 0xFF27 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF28 to 0xFF2F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF30 to 0xFF37 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF38 to 0xFF3F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF40 to 0xFF47 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF48 to 0xFF4F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF50 to 0xFF57 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF58 to 0xFF5F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF60 to 0xFF67 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF68 to 0xFF6F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF70 to 0xFF77 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF78 to 0xFF7F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF80 to 0xFF87 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF88 to 0xFF8F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF90 to 0xFF97 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFF98 to 0xFF9F */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFA0 to 0xFFA7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFA8 to 0xFFAF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFB0 to 0xFFB7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFB8 to 0xFFBF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFC0 to 0xFFC7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFC8 to 0xFFCF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFD0 to 0xFFD7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFD8 to 0xFFDF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFE0 to 0xFFE7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFE8 to 0xFFEF */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFF0 to 0xFFF7 */
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 	/* 0xFFF8 to 0xFFFF */
};

static unsigned short U2B[65536];
static unsigned short U2G[65536];

void init_encoding_table() {
    unsigned short i;
    for (i = 0; i < 32768; i++) 
        U2B[B2U[i]] = i + 0x8000;
    for (i = 0; i < 32768; i++) 
        U2G[G2U[i]] = i + 0x8000;
    // Hard code some fix
    U2G[0x2574] = 0xA3DF;
    /* BIG5: 0xC8B8, UCS2: 0x30FB,
     * not in GBK, use 0XA1A4(0x00B7 in UCS2) instead */
    U2G[0x30FB] = 0xA1A4;
}


/* 0 = UTF-8, 1 = GBK, 2 = BIG5 */
static int parser_codeset(const char * code)
{
    if (strcasestr(code, "UTF-8") ||
            strcasestr(code, "UTF8"))
        return 0;
    if (strcasestr(code, "GBK") ||
            strcasestr(code, "GB2312") ||
            strcasestr(code, "GB18030"))
        return 1;
    if (strcasestr(code, "BIG5"))
        return 2;
    return 0;
}

static wchar_t * convert_from_gbk_to_ucs2(const gchar * str,
        gssize len, gsize* writelen)
{
    wchar_t * wt = (wchar_t *)g_malloc((len + 1) * sizeof(wchar_t));
    const unsigned char * ustr = (const unsigned char *)str;
    gsize i = 0;
    gsize j = 0;
    for ( ; i < len; i++) {
        if (ustr[i] < 0x80) {
            /* ASCII character */
            wt[j++] = ustr[i];
        } else if (i + 1 < len) {
            /* Chinese character */
            unsigned short code = (ustr[i] << 8) + ustr[i + 1] - 0x8000;
            if (G2U[code] != 0)
                wt[j++] = G2U[code];
            else {
                wt[j++] = 0x20;
                wt[j++] = 0x20;
            }
            i++;
        } else {
            /* seems failed */
            wt[j++] = ustr[i];
        }
    }
    wt[j] = 0;
    *writelen = j;
    return wt;
}

static wchar_t * convert_from_big5_to_ucs2(const gchar * str,
        gssize len, gsize* writelen)
{
    wchar_t * wt = (wchar_t *)g_malloc((len + 1) * sizeof(wchar_t));
    const unsigned char * ustr = (const unsigned char *)str;
    gsize i = 0;
    gsize j = 0;
    for ( ; i < len; i++) {
        if (ustr[i] < 0x80) {
            /* ASCII character */
            wt[j++] = ustr[i];
        } else if (i + 1 < len) {
            /* Chinese character */
            unsigned short code = (ustr[i] << 8) + ustr[i + 1] - 0x8000;
            if (B2U[code] != 0)
                wt[j++] = B2U[code];
            else {
                wt[j++] = 0x20;
                wt[j++] = 0x20;
            }
            i++;
        } else {
            /* seems failed */
            wt[j++] = ustr[i];
        }
    }
    wt[j] = 0;
    *writelen = j;
    return wt;
}

static gchar * convert_from_ucs2_to_gbk(const wchar_t * str,
        gssize len, gsize * writelen)
{
    std::string text;
    int i;
    for (i = 0; i < len; i++) {
        if ((unsigned)str[i] <= 0x007f)
            text.push_back((char)str[i]);
        else {
            unsigned short ch = U2G[(unsigned)str[i]];
            if (ch != 0) {
                text.push_back((char)(ch >> 8));
                text.push_back((char)(ch & 0xff));
            } else {
                text.append("  ");
            }
        }
    }
    gchar * ret = (gchar *)g_malloc((text.size() + 1) * sizeof(gchar));
    strcpy(ret, text.c_str());
    *writelen = text.size();
    return ret;
}

static gchar * convert_from_ucs2_to_big5(const wchar_t * str,
        gssize len, gsize * writelen)
{
    std::string text;
    int i;
    for (i = 0; i < len; i++) {
        if ((unsigned)str[i] <= 0x007f)
            text.push_back((char)str[i]);
        else {
            unsigned short ch = U2B[(unsigned)str[i]];
            if (ch != 0) {
                text.push_back((char)(ch >> 8));
                text.push_back((char)(ch & 0xff));
            } else {
                text.append("  ");
            }
        }
    }
    gchar * ret = (gchar *)g_malloc((text.size() + 1) * sizeof(gchar));
    strcpy(ret, text.c_str());
    *writelen = text.size();
    return ret;
}

gchar * my_convert(const gchar *str, gssize len,const gchar *to_codeset,
        const gchar *from_codeset, gsize * writelen)
{
    int fromcode = parser_codeset(from_codeset);
    int tocode = parser_codeset(to_codeset);

    if (len == -1)
        len = strlen(str);

    wchar_t * mid = NULL;
    gsize midlen = 0;
    switch (fromcode) {
        case 1:
            mid = convert_from_gbk_to_ucs2(str, len, &midlen);
            break;
        case 2:
            mid = convert_from_big5_to_ucs2(str, len, &midlen);
            break;
        default:
            glong convl = 0;
            gunichar2 * _mid = g_utf8_to_utf16(str, len, NULL,
                    &convl, NULL);
            midlen = convl; 
            mid = (wchar_t *)g_malloc((midlen + 1) * sizeof(wchar_t));
            int i;
            for (i = 0; i < midlen; i++)
                mid[i] = _mid[i];
            mid[midlen] = 0;
            g_free((gpointer)_mid);
            INFO("mid: %x", mid[0]);
            break;
    }
    gchar * desttext;
    gsize wlen = 0;
    int i;
    switch (tocode) {
        case 1:
            desttext = convert_from_ucs2_to_gbk(mid, midlen, &wlen);
            break;
        case 2:
            desttext = convert_from_ucs2_to_big5(mid, midlen, &wlen);
            break;
        default:
            gunichar2 * _mid = (gunichar2 *)g_malloc((midlen + 1) * 
                    sizeof(gunichar2));
            int i;
            for (i = 0; i < midlen; i++)
                _mid[i] = mid[i];
            _mid[midlen] = 0;
            glong convl;
            desttext = g_utf16_to_utf8(_mid, midlen, NULL, &convl,
                    NULL);
            wlen = convl;
            g_free((gpointer)_mid);
            break;

    }
    if (writelen != NULL)
        *writelen = wlen;
    g_free((gpointer)mid);
    return desttext;
}
