#  model.rb -
#  model is a Model module
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


require 'yaml'
require 'singleton'
require 'geekast/models/lib/connection'
require 'geekast/models/lib/preferences'
require 'geekast/models/lib/bookmark'
require 'geekast/models/lib/im'

# module config
require 'geekast/config/config'

# Sig
require 'geekast/lib/signal'


module Geekast
  module Model

    def self.main
      Model.instance
    end

    class Model
      include Singleton

      def initialize
        puts "Model singleton launched" if $DEBUG

        @sig = Sig.instance
        @connection = PeercastConnection.new
        @bookmark = Bookmark.new
        @im = IM.new


        @sig.connect("MrefreshNB", ['Hash']) {|hash|
          puts hash[:signal] if $DEBUG
          if hash[:numpage] == Config::BOOKMARK
            refreshMB(hash[:signal])
          elsif hash[:signal] != ""
            refreshNB(hash)
          end
        }

        @sig.connect("MbookmarkAdd", ['Array']) {|data|
          puts "MbookmarkAdd" if $DEBUG
          @bookmark.add(data)
        }

        @sig.connect("MbookmarkDel", ['Integer']) {|data|
          puts "MbookmarkDel" if $DEBUG
          @bookmark.del
        }


        @sig.connect("MjabberConnect", ['Integer', 'String']) {|channel, data|
          puts "MjabberConnect" if $DEBUG
          @im.connect(channel, data)
        }



      end


      #######
      private
      #######

      def refreshNB(hash)

        msg = @connection.connect(hash)
        @connection.parse_xml(hash) if msg == "true"

        @sig.emit("ChandlerError", "httpConnect", msg)
      end

      def refreshMB(signal)
        @bookmark.load(signal)
      end


    end

  end
end
