/*
 *  Main authors:
 *     Guido Tack <tack@gecode.org>
 *     Christian Schulte <schulte@gecode.org>
 *
 *  Contributing authors:
 *     Gabor Szokoli <szokoli@gecode.org>
 *
 *  Copyright:
 *     Guido Tack, 2004
 *     Christian Schulte, 2004
 *     Gabor Szokoli, 2004
 *
 *  Last modified:
 *     $Date: 2005-11-24 18:03:01 +0100 (Thu, 24 Nov 2005) $ by $Author: tack $
 *     $Revision: 2639 $
 *
 *  This file is part of Gecode, the generic constraint
 *  development environment:
 *     http://www.gecode.org
 *
 *  See the file "LICENSE" for information on usage and
 *  redistribution of this file, and for a
 *     DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "set.hh"
#include "set/sequence.hh"

namespace Gecode { namespace Set { namespace Sequence {

  /*
   * "Sequence" propagator
   *
   */

  Actor*
  Seq::copy(Space* home, bool share) {
    return new (home) Seq(home,share,*this);
  }

  ExecStatus
  Seq::propagate(Space* home) {
    bool modified = false;
    GECODE_ES_CHECK(propagateSeq(home, modified, x));
    bool assigned = true;
    for (int i=x.size(); i--;) {
      if (!x[i].assigned()) {
	assigned = false; break;
      }
    }
    return assigned ? ES_SUBSUMED : ES_FIX;
  }

}}}

// STATISTICS: set-prop
