
# This tests some corner cases for coverage, mostly
#  dealing with large additional record counts and/or
#  dnames being encoded/repeated past the 16K mark,
#  which affects compression.
# Also covers a few EDNS cases at the bottom

use _GDT ();
use FindBin ();
use File::Spec ();
use Test::More tests => 12;

$optrr = Net::DNS::RR->new(
    type => "OPT",
    ednsversion => 0,
    name => "",
    class => 1024,
    extendedrcode => 0,
    ednsflags => 0,
);

my $long_rr = Net::DNS::rr_add('this.is.an.rr.thats.longer.than.an.opt.rr.in.order.to.make.coverage.work A 192.0.2.1');
my $long_root_rr = Net::DNS::rr_add('. MX 0 this.is.an.rr.thats.longer.than.an.opt.rr.in.order.to.make.coverage.work');

my $sixteen_txt = qq{ "0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDE" "F0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCD" "EF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABC" "DEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789AB" "CDEF"} x 16;

my $addtl_256 = [
    '00.example.com 86400 A 192.0.2.0',
    '01.example.com 86400 A 192.0.2.1',
    '02.example.com 86400 A 192.0.2.2',
    '03.example.com 86400 A 192.0.2.3',
    '04.example.com 86400 A 192.0.2.4',
    '05.example.com 86400 A 192.0.2.5',
    '06.example.com 86400 A 192.0.2.6',
    '07.example.com 86400 A 192.0.2.7',
    '08.example.com 86400 A 192.0.2.8',
    '09.example.com 86400 A 192.0.2.9',
    '0a.example.com 86400 A 192.0.2.10',
    '0b.example.com 86400 A 192.0.2.11',
    '0c.example.com 86400 A 192.0.2.12',
    '0d.example.com 86400 A 192.0.2.13',
    '0e.example.com 86400 A 192.0.2.14',
    '0f.example.com 86400 A 192.0.2.15',
    '10.example.com 86400 A 192.0.2.16',
    '11.example.com 86400 A 192.0.2.17',
    '12.example.com 86400 A 192.0.2.18',
    '13.example.com 86400 A 192.0.2.19',
    '14.example.com 86400 A 192.0.2.20',
    '15.example.com 86400 A 192.0.2.21',
    '16.example.com 86400 A 192.0.2.22',
    '17.example.com 86400 A 192.0.2.23',
    '18.example.com 86400 A 192.0.2.24',
    '19.example.com 86400 A 192.0.2.25',
    '1a.example.com 86400 A 192.0.2.26',
    '1b.example.com 86400 A 192.0.2.27',
    '1c.example.com 86400 A 192.0.2.28',
    '1d.example.com 86400 A 192.0.2.29',
    '1e.example.com 86400 A 192.0.2.30',
    '1f.example.com 86400 A 192.0.2.31',
    '20.example.com 86400 A 192.0.2.32',
    '21.example.com 86400 A 192.0.2.33',
    '22.example.com 86400 A 192.0.2.34',
    '23.example.com 86400 A 192.0.2.35',
    '24.example.com 86400 A 192.0.2.36',
    '25.example.com 86400 A 192.0.2.37',
    '26.example.com 86400 A 192.0.2.38',
    '27.example.com 86400 A 192.0.2.39',
    '28.example.com 86400 A 192.0.2.40',
    '29.example.com 86400 A 192.0.2.41',
    '2a.example.com 86400 A 192.0.2.42',
    '2b.example.com 86400 A 192.0.2.43',
    '2c.example.com 86400 A 192.0.2.44',
    '2d.example.com 86400 A 192.0.2.45',
    '2e.example.com 86400 A 192.0.2.46',
    '2f.example.com 86400 A 192.0.2.47',
    '30.example.com 86400 A 192.0.2.48',
    '31.example.com 86400 A 192.0.2.49',
    '32.example.com 86400 A 192.0.2.50',
    '33.example.com 86400 A 192.0.2.51',
    '34.example.com 86400 A 192.0.2.52',
    '35.example.com 86400 A 192.0.2.53',
    '36.example.com 86400 A 192.0.2.54',
    '37.example.com 86400 A 192.0.2.55',
    '38.example.com 86400 A 192.0.2.56',
    '39.example.com 86400 A 192.0.2.57',
    '3a.example.com 86400 A 192.0.2.58',
    '3b.example.com 86400 A 192.0.2.59',
    '3c.example.com 86400 A 192.0.2.60',
    '3d.example.com 86400 A 192.0.2.61',
    '3e.example.com 86400 A 192.0.2.62',
    '3f.example.com 86400 A 192.0.2.63',
    '40.example.com 86400 A 192.0.2.64',
    '41.example.com 86400 A 192.0.2.65',
    '42.example.com 86400 A 192.0.2.66',
    '43.example.com 86400 A 192.0.2.67',
    '44.example.com 86400 A 192.0.2.68',
    '45.example.com 86400 A 192.0.2.69',
    '46.example.com 86400 A 192.0.2.70',
    '47.example.com 86400 A 192.0.2.71',
    '48.example.com 86400 A 192.0.2.72',
    '49.example.com 86400 A 192.0.2.73',
    '4a.example.com 86400 A 192.0.2.74',
    '4b.example.com 86400 A 192.0.2.75',
    '4c.example.com 86400 A 192.0.2.76',
    '4d.example.com 86400 A 192.0.2.77',
    '4e.example.com 86400 A 192.0.2.78',
    '4f.example.com 86400 A 192.0.2.79',
    '50.example.com 86400 A 192.0.2.80',
    '51.example.com 86400 A 192.0.2.81',
    '52.example.com 86400 A 192.0.2.82',
    '53.example.com 86400 A 192.0.2.83',
    '54.example.com 86400 A 192.0.2.84',
    '55.example.com 86400 A 192.0.2.85',
    '56.example.com 86400 A 192.0.2.86',
    '57.example.com 86400 A 192.0.2.87',
    '58.example.com 86400 A 192.0.2.88',
    '59.example.com 86400 A 192.0.2.89',
    '5a.example.com 86400 A 192.0.2.90',
    '5b.example.com 86400 A 192.0.2.91',
    '5c.example.com 86400 A 192.0.2.92',
    '5d.example.com 86400 A 192.0.2.93',
    '5e.example.com 86400 A 192.0.2.94',
    '5f.example.com 86400 A 192.0.2.95',
    '60.example.com 86400 A 192.0.2.96',
    '61.example.com 86400 A 192.0.2.97',
    '62.example.com 86400 A 192.0.2.98',
    '63.example.com 86400 A 192.0.2.99',
    '64.example.com 86400 A 192.0.2.100',
    '65.example.com 86400 A 192.0.2.101',
    '66.example.com 86400 A 192.0.2.102',
    '67.example.com 86400 A 192.0.2.103',
    '68.example.com 86400 A 192.0.2.104',
    '69.example.com 86400 A 192.0.2.105',
    '6a.example.com 86400 A 192.0.2.106',
    '6b.example.com 86400 A 192.0.2.107',
    '6c.example.com 86400 A 192.0.2.108',
    '6d.example.com 86400 A 192.0.2.109',
    '6e.example.com 86400 A 192.0.2.110',
    '6f.example.com 86400 A 192.0.2.111',
    '70.example.com 86400 A 192.0.2.112',
    '71.example.com 86400 A 192.0.2.113',
    '72.example.com 86400 A 192.0.2.114',
    '73.example.com 86400 A 192.0.2.115',
    '74.example.com 86400 A 192.0.2.116',
    '75.example.com 86400 A 192.0.2.117',
    '76.example.com 86400 A 192.0.2.118',
    '77.example.com 86400 A 192.0.2.119',
    '78.example.com 86400 A 192.0.2.120',
    '79.example.com 86400 A 192.0.2.121',
    '7a.example.com 86400 A 192.0.2.122',
    '7b.example.com 86400 A 192.0.2.123',
    '7c.example.com 86400 A 192.0.2.124',
    '7d.example.com 86400 A 192.0.2.125',
    '7e.example.com 86400 A 192.0.2.126',
    '7f.example.com 86400 A 192.0.2.127',
    '80.example.com 86400 A 192.0.2.128',
    '81.example.com 86400 A 192.0.2.129',
    '82.example.com 86400 A 192.0.2.130',
    '83.example.com 86400 A 192.0.2.131',
    '84.example.com 86400 A 192.0.2.132',
    '85.example.com 86400 A 192.0.2.133',
    '86.example.com 86400 A 192.0.2.134',
    '87.example.com 86400 A 192.0.2.135',
    '88.example.com 86400 A 192.0.2.136',
    '89.example.com 86400 A 192.0.2.137',
    '8a.example.com 86400 A 192.0.2.138',
    '8b.example.com 86400 A 192.0.2.139',
    '8c.example.com 86400 A 192.0.2.140',
    '8d.example.com 86400 A 192.0.2.141',
    '8e.example.com 86400 A 192.0.2.142',
    '8f.example.com 86400 A 192.0.2.143',
    '90.example.com 86400 A 192.0.2.144',
    '91.example.com 86400 A 192.0.2.145',
    '92.example.com 86400 A 192.0.2.146',
    '93.example.com 86400 A 192.0.2.147',
    '94.example.com 86400 A 192.0.2.148',
    '95.example.com 86400 A 192.0.2.149',
    '96.example.com 86400 A 192.0.2.150',
    '97.example.com 86400 A 192.0.2.151',
    '98.example.com 86400 A 192.0.2.152',
    '99.example.com 86400 A 192.0.2.153',
    '9a.example.com 86400 A 192.0.2.154',
    '9b.example.com 86400 A 192.0.2.155',
    '9c.example.com 86400 A 192.0.2.156',
    '9d.example.com 86400 A 192.0.2.157',
    '9e.example.com 86400 A 192.0.2.158',
    '9f.example.com 86400 A 192.0.2.159',
    'a0.example.com 86400 A 192.0.2.160',
    'a1.example.com 86400 A 192.0.2.161',
    'a2.example.com 86400 A 192.0.2.162',
    'a3.example.com 86400 A 192.0.2.163',
    'a4.example.com 86400 A 192.0.2.164',
    'a5.example.com 86400 A 192.0.2.165',
    'a6.example.com 86400 A 192.0.2.166',
    'a7.example.com 86400 A 192.0.2.167',
    'a8.example.com 86400 A 192.0.2.168',
    'a9.example.com 86400 A 192.0.2.169',
    'aa.example.com 86400 A 192.0.2.170',
    'ab.example.com 86400 A 192.0.2.171',
    'ac.example.com 86400 A 192.0.2.172',
    'ad.example.com 86400 A 192.0.2.173',
    'ae.example.com 86400 A 192.0.2.174',
    'af.example.com 86400 A 192.0.2.175',
    'b0.example.com 86400 A 192.0.2.176',
    'b1.example.com 86400 A 192.0.2.177',
    'b2.example.com 86400 A 192.0.2.178',
    'b3.example.com 86400 A 192.0.2.179',
    'b4.example.com 86400 A 192.0.2.180',
    'b5.example.com 86400 A 192.0.2.181',
    'b6.example.com 86400 A 192.0.2.182',
    'b7.example.com 86400 A 192.0.2.183',
    'b8.example.com 86400 A 192.0.2.184',
    'b9.example.com 86400 A 192.0.2.185',
    'ba.example.com 86400 A 192.0.2.186',
    'bb.example.com 86400 A 192.0.2.187',
    'bc.example.com 86400 A 192.0.2.188',
    'bd.example.com 86400 A 192.0.2.189',
    'be.example.com 86400 A 192.0.2.190',
    'bf.example.com 86400 A 192.0.2.191',
    'c0.example.com 86400 A 192.0.2.192',
    'c1.example.com 86400 A 192.0.2.193',
    'c2.example.com 86400 A 192.0.2.194',
    'c3.example.com 86400 A 192.0.2.195',
    'c4.example.com 86400 A 192.0.2.196',
    'c5.example.com 86400 A 192.0.2.197',
    'c6.example.com 86400 A 192.0.2.198',
    'c7.example.com 86400 A 192.0.2.199',
    'c8.example.com 86400 A 192.0.2.200',
    'c9.example.com 86400 A 192.0.2.201',
    'ca.example.com 86400 A 192.0.2.202',
    'cb.example.com 86400 A 192.0.2.203',
    'cc.example.com 86400 A 192.0.2.204',
    'cd.example.com 86400 A 192.0.2.205',
    'ce.example.com 86400 A 192.0.2.206',
    'cf.example.com 86400 A 192.0.2.207',
    'd0.example.com 86400 A 192.0.2.208',
    'd1.example.com 86400 A 192.0.2.209',
    'd2.example.com 86400 A 192.0.2.210',
    'd3.example.com 86400 A 192.0.2.211',
    'd4.example.com 86400 A 192.0.2.212',
    'd5.example.com 86400 A 192.0.2.213',
    'd6.example.com 86400 A 192.0.2.214',
    'd7.example.com 86400 A 192.0.2.215',
    'd8.example.com 86400 A 192.0.2.216',
    'd9.example.com 86400 A 192.0.2.217',
    'da.example.com 86400 A 192.0.2.218',
    'db.example.com 86400 A 192.0.2.219',
    'dc.example.com 86400 A 192.0.2.220',
    'dd.example.com 86400 A 192.0.2.221',
    'de.example.com 86400 A 192.0.2.222',
    'df.example.com 86400 A 192.0.2.223',
    'e0.example.com 86400 A 192.0.2.224',
    'e1.example.com 86400 A 192.0.2.225',
    'e2.example.com 86400 A 192.0.2.226',
    'e3.example.com 86400 A 192.0.2.227',
    'e4.example.com 86400 A 192.0.2.228',
    'e5.example.com 86400 A 192.0.2.229',
    'e6.example.com 86400 A 192.0.2.230',
    'e7.example.com 86400 A 192.0.2.231',
    'e8.example.com 86400 A 192.0.2.232',
    'e9.example.com 86400 A 192.0.2.233',
    'ea.example.com 86400 A 192.0.2.234',
    'eb.example.com 86400 A 192.0.2.235',
    'ec.example.com 86400 A 192.0.2.236',
    'ed.example.com 86400 A 192.0.2.237',
    'ee.example.com 86400 A 192.0.2.238',
    'ef.example.com 86400 A 192.0.2.239',
    'f0.example.com 86400 A 192.0.2.240',
    'f1.example.com 86400 A 192.0.2.241',
    'f2.example.com 86400 A 192.0.2.242',
    'f3.example.com 86400 A 192.0.2.243',
    'f4.example.com 86400 A 192.0.2.244',
    'f5.example.com 86400 A 192.0.2.245',
    'f6.example.com 86400 A 192.0.2.246',
    'f7.example.com 86400 A 192.0.2.247',
    'f8.example.com 86400 A 192.0.2.248',
    'f9.example.com 86400 A 192.0.2.249',
    'fa.example.com 86400 A 192.0.2.250',
    'fb.example.com 86400 A 192.0.2.251',
    'fc.example.com 86400 A 192.0.2.252',
    'fd.example.com 86400 A 192.0.2.253',
    'fe.example.com 86400 A 192.0.2.254',
    'ff.example.com 86400 A 192.0.2.255',
];

my $srv_258 = [
    'sixteen.example.com 86400 SRV 0 0 0 00.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 01.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 02.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 03.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 04.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 05.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 06.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 07.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 08.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 09.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 0a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 0b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 0c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 0d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 0e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 0f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 10.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 11.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 12.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 13.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 14.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 15.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 16.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 17.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 18.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 19.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 1a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 1b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 1c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 1d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 1e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 1f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 20.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 21.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 22.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 23.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 24.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 25.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 26.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 27.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 28.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 29.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 2a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 2b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 2c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 2d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 2e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 2f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 30.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 31.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 32.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 33.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 34.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 35.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 36.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 37.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 38.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 39.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 3a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 3b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 3c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 3d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 3e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 3f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 40.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 41.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 42.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 43.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 44.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 45.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 46.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 47.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 48.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 49.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 4a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 4b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 4c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 4d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 4e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 4f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 50.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 51.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 52.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 53.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 54.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 55.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 56.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 57.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 58.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 59.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 5a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 5b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 5c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 5d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 5e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 5f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 60.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 61.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 62.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 63.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 64.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 65.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 66.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 67.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 68.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 69.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 6a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 6b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 6c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 6d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 6e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 6f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 70.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 71.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 72.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 73.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 74.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 75.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 76.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 77.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 78.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 79.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 7a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 7b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 7c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 7d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 7e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 7f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 80.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 81.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 82.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 83.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 84.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 85.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 86.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 87.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 88.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 89.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 8a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 8b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 8c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 8d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 8e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 8f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 90.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 91.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 92.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 93.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 94.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 95.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 96.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 97.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 98.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 99.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 9a.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 9b.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 9c.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 9d.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 9e.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 9f.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a0.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a1.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a2.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a3.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a4.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a5.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a6.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a7.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a8.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 a9.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 aa.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ab.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ac.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ad.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ae.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 af.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b0.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b1.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b2.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b3.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b4.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b5.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b6.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b7.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b8.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 b9.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ba.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 bb.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 bc.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 bd.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 be.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 bf.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c0.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c1.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c2.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c3.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c4.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c5.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c6.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c7.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c8.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 c9.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ca.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 cb.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 cc.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 cd.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ce.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 cf.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d0.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d1.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d2.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d3.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d4.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d5.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d6.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d7.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d8.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 d9.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 da.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 db.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 dc.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 dd.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 de.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 df.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e0.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e1.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e2.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e3.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e4.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e5.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e6.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e7.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e8.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 e9.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ea.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 eb.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ec.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ed.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ee.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ef.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f0.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f1.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f2.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f3.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f4.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f5.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f6.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f7.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f8.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 f9.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 fa.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 fb.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 fc.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 fd.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 fe.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 ff.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 257.example.com',
    'sixteen.example.com 86400 SRV 0 0 0 258.example.com',
];

my $mx_258 = [
    'sixteen.example.com 86400 MX 0 00.example.com',
    'sixteen.example.com 86400 MX 0 01.example.com',
    'sixteen.example.com 86400 MX 0 02.example.com',
    'sixteen.example.com 86400 MX 0 03.example.com',
    'sixteen.example.com 86400 MX 0 04.example.com',
    'sixteen.example.com 86400 MX 0 05.example.com',
    'sixteen.example.com 86400 MX 0 06.example.com',
    'sixteen.example.com 86400 MX 0 07.example.com',
    'sixteen.example.com 86400 MX 0 08.example.com',
    'sixteen.example.com 86400 MX 0 09.example.com',
    'sixteen.example.com 86400 MX 0 0a.example.com',
    'sixteen.example.com 86400 MX 0 0b.example.com',
    'sixteen.example.com 86400 MX 0 0c.example.com',
    'sixteen.example.com 86400 MX 0 0d.example.com',
    'sixteen.example.com 86400 MX 0 0e.example.com',
    'sixteen.example.com 86400 MX 0 0f.example.com',
    'sixteen.example.com 86400 MX 0 10.example.com',
    'sixteen.example.com 86400 MX 0 11.example.com',
    'sixteen.example.com 86400 MX 0 12.example.com',
    'sixteen.example.com 86400 MX 0 13.example.com',
    'sixteen.example.com 86400 MX 0 14.example.com',
    'sixteen.example.com 86400 MX 0 15.example.com',
    'sixteen.example.com 86400 MX 0 16.example.com',
    'sixteen.example.com 86400 MX 0 17.example.com',
    'sixteen.example.com 86400 MX 0 18.example.com',
    'sixteen.example.com 86400 MX 0 19.example.com',
    'sixteen.example.com 86400 MX 0 1a.example.com',
    'sixteen.example.com 86400 MX 0 1b.example.com',
    'sixteen.example.com 86400 MX 0 1c.example.com',
    'sixteen.example.com 86400 MX 0 1d.example.com',
    'sixteen.example.com 86400 MX 0 1e.example.com',
    'sixteen.example.com 86400 MX 0 1f.example.com',
    'sixteen.example.com 86400 MX 0 20.example.com',
    'sixteen.example.com 86400 MX 0 21.example.com',
    'sixteen.example.com 86400 MX 0 22.example.com',
    'sixteen.example.com 86400 MX 0 23.example.com',
    'sixteen.example.com 86400 MX 0 24.example.com',
    'sixteen.example.com 86400 MX 0 25.example.com',
    'sixteen.example.com 86400 MX 0 26.example.com',
    'sixteen.example.com 86400 MX 0 27.example.com',
    'sixteen.example.com 86400 MX 0 28.example.com',
    'sixteen.example.com 86400 MX 0 29.example.com',
    'sixteen.example.com 86400 MX 0 2a.example.com',
    'sixteen.example.com 86400 MX 0 2b.example.com',
    'sixteen.example.com 86400 MX 0 2c.example.com',
    'sixteen.example.com 86400 MX 0 2d.example.com',
    'sixteen.example.com 86400 MX 0 2e.example.com',
    'sixteen.example.com 86400 MX 0 2f.example.com',
    'sixteen.example.com 86400 MX 0 30.example.com',
    'sixteen.example.com 86400 MX 0 31.example.com',
    'sixteen.example.com 86400 MX 0 32.example.com',
    'sixteen.example.com 86400 MX 0 33.example.com',
    'sixteen.example.com 86400 MX 0 34.example.com',
    'sixteen.example.com 86400 MX 0 35.example.com',
    'sixteen.example.com 86400 MX 0 36.example.com',
    'sixteen.example.com 86400 MX 0 37.example.com',
    'sixteen.example.com 86400 MX 0 38.example.com',
    'sixteen.example.com 86400 MX 0 39.example.com',
    'sixteen.example.com 86400 MX 0 3a.example.com',
    'sixteen.example.com 86400 MX 0 3b.example.com',
    'sixteen.example.com 86400 MX 0 3c.example.com',
    'sixteen.example.com 86400 MX 0 3d.example.com',
    'sixteen.example.com 86400 MX 0 3e.example.com',
    'sixteen.example.com 86400 MX 0 3f.example.com',
    'sixteen.example.com 86400 MX 0 40.example.com',
    'sixteen.example.com 86400 MX 0 41.example.com',
    'sixteen.example.com 86400 MX 0 42.example.com',
    'sixteen.example.com 86400 MX 0 43.example.com',
    'sixteen.example.com 86400 MX 0 44.example.com',
    'sixteen.example.com 86400 MX 0 45.example.com',
    'sixteen.example.com 86400 MX 0 46.example.com',
    'sixteen.example.com 86400 MX 0 47.example.com',
    'sixteen.example.com 86400 MX 0 48.example.com',
    'sixteen.example.com 86400 MX 0 49.example.com',
    'sixteen.example.com 86400 MX 0 4a.example.com',
    'sixteen.example.com 86400 MX 0 4b.example.com',
    'sixteen.example.com 86400 MX 0 4c.example.com',
    'sixteen.example.com 86400 MX 0 4d.example.com',
    'sixteen.example.com 86400 MX 0 4e.example.com',
    'sixteen.example.com 86400 MX 0 4f.example.com',
    'sixteen.example.com 86400 MX 0 50.example.com',
    'sixteen.example.com 86400 MX 0 51.example.com',
    'sixteen.example.com 86400 MX 0 52.example.com',
    'sixteen.example.com 86400 MX 0 53.example.com',
    'sixteen.example.com 86400 MX 0 54.example.com',
    'sixteen.example.com 86400 MX 0 55.example.com',
    'sixteen.example.com 86400 MX 0 56.example.com',
    'sixteen.example.com 86400 MX 0 57.example.com',
    'sixteen.example.com 86400 MX 0 58.example.com',
    'sixteen.example.com 86400 MX 0 59.example.com',
    'sixteen.example.com 86400 MX 0 5a.example.com',
    'sixteen.example.com 86400 MX 0 5b.example.com',
    'sixteen.example.com 86400 MX 0 5c.example.com',
    'sixteen.example.com 86400 MX 0 5d.example.com',
    'sixteen.example.com 86400 MX 0 5e.example.com',
    'sixteen.example.com 86400 MX 0 5f.example.com',
    'sixteen.example.com 86400 MX 0 60.example.com',
    'sixteen.example.com 86400 MX 0 61.example.com',
    'sixteen.example.com 86400 MX 0 62.example.com',
    'sixteen.example.com 86400 MX 0 63.example.com',
    'sixteen.example.com 86400 MX 0 64.example.com',
    'sixteen.example.com 86400 MX 0 65.example.com',
    'sixteen.example.com 86400 MX 0 66.example.com',
    'sixteen.example.com 86400 MX 0 67.example.com',
    'sixteen.example.com 86400 MX 0 68.example.com',
    'sixteen.example.com 86400 MX 0 69.example.com',
    'sixteen.example.com 86400 MX 0 6a.example.com',
    'sixteen.example.com 86400 MX 0 6b.example.com',
    'sixteen.example.com 86400 MX 0 6c.example.com',
    'sixteen.example.com 86400 MX 0 6d.example.com',
    'sixteen.example.com 86400 MX 0 6e.example.com',
    'sixteen.example.com 86400 MX 0 6f.example.com',
    'sixteen.example.com 86400 MX 0 70.example.com',
    'sixteen.example.com 86400 MX 0 71.example.com',
    'sixteen.example.com 86400 MX 0 72.example.com',
    'sixteen.example.com 86400 MX 0 73.example.com',
    'sixteen.example.com 86400 MX 0 74.example.com',
    'sixteen.example.com 86400 MX 0 75.example.com',
    'sixteen.example.com 86400 MX 0 76.example.com',
    'sixteen.example.com 86400 MX 0 77.example.com',
    'sixteen.example.com 86400 MX 0 78.example.com',
    'sixteen.example.com 86400 MX 0 79.example.com',
    'sixteen.example.com 86400 MX 0 7a.example.com',
    'sixteen.example.com 86400 MX 0 7b.example.com',
    'sixteen.example.com 86400 MX 0 7c.example.com',
    'sixteen.example.com 86400 MX 0 7d.example.com',
    'sixteen.example.com 86400 MX 0 7e.example.com',
    'sixteen.example.com 86400 MX 0 7f.example.com',
    'sixteen.example.com 86400 MX 0 80.example.com',
    'sixteen.example.com 86400 MX 0 81.example.com',
    'sixteen.example.com 86400 MX 0 82.example.com',
    'sixteen.example.com 86400 MX 0 83.example.com',
    'sixteen.example.com 86400 MX 0 84.example.com',
    'sixteen.example.com 86400 MX 0 85.example.com',
    'sixteen.example.com 86400 MX 0 86.example.com',
    'sixteen.example.com 86400 MX 0 87.example.com',
    'sixteen.example.com 86400 MX 0 88.example.com',
    'sixteen.example.com 86400 MX 0 89.example.com',
    'sixteen.example.com 86400 MX 0 8a.example.com',
    'sixteen.example.com 86400 MX 0 8b.example.com',
    'sixteen.example.com 86400 MX 0 8c.example.com',
    'sixteen.example.com 86400 MX 0 8d.example.com',
    'sixteen.example.com 86400 MX 0 8e.example.com',
    'sixteen.example.com 86400 MX 0 8f.example.com',
    'sixteen.example.com 86400 MX 0 90.example.com',
    'sixteen.example.com 86400 MX 0 91.example.com',
    'sixteen.example.com 86400 MX 0 92.example.com',
    'sixteen.example.com 86400 MX 0 93.example.com',
    'sixteen.example.com 86400 MX 0 94.example.com',
    'sixteen.example.com 86400 MX 0 95.example.com',
    'sixteen.example.com 86400 MX 0 96.example.com',
    'sixteen.example.com 86400 MX 0 97.example.com',
    'sixteen.example.com 86400 MX 0 98.example.com',
    'sixteen.example.com 86400 MX 0 99.example.com',
    'sixteen.example.com 86400 MX 0 9a.example.com',
    'sixteen.example.com 86400 MX 0 9b.example.com',
    'sixteen.example.com 86400 MX 0 9c.example.com',
    'sixteen.example.com 86400 MX 0 9d.example.com',
    'sixteen.example.com 86400 MX 0 9e.example.com',
    'sixteen.example.com 86400 MX 0 9f.example.com',
    'sixteen.example.com 86400 MX 0 a0.example.com',
    'sixteen.example.com 86400 MX 0 a1.example.com',
    'sixteen.example.com 86400 MX 0 a2.example.com',
    'sixteen.example.com 86400 MX 0 a3.example.com',
    'sixteen.example.com 86400 MX 0 a4.example.com',
    'sixteen.example.com 86400 MX 0 a5.example.com',
    'sixteen.example.com 86400 MX 0 a6.example.com',
    'sixteen.example.com 86400 MX 0 a7.example.com',
    'sixteen.example.com 86400 MX 0 a8.example.com',
    'sixteen.example.com 86400 MX 0 a9.example.com',
    'sixteen.example.com 86400 MX 0 aa.example.com',
    'sixteen.example.com 86400 MX 0 ab.example.com',
    'sixteen.example.com 86400 MX 0 ac.example.com',
    'sixteen.example.com 86400 MX 0 ad.example.com',
    'sixteen.example.com 86400 MX 0 ae.example.com',
    'sixteen.example.com 86400 MX 0 af.example.com',
    'sixteen.example.com 86400 MX 0 b0.example.com',
    'sixteen.example.com 86400 MX 0 b1.example.com',
    'sixteen.example.com 86400 MX 0 b2.example.com',
    'sixteen.example.com 86400 MX 0 b3.example.com',
    'sixteen.example.com 86400 MX 0 b4.example.com',
    'sixteen.example.com 86400 MX 0 b5.example.com',
    'sixteen.example.com 86400 MX 0 b6.example.com',
    'sixteen.example.com 86400 MX 0 b7.example.com',
    'sixteen.example.com 86400 MX 0 b8.example.com',
    'sixteen.example.com 86400 MX 0 b9.example.com',
    'sixteen.example.com 86400 MX 0 ba.example.com',
    'sixteen.example.com 86400 MX 0 bb.example.com',
    'sixteen.example.com 86400 MX 0 bc.example.com',
    'sixteen.example.com 86400 MX 0 bd.example.com',
    'sixteen.example.com 86400 MX 0 be.example.com',
    'sixteen.example.com 86400 MX 0 bf.example.com',
    'sixteen.example.com 86400 MX 0 c0.example.com',
    'sixteen.example.com 86400 MX 0 c1.example.com',
    'sixteen.example.com 86400 MX 0 c2.example.com',
    'sixteen.example.com 86400 MX 0 c3.example.com',
    'sixteen.example.com 86400 MX 0 c4.example.com',
    'sixteen.example.com 86400 MX 0 c5.example.com',
    'sixteen.example.com 86400 MX 0 c6.example.com',
    'sixteen.example.com 86400 MX 0 c7.example.com',
    'sixteen.example.com 86400 MX 0 c8.example.com',
    'sixteen.example.com 86400 MX 0 c9.example.com',
    'sixteen.example.com 86400 MX 0 ca.example.com',
    'sixteen.example.com 86400 MX 0 cb.example.com',
    'sixteen.example.com 86400 MX 0 cc.example.com',
    'sixteen.example.com 86400 MX 0 cd.example.com',
    'sixteen.example.com 86400 MX 0 ce.example.com',
    'sixteen.example.com 86400 MX 0 cf.example.com',
    'sixteen.example.com 86400 MX 0 d0.example.com',
    'sixteen.example.com 86400 MX 0 d1.example.com',
    'sixteen.example.com 86400 MX 0 d2.example.com',
    'sixteen.example.com 86400 MX 0 d3.example.com',
    'sixteen.example.com 86400 MX 0 d4.example.com',
    'sixteen.example.com 86400 MX 0 d5.example.com',
    'sixteen.example.com 86400 MX 0 d6.example.com',
    'sixteen.example.com 86400 MX 0 d7.example.com',
    'sixteen.example.com 86400 MX 0 d8.example.com',
    'sixteen.example.com 86400 MX 0 d9.example.com',
    'sixteen.example.com 86400 MX 0 da.example.com',
    'sixteen.example.com 86400 MX 0 db.example.com',
    'sixteen.example.com 86400 MX 0 dc.example.com',
    'sixteen.example.com 86400 MX 0 dd.example.com',
    'sixteen.example.com 86400 MX 0 de.example.com',
    'sixteen.example.com 86400 MX 0 df.example.com',
    'sixteen.example.com 86400 MX 0 e0.example.com',
    'sixteen.example.com 86400 MX 0 e1.example.com',
    'sixteen.example.com 86400 MX 0 e2.example.com',
    'sixteen.example.com 86400 MX 0 e3.example.com',
    'sixteen.example.com 86400 MX 0 e4.example.com',
    'sixteen.example.com 86400 MX 0 e5.example.com',
    'sixteen.example.com 86400 MX 0 e6.example.com',
    'sixteen.example.com 86400 MX 0 e7.example.com',
    'sixteen.example.com 86400 MX 0 e8.example.com',
    'sixteen.example.com 86400 MX 0 e9.example.com',
    'sixteen.example.com 86400 MX 0 ea.example.com',
    'sixteen.example.com 86400 MX 0 eb.example.com',
    'sixteen.example.com 86400 MX 0 ec.example.com',
    'sixteen.example.com 86400 MX 0 ed.example.com',
    'sixteen.example.com 86400 MX 0 ee.example.com',
    'sixteen.example.com 86400 MX 0 ef.example.com',
    'sixteen.example.com 86400 MX 0 f0.example.com',
    'sixteen.example.com 86400 MX 0 f1.example.com',
    'sixteen.example.com 86400 MX 0 f2.example.com',
    'sixteen.example.com 86400 MX 0 f3.example.com',
    'sixteen.example.com 86400 MX 0 f4.example.com',
    'sixteen.example.com 86400 MX 0 f5.example.com',
    'sixteen.example.com 86400 MX 0 f6.example.com',
    'sixteen.example.com 86400 MX 0 f7.example.com',
    'sixteen.example.com 86400 MX 0 f8.example.com',
    'sixteen.example.com 86400 MX 0 f9.example.com',
    'sixteen.example.com 86400 MX 0 fa.example.com',
    'sixteen.example.com 86400 MX 0 fb.example.com',
    'sixteen.example.com 86400 MX 0 fc.example.com',
    'sixteen.example.com 86400 MX 0 fd.example.com',
    'sixteen.example.com 86400 MX 0 fe.example.com',
    'sixteen.example.com 86400 MX 0 ff.example.com',
    'sixteen.example.com 86400 MX 0 257.example.com',
    'sixteen.example.com 86400 MX 0 258.example.com',
];

my $cname_16 = [
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef1.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef2.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef2.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef3.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef3.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef4.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef4.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef5.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef5.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef6.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef6.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef7.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef7.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef8.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef8.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef9.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef9.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef10.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef10.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef11.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef11.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef12.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef12.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef13.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef13.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef14.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef14.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef15.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef15.example.com 86400 CNAME 0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef16.example.com',
    '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef16.example.com 86400 CNAME sixteen.example.com',
];

my $pid = _GDT->test_spawn_daemon();

# MX/SRV targets pointed at root of DNS
_GDT->test_dns(
    qname => 'cov.example.com', qtype => 'MX',
    answer => 'cov.example.com 86400 MX 1 .',
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [
        'ns1.example.com 86400 A 192.0.2.1',
        'ns2.example.com 86400 A 192.0.2.2',
    ],
);

_GDT->test_dns(
    qname => 'cov.example.com', qtype => 'SRV',
    answer => 'cov.example.com 86400 SRV 1 2 3 .',
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [
        'ns1.example.com 86400 A 192.0.2.1',
        'ns2.example.com 86400 A 192.0.2.2',
    ],
);

my $chaos = Net::DNS::Packet->new();
$chaos->push('question', Net::DNS::Question->new('foo', 'TXT', 'CH'));
_GDT->test_dns(
    qpacket => $chaos,
    header => { aa => 0 },
    answer => 'foo CH TXT gdnsd',
);

# coverage for placing various types of domainnames past the 16K point,
#  as well as >256 potential compression targets in a single packet.
#  which causes special cases in the code wrt compression and additional
#  records.
_GDT->test_dns(
    resopts => { usevc => 0, igntc => 0, udppacketsize => 16000 },
    qname => 'sixteen.example.com', qtype => 'MX',
    answer => $mx_258,
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [@$addtl_256, $optrr],
    stats => [qw/udp_reqs edns udp_edns_big noerror/],
);

_GDT->test_dns(
    resopts => { usevc => 0, igntc => 0, udppacketsize => 16000 },
    qname => 'sixteen.example.com', qtype => 'SRV',
    answer => $srv_258,
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [@$addtl_256, $optrr],
    stats => [qw/udp_reqs edns udp_edns_big noerror/],
);

_GDT->test_dns(
    resopts => { usevc => 0, igntc => 0, udppacketsize => 32000 },
    qname => '0123456789abcdef0123456789abcdef0123456789abcdef0123456789ab.cdef0123456789abcdef0123456789abcdef0123456789abcdef01234567.89abcdef0123456789abcdef0123456789abcdef1.example.com', qtype => 'MX',
    answer => [@$cname_16, @$mx_258],
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [@$addtl_256, $optrr],
    stats => [qw/udp_reqs edns udp_edns_big noerror/],
);

_GDT->test_dns(
    resopts => { usevc => 0, igntc => 0, udppacketsize => 32000 },
    qname => 'sixteen.example.com', qtype => 'ANY',
    answer => [
        'sixteen.example.com 86400 TXT ' . $sixteen_txt,
        @$srv_258,
        @$mx_258,
    ],
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [@$addtl_256[0..91], $optrr],
    stats => [qw/udp_reqs edns udp_edns_big noerror/],
);

# send edns-client-subnet while disabled in config...
_GDT->test_dns(
    qname => 'ns1.example.com', qtype => 'A',
    q_optrr => _GDT::optrr_clientsub(addr_v4 => '192.0.2.0', src_mask => 32),
    answer => 'ns1.example.com 86400 A 192.0.2.1',
    auth => [
        'example.com 86400 NS ns1.example.com',
        'example.com 86400 NS ns2.example.com',
    ],
    addtl => [
        'ns2.example.com 86400 A 192.0.2.2',
        $optrr,
    ],
    stats => [qw/udp_reqs edns noerror/],
);

# Questions containing Additional Records which are not OPT RRs...

{
    my $qpacket = Net::DNS::Packet->new();
    $qpacket->push('question', Net::DNS::Question->new('foo.example.com', 'A'));
    $qpacket->push('additional', $long_rr);
    _GDT->test_dns(
        qpacket => $qpacket,
        answer => 'foo.example.com 86400 A 192.0.2.3',
        auth => [
            'example.com 86400 NS ns1.example.com',
            'example.com 86400 NS ns2.example.com',
        ],
        addtl => [
            'ns1.example.com 86400 A 192.0.2.1',
            'ns2.example.com 86400 A 192.0.2.2',
        ],
    );
}

{
    my $qpacket = Net::DNS::Packet->new();
    $qpacket->push('question', Net::DNS::Question->new('foo.example.com', 'A'));
    $qpacket->push('additional', $long_root_rr);
    _GDT->test_dns(
        qpacket => $qpacket,
        answer => 'foo.example.com 86400 A 192.0.2.3',
        auth => [
            'example.com 86400 NS ns1.example.com',
            'example.com 86400 NS ns2.example.com',
        ],
        addtl => [
            'ns1.example.com 86400 A 192.0.2.1',
            'ns2.example.com 86400 A 192.0.2.2',
        ],
    );
}

_GDT->test_kill_daemon($pid);
