/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "allocate.h"
#include "gettext.h"
#include "widgets.h"
#include "commands.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "populate_scope_treeview.h"
#include "select_first_scope.h"
#include "set_num_ranges.h"
#include "populate_ranges.h"
#include "populate_scope_settings.h"
#include "populate_host_treeview.h"
#include "populate_host_settings.h"
#include "populate_leases.h"
#include "reread_conf.h"
#include "settings_window.h"

extern char LEASE_FILE_BUF[1024];
extern char DHCPD_CONF_BUF[1024];



void apply_settings_button_clicked(struct gdhcpd_widgets *widgets)
{
    /* The apply button in the settings window */
    FILE *fp;
    long file_size;
    char *conf, *new_conf, *tmp;
    char *ddns_update_style;
    char *ddns_updates;
    char *client_updates;
    char *one_lease_per_client;
    char *bootp;
    gint active_index = 0;
    gchar *cmd, *settings_file, *setting;

    G_CONST_RETURN gchar *conf_file = gtk_entry_get_text(GTK_ENTRY(widgets->settings_entry[0]));
    G_CONST_RETURN gchar *lease_file = gtk_entry_get_text(GTK_ENTRY(widgets->settings_entry[1]));
    

    settings_file = g_strdup_printf("%s/settings.conf", SETTINGS_PATH);

    /* If the settings directory doesnt exist, create it */
    if( ! file_exists(SETTINGS_PATH) )
    {
	cmd = g_strdup_printf("mkdir -p %s", SETTINGS_PATH);
	if( ! run_command(cmd) )
	{
	    printf("Can not run command:\n%s\n", cmd);
	    g_free(cmd);
	    g_free(settings_file);
	    return;
	}
	g_free(cmd);
    }

    /* Save the paths */
    if((fp=fopen(settings_file, "w+"))==NULL)
    {
	printf("Can not open the settings file here:\n%s\n", settings_file);
	g_free(settings_file);
	return;
    }
    
    setting = g_strdup_printf("dhcpd_conf: %s\n", conf_file);
    fputs(setting, fp);
    g_free(setting);

    setting = g_strdup_printf("lease_file: %s\n", lease_file);
    fputs(setting, fp);
    g_free(setting);

    fclose(fp);
    g_free(settings_file);


    /* Make the paths current. */
    sprintf(DHCPD_CONF_BUF, "%s", conf_file);
    sprintf(LEASE_FILE_BUF, "%s", lease_file);


    /* DDNS update style */
    ddns_update_style = allocate(1024);
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->settings_combo[0]));
    if( active_index <= 0 )
        snprintf(ddns_update_style, 1000, "%s", "ad-hoc");
    else
    if( active_index == 1 )
	snprintf(ddns_update_style, 1000, "%s", "interim");
    else
	snprintf(ddns_update_style, 1000, "%s", "none");

    /* DDNS updates */
    ddns_updates = allocate(1024);
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->settings_combo[1]));
    if( active_index <= 0 )
        snprintf(ddns_updates, 1000, "%s", "on");
    else
    if( active_index == 1 )
        snprintf(ddns_updates, 1000, "%s", "off");
    else
        snprintf(ddns_updates, 1000, "%s", "off");

      
    /* Client updates */    
    client_updates = allocate(1024);
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->settings_combo[2]));
    if( active_index <= 0 )
        snprintf(client_updates, 1000, "%s", "allow");
    else
    if( active_index == 1 )
	snprintf(client_updates, 1000, "%s", "deny");
    else
	snprintf(client_updates, 1000, "%s", "ignore");


    /* One lease per client */    
    one_lease_per_client = allocate(1024);
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->settings_combo[3]));
    if( active_index <= 0 )
        snprintf(one_lease_per_client, 1000, "%s", "true");
    else
	snprintf(one_lease_per_client, 1000, "%s", "false");

    /* BOOTP */    
    bootp = allocate(1024);
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->settings_combo[4]));
    if( active_index <= 0 )
        snprintf(bootp, 1000, "%s", "allow");
    else
    if( active_index == 1 )
	snprintf(bootp, 1000, "%s", "deny");
    else
	snprintf(bootp, 1000, "%s", "ignore");

    
    if( ! file_exists((char *)conf_file) )
      printf("Creating a new dhcpd.conf here: %s\n", conf_file);


    /* Creates a default conf if its missing */
    add_missing_values((gchar *)conf_file);


    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
	printf("Cant open: %s\n", DHCPD_CONF_BUF);
	free(ddns_update_style);
	free(ddns_updates);
	free(client_updates);
	free(one_lease_per_client);
	free(bootp);
	return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);
    
    conf = allocate(file_size+1);
    new_conf = allocate(file_size+8192); /* For changes */
    tmp = allocate(1024);

    snprintf(tmp, 1000, "ddns-update-style %s;\n", ddns_update_style);
    strcat(new_conf, tmp);

    snprintf(tmp, 1000, "ddns-updates %s;\n", ddns_updates);
    strcat(new_conf, tmp);

    snprintf(tmp, 1000, "%s client-updates;\n", client_updates);
    strcat(new_conf, tmp);
    
    snprintf(tmp, 1000, "one-lease-per-client %s;\n", one_lease_per_client);
    strcat(new_conf, tmp);

    snprintf(tmp, 1000, "%s bootp;\n", bootp);
    strcat(new_conf, tmp);

    free(tmp);
    free(ddns_update_style);
    free(ddns_updates);
    free(client_updates);
    free(one_lease_per_client);
    free(bootp);


    /* Get everything but the values to change */
    while(fgets(conf, file_size, fp)!=NULL)
    {    
	if( ! strstr(conf, "ddns-update-style")
	&&  ! strstr(conf, "ddns-updates")
	&&  ! strstr(conf, "client-updates;")
	&&  ! strstr(conf, "one-lease-per-client")
	&&  ! strstr(conf, "bootp;") )
	  strcat(new_conf, conf);
    }
    fclose(fp);
    free(conf);

    /* Write the new conf */
    if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
    {
	printf("Cant write: %s\n", DHCPD_CONF_BUF);
	free(new_conf);
	return;
    }
    fputs(new_conf, fp);
    fclose(fp);

    free(new_conf);
    
    /* Reread entire gui */
    populate_scope_treeview(widgets);
    select_first_scope(widgets);

    set_num_ranges(global_nic, global_subnet, global_netmask);
    populate_ranges(widgets, global_nic, global_subnet, global_netmask);

    populate_scope_settings(widgets);

    populate_host_treeview(widgets);
    populate_host_settings(widgets);

    populate_leases(widgets);
    
    gtk_widget_destroy(widgets->settings_window);

    reread_conf();
}


void cancel_settings_button_clicked(struct gdhcpd_widgets *widgets)
{
    gtk_widget_destroy(widgets->settings_window);
}


void show_settings_window(struct gdhcpd_widgets *widgets)
{
    FILE *fp;
    long file_size;
    char *conf, *tmp;
    GtkWidget *frame;
    GtkWidget *table;
    GtkWidget *settings_vbox;
    GtkTooltips *tooltips;
    gchar *info;
    gchar *utf8=NULL;

    widgets->settings_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_position(GTK_WINDOW (widgets->settings_window), GTK_WIN_POS_CENTER);
    gtk_widget_set_size_request(widgets->settings_window, -1, -1);

    /* Set window information */
    info = g_strdup_printf(_("GDHCPD %s settings"), VERSION);
    gtk_window_set_title(GTK_WINDOW(widgets->settings_window), info);
    g_free(info);

    g_signal_connect(GTK_WINDOW(widgets->settings_window), "delete_event", 
		     G_CALLBACK (gtk_widget_destroy), NULL);

    settings_vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add (GTK_CONTAINER (widgets->settings_window), settings_vbox);


    tooltips = gtk_tooltips_new();
    frame = gtk_frame_new("Settings:");

    /* A table with 16 settings and 2 columns */
    table = gtk_table_new(16, 2, FALSE);

    gtk_box_pack_start(GTK_BOX(settings_vbox), frame, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame), table);

    /* Max length and input 350 chars */
    widgets->settings_entry[0] = make_entry_with_label(GTK_TABLE(table), _(" Path to dhcpd.conf: "),   0,1,0,1,350);
    gtk_tooltips_set_tip(tooltips, widgets->settings_entry[0], "/path/to/dhcpd.conf", NULL);

    widgets->settings_entry[1] = make_entry_with_label(GTK_TABLE(table), _(" Path to dhcpd.leases: "), 0,1,1,2,350);
    gtk_tooltips_set_tip(tooltips, widgets->settings_entry[1], "/path/to/dhcpd.leases", NULL);

    widgets->settings_combo[0] = make_combo_with_label(GTK_TABLE(table), _(" DDNS update style: "),    0,1,2,3,350);
    widgets->settings_combo[1] = make_combo_with_label(GTK_TABLE(table), _(" DDNS updates: "),    0,1,3,4,350);
    widgets->settings_combo[2] = make_combo_with_label(GTK_TABLE(table), _(" Client updates: "),       0,1,4,5,350);
    widgets->settings_combo[3] = make_combo_with_label(GTK_TABLE(table), _(" One lease per client: "), 0,1,6,7,350);
    widgets->settings_combo[4] = make_combo_with_label(GTK_TABLE(table), _(" BOOTP: "),                0,1,8,9,350);

    /* Set entry texts */
    utf8 = g_locale_to_utf8(DHCPD_CONF_BUF, strlen(DHCPD_CONF_BUF), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->settings_entry[0]), utf8);

    utf8 = g_locale_to_utf8(LEASE_FILE_BUF, strlen(LEASE_FILE_BUF), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->settings_entry[1]), utf8);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
    
	return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);
    conf = allocate(file_size+1);
    tmp = allocate(file_size+1);

    while(fgets(conf, file_size, fp)!=NULL)
    {    
	if( strstr(conf, "ddns-update-style") )
	{
	    snprintf(tmp, 1000, "%s", _("Ad-hoc"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[0]), utf8);

	    snprintf(tmp, 1000, "%s", _("Interim"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[0]), utf8);

	    snprintf(tmp, 1000, "%s", _("None"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[0]), utf8);

	    /* Set selected. Cut 18 chars from the beginning of the line */
	    snprintf(tmp, 1000, "%s", &conf[18]);
	    /* Cut ; and newline */
	    tmp[strlen(tmp)-2]='\0';
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    if( !strcmp(tmp, "ad-hoc") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[0]), 0);
	    if( !strcmp(tmp, "interim") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[0]), 1);
	    if( !strcmp(tmp, "none") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[0]), 2);
	}
	else
	if( strstr(conf, "ddns-updates") )
	{
	    snprintf(tmp, 1000, "%s", _("Yes"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[1]), utf8);

	    snprintf(tmp, 1000, "%s", _("No"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[1]), utf8);

	    /* Cut 21 chars from the beginning of the line */
	    snprintf(tmp, 1000, "%s", &conf[13]);
	    tmp[strlen(tmp)-2]='\0';
	    if( !strcmp(tmp, "on") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[1]), 0);
	    if( !strcmp(tmp, "off") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[1]), 1);
	}
	else
	if( strstr(conf, "client-updates;") )
	{
	    snprintf(tmp, 1000, "%s", _("Allow"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[2]), utf8);

	    snprintf(tmp, 1000, "%s", _("Deny"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[2]), utf8);

	    snprintf(tmp, 1000, "%s", _("Ignore"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[2]), utf8);

	    snprintf(tmp, 1000, "%s", conf);
	    tmp[strlen(tmp)-17]='\0';
	    if( !strcmp(tmp, "allow") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[2]), 0);
	    if( !strcmp(tmp, "deny") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[2]), 1);
	    if( !strcmp(tmp, "ignore") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[2]), 2);
	}
	else
	if( strstr(conf, "one-lease-per-client") )
	{
	    snprintf(tmp, 1000, "%s", _("Yes"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[3]), utf8);

	    snprintf(tmp, 1000, "%s", _("No"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[3]), utf8);

	    /* Cut 21 chars from the beginning of the line */
	    snprintf(tmp, 1000, "%s", &conf[21]);
	    tmp[strlen(tmp)-2]='\0';
	    if( !strcmp(tmp, "true") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[3]), 0);
	    if( !strcmp(tmp, "false") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[3]), 1);
	}
        else
	if( strstr(conf, "bootp;") )
	{
	    snprintf(tmp, 1000, "%s", _("Allow"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[4]), utf8);

	    snprintf(tmp, 1000, "%s", _("Deny"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[4]), utf8);

	    snprintf(tmp, 1000, "%s", _("Ignore"));
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->settings_combo[4]), utf8);

	    snprintf(tmp, 1000, "%s", conf);
	    tmp[strlen(tmp)-8]='\0';
	    if( !strcmp(tmp, "allow") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[4]), 0);
	    if( !strcmp(tmp, "deny") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[4]), 1);
	    if( !strcmp(tmp, "ignore") )
	      gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->settings_combo[4]), 2);
	}
    }
    fclose(fp);
    free(conf);
    free(tmp);

    if( utf8!=NULL )
      g_free(utf8);

    GtkWidget *settings_hbuttonbox = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(settings_vbox), settings_hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(settings_hbuttonbox), GTK_BUTTONBOX_SPREAD);

    GtkWidget *apply_settings_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_container_add(GTK_CONTAINER(settings_hbuttonbox), apply_settings_button);
    g_signal_connect_swapped(G_OBJECT(apply_settings_button), "clicked", 
                             G_CALLBACK(apply_settings_button_clicked), widgets);
    
    GtkWidget *cancel_settings_button = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
    gtk_container_add(GTK_CONTAINER(settings_hbuttonbox), cancel_settings_button);
    g_signal_connect_swapped(G_OBJECT(cancel_settings_button), "clicked", 
                             G_CALLBACK(cancel_settings_button_clicked), widgets);

    gtk_widget_show_all(widgets->settings_window);
}
