/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "commands.h"
#include "create_scope_set_entries.h"


extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern char DHCPD_CONF_BUF[1024];


void populate_scope_settings(struct gdhcpd_widgets *widgets)
{
    FILE *fp;
    gchar *utf8=NULL;
    char *line, *buffy;
    long conf_size=0;
    int found_scope=0, y=0, i=0;

    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    gtk_widget_destroy(widgets->scope_set_scrolled_vbox);
    widgets->scope_set_scrolled_vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(widgets->scope_set_viewport), widgets->scope_set_scrolled_vbox);


    /* Create the settings entries */
    create_scope_set_entries(widgets);
    gtk_widget_show_all(widgets->main_window);
    
    /* Populate nic,subnet,netmask entries from the global values */
    utf8 = g_locale_to_utf8((char *)global_nic, strlen(global_nic), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[0]), utf8);

    utf8 = g_locale_to_utf8((char *)global_subnet, strlen(global_subnet), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[1]), utf8);

    utf8 = g_locale_to_utf8((char *)global_netmask, strlen(global_netmask), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[2]), utf8);


    buffy = allocate(1024);

    /* Insert the values from the scope */
    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( (strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope=1;
		    break;
		}
	    }
	}
	if( found_scope )
	  break;
    }

    if( found_scope )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	/* Break at scope end */
	if( strstr(line, "}") && ! strstr(line, "#") )
	  break;

	if( strlen(line)>1000 )
	  continue;

	remove_semicolon(line);

	if( strstr(line, "default-lease-time") && ! strstr(line, "#") )
	{
    	    sscanf(line, "%*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[3]), utf8);
	}

	if( strstr(line, "max-lease-time") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[4]), utf8);
	}

	if( strstr(line, "option domain-name") && ! strstr(line, "#")
	&& ! strstr(line, "option domain-name-servers")  )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }
	      
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[5]), utf8);
	}

	if( strstr(line, "option subnet-mask") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[6]), utf8);
	}

	if( strstr(line, "option broadcast-address") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[7]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option routers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[8]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option domain-name-servers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[9]), utf8);
	}

	if( strstr(line, "option nis-domain") && ! strstr(line, "#") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[10]), utf8);
	}

	if( strstr(line, "option time-offset") && ! strstr(line, "#") )
	{
	    sscanf(line, "%*s %*s %s", buffy);
	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[11]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option ntp-servers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[12]), utf8);
	}

	/* 3 values max */
	if( strstr(line, "option netbios-name-servers") && ! strstr(line, "#") )
	{
	    for(y=0; y<strlen(line)-1; y++)
	    if( line[y]=='s' && line[y+1]==' ' )
	      break;

	    for(y=y+1; y<strlen(line)-1; y++)
	    if( line[y]!=' ' )
	      break;
	    
	    strncpy(buffy, &line[y], strlen(line));

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[13]), utf8);
	}

	if( strstr(line, "option T150") && ! strstr(line, "#") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[14]), utf8);
	}

	if( strstr(line, "filename") && ! strstr(line, "#") )
	{
	    if( strstr(line, "\"") )
	    {
	       isolate_setting(line);
	       sprintf(buffy, "%s", line);
	    }
	    else
	      {
	         sscanf(line, "%*s %s", buffy);
		 sprintf(line, "%s", buffy);
	      }

	    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[15]), utf8);
	}
    }

    if( ! found_scope )
    {
	/* Clear the scope settings entries */
	for(i=0; i < NUM_SCOPE_SETTINGS; i++)
	   gtk_entry_set_text(GTK_ENTRY(widgets->scope_set_entry[i]), "");
    }

    fclose(fp);
    free(line);
    free(buffy);

    if( utf8!=NULL )
      g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
