/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005, 2006 Magnus Loef <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"


extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;

#include "allocate.h"
#include "show_info.h"
#include "reread_conf.h"


void delete_scope(struct gdhcpd_widgets *widgets)
{
    FILE *fp;
    long conf_size=0;
    int found_scope=0;
    char *line;
    char *new_conf, *temp_scope;
    char *line_from;
    char *line_to;
    gchar *info;

    line_from = allocate(MAX_CONF_LINE);

    line_to = allocate(MAX_CONF_LINE);

    /* 3 different styles ...\n{ or ...{ or ... { */
    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    if( strlen(global_nic)==0 || strlen(global_subnet)==0 || strlen(global_netmask)==0 )
    {
       info = g_strdup_printf(_("Missing values in delete scope, scope not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);

    temp_scope = allocate(conf_size+1);

    line = allocate(conf_size+1);

    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    strcat(temp_scope, line);    
	
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		strcat(temp_scope, line);

		/* Find nic line */
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope=1;
		    
		    while(fgets(line, conf_size, fp)!=NULL)
		    {
		       strcat(temp_scope, line);

		       if( strstr(line, "}") && ! strstr(line, "#") )
		       {
			  strcpy(temp_scope, "");
		          break;
		       }
		    }
		    
		    break;
		}

		if( ( strstr(line, "interface") || strstr(line, "}") )
		&& ( ! strstr(line, nic_line) && ! strstr(line, "#") ) )
		{
		    /* Not the correct scope, putting this one back */
		    strcat(new_conf, temp_scope);
		    break;
		}
	    }
	}
	else
	  strcat(new_conf, line);
	
	if( found_scope )
	  break;
    }

    /* Get the rest */
    while(fgets(line, conf_size, fp)!=NULL)
    {
        strcat(new_conf, line);
    }

    fclose(fp);

    if( found_scope )
    {

	if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
	{
    	    printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
    	    return;
	}
	else
          {
             fputs(new_conf, fp);
	     fclose(fp);
	  }
    }

    free(new_conf);
    free(temp_scope);
    free(line);
    free(line_from);
    free(line_to);

    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
}
