from ConfigWidget import ConfigWidget
from utils.datatypes import *

import gtk


class ConfigColor(ConfigWidget):

    def __init__(self, name, getter, setter, caller):

        ConfigWidget.__init__(self, name, getter, setter, caller)

        self._register_property("value", TYPE_STRING, self._setp_value,
                                self._getp, "black", doc = "Color value")


    def get_widgets(self):

        self.__label = gtk.Label("")
        self.__label.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(self.__label)

        self.__colorpicker = gtk.ColorButton()
        self.__colorpicker.set_use_alpha(True)
        self.__colorpicker.show()
        self.__colorpicker.connect("color-set", self.__on_change)

        return (align, self.__colorpicker)


    def _set_enabled(self, value):

        self.__colorpicker.set_sensitive(value)


    def _set_label(self, value):

        self.__label.set_text(value)


    def __parse_color(self, value):

        if ("#" in value and len(value) == 9):
            opacity = int(value[7:], 16) * 256
            return (value[:7], opacity)
        else:
            return (value, 0xffff)



    def __on_change(self, src):

        color = src.get_color()
        alpha = src.get_alpha()
        value = "#%02X%02X%02X%02X" % (color.red / 256, color.green / 256,
                                       color.blue / 256, alpha / 256)
        self._set_config(value)


    def _setp_value(self, key, value):
        
        colorname, alpha = self.__parse_color(value)
        color = gtk.gdk.color_parse(colorname)
        self.__colorpicker.set_color(color)
        self.__colorpicker.set_alpha(alpha)
        self._set_config(value)
        self._setp(key, value)
