import gtk
import sys


#
# Functions for creating every kind of dialog. They are for internal use.
#


def _set_message(dialog, primary, secondary):

    # create a HIG compliant message
    message = "<span weight=\"bold\" size=\"larger\">%(primary)s</span>\n" \
              "\n" \
              "%(secondary)s" % vars()

    # HIG says: no title
    dialog.set_title("")

    lbl = dialog.vbox.get_children()[0].get_children()[1]
    lbl.set_markup(message)


def error(primary, secondary):

    dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR,
                               gtk.BUTTONS_OK)
    _set_message(dialog, primary, secondary)
    gtk.threads_enter()
    dialog.run()
    gtk.threads_leave()
    sys.exit(1)


def warning(primary, secondary):

    dialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_WARNING,
                               gtk.BUTTONS_OK)
    _set_message(dialog, primary, secondary)
    gtk.threads_enter()
    dialog.run()
    gtk.threads_leave()
    dialog.destroy()


def info(primary, secondary):

    dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO,
                               gtk.BUTTONS_OK)
    _set_message(dialog, primary, secondary)
    gtk.threads_enter()
    dialog.run()
    gtk.threads_leave()
    dialog.destroy()



def fileselector(title, callback_ok, callback_cancel, *args):

    def on_cancel(src, fsel): fsel.destroy()

    fsel = gtk.FileSelection()
    if (title): fsel.set_title(title)

    if (callback_ok):
        args = ["clicked", callback_ok, fsel] + list(args)
        fsel.ok_button.connect(*args)
        
    if (callback_cancel):
        args = ["clicked", callback_cancel, fsel] + list(args)
        fsel.cancel_button.connect(*args)
    else:
        fsel.cancel_button.connect("clicked", on_cancel, fsel)
        
    fsel.show()



def progress(text, parent = None):

    dialog = gtk.Dialog("", parent, 0, ())
    vbox = gtk.VBox()
    vbox.show()
    dialog.vbox.pack_start(vbox, 0, 0, 0)
    
    lbl = gtk.Label("")
    lbl.set_markup(text)
    lbl.show()
    vbox.add(lbl)

    bar = gtk.ProgressBar()
    bar.show()
    vbox.add(bar)

    dialog.show()

    def f(value):
        value = max(0, value)
        
        if (value >= 100):
            dialog.destroy()
        else:
            bar.set_fraction(value / 100.0)
            bar.set_text("%i%%" % value)

        while (gtk.events_pending()): gtk.mainiteration()


    return f
