#
# Library for common functionality.
#

# convert
#   human_readable_bytes(bytes:int): (int)
#   bytes_to_gmkb(bytes:int): (int, int, int, int)
#   gmkb_to_bytes(GB:int, MB:int, kB:int, Bytes:int): (bytes:int)
#   secs_to_dhms(secs:int): (days:int, hrs:int, mins:int, secs:int)
#   dmhs_to_secs(days:int, hrs:int, mins:int, secs:int)
#   centigrade_to_fahrenheit(centigrade:int): (fahrenheit:int)
#   fahrenheit_to_centigrade(fahrenheit:int): (centigrade:int)
#   centigrade_to_kelvin(centigrade:int): (kelvin:int)
#   kelvin_to_centigrade(kelvin:int): (centigrade:int)
#
# cpu
#   get_speed(): float
#   get_model(): str
#   get_cache_size(): str
#   get_load(): (total:int, load:int)
#
# disk
#   get_partitions(): [(device:str, mpoint:str),...]
#   get_size(partition:str): (total:int, used:int)
#   get_fs(partition:str): (filesystem:str)
#
# memory
#   get_ram(): (total:int, used:int)
#   get_swap(): (total:int, used:int)
#
# network
#   get_devices(): [device:str,...]
#   get_ipaddr(): str
#   get_bytes_in_out(dev:str): (int, int)
#   get_pack_in_out(dev:str): (int, int)
#   get_speed_in_out(dev:str): (int, int)
#
# system
#   get_arch(): str
#   get_os(): str
#   get_name(): str
#   get_kernel(); str
#   get_uptime(): int
#   get_idletime(): int
#   get_users(): int
#   get_load_avg_1m(): float
#   get_load_avg_5m(): float
#   get_load_avg_15m(): float
#   get_tasks(): (total:int, running:int)


from Convert import Convert
from CPU import CPU
from Disk import Disk
from Memory import Memory
from Network import Network
from Sys import Sys


convert = Convert()
cpu = CPU()
disk = Disk()
memory = Memory()
net = Network()
sys = Sys()
