import polling
import glibtop

import commands, os


class Sys:

    def __init__(self):

        self.get_os           = polling.wrap(self.__poll_os, 0)
        self.get_arch         = polling.wrap(self.__poll_arch, 0)
        self.get_name         = polling.wrap(self.__poll_name, 0)
        self.get_kernel       = polling.wrap(self.__poll_kernel, 0)
        self.get_users        = polling.wrap(self.__poll_users, 30)
        self.get_uptime       = polling.wrap(self.__poll_uptime, 2, 0)
        self.get_idletime     = polling.wrap(self.__poll_uptime, 2, 1)
        self.get_load_avg_1m  = polling.wrap(self.__poll_load_avg, 30, 0)
        self.get_load_avg_5m  = polling.wrap(self.__poll_load_avg, 30, 1)
        self.get_load_avg_15m = polling.wrap(self.__poll_load_avg, 30, 2)
        self.get_tasks        = polling.wrap(self.__poll_tasks, 2)
        self.get_proclist     = polling.wrap(self.__poll_proclist, 2)
        self.get_proc_state   = polling.wrap(self.__poll_proc_state, 2)
        self.get_proc_uid     = polling.wrap(self.__poll_proc_uid, 2)
        self.get_proc_mem     = polling.wrap(self.__poll_proc_mem, 2)
        self.get_proc_time    = polling.wrap(self.__poll_proc_time, 2)
        self.get_proc_signal  = polling.wrap(self.__poll_proc_signal, 2)
        self.get_proc_kernel  = polling.wrap(self.__poll_proc_kernel, 2)
        self.get_proc_segment = polling.wrap(self.__poll_proc_segment, 2)
        self.get_proc_args    = polling.wrap(self.__poll_proc_args, 2)
        self.get_proc_map     = polling.wrap(self.__poll_proc_map, 2)



    def __poll_arch(self):

        return (os.uname()[4])



    def __poll_os(self):

        return (os.uname()[0])



    def __poll_name(self):

        return (os.uname()[1])



    def __poll_kernel(self):

        return (os.uname()[2])



    def __poll_users(self):

        uptime = commands.getoutput("uptime")
        return int(uptime.split()[-7])



    def __poll_uptime(self, mode):

        uptime, idletime = glibtop.get_uptime()

        # uptime
        if (mode == 0):
            return int(float(uptime))
        # idle time
        elif (mode == 1):
            return int(float(idletime))



    def __poll_load_avg(self, mode):

        avg1, avg5, avg15 = glibtop.get_loadavg()[0]
        if (mode == 0): return int(avg1 * 100) / 100.0
        elif (mode == 1): return int(avg5 * 100) / 100.0
        elif (mode == 2): return int(avg15 * 100) / 100.0



    def __poll_tasks(self):

        running, tasks = glibtop.get_loadavg()[1:3]

        return (tasks, running)


    def __poll_proclist(self, which, arg):

        pass



    def __poll_proc_state(self, pid):

        pass



    def __poll_proc_uid(self, pid):

        pass



    def __poll_proc_mem(self, pid):

        pass



    def __poll_proc_time(self, pid):

        pass



    def __poll_proc_signal(self, pid):

        pass



    def __poll_proc_kernel(self, pid):

        pass



    def __poll_proc_segment(self, pid):

        pass



    def __poll_proc_args(self, pid):

        pass



    def __poll_proc_map(self, pid):

        pass
