from ContainerTarget import ContainerTarget
from utils.datatypes import *
from utils import vfs

import gtk


_STATE_VISIBLE = 0
_STATE_HIDDEN = 1


#
# Class for target expander.
#
class TargetExpander(ContainerTarget):

    __ACTION_EXPAND = 100

    def __init__(self, parent, display):

        self.__show_state = _STATE_VISIBLE
        
        ContainerTarget.__init__(self, parent, display)
        self.__icon = gtk.Image()
        self.__icon.show()
        align=gtk.Alignment(0.0, 0.0)
        align.show()
        align.add(self.__icon)
        self.pack_start(align, gtk.FALSE, gtk.FALSE, 0)

        self._set_property_type("expanded", TYPE_BOOL)
        self._set_property_type("icon-uri", TYPE_STRING)
        self._set_property_type("on-expand", TYPE_STRING)



    def __on_click(self, src, event):

        if (self.__show_state == _STATE_VISIBLE):
            self.__set_expanded(gtk.FALSE)
        else:
            self.__set_expanded(gtk.TRUE)



    def __set_expanded(self, value):

        if (value): self.__show_state = _STATE_VISIBLE
        else: self.__show_state = _STATE_HIDDEN

        iconw, iconh = self.__icon.size_request()

        if (self.__show_state == _STATE_VISIBLE):
            #self._get_child().show()
            self._get_child().set_config("visible", "true")
            width, height = self._get_child().get_geometry()[2:]
            self.set_size(iconw + width, height)
            expand = 1
        else:
            self._get_child().set_config("visible", "false")
            #self._get_child().hide()
            self.set_size(iconw, iconh)
            expand = 0

        self._get_display().send_action(self.__ACTION_EXPAND, expand)
        

    def __set_icon(self, uri):

        uri = vfs.join(self.get_path(), uri)
        try:
            loader = gtk.gdk.PixbufLoader()
            fd = vfs.open(uri, "r")
            data = vfs.read_all(fd)
            fd.close()
            loader.write(data, len(data))
            loader.close()
            pbuf = loader.get_pixbuf()
            self.__icon.set_from_pixbuf(pbuf)
            
        except:
            pass



    def get_border_size(self):

        w, h = self.__icon.size_request()
        if (self.__show_state == _STATE_VISIBLE):
            return (w, 0, 0, 0)
        else:
            return (w, h, 0, 0)
        

    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        self.add(self._get_child())
        self._init_children()



    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "expanded"):
            self.__set_expanded(value)
            
        elif (key == "icon-uri"):
            self.__set_icon(value)

        elif (key == "on-expand"):
            self.set_action_call(self.__ACTION_EXPAND, value)
            
        else:
            ContainerTarget.set_config(self, key, value)



    def get_container_geometry(self):

        if (self._get_child()):
            x, y, w, h = self._get_child().get_geometry()
            iconw, iconh = self.__icon.size_request()
        else:
            x, y, w, h = self.get_geometry()

        return (x, y, w, h)
        


    def handle_action(self, action, px, py, path, args):

        ContainerTarget.handle_action(self, action, px, py, path[:], args)
        if (self.get_index() != -1): path.append(self.get_index())

        w, h = self.__icon.size_request()
        if (0 <= px <= w and 0 <= py <= h):
            if (action == self.ACTION_CLICK):
                if (self.__show_state == _STATE_VISIBLE):
                    self.__set_expanded(gtk.FALSE)
                else:
                    self.__set_expanded(gtk.TRUE)
            #end if
        #end if
