from utils.Observable import Observable

import gconf


#
# Configuration backend that uses GConf.
#
class GConfBackend(Observable):

    OBS_UPDATE = 0


    def __init__(self, path):

        self.__path = path
        self.__client = gconf.client_get_default()
        self.__client.add_dir(self.__path, gconf.CLIENT_PRELOAD_RECURSIVE)
        self.__client.notify_add(path, self.__on_notify)

        self.__handlers = {}



    #
    # Propagates configuration changes.
    #
    def __on_notify(self, client, cid, entry, err):

        path = entry.get_key()[len(self.__path) + 1:]
        path = path.split("/")
        value = entry.get_value()
        if (value):
            self.update_observer(self.OBS_UPDATE, path, value.get_string())



    #
    # Sets a configuration entry.
    #
    def set(self, *args):

        args = list(args)
        v = gconf.Value(gconf.VALUE_STRING)
        v.set_string(args[-1])
        path = "/".join([self.__path] + args[:-1])
        self.__client.set(path, v)



    #
    # Returns a configuration entry.
    #
    def get(self, *args):

        args = list(args)
        path = "/".join([self.__path] + args)
        v = self.__client.get(path)
        if (v):
            return v.get_string()
        else:
            return ""



    #
    # Removes the given folder from GConf.
    #
    def clear(self, *path):

        self.__client.unset(self.__path + "/" + "/".join(path))



    #
    # Returns a list of all directories at the given path.
    #
    def list(self, *args):

        args = list(args)
        path = "/".join([self.__path] + args)
        dirs = self.__client.all_dirs(path)
        entries = self.__client.all_entries(path)

        ret = []
        for d in dirs:
            ret.append(d[len(path) + 1:])

        for e in entries:
            ret.append(e.get_key()[len(path) + 1:])

        return ret
