/*!

\page gdcmanon Tool to anonymize a DICOM file.

\section synopsis SYNOPSIS

\verbatim
gdcmanon [options] file-in file-out
\endverbatim

\section description DESCRIPTION

The \b gdcmanon tool is an implementation of PS 3.15 / E.1 / Basic
 Application Level Confidentiality Profile
 (Implementation of E.1.1 De-identify & E.1.2 Re-identify)

\section parameters PARAMETERS

\verbatim
file-in   DICOM input filename

file-out  DICOM output filename
\endverbatim

\section options OPTIONS

\subsection params params
\verbatim
  -e --de-identify            De-identify DICOM (default)
  -d --re-identify            Re-identify DICOM
     --dumb                   Dumb mode anonymizer
\endverbatim

\subsection options options
\verbatim
  -i --input                  DICOM filename / directory
  -o --output                 DICOM filename / directory
     --root-uid               Root UID.
     --resources-path         Resources path.
  -k --key                    Path to RSA Private Key.
  -c --certificate            Path to Certificate.
\endverbatim

\subsection encryption_options encryption_options
\verbatim
     --des            DES.
     --des3           Triple DES.
     --aes128         AES 128.
     --aes192         AES 192.
     --aes256         AES 256.
\endverbatim

\subsection dumb_mode_options dumb_mode_options
\verbatim
     --empty   %d,%d           DICOM tag(s) to empty
     --remove  %d,%d           DICOM tag(s) to remove
     --replace %d,%d,%s        DICOM tag(s) to replace
\endverbatim

\subsection general_options general options
\verbatim
  -h   --help
         print this help text and exit

  -v   --version
         print version information and exit

  -V   --verbose
         verbose mode (warning+error).

  -W   --warning
         warning mode, print warning information

  -E   --error
         error mode, print error information

  -D   --debug
         debug mode, print debug information
\endverbatim

\subsection environment_variable environment variable
\verbatim
  GDCM_ROOT_UID Root UID
  GDCM_RESOURCES_PATH path pointing to resources files (Part3.xml, ...)
\endverbatim

\section usage Typical usage
\subsection de-identification (anonymization, encrypt)

\verbatim
$ gdcmanon --certificate certificate.pem -e original.dcm original_anonymized.dcm
\endverbatim

\subsection re-identification (de-anonymization,decrypt)

\verbatim
$ gdcmanon --key privatekey.pem -d original_anonymized.dcm original_copy.dcm
\endverbatim

You can then check that original.dcm and original_copy.dcm are identical.

\subsection dumb mode
This functionality is not describe in the DICOM standard. Users are advised that improper use
of that mode is not recommended, meaning that important tag can be empty/remove/replace resulting
in illegal/invalid DICOM file.
Only use when you know what you are doing.

\verbatim
$ gdcmanon --dumb --empty 10,10 --empty 10,20 --remove 10,40 --remove 10,1010 --replace 10,1030,10 012345.002.050.dcm out.dcm
\endverbatim

\section see_also SEE ALSO

<b>gdcmconv</b>(1), <b>gdcminfo</b>(1)

\section copyright COPYRIGHT

Copyright (c) 2006-2009 Mathieu Malaterre

*/
