/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;
import org.apache.xerces.impl.validation.ValidationContext;

public class MonthDV
extends AbstractDateTimeDV {
    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string, null);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "gMonth"});
        }
    }

    protected int[] parse(String string, int[] nArray) throws SchemaDateTimeException {
        this.resetBuffer(string);
        if (nArray == null) {
            nArray = new int[8];
        }
        this.resetDateObj(nArray);
        nArray[0] = 2001;
        nArray[2] = 15;
        if (this.fBuffer.charAt(0) != '-' || this.fBuffer.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + string);
        }
        int n = this.fStart + 4;
        nArray[1] = this.parseInt(this.fStart + 2, n);
        if (this.fBuffer.charAt(n++) != '-' || this.fBuffer.charAt(n) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonth: " + string);
        }
        if (6 < this.fEnd) {
            int n2 = this.findUTCSign(6, this.fEnd);
            if (n2 < 0) {
                throw new SchemaDateTimeException("Error in month parsing: " + string);
            }
            this.getTimeZone(nArray, n2);
        }
        this.validateDateTime(nArray);
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray);
        }
        return nArray;
    }

    protected short compareDates(int[] nArray, int[] nArray2) {
        if (nArray[7] == nArray2[7]) {
            return nArray[1] >= nArray2[1] ? (nArray[1] > nArray2[1] ? (short)1 : 0) : (short)-1;
        }
        if (nArray[7] == 90 || nArray2[7] == 90) {
            if (nArray[1] == nArray2[1]) {
                return 2;
            }
            if (nArray[1] + 1 == nArray2[1] || nArray[1] - 1 == nArray2[1]) {
                return 2;
            }
        }
        if (nArray[1] < nArray2[1]) {
            return -1;
        }
        return 1;
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append(nArray[1]);
        this.message.append('-');
        this.message.append('-');
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }
}

