/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ErrorListener;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class Container
extends Element
implements BeanContext {
    protected final BeanContextSupport bcs = new BeanContextSupport(this);
    protected Collection elements;
    static /* synthetic */ Class class$0;

    protected Container() {
        this.bccs = this.bcs;
        this.elements = this.createElements();
    }

    protected abstract Collection createElements();

    public int size() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).size();
        }
        return this.elements.size();
    }

    public boolean isEmpty() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).isEmpty();
        }
        return this.elements.isEmpty();
    }

    public boolean contains(Object o) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).contains(o);
        }
        return this.elements.contains(o);
    }

    public Iterator iterator() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).iterator();
        }
        return this.elements.iterator();
    }

    public Object[] toArray() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).toArray();
        }
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] a) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).toArray(a);
        }
        return this.elements.toArray(a);
    }

    public boolean add(Object o) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).add(o);
        }
        if (o == null) {
            throw new IllegalArgumentException();
        }
        if (!(o instanceof Element)) {
            throw new ClassCastException();
        }
        try {
            ((Element)o).setBeanContext(this);
        }
        catch (PropertyVetoException pve) {
            throw new IllegalArgumentException(pve.getLocalizedMessage());
        }
        boolean wasAdded = this.elements.add(o);
        return wasAdded;
    }

    public boolean remove(Object o) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).remove(o);
        }
        return this.elements.remove(o);
    }

    public boolean containsAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).containsAll(c);
        }
        return this.elements.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).addAll(c);
        }
        return this.elements.addAll(c);
    }

    public boolean removeAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).removeAll(c);
        }
        return this.elements.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).retainAll(c);
        }
        return this.elements.retainAll(c);
    }

    public void clear() {
        if (this.isAlias()) {
            ((Container)this.getReal()).clear();
            return;
        }
        this.elements.clear();
    }

    public void addBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (this.isAlias()) {
            ((Container)this.getReal()).addBeanContextMembershipListener(bcml);
            return;
        }
        this.bcs.addBeanContextMembershipListener(bcml);
    }

    public URL getResource(String name, BeanContextChild bcc) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getResource(name, bcc);
        }
        return this.bcs.getResource(name, bcc);
    }

    public InputStream getResourceAsStream(String name, BeanContextChild bcc) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getResourceAsStream(name, bcc);
        }
        return this.bcs.getResourceAsStream(name, bcc);
    }

    public Object instantiateChild(String beanName) throws ClassNotFoundException, IOException {
        if (this.isAlias()) {
            return ((Container)this.getReal()).instantiateChild(beanName);
        }
        return this.bcs.instantiateChild(beanName);
    }

    public void removeBeanContextMembershipListener(BeanContextMembershipListener bcml) {
        if (this.isAlias()) {
            ((Container)this.getReal()).removeBeanContextMembershipListener(bcml);
            return;
        }
        this.bcs.removeBeanContextMembershipListener(bcml);
    }

    public void setDesignTime(boolean designTime) {
        if (this.isAlias()) {
            ((Container)this.getReal()).setDesignTime(designTime);
            return;
        }
        this.bcs.setDesignTime(designTime);
    }

    public boolean isDesignTime() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).isDesignTime();
        }
        return this.bcs.isDesignTime();
    }

    public boolean needsGui() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).needsGui();
        }
        return this.bcs.needsGui();
    }

    public void dontUseGui() {
        if (this.isAlias()) {
            ((Container)this.getReal()).dontUseGui();
            return;
        }
        this.bcs.dontUseGui();
    }

    public void okToUseGui() {
        if (this.isAlias()) {
            ((Container)this.getReal()).okToUseGui();
            return;
        }
        this.bcs.okToUseGui();
    }

    public boolean avoidingGui() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).avoidingGui();
        }
        return this.bcs.avoidingGui();
    }

    protected Model resolveModelName(String name) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).resolveModelName(name);
        }
        BeanContext bc = this.getBeanContext();
        if (bc instanceof Container) {
            return ((Container)bc).resolveModelName(name);
        }
        return null;
    }

    public Element getElement(Class klass, String name) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getElement(klass, name);
        }
        if (name == null) {
            return null;
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!klass.isAssignableFrom(e.getClass()) || !name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public Element getRealElement(Class klass, String name) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getRealElement(klass, name);
        }
        Element ele = this.getElement(klass, name);
        if (ele != null) {
            ele = ele.getReal();
        }
        return ele;
    }

    public final Container getContainerOrSame(Class klass) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getContainerOrSame(klass);
        }
        if (klass.isAssignableFrom(this.getClass())) {
            return this;
        }
        return this.getContainer(klass);
    }

    public final boolean containsIndirectly(Element elt) {
        if (this.isAlias()) {
            return ((Container)this.getReal()).containsIndirectly(elt);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Container");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Container curContainer = elt.getContainer(clazz);
        while (curContainer != null) {
            if (curContainer == this) {
                return true;
            }
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("ch.interlis.ili2c.metamodel.Container");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            curContainer = curContainer.getContainer(clazz2);
        }
        return false;
    }

    public Set getIndirectElements() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getIndirectElements();
        }
        HashSet result = new HashSet();
        this.getIndirectElements_helper(result);
        return result;
    }

    private final void getIndirectElements_helper(Set s) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Element)) continue;
            s.add(obj);
            if (!(obj instanceof Container)) continue;
            ((Container)obj).getIndirectElements_helper(s);
        }
    }

    public Viewable getRHSNameSpace() {
        if (this.isAlias()) {
            return ((Container)this.getReal()).getRHSNameSpace();
        }
        Container c = this.getContainer();
        if (c == null) {
            return null;
        }
        return c.getRHSNameSpace();
    }

    public void checkIntegrity() throws IllegalStateException {
        if (this.isAlias()) {
            ((Container)this.getReal()).checkIntegrity();
            return;
        }
        super.checkIntegrity();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Element)) continue;
            ((Element)obj).checkIntegrity();
        }
    }

    public boolean checkStructuralEquivalence(Element with, ErrorListener listener) {
        int withSize;
        if (this.isAlias()) {
            return ((Container)this.getReal()).checkStructuralEquivalence(with, listener);
        }
        if (!super.checkStructuralEquivalence(with, listener)) {
            return false;
        }
        int mySize = this.size();
        if (mySize != (withSize = ((Container)with).size())) {
            listener.error(new ErrorListener.ErrorEvent(Element.formatMessage("err_diff_unequalNumberOfElts", this.toString(), Integer.toString(mySize), with.toString(), Integer.toString(withSize)), this, 5));
            return false;
        }
        Iterator myIter = this.iterator();
        Iterator otherIter = ((Container)with).iterator();
        boolean allFine = true;
        while (myIter.hasNext() && otherIter.hasNext()) {
            Element curMy = (Element)myIter.next();
            Element curOther = (Element)otherIter.next();
            if (curMy == null || curMy.checkStructuralEquivalence(curOther, listener)) continue;
            allFine = false;
        }
        return allFine;
    }
}

