/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import ch.ehi.basics.i18n.MessageFormat;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.view.GenericFileFilter;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileChooser
extends JFileChooser {
    static java.util.ResourceBundle rsrc;
    private boolean isOutputDirDialog = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ehi.basics.view.FileChooser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rsrc = ResourceBundle.getBundle(clazz);
    }

    public FileChooser() {
    }

    public FileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public FileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
    }

    public FileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public FileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public FileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
    }

    public void approveSelection() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        FileFilter filter = this.getFileFilter();
        if (filter instanceof GenericFileFilter && GenericFileFilter.getFileExtension(selectedFile) == null) {
            selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + "." + ((GenericFileFilter)filter).getExtension());
            this.setSelectedFile(selectedFile);
        }
        if (this.getDialogType() == 0) {
            if (!selectedFile.isFile()) {
                JOptionPane.showMessageDialog(this, rsrc.getString("CTfiledoesntexist"), this.getDialogTitle(), 0);
                return;
            }
        } else if (this.getDialogType() == 1) {
            if (selectedFile.exists()) {
                if (!selectedFile.canWrite()) {
                    JOptionPane.showMessageDialog(this, rsrc.getString("CTfileisntwriteable"), this.getDialogTitle(), 0);
                    return;
                }
                int response = JOptionPane.showConfirmDialog(this, rsrc.getString("CTfileexists"), this.getDialogTitle(), 1, 3);
                if (response == -1 || response == 2) {
                    this.cancelSelection();
                    return;
                }
                if (response != 0) {
                    return;
                }
            }
        } else if (this.isOutputDirDialog && selectedFile.exists()) {
            if (!selectedFile.canWrite()) {
                JOptionPane.showMessageDialog(this, rsrc.getString("CTdirisntwriteable"), this.getDialogTitle(), 0);
                return;
            }
            int response = JOptionPane.showConfirmDialog(this, MessageFormat.format(rsrc, "CTdirexists", selectedFile.getAbsolutePath()), this.getDialogTitle(), 1, 3);
            if (response == -1 || response == 2) {
                this.cancelSelection();
                return;
            }
            if (response != 0) {
                return;
            }
        }
        super.approveSelection();
    }

    public int showOutputDirDialog(Component parent) {
        this.setFileSelectionMode(1);
        this.setFileFilter(new GenericFileFilter(rsrc.getString("CTdirectories"), ""));
        this.setDialogTitle(rsrc.getString("CToutputDirTitle"));
        this.isOutputDirDialog = true;
        int ret = 1;
        try {
            ret = this.showDialog(parent, rsrc.getString("CTdirectoryApproveButton"));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.isOutputDirDialog = false;
            throw throwable;
        }
        Object var3_5 = null;
        this.isOutputDirDialog = false;
        return ret;
    }

    public int showInputDirDialog(Component parent) {
        this.setFileSelectionMode(1);
        this.setFileFilter(new GenericFileFilter(rsrc.getString("CTdirectories"), ""));
        this.setDialogTitle(rsrc.getString("CTinputDirTitle"));
        return this.showDialog(parent, rsrc.getString("CTdirectoryApproveButton"));
    }
}

