package GCPlugins::GCgames::GCJeuxVideoFr;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCgames::GCgamesCommon;

{
    package GCPlugins::GCgames::GCPluginJeuxVideoFr;

    use base 'GCPlugins::GCgames::GCgamesPluginsBase';

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
        if ($self->{parsingList})
        {
            if ($tagname eq 'tr')
            {
                $self->{isGame} = 1
                    if $attr->{class} =~ /listel[1-2]/;
            }
            if ($self->{isGame})
            {
                if ($tagname eq 'img')
                {
                    if ($attr->{src} =~ m|/style/img/supv.*?([a-z0-9]*)\.gif|)
                    {
                        $self->{itemIdx}++;
                        $self->{itemsList}[$self->{itemIdx}]->{platform} = uc $1;
                    }
                }
                elsif ($tagname eq 'a')
                {
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href}
                        if $self->{isName};
                }
                elsif ($tagname eq 'td')
                {
                    $self->{isName} = 1 if $attr->{class} eq 'titre';
                    $self->{isDate} = 1 if $attr->{class} eq 'datesortie';
                    $self->{isGenre} = 1 if $attr->{class} eq 'genre';
                }
            }
        }
        elsif ($self->{parsingTips})
        {
            if (
                (($tagname eq 'h2') && ($attr->{class} eq 'simple'))
                ||
                (($tagname eq 'div') && ($attr->{class} eq 'desc'))
               )
            {
                $self->{isTip} = 1;
            }
            
        }
        else
        {
           if ($attr->{id} eq 'fiche_technique_jeu')
            {
                $self->{isInfo} = 1;
                $self->{is} = '';
            }
            elsif (($self->{isInfo} eq '1') && ($tagname eq 'th'))
            {
                $self->{isInfo} = 2;
            }
            elsif ($attr->{id} eq 'wid_sortie')
            {
                $self->{is} = 'released';
            }
            elsif ($attr->{class} eq 'titre_page')
            {
                $self->{is} = 'name';
            }
            elsif ($attr->{class} eq 'cf_pochette ombre')
            {
                $self->{curInfo}->{boxpic} = $attr->{src}
                    if $attr->{src} =~ /^http/;
            }
            elsif ($attr->{class} eq 'thickbox')
            {
                $attr->{href} =~ /.*?id=([0-9]*)/;
                $self->{curInfo}->{screenshot2} = $attr->{href} if !$self->{curInfo}->{screenshot2}
                                                         &&  $self->{curInfo}->{screenshot1};
                $self->{curInfo}->{screenshot1} = $attr->{href} if !$self->{curInfo}->{screenshot1};
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
        if ($self->{parsingList})
        {
            $self->{isGame} = 0
                if ($tagname eq 'tr');
        }
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isName})
            {
                $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                $self->{isName} = 0;
            }
            elsif ($self->{isDate})
            {
                $self->{itemsList}[$self->{itemIdx}]->{released} = $origtext;
                $self->{isDate} = 0;
            }
            elsif ($self->{isGenre})
            {
                $self->{itemsList}[$self->{itemIdx}]->{genre} = $origtext;
                $self->{isGenre} = 0;
            }
        }
        elsif ($self->{parsingTips})
        {
            if ($self->{isTip})
            {
                $self->{curInfo}->{secrets} .= "\n\n" if $self->{curInfo}->{secrets};
                $self->{curInfo}->{secrets} .= $origtext;
                $self->{isTip} = 0;
            }
        }
        else
        {
            if ($self->{isInfo} eq 2)
            {
                $self->{is} = 'platform' if $origtext =~ /Plateforme/;
                $self->{is} = 'genre' if $origtext =~ /Genre/;
                $self->{is} = 'editor' if $origtext =~ /Editeur/;
                $self->{is} = 'developer' if $origtext =~ /D.veloppeur/;
                $self->{is} = 'players' if $origtext =~ /Type de jeu/;
                $self->{isInfo} = 1;
            }
            elsif (($self->{is}) && ($origtext))
            {
                $origtext =~ s/^\s*//;
                if ($origtext)
                {
                   if ($self->{is} eq 'players')
                   {
                       $origtext =~ s/Exclusivement Solo/1/;
                       $origtext =~ s/\s*joueurs?//i;
                   }

                   $self->{curInfo}->{$self->{is}} = $origtext;
                   $self->{is} = '';
                }
            }
        }
    } 

    sub getTipsUrl
    {
        my $self = shift;
        
        my $url = $self->{curInfo}->{$self->{urlField}};
        $url =~ s/fiche-/astuce-/;
        return $url;
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            name => 1,
            platform => 1,
            released => 1,
            genre => 1
        };

        $self->{isName} = 0;
        $self->{isGame} = 0;
        $self->{isDate} = 0;
        $self->{isGenre} = 0;
        $self->{isInfo} = 0;
        $self->{isTip} = 0;
        $self->{is} = '';

        $self->{key} = {
                        b => 'Bas',
                        h => 'Haut',
                        g => 'Gauche',
                        d => 'Droite'
                       };

        return $self;
    }

    sub toKey
    {
        my ($self, $value) = @_;
        
        if (length($value) <= 2)
        {
            $value = substr($value, 0, 1);
        }
        elsif ($value =~ /_/)
        {
            $value =~ s/(.)_(.)/$self->{key}->{$1}.'-'.$self->{key}->{$2}/ge;
        }
        else
        {
            $value = ucfirst $value;            
        }
        
        return $value;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $html =~ s|<br />|, |;
        }
        elsif ($self->{parsingTips})
        {
            $html =~ s|<b>(.*?)</b>|$1|gi;
            $html =~ s|<img src='http://www\.jeuxvideo\.fr/style/img/man/bt_([a-z_]*)\.gif' align='absmiddle'>|$self->toKey($1)|ge;
            $html =~ s|\x{92}|'|gi;
            $html =~ s|\x{8C}|OE|gi;
            $html =~ s|\x{9C}|oe|gi;
        }

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return 'http://www.jeuxvideo.fr/encyclopedie-jeux-video-ds-gba-gc-pc-ps2-psp-xbox-xbox360-ps3-rev---g0g-0-0-0.html?recherche='.$word;
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.jeuxvideo.fr' . $url;
    }

    sub getName
    {
        return 'jeuxvideo.fr';
    }
    
    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'FR';
    }

    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }
}

1;
