package GCPlugins::GCfilms::GCAmazon;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCfilms::GCfilmsAmazonCommon;

{
    package GCPlugins::GCfilms::GCPluginAmazon;

    use base qw(GCPlugins::GCfilms::GCfilmsAmazonPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;	
        $self->{inside}->{$tagname}++;
        if ($self->{parsingEnded})
        {
            if ($self->{itemIdx} < 0)
            {
                $self->{itemIdx} = 0;
                $self->{itemsList}[0]->{url} = $self->{loadedUrl};
            }
            return;
        }

        if ($self->{parsingList})
        {
            if ($tagname eq 'input')
            {
                $self->{beginParsing} = 1
                    if $attr->{src} =~ /go-button-search/;
            }
            return if ! $self->{beginParsing};
            if ($tagname eq "a")
            {
                my $urlId;
                if ($urlId = $self->isItemUrl($attr->{href}))
#                if ($attr->{href} =~ m|/dp/[A-Z0-9]*/sr=([0-3]-[0-9]*)/qid=[0-9]*|)
                {
                    return if $self->{alreadyRetrieved}->{$urlId};
                    $self->{alreadyRetrieved}->{$urlId} = 1;
                    my $url = $attr->{href}; 
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
            elsif ($tagname eq 'div')
            {
                $self->{inside}->{actors} = 2 if $attr->{class} eq 'binding';
                $self->{inside}->{srtitle} = 2 if $attr->{class} eq 'productTitle';
            }
            
        }
        else
        {
            if ($tagname eq "img")
            {
                if ($self->{insideAge})
                {
                    $self->{curInfo}->{age} = 18 if ($attr->{alt} eq 'R') || ($attr->{src} =~ m|G/01/detail/r|);
                    $self->{curInfo}->{age} = 13 if ($attr->{alt} =~ /PG\-13/) || ($attr->{src} =~ m|G/01/detail/pg-13|);
                    $self->{curInfo}->{age} = 5 if ($attr->{alt} eq 'PG') || ($attr->{src} =~ m|G/01/detail/pg\.|);
                    $self->{curInfo}->{age} = 2 if ($attr->{alt} eq 'G') || ($attr->{src} =~ m|G/01/detail/g|);
                    $self->{insideAge} = 0;
                }
                if (!$self->{curInfo}->{image})
                {
                    $self->{curInfo}->{image} = $self->extractImage($attr);
                }
            }
            elsif ($tagname eq "b")
            {
            	$self->{insideNameAndDate} = 1 if $attr->{class} eq "asinTitle";
            }
        }
    }

    sub end
    {
        my ($self, $tagname) = @_;
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
        return if ($self->{parsingEnded});

        if ($self->{parsingList})
        {
            if (
                (($self->{inside}->{b})
                || ($self->{inside}->{span}))            
             && ($origtext =~ /Sort by/))
            {
                $self->{beginParsing} = 1;
                return;
            }
            return if ! $self->{beginParsing};
            if ($self->{inside}->{actors})
            {
                $self->{itemsList}[$self->{itemIdx}]->{actors} = $origtext
                    if ! $self->{itemsList}[$self->{itemIdx}]->{actors};
                $self->{inside}->{actors} = 0 if $self->{inside}->{actors} == 2;
                return;
            }
            elsif ($self->{inside}->{srtitle})
            {
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{inside}->{srtitle} = 0 if $self->{inside}->{srtitle} == 2;
                return;
            }
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;

            if ($self->{insideNameAndDate})
            {
                if ($origtext =~ m/(.*) \(([0-9]{4})\)/)
                {
                    $self->{curInfo}->{title} = $1;
                    $self->{curInfo}->{date} = $2;
                }
                $self->{insideNameAndDate} = 0;
            }
            elsif ($self->{insideActors})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $origtext =~ s/\s+,/,/;
                $self->{curInfo}->{actors} = $origtext;
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{director} = $origtext;
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideTime})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/\n//g;
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideActors} = 1 if $origtext =~ /(Starring|Actors):/;
                $self->{insideDirector} = 1 if $origtext =~ /Directors?:/;
                $self->{insideTime} = 1 if $origtext =~ /Run Time:/;
                $self->{insideAge} = 1 if $origtext =~ /Rating/;
                $self->{insideSynopsis} = 1 if $origtext =~ /Plot Synopsis/;
            }        
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 0,
            director => 0,
            actors => 1,
        };

        $self->{suffix} = 'com';

        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html = $self->SUPER::preProcess($html);
        if ($self->{parsingList})
        {
            $html =~ s|^\s+~(.*)$|<actors>$1</actors>|gm;
        }
        else
        {
            $html =~ s/(<i>|<\/i>)//gim;
            $html =~ s/<p>/\n/gim;
            $html =~ s|</p>|\n|gim;
            $html =~ s/(<ul>|<\/ul>)/\n/gim;
            $html =~ s/<li>([^<])/- $1/gim;
            $html =~ s|([^>])</li>|$1\n|gim;
            $html =~ s|<br ?/?>|\n|gi;
            $html =~ s|<a href="/gp/imdb/[^"]*">(.*?)</a>|$1|gm;
            $html =~ s|<a href="[^"]*search-alias=dvd&field-keywords=[^"]*">(.*?)</a>|$1|gm;
            #"
        }

        $self->{parsingEnded} = 0;
        $self->{alreadyRetrieved} = {};
        $self->{beginParsing} = 0;

        return $html;
    }

    sub getName
    {
        return "Amazon (US)";
    }
    
    sub getLang
    {
        return 'EN';
    }

}

1;
