package GCModule::GCModuleFirst;

###################################################
#
#  Copyright 2005-2007 Dtek
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
#use warnings;
	
	
{

    package GCModule::GCModFirst;
	use File::Basename;

    
    sub new 
    {
        my ($proto) = @_;
        my $class = ref($proto) || $proto;

        ( my $moduleName = $class ) =~ s/:GCMod/:GCModule/;

        my $self = {moduleName => $moduleName};
        bless( $self, $class );
        return $self;
    }

    sub launch 
    {

        my $self = shift;
        my $dialog = GCLookForItems->new( $self->{parent}, $self->{langContainer} );
        $dialog->show;

    }

    sub load 
    {
        
        my ( $self, $parent ) = @_;
        $self->{parent} = $parent;
		my $model = $self->{parent}->{model}->getName;
		
		
		
        # if the model is supported
        # we Add menu item to access to the module
        if ( ( $model eq 'GCfilms' ) or ( $model eq 'GCmusics' ) ) 
        {
            my $name = $self->getLang->{Name};
            my $item = Gtk2::MenuItem->new_with_mnemonic($name);
            $item->signal_connect(
                'activate' => sub {
                    $self->launch;
                }
            );

            $self->{parent}->{menubar}->{menuFile}->insert( $item, 12 );
            $self->{parent}->{menubar}->{menuFile}->show_all;
            
            
            #Adding the OpenFolderToolButton
            #if there is some config file for the toolbar
            if ( -f $self->{parent}->{toolbar}->{configFile})
			{
				open CONFIG, $self->{parent}->{toolbar}->{configFile};
				my $i=1;
				#we locate the place of the play button
				foreach (<CONFIG>)
				{
					chomp;
					#if the play button is found, then we had the open folder button to the left of it
					if ($_ eq 'gtk-media-play')
					{
						my $ToolButton = Gtk2::ToolButton->new_from_stock('gtk-directory');
            			$ToolButton->set_label($self->{langContainer}->{OpenFolder});
						$self->{parent}->{tooltips}->set_tip($ToolButton, $self->{langContainer}->{OpenFolderTip}, '');
						$ToolButton->signal_connect('clicked' => sub {$self->openFolder});
						$self->{parent}->{toolbar}->insert($ToolButton,$i);
						$self->{parent}->{toolbar}->show_all;
						
						last;
					}
					$i++;
				}
				close CONFIG;
			}
        
        
        	
            
            
            
            
            #Modify subroutine GCFrame::playItem to use Aliases
			*GCFrame::playItem = sub {$self->playItem;};
			
			
			
			@{$self->{dirs}} =
			  map( { [ split( /\%/, $_ ) ] }
				split( /\|/, $self->{parent}->{options}->directories ) );
			
					
        
        }

		
		

    }
	
    sub getLang 
    {
        my $self = shift;

        if ( !$self->{langContainer} ) 
        {
            my $langFile = $self->{moduleName};
            my %tmpLang;
            eval "use GCLang::".$self->{parent}->{options}->lang."::$langFile\n";
            eval "%tmpLang = %GCLang::".$self->{parent}->{options}->lang."::".$langFile."::lang";
            $self->{langContainer} = \%tmpLang;
        }
        return $self->{langContainer};
    }

	sub openFolder
	{
		my $self = shift;
        my $field = $self->{parent}->{model}->{commonFields}->{play};
        my $dir = dirname($self->{parent}->{panel}->$field);
        foreach ( @{ $self->{dirs} } ) 
        {
			my $alias = $_->[1];
			if ($alias and $dir =~ m/^$alias/ ) 
			{
				
				$dir =~ s/^$alias/$_->[0]/;
				last;
			}
         }
        $self->{parent}->launch($dir, 'system');
		
	}
	sub playItem 
	{
		
		my $self = shift;
        my $field = $self->{parent}->{model}->{commonFields}->{play};
        my $format = $self->{parent}->{model}->{fieldsInfo}->{$field}->{format};
        my $file = $self->{parent}->{panel}->$field;
        
        foreach ( @{ $self->{dirs} } ) 
        {
			my $alias = $_->[1];
			if ($alias and $file =~ m/^$alias/ ) 
			{
				
				$file =~ s/^$alias/$_->[0]/;
				last;
			}
         }
        $self->{parent}->launch($file, $format);
		
		
	}
}

{

    package GCLookForItems;
    use base 'GCModalDialog';
	use File::Basename;
	use Unicode::Normalize;
	use Encode;
	use Encode::Guess qw/euc-jp shiftjis 7bit-jis/;
  	
	
	
    sub initValues 
    {
        use locale;


		
        my $self = shift;
		
		
		
		#get the directories config and split it in a table originaly separated by "%" and "|"
        my @directories =
          map( { [ split( /\%/, $_ ) ] }
            split( /\|/, $self->{options}->directories ) );

        $self->activateOkButton( scalar(@directories) );

        #get the plugins list
        my @valuesList;
        foreach ( @{ $self->{model}->getPluginsNames } ) 
        {
            my $pluginName =
              $GCPlugins::pluginsMap{ $self->{model}->getName }->{$_}->getName;
            push( @valuesList,
                { value => $pluginName, displayed => $pluginName } );
        }

        $self->{pluginsList}->setValues( \@valuesList );

        if ( $self->{options}->plugin ) 
        {
            $self->{pluginsList}->setValue( $self->{options}->plugin );
        }
        else 
        {
            $self->{pluginsList}
              ->setValue( $self->{model}->{preferences}->plugin );
        }

        @{ $self->{directories}->{data} } = @directories;

        $self->{suffixes}->set_text( $self->{options}->suffixes );
        $self->{remove}->set_text( $self->{options}->remove );
        $self->{checkDel}->set_active( $self->{options}->checkDel );
        $self->{checkGetInfo}->set_active( $self->{options}->checkGetInfo );
        $self->{checkGetFirst}->set_active( $self->{options}->checkGetFirst );

        $self->checkClicked;

    }

    sub saveValues 
    {

        my $self = shift;

        @{ $self->{dirs} } = @{ $self->{directories}->{data} };

        $self->{suf} = $self->{suffixes}->get_text;
        $self->{suf} =~ s/\W$//;
        $self->{suf} =~ s/^\W//;
        $self->{suf} =~ s/[^\w ]//g;

        $self->{remove} = $self->{remove}->get_text;
        $self->{remove} =~ s/\W$//;
        $self->{remove} =~ s/^\W//;
        $self->{remove} =~ s/[^\w ]//g;

        $self->{del}     = $self->{checkDel}->get_active;
        $self->{getInfo} = $self->{checkGetInfo}->get_active;
        $self->{first}   = $self->{checkGetFirst}->get_active;

        $self->{plugin} = $self->{pluginsList}->getValue;

        $self->{options}->directories(
            join( "|", map( { join( "%", @{$_} ) } @{ $self->{dirs} } ) ) );
        $self->{options}->suffixes( $self->{suf} );
        $self->{options}->remove( $self->{remove} );
        $self->{options}->plugin( $self->{plugin} );
        $self->{options}->checkDel( $self->{del} );
        $self->{options}->checkGetInfo( $self->{getInfo} );
        $self->{options}->checkGetFirst( $self->{first} );
        $self->{options}->save;

    }

    sub show 
    {
        my $self = shift;

        $self->initValues;

        $self->SUPER::show();
        $self->show_all;

        if ( $self->run eq 'ok' ) 
        {
            $self->saveValues;
            $self->hide;
            $self->process;
        }
        else 
        {
            $self->hide;
        }
    }

    sub process 
    {
        my ($self) = @_;



		$self->{parent}->{items}->updateCurrent;

		#print $options->{parent}->{items}->getNbItems."\n";

		$self->{parent}->setWaitCursor($self->{langModule}->{Wait});

		#get the list of all the existing files
		my $fieldFile = $self->{model}->{commonFields}->{play};
		@{ $self->{listDirs} } = map ( { $_->{$fieldFile} } @{ $self->{parent}->{items}->getItemsList } );

		#Put suffixes in a good way
		$self->{suf} =~ s/ /\$\|\./g;
		$self->{suf} = '.'. $self->{suf}.'$';


		
		@{ $self->{filesList} } = ();

		#for every directories set
		foreach ( @{ $self->{dirs} } ) 
		{

			#if the directory still exist
			if ( -e $_->[0] ) 
			{

				$self->{curDir} = $_;

				#We add the result of a recursive scan on it
				my $dir = $_->[0];
				$self->scan($dir);

			}
		}
		
		
		if ( scalar @{ $self->{filesList} } > 0 ) 
		{
			foreach (@{$self->getItemArray})
			{
				$self->{parent}->{items}->addItem($_, 0, 1);
			}
		}
		else 
		{
			$self->infoDialog( $self->{langModule}->{Uptodate} );
		}

		$self->{parent}->{items}->unselect;
		$self->{parent}->restoreCursor;
		$self->{parent}->checkPanelVisibility;
		$self->{parent}->selectFirst;
		$self->{parent}->markAsUpdated;
		$self->{parent}->allItems;

        

    }

    sub scan 
    {
        my ( $self, $dir ) = @_;
        #Get all the files in the directorie
		opendir REP, "$dir" or die "impossible to open $dir";
		my @files = readdir REP;
		closedir REP;
		
        #For each files
        foreach (@files) 
        {
			#if it's not a special file
			if( $_ ne '.' and $_ ne '..')
			{
				#if it's a directory
				if ( -d $dir.'/'.$_ ) 
				{
					#Do scan if recursive set
					$self->scan($dir.'/'.$_) if ( $self->{curDir}->[2] );
				}
				#else it's a file !
				else 
				{
					#so we check if we had it !
					$self->check($dir.'/'.$_);
				}
			}
        }

    }

    sub check 
    {
        my ( $self, $file ) = @_;

        #if the file got an extension who match
        if ( $file =~ m/$self->{suf}/ ) 
        {

			#encode file name into utf8
			$file = decode("Guess", $file);
			#Get filename with alias.
			my $fileAlias = $file;
			foreach ( @{ $self->{dirs} } ) 
			{
                #if the file is in the current directory
                if ( $file =~ m/^$_->[0]/ ) 
                {
					my $alias = $_->[1];
					#if we want to use an alias, we use it
                    if ($alias) 
                    {
                        my $dir = quotemeta( $_->[0] );
                        $fileAlias =~ s/^$dir/$alias/;
                    }
                    last;
                }
            }
            
            
            #if the file is not referenced in the database already
            if ( scalar( grep { $_ eq $fileAlias } @{ $self->{listDirs} } ) == 0 ) 
            {
				#We add the file to the list in order to be added later
				push( @{ $self->{filesList} }, [$file,$fileAlias] );
            }
			
        }

    }

    # Required by extracter to make this class acts as a panel
    sub AUTOLOAD 
    {
        return [];
    }

	# Return an array with all the new items
    sub getItemArray 
    {
        my $self = shift;
        my @result;
		
	
        #First we try to get the correct plugin
        my $plugin =
          $GCPlugins::pluginsMap{ $self->{model}->getName }
          ->{ $self->{plugin} };
        $plugin->{bigPics} = $self->{parent}->{options}->bigPics;
        my $titleField = $self->{model}->{commonFields}->{title};
        my $fileField  = $self->{model}->{commonFields}->{play};

        
        my $resultsDialog;
        if ( !$self->{first} ) 
        {
            $resultsDialog = $self->{parent}->getDialog('Results');
            $resultsDialog->setModel( $self->{model},
                $self->{model}->{fieldsInfo} );
            $resultsDialog->setMultipleSelection(0);
        }

        ( my $remove = $self->{remove} ) =~ s/ /\|/g;

        foreach ( @{ $self->{filesList} } ) 
        {
            
            my ($file,$fileAlias) = @{$_};
            my $extracter = $self->{model}->getExtracter( $self, $file, $self, $self->{model} );
            my $extracted = $extracter->getInfo;
		
			my $name = basename($fileAlias);
			
					
			
			# Filter the name
            # Remove suffix
            $name =~ s/\.[^.]*$//;

            # Remove everything between () {} []
            $name =~ s/[\(\[\{].*?[\)\]\}]//g;

            # Remove special characters
            $name =~ s/[\._,#@"]/ /g;

            #'"
            # Remove info from extracter for movies
            if ( $self->{model}->getName eq 'GCfilms' ) 
            {

                my $info = $extracted->{video}->{value}.'|'.$extracted->{audio}->{value}->[0]->[1];
                $info =~ s/ (.*?)//g;
                $name =~ s/$info//g;
            }
			
			# Remove words to remove
            $name =~ s/$remove//gi;
			
			# Show which movie we analyse
			$self->{parent}->setWaitCursor($self->{lang}->{StatusSearch}.' ('.$name.')');
			
            #Initialize what will be pushed in the array
            my $info = { $titleField => $name };
			
            
            #if we take info from internet
            if ( $self->{getInfo} ) 
            {

				

                # $name contains the title to search
                $plugin->{title}    = $name;
                $plugin->{type}     = 'load';
                $plugin->{urlField} = $self->{model}->{commonFields}->{url};

                $plugin->load;

                my $itemNumber = $plugin->getItemsNumber;

                if ( $itemNumber != 0 ) 
                {
                    $plugin->{type} = 'info';
                    if ( ( $itemNumber == 1 ) || ( $self->{first} ) ) 
                    {
                        $plugin->{wantedIdx} = 0;
                    }
                    else 
                    {
                        my @items = $plugin->getItems;
                        $resultsDialog->setWithNext(0);
                        $resultsDialog->setSearchPlugin($plugin);
                        $resultsDialog->setList( $name, @items );
                        $resultsDialog->show;
                        if ( $resultsDialog->{validated} ) 
                        {
                            $plugin->{wantedIdx} =
                              $resultsDialog->getItemsIndexes->[0];
                        }
                    }
                    $info = $plugin->getItemInfo;
                    my $title = $info->{$titleField};
                    $self->{parent}->{defaultPictureSuffix} =
                      $plugin->getDefaultPictureSuffix;
                    foreach my $field ( @{ $self->{model}->{managedImages} } ) 
                    {
                        $info->{$field} = '' if $info->{$field} eq 'empty';
                        next if !$info->{$field};
                        ( $info->{$field} ) =
                          $self->{parent}
                          ->downloadPicture( $info->{$field}, $title );
                    }

                }
            }

            # Add the default value
            my $defaultInfo = $self->{model}->getInitInfo;
            foreach my $field ( keys %$defaultInfo ) 
            {
                next if exists $info->{$field};
                $info->{$field} = $defaultInfo->{$field};
            }

            # Add file path to the informations
            $info->{$fileField} = $fileAlias;
            

            foreach my $field ( keys %$extracted ) 
            {
                next if $field eq 'comment';
                
                if ($field eq 'time')
                {
					my $h=0;
					my $mn=$extracted->{$field}->{value};	
                	while($mn>=60)
                	{
                		$h++;
                		$mn -= 60;
					}
					$info->{$field} = "$h"."h $mn";
					
				}
				else
				{
                	$info->{$field} = $extracted->{$field}->{value};
				}
            }

            if ( $self->{parsingError} ) 
            {
                $self->{parent}->restoreCursor;
                return $self->getEndInfo;
            }

            push (@result, $info);
            

        }
		
		return \@result;
    }

    sub dialog 
    {
        my ( $self, $type, $message ) = @_;

        my $errorDialog =
          Gtk2::MessageDialog->new( $self, [qw/modal destroy-with-parent/],
            $type, 'ok', $message );

        $errorDialog->set_position('center-on-parent');
        $errorDialog->run();
        $errorDialog->hide();
        $errorDialog->destroy;

    }

    sub infoDialog 
    {
        my ( $self, $message ) = @_;
        $self->dialog( 'info', $message );
    }

    sub errorDialog 
    {
        my ( $self, $message ) = @_;
        $self->dialog( 'error', $message );

    }

    sub removeCurrent 
    {
        my $self = shift;
        my @idx  = $self->{directories}->get_selected_indices;

        if ( scalar @idx != 0 ) 
        {
            if ( $^O =~ /win32/i ) 
            {
                my @newData;
                my $i = 0;
                foreach ( @{ $self->{directories}->{data} } ) 
                {
                    push @newData, @{$_} if $i != $idx[0];
                    $i++;
                }
                @{ $self->{directories}->{data} } = @newData;
            }
            else 
            {
                splice @{ $self->{directories}->{data} }, $idx[0], 1;
            }
        }

        if ( scalar( @{ $self->{directories}->{data} } ) == 0 ) 
        {

            $self->activateOkButton(0);
        }
    }

    sub add 
    {

        my $self = shift;

        if ( $self->addModify(0) ) 
        {
            $self->activateOkButton(1);

            unshift @{ $self->{directories}->{data} },
              [
                $self->{directorie}->get_text, 
                $self->{alias}->get_text,
                $self->{recursive}->get_active
              ];
        }
        $self->{addModifyDialog}->destroy;

    }

    sub modify 
    {
        my $self = shift;
        my @idx  = $self->{directories}->get_selected_indices;

        #if there is just one line select, we ask for an alias
        if ( scalar @idx == 1 ) 
        {
            if ( $self->addModify(1) ) 
            {
                $self->{directories}->{data}->[ $idx[0] ] = [
																$self->{directorie}->get_text, 
																$self->{alias}->get_text,
																$self->{recursive}->get_active
															];
            }
            $self->{addModifyDialog}->destroy;
        }

    }

    sub addModify 
    {

        my ( $self, $modif ) = @_;
        my $dialog = new Gtk2::Dialog(
            $self->{langModule}->{AddModify},
            $self, [qw/modal destroy-with-parent/],
            @GCDialogs::okCancelButtons
        );

        $self->{addModifyDialog} = $dialog;



		my $table = new Gtk2::Table(3, 3);
        $table->set_row_spacings($GCUtils::halfMargin);
        $table->set_col_spacings($GCUtils::margin);
        $table->set_border_width($GCUtils::margin);
        
        




        my $labelDir = new Gtk2::Label( $self->{langModule}->{Directory} );
        $labelDir->set_alignment( 0, 0 );
        $self->{directorie} = new Gtk2::Entry;
        my $buttonDir = Gtk2::Button->new_from_stock('gtk-open');
        $buttonDir->signal_connect(
            'clicked' => sub {
                $self->open;
            }
        );
        
        $self->{recursive} = new Gtk2::CheckButton( $self->{langModule}->{Recursive} );

        
        my $labelAlias = new Gtk2::Label( $self->{langModule}->{Alias} );
        $labelAlias->set_alignment( 0, 0 );
        $self->{alias} = new Gtk2::Entry;
        $self->{alias}->signal_connect( 'activate' => sub { $dialog->response('ok') } );
        
        
					  #$left attach, $right attach,
                      #$top attach, $bottom attach, $xoptions,
                      #$yoptions, $xpadding, $ypadding ) ;

		$table->attach($labelDir, 0, 1, 0, 1, 'fill', 'fill', 0, 0);
        $table->attach($self->{directorie}, 1, 2, 0, 1, ['fill', 'expand'], 'fill', 0, 0);
        $table->attach($buttonDir, 2, 3, 0, 1, 'fill', 'fill', 0, 0);
        $table->attach($labelAlias, 0, 1, 1, 2, 'fill', 'fill', 0, 0);
        $table->attach($self->{alias}, 1, 3, 1, 2, ['fill', 'expand'], 'fill', 0, 0);
        $table->attach($self->{recursive}, 0, 3, 2, 3, 'fill', 'fill', 0, 0);
        



        $dialog->vbox->pack_start( $table, 1, 1, 0 );
        $dialog->vbox->show_all;

        if ($modif) 
        {

            my @id   = $self->{directories}->get_selected_indices;
            my @data = @{ $self->{directories}->{data}->[ $id[0] ] };

            $self->{directorie}->set_text( $data[0] );
            $self->{alias}->set_text( $data[1] );
            $self->{recursive}->set_active( $data[2] );

        }

        if ( $dialog->run eq 'ok' ) 
        {

			#if it's only alpha-numeric and underscore characters and a directories is set
            if (    $self->{alias}->get_text =~ m/^[\w_]*$/)
            {
				if($self->{directorie}->get_text)
				{
            	
					#We take off the last character if it's a non alphanumeric character
					my $dir = $self->{directorie}->get_text;
					$dir =~ s/\W$//;
					$self->{directorie}->set_text($dir);

					return 1;
                
				}
				else
				{
					$self->errorDialog( $self->{langModule}->{DirWarning} );
					
				}
            }
            else 
            {
                $self->errorDialog( $self->{langModule}->{AliasWarning} );
            }

        }

        return 0;

    }

    sub open 
    {
        my $self = shift;

        my $fileDialog =
          new GCFileChooserDialog( $self->{langModule}->{FileChooserOpenDirectory},
            $self, 'select-folder' );

        if ( $fileDialog->run eq 'ok' ) 
        {

            $self->{directorie}->set_text( $fileDialog->get_filename );
        }

        $fileDialog->hide();
        $fileDialog->destroy;

    }

    sub checkClicked 
    {
        my $self = shift;
        my $bool = $self->{checkGetInfo}->get_active;
        $self->{pluginsList}->set_sensitive($bool);
        $self->{checkGetFirst}->set_sensitive($bool);
        $self->{checkGetFirst}->set_active(0) if !$bool;

    }

    sub new 
    {
        my ( $proto, $parent, $lang ) = @_;
        my $class = ref($proto) || $proto;
        my $self = $class->SUPER::new( $parent, $lang->{Name}, );

        bless( $self, $class );

        #$self->set_modal(1);
        $self->set_position('center');
        $self->set_default_size( 400, 400 );

        $self->{parent}  = $parent;
        $self->{langModule}    = $lang;
        $self->{options} = $parent->{options};
        $self->{model}   = $parent->{model};
		# Required by extracter
        $self->{lang} = $parent->{lang};
        
        #########################"
        # Table part
        ########################

        my $directoriesFrame = new GCGroup( $lang->{Directories} );
        my $vbox             = new Gtk2::VBox( 0, 0 );
        my $hbox             = new Gtk2::HBox( 0, 0 );
        $directoriesFrame->addWidget($vbox);

        my $labelDir = new Gtk2::Label( $lang->{AliasLong} );
        $labelDir->set_alignment( 0, 0 );
        $vbox->pack_start( $labelDir, 0, 0, 10 );
        $vbox->pack_start( $hbox,     1, 1, 0 );

        $self->{directories} = new Gtk2::SimpleList(
            $lang->{Directory} => "text",
            $lang->{Alias}     => "text",
            $lang->{Recursive} => "bool"
        );
        $self->{directories}->set_column_editable( 1, 1 );
        $self->{directories}->set_rules_hint(1);
        $self->{directories}->get_column(0)->set_sort_column_id(0);
        $self->{directories}->get_model->set_sort_column_id( 0, 'ascending' );

        for my $i ( 0 .. 2 ) 
        {
            $self->{directories}->get_column($i)->set_resizable(1);
        }
        $self->{order} = 1;
        $self->{sort}  = -1;

        my $scrollPanelList = new Gtk2::ScrolledWindow;
        $scrollPanelList->set_policy( 'never', 'automatic' );
        $scrollPanelList->set_shadow_type('etched-in');
        $scrollPanelList->set_border_width(0);
        $scrollPanelList->add( $self->{directories} );

        my $vboxButtons = new Gtk2::VBox( 0, 0 );
        my $addButton = Gtk2::Button->new_from_stock('gtk-add');
        $addButton->signal_connect(
            'clicked' => sub {
                $self->add;
            }
        );
        my $removeButton = Gtk2::Button->new_from_stock('gtk-remove');
        $removeButton->signal_connect(
            'clicked' => sub {
                $self->removeCurrent;
            }
        );

        my $editButton = Gtk2::Button->new_from_stock("gtk-edit");
        $editButton->signal_connect(
            'clicked' => sub {
                $self->modify;
            }
        );

        $vboxButtons->pack_start( $addButton,    0, 0, $GCUtils::halfMargin );
        $vboxButtons->pack_start( $removeButton, 0, 0, $GCUtils::halfMargin );
        $vboxButtons->pack_start( $editButton,   0, 0, $GCUtils::halfMargin );

        $hbox->pack_start( $scrollPanelList, 1, 1, 0 );
        $hbox->pack_start( $vboxButtons,     0, 0, $GCUtils::margin );
        $hbox->set_border_width(0);
        $self->vbox->pack_start( $directoriesFrame, 1, 1, 0 );

        #########################"
        # Options part
        ########################

        my $optionsFrame = new GCGroup( $lang->{OtherOptions} );
        my $vboxOptions = new Gtk2::VBox( 0, 0 );
        $optionsFrame->addWidget($vboxOptions);

        my $hboxSuf = new Gtk2::HBox( 0, 0 );
        my $labelSuf = new Gtk2::Label( $lang->{Suffixes} );
        $self->{suffixes} = new Gtk2::Entry;
        $hboxSuf->pack_start( $labelSuf, 0, 0, 0 );
        $hboxSuf->pack_start( $self->{suffixes}, 1, 1, 0 );

        my $hboxRemove = new Gtk2::HBox( 0, 0 );
        my $labelRemove = new Gtk2::Label( $lang->{Remove} );
        $self->{remove} = new Gtk2::Entry;
        $hboxRemove->pack_start( $labelRemove, 0, 0, 0 );
        $hboxRemove->pack_start( $self->{remove}, 1, 1, 0 );

        my $labelCommaSep = new Gtk2::Label( $lang->{CommaSeparation} );
        $labelCommaSep->set_alignment( 0, 0 );

        $self->{checkDel}     = new Gtk2::CheckButton( $lang->{Delete} );
        $self->{checkGetInfo} = new Gtk2::CheckButton( $lang->{GetInfo} );

        my $hboxPlug = new Gtk2::HBox( 0, 0 );
        my $labelPlug = new Gtk2::Label( $lang->{Plugin} );
        $self->{pluginsList} = new GCMenuList;
        $hboxPlug->pack_start( $labelPlug, 0, 0, 0 );
        $hboxPlug->pack_start( $self->{pluginsList}, 1, 1, 0 );

        $self->{checkGetFirst} = new Gtk2::CheckButton( $lang->{First} );
        $self->{checkGetInfo}->signal_connect(
            'toggled' => sub {
                $self->checkClicked;
            }
        );

        $vboxOptions->pack_start( $labelCommaSep,         0, 0, 10 );
        $vboxOptions->pack_start( $hboxSuf,               0, 0, 0 );
        $vboxOptions->pack_start( $hboxRemove,            0, 0, 10 );
        $vboxOptions->pack_start( $self->{checkDel},      0, 0, 0 );
        $vboxOptions->pack_start( $self->{checkGetInfo},  0, 0, 0 );
        $vboxOptions->pack_start( $hboxPlug,              0, 0, 0 );
        $vboxOptions->pack_start( $self->{checkGetFirst}, 0, 0, 0 );

        $self->vbox->pack_start( $optionsFrame, 0, 0, 0 );

        $self->setOkLabel( $lang->{LaunchResearch} );

        return $self;
    }

}

1;
