package GCPlugins::GCImdb;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginImdb;

    use base qw(GCPluginParser);
 
    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingEnded})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ m/mymovies\/list\?pending\&add=([0-9]*)/)
                {
                    $self->{movieIdx} = 0;
                    $self->{movieList}[0]->{"url"} = '/title/tt'.$1.'/';
                }
            }
            return;
        }
        
        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /^\/title\//)
                {
                    my $url = $attr->{href};
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if ((
                     ($self->{inside}->{a}) && 
                     (($self->{currentHref} =~ m/photogallery/) || ($self->{currentHref} =~ m/posters/)) &&
                     ($attr->{src} !~ /f\d{2}\.gif/)
                   ) ||
                   (
                      (
                        ($self->{curInfo}->{title}) &&
                        ($attr->{alt} eq $self->{curInfo}->{title})
                      ) ||
                      (
                        ($self->{curInfo}->{orig}) &&
                        ($attr->{alt} eq $self->{curInfo}->{orig})
                      )
                   ))
                {
                    $self->{curInfo}->{image} = $attr->{src} if ! $self->{curInfo}->{image};
                }
            }
            elsif ($tagname eq "a")
            {
                $self->{currentHref} = $attr->{href};
                if ($attr->{href} =~ m/fullcredits/)
                {
                    $self->{insideActors} = 0;
                    $self->{curInfo}->{actors} =~ s/, $//;
                }
                elsif ($attr->{href} =~ m/certificates=USA:(.+?)&/)
                {
                    $self->{curInfo}->{age} = 1 if ($1 eq 'Unrated') || ($1 eq 'Open');
                    $self->{curInfo}->{age} = 2 if ($1 eq 'G') || ($1 eq 'Approved');
                    $self->{curInfo}->{age} = 5 if ($1 eq 'PG') || ($1 eq 'M') || ($1 eq 'GP');
                    $self->{curInfo}->{age} = 13 if $1 eq 'PG-13';
                    $self->{curInfo}->{age} = 17 if $1 eq 'R';
                    $self->{curInfo}->{age} = 18  if ($1 eq 'NC-17') || ($1 eq 'X');
                }
                $self->{insideSynopsis} = 0 if ($attr->{href} =~ m/plotsummary/);
                $self->{insideType} = 0 if ($attr->{href} =~ m/keywords/);
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
		$self->{inside}->{$tagname}--;

    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
        
        $origtext =~ s/&#34;/"/g;
        $origtext =~ s/&#179;/3/g;
        $origtext =~ s/&#[0-9]*;//g;
        $origtext =~ s/\n//g;

        return if ($self->{parsingEnded});
        
        if ($self->{parsingList})
        {
            if (($self->{inside}->{h1}) && ($origtext !~ m/IMDb\s*Title\s*Search/i))
            {
                $self->{parsingEnded} = 1;
            }
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            if ($self->{isInfo})
            {
                $self->{movieList}[$self->{movieIdx}]->{"year"} = $1 if $origtext =~ m/\(([0-9]*)\)/;
                $self->{isInfo} = 0;
            }
        }
        else
        {
            $self->{insideNat} = 0 if $origtext =~ m/Language:|Color:/;
            $self->{insideOtherTitles} = 0 if $origtext =~ m/Runtime:|MPAA:/;
            $self->{insideSynopsis} = 0 if $origtext =~ m/(User Comments:)|(User Rating:)/;
            $self->{insideType} = 0 if $origtext =~ m/(User Rating:)|(Plot Outline:)/;

            if ($self->{insideType})
            {
                $self->{curInfo}->{type} .= lc($origtext).',' if $origtext !~ m/\//;
            }
            elsif ($self->{insideDirector})
            {
                $self->{curInfo}->{director} = $origtext;
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                ($self->{curInfo}->{synopsis} .= $origtext) =~ s/^\s*//;
            }
            elsif ($self->{insideNat})
            {
                $self->{curInfo}->{nat} .= $origtext;
            }
            elsif ($self->{insideTime})
            {
                $self->{curInfo}->{time} = $origtext;
                $self->{curInfo}->{time} =~ s/.*?://;
                $self->{insideTime} = 0;
            }
            elsif (($self->{insideActors}) && ($self->{inside}->{a}))
            {
                $self->{curInfo}->{actors} .= $origtext.', ' if ($self->{actorsCounter} < $GCPluginParser::MAX_ACTORS);
                $self->{actorsCounter}++;
            }
            elsif ($self->{insideOtherTitles})
            {
                if ($origtext =~ m/(.*?) \(International.*/)
                {
                    $self->{curInfo}->{title} = $1;
                    $self->{insideOtherTitles} = 0;
                }
            }
            
            if ($self->{inside}->{h1})
            {
                $self->{curInfo}->{date} = $origtext if $origtext =~ m/[0-9]+/;
                if (!$self->{curInfo}->{orig})
                {
                    $self->{curInfo}->{orig} = $origtext;
                    $self->{curInfo}->{orig} =~ s/\s*$//;
                }
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideDirector} = 1 if $origtext =~ m/Directed by/;
                $self->{insideType} = 1 if $origtext =~ m/Genre:/;
                $self->{insideSynopsis} = 1 if ($origtext =~ m/Synopsis:|Plot Summary:|Plot Outline:/);
                $self->{insideOtherTitles} = 1 if ($origtext =~ m/Also Known As:/);
                $self->{insideTime} = 1 if $origtext =~ m/Runtime:/;
                $self->{insideNat} = 1 if $origtext =~ m/Country:/;
                $self->{insideActors} = 1 if $origtext =~ m/Cast overview|credited cast:/i;
            }
            
        }
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        
        $self->{parsingEnded} = 0;
        
        $html =~ s/"&#34;/'"/g;
        $html =~ s/&#34;"/"'/g;
        
        return $html;
    }

    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
		return "http://www.imdb.com/find?q=$word;tt=on;mx=20";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
		return "http://www.imdb.com".$url;
    }

    sub getName
    {
        return "IMDb";
    }
    
    sub getImageFile
    {
        return "imdb.png";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'EN';
    }
    
    sub hasSearchDirector
    {
        return 0;
    }

    sub hasSearchActors
    {
        return 0;
    }
    
}

1;
