package GCSplash;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use Gtk2;

{
    package GCSplashWindow;
    use base "Gtk2::Window";

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new('popup');
        bless ($self, $class);

        $self->{parent} = shift;
        $self->{time} = shift;

        $self->set_decorated(0);
        $self->set_resizable(0);
        $self->set_destroy_with_parent(1);
        $self->set_position('center-always');

        my $image = Gtk2::Image->new_from_file($ENV{GCF_SHARE_DIR}.'/splash.jpg');
        
        $self->{label} = new Gtk2::Label('');

        $self->{vbox} = new Gtk2::VBox(0,0);
		$self->{vbox}->add($image);
		$self->{vbox}->add($self->{label});
		
		$self->{progress} = new Gtk2::ProgressBar;
		$self->{vbox}->add($self->{progress});
		
        $self->add($self->{vbox});
 
        my $color_bg = Gtk2::Gdk::Color->parse('#000000');
        $self->modify_bg('normal', $color_bg);
        my $color_fg = Gtk2::Gdk::Color->parse('#ffffff');
        $self->{label}->modify_fg('normal', $color_fg);

        $self->show;

        return $self;
    }

    sub init
    {
        my $self = shift;

        if ($self->{phase} == 0)
        {
            $self->{label}->set_text($self->{parent}->{lang}->{SplashInit});
            $self->{phase} = 1;
        }
        elsif ($self->{phase} == 1)
        {
            $self->setProgress(0.0);
            $self->{parent}->init($self);
            $self->setProgress(0.1);
            $self->{phase} = 2;
            $self->{label}->set_text($self->{parent}->{lang}->{SplashLoad});
        }
        elsif ($self->{phase} == 2)
        {
            $self->{parent}->loadPrevious($self);
            $self->setProgress(1.0);
            $self->{parent}->{initializing} = 0;
            $self->{parent}->set_sensitive(1);
            $self->{phase} = 3;
            $self->{label}->set_text($self->{parent}->{lang}->{SplashDone});
        }
        else
        {
            Glib::Timeout->add(1000 ,\&destroyMe, $self);
            return 0;
        }
        
        Glib::Timeout->add(100 ,\&init, $self);           

        return 0;
    }

    sub setProgressForMoviesLoad
    {
        my ($self, $current, $total) = @_;
        return if ($current % 10);
        $self->{progress}->set_fraction(0.2) if ! $total;
        $self->{progress}->set_fraction(0.1 + (($current / $total) * 0.3)) if $total;
        Gtk2->main_iteration while (Gtk2->events_pending);
    }

    sub setProgressForMoviesDisplay
    {
        my ($self, $current, $total) = @_;
        return if ($current % 10);
        $self->{progress}->set_fraction(0.6) if ! $total;
        $self->{progress}->set_fraction(0.4 + (($current / $total) * 0.5)) if $total;
        Gtk2->main_iteration while (Gtk2->events_pending);
    }

    sub setProgress
    {
        my ($self, $current) = @_;
        $self->{progress}->set_fraction($current);
        Gtk2->main_iteration while (Gtk2->events_pending);
    }

    sub destroyMe
    {
        my $self = shift;
        $self->destroy;
        return 0;
    }

    sub show
    {
        my $self = shift;

        $self->SUPER::show_all;
        $self->{phase} = 0;
        Glib::Timeout->add(10 ,\&init, $self);
    }
}

1;
