package GCPlugins::GCCinemotions;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginCinemotions;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        return if $self->{parsingEnded};

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if (($attr->{href} =~ /^\/modules\/Films\/fiche\//)
								 && ($attr->{class} eq "link4"))
                {
                    my $url = $attr->{href};
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
            elsif (($tagname eq "img") && (($attr->{src} =~ /^\/data\/films\//)
                    || ($attr->{src} =~ /^\/modules\/Films\/img\/webpasdaffiche\.jpg/)))
            {
                $self->{isMovie} = 0;
                $self->{movieIdx}--;
            }
            elsif ($tagname eq "font")
            {
                if ($attr->{class} eq "link4dtext")
                {
                    $self->{isInfo}=1;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if (($attr->{src} =~ /^\/data\/films\//) && 
                    ($attr->{src} !~ /\/data\/films\/[^_]*_[0-9]{4}_[0-9]*\.jpg/))
                {
                    $self->{curInfo}->{image} = "http://cinemotions.com" . $attr->{src};
                }
            }
            elsif ($tagname eq "a")
            {
                $self->{insideName} = 1 if $attr->{class} eq "titre_film";
            }
            elsif ($tagname eq "font")
            {
                $self->{insideOrig} = 1 if $attr->{class} eq "titrevo_film";
                $self->{insideInfos} = 1 if ($attr->{face} eq "arial")
                    && ($attr->{size} eq "2");
                $self->{insideArtists} = 1 if ($attr->{face} eq "verdana,geneva,arial")
                    && ($attr->{size} eq "2");
                $self->{insideSynopsis} = 1 if $attr->{class} eq "link6";
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;

    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
        $origtext =~ s/\s{2,}//g;
        $origtext =~ s/\n*//g if !$self->{insideSynopsis};

        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif ($self->{isInfo})
            {
                if (($origtext =~ /([0-9]{4}) - [0-9]*h[0-9]*/)
                    || ($origtext =~ /([0-9]{4}) - [0-9]* mn/))
                {
                    $self->{movieList}[$self->{movieIdx}]->{"year"} = $1;
                }
                elsif ($origtext =~ /R.alisation : ([^\.]*)(\.\.\..*)?Avec (.*)/)
                {
                    $self->{movieList}[$self->{movieIdx}]->{"director"} =$1;
                    $self->{movieList}[$self->{movieIdx}]->{"actors"} = $3;
                }
                $self->{isInfo} = 0;
            }
        }
        else
        {
            if ($self->{insideName})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{insideName} = 0;
            }
            elsif ($self->{insideOrig})
            {
                $self->{curInfo}->{orig} = $origtext;
                $self->{insideOrig} = 0;
            }
            if ($self->{insideInfos})
            {
                if ($origtext =~ /([0-9]{4})- (\S*)- (\S*)- ([^<]*)/)
                {
                    my $date = $1, my $nat = $2, my $type = $3, my $time = $4;
                    $nat =~ s/\//, /g;
                    $type =~ s/\//,/g;
                    
                    $self->{curInfo}->{date} = $date;
                    $self->{curInfo}->{nat} = $nat;
                    $self->{curInfo}->{type} = $type;
                    $self->{curInfo}->{time} = $time;
                }
                $self->{insideInfos} = 0;
            }
            elsif ($self->{insideArtists})
            {
                if ($origtext =~ /R.alisation : (.*)/)
                {
                    $self->{curInfo}->{director} = $1 if !$self->{curInfo}->{director};
                }
                elsif ($origtext =~ /Avec (.*)/)
                {
                    $self->{curInfo}->{actors} = $1 if !$self->{curInfo}->{actors};
                }
                $self->{insideArtists} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext if !$self->{curInfo}->{synopsis};
                $self->{insideSynopsis} = 0;
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        $html =~ s/<!--[^-]*-->//g;
        $html =~ s/<b>|<\/b>//g;
        $html =~ s/&nbsp;/ /g;
        $html =~ s/\\'//g;
        $html =~ s/<A HREF="\/modules\/Artistes\/fiche\/[0-9]*\/[^\.]*\.html"(?:  target=_parent)? class=link5(?:b)? onMouseOver="window\.status='[^']*'; return true;" onMouseOut="window.status=''">([^<]*)<\/A>/$1/gi;
        $html =~ s/<font class=link_news_2>([^<]*)<\/font>/$1/g;
        $html =~ s/<font class=link4dtext>([^<]*)<br>([^<]*)<\/TD>/<font class=link4dtext>$1 $2<\/font><\/TD>/gi;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
			return "http://www.cinemotions.com/modules/Films/resultats.php?new_keyword=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
			return "http://www.cinemotions.com" . $url;
    }

    sub getName
    {
        return "Cinemotions.com";
    }
    
    sub getImageFile
    {
        return "cinemotions.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'FR';
    }

}

1;
