package GCPlugins::GCAnimeNfoM;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAnimeNfoM;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
							if ($attr->{href} =~ m/mangatitle,[0-9]*,[a-z]*,[a-z0-9_]*\.html/)
							{
									$self->{isMovie} = 1;
              		$self->{isInfo} = 1;
              		$self->{movieIdx}++;
              		$self->{movieList}[$self->{movieIdx}]->{'url'} = $attr->{href};
							}
						}
        }
        else
        {
						if ($tagname eq "font")
						{
							if ($attr->{class} eq "DefaultFont")
							{
									$self->{insideInfos} = 1;
							}
						}
						elsif ($tagname eq "img")
						{
							if (($attr->{border} eq "0") && ($attr->{src} =~ m/^image\/manga_[0-9]*\.jpg$/) && ($attr->{width} eq "120") && ($attr->{height} eq "140"))
							{
									$self->{curInfo}->{image} = "http://www.animenfo.com/" . $attr->{src};
							}
						}
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
        }
        else
        {
            if ($self->{insideInfos})
            {
								if ($origtext =~ m/Alternative titles/)
								{
									$self->{insideName} = 1;
								}
								elsif ($origtext eq "Title")
								{
									$self->{insideOrig} = 1;
								}
								elsif ($origtext eq "Genres")
								{
									$self->{insideType} = 1;
								}
								elsif ($origtext eq "Author")
								{
									$self->{insideDirector} = 1;
								}
								elsif ($origtext =~ m/Description/)
								{
									$self->{insideSynopsis} = 1;
								}
								elsif ($self->{insideName})
								{
	         	      $self->{curInfo}->{title} = $origtext;
									$self->{insideName} = 0;
								}
								elsif ($self->{insideOrig})
								{
	         	      $self->{curInfo}->{orig} = $origtext;
									$self->{insideOrig} = 0;
								}
								elsif ($self->{insideType})
								{
	         	      $self->{curInfo}->{type} = $origtext;
									$self->{insideType} = 0;
								}
								elsif ($self->{insideDirector})
								{
	         	      $self->{curInfo}->{director} = $origtext if $origtext ne "US Distribution";
									$self->{insideDirector} = 0;
								}
								elsif ($self->{insideSynopsis})
								{
	         	      $self->{curInfo}->{synopsis} = $origtext if !$self->{curInfo}->{synopsis};
									$self->{insideSynopsis} = 0;
								}
  	            $self->{insideInfos} = 0;
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

				$html =~ s/<br \/>/\n/g;
				$html =~ s/<script language='JavaScript'>.*?<\/script>//g;
				$html =~ s/<a onMouseOut='[^']*' onMouseOver='[^']*' href='mangabygenre\.php\?genre=[0-9]*'>([^<]*)<\/a>/$1/g;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.animenfo.com/search.php?option=keywords&queryin=manga_titles&query=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.animenfo.com/' . $url;
    }

    sub getName
    {
        return "AnimeNfo Mangas";
    }
    
    sub getImageFile
    {
        return "animenfo.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'EN';
    }

    sub hasSearchActors
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }

    sub hasSearchYear
    {
        return 0;
    }
}

1;
