package GCImport::GCImportDVDProfiler;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use GCImport::GCImportBase;

{
    package GCImport::GCImporterDVDProfiler;

    use base qw(GCImport::GCImportBaseClass);
    
    eval "use XML::Simple"; my $hasXmlSimple = $@ ? 0 : 1;    
    use Data::Dumper;
        
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);
        
        $self->{errors} = '';
        $self->{errors} .= "XML::Simple\n" if (!$hasXmlSimple);

        return $self;
    }

    sub getName
    {
        return "DVDProfiler (.xml)";
    }
    
    sub getOptions
    {
        my $self = shift;
        my @options;
        return \@options;
    }
    
    sub getFilePattern
    {
       return "*.xml";
    }
    
    # Ignored for the moment
    sub wantsFieldsSelection
    {
        return 0;
    }
    sub getEndInfo
    {
        return "";
    }
    
    sub getMoviesArray
    {
	my ($self, $file) = @_;
	my $xml;
	my $data;
	#eval "use XML::Simple";
	# creer un objet
	#$xml = new XML::Simple (KeyAttr=>'Title'); # sans keyAttr les dvd seront dans une liste ou chaque dvd sera identifie par l'emplacement qu'il a dans cette liste
	$xml = XML::Simple->new; # sans keyAttr les dvd seront dans une liste ou chaque dvd sera identifie par l'emplacement qu'il a dans cette liste
	$data = $xml->XMLin ("$file");

	
	my @result; 
	my $film;
	
	foreach $film(@{$data->{DVD}}){
		my $movie;
		
		$movie->{title} = $film->{Title};
		$movie->{date} = $film->{ProductionYear};
		$movie->{time} = $film->{RunningTime}.' mn';
		$movie->{synopsis} = $film->{Overview};
		####### DIRECTOR #########
		my $director;
		
		if (ref ($film->{Credits}->{Credit}) eq "ARRAY") {
			foreach $director(@{$film->{Credits}->{Credit}}){
				if (($director->{CreditType}) eq 'Direction') {
					$movie->{director} .= $director->{FirstName}.' '.$director->{LastName}.', ';
					
				}
			}
		}
		else {
			if (($film->{Credits}->{Credit}->{CreditType}) eq 'Direction') {
					$movie->{director} .= $film->{Credits}->{Credit}->{FirstName}.' '.$film->{Credits}->{Credit}->{LastName};
				}
		}
		###### END DIRECTOR ######
		
		####### ACTORS #########
		my $actor;
		#print "Acteurs ", $film->{Actors}->{Actor}, "\n";
		if (ref ($film->{Actors}->{Actor}) eq "ARRAY") {
			foreach $actor(@{$film->{Actors}->{Actor}}){
				#print "Acteurs ", $film->{Actors}->{Actor}, "\n";
				$movie->{actors} .= $actor->{FirstName}.' '.$actor->{LastName}.' '.'('.$actor->{Role}.')'.', ';
				
			}
			}
		else {
		#print "Acteurs mais else", $film->{Actors}->{Actor}, "\n";
		$movie->{actors} .= $film->{Actors}->{Actor}->{'FirstName'}.' '.$film->{Actors}->{Actor}->{LastName}.' '.'('.$film->{Actors}->{Actor}->{Role}.')';
		}
		###### END ACTORS ######
		
		####### AUDIO #########
		my $audio;
		#print "Audio ", $film->{Audio}->{AudioFormat}, "\n";
		if (ref ($film->{Audio}->{AudioFormat}) eq "ARRAY"){
			foreach $audio(@{$film->{Audio}->{AudioFormat}}){
				#print "Audio ", $film->{Audio}->{AudioFormat}, "\n";
				$movie->{audio} .= $audio->{AudioLanguage}.', ';
				
				}
		}
		else  {
		#print "Audio ", $film->{Audio}->{AudioFormat}, "\n";
			$movie->{audio} .= $film->{Audio}->{AudioFormat}->{'AudioLanguage'};
		}
		###### END AUDIO ######
		####### SUBT #########
		my $subt;
		if (ref ($film->{Subtitles}->{Subtitle}) eq "ARRAY"){
			foreach $subt(@{$film->{Subtitles}->{Subtitle}}){
				$movie->{subt} .= $subt.', ';
				
			}
		}
		else {
			$movie->{subt} = $film->{Subtitles}->{Subtitle};
		}
		####### END SUBT #########
		####### TYPE #########
		my $type;
		if (ref ($film->{Genres}->{Genre}) eq "ARRAY"){
			foreach $type(@{$film->{Genres}->{Genre}}){
				$movie->{type} .= $type.',';
				
			}
		}
		else {
			$movie->{type} = $film->{Genres}->{Genre};
		}
		####### END TYPE #########
		
		#$movie->{orig} = $film->{Title};
		#$movie->{subt} = $film->{Subtitles}->{Subtitle};
		#$movie->{borrower} = $film->{Title};
		#$movie->{lendDate} = $film->{Title};
		#$movie->{history} = $film->{Title};
		#$movie->{seen} = $film->{Title};# non par defaut ?
		#$movie->{comment} = $film->{Title};
		#$movie->{image} = $film->{Title};
		#$movie->{nat} = $film->{Title};
		#$movie->{number} = $film->{CollectionNumber};
		#$movie->{rating} = $film->{Title};# note par defaut
		#$movie->{format} = $film->{Title};#DVD par d�faut ?
		#$movie->{url} = $film->{Title};
		#$movie->{place} = $film->{Title};
		$movie->{director} =~ s/, $//;
		$movie->{actors} =~ s/, $//;
		$movie->{audio} =~ s/, $//;
		$movie->{subt} =~ s/, $//;
		$movie->{type} =~ s/, $//;
		push @result, $movie;
	}
	return \@result;

	}
}

1;