package GCExport::GCExportBase;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

{
    package GCExport::GCExportBaseClass;
    use File::Basename;
    use File::Copy;
    
    if ($^O =~ /win32/i)
    {
        use File::DosGlob 'glob';
    }
    
    #Methods to be overriden in specific classes
    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = {};

        bless ($self, $class);
        return $self;
    }

    sub getName
    {
    }
    
    sub getOptions
    {
    }
    
    sub wantsFieldsSelection
    {
        return 0;
    }
    
    sub wantsImagesSelection
    {
        return 0;
    }
    
    sub wantsFileSelection
    {
        return 1;
    }
    
    sub getHeader
    {
    }

    sub getItem
    {
    }

    sub getFooter
    {
    }

    sub postProcess
    {
    }

    sub preProcess
    {
    }

    sub getEndInfo
    {
    }

    #End of methods to be overriden
    
    # If you need really specific processing, you can instead override the process method
    
    sub process
    {
        my ($self, $options) = @_;

        $self->{options} = $options;
        
        $self->{fileName} = $options->{file};
        $self->{orig} = $options->{collection};
        $self->{origDir} = dirname($self->{orig});
        $options->{collectionDir} = $self->{origDir};

        ($self->{dirName} = $self->{fileName}) =~ s/\.[^.]*?$//;
        $self->{dirName} .= '_images';
        if ( -e $self->{dirName})
        {
            my @images = glob $self->{dirName}.'/*';
            unlink foreach (@images);
            rmdir $self->{dirName};
            unlink $self->{dirName} if ( -e $self->{dirName});
        }
        mkdir $self->{dirName} if ($self->{options}->{withPictures});

        $self->preProcess();

        my @tmpArray = @{$options->{movies}};

        my $header = $self->getHeader($#tmpArray + 1);
        my $body = '';

        my $movie;
        my $idx = 0;
        foreach $movie(@tmpArray)
        {
            my $oldImage = $movie->{image};
            if ($oldImage && $self->{options}->{withPictures})
            {
                copy($movie->{image}, $self->{dirName});
                $movie->{image} = basename($self->{dirName}).'/'.basename($movie->{image});
                $movie->{image} =~ s/\//\\/g if ($^O =~ /win32/i);
                $movie->{audioEncoding} = $movie->{audio};
                $movie->{audio} =~ s/;.*?(,|$)/$1/g;
            }
            
            $body .= $self->getItem($movie, $idx);
            $movie->{image} = $oldImage;
	        $idx++;
        }
        my $footer = $self->getFooter($#tmpArray + 1);

        $self->postProcess(\$header);

        open EXPORTFILE, ">".$options->{file};
        printf EXPORTFILE "$header";
        printf EXPORTFILE "$body";
        printf EXPORTFILE "$footer";
        close EXPORTFILE;

        return $self->getEndInfo;
    }
}

1;
