package GCExport;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use File::Basename;
use FindBin qw($RealBin);

use base 'Exporter';
our @EXPORT = qw(@exportersArray);

our @exportersArray;

use Cwd;
my $oldCwd = getcwd;
chdir $RealBin;
foreach (glob "../lib/gcfilms/GCExport/*.pm")
{
    my $export = basename($_, '.pm')."\n";
    next if $export =~ /GCExportBase/;
    eval "use GCExport::$export";
    (my $exporter = $export) =~ s/^GCExport/GCExporter/;
    my $obj;
    eval "\$obj = new GCExport::$exporter";
    die "Fatal error with exporter $export\n$@" if $@;
    push @exportersArray, $obj if ! $obj->{errors};
}
chdir $oldCwd;

use Gtk2;
use GCDialogs;

{
    package GCExportDialog;
    use base "GCExportImportDialog";


    sub addOptions
    {
        my ($self, $options) = @_;
        $options->{movies} = $self->{parent}->{movies}->{movieArray};
        $options->{collection} = $self->{parent}->{options}->file;    
    }

    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new($parent, $parent->{lang}->{ExportTitle}, 'export');
        bless ($self, $class);

        $self->{fieldsDialog} = new GCFieldsSelectionDialog($self, $parent->{lang}->{ExportFieldsTitle});
        $self->{fieldsButtonLabel} = $parent->{lang}->{ExportFieldsTitle};
        $self->{fieldsTip} = $parent->{lang}->{ExportFieldsTip};

        return $self;
    }
    
}


1;
