package GCData;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCDisplay;

{
    package GCMovies;

    sub new
    {
        my ($proto, $parent) = @_;
        my $class = ref($proto) || $proto;
        my $self  = {};

        $self->{parent} = $parent;

        $self->{imagesToBeRemoved} = ();
        $self->{imagesToBeAdded} = ();
        $self->{movieArray} = [];
        $self->{currentSortOrder} = 1;
        $self->{currentSortField} = 'title';
        $self->{currentMovie} = -1;
        $self->{currentId} = -1;
        $self->{hasBeenDeleted} = 0;
        $self->{block} = 0;
        $self->{filterSearch} = new GCFilterSearch;

        bless ($self, $class);
        return $self;
    }
 
    sub setPanel()
    {
        my ($self, $panel) = @_;
        $self->{panel} = $panel;
    }

    sub updateCurrent
    {
		my $self = shift;
		
		return if $self->{currentMovie} == -1;

        my $oldTitle = $self->{movieArray}[$self->{currentMovie}]->{title};

        my $panelId = $self->{panel}->id;
        my $previousId = $self->{movieArray}[$self->{currentMovie}]->{id};
        
        if ($panelId &&
           ($panelId != $previousId))
        {
		  $self->{movieArray}[$self->{currentMovie}]->{id} = $self->{panel}->id;
		  $self->{maxId} = $panelId if ($panelId > $self->{maxId});
		  $self->{currentId} = $panelId;
		  $self->{toBeDisplayed}->{$panelId} = 1;
		  $self->{toBeDisplayed}->{$previousId} = 0;
        }
        
		$self->{panel}->id($self->{movieArray}[$self->{currentMovie}]->{id}) if $self->{panel}->id;
		$self->{movieArray}[$self->{currentMovie}]->{title} = $self->{panel}->title;
		$self->{movieArray}[$self->{currentMovie}]->{time} = $self->{panel}->time;
		$self->{movieArray}[$self->{currentMovie}]->{date} = $self->{panel}->date;
		$self->{movieArray}[$self->{currentMovie}]->{director} = $self->{panel}->director;
		$self->{movieArray}[$self->{currentMovie}]->{nat} = $self->{panel}->nationality;
		$self->{movieArray}[$self->{currentMovie}]->{age} = $self->{panel}->age;
		$self->{movieArray}[$self->{currentMovie}]->{image} = $self->{panel}->image;
		$self->{movieArray}[$self->{currentMovie}]->{orig} = $self->{panel}->orig;
		$self->{movieArray}[$self->{currentMovie}]->{actors} = $self->{panel}->actors;
		$self->{movieArray}[$self->{currentMovie}]->{comment} = $self->{panel}->comment;
		$self->{movieArray}[$self->{currentMovie}]->{synopsis} = $self->{panel}->synopsis;
		$self->{movieArray}[$self->{currentMovie}]->{seen} = $self->{panel}->seen;
		$self->{movieArray}[$self->{currentMovie}]->{number} = $self->{panel}->number;
		$self->{movieArray}[$self->{currentMovie}]->{rating} = $self->{panel}->rating;
		$self->{movieArray}[$self->{currentMovie}]->{format} = $self->{panel}->format;
		$self->{movieArray}[$self->{currentMovie}]->{url} = $self->{panel}->url;
		$self->{movieArray}[$self->{currentMovie}]->{borrower} = $self->{panel}->borrower;
        $self->{movieArray}[$self->{currentMovie}]->{lendDate} = $self->{panel}->lendDate;
        $self->{movieArray}[$self->{currentMovie}]->{history} = $self->{panel}->history;
	
		my $tmpTypes = $self->{panel}->type;
		$self->addTypes($tmpTypes);
		$self->{panel}->setTypes($self->getTypes);
		$self->{parent}->{menubar}->setTypes($self->getTypes);
		$self->{panel}->type($tmpTypes);
		$self->{movieArray}[$self->{currentMovie}]->{type} = $tmpTypes;
	
		my $tmpPlace = $self->{panel}->place;
		$self->addPlace($tmpPlace);
		$self->{panel}->setPlaces($self->getPlaces);
		$self->{panel}->place($tmpPlace);
		$self->{movieArray}[$self->{currentMovie}]->{place} = $tmpPlace;
	
		my $tmpAudios = $self->{panel}->audio;
		$self->addAudios($tmpAudios);
		$self->{panel}->setAudios($self->getAudios);
		$self->{panel}->audio($tmpAudios);
		$self->{movieArray}[$self->{currentMovie}]->{audio} = $tmpAudios;
	
		my $tmpSubs = $self->{panel}->subt;
		$self->addSubs($tmpSubs);
		$self->{panel}->setSubs($self->getSubs);
		$self->{panel}->subt($tmpSubs);
		$self->{movieArray}[$self->{currentMovie}]->{subt} = $tmpSubs;

        if ($oldTitle ne $self->{movieArray}[$self->{currentMovie}]->{title})
        {
            use locale;
            my $current = $self->{movieArray}[$self->{currentMovie}];
            my $next = 0;
            my $previous = 0;
            
            $next = $self->{movieArray}[$self->{currentMovie} + 1]
                if $self->{currentMovie} < ($self->{nbMovies} - 1);
 
            $previous = $self->{movieArray}[$self->{currentMovie} - 1]
                if $self->{currentMovie} > 0;
 
            if (
                 (
                    $self->{nbMovies} < 4
                 ) ||
                 (
                   $next && $previous &&
                   (
                     ($self->compareMovies($current, $previous) < 0) ||
                     ($self->compareMovies($current, $next) > 0)
                   )
                 ) ||
                 (
                    $next &&
                    ($self->compareMovies($current, $next) > 0)
                 ) ||
                 (
                    $previous &&
                    ($self->compareMovies($current, $previous) < 0)
                 )
               )
            {        
    		    $self->reloadList;
    		    return 1;
            }
            else
            {
                $self->{parent}->{moviesList}->changeCurrentTitle($self->{movieArray}[$self->{currentMovie}]->{title});
		        return 0;
            }
        }
		else
		{
		    return 0;
		}
    }
    
    sub currentTitle
    {
        my $self = shift;

        return $self->{movieArray}[$self->{currentMovie}]->{title};
    }
    
    sub displayCurrent
    {
        my $self = shift;

        $self->displayInPanel($self->{panel});
    }
    
    sub displayInPanel
    {
        my ($self, $panel, $idx) = @_;
        
        $idx = $self->{currentMovie} if !$idx;
        $panel->id($self->{movieArray}[$idx]->{id});
        $panel->title($self->{movieArray}[$idx]->{title});
        $panel->date($self->{movieArray}[$idx]->{date});
        $panel->time($self->{movieArray}[$idx]->{time});
        $panel->director($self->{movieArray}[$idx]->{director});
        $panel->nationality($self->{movieArray}[$idx]->{nat});
        $panel->age($self->{movieArray}[$idx]->{age});
        $panel->type($self->{movieArray}[$idx]->{type});
        $panel->image($self->{movieArray}[$idx]->{image});
        $panel->orig($self->{movieArray}[$idx]->{orig});
        $panel->actors($self->{movieArray}[$idx]->{actors});
        $panel->comment($self->{movieArray}[$idx]->{comment});
        $panel->synopsis($self->{movieArray}[$idx]->{synopsis});
        $panel->seen($self->{movieArray}[$idx]->{seen});
        $panel->number($self->{movieArray}[$idx]->{number});
        $panel->rating($self->{movieArray}[$idx]->{rating});
        $panel->format($self->{movieArray}[$idx]->{format});
        $panel->url($self->{movieArray}[$idx]->{url});
        $panel->place($self->{movieArray}[$idx]->{place});
        $panel->audio($self->{movieArray}[$idx]->{audio});
        $panel->subt($self->{movieArray}[$idx]->{subt});
        $panel->borrower($self->{movieArray}[$idx]->{borrower});
        $panel->lendDate($self->{movieArray}[$idx]->{lendDate});
        $panel->history($self->{movieArray}[$idx]->{history});

    }

    sub display
    {
        my $self = shift;

        return if ! $self->{nbMovies};

        my $number = shift;

        $number = 0 if $number == -1;

        $number = $self->selectToId($number);
        $self->{currentId} = $self->{movieArray}[$number]->{id};

        my $hasBeenReloaded = 0;

        if (($self->{currentMovie} > -1) && !($self->{hasBeenDeleted}))
        {
            $hasBeenReloaded = $self->updateCurrent;
        }
		else
		{
		    $self->{currentMovie} = $number;
		}

        $self->{hasBeenDeleted} = 0;

        $self->{currentMovie} = $number if ! $hasBeenReloaded;
        $self->displayCurrent;
    }

    sub setFilter
    {
        my ($self, $filter, $parameter) = @_;

        if ($filter eq 'seen')
        {
            if ($parameter eq 'notseen')
            {
                $self->{filterSearch}->setSeen(0);
            }
            else
            {
                $self->{filterSearch}->setSeen(-1);
            }
        }
        elsif ($filter eq 'type')
        {
            if ($parameter eq 'all')
            {
                $self->{filterSearch}->setType('');
            }
            else
            {
                $self->{filterSearch}->setType($parameter);
            }
        }
        elsif ($filter eq 'rating')
        {
            if ($parameter eq 'all')
            {
                $self->{filterSearch}->setRating(0);
            }
            else
            {
                $self->{filterSearch}->setRating($parameter);
            }
        }
        elsif ($filter eq 'age')
        {
            if ($parameter eq 'all')
            {
                $self->{filterSearch}->setAge(-1);
            }
            else
            {
                $self->{filterSearch}->setAge($parameter);
            }
        }
        elsif ($filter eq 'borrowing')
        {
            if ($parameter eq 'all')
            {
                $self->{filterSearch}->setBorrowed(-1);
            }
            else
            {
                $self->{filterSearch}->setBorrowed(($parameter eq 'yes') ? 1 : 0);
            }
        }
        elsif ($filter eq 'search')
        {
            if ($parameter eq 'all')
            {
                $self->{filterSearch}->clear;
            }
            else
            {
                $self->{filterSearch}->setOptions($parameter);
            }
        }

        $self->filter;
        $self->reloadList($self->{parent}, 1);
        
        $self->displayCurrent;
    }

    sub filterTest
    {
        my ($self, $value) = @_;

		return $self->{filterSearch}->test($value);
    }

    sub filter
    {
        my $self = shift;

        my %tmpMap = {};        
        my $i;
        for ($i = 0; $i < $self->{nbMovies}; $i++)
        {
            my $id = $self->{movieArray}[$i]->{id};
            if ($self->filterTest($self->{movieArray}[$i]))
            {
                $tmpMap{$id} = 1;
            }
            else
            {
                $tmpMap{$id} = 0;
            }
        }
       $self->{toBeDisplayed} = \%tmpMap;
    }

    sub getTypes
    {
        my $self = shift;
        push @{$self->{typesArray}}, '';
        my %saw;
        @saw{@{$self->{typesArray}}} = ();
        @{$self->{typesArray}} = sort keys %saw;
        return $self->{typesArray};
    }

    sub getPlaces
    {
        my $self = shift;
        push @{$self->{placesArray}}, '';
        my %saw;
        @saw{@{$self->{placesArray}}} = ();
        @{$self->{placesArray}} = sort keys %saw;
        return $self->{placesArray};
    }

    sub getAudios
    {
        my $self = shift;
        my (@audios, @encodings);
        push @audios, '';
        push @encodings, '';
        
        foreach (@{$self->{audiosArray}})
        {
            my @track = split ';';
            push @audios, $track[0] if ($track[0]);
            push @encodings, $track[1] if ($track[1]);
        }

        my %saw1;
        @saw1{@audios} = ();
        @audios = sort keys %saw1;

        my %saw2;
        @saw2{@encodings} = ();
        @encodings = sort keys %saw2;
        
        return (\@audios, \@encodings);
    }

    sub getSubs
    {
        my $self = shift;
        push @{$self->{subtsArray}}, '';
        my %saw;
        @saw{@{$self->{subtsArray}}} = ();
        @{$self->{subtsArray}} = sort keys %saw;
        return $self->{subtsArray};
    }

    
    sub changeOrder
    {
        my ($self, $field) = @_;
        
        $field = 'title' if !$field;

        $self->{currentSortOrder} = 0 if ($field ne $self->{currentSortField});
        $self->{currentSortField} = $field;
        $self->{currentSortOrder} = 1 - $self->{currentSortOrder};
        
        $self->reloadList($self->{parent}, 1);
    }
    
    sub resetSortField
    {
        my $self = shift;
        $self->{currentSortField} = 'title';
    }
    
    sub getSortOrder
    {
        my $self = shift;
        
        return ($self->{currentSortOrder}, $self->{currentSortField});        
    }

    sub compareMovies
    {
        my ($self, $a, $b) = @_;
    
        use locale;
        return ($self->{parent}->transformTitle($a->{title}) cmp $self->{parent}->transformTitle($b->{title}))
            if $self->{currentSortField} eq 'title';
        return ($a->{$self->{currentSortField}} cmp $b->{$self->{currentSortField}});
    }
    
    sub reloadList
    {
        my ($self, $splash, $fullProgress) = @_;

        return if $self->{block};

        if ($splash && $fullProgress)
        {
            $splash->initProgress;
        }
        
        $self->{parent}->{moviesList}->reset;
        
        sub compare
        {
            return $self->compareMovies($a, $b);
        }

        if ($self->{currentSortOrder})
        {
            @{$self->{movieArray}} = sort compare @{$self->{movieArray}};
        }
        else
        {
            @{$self->{movieArray}} = reverse sort compare @{$self->{movieArray}};
        }

        my @displayedArray = ();
        my $lastDisplayed = -1;
        my $hasId = 0;
        my $currentDisplayed = 0;
        my $j;
        for ($j = 0; $j < $self->{nbMovies}; $j++)
        {
            $hasId = 0;
            if ($self->{currentId} == $self->{movieArray}[$j]->{id})
            {
                $hasId = 1;
            }

            if ($self->{toBeDisplayed}->{$self->{movieArray}[$j]->{id}})
            {
                $self->{parent}->{moviesList}->addMovie($self->{movieArray}[$j]);
                
                if ($hasId)
                {
				    $self->{currentMovie} = $j;
				    $currentDisplayed = $#displayedArray + 1;
                }
                push @displayedArray, $j;
                $lastDisplayed = $j;
            }
            else
            {
                if ($hasId)
                {
                    $currentDisplayed = $#displayedArray;
                    $self->{currentMovie} = $lastDisplayed;
                    $self->{currentId} = $self->{movieArray}[$lastDisplayed]->{id};
                }
            }

            $splash->setProgressForMoviesDisplay($j, $self->{informations}->{count}) if $splash;
        }

        $self->{selectToIdArray} = \@displayedArray;

        if (! scalar(@displayedArray))
		{
		    $self->{panel}->hide;
		}
        else
        {
            $self->{panel}->show;
        }

        if ($splash && $fullProgress)
        {
            $splash->endProgress;
        }
        
        $self->{parent}->{moviesList}->done;
        
        $self->{currentId}  = $self->selectToId(0)
            if ($self->{currentId} == -1);

        $self->select($currentDisplayed, $self->{currentId});

        $self->setStatus;
    }

    sub setStatus
    {
        my $self = shift;
        
        my $number = 0;
        $number = scalar @{$self->{selectToIdArray}} if $self->{selectToIdArray};
        my $status = ' ';
        $status .= $number;
        $status .= ' '.$self->{parent}->{lang}->{StatusMovies};
        $self->{parent}->setStatus($status);
    }

    sub select
    {
		my ($self, $value, $id) = @_;
		$self->{parent}->{moviesList}->select($value, $id) unless  $value < 0;
    }

    sub removeCurrentMovie
    {
        my $self = shift;

        my $number = $self->{currentMovie};
        my $prevId = $self->{movieArray}[$number]->{id};

        my $image = $self->{movieArray}[$number]->{image};
        my $imagePrefix = $self->{parent}->{imagePrefix};
        if ($image =~ /(\/|\\)$imagePrefix[0-9]*\./)
        {
            $self->markToBeRemoved($image);
        }

        splice @{$self->{movieArray}}, $number, 1;

        $self->{nbMovies}--;

        $self->{panel}->hide if ! $self->{nbMovies};

        $self->{currentMovie}-- if $self->{currentMovie};
        
        my $id = $self->{movieArray}[$self->{currentMovie}]->{id};
        $self->{currentId} = $id;

        if ($self->{parent}->{moviesList}->removeMovie($number, $prevId))
        {
            $self->reloadList;
        }
        else
        {
            $self->{parent}->{moviesList}->select($self->{currentMovie});
        }

        $self->{hasBeenDeleted} = 1;

        $self->displayCurrent if $self->{nbMovies};
    }

    sub addMovie
    {
        my ($self, $info) = @_;

        $self->{panel}->show if ! $self->{nbMovies};

        $self->{maxId}++;
        
        my $currentId = $self->{maxId};

        $self->{movieArray}[$self->{nbMovies}]->{id} = $currentId;
        $self->{movieArray}[$self->{nbMovies}]->{title} = $info->{title};
        $self->{movieArray}[$self->{nbMovies}]->{date} = $info->{date};
        $self->{movieArray}[$self->{nbMovies}]->{time} = $info->{time};
        $self->{movieArray}[$self->{nbMovies}]->{director} = $info->{director};
        $self->{movieArray}[$self->{nbMovies}]->{nat} = $info->{nat};
        $self->{movieArray}[$self->{nbMovies}]->{age} = $info->{age};

        $self->addTypes($info->{type});
        $self->addPlace($info->{place});
        $self->addAudios($info->{audio});
        $self->addSubs($info->{subt});

        $self->{movieArray}[$self->{nbMovies}]->{type} = $info->{type};
        $self->{movieArray}[$self->{nbMovies}]->{image} = $info->{image};
        $self->{movieArray}[$self->{nbMovies}]->{synopsis} = $info->{synopsis};
        $self->{movieArray}[$self->{nbMovies}]->{orig} = $info->{orig};
        $self->{movieArray}[$self->{nbMovies}]->{actors} = $info->{actors};
        $self->{movieArray}[$self->{nbMovies}]->{url} = $info->{url};
        $self->{movieArray}[$self->{nbMovies}]->{seen} = 0;
        $self->{movieArray}[$self->{nbMovies}]->{place} = '';
        $self->{movieArray}[$self->{nbMovies}]->{audio} = '';
        $self->{movieArray}[$self->{nbMovies}]->{subt} = '';
	

        $self->{currentId} = $self->{maxId};
        $self->{toBeDisplayed}->{$self->{currentId}} = 1;

        $self->{toBeDisplayed}->{$self->{currentId}} = 1;
        $self->{parent}->{moviesList}->addMovie($self->{movieArray}[$self->{nbMovies}]);

        $self->{currentMovie} = $self->{nbMovies};
        push @{$self->{selectToIdArray}}, $self->{nbMovies};

        $self->select($self->{nbMovies});
        $self->setStatus;
        
        $self->{nbMovies}++;        

        $self->{parent}->{moviesList}->showCurrent;
        
        return $currentId;
    }
    
    sub insertMovie
    {
        my ($self, $info) = @_;

        $self->{maxId}++;

        $self->{movieArray}[$self->{nbMovies}]->{id} = $self->{maxId};
        $self->{movieArray}[$self->{nbMovies}]->{title} = $info->{title};
        $self->{movieArray}[$self->{nbMovies}]->{date} = $info->{date};
        $self->{movieArray}[$self->{nbMovies}]->{time} = $info->{time};
        $self->{movieArray}[$self->{nbMovies}]->{director} = $info->{director};
        $self->{movieArray}[$self->{nbMovies}]->{nat} = $info->{nat};
        $self->{movieArray}[$self->{nbMovies}]->{age} = $info->{age};
        $self->{movieArray}[$self->{nbMovies}]->{type} = $info->{type};
        $self->{movieArray}[$self->{nbMovies}]->{image} = $info->{image};
        $self->{movieArray}[$self->{nbMovies}]->{actors} = $info->{actors};
        $self->{movieArray}[$self->{nbMovies}]->{orig} = $info->{orig};
        $self->{movieArray}[$self->{nbMovies}]->{synopsis} = $info->{synopsis};
        $self->{movieArray}[$self->{nbMovies}]->{url} = $info->{url};
        $self->{movieArray}[$self->{nbMovies}]->{seen} = $info->{seen};
        $self->{movieArray}[$self->{nbMovies}]->{format} = $info->{format};
        $self->{movieArray}[$self->{nbMovies}]->{number} = $info->{number};
        $self->{movieArray}[$self->{nbMovies}]->{place} = $info->{place};
        $self->{movieArray}[$self->{nbMovies}]->{rating} = $info->{rating};
        $self->{movieArray}[$self->{nbMovies}]->{comment} = $info->{comment};
        $self->{movieArray}[$self->{nbMovies}]->{audio} = $info->{audio};
        $self->{movieArray}[$self->{nbMovies}]->{subt} = $info->{subt};
        $self->{movieArray}[$self->{nbMovies}]->{borrower} = $info->{borrower};
        $self->{movieArray}[$self->{nbMovies}]->{lendDate} = $info->{lendDate};
        $self->{movieArray}[$self->{nbMovies}]->{history} = $info->{history};
        
        $self->{nbMovies}++;

        $self->{currentId} = $self->{maxId};
        $self->{toBeDisplayed}->{$self->{currentId}} = 1;

        $self->addTypes($info->{type});
        $self->addPlace($info->{place});
        $self->addAudios($info->{audio});
        $self->addSubs($info->{subt});
    }

    sub selectToId
    {
		my ($self, $i) = @_;
	
		return $self->{selectToIdArray}[$i];
    }

    sub setOptions
    {
        my ($self, $options, $splash) = @_;

        $self->{options} = $options;

        $self->load($options->file, $splash, 0);
    }

    sub markToBeRemoved
    {
        my ($self, $image) = @_;

        push @{$self->{imagesToBeRemoved}}, $image;
    }

    sub markToBeAdded
    {
        my ($self, $image) = @_;
        push @{$self->{imagesToBeAdded}}, $image;        
    }
    
    sub removeMarkedPictures
    {
        my $self = shift;
        my $image;
        foreach $image(@{$self->{imagesToBeRemoved}})
        {
            unlink $image;
        }

        $self->{imagesToBeRemoved} = ();
    }

    sub addMarkedPictures
    {
        my $self = shift;

        $self->{imagesToBeAdded} = ();
    }
    
    sub clean
    {
        my $self = shift;
        my $image;
        foreach $image(@{$self->{imagesToBeAdded}})
        {
            unlink $image;
        }
    }

    sub rename
    {
        my ($self, $old, $new) = @_;
        
        foreach (@{$self->{movieArray}})
        {
            $_->{type} =~ s/$old,/$new,/gi;
        }
        $self->displayCurrent;
        $self->reloadList;
    }
    
    sub clearList
    {
        my $self = shift;
        $self->{currentMovie} = -1;
        $self->{typesArray} = ();
        $self->{placesArray} = ();
        $self->{audiosArray} = ();
        $self->{subtsArray} = ();
        $self->{maxId} = 0;
		$self->{movieArray} = [];
		$self->{informations} = {};
		$self->{selectToIdArray} = [];
        my %tmpMap = {};
		$self->{currentId} = -1;
		$self->{toBeDisplayed} = \%tmpMap;
        $self->{panel}->hide;
        $self->{nbMovies} = 0;
        $self->{parent}->{moviesList}->clearCache;
        $self->reloadList if ! $self->{parent}->{initializing};
    }

    sub load
    {
        my ($self, $file, $splash, $fullProgress) = @_;

        $self->clean;

        my $i = 0;

        $self->clearList;

        return if (!$file);

        if (! -e $file)
		{
		    $self->{nbMovies} = 0;
		    $self->{panel}->hide;
	            open MOVIES, ">$file" or die "Cannot create $file\n";
	            close MOVIES;
		}

		if (! open MOVIES, $file)
		{
		    my  $dialog = Gtk2::MessageDialog->new($self->{parent},
							   [qw/modal destroy-with-parent/],
							   'error',
							   'ok',
							   $self->{parent}->{lang}->{OpenError});
		    $dialog->run();
		    $dialog->destroy ;
		    return;
		}
        
        my %tmpMap = {};
        my $gotFirstLine = 0;

        while (<MOVIES>)
        {
            chomp;
            my @values =  split m/\|/;

            if (!$gotFirstLine)
            {
                $gotFirstLine = 1;
                if ($values[0] eq 'GCfilms')
                {
                    $self->{informations}->{count} = $values[1];
                    binmode( MOVIES, ':utf8' ) if $values[2] eq 'UTF8';
                    next;
                }
            }

            $self->{movieArray}[$i]->{id} = $values[0];
            $self->{movieArray}[$i]->{title} = $values[1];
            $self->{movieArray}[$i]->{date} = $values[2];
            $self->{movieArray}[$i]->{time} = $values[3];
            $self->{movieArray}[$i]->{director} = $values[4];
            $self->{movieArray}[$i]->{nat} = $values[5];
            $self->{movieArray}[$i]->{type} = $values[6];
            $self->{movieArray}[$i]->{image} = $values[7];
            $self->{movieArray}[$i]->{actors} = $values[8];
            $self->{movieArray}[$i]->{orig} = $values[9];
            $self->{movieArray}[$i]->{synopsis} = $values[10];
            $self->{movieArray}[$i]->{url} = $values[11];
            $self->{movieArray}[$i]->{seen} = $values[12];
            $self->{movieArray}[$i]->{format} = $values[13];
            $self->{movieArray}[$i]->{number} = $values[14];
            $self->{movieArray}[$i]->{place} = $values[15];
            $self->{movieArray}[$i]->{rating} = $values[16];
            $self->{movieArray}[$i]->{comment} = $values[17];
            $self->{movieArray}[$i]->{audio} = $values[18];
            $self->{movieArray}[$i]->{subt} = $values[19];
            $self->{movieArray}[$i]->{borrower} = $values[20];
            $self->{movieArray}[$i]->{lendDate} = $values[21];
            $self->{movieArray}[$i]->{history} = $values[22];
            $self->{movieArray}[$i]->{age} = $values[23];
	    
            if ($values[0] > $self->{maxId})
            {
                $self->{maxId} = $values[0];
            }

            $self->addTypes($values[6]);
            $self->addPlace($values[15]);
            $self->addAudios($values[18]);
            $self->addSubs($values[19]);

            if ($self->filterTest($self->{movieArray}[$i]))
            {
                $tmpMap{$values[0]} = 1;
            }
            else
            {
                $tmpMap{$values[0]} = 0;
            }

            $splash->setProgressForMoviesLoad($i, $self->{informations}->{count}) if $splash;

            $i++;
        }
        close MOVIES;
        $self->{nbMovies} = $i;
		$self->{toBeDisplayed} = \%tmpMap;
	
		if (! $i)
		{
		    $self->{panel}->hide;
		}
		
        $self->reloadList($splash, $fullProgress);
       
    }

    sub addTypes
    {
        my ($self, $value) = @_;

        my @types = split m/,/, $value;
        my $type;
        foreach $type (@types)
        {
            $type =~ s/^\s*//;
            push @{$self->{typesArray}}, $type;
        }
        
    }

    sub addPlace
    {
        my ($self, $value) = @_;

        push @{$self->{placesArray}}, $value;
    }

    sub addAudios
    {
        my ($self, $value) = @_;

        my @audios = split m/,/, $value;
        foreach (@audios)
        {
            push @{$self->{audiosArray}}, $_;
        }
        
    }

    sub addSubs
    {
        my ($self, $value) = @_;

        my @subts = split m/,/, $value;
        foreach (@subts)
        {
            push @{$self->{subtsArray}}, $_;
        }
        
    }

    sub save
    {
        my $self = shift;

        $self->updateCurrent if ($self->{currentMovie} > -1);
        $self->addMarkedPictures;
        $self->removeMarkedPictures;

        if (!open DATA, ">".$self->{options}->file)
        {
            my  $dialog = Gtk2::MessageDialog->new($self->{parent},
                [qw/modal destroy-with-parent/],
                'error',
                'ok',
                $self->{parent}->{lang}->{SaveError});
            $dialog->run();
            $dialog->destroy ;
            return 0;
        }
        
        binmode( MOVIES, ':utf8' );

        printf DATA "GCfilms|%d|UTF8\n",$self->{nbMovies};

        my $line;
        my $i;
        for ($i = 0; $i < $self->{nbMovies}; $i++)
        {
            $line = join "|",
              $self->{movieArray}[$i]->{title},
              $self->{movieArray}[$i]->{date},
              $self->{movieArray}[$i]->{time},
              $self->{movieArray}[$i]->{director},
              $self->{movieArray}[$i]->{nat},
              $self->{movieArray}[$i]->{type},
              $self->{movieArray}[$i]->{image},
              $self->{movieArray}[$i]->{actors},
              $self->{movieArray}[$i]->{orig},
              $self->{movieArray}[$i]->{synopsis},
              $self->{movieArray}[$i]->{url};

            $line .= "|" . join "|",
              $self->{movieArray}[$i]->{seen},
              $self->{movieArray}[$i]->{format},
              $self->{movieArray}[$i]->{number},
              $self->{movieArray}[$i]->{place},
              $self->{movieArray}[$i]->{rating},
              $self->{movieArray}[$i]->{comment};
	      
          $line .= "|" . join "|",
              $self->{movieArray}[$i]->{audio},
              $self->{movieArray}[$i]->{subt},
              $self->{movieArray}[$i]->{borrower},
              $self->{movieArray}[$i]->{lendDate},
              $self->{movieArray}[$i]->{history},
              $self->{movieArray}[$i]->{age};

          $line = $self->{movieArray}[$i]->{id}."|".$line;

          printf DATA Encode::encode_utf8("$line\n");
        }
        close DATA;
        
        return 1;
    }
}

1;
