;; DFA-based pipeline description for I6400.
;;
;; Copyright (C) 2015 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "i6400_int_pipe, i6400_mdu_pipe, i6400_fpu_short_pipe,
		   i6400_fpu_long_pipe")

(define_cpu_unit "i6400_gpmuldiv" "i6400_mdu_pipe")
(define_cpu_unit "i6400_agen, i6400_alu1, i6400_lsu" "i6400_int_pipe")
(define_cpu_unit "i6400_control, i6400_ctu, i6400_alu0" "i6400_int_pipe")

;; Short FPU pipeline.
(define_cpu_unit "i6400_fpu_short" "i6400_fpu_short_pipe")

;; Long FPU pipeline.
(define_cpu_unit "i6400_fpu_long, i6400_fpu_apu" "i6400_fpu_long_pipe")

(define_reservation "i6400_control_ctu" "i6400_control, i6400_ctu")
(define_reservation "i6400_control_alu0" "i6400_control, i6400_alu0")
(define_reservation "i6400_agen_lsu" "i6400_agen, i6400_lsu")
(define_reservation "i6400_agen_alu1" "i6400_agen, i6400_alu1")

;;
;; FPU pipe
;;

;; fabs, fneg
(define_insn_reservation "i6400_fpu_fabs" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fabs,fneg,fmove"))
  "i6400_fpu_short, i6400_fpu_apu")

;; fadd, fsub, fcvt
(define_insn_reservation "i6400_fpu_fadd" 4
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fadd, fcvt"))
  "i6400_fpu_long, i6400_fpu_apu")

;; fmul
(define_insn_reservation "i6400_fpu_fmul" 5
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fmul"))
  "i6400_fpu_long, i6400_fpu_apu")

;; div, sqrt (Double Precision)
(define_insn_reservation "i6400_fpu_div_df" 30
  (and (eq_attr "cpu" "i6400")
       (and (eq_attr "mode" "DF")
	    (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")))
  "i6400_fpu_long+i6400_fpu_apu*30")

;; div, sqrt (Single Precision)
(define_insn_reservation "i6400_fpu_div_sf" 22
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt"))
  "i6400_fpu_long+i6400_fpu_apu*22")

;;
;; Integer pipe
;;

;; and, lui, shifts, seb, seh
(define_insn_reservation "i6400_int_logical" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "move_type" "logical,const,andi,sll0,signext"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; addi, addiu, ori, xori, add, addu, sub, nor
(define_insn_reservation "i6400_int_add" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "alu_type" "add,sub,or,xor,nor"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; shifts, clo, clz, cond move, arith
(define_insn_reservation "i6400_int_arith" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "shift,slt,move,clz,condmove,arith"))
  "i6400_control_alu0 | i6400_agen_alu1")

;; nop
(define_insn_reservation "i6400_int_nop" 0
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "nop"))
  "nothing")

;; mult, multu, mul
(define_insn_reservation "i6400_int_mult" 4
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "imul3,imul"))
  "i6400_gpmuldiv")

;; divide
(define_insn_reservation "i6400_int_div" 32
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "idiv"))
  "i6400_gpmuldiv*32")

;; Load lb, lbu, lh, lhu, lq, lw, lw_i2f, lwxs
(define_insn_reservation "i6400_int_load" 3
  (and (eq_attr "cpu" "i6400")
       (eq_attr "move_type" "load"))
  "i6400_agen_lsu")

;; store
(define_insn_reservation "i6400_int_store" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "move_type" "store"))
  "i6400_agen_lsu")

;; prefetch
(define_insn_reservation "i6400_int_prefetch" 3
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "prefetch"))
  "i6400_agen_lsu")

;; branch and jump
(define_insn_reservation "i6400_int_branch" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "type" "branch,jump"))
  "i6400_control_ctu")

;; call
(define_insn_reservation "i6400_int_call" 1
  (and (eq_attr "cpu" "i6400")
       (eq_attr "jal" "indirect,direct"))
  "i6400_control_ctu")
