/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "reread_conf.h"
#include "commands.h"
#include "reverse_address.h"
#include "populate_resource_treeview.h"

extern char global_domain_type[1024];
extern char global_domain_name[1024];
extern char global_domain_address[1024];

extern char global_resource_type[1024];
extern char global_resource_hostname[1024];
extern char global_resource_address[1024];

extern char CHROOT_PATH_BUF[1024];
extern int MAX_CONF_LINE;



void delete_resource(struct w *widgets)
{
    FILE *fp;
    long conf_size=0;
    char *new_conf;
    char *line;
    gchar *info;

    char *reverse_addr;
    char *tmp1, *tmp2, *tmp3, *tmp4;
    gchar *forward_zone_file;
    gchar *reverse_zone_file;
    gchar *reverse_ptr_addr;


    /* Delete the resource in the forward and reverse zones */
    if( strlen(global_domain_type)==0 )
    {
       info = g_strdup_printf(_("Missing domain type, resource not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }
    if( strlen(global_domain_name)==0 )
    {
       info = g_strdup_printf(_("Missing domain name, resource not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }
    if( strlen(global_domain_address)==0 )
    {
       info = g_strdup_printf(_("Missing forward domain address, resource not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }
    if( strlen(global_resource_type)==0 )
    {
       info = g_strdup_printf(_("Missing resource type, resource not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }
    if( strlen(global_resource_hostname)==0 )
    {
       info = g_strdup_printf(_("Missing resource hostname, resource not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }
    if( strlen(global_resource_address)==0 )
    {
       info = g_strdup_printf(_("Missing forward resource address, resource not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }



    /* FIXME, use CHROOT  */
    forward_zone_file = g_strdup_printf("%s/etc/sites/%s/forward.zone", CHROOT_PATH_BUF, global_domain_name);

    /* Delete the selected resource from the forward zone */
    if((fp=fopen(forward_zone_file, "r"))==NULL)
    {
        printf("Couldnt open the forward zone file:\n%s\n", forward_zone_file);
	g_free(forward_zone_file);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);
    line = allocate(conf_size+1);

    tmp1 = allocate(MAX_CONF_LINE);
    tmp2 = allocate(MAX_CONF_LINE);
    tmp3 = allocate(MAX_CONF_LINE);
    tmp4 = allocate(MAX_CONF_LINE);


    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) > MAX_CONF_LINE-3 )
	  continue;

	if( strlen(line) < 2 )
	  continue;
	
	tmp1[0]='\0', tmp2[0]='\0', tmp3[0]='\0', tmp4[0]='\0';
	sscanf(line, "%s %s %s %s", tmp1, tmp2, tmp3, tmp4);

	/* Dont collect the lines we should delete */
	if( !strcmp(global_resource_type, "NS-Record")
	&& ( !strcmp(tmp2, global_resource_hostname) || !strcmp(tmp3, global_resource_hostname) )
	&& ( !strcmp(tmp1, "NS") || !strcmp(tmp2, "NS") ) )
	{
	    printf("Deleting NS !!!\n");
	}
	else
	if( !strcmp(global_resource_type, "MX-Record")
	&& ( !strcmp(tmp3, global_resource_hostname) || !strcmp(tmp4, global_resource_hostname) )
	&& ( !strcmp(tmp1, "MX") || !strcmp(tmp2, "MX") ) )
	{
	    printf("Deleting MX\n");    
	}
	else
	if( !strcmp(global_resource_type, "A-Record") 
	&&   !strcmp(tmp1, global_resource_hostname) 
	&& ( !strcmp(tmp3, global_resource_address) || !strcmp(tmp4, global_resource_address) )
	&& ( !strcmp(tmp2, "A") || !strcmp(tmp3, "A") ) )
	{
	    printf("Deleting A\n");    
	}
	else
	if( !strcmp(global_resource_type, "AAAA-Record") 
	&&   !strcmp(tmp1, global_resource_hostname) 
	&& ( !strcmp(tmp3, global_resource_address) || !strcmp(tmp4, global_resource_address) )
	&& ( !strcmp(tmp2, "AAAA") || !strcmp(tmp3, "AAAA") ) )
	{
	    printf("Deleting AAAA\n");    
	}
	else
	if( !strcmp(global_resource_type, "CNAME-Record")
	&&   !strcmp(tmp1, global_resource_address)
	&& ( !strcmp(tmp3, global_resource_hostname) || !strcmp(tmp4, global_resource_hostname) )
	&& ( !strcmp(tmp2, "CNAME") || !strcmp(tmp3, "CNAME") ) )
	{
	    printf("Deleting CNAME\n");    
	}
	else
	  strcat(new_conf, line);
    }
    fclose(fp);


    /* Write the new forward zone */
    if((fp=fopen(forward_zone_file, "w+"))==NULL)
    {
        printf("Couldnt write the forward zone file: %s\n", forward_zone_file);
	free(new_conf);
	free(line);
	free(tmp1); free(tmp2); free(tmp3); free(tmp4);
	g_free(forward_zone_file);
        return;
    }
    fputs(new_conf, fp);

    free(new_conf);
    free(line);
    free(tmp1); free(tmp2); free(tmp3); free(tmp4);
    g_free(forward_zone_file);
    fclose(fp);





    /* Reverse zone resource deletion Begin! */




    /* Return if there should be no PTR for this record type */
    if( strcmp(global_resource_type, "NS-Record") 
    &&  strcmp(global_resource_type, "A-Record") 
    &&  strcmp(global_resource_type, "AAAA-Record") )
    {
	populate_resource_treeview(widgets);
	return;
    }


    reverse_zone_file = g_strdup_printf("%s/etc/sites/%s/reverse.zone", CHROOT_PATH_BUF, global_domain_name);

    /* Delete the selected resource from the reverse zone */
    if((fp=fopen(reverse_zone_file, "r"))==NULL)
    {
        printf("Couldnt open the reverse zone file:\n%s\n", reverse_zone_file);
	g_free(reverse_zone_file);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);
    line = allocate(conf_size+1);

    tmp1 = allocate(MAX_CONF_LINE);
    tmp2 = allocate(MAX_CONF_LINE);
    tmp3 = allocate(MAX_CONF_LINE);
    tmp4 = allocate(MAX_CONF_LINE);


    reverse_addr = reverse_address(global_resource_address);
    reverse_ptr_addr = g_strdup_printf("%s.in-addr.arpa.", reverse_addr);
    free(reverse_addr);

    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) > MAX_CONF_LINE-3 )
	  continue;

	if( strlen(line) < 2 )
	  continue;
	
	tmp1[0]='\0', tmp2[0]='\0', tmp3[0]='\0', tmp4[0]='\0';
	sscanf(line, "%s %s %s %s", tmp1, tmp2, tmp3, tmp4);

	/* Dont collect the lines we should delete */
	if( !strcmp(global_resource_type, "NS-Record")
	&& ( !strcmp(tmp2, global_resource_hostname) || !strcmp(tmp3, global_resource_hostname) )
	&& ( !strcmp(tmp1, "NS") || !strcmp(tmp2, "NS") ) )
	{
	    printf("Deleting Reverse NS: %s\n", line);
	}
	else
	if( !strcmp(global_resource_type, "A-Record")
	&&   !strcmp(tmp1, reverse_ptr_addr)
	&& ( !strcmp(tmp3, global_resource_hostname) || !strcmp(tmp4, global_resource_hostname) )
	&& ( !strcmp(tmp2, "PTR") || !strcmp(tmp3, "PTR") ) )
	{
	    printf("Deleting Reverse PTR: %s\n", line);
	}
	else
	  strcat(new_conf, line);
    }
    fclose(fp);


    /* Write the new conf */
    if((fp=fopen(reverse_zone_file, "w+"))==NULL)
    {
        printf("Couldnt write the reverse zone file: %s\n", reverse_zone_file);
	free(new_conf);
	g_free(reverse_zone_file);
	g_free(reverse_ptr_addr);
        return;
    }
    fputs(new_conf, fp);
    free(new_conf);
    g_free(reverse_zone_file);
    fclose(fp);

    g_free(reverse_ptr_addr);

    populate_resource_treeview(widgets);
}
