/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"

/* Wether or not to let the domain section expand */
#define EXPAND_DOMAIN_SECTION FALSE

/* Wether or not to let the resource section expand */
#define EXPAND_RESOURCE_SECTION TRUE


#include "domain_treeview_row_clicked.h"
#include "add_domain.h"
#include "delete_domain_from_btn.h"
#include "resource_treeview_row_clicked.h"
#include "add_resource.h"
#include "delete_resource_from_btn.h"
#include "resource_combo_changed.h"
#include "domain_settings_window.h"


void create_domain_tab(struct w *widgets)
{
    GtkCellRenderer *domain_cell_renderer, *resource_cell_renderer;
    GtkWidget *domain_treeview_hbox, *resource_treeview_hbox;
    GtkWidget *domain_scrolled_window, *resource_scrolled_window;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();
    
    gchar *utf8=NULL;
    gchar *combo_text;

    /* Create the domain treeview in a scrolled window */
    domain_treeview_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), domain_treeview_hbox, EXPAND_DOMAIN_SECTION, TRUE, 0);

    domain_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(domain_treeview_hbox), domain_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(domain_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(domain_scrolled_window, -1, 100);

    widgets->domain_store = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->domain_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->domain_treeview), GTK_TREE_MODEL(widgets->domain_store));

    gtk_container_add(GTK_CONTAINER(domain_scrolled_window), widgets->domain_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->domain_treeview), TRUE);

    /* Set the column labels in the treeview */
    domain_cell_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *domain_name_col = gtk_tree_view_column_new_with_attributes(_("Domain name"), domain_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->domain_treeview), GTK_TREE_VIEW_COLUMN(domain_name_col));

    GtkTreeViewColumn *network_address_col = gtk_tree_view_column_new_with_attributes(_("Forward network address or range"), domain_cell_renderer, "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->domain_treeview), GTK_TREE_VIEW_COLUMN(network_address_col));

    GtkTreeViewColumn *dns_type_col = gtk_tree_view_column_new_with_attributes(_("DNS Type"), domain_cell_renderer, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->domain_treeview), GTK_TREE_VIEW_COLUMN(dns_type_col));

    g_signal_connect((gpointer)widgets->domain_treeview, "button_press_event",  
		      G_CALLBACK(domain_treeview_row_clicked), widgets);

    /* The add/delete domain entries and buttons */
    GtkWidget *domain_add_hbox1 = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), domain_add_hbox1, FALSE, FALSE, 0);

    GtkWidget *domain_add_hbox2 = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), domain_add_hbox2, FALSE, FALSE, 0);

    GtkWidget *domain_del_hbox = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), domain_del_hbox, FALSE, FALSE, 0);

    widgets->add_domain_name_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), widgets->add_domain_name_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->add_domain_name_entry, "yoursite.org or anothersite.yoursite.org", NULL);

    widgets->add_domain_address_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), widgets->add_domain_address_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->add_domain_address_entry, "192.168.0, 192.168.0-1-50 or 2001:0db8:85a3:08d3:1319:8a2e:0370", NULL);

    /* Domain type combo */
    widgets->add_domain_type_combo = gtk_combo_box_new_text();
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), widgets->add_domain_type_combo, TRUE, TRUE, 0);

    combo_text = g_strdup_printf(_("master"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_domain_type_combo), utf8);

    combo_text = g_strdup_printf(_("slave"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_domain_type_combo), utf8);
    /* Set this combo position as selected (Master) */
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->add_domain_type_combo), 0);
    g_free(combo_text);


    GtkWidget *domain_spacer_label_add1 = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_spacer_label_add1, FALSE, FALSE, 2);

    /* The add domain button */
    GtkWidget *domain_add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_add_button, FALSE, FALSE, 0);

    g_signal_connect_swapped(G_OBJECT(domain_add_button), "clicked", 
                             G_CALLBACK(add_domain), widgets);

    GtkWidget *domain_spacer_label_add2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_spacer_label_add2, FALSE, FALSE, 2);

    /* The delete domain button */
    GtkWidget *domain_del_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_del_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(domain_del_button), "clicked", 
                             G_CALLBACK(delete_domain_from_btn), widgets);
    gtk_tooltips_set_tip(tooltips, domain_del_button, _("Delete the selected domain."), NULL);

    GtkWidget *domain_spacer_label_del2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_spacer_label_del2, FALSE, FALSE, 2);



    /* The change domain button */
    GtkWidget *domain_change_button = gtk_button_new();
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_change_button, FALSE, FALSE, 0);
    gtk_tooltips_set_tip(tooltips, domain_change_button, _("Make changes to the selected domain."), NULL);

    GtkWidget *alignment60 = gtk_alignment_new(0.5, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(domain_change_button), alignment60);

    GtkWidget *hbox73 = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(alignment60), hbox73);
    GtkWidget *image40 = gtk_image_new_from_stock("gtk-refresh", GTK_ICON_SIZE_BUTTON);
    gtk_box_pack_start(GTK_BOX(hbox73), image40, FALSE, FALSE, 0);

    GtkWidget *label115 = gtk_label_new_with_mnemonic(_("Change"));
    gtk_box_pack_start(GTK_BOX(hbox73), label115, FALSE, FALSE, 0);
    gtk_label_set_justify(GTK_LABEL(label115), GTK_JUSTIFY_LEFT);

    g_signal_connect_swapped(G_OBJECT(domain_change_button), "clicked", 
                             G_CALLBACK(show_domain_settings_window), widgets);

    /* Adds some space to the right side of the button VS scrollbar */
    GtkWidget *domain_spacer_label_change = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(domain_add_hbox2), domain_spacer_label_change, FALSE, FALSE, 10);



    /* Some space between the 2 treeviews */
    GtkWidget *views_spacer_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), views_spacer_hbox, FALSE, FALSE, 0);
    GtkWidget *views_label = gtk_label_new("\nDomain Resources");
    gtk_box_pack_start(GTK_BOX(views_spacer_hbox), views_label, FALSE, FALSE, 10);



    /* Domain resources */

    /* Create the resource treeview in a scrolled window */
    resource_treeview_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), resource_treeview_hbox, EXPAND_RESOURCE_SECTION, TRUE, 0);

    resource_scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(resource_treeview_hbox), resource_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(resource_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(resource_scrolled_window, -1, 100);

    widgets->resource_store = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->resource_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->resource_treeview), GTK_TREE_MODEL(widgets->resource_store));

    gtk_container_add(GTK_CONTAINER(resource_scrolled_window), widgets->resource_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->resource_treeview), TRUE);

    /* Set the column labels in the treeview */
    resource_cell_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *resource_name_col = gtk_tree_view_column_new_with_attributes(_("Resource type"), resource_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->resource_treeview), GTK_TREE_VIEW_COLUMN(resource_name_col));

    GtkTreeViewColumn *resource_hostname_col = gtk_tree_view_column_new_with_attributes(_("Hostname+Domainname"), resource_cell_renderer, "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->resource_treeview), GTK_TREE_VIEW_COLUMN(resource_hostname_col));

    GtkTreeViewColumn *resource_ipaddress_col = gtk_tree_view_column_new_with_attributes(_("IP-address, MX Mailserver priority or CNAME host alias"), resource_cell_renderer, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->resource_treeview), GTK_TREE_VIEW_COLUMN(resource_ipaddress_col));

    g_signal_connect((gpointer)widgets->resource_treeview, "button_press_event",  
		      G_CALLBACK(resource_treeview_row_clicked), widgets);


    /* The add/delete resource entries and buttons */
    GtkWidget *resource_add_hbox1 = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), resource_add_hbox1, FALSE, FALSE, 0);

    GtkWidget *resource_add_hbox2 = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), resource_add_hbox2, FALSE, FALSE, 0);

    GtkWidget *resource_del_hbox = gtk_hbox_new(FALSE,FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), resource_del_hbox, FALSE, FALSE, 0);

    /* The resource combo box and selections */
    widgets->add_resource_type_combo = gtk_combo_box_new_text();
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), widgets->add_resource_type_combo, FALSE, FALSE, 0);

    combo_text = g_strdup_printf("Nameserver (NS-Record)");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_resource_type_combo), utf8);

    combo_text = g_strdup_printf("Mailserver (MX)");    
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_resource_type_combo), utf8);

    combo_text = g_strdup_printf("Authoritive (IPv4 A-Record)");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_resource_type_combo), utf8);

    combo_text = g_strdup_printf("Authoritive (IPv6 AAAA-Record)");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_resource_type_combo), utf8);

    combo_text = g_strdup_printf("Machine alias (CNAME)");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->add_resource_type_combo), utf8);

    /* Set this combo position as selected */
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->add_resource_type_combo), 0);

    g_free(combo_text);

    /* A selection made callback for setting new tooltips */
    g_signal_connect_swapped(G_OBJECT(widgets->add_resource_type_combo), "changed", 
                             G_CALLBACK(resource_combo_changed), widgets);


    /* Create the tooltips for the resource combo */
    widgets->resource_hostname_tooltip = gtk_tooltips_new();
    widgets->resource_address_tooltip  = gtk_tooltips_new();

    widgets->add_resource_hostname_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), widgets->add_resource_hostname_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(widgets->resource_hostname_tooltip, widgets->add_resource_hostname_entry, "A DNS server: dns1.yourdomain.org", NULL);

    widgets->add_resource_address_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), widgets->add_resource_address_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(widgets->resource_address_tooltip, widgets->add_resource_address_entry, "192.168.0.1 or 5F05:2000:80AD:5800:0058:0800:2023:1D71", NULL);


    GtkWidget *resource_spacer_label_add1 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), resource_spacer_label_add1, FALSE, FALSE, 2);

    /* The add resource button */
    GtkWidget *resource_add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), resource_add_button, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(resource_add_button), "clicked", 
                             G_CALLBACK(add_resource), widgets);


    GtkWidget *resource_spacer_label_add2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), resource_spacer_label_add2, FALSE, FALSE, 2);

    /* The delete resource button */
    GtkWidget *resource_del_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), resource_del_button, FALSE, FALSE, 0);

    g_signal_connect_swapped(G_OBJECT(resource_del_button), "clicked", 
                             G_CALLBACK(delete_resource_from_btn), widgets);

    gtk_tooltips_set_tip(tooltips, resource_del_button, _("Delete the selected resource."), NULL);

    GtkWidget *resource_spacer_label_del2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(resource_add_hbox2), resource_spacer_label_del2, FALSE, FALSE, 10);


    /* Some space between the last treeview and the bottom of the app */
    GtkWidget *lastview_spacer_hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), lastview_spacer_hbox, FALSE, FALSE, 0);
    GtkWidget *lastview_label = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(lastview_spacer_hbox), lastview_label, FALSE, FALSE, 10);


    if( utf8 != NULL )
      g_free(utf8);
}
