/*
 * Copyright (C) 2012-2015 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#ifndef TEST_HEIGHTS_CMP_H_
#define TEST_HEIGHTS_CMP_H_

#ifdef __GNUC__
    #define MAYBE_UNUSED __attribute__((used))
#elif defined _MSC_VER
    #pragma warning(disable: Cxxxxx)
    #define MAYBE_UNUSED
#else
    #define MAYBE_UNUSED
#endif

static float __heights[] = {
0.000000, 0.019685, 0.039370, 0.059055, 0.078740, 0.098425, 0.118110,
0.137795, 0.157480, 0.177165, 0.196850, 0.216535, 0.236220, 0.255906,
0.275591, 0.295276, 0.314961, 0.334646, 0.354331, 0.374016, 0.393701,
0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496,
0.551181, 0.570866, 0.590551, 0.610236, 0.629921, 0.649606, 0.669291,
0.688976, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087,
0.826772, 0.846457, 0.866142, 0.885827, 0.905512, 0.925197, 0.944882,
0.964567, 0.984252, 1.003937, 1.023622, 1.043307, 1.062992, 1.082677,
1.102362, 1.122047, 1.141732, 1.161417, 1.181102, 1.200787, 1.220472,
1.240157, 1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.348425,
1.358268, 1.368110, 1.377953, 1.407480, 1.437008, 1.466535, 1.496063,
1.505906, 1.515748, 1.525591, 1.535433, 1.564961, 1.594488, 1.624016,
1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.742126, 1.751969,
1.761811, 1.771654, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079,
1.889764, 1.909449, 1.929134, 1.958661, 1.988189, 2.017717, 2.047244,
2.066929, 2.086614, 2.106299, 2.125984, 2.135827, 2.145669, 2.155512,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.273622, 2.303150,
2.332677, 2.362205, 2.372047, 2.381890, 2.391732, 2.401575, 2.431102,
2.460630, 2.490157, 2.519685, 0.019685, 0.034449, 0.049213, 0.063976,
0.078740, 0.098425, 0.118110, 0.137795, 0.157480, 0.177165, 0.196850,
0.216535, 0.236220, 0.255906, 0.275591, 0.295276, 0.314961, 0.334646,
0.354331, 0.374016, 0.393701, 0.413386, 0.433071, 0.452756, 0.472441,
0.492126, 0.511811, 0.531496, 0.551181, 0.570866, 0.590551, 0.610236,
0.629921, 0.649606, 0.669291, 0.688976, 0.708661, 0.728346, 0.748031,
0.767717, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142, 0.885827,
0.905512, 0.925197, 0.944882, 0.964567, 0.984252, 1.003937, 1.023622,
1.043307, 1.062992, 1.082677, 1.102362, 1.119587, 1.136811, 1.154035,
1.171260, 1.193406, 1.215551, 1.237697, 1.259843, 1.279528, 1.299213,
1.318898, 1.338583, 1.350886, 1.363189, 1.375492, 1.387795, 1.412402,
1.437008, 1.461614, 1.486220, 1.498524, 1.510827, 1.523130, 1.535433,
1.562500, 1.589567, 1.616634, 1.643701, 1.665846, 1.687992, 1.710138,
1.732283, 1.744587, 1.756890, 1.769193, 1.781496, 1.798720, 1.815945,
1.833169, 1.850394, 1.872539, 1.894685, 1.916831, 1.938976, 1.963583,
1.988189, 2.012795, 2.037402, 2.059547, 2.081693, 2.103839, 2.125984,
2.135827, 2.145669, 2.155512, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.271161, 2.298228, 2.325295, 2.352362, 2.364665, 2.376969,
2.389272, 2.401575, 2.428642, 2.455709, 2.482776, 2.509843, 0.039370,
0.049213, 0.059055, 0.068898, 0.078740, 0.098425, 0.118110, 0.137795,
0.157480, 0.177165, 0.196850, 0.216535, 0.236220, 0.255906, 0.275591,
0.295276, 0.314961, 0.334646, 0.354331, 0.374016, 0.393701, 0.413386,
0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496, 0.551181,
0.570866, 0.590551, 0.610236, 0.629921, 0.649606, 0.669291, 0.688976,
0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087, 0.826772,
0.846457, 0.866142, 0.885827, 0.905512, 0.925197, 0.944882, 0.964567,
0.984252, 1.003937, 1.023622, 1.043307, 1.062992, 1.082677, 1.102362,
1.117126, 1.131890, 1.146654, 1.161417, 1.186024, 1.210630, 1.235236,
1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.353346, 1.368110,
1.382874, 1.397638, 1.417323, 1.437008, 1.456693, 1.476378, 1.491142,
1.505906, 1.520669, 1.535433, 1.560039, 1.584646, 1.609252, 1.633858,
1.658465, 1.683071, 1.707677, 1.732283, 1.747047, 1.761811, 1.776575,
1.791339, 1.806102, 1.820866, 1.835630, 1.850394, 1.875000, 1.899606,
1.924213, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559, 2.052165,
2.076772, 2.101378, 2.125984, 2.135827, 2.145669, 2.155512, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.268701, 2.293307, 2.317913,
2.342520, 2.357284, 2.372047, 2.386811, 2.401575, 2.426181, 2.450787,
2.475394, 2.500000, 0.059055, 0.063976, 0.068898, 0.073819, 0.078740,
0.098425, 0.118110, 0.137795, 0.157480, 0.177165, 0.196850, 0.216535,
0.236220, 0.255906, 0.275591, 0.295276, 0.314961, 0.334646, 0.354331,
0.374016, 0.393701, 0.413386, 0.433071, 0.452756, 0.472441, 0.492126,
0.511811, 0.531496, 0.551181, 0.570866, 0.590551, 0.610236, 0.629921,
0.649606, 0.669291, 0.688976, 0.708661, 0.728346, 0.748031, 0.767717,
0.787402, 0.807087, 0.826772, 0.846457, 0.866142, 0.885827, 0.905512,
0.925197, 0.944882, 0.964567, 0.984252, 1.003937, 1.023622, 1.043307,
1.062992, 1.082677, 1.102362, 1.114665, 1.126969, 1.139272, 1.151575,
1.178642, 1.205709, 1.232776, 1.259843, 1.279528, 1.299213, 1.318898,
1.338583, 1.355807, 1.373032, 1.390256, 1.407480, 1.422244, 1.437008,
1.451772, 1.466535, 1.483760, 1.500984, 1.518209, 1.535433, 1.557579,
1.579724, 1.601870, 1.624016, 1.651083, 1.678150, 1.705217, 1.732283,
1.749508, 1.766732, 1.783957, 1.801181, 1.813484, 1.825787, 1.838091,
1.850394, 1.877461, 1.904528, 1.931594, 1.958661, 1.973425, 1.988189,
2.002953, 2.017717, 2.044784, 2.071851, 2.098917, 2.125984, 2.135827,
2.145669, 2.155512, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095,
2.266240, 2.288386, 2.310532, 2.332677, 2.349902, 2.367126, 2.384350,
2.401575, 2.423720, 2.445866, 2.468012, 2.490158, 0.078740, 0.078740,
0.078740, 0.078740, 0.078740, 0.098425, 0.118110, 0.137795, 0.157480,
0.177165, 0.196850, 0.216535, 0.236220, 0.255906, 0.275591, 0.295276,
0.314961, 0.334646, 0.354331, 0.374016, 0.393701, 0.413386, 0.433071,
0.452756, 0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.570866,
0.590551, 0.610236, 0.629921, 0.649606, 0.669291, 0.688976, 0.708661,
0.728346, 0.748031, 0.767717, 0.787402, 0.807087, 0.826772, 0.846457,
0.866142, 0.885827, 0.905512, 0.925197, 0.944882, 0.964567, 0.984252,
1.003937, 1.023622, 1.043307, 1.062992, 1.082677, 1.102362, 1.112205,
1.122047, 1.131890, 1.141732, 1.171260, 1.200787, 1.230315, 1.259843,
1.279528, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638,
1.417323, 1.427165, 1.437008, 1.446850, 1.456693, 1.476378, 1.496063,
1.515748, 1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.643701,
1.673228, 1.702756, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024,
1.820866, 1.830709, 1.840551, 1.850394, 1.879921, 1.909449, 1.938976,
1.968504, 1.978346, 1.988189, 1.998031, 2.007874, 2.037402, 2.066929,
2.096457, 2.125984, 2.135827, 2.145669, 2.155512, 2.165354, 2.185039,
2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835,
2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630,
2.480315, 0.098425, 0.098425, 0.098425, 0.098425, 0.098425, 0.113189,
0.127953, 0.142717, 0.157480, 0.177165, 0.196850, 0.216535, 0.236220,
0.255906, 0.275591, 0.295276, 0.314961, 0.334646, 0.354331, 0.374016,
0.393701, 0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811,
0.531496, 0.551181, 0.570866, 0.590551, 0.610236, 0.629921, 0.649606,
0.669291, 0.688976, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402,
0.804626, 0.821850, 0.839075, 0.856299, 0.875984, 0.895669, 0.915354,
0.935039, 0.957185, 0.979331, 1.001476, 1.023622, 1.040846, 1.058071,
1.075295, 1.092520, 1.107283, 1.122047, 1.136811, 1.151575, 1.176181,
1.200787, 1.225394, 1.250000, 1.269685, 1.289370, 1.309055, 1.328740,
1.348425, 1.368110, 1.387795, 1.407480, 1.422244, 1.437008, 1.451772,
1.466535, 1.483760, 1.500984, 1.518209, 1.535433, 1.557579, 1.579724,
1.601870, 1.624016, 1.651083, 1.678150, 1.705217, 1.732283, 1.751969,
1.771654, 1.791339, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394,
1.877461, 1.904528, 1.931594, 1.958661, 1.970965, 1.983268, 1.995571,
2.007874, 2.034941, 2.062008, 2.089075, 2.116142, 2.130906, 2.145669,
2.160433, 2.175197, 2.192421, 2.209646, 2.226870, 2.244095, 2.263780,
2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575,
2.421260, 2.440945, 2.460630, 2.480315, 0.118110, 0.118110, 0.118110,
0.118110, 0.118110, 0.127953, 0.137795, 0.147638, 0.157480, 0.177165,
0.196850, 0.216535, 0.236220, 0.255906, 0.275591, 0.295276, 0.314961,
0.334646, 0.354331, 0.374016, 0.393701, 0.413386, 0.433071, 0.452756,
0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.570866, 0.590551,
0.610236, 0.629921, 0.649606, 0.669291, 0.688976, 0.708661, 0.728346,
0.748031, 0.767717, 0.787402, 0.802165, 0.816929, 0.831693, 0.846457,
0.866142, 0.885827, 0.905512, 0.925197, 0.949803, 0.974409, 0.999016,
1.023622, 1.038386, 1.053150, 1.067913, 1.082677, 1.102362, 1.122047,
1.141732, 1.161417, 1.181102, 1.200787, 1.220472, 1.240157, 1.259843,
1.279528, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638,
1.417323, 1.437008, 1.456693, 1.476378, 1.491142, 1.505906, 1.520669,
1.535433, 1.560039, 1.584646, 1.609252, 1.633858, 1.658465, 1.683071,
1.707677, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.820866,
1.830709, 1.840551, 1.850394, 1.875000, 1.899606, 1.924213, 1.948819,
1.963583, 1.978346, 1.993110, 2.007874, 2.032480, 2.057087, 2.081693,
2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.199803, 2.214567,
2.229331, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520,
2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
0.137795, 0.137795, 0.137795, 0.137795, 0.137795, 0.142717, 0.147638,
0.152559, 0.157480, 0.177165, 0.196850, 0.216535, 0.236220, 0.255906,
0.275591, 0.295276, 0.314961, 0.334646, 0.354331, 0.374016, 0.393701,
0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496,
0.551181, 0.570866, 0.590551, 0.610236, 0.629921, 0.649606, 0.669291,
0.688976, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.799705,
0.812008, 0.824311, 0.836614, 0.856299, 0.875984, 0.895669, 0.915354,
0.942421, 0.969488, 0.996555, 1.023622, 1.035925, 1.048228, 1.060531,
1.072835, 1.097441, 1.122047, 1.146654, 1.171260, 1.186024, 1.200787,
1.215551, 1.230315, 1.250000, 1.269685, 1.289370, 1.309055, 1.328740,
1.348425, 1.368110, 1.387795, 1.412402, 1.437008, 1.461614, 1.486220,
1.498524, 1.510827, 1.523130, 1.535433, 1.562500, 1.589567, 1.616634,
1.643701, 1.665846, 1.687992, 1.710138, 1.732283, 1.751969, 1.771654,
1.791339, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394, 1.872539,
1.894685, 1.916831, 1.938976, 1.956201, 1.973425, 1.990650, 2.007874,
2.030020, 2.052165, 2.074311, 2.096457, 2.121063, 2.145669, 2.170276,
2.194882, 2.207185, 2.219488, 2.231791, 2.244095, 2.263780, 2.283465,
2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.421260,
2.440945, 2.460630, 2.480315, 0.157480, 0.157480, 0.157480, 0.157480,
0.157480, 0.157480, 0.157480, 0.157480, 0.157480, 0.177165, 0.196850,
0.216535, 0.236220, 0.255906, 0.275591, 0.295276, 0.314961, 0.334646,
0.354331, 0.374016, 0.393701, 0.413386, 0.433071, 0.452756, 0.472441,
0.492126, 0.511811, 0.531496, 0.551181, 0.570866, 0.590551, 0.610236,
0.629921, 0.649606, 0.669291, 0.688976, 0.708661, 0.728346, 0.748031,
0.767717, 0.787402, 0.797244, 0.807087, 0.816929, 0.826772, 0.846457,
0.866142, 0.885827, 0.905512, 0.935039, 0.964567, 0.994094, 1.023622,
1.033465, 1.043307, 1.053150, 1.062992, 1.092520, 1.122047, 1.151575,
1.181102, 1.190945, 1.200787, 1.210630, 1.220472, 1.240157, 1.259843,
1.279528, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.407480,
1.437008, 1.466535, 1.496063, 1.505906, 1.515748, 1.525591, 1.535433,
1.564961, 1.594488, 1.624016, 1.653543, 1.673228, 1.692913, 1.712598,
1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.820866, 1.830709,
1.840551, 1.850394, 1.870079, 1.889764, 1.909449, 1.929134, 1.948819,
1.968504, 1.988189, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614,
2.116142, 2.145669, 2.175197, 2.204724, 2.214567, 2.224410, 2.234252,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205,
2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 0.177165,
0.177165, 0.177165, 0.177165, 0.177165, 0.177165, 0.177165, 0.177165,
0.177165, 0.194390, 0.211614, 0.228839, 0.246063, 0.268209, 0.290354,
0.312500, 0.334646, 0.354331, 0.374016, 0.393701, 0.413386, 0.433071,
0.452756, 0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.570866,
0.590551, 0.610236, 0.629921, 0.649606, 0.669291, 0.688976, 0.708661,
0.728346, 0.748031, 0.767717, 0.787402, 0.807087, 0.816929, 0.826772,
0.836614, 0.846457, 0.868602, 0.890748, 0.912894, 0.935039, 0.962106,
0.989173, 1.016240, 1.043307, 1.053150, 1.062992, 1.072835, 1.082677,
1.112205, 1.141732, 1.171260, 1.200787, 1.213091, 1.225394, 1.237697,
1.250000, 1.269685, 1.289370, 1.309055, 1.328740, 1.345965, 1.363189,
1.380413, 1.397638, 1.427165, 1.456693, 1.486220, 1.515748, 1.528051,
1.540354, 1.552657, 1.564961, 1.592028, 1.619094, 1.646161, 1.673228,
1.692913, 1.712598, 1.732283, 1.751969, 1.769193, 1.786417, 1.803642,
1.820866, 1.835630, 1.850394, 1.865157, 1.879921, 1.899606, 1.919291,
1.938976, 1.958661, 1.975886, 1.993110, 2.010335, 2.027559, 2.047244,
2.066929, 2.086614, 2.106299, 2.133366, 2.160433, 2.187500, 2.214567,
2.226870, 2.239173, 2.251476, 2.263780, 2.283465, 2.303150, 2.322835,
2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630,
2.480315, 2.500000, 0.196850, 0.196850, 0.196850, 0.196850, 0.196850,
0.196850, 0.196850, 0.196850, 0.196850, 0.211614, 0.226378, 0.241142,
0.255906, 0.280512, 0.305118, 0.329724, 0.354331, 0.374016, 0.393701,
0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496,
0.551181, 0.570866, 0.590551, 0.610236, 0.629921, 0.649606, 0.669291,
0.688976, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087,
0.826772, 0.836614, 0.846457, 0.856299, 0.866142, 0.890748, 0.915354,
0.939961, 0.964567, 0.989173, 1.013780, 1.038386, 1.062992, 1.072835,
1.082677, 1.092520, 1.102362, 1.131890, 1.161417, 1.190945, 1.220472,
1.235236, 1.250000, 1.264764, 1.279528, 1.299213, 1.318898, 1.338583,
1.358268, 1.373032, 1.387795, 1.402559, 1.417323, 1.446850, 1.476378,
1.505906, 1.535433, 1.550197, 1.564961, 1.579724, 1.594488, 1.619094,
1.643701, 1.668307, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654,
1.786417, 1.801181, 1.815945, 1.830709, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.002953, 2.017717,
2.032480, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.150591,
2.175197, 2.199803, 2.224410, 2.239173, 2.253937, 2.268701, 2.283465,
2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.421260,
2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 0.216535, 0.216535,
0.216535, 0.216535, 0.216535, 0.216535, 0.216535, 0.216535, 0.216535,
0.228839, 0.241142, 0.253445, 0.265748, 0.292815, 0.319882, 0.346949,
0.374016, 0.393701, 0.413386, 0.433071, 0.452756, 0.472441, 0.492126,
0.511811, 0.531496, 0.551181, 0.570866, 0.590551, 0.610236, 0.629921,
0.649606, 0.669291, 0.688976, 0.708661, 0.728346, 0.748031, 0.767717,
0.787402, 0.807087, 0.826772, 0.846457, 0.856299, 0.866142, 0.875984,
0.885827, 0.912894, 0.939961, 0.967028, 0.994094, 1.016240, 1.038386,
1.060531, 1.082677, 1.092520, 1.102362, 1.112205, 1.122047, 1.151575,
1.181102, 1.210630, 1.240157, 1.257382, 1.274606, 1.291831, 1.309055,
1.328740, 1.348425, 1.368110, 1.387795, 1.400098, 1.412402, 1.424705,
1.437008, 1.466535, 1.496063, 1.525591, 1.555118, 1.572343, 1.589567,
1.606791, 1.624016, 1.646161, 1.668307, 1.690453, 1.712598, 1.732283,
1.751969, 1.771654, 1.791339, 1.803642, 1.815945, 1.828248, 1.840551,
1.865157, 1.889764, 1.914370, 1.938976, 1.958661, 1.978346, 1.998031,
2.017717, 2.030020, 2.042323, 2.054626, 2.066929, 2.086614, 2.106299,
2.125984, 2.145669, 2.167815, 2.189961, 2.212106, 2.234252, 2.251476,
2.268701, 2.285925, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890,
2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685,
2.539370, 0.236220, 0.236220, 0.236220, 0.236220, 0.236220, 0.236220,
0.236220, 0.236220, 0.236220, 0.246063, 0.255906, 0.265748, 0.275591,
0.305118, 0.334646, 0.364173, 0.393701, 0.413386, 0.433071, 0.452756,
0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.570866, 0.590551,
0.610236, 0.629921, 0.649606, 0.669291, 0.688976, 0.708661, 0.728346,
0.748031, 0.767717, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142,
0.875984, 0.885827, 0.895669, 0.905512, 0.935039, 0.964567, 0.994094,
1.023622, 1.043307, 1.062992, 1.082677, 1.102362, 1.112205, 1.122047,
1.131890, 1.141732, 1.171260, 1.200787, 1.230315, 1.259843, 1.279528,
1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.417323,
1.427165, 1.437008, 1.446850, 1.456693, 1.486220, 1.515748, 1.545276,
1.574803, 1.594488, 1.614173, 1.633858, 1.653543, 1.673228, 1.692913,
1.712598, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.820866,
1.830709, 1.840551, 1.850394, 1.879921, 1.909449, 1.938976, 1.968504,
1.988189, 2.007874, 2.027559, 2.047244, 2.057087, 2.066929, 2.076772,
2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724,
2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520,
2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 0.255906, 0.255906, 0.255906,
0.255906, 0.255906, 0.255906, 0.255906, 0.255906, 0.255906, 0.263287,
0.270669, 0.278051, 0.285433, 0.312500, 0.339567, 0.366634, 0.393701,
0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496,
0.551181, 0.568406, 0.585630, 0.602854, 0.620079, 0.642224, 0.664370,
0.686516, 0.708661, 0.725886, 0.743110, 0.760335, 0.777559, 0.799705,
0.821850, 0.843996, 0.866142, 0.878445, 0.890748, 0.903051, 0.915354,
0.942421, 0.969488, 0.996555, 1.023622, 1.040846, 1.058071, 1.075295,
1.092520, 1.107283, 1.122047, 1.136811, 1.151575, 1.176181, 1.200787,
1.225394, 1.250000, 1.269685, 1.289370, 1.309055, 1.328740, 1.348425,
1.368110, 1.387795, 1.407480, 1.419783, 1.432087, 1.444390, 1.456693,
1.486220, 1.515748, 1.545276, 1.574803, 1.592028, 1.609252, 1.626476,
1.643701, 1.665846, 1.687992, 1.710138, 1.732283, 1.749508, 1.766732,
1.783957, 1.801181, 1.815945, 1.830709, 1.845472, 1.860236, 1.884843,
1.909449, 1.934055, 1.958661, 1.978346, 1.998031, 2.017717, 2.037402,
2.052165, 2.066929, 2.081693, 2.096457, 2.113681, 2.130906, 2.148130,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465,
2.303150, 2.322835, 2.344980, 2.367126, 2.389272, 2.411417, 2.428642,
2.445866, 2.463091, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
0.275591, 0.275591, 0.275591, 0.275591, 0.275591, 0.275591, 0.275591,
0.275591, 0.275591, 0.280512, 0.285433, 0.290354, 0.295276, 0.319882,
0.344488, 0.369094, 0.393701, 0.413386, 0.433071, 0.452756, 0.472441,
0.492126, 0.511811, 0.531496, 0.551181, 0.565945, 0.580709, 0.595472,
0.610236, 0.634843, 0.659449, 0.684055, 0.708661, 0.723425, 0.738189,
0.752953, 0.767717, 0.792323, 0.816929, 0.841535, 0.866142, 0.880906,
0.895669, 0.910433, 0.925197, 0.949803, 0.974409, 0.999016, 1.023622,
1.038386, 1.053150, 1.067913, 1.082677, 1.102362, 1.122047, 1.141732,
1.161417, 1.181102, 1.200787, 1.220472, 1.240157, 1.259843, 1.279528,
1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.412402,
1.427165, 1.441929, 1.456693, 1.486220, 1.515748, 1.545276, 1.574803,
1.589567, 1.604331, 1.619094, 1.633858, 1.658465, 1.683071, 1.707677,
1.732283, 1.747047, 1.761811, 1.776575, 1.791339, 1.811024, 1.830709,
1.850394, 1.870079, 1.889764, 1.909449, 1.929134, 1.948819, 1.968504,
1.988189, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.106299,
2.121063, 2.135827, 2.150591, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.347441, 2.372047,
2.396654, 2.421260, 2.436024, 2.450787, 2.465551, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 0.295276, 0.295276, 0.295276, 0.295276,
0.295276, 0.295276, 0.295276, 0.295276, 0.295276, 0.297736, 0.300197,
0.302657, 0.305118, 0.327264, 0.349409, 0.371555, 0.393701, 0.413386,
0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496, 0.551181,
0.563484, 0.575787, 0.588091, 0.600394, 0.627461, 0.654528, 0.681595,
0.708661, 0.720965, 0.733268, 0.745571, 0.757874, 0.784941, 0.812008,
0.839075, 0.866142, 0.883366, 0.900591, 0.917815, 0.935039, 0.957185,
0.979331, 1.001476, 1.023622, 1.035925, 1.048228, 1.060531, 1.072835,
1.097441, 1.122047, 1.146654, 1.171260, 1.186024, 1.200787, 1.215551,
1.230315, 1.250000, 1.269685, 1.289370, 1.309055, 1.328740, 1.348425,
1.368110, 1.387795, 1.405020, 1.422244, 1.439469, 1.456693, 1.486220,
1.515748, 1.545276, 1.574803, 1.587106, 1.599409, 1.611713, 1.624016,
1.651083, 1.678150, 1.705217, 1.732283, 1.744587, 1.756890, 1.769193,
1.781496, 1.806102, 1.830709, 1.855315, 1.879921, 1.894685, 1.909449,
1.924213, 1.938976, 1.958661, 1.978346, 1.998031, 2.017717, 2.042323,
2.066929, 2.091536, 2.116142, 2.128445, 2.140748, 2.153051, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150,
2.322835, 2.349902, 2.376969, 2.404035, 2.431102, 2.443406, 2.455709,
2.468012, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 0.314961,
0.314961, 0.314961, 0.314961, 0.314961, 0.314961, 0.314961, 0.314961,
0.314961, 0.314961, 0.314961, 0.314961, 0.314961, 0.334646, 0.354331,
0.374016, 0.393701, 0.413386, 0.433071, 0.452756, 0.472441, 0.492126,
0.511811, 0.531496, 0.551181, 0.561024, 0.570866, 0.580709, 0.590551,
0.620079, 0.649606, 0.679134, 0.708661, 0.718504, 0.728346, 0.738189,
0.748031, 0.777559, 0.807087, 0.836614, 0.866142, 0.885827, 0.905512,
0.925197, 0.944882, 0.964567, 0.984252, 1.003937, 1.023622, 1.033465,
1.043307, 1.053150, 1.062992, 1.092520, 1.122047, 1.151575, 1.181102,
1.190945, 1.200787, 1.210630, 1.220472, 1.240157, 1.259843, 1.279528,
1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.417323,
1.437008, 1.456693, 1.486220, 1.515748, 1.545276, 1.574803, 1.584646,
1.594488, 1.604331, 1.614173, 1.643701, 1.673228, 1.702756, 1.732283,
1.742126, 1.751969, 1.761811, 1.771654, 1.801181, 1.830709, 1.860236,
1.889764, 1.899606, 1.909449, 1.919291, 1.929134, 1.948819, 1.968504,
1.988189, 2.007874, 2.037402, 2.066929, 2.096457, 2.125984, 2.135827,
2.145669, 2.155512, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095,
2.263780, 2.283465, 2.303150, 2.322835, 2.352362, 2.381890, 2.411417,
2.440945, 2.450787, 2.460630, 2.470472, 2.480315, 2.500000, 2.519685,
2.539370, 2.559055, 0.334646, 0.334646, 0.334646, 0.334646, 0.334646,
0.334646, 0.334646, 0.334646, 0.334646, 0.334646, 0.334646, 0.334646,
0.334646, 0.349409, 0.364173, 0.378937, 0.393701, 0.413386, 0.433071,
0.452756, 0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.563484,
0.575787, 0.588091, 0.600394, 0.627461, 0.654528, 0.681595, 0.708661,
0.720965, 0.733268, 0.745571, 0.757874, 0.784941, 0.812008, 0.839075,
0.866142, 0.883366, 0.900591, 0.917815, 0.935039, 0.957185, 0.979331,
1.001476, 1.023622, 1.033465, 1.043307, 1.053150, 1.062992, 1.092520,
1.122047, 1.151575, 1.181102, 1.193406, 1.205709, 1.218012, 1.230315,
1.250000, 1.269685, 1.289370, 1.309055, 1.326280, 1.343504, 1.360728,
1.377953, 1.400098, 1.422244, 1.444390, 1.466535, 1.493602, 1.520669,
1.547736, 1.574803, 1.587106, 1.599409, 1.611713, 1.624016, 1.651083,
1.678150, 1.705217, 1.732283, 1.744587, 1.756890, 1.769193, 1.781496,
1.806102, 1.830709, 1.855315, 1.879921, 1.892224, 1.904528, 1.916831,
1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.034941, 2.062008,
2.089075, 2.116142, 2.128445, 2.140748, 2.153051, 2.165354, 2.187500,
2.209646, 2.231791, 2.253937, 2.271161, 2.288386, 2.305610, 2.322835,
2.352362, 2.381890, 2.411417, 2.440945, 2.450787, 2.460630, 2.470472,
2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 0.354331, 0.354331,
0.354331, 0.354331, 0.354331, 0.354331, 0.354331, 0.354331, 0.354331,
0.354331, 0.354331, 0.354331, 0.354331, 0.364173, 0.374016, 0.383858,
0.393701, 0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811,
0.531496, 0.551181, 0.565945, 0.580709, 0.595472, 0.610236, 0.634843,
0.659449, 0.684055, 0.708661, 0.723425, 0.738189, 0.752953, 0.767717,
0.792323, 0.816929, 0.841535, 0.866142, 0.880906, 0.895669, 0.910433,
0.925197, 0.949803, 0.974409, 0.999016, 1.023622, 1.033465, 1.043307,
1.053150, 1.062992, 1.092520, 1.122047, 1.151575, 1.181102, 1.195866,
1.210630, 1.225394, 1.240157, 1.259843, 1.279528, 1.299213, 1.318898,
1.333661, 1.348425, 1.363189, 1.377953, 1.402559, 1.427165, 1.451772,
1.476378, 1.500984, 1.525591, 1.550197, 1.574803, 1.589567, 1.604331,
1.619094, 1.633858, 1.658465, 1.683071, 1.707677, 1.732283, 1.747047,
1.761811, 1.776575, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079,
1.884843, 1.899606, 1.914370, 1.929134, 1.948819, 1.968504, 1.988189,
2.007874, 2.032480, 2.057087, 2.081693, 2.106299, 2.121063, 2.135827,
2.150591, 2.165354, 2.189961, 2.214567, 2.239173, 2.263780, 2.278543,
2.293307, 2.308071, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945,
2.450787, 2.460630, 2.470472, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 0.374016, 0.374016, 0.374016, 0.374016, 0.374016, 0.374016,
0.374016, 0.374016, 0.374016, 0.374016, 0.374016, 0.374016, 0.374016,
0.378937, 0.383858, 0.388780, 0.393701, 0.413386, 0.433071, 0.452756,
0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.568406, 0.585630,
0.602854, 0.620079, 0.642224, 0.664370, 0.686516, 0.708661, 0.725886,
0.743110, 0.760335, 0.777559, 0.799705, 0.821850, 0.843996, 0.866142,
0.878445, 0.890748, 0.903051, 0.915354, 0.942421, 0.969488, 0.996555,
1.023622, 1.033465, 1.043307, 1.053150, 1.062992, 1.092520, 1.122047,
1.151575, 1.181102, 1.198327, 1.215551, 1.232776, 1.250000, 1.269685,
1.289370, 1.309055, 1.328740, 1.341043, 1.353346, 1.365650, 1.377953,
1.405020, 1.432087, 1.459154, 1.486220, 1.508366, 1.530512, 1.552657,
1.574803, 1.592028, 1.609252, 1.626476, 1.643701, 1.665846, 1.687992,
1.710138, 1.732283, 1.749508, 1.766732, 1.783957, 1.801181, 1.815945,
1.830709, 1.845472, 1.860236, 1.877461, 1.894685, 1.911909, 1.929134,
1.948819, 1.968504, 1.988189, 2.007874, 2.030020, 2.052165, 2.074311,
2.096457, 2.113681, 2.130906, 2.148130, 2.165354, 2.192421, 2.219488,
2.246555, 2.273622, 2.285925, 2.298228, 2.310532, 2.322835, 2.352362,
2.381890, 2.411417, 2.440945, 2.450787, 2.460630, 2.470472, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 0.393701, 0.393701, 0.393701,
0.393701, 0.393701, 0.393701, 0.393701, 0.393701, 0.393701, 0.393701,
0.393701, 0.393701, 0.393701, 0.393701, 0.393701, 0.393701, 0.393701,
0.413386, 0.433071, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496,
0.551181, 0.570866, 0.590551, 0.610236, 0.629921, 0.649606, 0.669291,
0.688976, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087,
0.826772, 0.846457, 0.866142, 0.875984, 0.885827, 0.895669, 0.905512,
0.935039, 0.964567, 0.994094, 1.023622, 1.033465, 1.043307, 1.053150,
1.062992, 1.092520, 1.122047, 1.151575, 1.181102, 1.200787, 1.220472,
1.240157, 1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.348425,
1.358268, 1.368110, 1.377953, 1.407480, 1.437008, 1.466535, 1.496063,
1.515748, 1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.633858,
1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654,
1.791339, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394, 1.870079,
1.889764, 1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874,
2.027559, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669,
2.165354, 2.194882, 2.224410, 2.253937, 2.283465, 2.293307, 2.303150,
2.312992, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945, 2.450787,
2.460630, 2.470472, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
0.413386, 0.410925, 0.408465, 0.406004, 0.403543, 0.406004, 0.408465,
0.410925, 0.413386, 0.413386, 0.413386, 0.413386, 0.413386, 0.413386,
0.413386, 0.413386, 0.413386, 0.433071, 0.452756, 0.472441, 0.492126,
0.511811, 0.531496, 0.551181, 0.570866, 0.590551, 0.610236, 0.629921,
0.649606, 0.669291, 0.688976, 0.708661, 0.728346, 0.748031, 0.767717,
0.787402, 0.807087, 0.826772, 0.846457, 0.866142, 0.885827, 0.895669,
0.905512, 0.915354, 0.925197, 0.954724, 0.984252, 1.013780, 1.043307,
1.053150, 1.062992, 1.072835, 1.082677, 1.109744, 1.136811, 1.163878,
1.190945, 1.213091, 1.235236, 1.257382, 1.279528, 1.296752, 1.313976,
1.331201, 1.348425, 1.363189, 1.377953, 1.392717, 1.407480, 1.432087,
1.456693, 1.481299, 1.505906, 1.528051, 1.550197, 1.572343, 1.594488,
1.614173, 1.633858, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283,
1.751969, 1.771654, 1.791339, 1.811024, 1.830709, 1.843012, 1.855315,
1.867618, 1.879921, 1.897146, 1.914370, 1.931594, 1.948819, 1.968504,
1.988189, 2.007874, 2.027559, 2.049705, 2.071851, 2.093996, 2.116142,
2.133366, 2.150591, 2.167815, 2.185039, 2.212106, 2.239173, 2.266240,
2.293307, 2.305610, 2.317913, 2.330217, 2.342520, 2.369587, 2.396654,
2.423720, 2.450787, 2.465551, 2.480315, 2.495079, 2.509843, 2.529528,
2.549213, 2.568898, 2.588583, 0.433071, 0.428150, 0.423228, 0.418307,
0.413386, 0.418307, 0.423228, 0.428150, 0.433071, 0.433071, 0.433071,
0.433071, 0.433071, 0.433071, 0.433071, 0.433071, 0.433071, 0.452756,
0.472441, 0.492126, 0.511811, 0.531496, 0.551181, 0.570866, 0.590551,
0.610236, 0.629921, 0.649606, 0.669291, 0.688976, 0.708661, 0.728346,
0.748031, 0.767717, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142,
0.885827, 0.905512, 0.915354, 0.925197, 0.935039, 0.944882, 0.974409,
1.003937, 1.033465, 1.062992, 1.072835, 1.082677, 1.092520, 1.102362,
1.126969, 1.151575, 1.176181, 1.200787, 1.225394, 1.250000, 1.274606,
1.299213, 1.313976, 1.328740, 1.343504, 1.358268, 1.377953, 1.397638,
1.417323, 1.437008, 1.456693, 1.476378, 1.496063, 1.515748, 1.540354,
1.564961, 1.589567, 1.614173, 1.633858, 1.653543, 1.673228, 1.692913,
1.712598, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.830709,
1.850394, 1.865157, 1.879921, 1.894685, 1.909449, 1.924213, 1.938976,
1.953740, 1.968504, 1.988189, 2.007874, 2.027559, 2.047244, 2.071851,
2.096457, 2.121063, 2.145669, 2.160433, 2.175197, 2.189961, 2.204724,
2.229331, 2.253937, 2.278543, 2.303150, 2.317913, 2.332677, 2.347441,
2.362205, 2.386811, 2.411417, 2.436024, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 0.452756,
0.445374, 0.437992, 0.430610, 0.423228, 0.430610, 0.437992, 0.445374,
0.452756, 0.452756, 0.452756, 0.452756, 0.452756, 0.452756, 0.452756,
0.452756, 0.452756, 0.472441, 0.492126, 0.511811, 0.531496, 0.551181,
0.570866, 0.590551, 0.610236, 0.629921, 0.649606, 0.669291, 0.688976,
0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087, 0.826772,
0.846457, 0.866142, 0.885827, 0.905512, 0.925197, 0.935039, 0.944882,
0.954724, 0.964567, 0.994094, 1.023622, 1.053150, 1.082677, 1.092520,
1.102362, 1.112205, 1.122047, 1.144193, 1.166339, 1.188484, 1.210630,
1.237697, 1.264764, 1.291831, 1.318898, 1.331201, 1.343504, 1.355807,
1.368110, 1.392717, 1.417323, 1.441929, 1.466535, 1.481299, 1.496063,
1.510827, 1.525591, 1.552657, 1.579724, 1.606791, 1.633858, 1.653543,
1.673228, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.791339,
1.811024, 1.830709, 1.850394, 1.870079, 1.887303, 1.904528, 1.921752,
1.938976, 1.951280, 1.963583, 1.975886, 1.988189, 2.007874, 2.027559,
2.047244, 2.066929, 2.093996, 2.121063, 2.148130, 2.175197, 2.187500,
2.199803, 2.212106, 2.224410, 2.246555, 2.268701, 2.290847, 2.312992,
2.330217, 2.347441, 2.364665, 2.381890, 2.404035, 2.426181, 2.448327,
2.470472, 2.495079, 2.519685, 2.544291, 2.568898, 2.588583, 2.608268,
2.627953, 2.647638, 0.472441, 0.462598, 0.452756, 0.442913, 0.433071,
0.442913, 0.452756, 0.462598, 0.472441, 0.472441, 0.472441, 0.472441,
0.472441, 0.472441, 0.472441, 0.472441, 0.472441, 0.492126, 0.511811,
0.531496, 0.551181, 0.570866, 0.590551, 0.610236, 0.629921, 0.649606,
0.669291, 0.688976, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402,
0.807087, 0.826772, 0.846457, 0.866142, 0.885827, 0.905512, 0.925197,
0.944882, 0.954724, 0.964567, 0.974409, 0.984252, 1.013780, 1.043307,
1.072835, 1.102362, 1.112205, 1.122047, 1.131890, 1.141732, 1.161417,
1.181102, 1.200787, 1.220472, 1.250000, 1.279528, 1.309055, 1.338583,
1.348425, 1.358268, 1.368110, 1.377953, 1.407480, 1.437008, 1.466535,
1.496063, 1.505906, 1.515748, 1.525591, 1.535433, 1.564961, 1.594488,
1.624016, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.751969,
1.771654, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.948819, 1.968504, 1.978346, 1.988189, 1.998031,
2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.116142, 2.145669,
2.175197, 2.204724, 2.214567, 2.224410, 2.234252, 2.244095, 2.263780,
2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575,
2.421260, 2.440945, 2.460630, 2.480315, 2.509843, 2.539370, 2.568898,
2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 0.492126, 0.484744,
0.477362, 0.469980, 0.462598, 0.469980, 0.477362, 0.484744, 0.492126,
0.489665, 0.487205, 0.484744, 0.482283, 0.484744, 0.487205, 0.489665,
0.492126, 0.506890, 0.521654, 0.536417, 0.551181, 0.568406, 0.585630,
0.602854, 0.620079, 0.642224, 0.664370, 0.686516, 0.708661, 0.728346,
0.748031, 0.767717, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142,
0.885827, 0.905512, 0.925197, 0.944882, 0.957185, 0.969488, 0.981791,
0.994094, 1.021161, 1.048228, 1.075295, 1.102362, 1.114665, 1.126969,
1.139272, 1.151575, 1.171260, 1.190945, 1.210630, 1.230315, 1.257382,
1.284449, 1.311516, 1.338583, 1.348425, 1.358268, 1.368110, 1.377953,
1.405020, 1.432087, 1.459154, 1.486220, 1.500984, 1.515748, 1.530512,
1.545276, 1.569882, 1.594488, 1.619094, 1.643701, 1.663386, 1.683071,
1.702756, 1.722441, 1.742126, 1.761811, 1.781496, 1.801181, 1.820866,
1.840551, 1.860236, 1.879921, 1.899606, 1.919291, 1.938976, 1.958661,
1.973425, 1.988189, 2.002953, 2.017717, 2.037402, 2.057087, 2.076772,
2.096457, 2.121063, 2.145669, 2.170276, 2.194882, 2.209646, 2.224410,
2.239173, 2.253937, 2.273622, 2.293307, 2.312992, 2.332677, 2.349902,
2.367126, 2.384350, 2.401575, 2.423720, 2.445866, 2.468012, 2.490158,
2.514764, 2.539370, 2.563976, 2.588583, 2.610729, 2.632874, 2.655020,
2.677166, 0.511811, 0.506890, 0.501969, 0.497047, 0.492126, 0.497047,
0.501969, 0.506890, 0.511811, 0.506890, 0.501969, 0.497047, 0.492126,
0.497047, 0.501969, 0.506890, 0.511811, 0.521654, 0.531496, 0.541339,
0.551181, 0.565945, 0.580709, 0.595472, 0.610236, 0.634843, 0.659449,
0.684055, 0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087,
0.826772, 0.846457, 0.866142, 0.885827, 0.905512, 0.925197, 0.944882,
0.959646, 0.974409, 0.989173, 1.003937, 1.028543, 1.053150, 1.077756,
1.102362, 1.117126, 1.131890, 1.146654, 1.161417, 1.181102, 1.200787,
1.220472, 1.240157, 1.264764, 1.289370, 1.313976, 1.338583, 1.348425,
1.358268, 1.368110, 1.377953, 1.402559, 1.427165, 1.451772, 1.476378,
1.496063, 1.515748, 1.535433, 1.555118, 1.574803, 1.594488, 1.614173,
1.633858, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.751969,
1.771654, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559,
2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150,
2.322835, 2.342520, 2.357284, 2.372047, 2.386811, 2.401575, 2.426181,
2.450787, 2.475394, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.603347, 2.627953, 2.652559, 2.677166, 0.531496, 0.529035, 0.526575,
0.524114, 0.521654, 0.524114, 0.526575, 0.529035, 0.531496, 0.524114,
0.516732, 0.509350, 0.501969, 0.509350, 0.516732, 0.524114, 0.531496,
0.536417, 0.541339, 0.546260, 0.551181, 0.563484, 0.575787, 0.588091,
0.600394, 0.627461, 0.654528, 0.681595, 0.708661, 0.728346, 0.748031,
0.767717, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142, 0.885827,
0.905512, 0.925197, 0.944882, 0.962106, 0.979331, 0.996555, 1.013780,
1.035925, 1.058071, 1.080217, 1.102362, 1.119587, 1.136811, 1.154035,
1.171260, 1.190945, 1.210630, 1.230315, 1.250000, 1.272146, 1.294291,
1.316437, 1.338583, 1.348425, 1.358268, 1.368110, 1.377953, 1.400098,
1.422244, 1.444390, 1.466535, 1.491142, 1.515748, 1.540354, 1.564961,
1.579724, 1.594488, 1.609252, 1.624016, 1.643701, 1.663386, 1.683071,
1.702756, 1.722441, 1.742126, 1.761811, 1.781496, 1.801181, 1.820866,
1.840551, 1.860236, 1.879921, 1.899606, 1.919291, 1.938976, 1.963583,
1.988189, 2.012795, 2.037402, 2.057087, 2.076772, 2.096457, 2.116142,
2.130906, 2.145669, 2.160433, 2.175197, 2.199803, 2.224410, 2.249016,
2.273622, 2.293307, 2.312992, 2.332677, 2.352362, 2.364665, 2.376969,
2.389272, 2.401575, 2.428642, 2.455709, 2.482776, 2.509843, 2.524606,
2.539370, 2.554134, 2.568898, 2.595965, 2.623032, 2.650099, 2.677166,
0.551181, 0.551181, 0.551181, 0.551181, 0.551181, 0.551181, 0.551181,
0.551181, 0.551181, 0.541339, 0.531496, 0.521654, 0.511811, 0.521654,
0.531496, 0.541339, 0.551181, 0.551181, 0.551181, 0.551181, 0.551181,
0.561024, 0.570866, 0.580709, 0.590551, 0.620079, 0.649606, 0.679134,
0.708661, 0.728346, 0.748031, 0.767717, 0.787402, 0.807087, 0.826772,
0.846457, 0.866142, 0.885827, 0.905512, 0.925197, 0.944882, 0.964567,
0.984252, 1.003937, 1.023622, 1.043307, 1.062992, 1.082677, 1.102362,
1.122047, 1.141732, 1.161417, 1.181102, 1.200787, 1.220472, 1.240157,
1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.348425, 1.358268,
1.368110, 1.377953, 1.397638, 1.417323, 1.437008, 1.456693, 1.486220,
1.515748, 1.545276, 1.574803, 1.584646, 1.594488, 1.604331, 1.614173,
1.633858, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.751969,
1.771654, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.958661, 1.988189, 2.017717, 2.047244, 2.066929,
2.086614, 2.106299, 2.125984, 2.135827, 2.145669, 2.155512, 2.165354,
2.194882, 2.224410, 2.253937, 2.283465, 2.303150, 2.322835, 2.342520,
2.362205, 2.372047, 2.381890, 2.391732, 2.401575, 2.431102, 2.460630,
2.490157, 2.519685, 2.529528, 2.539370, 2.549213, 2.559055, 2.588583,
2.618110, 2.647638, 2.677166, 0.570866, 0.570866, 0.570866, 0.570866,
0.570866, 0.570866, 0.570866, 0.570866, 0.570866, 0.563484, 0.556102,
0.548720, 0.541339, 0.548720, 0.556102, 0.563484, 0.570866, 0.570866,
0.570866, 0.570866, 0.570866, 0.578248, 0.585630, 0.593012, 0.600394,
0.627461, 0.654528, 0.681595, 0.708661, 0.725886, 0.743110, 0.760335,
0.777559, 0.799705, 0.821850, 0.843996, 0.866142, 0.885827, 0.905512,
0.925197, 0.944882, 0.964567, 0.984252, 1.003937, 1.023622, 1.043307,
1.062992, 1.082677, 1.102362, 1.122047, 1.141732, 1.161417, 1.181102,
1.198327, 1.215551, 1.232776, 1.250000, 1.269685, 1.289370, 1.309055,
1.328740, 1.343504, 1.358268, 1.373032, 1.387795, 1.405020, 1.422244,
1.439469, 1.456693, 1.483760, 1.510827, 1.537894, 1.564961, 1.579724,
1.594488, 1.609252, 1.624016, 1.641240, 1.658465, 1.675689, 1.692913,
1.712598, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.830709,
1.850394, 1.870079, 1.889764, 1.909449, 1.929134, 1.956201, 1.983268,
2.010335, 2.037402, 2.057087, 2.076772, 2.096457, 2.116142, 2.128445,
2.140748, 2.153051, 2.165354, 2.194882, 2.224410, 2.253937, 2.283465,
2.303150, 2.322835, 2.342520, 2.362205, 2.372047, 2.381890, 2.391732,
2.401575, 2.428642, 2.455709, 2.482776, 2.509843, 2.522146, 2.534449,
2.546752, 2.559055, 2.588583, 2.618110, 2.647638, 2.677166, 0.590551,
0.590551, 0.590551, 0.590551, 0.590551, 0.590551, 0.590551, 0.590551,
0.590551, 0.585630, 0.580709, 0.575787, 0.570866, 0.575787, 0.580709,
0.585630, 0.590551, 0.590551, 0.590551, 0.590551, 0.590551, 0.595472,
0.600394, 0.605315, 0.610236, 0.634843, 0.659449, 0.684055, 0.708661,
0.723425, 0.738189, 0.752953, 0.767717, 0.792323, 0.816929, 0.841535,
0.866142, 0.885827, 0.905512, 0.925197, 0.944882, 0.964567, 0.984252,
1.003937, 1.023622, 1.043307, 1.062992, 1.082677, 1.102362, 1.122047,
1.141732, 1.161417, 1.181102, 1.195866, 1.210630, 1.225394, 1.240157,
1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953,
1.397638, 1.412402, 1.427165, 1.441929, 1.456693, 1.481299, 1.505906,
1.530512, 1.555118, 1.574803, 1.594488, 1.614173, 1.633858, 1.648622,
1.663386, 1.678150, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654,
1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.889764, 1.909449,
1.929134, 1.953740, 1.978346, 2.002953, 2.027559, 2.047244, 2.066929,
2.086614, 2.106299, 2.121063, 2.135827, 2.150591, 2.165354, 2.194882,
2.224410, 2.253937, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205,
2.372047, 2.381890, 2.391732, 2.401575, 2.426181, 2.450787, 2.475394,
2.500000, 2.514764, 2.529528, 2.544291, 2.559055, 2.588583, 2.618110,
2.647638, 2.677166, 0.610236, 0.610236, 0.610236, 0.610236, 0.610236,
0.610236, 0.610236, 0.610236, 0.610236, 0.607776, 0.605315, 0.602854,
0.600394, 0.602854, 0.605315, 0.607776, 0.610236, 0.610236, 0.610236,
0.610236, 0.610236, 0.612697, 0.615157, 0.617618, 0.620079, 0.642224,
0.664370, 0.686516, 0.708661, 0.720965, 0.733268, 0.745571, 0.757874,
0.784941, 0.812008, 0.839075, 0.866142, 0.885827, 0.905512, 0.925197,
0.944882, 0.964567, 0.984252, 1.003937, 1.023622, 1.043307, 1.062992,
1.082677, 1.102362, 1.122047, 1.141732, 1.161417, 1.181102, 1.193406,
1.205709, 1.218012, 1.230315, 1.250000, 1.269685, 1.289370, 1.309055,
1.333661, 1.358268, 1.382874, 1.407480, 1.419783, 1.432087, 1.444390,
1.456693, 1.478839, 1.500984, 1.523130, 1.545276, 1.569882, 1.594488,
1.619094, 1.643701, 1.656004, 1.668307, 1.680610, 1.692913, 1.712598,
1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.830709, 1.850394,
1.870079, 1.889764, 1.909449, 1.929134, 1.951280, 1.973425, 1.995571,
2.017717, 2.037402, 2.057087, 2.076772, 2.096457, 2.113681, 2.130906,
2.148130, 2.165354, 2.194882, 2.224410, 2.253937, 2.283465, 2.303150,
2.322835, 2.342520, 2.362205, 2.372047, 2.381890, 2.391732, 2.401575,
2.423720, 2.445866, 2.468012, 2.490158, 2.507382, 2.524606, 2.541831,
2.559055, 2.588583, 2.618110, 2.647638, 2.677166, 0.629921, 0.629921,
0.629921, 0.629921, 0.629921, 0.629921, 0.629921, 0.629921, 0.629921,
0.629921, 0.629921, 0.629921, 0.629921, 0.629921, 0.629921, 0.629921,
0.629921, 0.629921, 0.629921, 0.629921, 0.629921, 0.629921, 0.629921,
0.629921, 0.629921, 0.649606, 0.669291, 0.688976, 0.708661, 0.718504,
0.728346, 0.738189, 0.748031, 0.777559, 0.807087, 0.836614, 0.866142,
0.885827, 0.905512, 0.925197, 0.944882, 0.964567, 0.984252, 1.003937,
1.023622, 1.043307, 1.062992, 1.082677, 1.102362, 1.122047, 1.141732,
1.161417, 1.181102, 1.190945, 1.200787, 1.210630, 1.220472, 1.240157,
1.259843, 1.279528, 1.299213, 1.328740, 1.358268, 1.387795, 1.417323,
1.427165, 1.437008, 1.446850, 1.456693, 1.476378, 1.496063, 1.515748,
1.535433, 1.564961, 1.594488, 1.624016, 1.653543, 1.663386, 1.673228,
1.683071, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.791339,
1.811024, 1.830709, 1.850394, 1.870079, 1.889764, 1.909449, 1.929134,
1.948819, 1.968504, 1.988189, 2.007874, 2.027559, 2.047244, 2.066929,
2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.194882, 2.224410,
2.253937, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.372047,
2.381890, 2.391732, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.588583, 2.618110, 2.647638,
2.677166, 0.649606, 0.649606, 0.649606, 0.649606, 0.649606, 0.649606,
0.649606, 0.649606, 0.649606, 0.647146, 0.644685, 0.642224, 0.639764,
0.642224, 0.644685, 0.647146, 0.649606, 0.647146, 0.644685, 0.642224,
0.639764, 0.639764, 0.639764, 0.639764, 0.639764, 0.661909, 0.684055,
0.706201, 0.728346, 0.740650, 0.752953, 0.765256, 0.777559, 0.802165,
0.826772, 0.851378, 0.875984, 0.898130, 0.920276, 0.942421, 0.964567,
0.981791, 0.999016, 1.016240, 1.033465, 1.053150, 1.072835, 1.092520,
1.112205, 1.134350, 1.156496, 1.178642, 1.200787, 1.213091, 1.225394,
1.237697, 1.250000, 1.267224, 1.284449, 1.301673, 1.318898, 1.345965,
1.373032, 1.400098, 1.427165, 1.439469, 1.451772, 1.464075, 1.476378,
1.496063, 1.515748, 1.535433, 1.555118, 1.584646, 1.614173, 1.643701,
1.673228, 1.685531, 1.697835, 1.710138, 1.722441, 1.739665, 1.756890,
1.774114, 1.791339, 1.813484, 1.835630, 1.857776, 1.879921, 1.899606,
1.919291, 1.938976, 1.958661, 1.975886, 1.993110, 2.010335, 2.027559,
2.049705, 2.071851, 2.093996, 2.116142, 2.133366, 2.150591, 2.167815,
2.185039, 2.212106, 2.239173, 2.266240, 2.293307, 2.315453, 2.337598,
2.359744, 2.381890, 2.391732, 2.401575, 2.411417, 2.421260, 2.440945,
2.460630, 2.480315, 2.500000, 2.522146, 2.544291, 2.566437, 2.588583,
2.613189, 2.637795, 2.662402, 2.687008, 0.669291, 0.669291, 0.669291,
0.669291, 0.669291, 0.669291, 0.669291, 0.669291, 0.669291, 0.664370,
0.659449, 0.654528, 0.649606, 0.654528, 0.659449, 0.664370, 0.669291,
0.664370, 0.659449, 0.654528, 0.649606, 0.649606, 0.649606, 0.649606,
0.649606, 0.674213, 0.698819, 0.723425, 0.748031, 0.762795, 0.777559,
0.792323, 0.807087, 0.826772, 0.846457, 0.866142, 0.885827, 0.910433,
0.935039, 0.959646, 0.984252, 0.999016, 1.013780, 1.028543, 1.043307,
1.062992, 1.082677, 1.102362, 1.122047, 1.146654, 1.171260, 1.195866,
1.220472, 1.235236, 1.250000, 1.264764, 1.279528, 1.294291, 1.309055,
1.323819, 1.338583, 1.363189, 1.387795, 1.412402, 1.437008, 1.451772,
1.466535, 1.481299, 1.496063, 1.515748, 1.535433, 1.555118, 1.574803,
1.604331, 1.633858, 1.663386, 1.692913, 1.707677, 1.722441, 1.737205,
1.751969, 1.766732, 1.781496, 1.796260, 1.811024, 1.835630, 1.860236,
1.884843, 1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.002953,
2.017717, 2.032480, 2.047244, 2.071851, 2.096457, 2.121063, 2.145669,
2.160433, 2.175197, 2.189961, 2.204724, 2.229331, 2.253937, 2.278543,
2.303150, 2.327756, 2.352362, 2.376969, 2.401575, 2.411417, 2.421260,
2.431102, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.544291,
2.568898, 2.593504, 2.618110, 2.637795, 2.657480, 2.677165, 2.696851,
0.688976, 0.688976, 0.688976, 0.688976, 0.688976, 0.688976, 0.688976,
0.688976, 0.688976, 0.681595, 0.674213, 0.666831, 0.659449, 0.666831,
0.674213, 0.681595, 0.688976, 0.681595, 0.674213, 0.666831, 0.659449,
0.659449, 0.659449, 0.659449, 0.659449, 0.686516, 0.713583, 0.740650,
0.767717, 0.784941, 0.802165, 0.819390, 0.836614, 0.851378, 0.866142,
0.880906, 0.895669, 0.922736, 0.949803, 0.976870, 1.003937, 1.016240,
1.028543, 1.040846, 1.053150, 1.072835, 1.092520, 1.112205, 1.131890,
1.158957, 1.186024, 1.213091, 1.240157, 1.257382, 1.274606, 1.291831,
1.309055, 1.321358, 1.333661, 1.345965, 1.358268, 1.380413, 1.402559,
1.424705, 1.446850, 1.464075, 1.481299, 1.498524, 1.515748, 1.535433,
1.555118, 1.574803, 1.594488, 1.624016, 1.653543, 1.683071, 1.712598,
1.729823, 1.747047, 1.764272, 1.781496, 1.793799, 1.806102, 1.818406,
1.830709, 1.857776, 1.884843, 1.911909, 1.938976, 1.958661, 1.978346,
1.998031, 2.017717, 2.030020, 2.042323, 2.054626, 2.066929, 2.093996,
2.121063, 2.148130, 2.175197, 2.187500, 2.199803, 2.212106, 2.224410,
2.246555, 2.268701, 2.290847, 2.312992, 2.340059, 2.367126, 2.394193,
2.421260, 2.431102, 2.440945, 2.450787, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.566437, 2.593504, 2.620571, 2.647638, 2.662402,
2.677166, 2.691929, 2.706693, 0.708661, 0.708661, 0.708661, 0.708661,
0.708661, 0.708661, 0.708661, 0.708661, 0.708661, 0.698819, 0.688976,
0.679134, 0.669291, 0.679134, 0.688976, 0.698819, 0.708661, 0.698819,
0.688976, 0.679134, 0.669291, 0.669291, 0.669291, 0.669291, 0.669291,
0.698819, 0.728346, 0.757874, 0.787402, 0.807087, 0.826772, 0.846457,
0.866142, 0.875984, 0.885827, 0.895669, 0.905512, 0.935039, 0.964567,
0.994094, 1.023622, 1.033465, 1.043307, 1.053150, 1.062992, 1.082677,
1.102362, 1.122047, 1.141732, 1.171260, 1.200787, 1.230315, 1.259843,
1.279528, 1.299213, 1.318898, 1.338583, 1.348425, 1.358268, 1.368110,
1.377953, 1.397638, 1.417323, 1.437008, 1.456693, 1.476378, 1.496063,
1.515748, 1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.643701,
1.673228, 1.702756, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024,
1.820866, 1.830709, 1.840551, 1.850394, 1.879921, 1.909449, 1.938976,
1.968504, 1.988189, 2.007874, 2.027559, 2.047244, 2.057087, 2.066929,
2.076772, 2.086614, 2.116142, 2.145669, 2.175197, 2.204724, 2.214567,
2.224410, 2.234252, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835,
2.352362, 2.381890, 2.411417, 2.440945, 2.450787, 2.460630, 2.470472,
2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.588583, 2.618110,
2.647638, 2.677166, 2.687008, 2.696851, 2.706693, 2.716536, 0.728346,
0.728346, 0.728346, 0.728346, 0.728346, 0.728346, 0.728346, 0.728346,
0.728346, 0.720965, 0.713583, 0.706201, 0.698819, 0.706201, 0.713583,
0.720965, 0.728346, 0.720965, 0.713583, 0.706201, 0.698819, 0.698819,
0.698819, 0.698819, 0.698819, 0.720965, 0.743110, 0.765256, 0.787402,
0.807087, 0.826772, 0.846457, 0.866142, 0.878445, 0.890748, 0.903051,
0.915354, 0.942421, 0.969488, 0.996555, 1.023622, 1.033465, 1.043307,
1.053150, 1.062992, 1.085138, 1.107283, 1.129429, 1.151575, 1.178642,
1.205709, 1.232776, 1.259843, 1.279528, 1.299213, 1.318898, 1.338583,
1.350886, 1.363189, 1.375492, 1.387795, 1.405020, 1.422244, 1.439469,
1.456693, 1.478839, 1.500984, 1.523130, 1.545276, 1.564961, 1.584646,
1.604331, 1.624016, 1.648622, 1.673228, 1.697835, 1.722441, 1.744587,
1.766732, 1.788878, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394,
1.877461, 1.904528, 1.931594, 1.958661, 1.980807, 2.002953, 2.025099,
2.047244, 2.059547, 2.071851, 2.084154, 2.096457, 2.121063, 2.145669,
2.170276, 2.194882, 2.209646, 2.224410, 2.239173, 2.253937, 2.271161,
2.288386, 2.305610, 2.322835, 2.349902, 2.376969, 2.404035, 2.431102,
2.443406, 2.455709, 2.468012, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 2.586122, 2.613189, 2.640256, 2.667323, 2.679626, 2.691929,
2.704232, 2.716536, 0.748031, 0.748031, 0.748031, 0.748031, 0.748031,
0.748031, 0.748031, 0.748031, 0.748031, 0.743110, 0.738189, 0.733268,
0.728346, 0.733268, 0.738189, 0.743110, 0.748031, 0.743110, 0.738189,
0.733268, 0.728346, 0.728346, 0.728346, 0.728346, 0.728346, 0.743110,
0.757874, 0.772638, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142,
0.880906, 0.895669, 0.910433, 0.925197, 0.949803, 0.974409, 0.999016,
1.023622, 1.033465, 1.043307, 1.053150, 1.062992, 1.087598, 1.112205,
1.136811, 1.161417, 1.186024, 1.210630, 1.235236, 1.259843, 1.279528,
1.299213, 1.318898, 1.338583, 1.353346, 1.368110, 1.382874, 1.397638,
1.412402, 1.427165, 1.441929, 1.456693, 1.481299, 1.505906, 1.530512,
1.555118, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543, 1.673228,
1.692913, 1.712598, 1.737205, 1.761811, 1.786417, 1.811024, 1.820866,
1.830709, 1.840551, 1.850394, 1.875000, 1.899606, 1.924213, 1.948819,
1.973425, 1.998031, 2.022638, 2.047244, 2.062008, 2.076772, 2.091536,
2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.263780, 2.278543, 2.293307, 2.308071, 2.322835, 2.347441,
2.372047, 2.396654, 2.421260, 2.436024, 2.450787, 2.465551, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.583662, 2.608268, 2.632874,
2.657480, 2.672244, 2.687008, 2.701772, 2.716536, 0.767717, 0.767717,
0.767717, 0.767717, 0.767717, 0.767717, 0.767717, 0.767717, 0.767717,
0.765256, 0.762795, 0.760335, 0.757874, 0.760335, 0.762795, 0.765256,
0.767717, 0.765256, 0.762795, 0.760335, 0.757874, 0.757874, 0.757874,
0.757874, 0.757874, 0.765256, 0.772638, 0.780020, 0.787402, 0.807087,
0.826772, 0.846457, 0.866142, 0.883366, 0.900591, 0.917815, 0.935039,
0.957185, 0.979331, 1.001476, 1.023622, 1.033465, 1.043307, 1.053150,
1.062992, 1.090059, 1.117126, 1.144193, 1.171260, 1.193406, 1.215551,
1.237697, 1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.355807,
1.373032, 1.390256, 1.407480, 1.419783, 1.432087, 1.444390, 1.456693,
1.483760, 1.510827, 1.537894, 1.564961, 1.584646, 1.604331, 1.624016,
1.643701, 1.658465, 1.673228, 1.687992, 1.702756, 1.729823, 1.756890,
1.783957, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394, 1.872539,
1.894685, 1.916831, 1.938976, 1.966043, 1.993110, 2.020177, 2.047244,
2.064469, 2.081693, 2.098917, 2.116142, 2.130906, 2.145669, 2.160433,
2.175197, 2.199803, 2.224410, 2.249016, 2.273622, 2.285925, 2.298228,
2.310532, 2.322835, 2.344980, 2.367126, 2.389272, 2.411417, 2.428642,
2.445866, 2.463091, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
2.581201, 2.603347, 2.625492, 2.647638, 2.664862, 2.682087, 2.699311,
2.716536, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402,
0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402,
0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402,
0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402, 0.787402,
0.787402, 0.787402, 0.807087, 0.826772, 0.846457, 0.866142, 0.885827,
0.905512, 0.925197, 0.944882, 0.964567, 0.984252, 1.003937, 1.023622,
1.033465, 1.043307, 1.053150, 1.062992, 1.092520, 1.122047, 1.151575,
1.181102, 1.200787, 1.220472, 1.240157, 1.259843, 1.279528, 1.299213,
1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.417323, 1.427165,
1.437008, 1.446850, 1.456693, 1.486220, 1.515748, 1.545276, 1.574803,
1.594488, 1.614173, 1.633858, 1.653543, 1.663386, 1.673228, 1.683071,
1.692913, 1.722441, 1.751969, 1.781496, 1.811024, 1.820866, 1.830709,
1.840551, 1.850394, 1.870079, 1.889764, 1.909449, 1.929134, 1.958661,
1.988189, 2.017717, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984,
2.135827, 2.145669, 2.155512, 2.165354, 2.194882, 2.224410, 2.253937,
2.283465, 2.293307, 2.303150, 2.312992, 2.322835, 2.342520, 2.362205,
2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795,
2.657480, 2.677166, 2.696851, 2.716536, 0.807087, 0.804626, 0.802165,
0.799705, 0.797244, 0.799705, 0.802165, 0.804626, 0.807087, 0.804626,
0.802165, 0.799705, 0.797244, 0.797244, 0.797244, 0.797244, 0.797244,
0.797244, 0.797244, 0.797244, 0.797244, 0.799705, 0.802165, 0.804626,
0.807087, 0.807087, 0.807087, 0.807087, 0.807087, 0.819390, 0.831693,
0.843996, 0.856299, 0.878445, 0.900591, 0.922736, 0.944882, 0.964567,
0.984252, 1.003937, 1.023622, 1.033465, 1.043307, 1.053150, 1.062992,
1.090059, 1.117126, 1.144193, 1.171260, 1.193406, 1.215551, 1.237697,
1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.355807, 1.373032,
1.390256, 1.407480, 1.419783, 1.432087, 1.444390, 1.456693, 1.486220,
1.515748, 1.545276, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543,
1.663386, 1.673228, 1.683071, 1.692913, 1.722441, 1.751969, 1.781496,
1.811024, 1.820866, 1.830709, 1.840551, 1.850394, 1.872539, 1.894685,
1.916831, 1.938976, 1.963583, 1.988189, 2.012795, 2.037402, 2.057087,
2.076772, 2.096457, 2.116142, 2.130906, 2.145669, 2.160433, 2.175197,
2.199803, 2.224410, 2.249016, 2.273622, 2.285925, 2.298228, 2.310532,
2.322835, 2.344980, 2.367126, 2.389272, 2.411417, 2.431102, 2.450787,
2.470472, 2.490158, 2.509843, 2.529528, 2.549213, 2.568898, 2.586122,
2.603347, 2.620571, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536,
0.826772, 0.821850, 0.816929, 0.812008, 0.807087, 0.812008, 0.816929,
0.821850, 0.826772, 0.821850, 0.816929, 0.812008, 0.807087, 0.807087,
0.807087, 0.807087, 0.807087, 0.807087, 0.807087, 0.807087, 0.807087,
0.812008, 0.816929, 0.821850, 0.826772, 0.826772, 0.826772, 0.826772,
0.826772, 0.831693, 0.836614, 0.841535, 0.846457, 0.871063, 0.895669,
0.920276, 0.944882, 0.964567, 0.984252, 1.003937, 1.023622, 1.033465,
1.043307, 1.053150, 1.062992, 1.087598, 1.112205, 1.136811, 1.161417,
1.186024, 1.210630, 1.235236, 1.259843, 1.279528, 1.299213, 1.318898,
1.338583, 1.353346, 1.368110, 1.382874, 1.397638, 1.412402, 1.427165,
1.441929, 1.456693, 1.486220, 1.515748, 1.545276, 1.574803, 1.594488,
1.614173, 1.633858, 1.653543, 1.663386, 1.673228, 1.683071, 1.692913,
1.722441, 1.751969, 1.781496, 1.811024, 1.820866, 1.830709, 1.840551,
1.850394, 1.875000, 1.899606, 1.924213, 1.948819, 1.968504, 1.988189,
2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984,
2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780,
2.278543, 2.293307, 2.308071, 2.322835, 2.347441, 2.372047, 2.396654,
2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 2.578740, 2.593504, 2.608268, 2.623032, 2.637795, 2.657480,
2.677166, 2.696851, 2.716536, 0.846457, 0.839075, 0.831693, 0.824311,
0.816929, 0.824311, 0.831693, 0.839075, 0.846457, 0.839075, 0.831693,
0.824311, 0.816929, 0.816929, 0.816929, 0.816929, 0.816929, 0.816929,
0.816929, 0.816929, 0.816929, 0.824311, 0.831693, 0.839075, 0.846457,
0.846457, 0.846457, 0.846457, 0.846457, 0.843996, 0.841535, 0.839075,
0.836614, 0.863681, 0.890748, 0.917815, 0.944882, 0.964567, 0.984252,
1.003937, 1.023622, 1.033465, 1.043307, 1.053150, 1.062992, 1.085138,
1.107283, 1.129429, 1.151575, 1.178642, 1.205709, 1.232776, 1.259843,
1.279528, 1.299213, 1.318898, 1.338583, 1.350886, 1.363189, 1.375492,
1.387795, 1.405020, 1.422244, 1.439469, 1.456693, 1.486220, 1.515748,
1.545276, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543, 1.663386,
1.673228, 1.683071, 1.692913, 1.722441, 1.751969, 1.781496, 1.811024,
1.820866, 1.830709, 1.840551, 1.850394, 1.877461, 1.904528, 1.931594,
1.958661, 1.973425, 1.988189, 2.002953, 2.017717, 2.037402, 2.057087,
2.076772, 2.096457, 2.121063, 2.145669, 2.170276, 2.194882, 2.209646,
2.224410, 2.239173, 2.253937, 2.271161, 2.288386, 2.305610, 2.322835,
2.349902, 2.376969, 2.404035, 2.431102, 2.450787, 2.470472, 2.490157,
2.509843, 2.529528, 2.549213, 2.568898, 2.588583, 2.600886, 2.613189,
2.625492, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 0.866142,
0.856299, 0.846457, 0.836614, 0.826772, 0.836614, 0.846457, 0.856299,
0.866142, 0.856299, 0.846457, 0.836614, 0.826772, 0.826772, 0.826772,
0.826772, 0.826772, 0.826772, 0.826772, 0.826772, 0.826772, 0.836614,
0.846457, 0.856299, 0.866142, 0.866142, 0.866142, 0.866142, 0.866142,
0.856299, 0.846457, 0.836614, 0.826772, 0.856299, 0.885827, 0.915354,
0.944882, 0.964567, 0.984252, 1.003937, 1.023622, 1.033465, 1.043307,
1.053150, 1.062992, 1.082677, 1.102362, 1.122047, 1.141732, 1.171260,
1.200787, 1.230315, 1.259843, 1.279528, 1.299213, 1.318898, 1.338583,
1.348425, 1.358268, 1.368110, 1.377953, 1.397638, 1.417323, 1.437008,
1.456693, 1.486220, 1.515748, 1.545276, 1.574803, 1.594488, 1.614173,
1.633858, 1.653543, 1.663386, 1.673228, 1.683071, 1.692913, 1.722441,
1.751969, 1.781496, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394,
1.879921, 1.909449, 1.938976, 1.968504, 1.978346, 1.988189, 1.998031,
2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.116142, 2.145669,
2.175197, 2.204724, 2.214567, 2.224410, 2.234252, 2.244095, 2.263780,
2.283465, 2.303150, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945,
2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.598425, 2.608268, 2.618110, 2.627953, 2.637795, 2.657480, 2.677166,
2.696851, 2.716536, 0.875984, 0.868602, 0.861220, 0.853839, 0.846457,
0.853839, 0.861220, 0.868602, 0.875984, 0.871063, 0.866142, 0.861220,
0.856299, 0.856299, 0.856299, 0.856299, 0.856299, 0.856299, 0.856299,
0.856299, 0.856299, 0.863681, 0.871063, 0.878445, 0.885827, 0.885827,
0.885827, 0.885827, 0.885827, 0.878445, 0.871063, 0.863681, 0.856299,
0.880906, 0.905512, 0.930118, 0.954724, 0.976870, 0.999016, 1.021161,
1.043307, 1.053150, 1.062992, 1.072835, 1.082677, 1.104823, 1.126969,
1.149114, 1.171260, 1.198327, 1.225394, 1.252461, 1.279528, 1.299213,
1.318898, 1.338583, 1.358268, 1.370571, 1.382874, 1.395177, 1.407480,
1.427165, 1.446850, 1.466535, 1.486220, 1.510827, 1.535433, 1.560039,
1.584646, 1.604331, 1.624016, 1.643701, 1.663386, 1.678150, 1.692913,
1.707677, 1.722441, 1.747047, 1.771654, 1.796260, 1.820866, 1.833169,
1.845472, 1.857776, 1.870079, 1.899606, 1.929134, 1.958661, 1.988189,
2.000492, 2.012795, 2.025099, 2.037402, 2.054626, 2.071851, 2.089075,
2.106299, 2.133366, 2.160433, 2.187500, 2.214567, 2.226870, 2.239173,
2.251476, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.369587,
2.396654, 2.423720, 2.450787, 2.470472, 2.490158, 2.509843, 2.529528,
2.549213, 2.568898, 2.588583, 2.608268, 2.623031, 2.637795, 2.652559,
2.667323, 2.684547, 2.701772, 2.718996, 2.736221, 0.885827, 0.880906,
0.875984, 0.871063, 0.866142, 0.871063, 0.875984, 0.880906, 0.885827,
0.885827, 0.885827, 0.885827, 0.885827, 0.885827, 0.885827, 0.885827,
0.885827, 0.885827, 0.885827, 0.885827, 0.885827, 0.890748, 0.895669,
0.900591, 0.905512, 0.905512, 0.905512, 0.905512, 0.905512, 0.900591,
0.895669, 0.890748, 0.885827, 0.905512, 0.925197, 0.944882, 0.964567,
0.989173, 1.013780, 1.038386, 1.062992, 1.072835, 1.082677, 1.092520,
1.102362, 1.126969, 1.151575, 1.176181, 1.200787, 1.225394, 1.250000,
1.274606, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.392717,
1.407480, 1.422244, 1.437008, 1.456693, 1.476378, 1.496063, 1.515748,
1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543,
1.673228, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.791339,
1.811024, 1.830709, 1.845472, 1.860236, 1.875000, 1.889764, 1.919291,
1.948819, 1.978346, 2.007874, 2.022638, 2.037402, 2.052165, 2.066929,
2.081693, 2.096457, 2.111221, 2.125984, 2.150591, 2.175197, 2.199803,
2.224410, 2.239173, 2.253937, 2.268701, 2.283465, 2.303150, 2.322835,
2.342520, 2.362205, 2.386811, 2.411417, 2.436024, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110,
2.637795, 2.657480, 2.677165, 2.696851, 2.711614, 2.726378, 2.741142,
2.755906, 0.895669, 0.893209, 0.890748, 0.888287, 0.885827, 0.888287,
0.890748, 0.893209, 0.895669, 0.900591, 0.905512, 0.910433, 0.915354,
0.915354, 0.915354, 0.915354, 0.915354, 0.915354, 0.915354, 0.915354,
0.915354, 0.917815, 0.920276, 0.922736, 0.925197, 0.925197, 0.925197,
0.925197, 0.925197, 0.922736, 0.920276, 0.917815, 0.915354, 0.930118,
0.944882, 0.959646, 0.974409, 1.001476, 1.028543, 1.055610, 1.082677,
1.092520, 1.102362, 1.112205, 1.122047, 1.149114, 1.176181, 1.203248,
1.230315, 1.252461, 1.274606, 1.296752, 1.318898, 1.338583, 1.358268,
1.377953, 1.397638, 1.414862, 1.432087, 1.449311, 1.466535, 1.486220,
1.505906, 1.525591, 1.545276, 1.560039, 1.574803, 1.589567, 1.604331,
1.624016, 1.643701, 1.663386, 1.683071, 1.707677, 1.732283, 1.756890,
1.781496, 1.796260, 1.811024, 1.825787, 1.840551, 1.857776, 1.875000,
1.892224, 1.909449, 1.938976, 1.968504, 1.998031, 2.027559, 2.044784,
2.062008, 2.079232, 2.096457, 2.108760, 2.121063, 2.133366, 2.145669,
2.167815, 2.189961, 2.212106, 2.234252, 2.251476, 2.268701, 2.285925,
2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.404035, 2.426181,
2.448327, 2.470472, 2.490157, 2.509843, 2.529528, 2.549213, 2.568898,
2.588583, 2.608268, 2.627953, 2.652559, 2.677166, 2.701772, 2.726378,
2.738681, 2.750984, 2.763287, 2.775591, 0.905512, 0.905512, 0.905512,
0.905512, 0.905512, 0.905512, 0.905512, 0.905512, 0.905512, 0.915354,
0.925197, 0.935039, 0.944882, 0.944882, 0.944882, 0.944882, 0.944882,
0.944882, 0.944882, 0.944882, 0.944882, 0.944882, 0.944882, 0.944882,
0.944882, 0.944882, 0.944882, 0.944882, 0.944882, 0.944882, 0.944882,
0.944882, 0.944882, 0.954724, 0.964567, 0.974409, 0.984252, 1.013780,
1.043307, 1.072835, 1.102362, 1.112205, 1.122047, 1.131890, 1.141732,
1.171260, 1.200787, 1.230315, 1.259843, 1.279528, 1.299213, 1.318898,
1.338583, 1.358268, 1.377953, 1.397638, 1.417323, 1.437008, 1.456693,
1.476378, 1.496063, 1.515748, 1.535433, 1.555118, 1.574803, 1.584646,
1.594488, 1.604331, 1.614173, 1.633858, 1.653543, 1.673228, 1.692913,
1.722441, 1.751969, 1.781496, 1.811024, 1.820866, 1.830709, 1.840551,
1.850394, 1.870079, 1.889764, 1.909449, 1.929134, 1.958661, 1.988189,
2.017717, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.135827,
2.145669, 2.155512, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095,
2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890,
2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685,
2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.667323,
2.696851, 2.726378, 2.755906, 2.765748, 2.775591, 2.785433, 2.795276,
0.935039, 0.935039, 0.935039, 0.935039, 0.935039, 0.935039, 0.935039,
0.935039, 0.935039, 0.942421, 0.949803, 0.957185, 0.964567, 0.962106,
0.959646, 0.957185, 0.954724, 0.957185, 0.959646, 0.962106, 0.964567,
0.964567, 0.964567, 0.964567, 0.964567, 0.962106, 0.959646, 0.957185,
0.954724, 0.957185, 0.959646, 0.962106, 0.964567, 0.971949, 0.979331,
0.986713, 0.994094, 1.021161, 1.048228, 1.075295, 1.102362, 1.112205,
1.122047, 1.131890, 1.141732, 1.168799, 1.195866, 1.222933, 1.250000,
1.269685, 1.289370, 1.309055, 1.328740, 1.348425, 1.368110, 1.387795,
1.407480, 1.429626, 1.451772, 1.473917, 1.496063, 1.515748, 1.535433,
1.555118, 1.574803, 1.587106, 1.599409, 1.611713, 1.624016, 1.643701,
1.663386, 1.683071, 1.702756, 1.727362, 1.751969, 1.776575, 1.801181,
1.815945, 1.830709, 1.845472, 1.860236, 1.879921, 1.899606, 1.919291,
1.938976, 1.963583, 1.988189, 2.012795, 2.037402, 2.059547, 2.081693,
2.103839, 2.125984, 2.138287, 2.150591, 2.162894, 2.175197, 2.194882,
2.214567, 2.234252, 2.253937, 2.271161, 2.288386, 2.305610, 2.322835,
2.344980, 2.367126, 2.389272, 2.411417, 2.428642, 2.445866, 2.463091,
2.480315, 2.502461, 2.524606, 2.546752, 2.568898, 2.588583, 2.608268,
2.627953, 2.647638, 2.672244, 2.696851, 2.721457, 2.746063, 2.758366,
2.770669, 2.782973, 2.795276, 0.964567, 0.964567, 0.964567, 0.964567,
0.964567, 0.964567, 0.964567, 0.964567, 0.964567, 0.969488, 0.974409,
0.979331, 0.984252, 0.979331, 0.974409, 0.969488, 0.964567, 0.969488,
0.974409, 0.979331, 0.984252, 0.984252, 0.984252, 0.984252, 0.984252,
0.979331, 0.974409, 0.969488, 0.964567, 0.969488, 0.974409, 0.979331,
0.984252, 0.989173, 0.994094, 0.999016, 1.003937, 1.028543, 1.053150,
1.077756, 1.102362, 1.112205, 1.122047, 1.131890, 1.141732, 1.166339,
1.190945, 1.215551, 1.240157, 1.259843, 1.279528, 1.299213, 1.318898,
1.338583, 1.358268, 1.377953, 1.397638, 1.422244, 1.446850, 1.471457,
1.496063, 1.515748, 1.535433, 1.555118, 1.574803, 1.589567, 1.604331,
1.619094, 1.633858, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283,
1.751969, 1.771654, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079,
1.889764, 1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874,
2.027559, 2.052165, 2.076772, 2.101378, 2.125984, 2.140748, 2.155512,
2.170276, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.278543,
2.293307, 2.308071, 2.322835, 2.347441, 2.372047, 2.396654, 2.421260,
2.436024, 2.450787, 2.465551, 2.480315, 2.504921, 2.529528, 2.554134,
2.578740, 2.598425, 2.618110, 2.637795, 2.657480, 2.677165, 2.696851,
2.716535, 2.736221, 2.750984, 2.765748, 2.780512, 2.795276, 0.994094,
0.994094, 0.994094, 0.994094, 0.994094, 0.994094, 0.994094, 0.994094,
0.994094, 0.996555, 0.999016, 1.001476, 1.003937, 0.996555, 0.989173,
0.981791, 0.974409, 0.981791, 0.989173, 0.996555, 1.003937, 1.003937,
1.003937, 1.003937, 1.003937, 0.996555, 0.989173, 0.981791, 0.974409,
0.981791, 0.989173, 0.996555, 1.003937, 1.006398, 1.008858, 1.011319,
1.013780, 1.035925, 1.058071, 1.080217, 1.102362, 1.112205, 1.122047,
1.131890, 1.141732, 1.163878, 1.186024, 1.208169, 1.230315, 1.250000,
1.269685, 1.289370, 1.309055, 1.328740, 1.348425, 1.368110, 1.387795,
1.414862, 1.441929, 1.468996, 1.496063, 1.515748, 1.535433, 1.555118,
1.574803, 1.592028, 1.609252, 1.626476, 1.643701, 1.663386, 1.683071,
1.702756, 1.722441, 1.737205, 1.751969, 1.766732, 1.781496, 1.806102,
1.830709, 1.855315, 1.879921, 1.899606, 1.919291, 1.938976, 1.958661,
1.973425, 1.988189, 2.002953, 2.017717, 2.044784, 2.071851, 2.098917,
2.125984, 2.143209, 2.160433, 2.177658, 2.194882, 2.214567, 2.234252,
2.253937, 2.273622, 2.285925, 2.298228, 2.310532, 2.322835, 2.349902,
2.376969, 2.404035, 2.431102, 2.443406, 2.455709, 2.468012, 2.480315,
2.507382, 2.534449, 2.561516, 2.588583, 2.608268, 2.627953, 2.647638,
2.667323, 2.682087, 2.696851, 2.711614, 2.726378, 2.743603, 2.760827,
2.778051, 2.795276, 1.023622, 1.023622, 1.023622, 1.023622, 1.023622,
1.023622, 1.023622, 1.023622, 1.023622, 1.023622, 1.023622, 1.023622,
1.023622, 1.013780, 1.003937, 0.994094, 0.984252, 0.994094, 1.003937,
1.013780, 1.023622, 1.023622, 1.023622, 1.023622, 1.023622, 1.013780,
1.003937, 0.994094, 0.984252, 0.994094, 1.003937, 1.013780, 1.023622,
1.023622, 1.023622, 1.023622, 1.023622, 1.043307, 1.062992, 1.082677,
1.102362, 1.112205, 1.122047, 1.131890, 1.141732, 1.161417, 1.181102,
1.200787, 1.220472, 1.240157, 1.259843, 1.279528, 1.299213, 1.318898,
1.338583, 1.358268, 1.377953, 1.407480, 1.437008, 1.466535, 1.496063,
1.515748, 1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.633858,
1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.742126, 1.751969,
1.761811, 1.771654, 1.801181, 1.830709, 1.860236, 1.889764, 1.909449,
1.929134, 1.948819, 1.968504, 1.978346, 1.988189, 1.998031, 2.007874,
2.037402, 2.066929, 2.096457, 2.125984, 2.145669, 2.165354, 2.185039,
2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.293307, 2.303150,
2.312992, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945, 2.450787,
2.460630, 2.470472, 2.480315, 2.509843, 2.539370, 2.568898, 2.598425,
2.618110, 2.637795, 2.657480, 2.677166, 2.687008, 2.696851, 2.706693,
2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 1.043307, 1.040846,
1.038386, 1.035925, 1.033465, 1.035925, 1.038386, 1.040846, 1.043307,
1.043307, 1.043307, 1.043307, 1.043307, 1.035925, 1.028543, 1.021161,
1.013780, 1.018701, 1.023622, 1.028543, 1.033465, 1.035925, 1.038386,
1.040846, 1.043307, 1.035925, 1.028543, 1.021161, 1.013780, 1.018701,
1.023622, 1.028543, 1.033465, 1.035925, 1.038386, 1.040846, 1.043307,
1.058071, 1.072835, 1.087598, 1.102362, 1.114665, 1.126969, 1.139272,
1.151575, 1.168799, 1.186024, 1.203248, 1.220472, 1.242618, 1.264764,
1.286910, 1.309055, 1.326280, 1.343504, 1.360728, 1.377953, 1.407480,
1.437008, 1.466535, 1.496063, 1.515748, 1.535433, 1.555118, 1.574803,
1.594488, 1.614173, 1.633858, 1.653543, 1.673228, 1.692913, 1.712598,
1.732283, 1.744587, 1.756890, 1.769193, 1.781496, 1.806102, 1.830709,
1.855315, 1.879921, 1.899606, 1.919291, 1.938976, 1.958661, 1.970965,
1.983268, 1.995571, 2.007874, 2.034941, 2.062008, 2.089075, 2.116142,
2.138287, 2.160433, 2.182579, 2.204724, 2.221949, 2.239173, 2.256398,
2.273622, 2.285925, 2.298228, 2.310532, 2.322835, 2.349902, 2.376969,
2.404035, 2.431102, 2.445866, 2.460630, 2.475394, 2.490158, 2.514764,
2.539370, 2.563976, 2.588583, 2.608268, 2.627953, 2.647638, 2.667323,
2.679626, 2.691929, 2.704232, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 1.062992, 1.058071, 1.053150, 1.048228, 1.043307, 1.048228,
1.053150, 1.058071, 1.062992, 1.062992, 1.062992, 1.062992, 1.062992,
1.058071, 1.053150, 1.048228, 1.043307, 1.043307, 1.043307, 1.043307,
1.043307, 1.048228, 1.053150, 1.058071, 1.062992, 1.058071, 1.053150,
1.048228, 1.043307, 1.043307, 1.043307, 1.043307, 1.043307, 1.048228,
1.053150, 1.058071, 1.062992, 1.072835, 1.082677, 1.092520, 1.102362,
1.117126, 1.131890, 1.146654, 1.161417, 1.176181, 1.190945, 1.205709,
1.220472, 1.245079, 1.269685, 1.294291, 1.318898, 1.333661, 1.348425,
1.363189, 1.377953, 1.407480, 1.437008, 1.466535, 1.496063, 1.515748,
1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543,
1.673228, 1.692913, 1.712598, 1.732283, 1.747047, 1.761811, 1.776575,
1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.889764, 1.909449,
1.929134, 1.948819, 1.963583, 1.978346, 1.993110, 2.007874, 2.032480,
2.057087, 2.081693, 2.106299, 2.130906, 2.155512, 2.180118, 2.204724,
2.219488, 2.234252, 2.249016, 2.263780, 2.278543, 2.293307, 2.308071,
2.322835, 2.347441, 2.372047, 2.396654, 2.421260, 2.440945, 2.460630,
2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425,
2.618110, 2.637795, 2.657480, 2.672244, 2.687008, 2.701772, 2.716536,
2.736221, 2.755906, 2.775591, 2.795276, 1.082677, 1.075295, 1.067913,
1.060531, 1.053150, 1.060531, 1.067913, 1.075295, 1.082677, 1.082677,
1.082677, 1.082677, 1.082677, 1.080217, 1.077756, 1.075295, 1.072835,
1.067913, 1.062992, 1.058071, 1.053150, 1.060531, 1.067913, 1.075295,
1.082677, 1.080217, 1.077756, 1.075295, 1.072835, 1.067913, 1.062992,
1.058071, 1.053150, 1.060531, 1.067913, 1.075295, 1.082677, 1.087598,
1.092520, 1.097441, 1.102362, 1.119587, 1.136811, 1.154035, 1.171260,
1.183563, 1.195866, 1.208169, 1.220472, 1.247539, 1.274606, 1.301673,
1.328740, 1.341043, 1.353346, 1.365650, 1.377953, 1.407480, 1.437008,
1.466535, 1.496063, 1.515748, 1.535433, 1.555118, 1.574803, 1.594488,
1.614173, 1.633858, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283,
1.749508, 1.766732, 1.783957, 1.801181, 1.815945, 1.830709, 1.845472,
1.860236, 1.879921, 1.899606, 1.919291, 1.938976, 1.956201, 1.973425,
1.990650, 2.007874, 2.030020, 2.052165, 2.074311, 2.096457, 2.123524,
2.150591, 2.177658, 2.204724, 2.217028, 2.229331, 2.241634, 2.253937,
2.271161, 2.288386, 2.305610, 2.322835, 2.344980, 2.367126, 2.389272,
2.411417, 2.436024, 2.460630, 2.485236, 2.509843, 2.524606, 2.539370,
2.554134, 2.568898, 2.588583, 2.608268, 2.627953, 2.647638, 2.664862,
2.682087, 2.699311, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276,
1.102362, 1.092520, 1.082677, 1.072835, 1.062992, 1.072835, 1.082677,
1.092520, 1.102362, 1.102362, 1.102362, 1.102362, 1.102362, 1.102362,
1.102362, 1.102362, 1.102362, 1.092520, 1.082677, 1.072835, 1.062992,
1.072835, 1.082677, 1.092520, 1.102362, 1.102362, 1.102362, 1.102362,
1.102362, 1.092520, 1.082677, 1.072835, 1.062992, 1.072835, 1.082677,
1.092520, 1.102362, 1.102362, 1.102362, 1.102362, 1.102362, 1.122047,
1.141732, 1.161417, 1.181102, 1.190945, 1.200787, 1.210630, 1.220472,
1.250000, 1.279528, 1.309055, 1.338583, 1.348425, 1.358268, 1.368110,
1.377953, 1.407480, 1.437008, 1.466535, 1.496063, 1.515748, 1.535433,
1.555118, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543, 1.673228,
1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024,
1.820866, 1.830709, 1.840551, 1.850394, 1.870079, 1.889764, 1.909449,
1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559, 2.047244,
2.066929, 2.086614, 2.116142, 2.145669, 2.175197, 2.204724, 2.214567,
2.224410, 2.234252, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835,
2.342520, 2.362205, 2.381890, 2.401575, 2.431102, 2.460630, 2.490157,
2.519685, 2.529528, 2.539370, 2.549213, 2.559055, 2.578740, 2.598425,
2.618110, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221,
2.755906, 2.775591, 2.795276, 1.122047, 1.114665, 1.107283, 1.099902,
1.092520, 1.099902, 1.107283, 1.114665, 1.122047, 1.122047, 1.122047,
1.122047, 1.122047, 1.122047, 1.122047, 1.122047, 1.122047, 1.114665,
1.107283, 1.099902, 1.092520, 1.097441, 1.102362, 1.107283, 1.112205,
1.114665, 1.117126, 1.119587, 1.122047, 1.112205, 1.102362, 1.092520,
1.082677, 1.092520, 1.102362, 1.112205, 1.122047, 1.122047, 1.122047,
1.122047, 1.122047, 1.141732, 1.161417, 1.181102, 1.200787, 1.213091,
1.225394, 1.237697, 1.250000, 1.277067, 1.304134, 1.331201, 1.358268,
1.370571, 1.382874, 1.395177, 1.407480, 1.434547, 1.461614, 1.488681,
1.515748, 1.532972, 1.550197, 1.567421, 1.584646, 1.606791, 1.628937,
1.651083, 1.673228, 1.692913, 1.712598, 1.732283, 1.751969, 1.769193,
1.786417, 1.803642, 1.820866, 1.833169, 1.845472, 1.857776, 1.870079,
1.889764, 1.909449, 1.929134, 1.948819, 1.970965, 1.993110, 2.015256,
2.037402, 2.057087, 2.076772, 2.096457, 2.116142, 2.143209, 2.170276,
2.197343, 2.224410, 2.236713, 2.249016, 2.261319, 2.273622, 2.293307,
2.312992, 2.332677, 2.352362, 2.372047, 2.391732, 2.411417, 2.431103,
2.458169, 2.485236, 2.512303, 2.539370, 2.549213, 2.559055, 2.568898,
2.578740, 2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 2.696851,
2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.814961, 1.141732,
1.136811, 1.131890, 1.126969, 1.122047, 1.126969, 1.131890, 1.136811,
1.141732, 1.141732, 1.141732, 1.141732, 1.141732, 1.141732, 1.141732,
1.141732, 1.141732, 1.136811, 1.131890, 1.126969, 1.122047, 1.122047,
1.122047, 1.122047, 1.122047, 1.126969, 1.131890, 1.136811, 1.141732,
1.131890, 1.122047, 1.112205, 1.102362, 1.112205, 1.122047, 1.131890,
1.141732, 1.141732, 1.141732, 1.141732, 1.141732, 1.161417, 1.181102,
1.200787, 1.220472, 1.235236, 1.250000, 1.264764, 1.279528, 1.304134,
1.328740, 1.353346, 1.377953, 1.392717, 1.407480, 1.422244, 1.437008,
1.461614, 1.486220, 1.510827, 1.535433, 1.550197, 1.564961, 1.579724,
1.594488, 1.619094, 1.643701, 1.668307, 1.692913, 1.712598, 1.732283,
1.751969, 1.771654, 1.786417, 1.801181, 1.815945, 1.830709, 1.845472,
1.860236, 1.875000, 1.889764, 1.909449, 1.929134, 1.948819, 1.968504,
1.993110, 2.017717, 2.042323, 2.066929, 2.086614, 2.106299, 2.125984,
2.145669, 2.170276, 2.194882, 2.219488, 2.244095, 2.258858, 2.273622,
2.288386, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575,
2.421260, 2.440945, 2.460630, 2.485236, 2.509843, 2.534449, 2.559055,
2.568898, 2.578740, 2.588583, 2.598425, 2.618110, 2.637795, 2.657480,
2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276,
2.814961, 2.834646, 1.161417, 1.158957, 1.156496, 1.154035, 1.151575,
1.154035, 1.156496, 1.158957, 1.161417, 1.161417, 1.161417, 1.161417,
1.161417, 1.161417, 1.161417, 1.161417, 1.161417, 1.158957, 1.156496,
1.154035, 1.151575, 1.146654, 1.141732, 1.136811, 1.131890, 1.139272,
1.146654, 1.154035, 1.161417, 1.151575, 1.141732, 1.131890, 1.122047,
1.131890, 1.141732, 1.151575, 1.161417, 1.161417, 1.161417, 1.161417,
1.161417, 1.181102, 1.200787, 1.220472, 1.240157, 1.257382, 1.274606,
1.291831, 1.309055, 1.331201, 1.353346, 1.375492, 1.397638, 1.414862,
1.432087, 1.449311, 1.466535, 1.488681, 1.510827, 1.532972, 1.555118,
1.567421, 1.579724, 1.592028, 1.604331, 1.631398, 1.658465, 1.685531,
1.712598, 1.732283, 1.751969, 1.771654, 1.791339, 1.803642, 1.815945,
1.828248, 1.840551, 1.857776, 1.875000, 1.892224, 1.909449, 1.929134,
1.948819, 1.968504, 1.988189, 2.015256, 2.042323, 2.069390, 2.096457,
2.116142, 2.135827, 2.155512, 2.175197, 2.197343, 2.219488, 2.241634,
2.263780, 2.281004, 2.298228, 2.315453, 2.332677, 2.352362, 2.372047,
2.391732, 2.411417, 2.431102, 2.450787, 2.470472, 2.490158, 2.512303,
2.534449, 2.556595, 2.578740, 2.588583, 2.598425, 2.608268, 2.618110,
2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906,
2.775591, 2.795276, 2.814961, 2.834646, 2.854331, 1.181102, 1.181102,
1.181102, 1.181102, 1.181102, 1.181102, 1.181102, 1.181102, 1.181102,
1.181102, 1.181102, 1.181102, 1.181102, 1.181102, 1.181102, 1.181102,
1.181102, 1.181102, 1.181102, 1.181102, 1.181102, 1.171260, 1.161417,
1.151575, 1.141732, 1.151575, 1.161417, 1.171260, 1.181102, 1.171260,
1.161417, 1.151575, 1.141732, 1.151575, 1.161417, 1.171260, 1.181102,
1.181102, 1.181102, 1.181102, 1.181102, 1.200787, 1.220472, 1.240157,
1.259843, 1.279528, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953,
1.397638, 1.417323, 1.437008, 1.456693, 1.476378, 1.496063, 1.515748,
1.535433, 1.555118, 1.574803, 1.584646, 1.594488, 1.604331, 1.614173,
1.643701, 1.673228, 1.702756, 1.732283, 1.751969, 1.771654, 1.791339,
1.811024, 1.820866, 1.830709, 1.840551, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.037402,
2.066929, 2.096457, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724,
2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520,
2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.608268,
2.618110, 2.627953, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536,
2.736221, 2.755906, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331,
2.874016, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787,
1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787,
1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787,
1.200787, 1.193406, 1.186024, 1.178642, 1.171260, 1.176181, 1.181102,
1.186024, 1.190945, 1.186024, 1.181102, 1.176181, 1.171260, 1.178642,
1.186024, 1.193406, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787,
1.215551, 1.230315, 1.245079, 1.259843, 1.279528, 1.299213, 1.318898,
1.338583, 1.358268, 1.377953, 1.397638, 1.417323, 1.434547, 1.451772,
1.468996, 1.486220, 1.505906, 1.525591, 1.545276, 1.564961, 1.579724,
1.594488, 1.609252, 1.624016, 1.648622, 1.673228, 1.697835, 1.722441,
1.742126, 1.761811, 1.781496, 1.801181, 1.815945, 1.830709, 1.845472,
1.860236, 1.877461, 1.894685, 1.911909, 1.929134, 1.948819, 1.968504,
1.988189, 2.007874, 2.037402, 2.066929, 2.096457, 2.125984, 2.143209,
2.160433, 2.177658, 2.194882, 2.214567, 2.234252, 2.253937, 2.273622,
2.295768, 2.317913, 2.340059, 2.362205, 2.379429, 2.396654, 2.413878,
2.431102, 2.450787, 2.470472, 2.490157, 2.509843, 2.529528, 2.549213,
2.568898, 2.588583, 2.603346, 2.618110, 2.632874, 2.647638, 2.667323,
2.687008, 2.706693, 2.726378, 2.743603, 2.760827, 2.778051, 2.795276,
2.814961, 2.834646, 2.854331, 2.874016, 1.220472, 1.220472, 1.220472,
1.220472, 1.220472, 1.220472, 1.220472, 1.220472, 1.220472, 1.220472,
1.220472, 1.220472, 1.220472, 1.220472, 1.220472, 1.220472, 1.220472,
1.220472, 1.220472, 1.220472, 1.220472, 1.215551, 1.210630, 1.205709,
1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787, 1.200787,
1.200787, 1.200787, 1.205709, 1.210630, 1.215551, 1.220472, 1.220472,
1.220472, 1.220472, 1.220472, 1.230315, 1.240157, 1.250000, 1.259843,
1.279528, 1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638,
1.417323, 1.432087, 1.446850, 1.461614, 1.476378, 1.496063, 1.515748,
1.535433, 1.555118, 1.574803, 1.594488, 1.614173, 1.633858, 1.653543,
1.673228, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.791339,
1.811024, 1.830709, 1.850394, 1.870079, 1.884843, 1.899606, 1.914370,
1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.037402, 2.066929,
2.096457, 2.125984, 2.140748, 2.155512, 2.170276, 2.185039, 2.204724,
2.224410, 2.244095, 2.263780, 2.288386, 2.312992, 2.337598, 2.362205,
2.376969, 2.391732, 2.406496, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110,
2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.750984,
2.765748, 2.780512, 2.795276, 2.814961, 2.834646, 2.854331, 2.874016,
1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157,
1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157,
1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157,
1.237697, 1.235236, 1.232776, 1.230315, 1.225394, 1.220472, 1.215551,
1.210630, 1.215551, 1.220472, 1.225394, 1.230315, 1.232776, 1.235236,
1.237697, 1.240157, 1.240157, 1.240157, 1.240157, 1.240157, 1.245079,
1.250000, 1.254921, 1.259843, 1.279528, 1.299213, 1.318898, 1.338583,
1.358268, 1.377953, 1.397638, 1.417323, 1.429626, 1.441929, 1.454232,
1.466535, 1.486220, 1.505906, 1.525591, 1.545276, 1.569882, 1.594488,
1.619094, 1.643701, 1.658465, 1.673228, 1.687992, 1.702756, 1.722441,
1.742126, 1.761811, 1.781496, 1.806102, 1.830709, 1.855315, 1.879921,
1.892224, 1.904528, 1.916831, 1.929134, 1.948819, 1.968504, 1.988189,
2.007874, 2.037402, 2.066929, 2.096457, 2.125984, 2.138287, 2.150591,
2.162894, 2.175197, 2.194882, 2.214567, 2.234252, 2.253937, 2.281004,
2.308071, 2.335138, 2.362205, 2.374508, 2.386811, 2.399114, 2.411417,
2.431102, 2.450787, 2.470472, 2.490158, 2.509843, 2.529528, 2.549213,
2.568898, 2.593504, 2.618110, 2.642716, 2.667323, 2.687008, 2.706693,
2.726378, 2.746063, 2.758366, 2.770669, 2.782973, 2.795276, 2.814961,
2.834646, 2.854331, 2.874016, 1.259843, 1.259843, 1.259843, 1.259843,
1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843,
1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843,
1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843,
1.250000, 1.240157, 1.230315, 1.220472, 1.230315, 1.240157, 1.250000,
1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843,
1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.259843, 1.279528,
1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.417323,
1.427165, 1.437008, 1.446850, 1.456693, 1.476378, 1.496063, 1.515748,
1.535433, 1.564961, 1.594488, 1.624016, 1.653543, 1.663386, 1.673228,
1.683071, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.801181,
1.830709, 1.860236, 1.889764, 1.899606, 1.909449, 1.919291, 1.929134,
1.948819, 1.968504, 1.988189, 2.007874, 2.037402, 2.066929, 2.096457,
2.125984, 2.135827, 2.145669, 2.155512, 2.165354, 2.185039, 2.204724,
2.224410, 2.244095, 2.273622, 2.303150, 2.332677, 2.362205, 2.372047,
2.381890, 2.391732, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.588583, 2.618110, 2.647638,
2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.765748, 2.775591,
2.785433, 2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 1.279528,
1.279528, 1.279528, 1.279528, 1.279528, 1.279528, 1.279528, 1.279528,
1.279528, 1.277067, 1.274606, 1.272146, 1.269685, 1.272146, 1.274606,
1.277067, 1.279528, 1.279528, 1.279528, 1.279528, 1.279528, 1.279528,
1.279528, 1.279528, 1.279528, 1.269685, 1.259843, 1.250000, 1.240157,
1.250000, 1.259843, 1.269685, 1.279528, 1.277067, 1.274606, 1.272146,
1.269685, 1.272146, 1.274606, 1.277067, 1.279528, 1.279528, 1.279528,
1.279528, 1.279528, 1.291831, 1.304134, 1.316437, 1.328740, 1.348425,
1.368110, 1.387795, 1.407480, 1.419783, 1.432087, 1.444390, 1.456693,
1.476378, 1.496063, 1.515748, 1.535433, 1.562500, 1.589567, 1.616634,
1.643701, 1.656004, 1.668307, 1.680610, 1.692913, 1.712598, 1.732283,
1.751969, 1.771654, 1.801181, 1.830709, 1.860236, 1.889764, 1.902067,
1.914370, 1.926673, 1.938976, 1.958661, 1.978346, 1.998031, 2.017717,
2.042323, 2.066929, 2.091536, 2.116142, 2.128445, 2.140748, 2.153051,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.271161, 2.298228,
2.325295, 2.352362, 2.364665, 2.376969, 2.389272, 2.401575, 2.421260,
2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
2.586122, 2.613189, 2.640256, 2.667323, 2.689469, 2.711614, 2.733760,
2.755906, 2.768209, 2.780512, 2.792815, 2.805118, 2.822343, 2.839567,
2.856791, 2.874016, 1.299213, 1.299213, 1.299213, 1.299213, 1.299213,
1.299213, 1.299213, 1.299213, 1.299213, 1.294291, 1.289370, 1.284449,
1.279528, 1.284449, 1.289370, 1.294291, 1.299213, 1.299213, 1.299213,
1.299213, 1.299213, 1.299213, 1.299213, 1.299213, 1.299213, 1.289370,
1.279528, 1.269685, 1.259843, 1.269685, 1.279528, 1.289370, 1.299213,
1.294291, 1.289370, 1.284449, 1.279528, 1.284449, 1.289370, 1.294291,
1.299213, 1.299213, 1.299213, 1.299213, 1.299213, 1.304134, 1.309055,
1.313976, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.412402,
1.427165, 1.441929, 1.456693, 1.476378, 1.496063, 1.515748, 1.535433,
1.560039, 1.584646, 1.609252, 1.633858, 1.648622, 1.663386, 1.678150,
1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.801181, 1.830709,
1.860236, 1.889764, 1.904528, 1.919291, 1.934055, 1.948819, 1.968504,
1.988189, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.106299,
2.121063, 2.135827, 2.150591, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.268701, 2.293307, 2.317913, 2.342520, 2.357284, 2.372047,
2.386811, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.583662, 2.608268, 2.632874, 2.657480,
2.682087, 2.706693, 2.731299, 2.755906, 2.770669, 2.785433, 2.800197,
2.814961, 2.829725, 2.844488, 2.859252, 2.874016, 1.318898, 1.318898,
1.318898, 1.318898, 1.318898, 1.318898, 1.318898, 1.318898, 1.318898,
1.311516, 1.304134, 1.296752, 1.289370, 1.296752, 1.304134, 1.311516,
1.318898, 1.318898, 1.318898, 1.318898, 1.318898, 1.318898, 1.318898,
1.318898, 1.318898, 1.309055, 1.299213, 1.289370, 1.279528, 1.289370,
1.299213, 1.309055, 1.318898, 1.311516, 1.304134, 1.296752, 1.289370,
1.296752, 1.304134, 1.311516, 1.318898, 1.318898, 1.318898, 1.318898,
1.318898, 1.316437, 1.313976, 1.311516, 1.309055, 1.328740, 1.348425,
1.368110, 1.387795, 1.405020, 1.422244, 1.439469, 1.456693, 1.476378,
1.496063, 1.515748, 1.535433, 1.557579, 1.579724, 1.601870, 1.624016,
1.641240, 1.658465, 1.675689, 1.692913, 1.712598, 1.732283, 1.751969,
1.771654, 1.801181, 1.830709, 1.860236, 1.889764, 1.906988, 1.924213,
1.941437, 1.958661, 1.978346, 1.998031, 2.017717, 2.037402, 2.052165,
2.066929, 2.081693, 2.096457, 2.113681, 2.130906, 2.148130, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.266240, 2.288386, 2.310532,
2.332677, 2.349902, 2.367126, 2.384350, 2.401575, 2.421260, 2.440945,
2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.581201,
2.603347, 2.625492, 2.647638, 2.674705, 2.701772, 2.728839, 2.755906,
2.773130, 2.790354, 2.807579, 2.824803, 2.837106, 2.849410, 2.861713,
2.874016, 1.338583, 1.338583, 1.338583, 1.338583, 1.338583, 1.338583,
1.338583, 1.338583, 1.338583, 1.328740, 1.318898, 1.309055, 1.299213,
1.309055, 1.318898, 1.328740, 1.338583, 1.338583, 1.338583, 1.338583,
1.338583, 1.338583, 1.338583, 1.338583, 1.338583, 1.328740, 1.318898,
1.309055, 1.299213, 1.309055, 1.318898, 1.328740, 1.338583, 1.328740,
1.318898, 1.309055, 1.299213, 1.309055, 1.318898, 1.328740, 1.338583,
1.338583, 1.338583, 1.338583, 1.338583, 1.328740, 1.318898, 1.309055,
1.299213, 1.318898, 1.338583, 1.358268, 1.377953, 1.397638, 1.417323,
1.437008, 1.456693, 1.476378, 1.496063, 1.515748, 1.535433, 1.555118,
1.574803, 1.594488, 1.614173, 1.633858, 1.653543, 1.673228, 1.692913,
1.712598, 1.732283, 1.751969, 1.771654, 1.801181, 1.830709, 1.860236,
1.889764, 1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874,
2.027559, 2.047244, 2.057087, 2.066929, 2.076772, 2.086614, 2.106299,
2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095,
2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890,
2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685,
2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.667323,
2.696851, 2.726378, 2.755906, 2.775591, 2.795276, 2.814961, 2.834646,
2.844488, 2.854331, 2.864173, 2.874016, 1.358268, 1.358268, 1.358268,
1.358268, 1.358268, 1.358268, 1.358268, 1.358268, 1.358268, 1.350886,
1.343504, 1.336122, 1.328740, 1.333661, 1.338583, 1.343504, 1.348425,
1.350886, 1.353346, 1.355807, 1.358268, 1.355807, 1.353346, 1.350886,
1.348425, 1.343504, 1.338583, 1.333661, 1.328740, 1.336122, 1.343504,
1.350886, 1.358268, 1.350886, 1.343504, 1.336122, 1.328740, 1.336122,
1.343504, 1.350886, 1.358268, 1.358268, 1.358268, 1.358268, 1.358268,
1.350886, 1.343504, 1.336122, 1.328740, 1.348425, 1.368110, 1.387795,
1.407480, 1.424705, 1.441929, 1.459154, 1.476378, 1.498524, 1.520669,
1.542815, 1.564961, 1.582185, 1.599409, 1.616634, 1.633858, 1.653543,
1.673228, 1.692913, 1.712598, 1.734744, 1.756890, 1.779035, 1.801181,
1.825787, 1.850394, 1.875000, 1.899606, 1.919291, 1.938976, 1.958661,
1.978346, 1.998031, 2.017717, 2.037402, 2.057087, 2.071851, 2.086614,
2.101378, 2.116142, 2.133366, 2.150591, 2.167815, 2.185039, 2.204724,
2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520,
2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110,
2.637795, 2.657480, 2.684547, 2.711614, 2.738681, 2.765748, 2.785433,
2.805118, 2.824803, 2.844488, 2.856791, 2.869095, 2.881398, 2.893701,
1.377953, 1.377953, 1.377953, 1.377953, 1.377953, 1.377953, 1.377953,
1.377953, 1.377953, 1.373032, 1.368110, 1.363189, 1.358268, 1.358268,
1.358268, 1.358268, 1.358268, 1.363189, 1.368110, 1.373032, 1.377953,
1.373032, 1.368110, 1.363189, 1.358268, 1.358268, 1.358268, 1.358268,
1.358268, 1.363189, 1.368110, 1.373032, 1.377953, 1.373032, 1.368110,
1.363189, 1.358268, 1.363189, 1.368110, 1.373032, 1.377953, 1.377953,
1.377953, 1.377953, 1.377953, 1.373032, 1.368110, 1.363189, 1.358268,
1.377953, 1.397638, 1.417323, 1.437008, 1.451772, 1.466535, 1.481299,
1.496063, 1.520669, 1.545276, 1.569882, 1.594488, 1.609252, 1.624016,
1.638780, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.756890,
1.781496, 1.806102, 1.830709, 1.850394, 1.870079, 1.889764, 1.909449,
1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559, 2.047244,
2.066929, 2.086614, 2.106299, 2.125984, 2.145669, 2.160433, 2.175197,
2.189961, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150,
2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.440945,
2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 2.701772, 2.726378,
2.750984, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331, 2.869095,
2.883858, 2.898622, 2.913386, 1.397638, 1.397638, 1.397638, 1.397638,
1.397638, 1.397638, 1.397638, 1.397638, 1.397638, 1.395177, 1.392717,
1.390256, 1.387795, 1.382874, 1.377953, 1.373032, 1.368110, 1.375492,
1.382874, 1.390256, 1.397638, 1.390256, 1.382874, 1.375492, 1.368110,
1.373032, 1.377953, 1.382874, 1.387795, 1.390256, 1.392717, 1.395177,
1.397638, 1.395177, 1.392717, 1.390256, 1.387795, 1.390256, 1.392717,
1.395177, 1.397638, 1.397638, 1.397638, 1.397638, 1.397638, 1.395177,
1.392717, 1.390256, 1.387795, 1.407480, 1.427165, 1.446850, 1.466535,
1.478839, 1.491142, 1.503445, 1.515748, 1.542815, 1.569882, 1.596949,
1.624016, 1.636319, 1.648622, 1.660925, 1.673228, 1.692913, 1.712598,
1.732283, 1.751969, 1.779035, 1.806102, 1.833169, 1.860236, 1.875000,
1.889764, 1.904528, 1.919291, 1.938976, 1.958661, 1.978346, 1.998031,
2.017717, 2.037402, 2.057087, 2.076772, 2.101378, 2.125984, 2.150591,
2.175197, 2.187500, 2.199803, 2.212106, 2.224410, 2.244095, 2.263780,
2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575,
2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.657480, 2.677166,
2.696851, 2.718996, 2.741142, 2.763288, 2.785433, 2.805118, 2.824803,
2.844488, 2.864173, 2.881398, 2.898622, 2.915847, 2.933071, 1.417323,
1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323,
1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.407480, 1.397638,
1.387795, 1.377953, 1.387795, 1.397638, 1.407480, 1.417323, 1.407480,
1.397638, 1.387795, 1.377953, 1.387795, 1.397638, 1.407480, 1.417323,
1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323,
1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323,
1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.417323, 1.437008,
1.456693, 1.476378, 1.496063, 1.505906, 1.515748, 1.525591, 1.535433,
1.564961, 1.594488, 1.624016, 1.653543, 1.663386, 1.673228, 1.683071,
1.692913, 1.712598, 1.732283, 1.751969, 1.771654, 1.801181, 1.830709,
1.860236, 1.889764, 1.899606, 1.909449, 1.919291, 1.929134, 1.948819,
1.968504, 1.988189, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614,
2.116142, 2.145669, 2.175197, 2.204724, 2.214567, 2.224410, 2.234252,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205,
2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795,
2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386,
2.933071, 2.952756, 1.427165, 1.427165, 1.427165, 1.427165, 1.427165,
1.429626, 1.432087, 1.434547, 1.437008, 1.437008, 1.437008, 1.437008,
1.437008, 1.427165, 1.417323, 1.407480, 1.397638, 1.407480, 1.417323,
1.427165, 1.437008, 1.429626, 1.422244, 1.414862, 1.407480, 1.412402,
1.417323, 1.422244, 1.427165, 1.429626, 1.432087, 1.434547, 1.437008,
1.434547, 1.432087, 1.429626, 1.427165, 1.429626, 1.432087, 1.434547,
1.437008, 1.434547, 1.432087, 1.429626, 1.427165, 1.427165, 1.427165,
1.427165, 1.427165, 1.444390, 1.461614, 1.478839, 1.496063, 1.505906,
1.515748, 1.525591, 1.535433, 1.564961, 1.594488, 1.624016, 1.653543,
1.663386, 1.673228, 1.683071, 1.692913, 1.712598, 1.732283, 1.751969,
1.771654, 1.798720, 1.825787, 1.852854, 1.879921, 1.894685, 1.909449,
1.924213, 1.938976, 1.956201, 1.973425, 1.990650, 2.007874, 2.030020,
2.052165, 2.074311, 2.096457, 2.121063, 2.145669, 2.170276, 2.194882,
2.209646, 2.224410, 2.239173, 2.253937, 2.271161, 2.288386, 2.305610,
2.322835, 2.344980, 2.367126, 2.389272, 2.411417, 2.428642, 2.445866,
2.463091, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536,
2.736221, 2.755906, 2.775591, 2.795276, 2.817421, 2.839567, 2.861713,
2.883858, 2.901083, 2.918307, 2.935532, 2.952756, 1.437008, 1.437008,
1.437008, 1.437008, 1.437008, 1.441929, 1.446850, 1.451772, 1.456693,
1.456693, 1.456693, 1.456693, 1.456693, 1.446850, 1.437008, 1.427165,
1.417323, 1.427165, 1.437008, 1.446850, 1.456693, 1.451772, 1.446850,
1.441929, 1.437008, 1.437008, 1.437008, 1.437008, 1.437008, 1.441929,
1.446850, 1.451772, 1.456693, 1.451772, 1.446850, 1.441929, 1.437008,
1.441929, 1.446850, 1.451772, 1.456693, 1.451772, 1.446850, 1.441929,
1.437008, 1.437008, 1.437008, 1.437008, 1.437008, 1.451772, 1.466535,
1.481299, 1.496063, 1.505906, 1.515748, 1.525591, 1.535433, 1.564961,
1.594488, 1.624016, 1.653543, 1.663386, 1.673228, 1.683071, 1.692913,
1.712598, 1.732283, 1.751969, 1.771654, 1.796260, 1.820866, 1.845472,
1.870079, 1.889764, 1.909449, 1.929134, 1.948819, 1.963583, 1.978346,
1.993110, 2.007874, 2.032480, 2.057087, 2.081693, 2.106299, 2.125984,
2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780,
2.278543, 2.293307, 2.308071, 2.322835, 2.347441, 2.372047, 2.396654,
2.421260, 2.436024, 2.450787, 2.465551, 2.480315, 2.500000, 2.519685,
2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.657480,
2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276,
2.819882, 2.844488, 2.869095, 2.893701, 2.908465, 2.923229, 2.937992,
2.952756, 1.446850, 1.446850, 1.446850, 1.446850, 1.446850, 1.454232,
1.461614, 1.468996, 1.476378, 1.476378, 1.476378, 1.476378, 1.476378,
1.466535, 1.456693, 1.446850, 1.437008, 1.446850, 1.456693, 1.466535,
1.476378, 1.473917, 1.471457, 1.468996, 1.466535, 1.461614, 1.456693,
1.451772, 1.446850, 1.454232, 1.461614, 1.468996, 1.476378, 1.468996,
1.461614, 1.454232, 1.446850, 1.454232, 1.461614, 1.468996, 1.476378,
1.468996, 1.461614, 1.454232, 1.446850, 1.446850, 1.446850, 1.446850,
1.446850, 1.459154, 1.471457, 1.483760, 1.496063, 1.505906, 1.515748,
1.525591, 1.535433, 1.564961, 1.594488, 1.624016, 1.653543, 1.663386,
1.673228, 1.683071, 1.692913, 1.712598, 1.732283, 1.751969, 1.771654,
1.793799, 1.815945, 1.838091, 1.860236, 1.884843, 1.909449, 1.934055,
1.958661, 1.970965, 1.983268, 1.995571, 2.007874, 2.034941, 2.062008,
2.089075, 2.116142, 2.130906, 2.145669, 2.160433, 2.175197, 2.199803,
2.224410, 2.249016, 2.273622, 2.285925, 2.298228, 2.310532, 2.322835,
2.349902, 2.376969, 2.404035, 2.431102, 2.443406, 2.455709, 2.468012,
2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425,
2.618110, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221,
2.755906, 2.775591, 2.795276, 2.822343, 2.849410, 2.876476, 2.903543,
2.915847, 2.928150, 2.940453, 2.952756, 1.456693, 1.456693, 1.456693,
1.456693, 1.456693, 1.466535, 1.476378, 1.486220, 1.496063, 1.496063,
1.496063, 1.496063, 1.496063, 1.486220, 1.476378, 1.466535, 1.456693,
1.466535, 1.476378, 1.486220, 1.496063, 1.496063, 1.496063, 1.496063,
1.496063, 1.486220, 1.476378, 1.466535, 1.456693, 1.466535, 1.476378,
1.486220, 1.496063, 1.486220, 1.476378, 1.466535, 1.456693, 1.466535,
1.476378, 1.486220, 1.496063, 1.486220, 1.476378, 1.466535, 1.456693,
1.456693, 1.456693, 1.456693, 1.456693, 1.466535, 1.476378, 1.486220,
1.496063, 1.505906, 1.515748, 1.525591, 1.535433, 1.564961, 1.594488,
1.624016, 1.653543, 1.663386, 1.673228, 1.683071, 1.692913, 1.712598,
1.732283, 1.751969, 1.771654, 1.791339, 1.811024, 1.830709, 1.850394,
1.879921, 1.909449, 1.938976, 1.968504, 1.978346, 1.988189, 1.998031,
2.007874, 2.037402, 2.066929, 2.096457, 2.125984, 2.135827, 2.145669,
2.155512, 2.165354, 2.194882, 2.224410, 2.253937, 2.283465, 2.293307,
2.303150, 2.312992, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945,
2.450787, 2.460630, 2.470472, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.657480, 2.677166,
2.696851, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.824803,
2.854331, 2.883858, 2.913386, 2.923228, 2.933071, 2.942913, 2.952756,
1.476378, 1.476378, 1.476378, 1.476378, 1.476378, 1.486220, 1.496063,
1.505906, 1.515748, 1.515748, 1.515748, 1.515748, 1.515748, 1.508366,
1.500984, 1.493602, 1.486220, 1.493602, 1.500984, 1.508366, 1.515748,
1.515748, 1.515748, 1.515748, 1.515748, 1.505906, 1.496063, 1.486220,
1.476378, 1.483760, 1.491142, 1.498524, 1.505906, 1.500984, 1.496063,
1.491142, 1.486220, 1.493602, 1.500984, 1.508366, 1.515748, 1.508366,
1.500984, 1.493602, 1.486220, 1.483760, 1.481299, 1.478839, 1.476378,
1.483760, 1.491142, 1.498524, 1.505906, 1.513287, 1.520669, 1.528051,
1.535433, 1.562500, 1.589567, 1.616634, 1.643701, 1.658465, 1.673228,
1.687992, 1.702756, 1.722441, 1.742126, 1.761811, 1.781496, 1.801181,
1.820866, 1.840551, 1.860236, 1.884843, 1.909449, 1.934055, 1.958661,
1.973425, 1.988189, 2.002953, 2.017717, 2.042323, 2.066929, 2.091536,
2.116142, 2.128445, 2.140748, 2.153051, 2.165354, 2.192421, 2.219488,
2.246555, 2.273622, 2.285925, 2.298228, 2.310532, 2.322835, 2.349902,
2.376969, 2.404035, 2.431102, 2.443406, 2.455709, 2.468012, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110,
2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906,
2.775591, 2.795276, 2.822343, 2.849410, 2.876476, 2.903543, 2.915847,
2.928150, 2.940453, 2.952756, 1.496063, 1.496063, 1.496063, 1.496063,
1.496063, 1.505906, 1.515748, 1.525591, 1.535433, 1.535433, 1.535433,
1.535433, 1.535433, 1.530512, 1.525591, 1.520669, 1.515748, 1.520669,
1.525591, 1.530512, 1.535433, 1.535433, 1.535433, 1.535433, 1.535433,
1.525591, 1.515748, 1.505906, 1.496063, 1.500984, 1.505906, 1.510827,
1.515748, 1.515748, 1.515748, 1.515748, 1.515748, 1.520669, 1.525591,
1.530512, 1.535433, 1.530512, 1.525591, 1.520669, 1.515748, 1.510827,
1.505906, 1.500984, 1.496063, 1.500984, 1.505906, 1.510827, 1.515748,
1.520669, 1.525591, 1.530512, 1.535433, 1.560039, 1.584646, 1.609252,
1.633858, 1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.751969,
1.771654, 1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559,
2.047244, 2.066929, 2.086614, 2.106299, 2.121063, 2.135827, 2.150591,
2.165354, 2.189961, 2.214567, 2.239173, 2.263780, 2.278543, 2.293307,
2.308071, 2.322835, 2.347441, 2.372047, 2.396654, 2.421260, 2.436024,
2.450787, 2.465551, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
2.578740, 2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 2.696851,
2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.819882, 2.844488,
2.869095, 2.893701, 2.908465, 2.923229, 2.937992, 2.952756, 1.515748,
1.515748, 1.515748, 1.515748, 1.515748, 1.525591, 1.535433, 1.545276,
1.555118, 1.555118, 1.555118, 1.555118, 1.555118, 1.552657, 1.550197,
1.547736, 1.545276, 1.547736, 1.550197, 1.552657, 1.555118, 1.555118,
1.555118, 1.555118, 1.555118, 1.545276, 1.535433, 1.525591, 1.515748,
1.518209, 1.520669, 1.523130, 1.525591, 1.530512, 1.535433, 1.540354,
1.545276, 1.547736, 1.550197, 1.552657, 1.555118, 1.552657, 1.550197,
1.547736, 1.545276, 1.537894, 1.530512, 1.523130, 1.515748, 1.518209,
1.520669, 1.523130, 1.525591, 1.528051, 1.530512, 1.532972, 1.535433,
1.557579, 1.579724, 1.601870, 1.624016, 1.648622, 1.673228, 1.697835,
1.722441, 1.742126, 1.761811, 1.781496, 1.801181, 1.820866, 1.840551,
1.860236, 1.879921, 1.894685, 1.909449, 1.924213, 1.938976, 1.963583,
1.988189, 2.012795, 2.037402, 2.052165, 2.066929, 2.081693, 2.096457,
2.113681, 2.130906, 2.148130, 2.165354, 2.187500, 2.209646, 2.231791,
2.253937, 2.271161, 2.288386, 2.305610, 2.322835, 2.344980, 2.367126,
2.389272, 2.411417, 2.428642, 2.445866, 2.463091, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795,
2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 2.817421, 2.839567, 2.861713, 2.883858, 2.901083, 2.918307,
2.935532, 2.952756, 1.535433, 1.535433, 1.535433, 1.535433, 1.535433,
1.545276, 1.555118, 1.564961, 1.574803, 1.574803, 1.574803, 1.574803,
1.574803, 1.574803, 1.574803, 1.574803, 1.574803, 1.574803, 1.574803,
1.574803, 1.574803, 1.574803, 1.574803, 1.574803, 1.574803, 1.564961,
1.555118, 1.545276, 1.535433, 1.535433, 1.535433, 1.535433, 1.535433,
1.545276, 1.555118, 1.564961, 1.574803, 1.574803, 1.574803, 1.574803,
1.574803, 1.574803, 1.574803, 1.574803, 1.574803, 1.564961, 1.555118,
1.545276, 1.535433, 1.535433, 1.535433, 1.535433, 1.535433, 1.535433,
1.535433, 1.535433, 1.535433, 1.555118, 1.574803, 1.594488, 1.614173,
1.643701, 1.673228, 1.702756, 1.732283, 1.751969, 1.771654, 1.791339,
1.811024, 1.830709, 1.850394, 1.870079, 1.889764, 1.899606, 1.909449,
1.919291, 1.929134, 1.958661, 1.988189, 2.017717, 2.047244, 2.057087,
2.066929, 2.076772, 2.086614, 2.106299, 2.125984, 2.145669, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150,
2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.440945,
2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536,
2.736221, 2.755906, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331,
2.874016, 2.893701, 2.913386, 2.933071, 2.952756, 1.564961, 1.564961,
1.564961, 1.564961, 1.564961, 1.569882, 1.574803, 1.579724, 1.584646,
1.587106, 1.589567, 1.592028, 1.594488, 1.592028, 1.589567, 1.587106,
1.584646, 1.587106, 1.589567, 1.592028, 1.594488, 1.594488, 1.594488,
1.594488, 1.594488, 1.587106, 1.579724, 1.572343, 1.564961, 1.564961,
1.564961, 1.564961, 1.564961, 1.572343, 1.579724, 1.587106, 1.594488,
1.594488, 1.594488, 1.594488, 1.594488, 1.594488, 1.594488, 1.594488,
1.594488, 1.584646, 1.574803, 1.564961, 1.555118, 1.557579, 1.560039,
1.562500, 1.564961, 1.564961, 1.564961, 1.564961, 1.564961, 1.584646,
1.604331, 1.624016, 1.643701, 1.668307, 1.692913, 1.717520, 1.742126,
1.764272, 1.786417, 1.808563, 1.830709, 1.847933, 1.865157, 1.882382,
1.899606, 1.911909, 1.924213, 1.936516, 1.948819, 1.975886, 2.002953,
2.030020, 2.057087, 2.069390, 2.081693, 2.093996, 2.106299, 2.125984,
2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780,
2.283465, 2.303150, 2.322835, 2.342520, 2.364665, 2.386811, 2.408957,
2.431103, 2.450788, 2.470473, 2.490158, 2.509843, 2.529528, 2.549213,
2.568898, 2.588583, 2.605807, 2.623032, 2.640256, 2.657480, 2.677166,
2.696851, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.814961,
2.834646, 2.854331, 2.874016, 2.893701, 2.915847, 2.937992, 2.960138,
2.982284, 1.594488, 1.594488, 1.594488, 1.594488, 1.594488, 1.594488,
1.594488, 1.594488, 1.594488, 1.599409, 1.604331, 1.609252, 1.614173,
1.609252, 1.604331, 1.599409, 1.594488, 1.599409, 1.604331, 1.609252,
1.614173, 1.614173, 1.614173, 1.614173, 1.614173, 1.609252, 1.604331,
1.599409, 1.594488, 1.594488, 1.594488, 1.594488, 1.594488, 1.599409,
1.604331, 1.609252, 1.614173, 1.614173, 1.614173, 1.614173, 1.614173,
1.614173, 1.614173, 1.614173, 1.614173, 1.604331, 1.594488, 1.584646,
1.574803, 1.579724, 1.584646, 1.589567, 1.594488, 1.594488, 1.594488,
1.594488, 1.594488, 1.614173, 1.633858, 1.653543, 1.673228, 1.692913,
1.712598, 1.732283, 1.751969, 1.776575, 1.801181, 1.825787, 1.850394,
1.865157, 1.879921, 1.894685, 1.909449, 1.924213, 1.938976, 1.953740,
1.968504, 1.993110, 2.017717, 2.042323, 2.066929, 2.081693, 2.096457,
2.111221, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205,
2.386811, 2.411417, 2.436024, 2.460630, 2.480315, 2.500000, 2.519685,
2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.632874, 2.647638,
2.662402, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386,
2.937992, 2.962599, 2.987205, 3.011811, 1.624016, 1.624016, 1.624016,
1.624016, 1.624016, 1.619094, 1.614173, 1.609252, 1.604331, 1.611713,
1.619094, 1.626476, 1.633858, 1.626476, 1.619094, 1.611713, 1.604331,
1.611713, 1.619094, 1.626476, 1.633858, 1.633858, 1.633858, 1.633858,
1.633858, 1.631398, 1.628937, 1.626476, 1.624016, 1.624016, 1.624016,
1.624016, 1.624016, 1.626476, 1.628937, 1.631398, 1.633858, 1.633858,
1.633858, 1.633858, 1.633858, 1.633858, 1.633858, 1.633858, 1.633858,
1.624016, 1.614173, 1.604331, 1.594488, 1.601870, 1.609252, 1.616634,
1.624016, 1.624016, 1.624016, 1.624016, 1.624016, 1.643701, 1.663386,
1.683071, 1.702756, 1.717520, 1.732283, 1.747047, 1.761811, 1.788878,
1.815945, 1.843012, 1.870079, 1.882382, 1.894685, 1.906988, 1.919291,
1.936516, 1.953740, 1.970965, 1.988189, 2.010335, 2.032480, 2.054626,
2.076772, 2.093996, 2.111221, 2.128445, 2.145669, 2.165354, 2.185039,
2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835,
2.342520, 2.362205, 2.381890, 2.408957, 2.436024, 2.463091, 2.490158,
2.509843, 2.529528, 2.549213, 2.568898, 2.588583, 2.608268, 2.627953,
2.647638, 2.659941, 2.672244, 2.684547, 2.696851, 2.716536, 2.736221,
2.755906, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331, 2.874016,
2.893701, 2.913386, 2.933071, 2.960138, 2.987205, 3.014272, 3.041339,
1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.643701, 1.633858,
1.624016, 1.614173, 1.624016, 1.633858, 1.643701, 1.653543, 1.643701,
1.633858, 1.624016, 1.614173, 1.624016, 1.633858, 1.643701, 1.653543,
1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.653543,
1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.653543,
1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.653543, 1.653543,
1.653543, 1.653543, 1.653543, 1.643701, 1.633858, 1.624016, 1.614173,
1.624016, 1.633858, 1.643701, 1.653543, 1.653543, 1.653543, 1.653543,
1.653543, 1.673228, 1.692913, 1.712598, 1.732283, 1.742126, 1.751969,
1.761811, 1.771654, 1.801181, 1.830709, 1.860236, 1.889764, 1.899606,
1.909449, 1.919291, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874,
2.027559, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465,
2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.431102,
2.460630, 2.490157, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425,
2.618110, 2.637795, 2.657480, 2.677166, 2.687008, 2.696851, 2.706693,
2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.814961, 2.834646,
2.854331, 2.874016, 2.893701, 2.913386, 2.933071, 2.952756, 2.982283,
3.011811, 3.041338, 3.070866, 1.663386, 1.665846, 1.668307, 1.670768,
1.673228, 1.665846, 1.658465, 1.651083, 1.643701, 1.651083, 1.658465,
1.665846, 1.673228, 1.663386, 1.653543, 1.643701, 1.633858, 1.643701,
1.653543, 1.663386, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228,
1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228,
1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228,
1.673228, 1.673228, 1.670768, 1.668307, 1.665846, 1.663386, 1.658465,
1.653543, 1.648622, 1.643701, 1.648622, 1.653543, 1.658465, 1.663386,
1.663386, 1.663386, 1.663386, 1.663386, 1.680610, 1.697835, 1.715059,
1.732283, 1.744587, 1.756890, 1.769193, 1.781496, 1.806102, 1.830709,
1.855315, 1.879921, 1.892224, 1.904528, 1.916831, 1.929134, 1.948819,
1.968504, 1.988189, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614,
2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.266240, 2.288386, 2.310532, 2.332677, 2.349902, 2.367126,
2.384350, 2.401575, 2.428642, 2.455709, 2.482776, 2.509843, 2.529528,
2.549213, 2.568898, 2.588583, 2.610729, 2.632874, 2.655020, 2.677166,
2.689469, 2.701772, 2.714075, 2.726378, 2.746063, 2.765748, 2.785433,
2.805118, 2.824803, 2.844488, 2.864173, 2.883858, 2.903543, 2.923229,
2.942914, 2.962599, 2.987205, 3.011811, 3.036417, 3.061024, 1.673228,
1.678150, 1.683071, 1.687992, 1.692913, 1.687992, 1.683071, 1.678150,
1.673228, 1.678150, 1.683071, 1.687992, 1.692913, 1.683071, 1.673228,
1.663386, 1.653543, 1.663386, 1.673228, 1.683071, 1.692913, 1.692913,
1.692913, 1.692913, 1.692913, 1.692913, 1.692913, 1.692913, 1.692913,
1.692913, 1.692913, 1.692913, 1.692913, 1.692913, 1.692913, 1.692913,
1.692913, 1.692913, 1.692913, 1.692913, 1.692913, 1.687992, 1.683071,
1.678150, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228,
1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228, 1.673228,
1.687992, 1.702756, 1.717520, 1.732283, 1.747047, 1.761811, 1.776575,
1.791339, 1.811024, 1.830709, 1.850394, 1.870079, 1.884843, 1.899606,
1.914370, 1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559,
2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.268701, 2.293307, 2.317913,
2.342520, 2.357284, 2.372047, 2.386811, 2.401575, 2.426181, 2.450787,
2.475394, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.603347,
2.627953, 2.652559, 2.677166, 2.691929, 2.706693, 2.721457, 2.736221,
2.755906, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331, 2.874016,
2.893701, 2.913386, 2.933071, 2.952756, 2.972441, 2.992126, 3.011811,
3.031496, 3.051181, 1.683071, 1.690453, 1.697835, 1.705217, 1.712598,
1.710138, 1.707677, 1.705217, 1.702756, 1.705217, 1.707677, 1.710138,
1.712598, 1.702756, 1.692913, 1.683071, 1.673228, 1.683071, 1.692913,
1.702756, 1.712598, 1.712598, 1.712598, 1.712598, 1.712598, 1.712598,
1.712598, 1.712598, 1.712598, 1.712598, 1.712598, 1.712598, 1.712598,
1.712598, 1.712598, 1.712598, 1.712598, 1.712598, 1.712598, 1.712598,
1.712598, 1.705217, 1.697835, 1.690453, 1.683071, 1.687992, 1.692913,
1.697835, 1.702756, 1.697835, 1.692913, 1.687992, 1.683071, 1.683071,
1.683071, 1.683071, 1.683071, 1.695374, 1.707677, 1.719980, 1.732283,
1.749508, 1.766732, 1.783957, 1.801181, 1.815945, 1.830709, 1.845472,
1.860236, 1.877461, 1.894685, 1.911909, 1.929134, 1.948819, 1.968504,
1.988189, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.106299,
2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095,
2.271161, 2.298228, 2.325295, 2.352362, 2.364665, 2.376969, 2.389272,
2.401575, 2.423720, 2.445866, 2.468012, 2.490158, 2.509843, 2.529528,
2.549213, 2.568898, 2.595965, 2.623032, 2.650099, 2.677166, 2.694390,
2.711614, 2.728839, 2.746063, 2.765748, 2.785433, 2.805118, 2.824803,
2.844488, 2.864173, 2.883858, 2.903543, 2.923229, 2.942914, 2.962599,
2.982284, 2.997047, 3.011811, 3.026575, 3.041339, 1.692913, 1.702756,
1.712598, 1.722441, 1.732283, 1.732283, 1.732283, 1.732283, 1.732283,
1.732283, 1.732283, 1.732283, 1.732283, 1.722441, 1.712598, 1.702756,
1.692913, 1.702756, 1.712598, 1.722441, 1.732283, 1.732283, 1.732283,
1.732283, 1.732283, 1.732283, 1.732283, 1.732283, 1.732283, 1.732283,
1.732283, 1.732283, 1.732283, 1.732283, 1.732283, 1.732283, 1.732283,
1.732283, 1.732283, 1.732283, 1.732283, 1.722441, 1.712598, 1.702756,
1.692913, 1.702756, 1.712598, 1.722441, 1.732283, 1.722441, 1.712598,
1.702756, 1.692913, 1.692913, 1.692913, 1.692913, 1.692913, 1.702756,
1.712598, 1.722441, 1.732283, 1.751969, 1.771654, 1.791339, 1.811024,
1.820866, 1.830709, 1.840551, 1.850394, 1.870079, 1.889764, 1.909449,
1.929134, 1.948819, 1.968504, 1.988189, 2.007874, 2.027559, 2.047244,
2.066929, 2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.185039,
2.204724, 2.224410, 2.244095, 2.273622, 2.303150, 2.332677, 2.362205,
2.372047, 2.381890, 2.391732, 2.401575, 2.421260, 2.440945, 2.460630,
2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.588583, 2.618110,
2.647638, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386,
2.933071, 2.952756, 2.972441, 2.992126, 3.001968, 3.011811, 3.021653,
3.031496, 1.712598, 1.719980, 1.727362, 1.734744, 1.742126, 1.742126,
1.742126, 1.742126, 1.742126, 1.742126, 1.742126, 1.742126, 1.742126,
1.737205, 1.732283, 1.727362, 1.722441, 1.729823, 1.737205, 1.744587,
1.751969, 1.749508, 1.747047, 1.744587, 1.742126, 1.744587, 1.747047,
1.749508, 1.751969, 1.749508, 1.747047, 1.744587, 1.742126, 1.742126,
1.742126, 1.742126, 1.742126, 1.744587, 1.747047, 1.749508, 1.751969,
1.744587, 1.737205, 1.729823, 1.722441, 1.729823, 1.737205, 1.744587,
1.751969, 1.744587, 1.737205, 1.729823, 1.722441, 1.719980, 1.717520,
1.715059, 1.712598, 1.722441, 1.732283, 1.742126, 1.751969, 1.766732,
1.781496, 1.796260, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394,
1.872539, 1.894685, 1.916831, 1.938976, 1.956201, 1.973425, 1.990650,
2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984,
2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.271161,
2.298228, 2.325295, 2.352362, 2.364665, 2.376969, 2.389272, 2.401575,
2.423720, 2.445866, 2.468012, 2.490158, 2.507382, 2.524606, 2.541831,
2.559055, 2.586122, 2.613189, 2.640256, 2.667323, 2.687008, 2.706693,
2.726378, 2.746063, 2.765748, 2.785433, 2.805118, 2.824803, 2.844488,
2.864173, 2.883858, 2.903543, 2.923229, 2.942914, 2.962599, 2.982284,
2.994587, 3.006890, 3.019193, 3.031496, 1.732283, 1.737205, 1.742126,
1.747047, 1.751969, 1.751969, 1.751969, 1.751969, 1.751969, 1.751969,
1.751969, 1.751969, 1.751969, 1.751969, 1.751969, 1.751969, 1.751969,
1.756890, 1.761811, 1.766732, 1.771654, 1.766732, 1.761811, 1.756890,
1.751969, 1.756890, 1.761811, 1.766732, 1.771654, 1.766732, 1.761811,
1.756890, 1.751969, 1.751969, 1.751969, 1.751969, 1.751969, 1.756890,
1.761811, 1.766732, 1.771654, 1.766732, 1.761811, 1.756890, 1.751969,
1.756890, 1.761811, 1.766732, 1.771654, 1.766732, 1.761811, 1.756890,
1.751969, 1.747047, 1.742126, 1.737205, 1.732283, 1.742126, 1.751969,
1.761811, 1.771654, 1.781496, 1.791339, 1.801181, 1.811024, 1.820866,
1.830709, 1.840551, 1.850394, 1.875000, 1.899606, 1.924213, 1.948819,
1.963583, 1.978346, 1.993110, 2.007874, 2.027559, 2.047244, 2.066929,
2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724,
2.224410, 2.244095, 2.268701, 2.293307, 2.317913, 2.342520, 2.357284,
2.372047, 2.386811, 2.401575, 2.426181, 2.450787, 2.475394, 2.500000,
2.514764, 2.529528, 2.544291, 2.559055, 2.583662, 2.608268, 2.632874,
2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386,
2.933071, 2.952756, 2.972441, 2.987205, 3.001969, 3.016732, 3.031496,
1.751969, 1.754429, 1.756890, 1.759350, 1.761811, 1.761811, 1.761811,
1.761811, 1.761811, 1.761811, 1.761811, 1.761811, 1.761811, 1.766732,
1.771654, 1.776575, 1.781496, 1.783957, 1.786417, 1.788878, 1.791339,
1.783957, 1.776575, 1.769193, 1.761811, 1.769193, 1.776575, 1.783957,
1.791339, 1.783957, 1.776575, 1.769193, 1.761811, 1.761811, 1.761811,
1.761811, 1.761811, 1.769193, 1.776575, 1.783957, 1.791339, 1.788878,
1.786417, 1.783957, 1.781496, 1.783957, 1.786417, 1.788878, 1.791339,
1.788878, 1.786417, 1.783957, 1.781496, 1.774114, 1.766732, 1.759350,
1.751969, 1.761811, 1.771654, 1.781496, 1.791339, 1.796260, 1.801181,
1.806102, 1.811024, 1.820866, 1.830709, 1.840551, 1.850394, 1.877461,
1.904528, 1.931594, 1.958661, 1.970965, 1.983268, 1.995571, 2.007874,
2.027559, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.266240, 2.288386,
2.310532, 2.332677, 2.349902, 2.367126, 2.384350, 2.401575, 2.428642,
2.455709, 2.482776, 2.509843, 2.522146, 2.534449, 2.546752, 2.559055,
2.581201, 2.603347, 2.625492, 2.647638, 2.667323, 2.687008, 2.706693,
2.726378, 2.746063, 2.765748, 2.785433, 2.805118, 2.824803, 2.844488,
2.864173, 2.883858, 2.903543, 2.923229, 2.942914, 2.962599, 2.979823,
2.997047, 3.014272, 3.031496, 1.771654, 1.771654, 1.771654, 1.771654,
1.771654, 1.771654, 1.771654, 1.771654, 1.771654, 1.771654, 1.771654,
1.771654, 1.771654, 1.781496, 1.791339, 1.801181, 1.811024, 1.811024,
1.811024, 1.811024, 1.811024, 1.801181, 1.791339, 1.781496, 1.771654,
1.781496, 1.791339, 1.801181, 1.811024, 1.801181, 1.791339, 1.781496,
1.771654, 1.771654, 1.771654, 1.771654, 1.771654, 1.781496, 1.791339,
1.801181, 1.811024, 1.811024, 1.811024, 1.811024, 1.811024, 1.811024,
1.811024, 1.811024, 1.811024, 1.811024, 1.811024, 1.811024, 1.811024,
1.801181, 1.791339, 1.781496, 1.771654, 1.781496, 1.791339, 1.801181,
1.811024, 1.811024, 1.811024, 1.811024, 1.811024, 1.820866, 1.830709,
1.840551, 1.850394, 1.879921, 1.909449, 1.938976, 1.968504, 1.978346,
1.988189, 1.998031, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614,
2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205,
2.381890, 2.401575, 2.431102, 2.460630, 2.490157, 2.519685, 2.529528,
2.539370, 2.549213, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795,
2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386,
2.933071, 2.952756, 2.972441, 2.992126, 3.011811, 3.031496, 1.801181,
1.798720, 1.796260, 1.793799, 1.791339, 1.793799, 1.796260, 1.798720,
1.801181, 1.798720, 1.796260, 1.793799, 1.791339, 1.798720, 1.806102,
1.813484, 1.820866, 1.820866, 1.820866, 1.820866, 1.820866, 1.815945,
1.811024, 1.806102, 1.801181, 1.808563, 1.815945, 1.823327, 1.830709,
1.823327, 1.815945, 1.808563, 1.801181, 1.798720, 1.796260, 1.793799,
1.791339, 1.801181, 1.811024, 1.820866, 1.830709, 1.830709, 1.830709,
1.830709, 1.830709, 1.830709, 1.830709, 1.830709, 1.830709, 1.830709,
1.830709, 1.830709, 1.830709, 1.823327, 1.815945, 1.808563, 1.801181,
1.806102, 1.811024, 1.815945, 1.820866, 1.820866, 1.820866, 1.820866,
1.820866, 1.835630, 1.850394, 1.865157, 1.879921, 1.904528, 1.929134,
1.953740, 1.978346, 1.990650, 2.002953, 2.015256, 2.027559, 2.047244,
2.066929, 2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.185039,
2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835,
2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.450787, 2.480315,
2.509843, 2.539370, 2.549213, 2.559055, 2.568898, 2.578740, 2.600886,
2.623032, 2.645177, 2.667323, 2.684547, 2.701772, 2.718996, 2.736221,
2.758366, 2.780512, 2.802658, 2.824803, 2.844488, 2.864173, 2.883858,
2.903543, 2.920768, 2.937992, 2.955217, 2.972441, 2.992126, 3.011811,
3.031496, 3.051181, 1.830709, 1.825787, 1.820866, 1.815945, 1.811024,
1.815945, 1.820866, 1.825787, 1.830709, 1.825787, 1.820866, 1.815945,
1.811024, 1.815945, 1.820866, 1.825787, 1.830709, 1.830709, 1.830709,
1.830709, 1.830709, 1.830709, 1.830709, 1.830709, 1.830709, 1.835630,
1.840551, 1.845472, 1.850394, 1.845472, 1.840551, 1.835630, 1.830709,
1.825787, 1.820866, 1.815945, 1.811024, 1.820866, 1.830709, 1.840551,
1.850394, 1.850394, 1.850394, 1.850394, 1.850394, 1.850394, 1.850394,
1.850394, 1.850394, 1.850394, 1.850394, 1.850394, 1.850394, 1.845472,
1.840551, 1.835630, 1.830709, 1.830709, 1.830709, 1.830709, 1.830709,
1.830709, 1.830709, 1.830709, 1.830709, 1.850394, 1.870079, 1.889764,
1.909449, 1.929134, 1.948819, 1.968504, 1.988189, 2.002953, 2.017717,
2.032480, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465,
2.303150, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.421260,
2.440945, 2.470472, 2.500000, 2.529528, 2.559055, 2.568898, 2.578740,
2.588583, 2.598425, 2.623032, 2.647638, 2.672244, 2.696851, 2.711614,
2.726378, 2.741142, 2.755906, 2.780512, 2.805118, 2.829725, 2.854331,
2.874016, 2.893701, 2.913386, 2.933071, 2.947835, 2.962599, 2.977362,
2.992126, 3.011811, 3.031496, 3.051181, 3.070866, 1.860236, 1.852854,
1.845472, 1.838091, 1.830709, 1.838091, 1.845472, 1.852854, 1.860236,
1.852854, 1.845472, 1.838091, 1.830709, 1.833169, 1.835630, 1.838091,
1.840551, 1.840551, 1.840551, 1.840551, 1.840551, 1.845472, 1.850394,
1.855315, 1.860236, 1.862697, 1.865157, 1.867618, 1.870079, 1.867618,
1.865157, 1.862697, 1.860236, 1.852854, 1.845472, 1.838091, 1.830709,
1.840551, 1.850394, 1.860236, 1.870079, 1.870079, 1.870079, 1.870079,
1.870079, 1.870079, 1.870079, 1.870079, 1.870079, 1.870079, 1.870079,
1.870079, 1.870079, 1.867618, 1.865157, 1.862697, 1.860236, 1.855315,
1.850394, 1.845472, 1.840551, 1.840551, 1.840551, 1.840551, 1.840551,
1.865157, 1.889764, 1.914370, 1.938976, 1.953740, 1.968504, 1.983268,
1.998031, 2.015256, 2.032480, 2.049705, 2.066929, 2.086614, 2.106299,
2.125984, 2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095,
2.263780, 2.283465, 2.303150, 2.322835, 2.342520, 2.362205, 2.381890,
2.401575, 2.421260, 2.440945, 2.460630, 2.490157, 2.519685, 2.549213,
2.578740, 2.588583, 2.598425, 2.608268, 2.618110, 2.645177, 2.672244,
2.699311, 2.726378, 2.738681, 2.750984, 2.763287, 2.775591, 2.802658,
2.829725, 2.856791, 2.883858, 2.903543, 2.923229, 2.942914, 2.962599,
2.974902, 2.987205, 2.999508, 3.011811, 3.031496, 3.051181, 3.070866,
3.090551, 1.889764, 1.879921, 1.870079, 1.860236, 1.850394, 1.860236,
1.870079, 1.879921, 1.889764, 1.879921, 1.870079, 1.860236, 1.850394,
1.850394, 1.850394, 1.850394, 1.850394, 1.850394, 1.850394, 1.850394,
1.850394, 1.860236, 1.870079, 1.879921, 1.889764, 1.889764, 1.889764,
1.889764, 1.889764, 1.889764, 1.889764, 1.889764, 1.889764, 1.879921,
1.870079, 1.860236, 1.850394, 1.860236, 1.870079, 1.879921, 1.889764,
1.889764, 1.889764, 1.889764, 1.889764, 1.889764, 1.889764, 1.889764,
1.889764, 1.889764, 1.889764, 1.889764, 1.889764, 1.889764, 1.889764,
1.889764, 1.889764, 1.879921, 1.870079, 1.860236, 1.850394, 1.850394,
1.850394, 1.850394, 1.850394, 1.879921, 1.909449, 1.938976, 1.968504,
1.978346, 1.988189, 1.998031, 2.007874, 2.027559, 2.047244, 2.066929,
2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724,
2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.342520,
2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.509843, 2.539370, 2.568898, 2.598425, 2.608268, 2.618110, 2.627953,
2.637795, 2.667323, 2.696851, 2.726378, 2.755906, 2.765748, 2.775591,
2.785433, 2.795276, 2.824803, 2.854331, 2.883858, 2.913386, 2.933071,
2.952756, 2.972441, 2.992126, 3.001968, 3.011811, 3.021653, 3.031496,
3.051181, 3.070866, 3.090551, 3.110236, 1.909449, 1.899606, 1.889764,
1.879921, 1.870079, 1.879921, 1.889764, 1.899606, 1.909449, 1.899606,
1.889764, 1.879921, 1.870079, 1.872539, 1.875000, 1.877461, 1.879921,
1.877461, 1.875000, 1.872539, 1.870079, 1.877461, 1.884843, 1.892224,
1.899606, 1.902067, 1.904528, 1.906988, 1.909449, 1.909449, 1.909449,
1.909449, 1.909449, 1.902067, 1.894685, 1.887303, 1.879921, 1.884843,
1.889764, 1.894685, 1.899606, 1.902067, 1.904528, 1.906988, 1.909449,
1.906988, 1.904528, 1.902067, 1.899606, 1.899606, 1.899606, 1.899606,
1.899606, 1.899606, 1.899606, 1.899606, 1.899606, 1.894685, 1.889764,
1.884843, 1.879921, 1.879921, 1.879921, 1.879921, 1.879921, 1.902067,
1.924213, 1.946358, 1.968504, 1.978346, 1.988189, 1.998031, 2.007874,
2.027559, 2.047244, 2.066929, 2.086614, 2.108760, 2.130906, 2.153051,
2.175197, 2.192421, 2.209646, 2.226870, 2.244095, 2.263780, 2.283465,
2.303150, 2.322835, 2.344980, 2.367126, 2.389272, 2.411417, 2.428642,
2.445866, 2.463091, 2.480315, 2.507382, 2.534449, 2.561516, 2.588583,
2.600886, 2.613189, 2.625492, 2.637795, 2.664862, 2.691929, 2.718996,
2.746063, 2.758366, 2.770669, 2.782973, 2.795276, 2.822343, 2.849410,
2.876476, 2.903543, 2.923229, 2.942914, 2.962599, 2.982284, 2.994587,
3.006890, 3.019193, 3.031496, 3.051181, 3.070866, 3.090551, 3.110236,
1.929134, 1.919291, 1.909449, 1.899606, 1.889764, 1.899606, 1.909449,
1.919291, 1.929134, 1.919291, 1.909449, 1.899606, 1.889764, 1.894685,
1.899606, 1.904528, 1.909449, 1.904528, 1.899606, 1.894685, 1.889764,
1.894685, 1.899606, 1.904528, 1.909449, 1.914370, 1.919291, 1.924213,
1.929134, 1.929134, 1.929134, 1.929134, 1.929134, 1.924213, 1.919291,
1.914370, 1.909449, 1.909449, 1.909449, 1.909449, 1.909449, 1.914370,
1.919291, 1.924213, 1.929134, 1.924213, 1.919291, 1.914370, 1.909449,
1.909449, 1.909449, 1.909449, 1.909449, 1.909449, 1.909449, 1.909449,
1.909449, 1.909449, 1.909449, 1.909449, 1.909449, 1.909449, 1.909449,
1.909449, 1.909449, 1.924213, 1.938976, 1.953740, 1.968504, 1.978346,
1.988189, 1.998031, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614,
2.111221, 2.135827, 2.160433, 2.185039, 2.199803, 2.214567, 2.229331,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.347441, 2.372047,
2.396654, 2.421260, 2.436024, 2.450787, 2.465551, 2.480315, 2.504921,
2.529528, 2.554134, 2.578740, 2.593504, 2.608268, 2.623032, 2.637795,
2.662402, 2.687008, 2.711614, 2.736221, 2.750984, 2.765748, 2.780512,
2.795276, 2.819882, 2.844488, 2.869095, 2.893701, 2.913386, 2.933071,
2.952756, 2.972441, 2.987205, 3.001969, 3.016732, 3.031496, 3.051181,
3.070866, 3.090551, 3.110236, 1.948819, 1.938976, 1.929134, 1.919291,
1.909449, 1.919291, 1.929134, 1.938976, 1.948819, 1.938976, 1.929134,
1.919291, 1.909449, 1.916831, 1.924213, 1.931594, 1.938976, 1.931594,
1.924213, 1.916831, 1.909449, 1.911909, 1.914370, 1.916831, 1.919291,
1.926673, 1.934055, 1.941437, 1.948819, 1.948819, 1.948819, 1.948819,
1.948819, 1.946358, 1.943898, 1.941437, 1.938976, 1.934055, 1.929134,
1.924213, 1.919291, 1.926673, 1.934055, 1.941437, 1.948819, 1.941437,
1.934055, 1.926673, 1.919291, 1.919291, 1.919291, 1.919291, 1.919291,
1.919291, 1.919291, 1.919291, 1.919291, 1.924213, 1.929134, 1.934055,
1.938976, 1.938976, 1.938976, 1.938976, 1.938976, 1.946358, 1.953740,
1.961122, 1.968504, 1.978346, 1.988189, 1.998031, 2.007874, 2.027559,
2.047244, 2.066929, 2.086614, 2.113681, 2.140748, 2.167815, 2.194882,
2.207185, 2.219488, 2.231791, 2.244095, 2.263780, 2.283465, 2.303150,
2.322835, 2.349902, 2.376969, 2.404035, 2.431102, 2.443406, 2.455709,
2.468012, 2.480315, 2.502461, 2.524606, 2.546752, 2.568898, 2.586122,
2.603347, 2.620571, 2.637795, 2.659941, 2.682087, 2.704232, 2.726378,
2.743603, 2.760827, 2.778051, 2.795276, 2.817421, 2.839567, 2.861713,
2.883858, 2.903543, 2.923229, 2.942914, 2.962599, 2.979823, 2.997047,
3.014272, 3.031496, 3.051181, 3.070866, 3.090551, 3.110236, 1.968504,
1.958661, 1.948819, 1.938976, 1.929134, 1.938976, 1.948819, 1.958661,
1.968504, 1.958661, 1.948819, 1.938976, 1.929134, 1.938976, 1.948819,
1.958661, 1.968504, 1.958661, 1.948819, 1.938976, 1.929134, 1.929134,
1.929134, 1.929134, 1.929134, 1.938976, 1.948819, 1.958661, 1.968504,
1.968504, 1.968504, 1.968504, 1.968504, 1.968504, 1.968504, 1.968504,
1.968504, 1.958661, 1.948819, 1.938976, 1.929134, 1.938976, 1.948819,
1.958661, 1.968504, 1.958661, 1.948819, 1.938976, 1.929134, 1.929134,
1.929134, 1.929134, 1.929134, 1.929134, 1.929134, 1.929134, 1.929134,
1.938976, 1.948819, 1.958661, 1.968504, 1.968504, 1.968504, 1.968504,
1.968504, 1.968504, 1.968504, 1.968504, 1.968504, 1.978346, 1.988189,
1.998031, 2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.116142,
2.145669, 2.175197, 2.204724, 2.214567, 2.224410, 2.234252, 2.244095,
2.263780, 2.283465, 2.303150, 2.322835, 2.352362, 2.381890, 2.411417,
2.440945, 2.450787, 2.460630, 2.470472, 2.480315, 2.500000, 2.519685,
2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.657480,
2.677166, 2.696851, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276,
2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386, 2.933071,
2.952756, 2.972441, 2.992126, 3.011811, 3.031496, 3.051181, 3.070866,
3.090551, 3.110236, 1.978346, 1.970965, 1.963583, 1.956201, 1.948819,
1.956201, 1.963583, 1.970965, 1.978346, 1.973425, 1.968504, 1.963583,
1.958661, 1.963583, 1.968504, 1.973425, 1.978346, 1.970965, 1.963583,
1.956201, 1.948819, 1.948819, 1.948819, 1.948819, 1.948819, 1.956201,
1.963583, 1.970965, 1.978346, 1.978346, 1.978346, 1.978346, 1.978346,
1.978346, 1.978346, 1.978346, 1.978346, 1.970965, 1.963583, 1.956201,
1.948819, 1.958661, 1.968504, 1.978346, 1.988189, 1.978346, 1.968504,
1.958661, 1.948819, 1.948819, 1.948819, 1.948819, 1.948819, 1.948819,
1.948819, 1.948819, 1.948819, 1.958661, 1.968504, 1.978346, 1.988189,
1.985728, 1.983268, 1.980807, 1.978346, 1.978346, 1.978346, 1.978346,
1.978346, 1.985728, 1.993110, 2.000492, 2.007874, 2.027559, 2.047244,
2.066929, 2.086614, 2.113681, 2.140748, 2.167815, 2.194882, 2.209646,
2.224410, 2.239173, 2.253937, 2.271161, 2.288386, 2.305610, 2.322835,
2.349902, 2.376969, 2.404035, 2.431102, 2.445866, 2.460630, 2.475394,
2.490158, 2.509843, 2.529528, 2.549213, 2.568898, 2.586122, 2.603347,
2.620571, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221,
2.755906, 2.775591, 2.795276, 2.817421, 2.839567, 2.861713, 2.883858,
2.901083, 2.918307, 2.935532, 2.952756, 2.972441, 2.992126, 3.011811,
3.031496, 3.051181, 3.070866, 3.090551, 3.110236, 1.988189, 1.983268,
1.978346, 1.973425, 1.968504, 1.973425, 1.978346, 1.983268, 1.988189,
1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.988189,
1.988189, 1.983268, 1.978346, 1.973425, 1.968504, 1.968504, 1.968504,
1.968504, 1.968504, 1.973425, 1.978346, 1.983268, 1.988189, 1.988189,
1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.988189,
1.983268, 1.978346, 1.973425, 1.968504, 1.978346, 1.988189, 1.998031,
2.007874, 1.998031, 1.988189, 1.978346, 1.968504, 1.968504, 1.968504,
1.968504, 1.968504, 1.968504, 1.968504, 1.968504, 1.968504, 1.978346,
1.988189, 1.998031, 2.007874, 2.002953, 1.998031, 1.993110, 1.988189,
1.988189, 1.988189, 1.988189, 1.988189, 1.993110, 1.998031, 2.002953,
2.007874, 2.027559, 2.047244, 2.066929, 2.086614, 2.111221, 2.135827,
2.160433, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.278543,
2.293307, 2.308071, 2.322835, 2.347441, 2.372047, 2.396654, 2.421260,
2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
2.578740, 2.593504, 2.608268, 2.623032, 2.637795, 2.657480, 2.677166,
2.696851, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.819882,
2.844488, 2.869095, 2.893701, 2.908465, 2.923229, 2.937992, 2.952756,
2.972441, 2.992126, 3.011811, 3.031496, 3.051181, 3.070866, 3.090551,
3.110236, 1.998031, 1.995571, 1.993110, 1.990650, 1.988189, 1.990650,
1.993110, 1.995571, 1.998031, 2.002953, 2.007874, 2.012795, 2.017717,
2.012795, 2.007874, 2.002953, 1.998031, 1.995571, 1.993110, 1.990650,
1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.990650, 1.993110,
1.995571, 1.998031, 1.998031, 1.998031, 1.998031, 1.998031, 1.998031,
1.998031, 1.998031, 1.998031, 1.995571, 1.993110, 1.990650, 1.988189,
1.998031, 2.007874, 2.017717, 2.027559, 2.017717, 2.007874, 1.998031,
1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.988189, 1.988189,
1.988189, 1.988189, 1.998031, 2.007874, 2.017717, 2.027559, 2.020177,
2.012795, 2.005414, 1.998031, 1.998031, 1.998031, 1.998031, 1.998031,
2.000492, 2.002953, 2.005414, 2.007874, 2.027559, 2.047244, 2.066929,
2.086614, 2.108760, 2.130906, 2.153051, 2.175197, 2.199803, 2.224410,
2.249016, 2.273622, 2.285925, 2.298228, 2.310532, 2.322835, 2.344980,
2.367126, 2.389272, 2.411417, 2.436024, 2.460630, 2.485236, 2.509843,
2.529528, 2.549213, 2.568898, 2.588583, 2.600886, 2.613189, 2.625492,
2.637795, 2.657480, 2.677166, 2.696851, 2.716536, 2.736221, 2.755906,
2.775591, 2.795276, 2.822343, 2.849410, 2.876476, 2.903543, 2.915847,
2.928150, 2.940453, 2.952756, 2.972441, 2.992126, 3.011811, 3.031496,
3.051181, 3.070866, 3.090551, 3.110236, 2.007874, 2.007874, 2.007874,
2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.017717,
2.027559, 2.037402, 2.047244, 2.037402, 2.027559, 2.017717, 2.007874,
2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874,
2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874,
2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874,
2.007874, 2.007874, 2.007874, 2.017717, 2.027559, 2.037402, 2.047244,
2.037402, 2.027559, 2.017717, 2.007874, 2.007874, 2.007874, 2.007874,
2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.017717, 2.027559,
2.037402, 2.047244, 2.037402, 2.027559, 2.017717, 2.007874, 2.007874,
2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874, 2.007874,
2.027559, 2.047244, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669,
2.165354, 2.194882, 2.224410, 2.253937, 2.283465, 2.293307, 2.303150,
2.312992, 2.322835, 2.342520, 2.362205, 2.381890, 2.401575, 2.431102,
2.460630, 2.490157, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425,
2.608268, 2.618110, 2.627953, 2.637795, 2.657480, 2.677166, 2.696851,
2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.824803, 2.854331,
2.883858, 2.913386, 2.923228, 2.933071, 2.942913, 2.952756, 2.972441,
2.992126, 3.011811, 3.031496, 3.051181, 3.070866, 3.090551, 3.110236,
2.027559, 2.030020, 2.032480, 2.034941, 2.037402, 2.037402, 2.037402,
2.037402, 2.037402, 2.044784, 2.052165, 2.059547, 2.066929, 2.059547,
2.052165, 2.044784, 2.037402, 2.034941, 2.032480, 2.030020, 2.027559,
2.027559, 2.027559, 2.027559, 2.027559, 2.030020, 2.032480, 2.034941,
2.037402, 2.037402, 2.037402, 2.037402, 2.037402, 2.034941, 2.032480,
2.030020, 2.027559, 2.027559, 2.027559, 2.027559, 2.027559, 2.037402,
2.047244, 2.057087, 2.066929, 2.057087, 2.047244, 2.037402, 2.027559,
2.030020, 2.032480, 2.034941, 2.037402, 2.037402, 2.037402, 2.037402,
2.037402, 2.042323, 2.047244, 2.052165, 2.057087, 2.052165, 2.047244,
2.042323, 2.037402, 2.037402, 2.037402, 2.037402, 2.037402, 2.034941,
2.032480, 2.030020, 2.027559, 2.047244, 2.066929, 2.086614, 2.106299,
2.125984, 2.145669, 2.165354, 2.185039, 2.212106, 2.239173, 2.266240,
2.293307, 2.308071, 2.322835, 2.337598, 2.352362, 2.372047, 2.391732,
2.411417, 2.431103, 2.458169, 2.485236, 2.512303, 2.539370, 2.559055,
2.578740, 2.598425, 2.618110, 2.630414, 2.642717, 2.655020, 2.667323,
2.684547, 2.701772, 2.718996, 2.736221, 2.755906, 2.775591, 2.795276,
2.814961, 2.844488, 2.874016, 2.903543, 2.933071, 2.942913, 2.952756,
2.962598, 2.972441, 2.992126, 3.011811, 3.031496, 3.051181, 3.070866,
3.090551, 3.110236, 3.129921, 2.047244, 2.052165, 2.057087, 2.062008,
2.066929, 2.066929, 2.066929, 2.066929, 2.066929, 2.071851, 2.076772,
2.081693, 2.086614, 2.081693, 2.076772, 2.071851, 2.066929, 2.062008,
2.057087, 2.052165, 2.047244, 2.047244, 2.047244, 2.047244, 2.047244,
2.052165, 2.057087, 2.062008, 2.066929, 2.066929, 2.066929, 2.066929,
2.066929, 2.062008, 2.057087, 2.052165, 2.047244, 2.047244, 2.047244,
2.047244, 2.047244, 2.057087, 2.066929, 2.076772, 2.086614, 2.076772,
2.066929, 2.057087, 2.047244, 2.052165, 2.057087, 2.062008, 2.066929,
2.066929, 2.066929, 2.066929, 2.066929, 2.066929, 2.066929, 2.066929,
2.066929, 2.066929, 2.066929, 2.066929, 2.066929, 2.066929, 2.066929,
2.066929, 2.066929, 2.062008, 2.057087, 2.052165, 2.047244, 2.066929,
2.086614, 2.106299, 2.125984, 2.145669, 2.165354, 2.185039, 2.204724,
2.229331, 2.253937, 2.278543, 2.303150, 2.322835, 2.342520, 2.362205,
2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.485236, 2.509843,
2.534449, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.652559,
2.667323, 2.682087, 2.696851, 2.711614, 2.726378, 2.741142, 2.755906,
2.775591, 2.795276, 2.814961, 2.834646, 2.864173, 2.893701, 2.923228,
2.952756, 2.962598, 2.972441, 2.982283, 2.992126, 3.011811, 3.031496,
3.051181, 3.070866, 3.090551, 3.110236, 3.129921, 3.149606, 2.066929,
2.074311, 2.081693, 2.089075, 2.096457, 2.096457, 2.096457, 2.096457,
2.096457, 2.098917, 2.101378, 2.103839, 2.106299, 2.103839, 2.101378,
2.098917, 2.096457, 2.089075, 2.081693, 2.074311, 2.066929, 2.066929,
2.066929, 2.066929, 2.066929, 2.074311, 2.081693, 2.089075, 2.096457,
2.096457, 2.096457, 2.096457, 2.096457, 2.089075, 2.081693, 2.074311,
2.066929, 2.066929, 2.066929, 2.066929, 2.066929, 2.076772, 2.086614,
2.096457, 2.106299, 2.096457, 2.086614, 2.076772, 2.066929, 2.074311,
2.081693, 2.089075, 2.096457, 2.096457, 2.096457, 2.096457, 2.096457,
2.091536, 2.086614, 2.081693, 2.076772, 2.081693, 2.086614, 2.091536,
2.096457, 2.096457, 2.096457, 2.096457, 2.096457, 2.089075, 2.081693,
2.074311, 2.066929, 2.086614, 2.106299, 2.125984, 2.145669, 2.165354,
2.185039, 2.204724, 2.224410, 2.246555, 2.268701, 2.290847, 2.312992,
2.337598, 2.362205, 2.386811, 2.411417, 2.431102, 2.450787, 2.470472,
2.490158, 2.512303, 2.534449, 2.556595, 2.578740, 2.598425, 2.618110,
2.637795, 2.657480, 2.674705, 2.691929, 2.709154, 2.726378, 2.738681,
2.750984, 2.763287, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331,
2.883858, 2.913386, 2.942913, 2.972441, 2.982283, 2.992126, 3.001968,
3.011811, 3.031496, 3.051181, 3.070866, 3.090551, 3.110236, 3.129921,
3.149606, 3.169291, 2.086614, 2.096457, 2.106299, 2.116142, 2.125984,
2.125984, 2.125984, 2.125984, 2.125984, 2.125984, 2.125984, 2.125984,
2.125984, 2.125984, 2.125984, 2.125984, 2.125984, 2.116142, 2.106299,
2.096457, 2.086614, 2.086614, 2.086614, 2.086614, 2.086614, 2.096457,
2.106299, 2.116142, 2.125984, 2.125984, 2.125984, 2.125984, 2.125984,
2.116142, 2.106299, 2.096457, 2.086614, 2.086614, 2.086614, 2.086614,
2.086614, 2.096457, 2.106299, 2.116142, 2.125984, 2.116142, 2.106299,
2.096457, 2.086614, 2.096457, 2.106299, 2.116142, 2.125984, 2.125984,
2.125984, 2.125984, 2.125984, 2.116142, 2.106299, 2.096457, 2.086614,
2.096457, 2.106299, 2.116142, 2.125984, 2.125984, 2.125984, 2.125984,
2.125984, 2.116142, 2.106299, 2.096457, 2.086614, 2.106299, 2.125984,
2.145669, 2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780,
2.283465, 2.303150, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945,
2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.598425, 2.618110, 2.637795, 2.657480, 2.677166, 2.696851, 2.716536,
2.736221, 2.755906, 2.765748, 2.775591, 2.785433, 2.795276, 2.814961,
2.834646, 2.854331, 2.874016, 2.903543, 2.933071, 2.962598, 2.992126,
3.001968, 3.011811, 3.021653, 3.031496, 3.051181, 3.070866, 3.090551,
3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 2.116142, 2.121063,
2.125984, 2.130906, 2.135827, 2.135827, 2.135827, 2.135827, 2.135827,
2.138287, 2.140748, 2.143209, 2.145669, 2.145669, 2.145669, 2.145669,
2.145669, 2.135827, 2.125984, 2.116142, 2.106299, 2.108760, 2.111221,
2.113681, 2.116142, 2.123524, 2.130906, 2.138287, 2.145669, 2.145669,
2.145669, 2.145669, 2.145669, 2.135827, 2.125984, 2.116142, 2.106299,
2.106299, 2.106299, 2.106299, 2.106299, 2.116142, 2.125984, 2.135827,
2.145669, 2.138287, 2.130906, 2.123524, 2.116142, 2.123524, 2.130906,
2.138287, 2.145669, 2.143209, 2.140748, 2.138287, 2.135827, 2.128445,
2.121063, 2.113681, 2.106299, 2.116142, 2.125984, 2.135827, 2.145669,
2.143209, 2.140748, 2.138287, 2.135827, 2.130906, 2.125984, 2.121063,
2.116142, 2.128445, 2.140748, 2.153051, 2.165354, 2.185039, 2.204724,
2.224410, 2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.352362,
2.381890, 2.411417, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685,
2.536910, 2.554134, 2.571358, 2.588583, 2.610729, 2.632874, 2.655020,
2.677166, 2.694390, 2.711614, 2.728839, 2.746063, 2.758366, 2.770669,
2.782973, 2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.901083,
2.928150, 2.955217, 2.982284, 2.994587, 3.006890, 3.019193, 3.031496,
3.051181, 3.070866, 3.090551, 3.110236, 3.129921, 3.149606, 3.169291,
3.188977, 2.145669, 2.145669, 2.145669, 2.145669, 2.145669, 2.145669,
2.145669, 2.145669, 2.145669, 2.150591, 2.155512, 2.160433, 2.165354,
2.165354, 2.165354, 2.165354, 2.165354, 2.155512, 2.145669, 2.135827,
2.125984, 2.130906, 2.135827, 2.140748, 2.145669, 2.150591, 2.155512,
2.160433, 2.165354, 2.165354, 2.165354, 2.165354, 2.165354, 2.155512,
2.145669, 2.135827, 2.125984, 2.125984, 2.125984, 2.125984, 2.125984,
2.135827, 2.145669, 2.155512, 2.165354, 2.160433, 2.155512, 2.150591,
2.145669, 2.150591, 2.155512, 2.160433, 2.165354, 2.160433, 2.155512,
2.150591, 2.145669, 2.140748, 2.135827, 2.130906, 2.125984, 2.135827,
2.145669, 2.155512, 2.165354, 2.160433, 2.155512, 2.150591, 2.145669,
2.145669, 2.145669, 2.145669, 2.145669, 2.150591, 2.155512, 2.160433,
2.165354, 2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465,
2.303150, 2.322835, 2.352362, 2.381890, 2.411417, 2.440945, 2.460630,
2.480315, 2.500000, 2.519685, 2.534449, 2.549213, 2.563977, 2.578740,
2.603347, 2.627953, 2.652559, 2.677166, 2.691929, 2.706693, 2.721457,
2.736221, 2.750984, 2.765748, 2.780512, 2.795276, 2.814961, 2.834646,
2.854331, 2.874016, 2.898622, 2.923229, 2.947835, 2.972441, 2.987205,
3.001969, 3.016732, 3.031496, 3.051181, 3.070866, 3.090551, 3.110236,
3.129921, 3.149606, 3.169291, 3.188977, 2.175197, 2.170276, 2.165354,
2.160433, 2.155512, 2.155512, 2.155512, 2.155512, 2.155512, 2.162894,
2.170276, 2.177658, 2.185039, 2.185039, 2.185039, 2.185039, 2.185039,
2.175197, 2.165354, 2.155512, 2.145669, 2.153051, 2.160433, 2.167815,
2.175197, 2.177658, 2.180118, 2.182579, 2.185039, 2.185039, 2.185039,
2.185039, 2.185039, 2.175197, 2.165354, 2.155512, 2.145669, 2.145669,
2.145669, 2.145669, 2.145669, 2.155512, 2.165354, 2.175197, 2.185039,
2.182579, 2.180118, 2.177658, 2.175197, 2.177658, 2.180118, 2.182579,
2.185039, 2.177658, 2.170276, 2.162894, 2.155512, 2.153051, 2.150591,
2.148130, 2.145669, 2.155512, 2.165354, 2.175197, 2.185039, 2.177658,
2.170276, 2.162894, 2.155512, 2.160433, 2.165354, 2.170276, 2.175197,
2.172736, 2.170276, 2.167815, 2.165354, 2.185039, 2.204724, 2.224410,
2.244095, 2.263780, 2.283465, 2.303150, 2.322835, 2.352362, 2.381890,
2.411417, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.531988,
2.544291, 2.556595, 2.568898, 2.595965, 2.623032, 2.650099, 2.677166,
2.689469, 2.701772, 2.714075, 2.726378, 2.743603, 2.760827, 2.778051,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.896162, 2.918307,
2.940453, 2.962599, 2.979823, 2.997047, 3.014272, 3.031496, 3.051181,
3.070866, 3.090551, 3.110236, 3.129921, 3.149606, 3.169291, 3.188977,
2.204724, 2.194882, 2.185039, 2.175197, 2.165354, 2.165354, 2.165354,
2.165354, 2.165354, 2.175197, 2.185039, 2.194882, 2.204724, 2.204724,
2.204724, 2.204724, 2.204724, 2.194882, 2.185039, 2.175197, 2.165354,
2.175197, 2.185039, 2.194882, 2.204724, 2.204724, 2.204724, 2.204724,
2.204724, 2.204724, 2.204724, 2.204724, 2.204724, 2.194882, 2.185039,
2.175197, 2.165354, 2.165354, 2.165354, 2.165354, 2.165354, 2.175197,
2.185039, 2.194882, 2.204724, 2.204724, 2.204724, 2.204724, 2.204724,
2.204724, 2.204724, 2.204724, 2.204724, 2.194882, 2.185039, 2.175197,
2.165354, 2.165354, 2.165354, 2.165354, 2.165354, 2.175197, 2.185039,
2.194882, 2.204724, 2.194882, 2.185039, 2.175197, 2.165354, 2.175197,
2.185039, 2.194882, 2.204724, 2.194882, 2.185039, 2.175197, 2.165354,
2.185039, 2.204724, 2.224410, 2.244095, 2.263780, 2.283465, 2.303150,
2.322835, 2.352362, 2.381890, 2.411417, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.529528, 2.539370, 2.549213, 2.559055, 2.588583,
2.618110, 2.647638, 2.677166, 2.687008, 2.696851, 2.706693, 2.716536,
2.736221, 2.755906, 2.775591, 2.795276, 2.814961, 2.834646, 2.854331,
2.874016, 2.893701, 2.913386, 2.933071, 2.952756, 2.972441, 2.992126,
3.011811, 3.031496, 3.051181, 3.070866, 3.090551, 3.110236, 3.129921,
3.149606, 3.169291, 3.188977, 2.224410, 2.217028, 2.209646, 2.202264,
2.194882, 2.194882, 2.194882, 2.194882, 2.194882, 2.199803, 2.204724,
2.209646, 2.214567, 2.214567, 2.214567, 2.214567, 2.214567, 2.209646,
2.204724, 2.199803, 2.194882, 2.199803, 2.204724, 2.209646, 2.214567,
2.217028, 2.219488, 2.221949, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.214567, 2.204724, 2.194882, 2.185039, 2.185039, 2.185039,
2.185039, 2.185039, 2.194882, 2.204724, 2.214567, 2.224410, 2.224410,
2.224410, 2.224410, 2.224410, 2.221949, 2.219488, 2.217028, 2.214567,
2.209646, 2.204724, 2.199803, 2.194882, 2.194882, 2.194882, 2.194882,
2.194882, 2.199803, 2.204724, 2.209646, 2.214567, 2.207185, 2.199803,
2.192421, 2.185039, 2.194882, 2.204724, 2.214567, 2.224410, 2.214567,
2.204724, 2.194882, 2.185039, 2.202264, 2.219488, 2.236713, 2.253937,
2.271161, 2.288386, 2.305610, 2.322835, 2.349902, 2.376969, 2.404035,
2.431102, 2.450787, 2.470472, 2.490157, 2.509843, 2.522146, 2.534449,
2.546752, 2.559055, 2.588583, 2.618110, 2.647638, 2.677166, 2.687008,
2.696851, 2.706693, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276,
2.817421, 2.839567, 2.861713, 2.883858, 2.903543, 2.923229, 2.942914,
2.962599, 2.979823, 2.997047, 3.014272, 3.031496, 3.051181, 3.070866,
3.090551, 3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 2.244095,
2.239173, 2.234252, 2.229331, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.224410, 2.224410, 2.229331, 2.234252, 2.239173, 2.244095,
2.244095, 2.244095, 2.244095, 2.244095, 2.234252, 2.224410, 2.214567,
2.204724, 2.204724, 2.204724, 2.204724, 2.204724, 2.214567, 2.224410,
2.234252, 2.244095, 2.244095, 2.244095, 2.244095, 2.244095, 2.239173,
2.234252, 2.229331, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.219488, 2.214567, 2.209646, 2.204724, 2.214567, 2.224410,
2.234252, 2.244095, 2.234252, 2.224410, 2.214567, 2.204724, 2.219488,
2.234252, 2.249016, 2.263780, 2.278543, 2.293307, 2.308071, 2.322835,
2.347441, 2.372047, 2.396654, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.514764, 2.529528, 2.544291, 2.559055, 2.588583, 2.618110,
2.647638, 2.677166, 2.687008, 2.696851, 2.706693, 2.716536, 2.736221,
2.755906, 2.775591, 2.795276, 2.819882, 2.844488, 2.869095, 2.893701,
2.913386, 2.933071, 2.952756, 2.972441, 2.987205, 3.001969, 3.016732,
3.031496, 3.051181, 3.070866, 3.090551, 3.110236, 3.129921, 3.149606,
3.169291, 3.188977, 2.263780, 2.261319, 2.258858, 2.256398, 2.253937,
2.253937, 2.253937, 2.253937, 2.253937, 2.249016, 2.244095, 2.239173,
2.234252, 2.234252, 2.234252, 2.234252, 2.234252, 2.239173, 2.244095,
2.249016, 2.253937, 2.249016, 2.244095, 2.239173, 2.234252, 2.241634,
2.249016, 2.256398, 2.263780, 2.263780, 2.263780, 2.263780, 2.263780,
2.253937, 2.244095, 2.234252, 2.224410, 2.224410, 2.224410, 2.224410,
2.224410, 2.234252, 2.244095, 2.253937, 2.263780, 2.263780, 2.263780,
2.263780, 2.263780, 2.256398, 2.249016, 2.241634, 2.234252, 2.239173,
2.244095, 2.249016, 2.253937, 2.253937, 2.253937, 2.253937, 2.253937,
2.249016, 2.244095, 2.239173, 2.234252, 2.231791, 2.229331, 2.226870,
2.224410, 2.234252, 2.244095, 2.253937, 2.263780, 2.253937, 2.244095,
2.234252, 2.224410, 2.236713, 2.249016, 2.261319, 2.273622, 2.285925,
2.298228, 2.310532, 2.322835, 2.344980, 2.367126, 2.389272, 2.411417,
2.431102, 2.450787, 2.470472, 2.490158, 2.507382, 2.524606, 2.541831,
2.559055, 2.588583, 2.618110, 2.647638, 2.677166, 2.687008, 2.696851,
2.706693, 2.716536, 2.736221, 2.755906, 2.775591, 2.795276, 2.822343,
2.849410, 2.876476, 2.903543, 2.923229, 2.942914, 2.962599, 2.982284,
2.994587, 3.006890, 3.019193, 3.031496, 3.051181, 3.070866, 3.090551,
3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 2.283465, 2.283465,
2.283465, 2.283465, 2.283465, 2.283465, 2.283465, 2.283465, 2.283465,
2.273622, 2.263780, 2.253937, 2.244095, 2.244095, 2.244095, 2.244095,
2.244095, 2.253937, 2.263780, 2.273622, 2.283465, 2.273622, 2.263780,
2.253937, 2.244095, 2.253937, 2.263780, 2.273622, 2.283465, 2.283465,
2.283465, 2.283465, 2.283465, 2.273622, 2.263780, 2.253937, 2.244095,
2.244095, 2.244095, 2.244095, 2.244095, 2.253937, 2.263780, 2.273622,
2.283465, 2.283465, 2.283465, 2.283465, 2.283465, 2.273622, 2.263780,
2.253937, 2.244095, 2.253937, 2.263780, 2.273622, 2.283465, 2.283465,
2.283465, 2.283465, 2.283465, 2.273622, 2.263780, 2.253937, 2.244095,
2.244095, 2.244095, 2.244095, 2.244095, 2.253937, 2.263780, 2.273622,
2.283465, 2.273622, 2.263780, 2.253937, 2.244095, 2.253937, 2.263780,
2.273622, 2.283465, 2.293307, 2.303150, 2.312992, 2.322835, 2.342520,
2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.588583, 2.618110, 2.647638,
2.677166, 2.687008, 2.696851, 2.706693, 2.716536, 2.736221, 2.755906,
2.775591, 2.795276, 2.824803, 2.854331, 2.883858, 2.913386, 2.933071,
2.952756, 2.972441, 2.992126, 3.001968, 3.011811, 3.021653, 3.031496,
3.051181, 3.070866, 3.090551, 3.110236, 3.129921, 3.149606, 3.169291,
3.188977, 2.303150, 2.300689, 2.298228, 2.295768, 2.293307, 2.295768,
2.298228, 2.300689, 2.303150, 2.293307, 2.283465, 2.273622, 2.263780,
2.263780, 2.263780, 2.263780, 2.263780, 2.273622, 2.283465, 2.293307,
2.303150, 2.295768, 2.288386, 2.281004, 2.273622, 2.278543, 2.283465,
2.288386, 2.293307, 2.293307, 2.293307, 2.293307, 2.293307, 2.288386,
2.283465, 2.278543, 2.273622, 2.271161, 2.268701, 2.266240, 2.263780,
2.271161, 2.278543, 2.285925, 2.293307, 2.293307, 2.293307, 2.293307,
2.293307, 2.285925, 2.278543, 2.271161, 2.263780, 2.271161, 2.278543,
2.285925, 2.293307, 2.293307, 2.293307, 2.293307, 2.293307, 2.288386,
2.283465, 2.278543, 2.273622, 2.273622, 2.273622, 2.273622, 2.273622,
2.278543, 2.283465, 2.288386, 2.293307, 2.285925, 2.278543, 2.271161,
2.263780, 2.271161, 2.278543, 2.285925, 2.293307, 2.305610, 2.317913,
2.330217, 2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.440945,
2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740,
2.608268, 2.637795, 2.667323, 2.696851, 2.709154, 2.721457, 2.733760,
2.746063, 2.765748, 2.785433, 2.805118, 2.824803, 2.851870, 2.878937,
2.906004, 2.933071, 2.950295, 2.967520, 2.984744, 3.001969, 3.014272,
3.026575, 3.038878, 3.051181, 3.070866, 3.090551, 3.110236, 3.129921,
3.149606, 3.169291, 3.188977, 3.208662, 2.322835, 2.317913, 2.312992,
2.308071, 2.303150, 2.308071, 2.312992, 2.317913, 2.322835, 2.312992,
2.303150, 2.293307, 2.283465, 2.283465, 2.283465, 2.283465, 2.283465,
2.293307, 2.303150, 2.312992, 2.322835, 2.317913, 2.312992, 2.308071,
2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150,
2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.298228,
2.293307, 2.288386, 2.283465, 2.288386, 2.293307, 2.298228, 2.303150,
2.303150, 2.303150, 2.303150, 2.303150, 2.298228, 2.293307, 2.288386,
2.283465, 2.288386, 2.293307, 2.298228, 2.303150, 2.303150, 2.303150,
2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150,
2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150, 2.303150,
2.298228, 2.293307, 2.288386, 2.283465, 2.288386, 2.293307, 2.298228,
2.303150, 2.317913, 2.332677, 2.347441, 2.362205, 2.381890, 2.401575,
2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 2.578740, 2.598425, 2.627953, 2.657480, 2.687008, 2.716536,
2.731299, 2.746063, 2.760827, 2.775591, 2.795276, 2.814961, 2.834646,
2.854331, 2.878937, 2.903543, 2.928150, 2.952756, 2.967520, 2.982284,
2.997047, 3.011811, 3.026575, 3.041339, 3.056103, 3.070866, 3.090551,
3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 3.208662, 3.228347,
2.342520, 2.335138, 2.327756, 2.320374, 2.312992, 2.320374, 2.327756,
2.335138, 2.342520, 2.332677, 2.322835, 2.312992, 2.303150, 2.303150,
2.303150, 2.303150, 2.303150, 2.312992, 2.322835, 2.332677, 2.342520,
2.340059, 2.337598, 2.335138, 2.332677, 2.327756, 2.322835, 2.317913,
2.312992, 2.312992, 2.312992, 2.312992, 2.312992, 2.317913, 2.322835,
2.327756, 2.332677, 2.325295, 2.317913, 2.310532, 2.303150, 2.305610,
2.308071, 2.310532, 2.312992, 2.312992, 2.312992, 2.312992, 2.312992,
2.310532, 2.308071, 2.305610, 2.303150, 2.305610, 2.308071, 2.310532,
2.312992, 2.312992, 2.312992, 2.312992, 2.312992, 2.317913, 2.322835,
2.327756, 2.332677, 2.332677, 2.332677, 2.332677, 2.332677, 2.327756,
2.322835, 2.317913, 2.312992, 2.310532, 2.308071, 2.305610, 2.303150,
2.305610, 2.308071, 2.310532, 2.312992, 2.330217, 2.347441, 2.364665,
2.381890, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.647638,
2.677166, 2.706693, 2.736221, 2.753445, 2.770669, 2.787894, 2.805118,
2.824803, 2.844488, 2.864173, 2.883858, 2.906004, 2.928150, 2.950295,
2.972441, 2.984744, 2.997047, 3.009350, 3.021654, 3.038878, 3.056103,
3.073327, 3.090551, 3.110236, 3.129921, 3.149606, 3.169291, 3.188977,
3.208662, 3.228347, 3.248032, 2.362205, 2.352362, 2.342520, 2.332677,
2.322835, 2.332677, 2.342520, 2.352362, 2.362205, 2.352362, 2.342520,
2.332677, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.332677,
2.342520, 2.352362, 2.362205, 2.362205, 2.362205, 2.362205, 2.362205,
2.352362, 2.342520, 2.332677, 2.322835, 2.322835, 2.322835, 2.322835,
2.322835, 2.332677, 2.342520, 2.352362, 2.362205, 2.352362, 2.342520,
2.332677, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835,
2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835,
2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835,
2.322835, 2.332677, 2.342520, 2.352362, 2.362205, 2.362205, 2.362205,
2.362205, 2.362205, 2.352362, 2.342520, 2.332677, 2.322835, 2.322835,
2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835, 2.322835,
2.342520, 2.362205, 2.381890, 2.401575, 2.421260, 2.440945, 2.460630,
2.480315, 2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425,
2.618110, 2.637795, 2.667323, 2.696851, 2.726378, 2.755906, 2.775591,
2.795276, 2.814961, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386,
2.933071, 2.952756, 2.972441, 2.992126, 3.001968, 3.011811, 3.021653,
3.031496, 3.051181, 3.070866, 3.090551, 3.110236, 3.129921, 3.149606,
3.169291, 3.188977, 3.208662, 3.228347, 3.248032, 3.267717, 2.381890,
2.374508, 2.367126, 2.359744, 2.352362, 2.357284, 2.362205, 2.367126,
2.372047, 2.367126, 2.362205, 2.357284, 2.352362, 2.349902, 2.347441,
2.344980, 2.342520, 2.352362, 2.362205, 2.372047, 2.381890, 2.381890,
2.381890, 2.381890, 2.381890, 2.374508, 2.367126, 2.359744, 2.352362,
2.349902, 2.347441, 2.344980, 2.342520, 2.349902, 2.357284, 2.364665,
2.372047, 2.364665, 2.357284, 2.349902, 2.342520, 2.344980, 2.347441,
2.349902, 2.352362, 2.352362, 2.352362, 2.352362, 2.352362, 2.349902,
2.347441, 2.344980, 2.342520, 2.342520, 2.342520, 2.342520, 2.342520,
2.342520, 2.342520, 2.342520, 2.342520, 2.349902, 2.357284, 2.364665,
2.372047, 2.374508, 2.376969, 2.379429, 2.381890, 2.372047, 2.362205,
2.352362, 2.342520, 2.344980, 2.347441, 2.349902, 2.352362, 2.349902,
2.347441, 2.344980, 2.342520, 2.357284, 2.372047, 2.386811, 2.401575,
2.421260, 2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370,
2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.664862, 2.691929,
2.718996, 2.746063, 2.768209, 2.790354, 2.812500, 2.834646, 2.854331,
2.874016, 2.893701, 2.913386, 2.930610, 2.947835, 2.965059, 2.982284,
2.997047, 3.011811, 3.026575, 3.041339, 3.058563, 3.075788, 3.093012,
3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 3.208662, 3.228347,
3.248032, 3.267717, 2.401575, 2.396654, 2.391732, 2.386811, 2.381890,
2.381890, 2.381890, 2.381890, 2.381890, 2.381890, 2.381890, 2.381890,
2.381890, 2.376969, 2.372047, 2.367126, 2.362205, 2.372047, 2.381890,
2.391732, 2.401575, 2.401575, 2.401575, 2.401575, 2.401575, 2.396654,
2.391732, 2.386811, 2.381890, 2.376969, 2.372047, 2.367126, 2.362205,
2.367126, 2.372047, 2.376969, 2.381890, 2.376969, 2.372047, 2.367126,
2.362205, 2.367126, 2.372047, 2.376969, 2.381890, 2.381890, 2.381890,
2.381890, 2.381890, 2.376969, 2.372047, 2.367126, 2.362205, 2.362205,
2.362205, 2.362205, 2.362205, 2.362205, 2.362205, 2.362205, 2.362205,
2.367126, 2.372047, 2.376969, 2.381890, 2.386811, 2.391732, 2.396654,
2.401575, 2.391732, 2.381890, 2.372047, 2.362205, 2.367126, 2.372047,
2.376969, 2.381890, 2.376969, 2.372047, 2.367126, 2.362205, 2.372047,
2.381890, 2.391732, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315,
2.500000, 2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110,
2.637795, 2.662402, 2.687008, 2.711614, 2.736221, 2.760827, 2.785433,
2.810040, 2.834646, 2.854331, 2.874016, 2.893701, 2.913386, 2.928150,
2.942914, 2.957677, 2.972441, 2.992126, 3.011811, 3.031496, 3.051181,
3.065945, 3.080709, 3.095473, 3.110236, 3.129921, 3.149606, 3.169291,
3.188977, 3.208662, 3.228347, 3.248032, 3.267717, 2.421260, 2.418799,
2.416339, 2.413878, 2.411417, 2.406496, 2.401575, 2.396654, 2.391732,
2.396654, 2.401575, 2.406496, 2.411417, 2.404035, 2.396654, 2.389272,
2.381890, 2.391732, 2.401575, 2.411417, 2.421260, 2.421260, 2.421260,
2.421260, 2.421260, 2.418799, 2.416339, 2.413878, 2.411417, 2.404035,
2.396654, 2.389272, 2.381890, 2.384350, 2.386811, 2.389272, 2.391732,
2.389272, 2.386811, 2.384350, 2.381890, 2.389272, 2.396654, 2.404035,
2.411417, 2.411417, 2.411417, 2.411417, 2.411417, 2.404035, 2.396654,
2.389272, 2.381890, 2.381890, 2.381890, 2.381890, 2.381890, 2.381890,
2.381890, 2.381890, 2.381890, 2.384350, 2.386811, 2.389272, 2.391732,
2.399114, 2.406496, 2.413878, 2.421260, 2.411417, 2.401575, 2.391732,
2.381890, 2.389272, 2.396654, 2.404035, 2.411417, 2.404035, 2.396654,
2.389272, 2.381890, 2.386811, 2.391732, 2.396654, 2.401575, 2.421260,
2.440945, 2.460630, 2.480315, 2.500000, 2.519685, 2.539370, 2.559055,
2.578740, 2.598425, 2.618110, 2.637795, 2.659941, 2.682087, 2.704232,
2.726378, 2.753445, 2.780512, 2.807579, 2.834646, 2.854331, 2.874016,
2.893701, 2.913386, 2.925689, 2.937992, 2.950295, 2.962599, 2.987205,
3.011811, 3.036417, 3.061024, 3.073327, 3.085630, 3.097933, 3.110236,
3.129921, 3.149606, 3.169291, 3.188977, 3.208662, 3.228347, 3.248032,
3.267717, 2.440945, 2.440945, 2.440945, 2.440945, 2.440945, 2.431102,
2.421260, 2.411417, 2.401575, 2.411417, 2.421260, 2.431102, 2.440945,
2.431102, 2.421260, 2.411417, 2.401575, 2.411417, 2.421260, 2.431102,
2.440945, 2.440945, 2.440945, 2.440945, 2.440945, 2.440945, 2.440945,
2.440945, 2.440945, 2.431102, 2.421260, 2.411417, 2.401575, 2.401575,
2.401575, 2.401575, 2.401575, 2.401575, 2.401575, 2.401575, 2.401575,
2.411417, 2.421260, 2.431102, 2.440945, 2.440945, 2.440945, 2.440945,
2.440945, 2.431102, 2.421260, 2.411417, 2.401575, 2.401575, 2.401575,
2.401575, 2.401575, 2.401575, 2.401575, 2.401575, 2.401575, 2.401575,
2.401575, 2.401575, 2.401575, 2.411417, 2.421260, 2.431102, 2.440945,
2.431102, 2.421260, 2.411417, 2.401575, 2.411417, 2.421260, 2.431102,
2.440945, 2.431102, 2.421260, 2.411417, 2.401575, 2.401575, 2.401575,
2.401575, 2.401575, 2.421260, 2.440945, 2.460630, 2.480315, 2.500000,
2.519685, 2.539370, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795,
2.657480, 2.677166, 2.696851, 2.716536, 2.746063, 2.775591, 2.805118,
2.834646, 2.854331, 2.874016, 2.893701, 2.913386, 2.923228, 2.933071,
2.942913, 2.952756, 2.982283, 3.011811, 3.041338, 3.070866, 3.080709,
3.090551, 3.100394, 3.110236, 3.129921, 3.149606, 3.169291, 3.188977,
3.208662, 3.228347, 3.248032, 3.267717, 2.460630, 2.460630, 2.460630,
2.460630, 2.460630, 2.450787, 2.440945, 2.431102, 2.421260, 2.428642,
2.436024, 2.443406, 2.450787, 2.445866, 2.440945, 2.436024, 2.431103,
2.436024, 2.440945, 2.445866, 2.450787, 2.450787, 2.450787, 2.450787,
2.450787, 2.450787, 2.450787, 2.450787, 2.450787, 2.445866, 2.440945,
2.436024, 2.431103, 2.431103, 2.431103, 2.431103, 2.431103, 2.431103,
2.431103, 2.431103, 2.431103, 2.436024, 2.440945, 2.445866, 2.450787,
2.453248, 2.455709, 2.458169, 2.460630, 2.453248, 2.445866, 2.438484,
2.431103, 2.428642, 2.426181, 2.423720, 2.421260, 2.421260, 2.421260,
2.421260, 2.421260, 2.421260, 2.421260, 2.421260, 2.421260, 2.431102,
2.440945, 2.450787, 2.460630, 2.450787, 2.440945, 2.431102, 2.421260,
2.431102, 2.440945, 2.450787, 2.460630, 2.453248, 2.445866, 2.438484,
2.431103, 2.431103, 2.431103, 2.431103, 2.431103, 2.445866, 2.460630,
2.475394, 2.490158, 2.507382, 2.524606, 2.541831, 2.559055, 2.578740,
2.598425, 2.618110, 2.637795, 2.659941, 2.682087, 2.704232, 2.726378,
2.750984, 2.775591, 2.800197, 2.824803, 2.844488, 2.864173, 2.883858,
2.903543, 2.915847, 2.928150, 2.940453, 2.952756, 2.979823, 3.006890,
3.033957, 3.061024, 3.073327, 3.085630, 3.097933, 3.110236, 3.129921,
3.149606, 3.169291, 3.188977, 3.208662, 3.228347, 3.248032, 3.267717,
2.480315, 2.480315, 2.480315, 2.480315, 2.480315, 2.470472, 2.460630,
2.450787, 2.440945, 2.445866, 2.450787, 2.455709, 2.460630, 2.460630,
2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630,
2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630,
2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630,
2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.460630,
2.460630, 2.460630, 2.460630, 2.465551, 2.470472, 2.475394, 2.480315,
2.475394, 2.470473, 2.465551, 2.460630, 2.455709, 2.450787, 2.445866,
2.440945, 2.440945, 2.440945, 2.440945, 2.440945, 2.440945, 2.440945,
2.440945, 2.440945, 2.450787, 2.460630, 2.470472, 2.480315, 2.470472,
2.460630, 2.450787, 2.440945, 2.450787, 2.460630, 2.470472, 2.480315,
2.475394, 2.470473, 2.465551, 2.460630, 2.460630, 2.460630, 2.460630,
2.460630, 2.470473, 2.480315, 2.490158, 2.500000, 2.514764, 2.529528,
2.544291, 2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.662402,
2.687008, 2.711614, 2.736221, 2.755905, 2.775591, 2.795276, 2.814961,
2.834646, 2.854331, 2.874016, 2.893701, 2.908465, 2.923229, 2.937992,
2.952756, 2.977362, 3.001969, 3.026575, 3.051181, 3.065945, 3.080709,
3.095473, 3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 3.208662,
3.228347, 3.248032, 3.267717, 2.500000, 2.500000, 2.500000, 2.500000,
2.500000, 2.490157, 2.480315, 2.470472, 2.460630, 2.463091, 2.465551,
2.468012, 2.470472, 2.475394, 2.480315, 2.485236, 2.490158, 2.485236,
2.480315, 2.475394, 2.470472, 2.470472, 2.470472, 2.470472, 2.470472,
2.470472, 2.470472, 2.470472, 2.470472, 2.475394, 2.480315, 2.485236,
2.490158, 2.490158, 2.490158, 2.490158, 2.490158, 2.490158, 2.490158,
2.490158, 2.490158, 2.485236, 2.480315, 2.475394, 2.470472, 2.477854,
2.485236, 2.492618, 2.500000, 2.497540, 2.495079, 2.492618, 2.490158,
2.482776, 2.475394, 2.468012, 2.460630, 2.460630, 2.460630, 2.460630,
2.460630, 2.460630, 2.460630, 2.460630, 2.460630, 2.470472, 2.480315,
2.490157, 2.500000, 2.490157, 2.480315, 2.470472, 2.460630, 2.470472,
2.480315, 2.490157, 2.500000, 2.497540, 2.495079, 2.492618, 2.490158,
2.490158, 2.490158, 2.490158, 2.490158, 2.495079, 2.500000, 2.504921,
2.509843, 2.522146, 2.534449, 2.546752, 2.559055, 2.578740, 2.598425,
2.618110, 2.637795, 2.664862, 2.691929, 2.718996, 2.746063, 2.760827,
2.775591, 2.790354, 2.805118, 2.824803, 2.844488, 2.864173, 2.883858,
2.901083, 2.918307, 2.935532, 2.952756, 2.974902, 2.997047, 3.019193,
3.041339, 3.058563, 3.075788, 3.093012, 3.110236, 3.129921, 3.149606,
3.169291, 3.188977, 3.208662, 3.228347, 3.248032, 3.267717, 2.519685,
2.519685, 2.519685, 2.519685, 2.519685, 2.509843, 2.500000, 2.490157,
2.480315, 2.480315, 2.480315, 2.480315, 2.480315, 2.490157, 2.500000,
2.509843, 2.519685, 2.509843, 2.500000, 2.490157, 2.480315, 2.480315,
2.480315, 2.480315, 2.480315, 2.480315, 2.480315, 2.480315, 2.480315,
2.490157, 2.500000, 2.509843, 2.519685, 2.519685, 2.519685, 2.519685,
2.519685, 2.519685, 2.519685, 2.519685, 2.519685, 2.509843, 2.500000,
2.490157, 2.480315, 2.490157, 2.500000, 2.509843, 2.519685, 2.519685,
2.519685, 2.519685, 2.519685, 2.509843, 2.500000, 2.490157, 2.480315,
2.480315, 2.480315, 2.480315, 2.480315, 2.480315, 2.480315, 2.480315,
2.480315, 2.490157, 2.500000, 2.509843, 2.519685, 2.509843, 2.500000,
2.490157, 2.480315, 2.490157, 2.500000, 2.509843, 2.519685, 2.519685,
2.519685, 2.519685, 2.519685, 2.519685, 2.519685, 2.519685, 2.519685,
2.519685, 2.519685, 2.519685, 2.519685, 2.529528, 2.539370, 2.549213,
2.559055, 2.578740, 2.598425, 2.618110, 2.637795, 2.667323, 2.696851,
2.726378, 2.755906, 2.765748, 2.775591, 2.785433, 2.795276, 2.814961,
2.834646, 2.854331, 2.874016, 2.893701, 2.913386, 2.933071, 2.952756,
2.972441, 2.992126, 3.011811, 3.031496, 3.051181, 3.070866, 3.090551,
3.110236, 3.129921, 3.149606, 3.169291, 3.188977, 3.208662, 3.228347,
3.248032, 3.267717, 3.314469};
static float *heights MAYBE_UNUSED = __heights;

#endif
