#! /bin/sh
#
# Generate uvector.h
#
#  $Id: uvector.h.sh,v 1.23 2004/01/27 23:52:14 shirok Exp $
#

cat <<EOF
/*
 * uvector - uniform (homogeneous) numeric vector types (SRFI-4)
 *
 *   Copyright (c) 1999-2003 Shiro Kawai, All rights reserved.
 * 
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  This file is automatically generated.  DO NOT EDIT.
 *  \$Id: uvector.h.sh,v 1.23 2004/01/27 23:52:14 shirok Exp $
 */

#ifndef GAUCHE_UVECTOR_H
#define GAUCHE_UVECTOR_H

#include <gauche.h>

/*
 * This header file is for other extension modules which need
 * to access uniform vectors in C level.
 */

#if SIZEOF_LONG == 4
#ifdef WORDS_BIGENDIAN
typedef struct {
    unsigned long hi;
    unsigned long lo;
} ScmI64;
#else  /* !WORDS_BIGENDIAN */
typedef struct {
    unsigned long lo;
    unsigned long hi;
} ScmI64;
#endif /* !WORDS_BIGENDIAN */
extern ScmObj Scm_Int64Box(ScmI64 v);
extern ScmObj Scm_Uint64Box(ScmI64 v);
extern ScmI64 Scm_Int64Unbox(ScmObj o, int clamp);
extern ScmI64 Scm_Uint64Unbox(ScmObj o, int clamp);
#endif /* SIZEOF_LONG == 4 */

#if SIZEOF_INT >= 4
typedef int           SCM_UVECTOR_INT32;
typedef unsigned int  SCM_UVECTOR_UINT32;
#else
typedef long          SCM_UVECTOR_INT32;
typedef unsigned long SCM_UVECTOR_UINT32;
#endif

#if SIZEOF_LONG >= 8
typedef long          SCM_UVECTOR_INT64;
typedef unsigned long SCM_UVECTOR_UINT64;
#else
typedef ScmI64     SCM_UVECTOR_INT64;
typedef ScmI64     SCM_UVECTOR_UINT64;
#endif

/* Clamp flag for arithmetic operations */
enum {
    SCM_UVECTOR_CLAMP_NONE = 0,
    SCM_UVECTOR_CLAMP_LO   = 1,
    SCM_UVECTOR_CLAMP_HI   = 2,
    SCM_UVECTOR_CLAMP_BOTH = 3
};

/* Operation flag */
enum {
    SCM_UVECTOR_ADD,
    SCM_UVECTOR_SUB,
    SCM_UVECTOR_MUL,
    SCM_UVECTOR_DIV,
    SCM_UVECTOR_AND,
    SCM_UVECTOR_IOR,
    SCM_UVECTOR_XOR
};

/* Useful constants */
extern ScmObj Scm_UvectorS32Max;  /* Scheme 2^31-1 */
extern ScmObj Scm_UvectorS32Min;  /* Scheme -2^31  */
extern ScmObj Scm_UvectorU32Max;  /* Scheme 2^32-1 */
extern ScmObj Scm_UvectorU32Min;  /* Scheme 0      */
extern ScmObj Scm_UvectorS64Max;  /* Scheme 2^63-1 */
extern ScmObj Scm_UvectorS64Min;  /* Scheme -2^63  */
extern ScmObj Scm_UvectorU64Max;  /* Scheme 2^64-1 */
extern ScmObj Scm_UvectorU64Min;  /* Scheme 0      */

/*
 * Common structure for generic uvector operation
 */
typedef struct ScmUVectorRec {
    SCM_HEADER;
    unsigned int immutable : 1;
    int size : (SIZEOF_INT*CHAR_BIT-1);
    void *owner;
    void *elements;
} ScmUVector;

SCM_CLASS_DECL(Scm_UVectorClass);
#define SCM_CLASS_UVECTOR         (&Scm_UVectorClass)
#define SCM_UVECTOR(obj)          ((ScmUVector*)(obj))
#define SCM_UVECTORP(obj)         Scm_TypeP(obj, SCM_CLASS_UVECTOR)
#define SCM_UVECTOR_SIZE(obj)     (SCM_UVECTOR(obj)->size)
#define SCM_UVECTOR_IMMUTABLE_P(obj) (SCM_UVECTOR(obj)->immutable)
#define SCM_UVECTOR_OWNER(obj)    (SCM_UVECTOR(obj)->owner)
#define SCM_UVECTOR_ELEMENTS(obj) (SCM_UVECTOR(obj)->elements)

#define SCM_UVECTOR_CHECK_MUTABLE(obj)                 \\
  do { if (SCM_UVECTOR_IMMUTABLE_P(obj)) {             \\
    Scm_Error("uniform vector is immutable: %S", obj); \\
  }} while (0)

extern int Scm_UVectorElementSize(ScmClass *klass);
extern ScmObj Scm_MakeUVector(ScmClass *klass, int size, void *init);
extern ScmObj Scm_MakeUVectorFull(ScmClass *klass, int size, void *init,
                                  int immutablep, void *owner);
EOF

#
# emit vecttype itemtype
#
emit() {
    vecttype=$1
    itemtype=$2
    integer=$3
    VECTTYPE=`echo $vecttype | tr '[a-z]' '[A-Z]'`
    cat <<EOF

/* ${vecttype} */

typedef struct Scm${vecttype}Rec {
    SCM_HEADER;
    unsigned int immutable : 1;
    int size : (SIZEOF_INT*CHAR_BIT-1);
    void *owner;
    $itemtype *elements;
} Scm${vecttype};

SCM_CLASS_DECL(Scm_${vecttype}Class);
#define SCM_CLASS_${VECTTYPE}  (&Scm_${vecttype}Class)

#define SCM_${VECTTYPE}(obj)        ((Scm${vecttype}*)(obj))
#define SCM_${VECTTYPE}P(obj)       SCM_XTYPEP(obj, SCM_CLASS_${VECTTYPE})
#define SCM_${VECTTYPE}_SIZE(obj)   (SCM_${VECTTYPE}(obj)->size)
#define SCM_${VECTTYPE}_ELEMENTS(obj) (SCM_${VECTTYPE}(obj)->elements)

extern ScmObj Scm_Make${vecttype}(int size, ${itemtype} fill);
extern ScmObj Scm_Make${vecttype}FromArray(int size, const ${itemtype} array[]);
extern ScmObj Scm_Make${vecttype}FromArrayShared(int size, ${itemtype} array[]);
extern ScmObj Scm_${vecttype}Fill(Scm${vecttype} *vec, ${itemtype} fill, int, int);
extern ScmObj Scm_${vecttype}Ref(Scm${vecttype} *vec, int index, ScmObj fallback);
extern ScmObj Scm_${vecttype}Set(Scm${vecttype} *vec, int index, ScmObj val, int clamp);
extern ScmObj Scm_${vecttype}ToList(Scm${vecttype} *vec, int start, int end);
extern ScmObj Scm_ListTo${vecttype}(ScmObj list, int clamp);
extern ScmObj Scm_${vecttype}Copy(Scm${vecttype} *vec, int start, int end);
extern ScmObj Scm_${vecttype}CopyX(Scm${vecttype} *dst, Scm${vecttype} *src);
extern ScmObj Scm_${vecttype}ToVector(Scm${vecttype} *vec, int start, int end);
extern ScmObj Scm_VectorTo${vecttype}(ScmVector *vec, int start, int end, int clamp);

/* arithmetics */
extern ScmObj Scm_${vecttype}Op(Scm${vecttype} *dest, Scm${vecttype} *v0, ScmObj v1, int op, int clamp);
extern ScmObj Scm_${vecttype}DotProd(Scm${vecttype} *v0, ScmObj v1);
extern ScmObj Scm_${vecttype}RangeCheck(Scm${vecttype} *v0, ScmObj min, ScmObj max);
extern ScmObj Scm_${vecttype}Clamp(Scm${vecttype} *v0, ScmObj min, ScmObj max);
EOF
}

emit S8Vector  "signed char"  1
emit U8Vector  "unsigned char" 1
emit S16Vector "signed short" 1
emit U16Vector "unsigned short" 1
emit S32Vector "SCM_UVECTOR_INT32" 1
emit U32Vector "SCM_UVECTOR_UINT32" 1
emit S64Vector "SCM_UVECTOR_INT64" 1
emit U64Vector "SCM_UVECTOR_UINT64" 1
emit F32Vector "float"
emit F64Vector "double"

cat <<EOF

#endif /* GAUCHE_UVECTOR_H */
EOF
