/***************************************************************************

  reserved_t.h

  Template for reserved keywords table and subroutines table.

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#include "gb_common.h"
#include "gb_pcode.h"
#include "gb_type_common.h"
#include "gb_reserved.h"


PUBLIC COMP_INFO COMP_res_info[] =
{
  { "" },

  { "BOOLEAN",      RSF_TYPE,     T_BOOLEAN         },
  { "BYTE",         RSF_TYPE,     T_BYTE            },
  { "DATE",         RSF_TYPE,     T_DATE            },
  { "FLOAT",        RSF_TYPE,     T_FLOAT           },
  { "INTEGER",      RSF_TYPE,     T_INTEGER         },
  { "LONG",                                         },
  { "HUGE"                                          },
  { "SHORT",        RSF_TYPE,     T_SHORT           },
  { "STRING",       RSF_TYPE,     T_STRING          },
  { "VARIANT",      RSF_TYPE,     T_VARIANT         },
  { "CLASS"                                         },
  { "FUNCTION",                                     },
  { "OBJECT",       RSF_TYPE,     T_OBJECT          },
  { "STRUCT"                                        },
  { "CONST"                                         },
  { "PRIVATE"                                       },
  { "PUBLIC"                                        },
  { "STATIC"                                        },
  { "PROPERTY"                                      },
  { "EVENT"                                         },
  { "INHERITS"                                      },
  { "IMPLEMENTS"                                    },
  { "AS"                                            },
  { "DIM"                                           },
  { "NEW"                                           },
  { "PROCEDURE"                                     },
  { "SUB"                                           },
  { "RETURN"                                        },
  { "PARAM"                                         },
  { "OPTIONAL"                                      },
  { "OUTPUT"                                        },
  { "DO"                                            },
  { "LOOP"                                          },
  { "WHILE"                                         },
  { "UNTIL"                                         },
  { "REPEAT"                                        },
  { "WEND"                                          },
  { "IF"                                            },
  { "THEN"                                          },
  { "ELSE"                                          },
  { "ENDIF"                                         },
  { "END"                                           },
  { "FOR"                                           },
  { "TO"                                            },
  { "STEP"                                          },
  { "NEXT"                                          },
  { "SELECT"                                        },
  { "CASE"                                          },
  { "EXIT"                                          },
  { "BREAK"                                         },
  { "CONTINUE"                                      },
  { "GOTO"                                          },
  { "ME"                                            },
  { "LAST"                                          },
  { "TRY"                                           },
  { "FINALLY"                                       },
  { "CATCH"                                         },
  { "WITH"                                          },
  { "TRUE"                                          },
  { "FALSE"                                         },
  { "SWAP"                                          },
  { "NULL"                                          },
  { "EXTERN"                                        },
  { "EACH"                                          },
  { "IN"                                            },
  { "DEFAULT"                                       },
  { "STOP"                                          },
  { "QUIT"                                          },
  { "USE"                                           },
  { "RAISE"                                         },
  { "ERROR"                                         },

  { "PRINT"                                         },
  { "INPUT"                                         },
  { "READ"                                          },
  { "WRITE"                                         },
  { "OPEN"                                          },
  { "CLOSE"                                         },
  { "SEEK"                                          },
  { "APPEND"                                        },
  { "CREATE"                                        },
  { "BINARY"                                        },
  { "DIRECT"                                        },
  { "LINE"                                          },
  { "FLUSH"                                         },
  { "EXEC"                                          },
  { "SHELL"                                         },
  { "WAIT"                                          },
  { "KILL"                                          },
  { "RENAME"                                        },
  { "COPY"                                          },
  { "INC"                                           },
  { "DEC"                                           },
  { "MKDIR"                                         },
  { "RMDIR"                                         },
  { "WATCH"                                         },
  { "BIG"                                           },
  { "LITTLE"                                        },
  { "LINK"                                          },

  { ":"                                                         },
  { ";"                                                         },
  { ","                                                         },
  { "..."                                                       },
  { "#"                                                         },
  { "@"                                                         },
  { "=",            RSF_OP2,      OP_EQUAL,     4,    C_EQ      },
  { "(",            RSF_OPP,      OP_LBRA,      12              },
  { ")",                                                        },
  { ".",            RSF_OP2,      OP_PT,        20              },
  { "!",            RSF_OP2,      OP_EXCL,      20              },
  { "+",            RSF_OP2,      OP_PLUS,      5,    C_ADD     },
  { "-",            RSF_OP2,      OP_MINUS,     5,    C_SUB     },
  { "*",            RSF_OP2,      OP_STAR,      6,    C_MUL     },
  { "/",            RSF_OP2,      OP_SLASH,     6,    C_DIV     },
  { "^",            RSF_OP2,      OP_FLEX,      7,    C_POW     },
  { "&",            RSF_OPN,      OP_AMP,       5,    C_CAT     },
  { ">",            RSF_OP2,      OP_GT,        4,    C_GT      },
  { "<",            RSF_OP2,      OP_LT,        4,    C_LT      },
  { ">=",           RSF_OP2,      OP_GE,        4,    C_GE      },
  { "<=",           RSF_OP2,      OP_LE,        4,    C_LE      },
  { "<>",           RSF_OP2,      OP_NE,        4,    C_NE      },
  { "[",            RSF_OPP,      OP_LSQR,      12              },
  { "]",            RSF_NONE,     OP_RSQR                       },
  { "AND",          RSF_OP2,      OP_AND,       2,    C_AND     },
  { "OR",           RSF_OP2,      OP_OR,        1,    C_OR      },
  { "NOT",          RSF_OP1,      OP_NOT,       10,   C_NOT     },
  { "XOR",          RSF_OP2,      OP_XOR,       3,    C_XOR     },
  { "\\",           RSF_OP2,      OP_DIV,       6,    C_QUO     },
  { "MOD",          RSF_OP2,      OP_MOD,       6,    C_REM     },
  { "IS",           RSF_OP2,      OP_IS,        8,    C_IS      },

  { "LIKE",         RSF_OP2,      OP_LIKE,      4,    C_LIKE    },
  { "&/",           RSF_OPN,      OP_FILE,      7,    C_FILE    },

  { NULL }
};


PUBLIC SUBR_INFO COMP_subr_info[] =
{
  { "Left$",      0,  0,  1,  2 },
  { "Left",       0,  0,  1,  2 },

  { "Mid$",       1,  0,  2,  3 },
  { "Mid",        1,  0,  2,  3 },

  { "Right$",     2,  0,  1,  2 },
  { "Right",      2,  0,  1,  2 },

  { "Len",        3,  0,  1     },

  { "Space$",     4,  0,  1     },
  { "Space",      4,  0,  1     },

  { "String$",    5,  0,  2     },
  { "String",     5,  0,  2     },

  { "Trim$",      6,  0,  1     },
  { "Trim",       6,  0,  1     },

  { "LTrim$",     6,  1,  1     },
  { "LTrim",      6,  1,  1     },

  { "RTrim$",     6,  2,  1     },
  { "RTrim",      6,  2,  1     },

  { "Upper$",     7,  0,  1     },
  { "Upper",      7,  0,  1     },
  { "UCase$",     7,  0,  1     },
  { "UCase",      7,  0,  1     },

  { "Lower$",     8,  0,  1     },
  { "Lower",      8,  0,  1     },
  { "LCase$",     8,  0,  1     },
  { "LCase",      8,  0,  1     },

  { "Chr$",       9,  0,  1     },
  { "Chr",        9,  0,  1     },

  { "Asc",       10,  0,  1,  2 },

  { "InStr",     11,  0,  2,  3 },

  { "RInStr",    12,  0,  2,  3 },

  { "Subst$",    13,  0,  1, 63 },
  { "Subst",     13,  0,  1, 63 },

  { "Replace$",  14,  0,  3,  4 },
  { "Replace",   14,  0,  3,  4 },

  { "Split",     15,  0,  1,  3 },

  { "Conv",      16,  0,  3     },
  { "Conv$",     16,  0,  3     },

  { "Abs",       17,  0,  1     },
  { "Int",       18,  0,  1     },

  { "Frac",      19,  1,  1     },
  { "Log",       19,  2,  1     },
  { "Exp",       19,  3,  1     },
  { "Sqr",       19,  4,  1     },
  { "Sin",       19,  5,  1     },
  { "Cos",       19,  6,  1     },
  { "Tan",       19,  7,  1     },
  { "Atn",       19,  8,  1     },
  { "Atan",      19,  8,  1     },
  { "Asn",       19,  9,  1     },
  { "Asin",      19,  9,  1     },
  { "Acs",       19, 10,  1     },
  { "Acos",      19, 10,  1     },
  { "Deg",       19, 11,  1     },
  { "Rad",       19, 12,  1     },
  { "Log10",     19, 13,  1     },
  { "Sinh",      19, 14,  1     },
  { "Cosh",      19, 15,  1     },
  { "Tanh",      19, 16,  1     },
  { "Asnh",      19, 17,  1     },
  { "Asinh",     19, 17,  1     },
  { "Acsh",      19, 18,  1     },
  { "Acosh",     19, 18,  1     },
  { "Atnh",      19, 19,  1     },
  { "Atanh",     19, 19,  1     },

  { "Sgn",       20,  0,  1     },
  { "Fix",       21,  0,  1     },

  { "Pi",        22,  0,  0,  1 },
  { "Round",     23,  0,  1,  2 },
  { "Randomize", 24,  0,  0     },
  { "Rnd",       25,  0,  0,  2 },
  { "Min",       26,  0,  2, 63 },
  { "Max",       27,  0,  2, 63 },

  { "If",        28,  0,  2,  3 },
  { "IIf",       28,  0,  2,  3 },
  { "Choose",    29,  0,  1, 63 },

  { "Array",     30,  0,  1, 63 },

  { "BClr",      35,  1,  2     },
  { "BSet",      35,  2,  2     },
  { "BTst",      35,  3,  2     },
  { "BChg",      35,  4,  2     },
  { "Shl",       35,  5,  2     },
  { "Shr",       35,  6,  2     },
  { "Rol",       35,  7,  2     },
  { "Ror",       35,  8,  2     },

  { "IsBoolean", 42,  1,  1     },
  { "IsByte",    42,  2,  1     },
  { "IsShort",   42,  3,  1     },
  { "IsInteger", 42,  4,  1     },
  { "IsLong",    42,  5,  1     },
  { "IsFloat",   42,  6,  1     },
  { "IsDate",    42,  7,  1     },
  { "IsString",  42,  8,  1     },
  { "IsNull",    42,  15, 1     },
  { "IsObject",  42,  16, 1     },
  { "IsNumber",  42,  17, 1     },

  { "Boolean?",  42,  1,  1     },
  { "Byte?",     42,  2,  1     },
  { "Short?",    42,  3,  1     },
  { "Integer?",  42,  4,  1     },
  { "Long?",     42,  5,  1     },
  { "Float?",    42,  6,  1     },
  { "Date?",     42,  7,  1     },
  { "String?",   42,  8,  1     },
  { "Null?",     42,  15, 1     },
  { "Object?",   42,  16, 1     },
  { "Number?",   42,  17, 1     },

  { "TypeOf",    43,  0,  1     },

  { "CBool",     44,  1,  1     },
  { "CByte",     44,  2,  1     },
  { "CShort",    44,  3,  1     },
  { "CInt",      44,  4,  1     },
  { "CInteger",  44,  4,  1     },
  { "CLng",      44,  5,  1     },
  { "CLong",     44,  5,  1     },
  { "CFloat",    44,  6,  1     },
  { "CDate",     44,  7,  1     },
  { "CStr",      44,  8,  1     },
  { "CString",   44,  8,  1     },

  { "Bin$",      45,  0,  1,  2 },
  { "Bin",       45,  0,  1,  2 },

  { "Hex$",      46,  0,  1,  2 },
  { "Hex",       46,  0,  1,  2 },

  { "Val",       47,  0,  1     },

  { "Str$",      48,  0,  1     },
  { "Str",       48,  0,  1     },

  { "Format$",   49,  0,  1,  2 },
  { "Format",    49,  0,  1,  2 },

  { "Timer",     50,  0,  0     },

  { "Now",       51,  0,  0     },

  { "Year",      52,  1,  1     },
  { "Month",     52,  2,  1     },
  { "Day",       52,  3,  1     },
  { "Hour",      52,  4,  1     },
  { "Minute",    52,  5,  1     },
  { "Second",    52,  6,  1     },
  { "WeekDay",   52,  7,  1     },

  { "Date",      53,  0,  0,  6 },

  { "Time",      54,  0,  0,  3 },

#ifndef __EVAL_RESERVED_C

  { "Error",     55,  0,  0,  2 },

  { "Eval",      56,  0,  1,  2 },

  { "Use",       57,  0,  1     },
  { "Beep",      58,  0,  0     },

  { "Wait",      59,  0,  0,  1 },

  { "Open",      60,  0,  2     },
  { "Close",     61,  0,  1     },
  { "Input",     62,  0,  0,  1 },
  { "Print",     63,  0,  1, 63 },
  { "Read",      64,  0,  1,  2 },
  { "Write",     65,  0,  1,  2 },
  { "Eof",       66,  0,  1     },
  { "Lof",       67,  0,  1     },
  { "Seek",      68,  0,  1,  3 },
  { "Kill",      69,  0,  1     },
  { "Mkdir",     70,  0,  1     },
  { "Rmdir",     71,  0,  1     },
  { "Exist",     72,  0,  1     },
  { "Rename",    73,  0,  2     },
  { "Stat",      74,  0,  1     },
  { "LineInput", 75,  0,  1     },

  { "Temp",      76,  0,  0,    },
  { "Temp$",     76,  0,  0,    },

  { "IsDir",     77,  0,  1     },
  { "Dir?",      77,  0,  1     },

  { "Dir",       78,  0,  1,  2 },
  { "Flush",     79,  0,  1     },

  { "Exec",      80,  0,  3     },
  { "Shell",     80,  1,  3     },
  { "Copy",      81,  0,  2     },
  { "Access",    82,  0,  1,  2 },
  { "Link",      83,  0,  2     },

  /*
  { "_EventOff", 94,  0,  0     },
  { "_EventOn",  95,  0,  0     },
  */

#endif

  { NULL }
};

/*
PUBLIC CONST_INFO COMP_const_info[] =
{
  {  1, "gbCompBinary" },
  {  2, "gbCompCase" },
  {  3, "gbCompLang" },
  {  4, "gbSearchBackward" },
  {  5, "gbSearchWord" },

  {  6, "gbRead" },
  {  7, "gbWrite" },
  {  8, "gbAppend" },
  {  9, "gbCreate" },
  { 10, "gbDirect" },
  { 11, "gbBinary" },

  { 12, "gbNull" },
  { 13, "gbBoolean" },
  { 14, "gbByte" },
  { 15, "gbShort" },
  { 16, "gbInteger" },
  { 17, "gbLong" },
  { 18, "gbFloat" },
  { 19, "gbDate" },
  { 20, "gbString" },
  { 21, "gbVariant" },
  { 22, "gbObject" },

  { 23, "gbFile" },
  { 24, "gbDirectory" },
  { 25, "gbDevice" },
  { 26, "gbPipe" },
  { 27, "gbSocket" },
  { 28, "gbLink" },
  { 29, "gbHidden" },

  { 30, "gbVoid" },

  { -1, NULL }
};
*/

PUBLIC TABLE *COMP_res_table;
PUBLIC TABLE *COMP_subr_table;
/*PUBLIC TABLE *COMP_const_table;*/


PUBLIC void RESERVED_init(void)
{
  COMP_INFO *info;
  SUBR_INFO *subr;
  /*CONST_INFO *cst;*/

  /* Table des mots rservs */

  TABLE_create(&COMP_res_table, 0, TF_IGNORE_CASE);
  for (info = &COMP_res_info[0]; info->name; info++)
    TABLE_add_symbol(COMP_res_table, info->name, strlen(info->name), NULL, NULL);

  #ifdef DEBUG
  printf("Table des mots rservs:\n");
  TABLE_print(COMP_res_table, TRUE);
  #endif

  /* Table des routines intgres */

  TABLE_create(&COMP_subr_table, 0, TF_IGNORE_CASE);
  for (subr = &COMP_subr_info[0]; subr->name; subr++)
  {
    if (subr->max_param == 0)
      subr->max_param = subr->min_param;

    TABLE_add_symbol(COMP_subr_table, subr->name, strlen(subr->name), NULL, NULL);
  }

  #ifdef DEBUG
  printf("Table des routines intgres:\n");
  TABLE_print(COMP_subr_table, TRUE);
  #endif

  /* Table des constantes */

  /*
  TABLE_create(&COMP_const_table, 0, TF_IGNORE_CASE);
  for (cst = &COMP_const_info[0]; cst->name; cst++)
    TABLE_add_symbol(COMP_const_table, cst->name, strlen(cst->name), NULL, NULL);
  */
}


PUBLIC void RESERVED_exit(void)
{
  TABLE_delete(&COMP_res_table);
  TABLE_delete(&COMP_subr_table);
}


PUBLIC SUBR_INFO *SUBR_get(const char *subr_name)
{
  long index;

  if (!TABLE_find_symbol(COMP_subr_table, subr_name, strlen(subr_name), NULL, &index))
    return NULL;
  else
    return &COMP_subr_info[index];
}


PUBLIC SUBR_INFO *SUBR_get_from_opcode(ushort opcode, ushort optype)
{
  SUBR_INFO *si;

  for (si = COMP_subr_info; si->name; si++)
  {
    if (si->opcode == opcode)
    {
      if (si->min_param != si->max_param)
        return si;
      else if (si->optype == optype || si->optype == 0)
        return si;
    }
  }

  /*ERROR_panic("SUBR_get_from_opcode: SUBR not found !");*/
  return NULL;
}


/*
PUBLIC CONST_INFO *CONST_get(char *cst_name)
{
  long index;

  if (!TABLE_find_symbol(COMP_const_table, cst_name, strlen(cst_name), NULL, &index))
    return NULL;
  else
    return &COMP_const_info[index];
}


PUBLIC CONST_INFO *CONST_get_from_index(short index)
{
  CONST_INFO *ci;

  for (ci = COMP_const_info; ci->name; ci++)
  {
    if (ci->index == index)
      return ci;
  }

  return NULL;
}
*/
