/***************************************************************************

  CMenu.h

  The Menu class

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __CMENU_H
#define __CMENU_H

#include "gambas.h"
#include <qmenudata.h>
#include <qpopupmenu.h>
#include <qintdict.h>
#include <qlist.h>
#include <qkeysequence.h>

#include "CWidget.h"
#include "CPicture.h"

#ifndef __CMENU_CPP
extern GB_DESC CMenuDesc[];
extern GB_DESC CMenuChildrenDesc[];
#else

#define THIS  OBJECT(CMENU)

#define QPOPUPMENU(object) ((QPopupMenu *)((CWIDGET *)object)->widget)
#define QMENUDATA(object) ((QMenuData *)((CWIDGET *)object)->widget)

#define WF_VISIBLE (WF_LAST << 1)

#define CMENU_is_popup(_menu) (((CMENU *)_menu)->children != NULL)
#define CMENU_is_top(_menu) (((CMENU *)_menu)->parent == NULL)
#define CMENU_is_visible(_menu) (CWIDGET_test_flag(_menu, WF_VISIBLE))

#define CMENU_PROPERTIES \
  "Text,Picture,Enabled,Checked,Visible,Tag,Shortcut"

#endif

/*
typedef
  struct {
    GB_BASE ob;
    struct _CMENU *menu;
    CPICTURE *picture;
    long id;
    //char *key;
    }
  CMENUITEM;
*/

typedef
  struct _CMENU {
    CWIDGET widget;
    char *text;
    CPICTURE *picture;
    QMenuData *container;
    struct _CMENU *parent;
    QWidget *toplevel;
    QList<struct _CMENU> *children;
    int id;
    int pos;
    QKeySequence *accel;
    bool enabled;
    bool checked;
    bool deleted;
    }
  CMENU;

typedef
  QIntDict<CMENU> CMenuDict;

typedef
  QList<CMENU> CMenuList;


class CMenu : public QObject
{
  Q_OBJECT

public:

  static CMenu manager;
  static CMenuDict dict;

  static void unrefChildren(CMenuList *list);

public slots:

  void activated(int);
  void shown();
  void destroy();
};

#endif
