/***************************************************************************

  mathext.h

  Mathematical extension routines

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __GBX_MATH_H
#define __GBX_MATH_H

PUBLIC double frac(double x);
PUBLIC long lsgn(long x);
PUBLIC double fsgn(double x);
PUBLIC double deg(double x);
PUBLIC double rad(double x);
PUBLIC double fix(double x);
PUBLIC double frexp10(double x, int *exp);

PUBLIC void randomize(void);
PUBLIC double rnd(void);

#endif
