/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.Base64;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class GalleryProperties
extends Properties
implements PreferenceNames {
    public static final String MODULE = "GalProps";
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    protected Dimension thumbnailSize = null;
    protected Rectangle mainBounds = null;
    protected Rectangle previewBounds = null;

    public GalleryProperties(Properties p) {
        super(p);
    }

    public GalleryProperties() {
    }

    public void copyProperties(Properties source) {
        Enumeration<?> names = source.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = source.getProperty(name);
            this.setProperty(name, value);
        }
    }

    public File getCurrentDirectory() {
        String currentDirectory = this.getProperty("filedialogPath");
        if (currentDirectory != null) {
            return new File(currentDirectory);
        }
        return null;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.setProperty("filedialogPath", currentDirectory.getPath());
    }

    public boolean getShowPreview() {
        return this.getBooleanProperty("showPreview");
    }

    public void setShowPreview(boolean showPreview) {
        this.setProperty("showPreview", String.valueOf(showPreview));
    }

    public boolean getShowPath() {
        return this.getBooleanProperty("showPath");
    }

    public void setShowPath(boolean showPath) {
        this.setProperty("showPath", String.valueOf(showPath));
    }

    public boolean getShowThumbnails() {
        return this.getBooleanProperty("showThumbnails");
    }

    public void setShowThumbnails(boolean showThumbnails) {
        this.setProperty("showThumbnails", String.valueOf(showThumbnails));
    }

    public Dimension getThumbnailSize() {
        if (this.thumbnailSize == null) {
            this.thumbnailSize = this.getDimensionProperty("thumbnailSize");
        }
        return this.thumbnailSize;
    }

    public Rectangle getMainBounds() {
        if (this.mainBounds == null) {
            this.mainBounds = this.getRectangleProperty("mainBounds");
        }
        return this.mainBounds;
    }

    public Rectangle getPreviewBounds() {
        if (this.previewBounds == null) {
            this.previewBounds = this.getRectangleProperty("previewBounds");
        }
        return this.previewBounds;
    }

    public void setMainBounds(Rectangle r) {
        this.setRectangleProperty("mainBounds", r);
    }

    public void setPreviewBounds(Rectangle r) {
        this.setRectangleProperty("previewBounds", r);
    }

    public void setThumbnailSize(Dimension size) {
        this.thumbnailSize = size;
        this.setDimensionProperty("thumbnailSize", size);
    }

    public Dimension getDimensionProperty(String key) {
        StringTokenizer st;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 2) {
            return new Dimension(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        Log.log(1, MODULE, "Parameter " + key + " = " + value + " is missing or malformed (should be width,height)");
        return null;
    }

    public void setDimensionProperty(String key, Dimension d) {
        this.setProperty(key, (int)d.getWidth() + "," + (int)d.getHeight());
    }

    public int getIntDimensionProperty(String key) {
        int i = this.getIntProperty(key + "1", -1);
        if (i == -1) {
            Dimension d = this.getDimensionProperty(key);
            i = d != null ? d.width : 0;
            this.setIntDimensionProperty(key, i);
        }
        return i;
    }

    public void setIntDimensionProperty(String key, int i) {
        this.setProperty(key + "1", String.valueOf(i));
    }

    public Color getColorProperty(String key) {
        StringTokenizer st;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 3) {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        Log.log(1, MODULE, "Parameter " + key + " = " + value + " is missing or malformed (should be red,green,blue)");
        return null;
    }

    public void setColorProperty(String key, Color c) {
        this.setProperty(key, c.getRed() + "," + c.getGreen() + "," + c.getBlue());
    }

    public boolean getLoadLastMRU() {
        return this.getBooleanProperty("loadLastMRU", false);
    }

    public void setLoadLastMRU(boolean loadLastMRU) {
        this.setBooleanProperty("loadLastMRU", loadLastMRU);
    }

    public void setMRUCountProperty(int MRUCountProperty) {
        this.setIntProperty("mruCount", MRUCountProperty);
    }

    public int getMRUCountProperty() {
        return this.getIntProperty("mruCount", 4);
    }

    public String getMRUItem(int mruItemNumber) {
        return this.getProperty("mruItem." + mruItemNumber, null);
    }

    public void removeMRUItem(int mruItemNumber) {
        this.remove("mruItem." + mruItemNumber);
    }

    public void setMRUItem(int mruItemNumber, String mruItem) {
        this.setProperty("mruItem." + mruItemNumber, mruItem);
    }

    public void addMRUItem(File mruItem) {
        try {
            String currentItem = mruItem.getCanonicalPath();
            this.addMRUItem(currentItem);
        }
        catch (IOException ioe) {
            Log.log(1, MODULE, "mruItem add attempt with an invalid File object");
            Log.logException(1, MODULE, ioe);
        }
    }

    public void addMRUItem(String newMRUItem) {
        int i;
        Vector<String> mruItems = new Vector<String>();
        mruItems.addElement(newMRUItem);
        for (i = 0; i < 20; ++i) {
            String nextItem = this.getMRUItem(i);
            if (null == nextItem || nextItem.equals(newMRUItem)) continue;
            mruItems.addElement(nextItem);
        }
        for (i = 1; i <= 20; ++i) {
            this.removeMRUItem(i);
        }
        for (i = 1; i <= mruItems.size(); ++i) {
            this.setMRUItem(i, (String)mruItems.elementAt(i - 1));
        }
    }

    public Rectangle getRectangleProperty(String key) {
        StringTokenizer st;
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value != null && (st = new StringTokenizer(value, ",")).countTokens() == 4) {
            return new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        Log.log(1, MODULE, "Parameter " + key + " is missing or malformed (should be x,y,width,height)");
        return null;
    }

    public void setRectangleProperty(String key, Rectangle rect) {
        this.setProperty(key, (int)rect.getX() + "," + (int)rect.getY() + "," + (int)rect.getWidth() + "," + (int)rect.getHeight());
    }

    public boolean getBooleanProperty(String key) {
        String booleanS = this.getProperty(key);
        if (booleanS != null) {
            if (booleanS.equalsIgnoreCase("yes") || booleanS.equalsIgnoreCase("true")) {
                return true;
            }
            if (booleanS.equalsIgnoreCase("no") || booleanS.equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new NumberFormatException("Parameter " + key + " = " + booleanS + " is missing or malformed (should be true/yes or false/no)");
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        try {
            return this.getBooleanProperty(key);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setBooleanProperty(String key, boolean value) {
        this.setProperty(key, value ? "true" : "false");
    }

    public int getIntProperty(String key) {
        String intS = this.getProperty(key);
        try {
            return Integer.valueOf(intS);
        }
        catch (Exception e) {
            throw new NumberFormatException("Parameter " + key + " = " + intS + " is missing or malformed (should be an integer value)");
        }
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            return this.getIntProperty(key);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public void setIntProperty(String key, int value) {
        this.setProperty(key, String.valueOf(value));
    }

    public String getBase64Property(String key) {
        String base64S = this.getProperty(key);
        if (base64S == null) {
            return null;
        }
        try {
            return Base64.decode(base64S);
        }
        catch (Error e) {
            throw new NumberFormatException("Parameter " + key + " = " + base64S + " is missing or malformed (should be a Base64 value)");
        }
    }

    public void setBase64Property(String key, String value) {
        this.setProperty(key, Base64.encode(value));
    }

    public Date getDateProperty(String key) {
        String dateS = this.getProperty(key);
        if (dateS == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(dateS);
        }
        catch (ParseException e) {
            throw new NumberFormatException("Parameter " + key + " = " + dateS + " is missing or malformed (should be a Date value (yyyy/mm/dd))");
        }
    }

    public void setDateProperty(String key, Date date) {
        this.setProperty(key, this.dateFormat.format(date));
    }

    public String getProperty(String key, String defaultValue) {
        String tmp = this.getProperty(key);
        if (tmp == null) {
            return defaultValue;
        }
        return tmp;
    }

    public void logProperties(int level, String module) {
        if (module == null) {
            module = MODULE;
        }
        ArrayList names = new ArrayList(100);
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        Object[] namesArray = names.toArray();
        Arrays.sort(namesArray);
        for (int i = 0; i < namesArray.length; ++i) {
            String name = (String)namesArray[i];
            Log.log(level, module, name + "= |" + this.getProperty(name) + "|");
        }
    }

    public void uncache() {
        this.thumbnailSize = null;
        this.mainBounds = null;
        this.previewBounds = null;
    }
}

