/*
 * Galaxium Messenger
 * Copyright (C) 2003-2007 Philippe Durand <draekz@gmail.com>
 * Copyright (C) 2005-2007 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections.Generic;

using Galaxium.Core;

namespace Galaxium.Protocol.Msn
{
	[Flags]
	public enum MsnClientIdentifier : long
	{
		Unknown = 0,
		MobileDevice = 0x01,
		CanSendReceiveInk_GIF = 0x04,
		CanSendReceiveInk_ISF = 0x08,
		CanVideoConference = 0x10,
		MultiPacketMessaging = 0x20,
		MsnMobileDevice = 0x40,
		MsnDirectDevice = 0x80,
		WebBasedMessenger = 0x100,
		DirectIM = 0x4000,
		CanReceiveWinks = 0x8000,
		SupportVoiceClips = 0x40000,
		SupportSharedFolder = 0x400000,
		SupportsMSNC1 = 0x10000000,
		SupportsMSNC2 = 0x20000000,
		SupportsMSNC3 = 0x30000000,
		SupportsMSNC4 = 0x40000000,
		SupportsMSNC5 = 0x50000000,
		SupportsMSNC6 = 0x60000000,
		SupportsMSNC7 = 0x70000000,

		Default = SupportsMSNC7 | DirectIM | MultiPacketMessaging | CanReceiveWinks | CanSendReceiveInk_GIF | SupportVoiceClips
	}
}