/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * Copyright (C) 2007 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

using G=Gtk;

using Galaxium.Core;
using Galaxium.Gui;
using Galaxium.Gui.GtkGui;

namespace Galaxium.Protocol.Msn.GtkGui
{
	public class InviteContactToolCommand : AbstractMenuCommand
	{
		public override void SetMenuItem ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			(MenuItem as G.ToolButton).Sensitive = (chatWidget != null) && (chatWidget.Conversation as MsnConversation).CanInvite;
		}
		
		public override void Run ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			if (chatWidget != null)
			{
				new InviteContactDialog (chatWidget.Conversation, delegate (IContact c)
				{
					MsnContact contact = c as MsnContact;
					
					return (contact.Network == Network.WindowsLive) &&
							(contact.Presence != MsnPresence.Offline) &&
							(!chatWidget.Conversation.ContactCollection.Contains (contact));
				},
				delegate (IContact c)
				{
					MsnContact contact = c as MsnContact;

					if (contact.Presence == MsnPresence.Idle)
						return IconUtility.GetIcon ("galaxium-idle", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Offline)
						return IconUtility.GetIcon ("galaxium-offline", IconSizes.Small);
					else if (!contact.IsInList(MsnListType.Reverse))
						return IconUtility.GetIcon ("galaxium-status-reverse", IconSizes.Small);
					else if (contact.IsBlocked)
						return IconUtility.GetIcon ("galaxium-status-block", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Away)
						return IconUtility.GetIcon ("galaxium-status-away", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Brb)
						return IconUtility.GetIcon ("galaxium-status-brb", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Busy)
						return IconUtility.GetIcon ("galaxium-status-busy", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Lunch)
						return IconUtility.GetIcon ("galaxium-status-lunch", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Online)
						return IconUtility.GetIcon ("galaxium-online", IconSizes.Small);
					else if (contact.Presence == MsnPresence.Phone)
						return IconUtility.GetIcon ("galaxium-status-phone", IconSizes.Small);
					
					return null;
				});
			}
		}
	}
	
	public class SendNudgeToolCommand : AbstractMenuCommand
	{
		public override void SetMenuItem ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			(MenuItem as G.ToolButton).Sensitive = (chatWidget != null) && (chatWidget.Conversation as MsnConversation).CanSendNudge;
		}
		
		public override void Run ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			if (chatWidget != null)
				chatWidget.SendNudge ();
		}
	}
	
	public class SendFileToolCommand : AbstractMenuCommand
	{
		public override void SetMenuItem ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			(MenuItem as G.ToolButton).Sensitive = (chatWidget != null) &&
													chatWidget.Conversation.IsPrivateConversation &&
													((chatWidget.Conversation.PrimaryContact as MsnContact).Network == Network.WindowsLive) &&
													(chatWidget.Conversation.PrimaryContact.Presence != MsnPresence.Offline);
		}
		
		public override void Run ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			if (chatWidget != null)
				chatWidget.SendFile ();
		}
	}
	
	public class StartActivityCommand : AbstractMenuCommand
	{
		public override void SetMenuItem ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			(MenuItem as G.ToolButton).Sensitive = (chatWidget != null) && (chatWidget.Conversation as MsnConversation).CanStartActivity;
		}
		
		public override void Run ()
		{
			MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			if (chatWidget != null)
				chatWidget.ShowActivityPopup (MenuItem as G.Widget);
		}
	}
	
	public class ViewWebcamCommand : AbstractMenuCommand
	{
		public override void SetMenuItem ()
		{
			//MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			//(MenuItem as G.MenuItem).Sensitive = (chatWidget != null) && (chatWidget.Conversation as MsnConversation).CanViewWebcam;
			(MenuItem as G.MenuItem).Sensitive = false;
		}
		
		public override void Run ()
		{
			//MsnChatWidget chatWidget = Object as MsnChatWidget;
			
		}
	}
	
	public class ShowWebcamCommand : AbstractMenuCommand
	{
		public override void SetMenuItem ()
		{
			//MsnChatWidget chatWidget = Object as MsnChatWidget;
			
			//(MenuItem as G.MenuItem).Sensitive = (chatWidget != null) && (chatWidget.Conversation as MsnConversation).CanShowWebcam;
			(MenuItem as G.MenuItem).Sensitive = false;
		}
		
		public override void Run ()
		{
			//MsnChatWidget chatWidget = Object as MsnChatWidget;
			
		}
	}
}
