using System;
using System.IO;

using Mono.Addins;
using Galaxium.Core;

namespace Galaxium.Gui
{
	public class MessageDisplayExtension: ExtensionNode
	{
		[NodeAttribute]
		string id;
		
		[NodeAttribute]
		string icon;
		
		[NodeAttribute]
		string type;
		
		public string Name
		{
			get { return id; }
		}
		
		public string Icon
		{
			get { return icon; }
		}
		
		public IMessageDisplay CreateInstance (Galaxium.Protocol.IConversation conversation)
		{
			return Activator.CreateInstance (Addin.GetType (type), conversation) as IMessageDisplay;
		}
		
		public override bool Equals (object o)
		{
			return base.Equals(o) || id.Equals(o);
		}
	}
}
