namespace Galago
{
	using System;
	using System.Runtime.InteropServices;

	public delegate void StatusUpdatedHandler(object o, StatusUpdatedArgs args);

	public class StatusUpdatedArgs : SignalArgs
	{
		public Status Status
		{
			get
			{
				IntPtr raw_ret = (IntPtr)Args[0];
				return Object.Wrap(raw_ret) as Status;
			}
		}

		public string AttributeId
		{
			get
			{
				IntPtr raw_ret = (IntPtr)Args[1];
				return Marshal.PtrToStringAnsi(raw_ret);
			}
		}
	}
}


