namespace Galago
{
	using System;
	using System.Runtime.InteropServices;

	public class Person
		: Object
	{
		~Person()
		{
			Dispose();
		}

		public Person(IntPtr raw) : base(raw) {}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_new(string id, bool native);

		public Person(string id, bool native)
		{
			Raw = galago_person_new(id, native);
		}

		public Person(string id)
			: this(id, true)
		{
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_me_new(bool native);

		public static Person GetMe(bool native)
		{
			return new Person(galago_person_me_new(native));
		}

		[DllImport("libgalago.so")]
		static extern bool galago_person_is_me(IntPtr person);

		public bool IsMe
		{
			get { return galago_person_is_me(Handle); }
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_id(IntPtr person);

		public string Id
		{
			get
			{
				IntPtr raw_ret = galago_person_get_id(Handle);
				return Marshal.PtrToStringAnsi(raw_ret);
			}
		}

		[DllImport("libgalago.so")]
		static extern bool galago_person_is_native(IntPtr person);

		public bool Native
		{
			get { return galago_person_is_native(Handle); }
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_display_name(IntPtr person);

		public string DisplayName
		{
			get
			{
				IntPtr raw_ret = galago_person_get_display_name(Handle);
				return Marshal.PtrToStringAnsi(raw_ret);
			}
		}

		[DllImport("libgalago.so")]
		static extern bool galago_person_has_accounts(IntPtr person,
													  bool query);

		public bool HasAccounts(bool query)
		{
			return galago_person_has_accounts(Handle, query);
		}

		public bool HasAccounts()
		{
			return HasAccounts(true);
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_accounts(IntPtr person,
														bool query);

		public List GetAccounts(bool query)
		{
			IntPtr raw_ret = galago_person_get_accounts(Handle, query);

			return new List(raw_ret);
		}

		public List GetAccounts()
		{
			return GetAccounts(true);
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_priority_account(IntPtr person);

		public Person PriorityAccount
		{
			get
			{
				IntPtr raw_ret = galago_person_get_priority_account(Handle);
				return Object.Wrap(raw_ret) as Person;
			}
		}

		[DllImport("libgalago.so")]
		static extern void galago_person_add_account(IntPtr person,
													 IntPtr account);

		public void AddAccount(Account account)
		{
			galago_person_add_account(Handle, account.Handle);
		}

		[DllImport("libgalago.so")]
		static extern void galago_person_remove_account(IntPtr person,
														IntPtr account);

		public void RemoveAccount(Account account)
		{
			galago_person_remove_account(Handle, account.Handle);
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_account(IntPtr person,
													   IntPtr service,
													   string username,
													   bool query);

		public Account GetAccount(Service service, string username,
								  bool query)
		{
			IntPtr raw_ret = galago_person_get_account(Handle, service.Handle,
													   username, query);
			return Object.Wrap(raw_ret) as Account;
		}

		public Account GetAccount(Service service, string username)
		{
			return GetAccount(service, username, true);
		}

		[DllImport("libgalago.so")]
		static extern void galago_person_set_property_string(IntPtr person,
															 string name,
															 string value);

		public void SetProperty(string name, string value)
		{
			galago_person_set_property_string(Handle, name, value);
		}

		[DllImport("libgalago.so")]
		static extern void galago_person_set_property_bool(IntPtr person,
														   string name,
														   bool value);

		public void SetProperty(string name, bool value)
		{
			galago_person_set_property_bool(Handle, name, value);
		}

		[DllImport("libgalago.so")]
		static extern void galago_person_set_property_uint32(IntPtr person,
															 string name,
															 uint value);

		public void SetProperty(string name, uint value)
		{
			galago_person_set_property_uint32(Handle, name, value);
		}

		[DllImport("libgalago.so")]
		static extern bool galago_person_remove_property(IntPtr person,
														 string name);

		public bool RemoveProperty(string name)
		{
			return galago_person_remove_property(Handle, name);
		}

		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_property_string(IntPtr person,
															   string name);

		public void GetProperty(string name, out string value)
		{
			IntPtr raw_ret = galago_person_get_property_string(Handle, name);

			value = Marshal.PtrToStringAnsi(raw_ret);
		}

		[DllImport("libgalago.so")]
		static extern bool galago_person_get_property_bool(IntPtr person,
														   string name);

		public void GetProperty(string name, out bool value)
		{
			value = galago_person_get_property_bool(Handle, name);
		}

		[DllImport("libgalago.so")]
		static extern uint galago_person_get_property_uint32(IntPtr person,
															 string name);

		public void GetProperty(string name, out uint value)
		{
			value = galago_person_get_property_uint32(Handle, name);
		}

		/*
		 * Photo
		 */
		[DllImport("libgalago.so")]
		static extern void galago_person_set_photo(IntPtr person,
												   IntPtr photo);

		public Photo Photo
		{
			get { return GetPhoto(true);                          }
			set { galago_person_set_photo(Handle, value.Handle); }
		}

		/*
		 * GetPhoto
		 */
		[DllImport("libgalago.so")]
		static extern IntPtr galago_person_get_photo(IntPtr person,
													   bool query);

		public Photo GetPhoto(bool query)
		{
			IntPtr raw_ret = galago_person_get_photo(Handle, query);

			return Object.Wrap(raw_ret) as Photo;
		}

		public Photo GetPhoto()
		{
			return GetPhoto(true);
		}

		/*
		 * Signals
		 */
		[Galago.Signal("updated")]
		public event EventHandler OnUpdated
		{
			add
			{
				AddSignalHandler("updated",
								 typeof(SignalMarshals.VoidVoidSignal),
								 typeof(EventArgs),
								 value);
			}

			remove
			{
				RemoveSignalHandler("updated", value);
			}
		}

		[Galago.Signal("photo-set")]
		public event PhotoSetHandler OnPhotoSet
		{
			add
			{
				AddSignalHandler("photo-set",
								 typeof(SignalMarshals.VoidPointerSignal),
								 typeof(PhotoSetArgs),
								 value);
			}

			remove
			{
				RemoveSignalHandler("photo-set", value);
			}
		}
	}
}
