"""
This type stub file was generated by pyright.
"""

from typing import Optional
from typing import TypeVar

from datetime import datetime

from winrt.windows.ui.notifications import ScheduledToastNotification
from winrt.windows.ui.notifications import ToastNotification
from winrt.windows.ui.notifications import ToastNotifier

from .toast import Toast

ToastNotificationT = TypeVar("ToastNotificationT", ToastNotification, ScheduledToastNotification)
class BaseWindowsToaster:
    """
    Wrapper to simplify WinRT's ToastNotificationManager

    :param applicationText: Text to display the application as
    """
    applicationText: str
    notifierAUMID: Optional[str]
    toastNotifier: ToastNotifier
    def __init__(self, applicationText: str) -> None:
        ...
    
    def show_toast(self, toast: Toast) -> None:
        """
        Displays the specified toast notification.
        If `toast` has already been shown, it will pop up again, but make no new sections in the action center

        :param toast: Toast to display
        """
        ...
    
    def update_toast(self, toast: Toast) -> bool:
        """
        Update the passed notification data with the new data in the clas

        :param toast: Toast to update
        :type toast: Toast
        :return: Whether the update succeeded
        """
        ...
    
    def schedule_toast(self, toast: Toast, displayTime: datetime) -> None:
        """
        Schedule the passed notification toast. Warning: scheduled toasts cannot be updated or activated (i.e. on_X)

        :param toast: Toast to display
        :type toast: Toast
        :param displayTime: Time to display the toast on
        :type displayTime: datetime
        """
        ...
    
    def unschedule_toast(self, toast: Toast) -> None:
        """
        Unschedule the passed notification toast

        :raises: ToastNotFoundError: If the toast could not be found
        """
        ...
    
    def clear_toasts(self) -> None:
        """
        Clear toasts popped by this toaster
        """
        ...
    
    def clear_scheduled_toasts(self) -> None:
        """
        Clear all scheduled toasts set for the toaster
        """
        ...
    


class WindowsToaster(BaseWindowsToaster):
    """
    Basic toaster, used to display toasts without actions and/or inputs.
    If you need to use them, see :class:`InteractableWindowsToaster`

    :param applicationText: Text to display the application as
    """
    __InteractableWarningMessage = ...
    def __init__(self, applicationText: str) -> None:
        ...
    
    def show_toast(self, toast: Toast) -> None:
        ...
    


class InteractableWindowsToaster(BaseWindowsToaster):
    """
    :class:`WindowsToaster`, but uses a AUMID to support actions. Actions require a recognised AUMID to trigger
    on_activated, otherwise it triggers on_dismissed with no arguments

    :param applicationText: Text to display the application as
    :param notifierAUMID: AUMID to use. Defaults to Command Prompt. To use a custom AUMID, see one of the scripts
    """
    def __init__(self, applicationText: str, notifierAUMID: Optional[str] = ...) -> None:
        ...
    


