%define gaim_major_ver %(echo %{gaimver} | sed -e 's/\\([[0-9]]*\\).\\([[0-9]]*\\).\\([[0-9]]*\\)/\\1/' -)
%define gaim_minor_ver %(echo %{gaimver} | sed -e 's/\\([[0-9]]*\\).\\([[0-9]]*\\).\\([[0-9]]*\\)/\\2/' -)
%define gaim_next_major_ver %(echo $((%{gaim_major_ver}+1)))
%define rpmrelease 0

Summary:    XMMS Remote Plugin for Gaim
Name:       gaim-xmms-remote
Version:    1.8
Release:    %{gaim_major_ver}.%{gaim_minor_ver}.%{rpmrelease}%{?gaimdist:.%{gaimdist}}
License:    GPL
Group:      Applications/Internet
Url:        http://guifications.sourceforge.net/
Source:     gaim-xmms-remote-%{version}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-%{version}-root

Requires:      gaim >= 1:%{gaim_major_ver}.%{gaim_minor_ver}
Conflicts:     gaim > 1:%{gaim_next_major_ver}
Conflicts:     gaim < 1:%{gaim_major_ver}.%{gaim_minor_ver}

BuildRequires: pkgconfig, libtool, xmms-devel, gaim-devel >= 1:%{gaim_major_ver}.%{gaim_minor_ver}
BuildConflicts: gaim-devel > 1:%{gaim_next_major_ver}, gaim-devel < 1:%{gaim_major_ver}.%{gaim_minor_ver}

%if "%{_vendor}" == "MandrakeSoft"
BuildRequires: libgtk+1.2-devel, libgtk+2.0_0-devel
%else
BuildRequires: gtk+-devel, gtk2-devel
%endif

%description
Gaim XMMS Remote is a remote control plugin for Gaim to control XMMS

To rebuild for a specific Gaim version or dist tag:
rpmbuild --rebuild gaim-gaim-xmms-remote-1.8-%{release}.src.rpm --define 'gaimver %{gaimver}' --define 'gaimdist %{!?gaimdist:fc1}%{?gaimdist:%{gaimdist}}'

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix}

make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

strip $RPM_BUILD_ROOT%{_libdir}/gaim/*.so || :
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/gxr.la $RPM_BUILD_ROOT%{_libdir}/gaim/gxr.a

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc README ChangeLog
%{_libdir}/gaim/gxr.so
%dir %{_datadir}/pixmaps/gaim/gxr
%{_datadir}/pixmaps/gaim/gxr/*

%changelog
* Tue Oct 12 2004 Stu Tomlinson <stu@nosnilmot.com>
- Add Gaim version checks to match new Gaim versioning

* Fri Jun 25 2004 Stu Tomlinson <stu@nosnilmot.com>
- Update for Gaim 0.79

* Thu May 27 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweak to allow both .src.rpm and .nosrc.rpm to be generated
  from a dist tarball.

* Wed Mar 24 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweak!

* Tue Mar 02 2004 Stu Tomlinson <stu@nosnilmot.com>
- Initial spec file
