 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: progress.c                                                       *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>

#include "gafix.h"
#include "progress.h"

GtkWidget *
new_progress_window ( void )
{
	GtkWidget *dialog, *progressbar;
   
	/* Create the widgets */
	dialog = gtk_dialog_new_with_buttons ("Communicate with Casio Calculator...", GTK_WINDOW(main_window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);
	progressbar = gtk_progress_bar_new ();
   
	/* Ensure that the dialog box is hidden when the user responds. */
	g_signal_connect_swapped (dialog, "response",  G_CALLBACK (disable_progress_window), NULL);
	g_signal_connect_swapped (dialog, "delete-event", G_CALLBACK (disable_progress_window), NULL);

	/* Add the progressbar */
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), progressbar);

	/* return the whole dialog */
	return dialog;
}

void
enable_progress_window ( void )
{
	/* make sure that the communication is not canceld */
	progress_cancel = FALSE;

	/* show the progress-dialog widget */
	gtk_widget_show_all ( progress );

	/* reset the statusbar */
	set_progress_window_status ( 0 );

	/* disable buttons in main window */
	sensitive_of_communication_buttons ( FALSE );

	/* make sure it's displayed */
	while (gtk_events_pending ())
		gtk_main_iteration ();
}

void
disable_progress_window ( void )
{
	/* make sure that the communication is canceld */
	progress_cancel = TRUE;

	/* hide the progress-dialog widget */
	set_progress_window_status ( 0 );

	/* reset the statusbar */
	gtk_widget_hide ( progress );

	/* disable buttons in main window */
	sensitive_of_communication_buttons ( TRUE );
}

void
set_progress_window_status ( gint percentage )
{
	gdouble fraction = (gdouble) percentage / 100;						//get fraction of percentage

	gtk_progress_bar_set_fraction (										//set the fraction
		GTK_PROGRESS_BAR (												//define as GtkProgressBar
			gtk_container_get_children (								//get children of vertical box in progress-dialog (= ProgressBar)
				gtk_container_get_children (							//get children of progress-dialog (= vertical box)
					GTK_CONTAINER(progress)								//define progress-dialog as GtkContainer
				)->data													//Use first child's data ( = vertical box )
			)->data														//Use first child's data ( = Progressbar )
		),																//end of GTK_PROGRESS_BAR
		fraction														//the fraction parameter for gtk_progress_bar_set_fraction
	);																	//end of gtk_progress_bar_set_fraction
}

void
sensitive_of_communication_buttons ( gboolean sensitive )
{
	/* enable/disable CFX communication menu */
	gtk_widget_set_sensitive (									// set sensitive
		GTK_WIDGET (											// define it as a widget
			g_list_nth_data (									// get data of nth child (CFX menu)
				gtk_container_get_children (					// get children of menu bar
					GTK_CONTAINER (								// define it as a container
						gtk_container_get_children (			// get first child (menu bar)
							gtk_container_get_children (		// get first hild (vertical box)
								GTK_CONTAINER(main_window)		// main window
							)->data
						)->data
					)
				),
				2
			)
		),
		sensitive
	);

	/* enable/disable Upload Button */
	gtk_widget_set_sensitive (													// set sensitive
		GTK_WIDGET (															// define as container
			g_list_nth_data (													// get data of 4th child (upload button)
				gtk_container_get_children (									// get children of toolbar
					GTK_CONTAINER (												// define as container
						gtk_container_get_children (							// get first child of griparea (toolbar)
							GTK_CONTAINER (										// define as container
								g_list_nth_data (								// get data of 2th child (toolbar's griparea)
									gtk_container_get_children (				// get second children of vertical box
										GTK_CONTAINER (							// define as container
											gtk_container_get_children (		// get first hild (vertical box)
												GTK_CONTAINER(main_window)		// main window
											)->data
												)
									),
									1
								)
							)
						)->data
					)
				),
				4
			)
		),
		sensitive
	);

	/* enable/disable Download Button */
	gtk_widget_set_sensitive (													// set sensitive
		GTK_WIDGET (															// define as container
			g_list_nth_data (													// get data of 5th child (download button)
				gtk_container_get_children (									// get children of toolbar
					GTK_CONTAINER (												// define as container
						gtk_container_get_children (							// get first child of griparea (toolbar)
							GTK_CONTAINER (										// define as container
								g_list_nth_data (								// get data of 2th child (toolbar's griparea)
									gtk_container_get_children (				// get second children of vertical box
										GTK_CONTAINER (							// define as container
											gtk_container_get_children (		// get first hild (vertical box)
												GTK_CONTAINER(main_window)		// main window
											)->data
												)
									),
									1
								)
							)
						)->data
					)
				),
				5
			)
		),
		sensitive
	);
	
}
