 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: gafix.c                                                          *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcebuffer.h>
#include <gtksourceview/gtksourcetagtable.h>
#include <glade/glade.h>

#include <stdlib.h>

#include "text_functions.h"
#include "file.h"
#include "gafix.h"
#include "tab.h"
#include "info_dialog.h"
#include "progress.h"

int
main (int argc, char **argv)
{
	/* initialize gtk */
	gtk_init (&argc, &argv);

	/* test for glade xml file */
	if(file_existance(GLADE_FILE) == FALSE) {
		g_printerr("Glade file was not found at \"%s\"\n", GLADE_FILE);
		return -1;
	}

	/* load glade xml file */
	xml = glade_xml_new (GLADE_FILE, "main", NULL);

	tty = "/dev/ttyS0";

	/* load global widgets */
	notebook  = glade_xml_get_widget (xml, "notebook");
	statusbar = glade_xml_get_widget (xml, "statusbar");
	main_window = glade_xml_get_widget (xml, "main");
	progress = new_progress_window();

	/* connect functions to signals */
	glade_xml_signal_autoconnect(xml);
	
	/* show the main window */
	gtk_widget_show_all (main_window);

	/* Create empty page */
	new_file();

	/* gtk main loop */
	gtk_main ();
	
	/* exit program successfully */
	return EXIT_SUCCESS;
}
