/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "allocate.h"
#include "widgets.h"
#include "functions.h"
#include "populate_user_settings.h"
#include "chars_are_digits.h"
#include "show_info.h"
#include "populate_shell_combo.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];
extern char global_user_name[1024];



void populate_user_settings(struct w *widgets)
{
    gchar *utf8=NULL, *username, *user_item, *groupname;
    GtkListStore *shell_store;
    GtkTreeIter shell_iter;
    gchar *shell;

    /* Always set an empty password */
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[1]), "");

    username = g_strdup_printf("%s", global_user_name);

    /* Set all widget values to default if no user is selected */
    if( username == NULL || strlen(username) < 1 )
    {
	/* User */
	gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[0]), "");

	/* Password */
	gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[1]), "");

	/* Group */
	gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[2]), "");

	/* Comment */
	gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[3]), "");

	/* Home directory */
	gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[4]), "/home/SomeUserName");

	/* Shell */
	gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->user_set_combo[0]), 0);
    }

    /* Insert username */
    utf8 = g_locale_to_utf8(username, strlen(username), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[0]), utf8);
    if( utf8!=NULL )
      g_free(utf8);

    /* Insert group name */
    user_item = get_user_setting(username, "group");
    groupname = get_group_name(user_item);
    utf8 = g_locale_to_utf8(groupname, strlen(groupname), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[2]), utf8);
    g_free(user_item);
    g_free(groupname);
    if( utf8!=NULL )
      g_free(utf8);

    /* Insert the users comment */
    user_item = get_user_setting(username, "comment");
    utf8 = g_locale_to_utf8(user_item, strlen(user_item), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[3]), utf8);
    g_free(user_item);
    if( utf8!=NULL )
      g_free(utf8);


    /* Insert home directory */
    user_item = get_user_setting(username, "homedir");
    utf8 = g_locale_to_utf8(user_item, strlen(user_item), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->user_set_entry[4]), utf8);
    g_free(user_item);
    if( utf8!=NULL )
      g_free(utf8);

    /* Get the users shell and select it. If the shell combo has
       this shell in its list(/etc/shells), then select it. Otherwise select /dev/null */
    user_item = get_user_setting(username, "shell");
    shell_store = GTK_LIST_STORE(gtk_combo_box_get_model(GTK_COMBO_BOX(widgets->user_set_combo[0])));
    if( shell_store )
    {
        if( gtk_tree_model_get_iter_first(GTK_TREE_MODEL(shell_store), &shell_iter) )
        {
            do {
                    gtk_tree_model_get(GTK_TREE_MODEL(shell_store), &shell_iter, 0, &shell, -1);
                    if( shell )
                    {
                        if( ! strcmp(user_item, shell) )
                        {
                            gtk_combo_box_set_active_iter(GTK_COMBO_BOX(widgets->user_set_combo[0]), &shell_iter);
                            break;
                        }
                    }
               }    while(gtk_tree_model_iter_next(GTK_TREE_MODEL(shell_store), &shell_iter));
	}
    }
    g_free(user_item);
    g_free(username);

    gtk_widget_show_all(widgets->main_window);
}
