/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "commands.h"
#include "activate_button_clicked.h"
#include "apply_client_settings.h"

extern gchar *selected_connection;

extern int activated;



void activate_button_clicked(struct w *widgets)
{
    gchar *info, *path;

    if( activated )
      return;

    /* See if we have required things such as certs */
    path = g_strdup_printf("%s/client/%s/certs/cert.pem", OPENVPN_SYSCONF_DIR, selected_connection);
    if( ! file_exists(path) )
    {
	info = g_strdup_printf(_("Import server certificates in the client settings first.\n"));
	show_info(info);
	g_free(info);
	g_free(path);
	return;
    }
    g_free(path);

    /* Apply the client settings. Writes client conf and sysinit script */
    apply_client_settings(widgets);

    /* Start the gadmin-openvpn-client runlevel script and
       make it start at boot if specified. */
    init_start(widgets);
}
